<?php
namespace Espo\Custom\Hooks\Lead;

use Espo\ORM\Entity;
use Espo\Core\Mail\EmailSender;
use Espo\Core\Mail\EmailFactory;
use Espo\Core\Mail\SmtpParams;

class TestHook
{    
    // An optional parameter, defines in which order hooks will be processed.
    // Lesser value means sooner.
    public static int $order = 5; 

    public function __construct(
        private EmailSender $emailSender,
        private EmailFactory $emailFactory
    ) {}

    /**
     * @param array<string, mixed> $options
     */
    public function beforeSave(Entity $entity, array $options): void
    {
        if ($entity->isNew() && !$entity->get('accountName')) { 

            $entity->set('accountName', 'Sem aconta');
            $this->sendEmail();
        }
    }
    public function sendEmail(): void
    {
        $email = $this->emailFactory->create();        
        $email->setSubject('Atualização na ação XXX');
        $email->setBody('Teve uma atualização X na ação XXX. O status foi atualizado para ZZZ.');
        $email->addToAddress('leonardo@softmanutencoes.com.br');
        $email->setIsPlain(); // Html is by default
        $this->emailSender->send($email);
    }
}