<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;

class Alocacao extends Base
{
    public function actionConfirmar($params, $data, $request)
    {
        $log = $GLOBALS['log'];
        $log->info("actionConfirmar - Alocacao");

        $entityManager = $this->getContainer()->get('entityManager');

        //Criar uma movimentação retirando (debito) o dinheiro da CC selecionada e alocando no cValorAlocado da Ação
        //[Ação]         Valor alocado (cValorAlocado)
        //[Ação]		   Alocação necessária (cInvestimentoNecessario)
        //[C.C] 		   Origem do investimento (softContaCorrente)
        //[Movimentação]  Valor para investir (cSoftValor)
        
        $origem = $data->origemInvestimento ?? null;
        $valor = $data->valorInvestir ?? null;
        $saldo = $data->saldoFinal ?? null;
        $idAcao = $data->idAcao ?? null;
        $contaCorrenteId = $data->contaCorrenteId ?? null;        
        $user = $this->getUser();
        $userId = $user->getId();
        
        if (!$idAcao || !$contaCorrenteId || !$valor) {
            throw new BadRequest("Parâmetros inválidos para criar movimentação.");
        }

        
        //Carregar as entidades Acao e CC
        $acao = $entityManager->getEntity('Campaign', $idAcao);
        $contaCorrente = $entityManager->getEntity('CSoftContaCorrente', $contaCorrenteId);
        
        if (!$contaCorrente) {
            throw new BadRequest("Conta Corrente não encontrada.");
        }    
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }        
        //Criar uma movimentacao
        $mov = $entityManager->getEntity('CMovimentacao');
        $mov->set('name', 'Alocação automática');
        $mov->set('softContaCorrenteId', $contaCorrenteId);
        $mov->set('campaignId', $idAcao);
        $mov->set('cSoftValor', (float)$valor);
        $mov->set('createdById', $userId);
        $mov->set('cSoftTipo', 'Débito');
        $mov->set('cSoftTipoVerba', $origem);
        
        $entityManager->saveEntity($mov);

        // Atualiza valores alocados da Acao
        $valorAtual = (float)$acao->get('cValorAlocado');      
        $alocacaoNecessaria = (float)$acao->get('cInvestimentoNecessario');   
        $valorAcao = (float)$acao->get('budget');        

        $valorAlocado = $valorAtual + (float)$valor;
        $alocacaoNecessariaFinal = $valorAcao - $valorAlocado;

        $acao->set('cValorAlocado', $valorAlocado);
        $acao->set('cInvestimentoNecessario', $alocacaoNecessariaFinal);

        $entityManager->saveEntity($acao);


        return [
            'success' => true,
            'mensagem' => 'Movimentação registrada com sucesso',
        ];
    }
}
