define('custom:views/lead/detail', ['views/detail'], function (Dep) {
    return Dep.extend({
        setup: function () {
            Dep.prototype.setup.call(this);
            this.controlConvertButton();
            
            this.listenTo(this.model, 'change:status', () => {
                this.controlConvertButton();
            });
        },
        
        controlConvertButton: function () {
            const shouldShowConvert = this.shouldShowConvertButton();
            
            if (shouldShowConvert) {
                this.showHeaderActionItem('convert');
            } else {
                this.hideHeaderActionItem('convert');
            }
        },
        
        shouldShowConvertButton: function () {
            const status = this.model.get('status');
            return status === 'converted';
        },
        
        afterRender: function () {
            Dep.prototype.afterRender.call(this);
            this.controlConvertButton();
        }
    });
});​