define('custom:views/conta-corrente/record/detail', [
  'views/record/detail'
], function (Dep) {

  return Dep.extend({
    setup() {
      Dep.prototype.setup.call(this);
      console.log("ENTREI CREATE CC");

      // Handler separado para poder remover depois
      this.__ccRefreshHandler = (ev) => {
        if (!ev || !ev.detail) return;
        if (ev.detail.id !== this.model.id) return;

        this.model.fetch().then(() => {
          if (this.highlightField) this.highlightField('saldo');
          this.render();
        });
      };

      window.addEventListener('cc:refreshSaldo', this.__ccRefreshHandler, false);

      // Limpeza quando a view for desmontada
      this.once('remove', () => {
        window.removeEventListener('cc:refreshSaldo', this.__ccRefreshHandler, false);
      });
    }
  });
});
