define('custom:views/campaign/modals/aviso', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
            
            const textFieldOrigem = 'A verba será removida diretamente da conta corrente de ' + this.options.data.origemInvestimento + ', confirmar?';
            const textFieldValorInvestir = 'O valor que será investido:R$ ' + this.options.data.valorInvestir;
            const textFieldSaldoFinal = 'Saldo final da conta corrente: R$ ' + this.options.data.saldoFinal;

            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];            
            this.headerText = 'Aviso da alocação de investimento';

            this.formModel = new Model();

            // Define os campos do formulário
            this.formModel.setDefs({
            });

            // Inicializa com o valor sugerido (opcional, pode vir da primeira modal)
            this.formModel.set({                
            });

            // Passa os dados da primeira modal para o modelo
            //this.formModel.set(this.options.data || {});

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'origemInvestimento', readOnly: true, label:  textFieldOrigem}],                            
                            [{ name: 'valorInvestir', readOnly: true, label:  textFieldValorInvestir}],                            
                            [{ name: 'saldoFinal', readOnly: true, label:  textFieldSaldoFinal}],                            
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {
            const recordView = this.getView('record');
            const isValid = recordView.processFetch();

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }else if(isValid.valorAlocar <= 0){
                Espo.Ui.error('O valor para investir precisa ser maior do que zero.');
                return;
            }


            //Criar uma movimentação retirando (debito) o dinheiro da CC selecionada e alocando no cValorAlocado da Ação
            //[Ação]         Valor alocado (cValorAlocado)
            //[Ação]		   Alocação necessária (cInvestimentoNecessario)
            //[Ação]		   Valor alocado (sum(cSoftValor))
            //[C.C] 		   Origem do investimento (softContaCorrente)
            //[Movimentação]  Valor para investir (cSoftValor)
            try {
                const response = await Espo.Ajax.postRequest('Alocacao/action/confirmar', {
                    origemInvestimento: this.options.data.origemInvestimento,
                    valorInvestir: this.options.data.valorInvestir,
                    saldoFinal: this.options.data.saldoFinal,
                    idAcao: this.options.data.idAcao,
                    contaCorrenteId: this.options.data.contaCorrenteId
                });

                if (response.success) {
                    Espo.Ui.success(response.mensagem);
                    this.trigger('done', response);
                    this.close();
                } else {
                    Espo.Ui.error('Erro ao confirmar a alocação');
                }
            } catch (e) {
                Espo.Ui.error('Falha na comunicação com o servidor');
                console.error(e);
            }                 
/*
            Espo.Ui.success('Alocação confirmada com sucesso');
            

            //TODO: tirar isso
            let response = 'voltei';

            this.trigger('done', response); // Propaga o evento para a view pai
            this.close();
*/
        }
    }
});