-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: localhost    Database: espo_leo
-- ------------------------------------------------------
-- Server version	8.0.42-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `account`
--

DROP TABLE IF EXISTS `account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(249) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `industry` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sic_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address_street` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address_city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address_state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address_country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_address_postal_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address_street` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address_city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address_state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address_country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address_postal_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_number` bigint DEFAULT NULL,
  `c_c_soft_rede_i_d` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C_C_SOFT_REDE_I_D` (`c_c_soft_rede_i_d`),
  UNIQUE KEY `UNIQ_CREATED_AT_ID` (`created_at`,`id`),
  KEY `IDX_CREATED_AT` (`created_at`,`deleted`),
  KEY `IDX_NAME` (`name`,`deleted`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account`
--

LOCK TABLES `account` WRITE;
/*!40000 ALTER TABLE `account` DISABLE KEYS */;
INSERT INTO `account` VALUES ('689d1ca1c69e778e3','PONTOCOR COM DE TINTAS (REDE)',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-08-13 23:15:45','2025-08-16 19:08:15','2025-08-16 19:08:15',NULL,'687bf5ab74919cb49','687bf5ab74919cb49',NULL,2,1),('68dbfdc48863525c1','Gerente de Marketing',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-30 15:56:52','2025-09-30 15:56:52','2025-09-30 15:56:52',NULL,'687bf5ab74919cb49',NULL,'687bfc5c494e48ba9',1,2),('68dd85dd48f9365d0','SOFT AUTOMACAO (REDE)',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-10-01 19:49:49','2025-10-01 19:49:55','2025-10-01 19:49:55',NULL,'687bf5ab74919cb49','687bf5ab74919cb49',NULL,2,3);
/*!40000 ALTER TABLE `account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_contact`
--

DROP TABLE IF EXISTS `account_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_contact` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_inactive` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ACCOUNT_ID_CONTACT_ID` (`account_id`,`contact_id`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_contact`
--

LOCK TABLES `account_contact` WRITE;
/*!40000 ALTER TABLE `account_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_document`
--

DROP TABLE IF EXISTS `account_document`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_document` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ACCOUNT_ID_DOCUMENT_ID` (`account_id`,`document_id`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_DOCUMENT_ID` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_document`
--

LOCK TABLES `account_document` WRITE;
/*!40000 ALTER TABLE `account_document` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_document` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_portal_user`
--

DROP TABLE IF EXISTS `account_portal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_portal_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_USER_ID_ACCOUNT_ID` (`user_id`,`account_id`),
  KEY `IDX_USER_ID` (`user_id`),
  KEY `IDX_ACCOUNT_ID` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_portal_user`
--

LOCK TABLES `account_portal_user` WRITE;
/*!40000 ALTER TABLE `account_portal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_portal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_target_list`
--

DROP TABLE IF EXISTS `account_target_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_target_list` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_list_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opted_out` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ACCOUNT_ID_TARGET_LIST_ID` (`account_id`,`target_list_id`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_TARGET_LIST_ID` (`target_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_target_list`
--

LOCK TABLES `account_target_list` WRITE;
/*!40000 ALTER TABLE `account_target_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_target_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `action_history_record`
--

DROP TABLE IF EXISTS `action_history_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `action_history_record` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `number` bigint unsigned NOT NULL AUTO_INCREMENT,
  `target_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `ip_address` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_token_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_log_record_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NUMBER` (`number`),
  KEY `IDX_TARGET` (`target_type`,`target_id`),
  KEY `IDX_USER_ID` (`user_id`),
  KEY `IDX_AUTH_TOKEN_ID` (`auth_token_id`),
  KEY `IDX_AUTH_LOG_RECORD_ID` (`auth_log_record_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1564 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `action_history_record`
--

LOCK TABLES `action_history_record` WRITE;
/*!40000 ALTER TABLE `action_history_record` DISABLE KEYS */;
INSERT INTO `action_history_record` VALUES ('695a93afb8d797c0c',0,1552,'User',NULL,'read','2026-01-04 16:22:07','191.219.211.31','687bf5ab74919cb49','687bf5ab74919cb49','695a93906659c1329','695a93907dfc35d87'),('695a93c9042480053',0,1553,'User',NULL,'read','2026-01-04 16:22:33','191.219.211.31','687bf5ab74919cb49','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a93db7b8fa838d',0,1554,'Campaign',NULL,'create','2026-01-04 16:22:51','191.219.211.31','695a93d9b69392fee','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a93de284632606',0,1555,'Campaign',NULL,'read','2026-01-04 16:22:54','191.219.211.31','695a93d9b69392fee','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a93e9cac8323d5',0,1556,'Campaign',NULL,'read','2026-01-04 16:23:05','191.219.211.31','695a93d9b69392fee','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a95ffdaa8f24f6',0,1557,'Campaign',NULL,'read','2026-01-04 16:31:59','191.219.211.31','695a93d9b69392fee','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a9604a7b616930',0,1558,'Campaign',NULL,'read','2026-01-04 16:32:04','191.219.211.31','68803d9e8b9b09625','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a9610395f81e53',0,1559,'Campaign',NULL,'create','2026-01-04 16:32:16','191.219.211.31','695a960e997e58e76','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a9612642fd6a00',0,1560,'Campaign',NULL,'read','2026-01-04 16:32:18','191.219.211.31','695a960e997e58e76','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a96490a00c9655',0,1561,'CSoftContaCorrente',NULL,'read','2026-01-04 16:33:13','191.219.211.31','68dd860735ad2846e','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a96506bca972a7',0,1562,'Account',NULL,'read','2026-01-04 16:33:20','191.219.211.31','68dd85dd48f9365d0','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0'),('695a965a6bd71db29',0,1563,'Contact',NULL,'read','2026-01-04 16:33:30','191.219.211.31','68a3cd8a3b98c8213','687bf5ab74919cb49','695a93c82d3cbdc89','695a93c848b2e62d0');
/*!40000 ALTER TABLE `action_history_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `address_country`
--

DROP TABLE IF EXISTS `address_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `address_country` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_preferred` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NAME` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address_country`
--

LOCK TABLES `address_country` WRITE;
/*!40000 ALTER TABLE `address_country` DISABLE KEYS */;
/*!40000 ALTER TABLE `address_country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_log_record`
--

DROP TABLE IF EXISTS `app_log_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_log_record` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `number` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `message` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `level` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` int DEFAULT NULL,
  `exception_class` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line` int DEFAULT NULL,
  `request_method` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_resource_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NUMBER` (`number`),
  KEY `IDX_LEVEL` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_log_record`
--

LOCK TABLES `app_log_record` WRITE;
/*!40000 ALTER TABLE `app_log_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_log_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_secret`
--

DROP TABLE IF EXISTS `app_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_secret` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `delete_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NAME_DELETE_ID` (`name`,`delete_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_secret`
--

LOCK TABLES `app_secret` WRITE;
/*!40000 ALTER TABLE `app_secret` DISABLE KEYS */;
INSERT INTO `app_secret` VALUES ('68802a0b9bbaefa8d','TestRequest',0,'xCWxuB2mMCDRuStTXuwLloqFgv1FBzfCv6CXLPqILNY=',NULL,'2025-07-23 00:17:15','2025-07-23 00:17:15','0','687bf5ab74919cb49',NULL);
/*!40000 ALTER TABLE `app_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `array_value`
--

DROP TABLE IF EXISTS `array_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `array_value` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `value` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ENTITY_TYPE_VALUE` (`entity_type`,`value`),
  KEY `IDX_ENTITY_VALUE` (`entity_type`,`entity_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `array_value`
--

LOCK TABLES `array_value` WRITE;
/*!40000 ALTER TABLE `array_value` DISABLE KEYS */;
INSERT INTO `array_value` VALUES ('687bfc2d73ffcc049',0,'INBOX','monitoredFolders','687bfc2d3ac6cee8b','InboundEmail');
/*!40000 ALTER TABLE `array_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment`
--

DROP TABLE IF EXISTS `attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` bigint DEFAULT NULL,
  `field` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_being_uploaded` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `role` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `storage` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `storage_file_path` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_PARENT` (`parent_type`,`parent_id`),
  KEY `IDX_RELATED` (`related_id`,`related_type`),
  KEY `IDX_SOURCE` (`source_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment`
--

LOCK TABLES `attachment` WRITE;
/*!40000 ALTER TABLE `attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_log_record`
--

DROP TABLE IF EXISTS `auth_log_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_log_record` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `is_denied` tinyint(1) NOT NULL DEFAULT '0',
  `denial_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_time` double DEFAULT NULL,
  `request_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_method` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authentication_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `portal_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_token_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_IP_ADDRESS` (`ip_address`),
  KEY `IDX_IP_ADDRESS_REQUEST_TIME` (`ip_address`,`request_time`),
  KEY `IDX_REQUEST_TIME` (`request_time`),
  KEY `IDX_PORTAL_ID` (`portal_id`),
  KEY `IDX_USER_ID` (`user_id`),
  KEY `IDX_AUTH_TOKEN_ID` (`auth_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auth_log_record`
--

LOCK TABLES `auth_log_record` WRITE;
/*!40000 ALTER TABLE `auth_log_record` DISABLE KEYS */;
INSERT INTO `auth_log_record` VALUES ('6915362148e89c1f9',0,'admin','177.92.53.130','2025-11-13 01:36:33',1,'CREDENTIALS',1762997787.3016,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('6915362a1236f7c48',0,'admin','177.92.53.130','2025-11-13 01:36:42',0,NULL,1762997800.9568,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,'687bf5ab74919cb49','69153629ed84a7a42'),('69264c796a4a286dc',0,'admin','177.92.54.181','2025-11-26 00:40:25',1,'CREDENTIALS',1764117622.3362,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('69264c7c4b047a2cf',0,'admin','177.92.54.181','2025-11-26 00:40:28',0,NULL,1764117627.32,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,'687bf5ab74919cb49','69264c7c15f459eac'),('695a90ba60b9bdf2c',0,'admin','191.219.211.31','2026-01-04 16:09:30',1,'CREDENTIALS',1767542969.9867,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90c38ea77e412',0,'admin','191.219.211.31','2026-01-04 16:09:39',1,'CREDENTIALS',1767542979.4445,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90c72fed490a2',0,'admin','191.219.211.31','2026-01-04 16:09:43',1,'CREDENTIALS',1767542983.0682,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90cd60671bf6b',0,'admin','191.219.211.31','2026-01-04 16:09:49',1,'CREDENTIALS',1767542989.1361,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90cf0874c1bec',0,'admin','191.219.211.31','2026-01-04 16:09:51',1,'CREDENTIALS',1767542990.8237,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90d3819c690cc',0,'admin','191.219.211.31','2026-01-04 16:09:55',1,'CREDENTIALS',1767542995.2916,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90d64f7eebcf7',0,'admin','191.219.211.31','2026-01-04 16:09:58',1,'CREDENTIALS',1767542997.8116,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90e8d96976820',0,'admin','191.219.211.31','2026-01-04 16:10:16',1,'CREDENTIALS',1767543016.591,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a90fa704b702d8',0,'admin','191.219.211.31','2026-01-04 16:10:34',1,'CREDENTIALS',1767543033.0837,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,NULL,NULL),('695a937de5f4c0bef',0,'admin','191.219.211.31','2026-01-04 16:21:17',0,NULL,1767543676.8977,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,'687bf5ab74919cb49','695a937d9cdb910eb'),('695a93907dfc35d87',0,'admin','191.219.211.31','2026-01-04 16:21:36',0,NULL,1767543696.2469,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,'687bf5ab74919cb49','695a93906659c1329'),('695a93c848b2e62d0',0,'admin','191.219.211.31','2026-01-04 16:22:32',0,NULL,1767543752.1183,'http://softpinhais.ddns.net/crm_leo/api/v1/App/user','GET','Espo',NULL,'687bf5ab74919cb49','695a93c82d3cbdc89');
/*!40000 ALTER TABLE `auth_log_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_token`
--

DROP TABLE IF EXISTS `auth_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_token` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `token` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `secret` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_access` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `portal_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_TOKEN` (`token`,`deleted`),
  KEY `IDX_HASH` (`hash`),
  KEY `IDX_USER_ID` (`user_id`),
  KEY `IDX_PORTAL_ID` (`portal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auth_token`
--

LOCK TABLES `auth_token` WRITE;
/*!40000 ALTER TABLE `auth_token` DISABLE KEYS */;
INSERT INTO `auth_token` VALUES ('695a937d9cdb910eb',0,'c12abf452e087b5378154563a58d4019','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','b81dd34fa44a1fa84ccc91834c3b0aa0','191.219.211.31',1,'2026-01-04 16:21:24','2026-01-04 16:21:17','2026-01-04 16:21:24','687bf5ab74919cb49',NULL),('695a93906659c1329',0,'ab23bcf086e51feb844b9ebf18339bee','$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi','da257946db8e11cf5995631887983246','191.219.211.31',1,'2026-01-04 16:22:25','2026-01-04 16:21:36','2026-01-04 16:22:25','687bf5ab74919cb49',NULL),('695a93c82d3cbdc89',0,'ad3bcb121493f67a0e2eeefe55a3b893','$2y$10$2WI9aVbuTVG/PoB8fKsvQuCnryW2VZy..aDe08a9XRZaRlT10sHZ6','e780295f2f8aedb86599895c6dbbdd0b','191.219.211.31',1,'2026-01-04 16:37:42','2026-01-04 16:22:32','2026-01-04 16:37:42','687bf5ab74919cb49',NULL);
/*!40000 ALTER TABLE `auth_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authentication_provider`
--

DROP TABLE IF EXISTS `authentication_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authentication_provider` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_client_secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_authorization_endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_user_info_endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_token_endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_jwks_endpoint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_jwt_signature_algorithm_list` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `oidc_scopes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `oidc_create_user` tinyint(1) NOT NULL DEFAULT '0',
  `oidc_username_claim` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'sub',
  `oidc_sync` tinyint(1) NOT NULL DEFAULT '0',
  `oidc_logout_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oidc_authorization_prompt` varchar(14) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authentication_provider`
--

LOCK TABLES `authentication_provider` WRITE;
/*!40000 ALTER TABLE `authentication_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `authentication_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autofollow`
--

DROP TABLE IF EXISTS `autofollow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `autofollow` (
  `id` int NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) DEFAULT '0',
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ENTITY_TYPE` (`entity_type`),
  KEY `IDX_USER` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autofollow`
--

LOCK TABLES `autofollow` WRITE;
/*!40000 ALTER TABLE `autofollow` DISABLE KEYS */;
/*!40000 ALTER TABLE `autofollow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `c_movimentacao`
--

DROP TABLE IF EXISTS `c_movimentacao`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `c_movimentacao` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `teste` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_movimentacao` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_soft_tipo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Débito',
  `c_soft_tipo_verba` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Acordo objetivo',
  `c_soft_valor` decimal(13,4) DEFAULT NULL,
  `c_soft_valor_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `soft_conta_corrente_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CREATED_AT_ID` (`created_at`,`id`),
  KEY `IDX_NAME` (`name`,`deleted`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_CREATED_AT` (`created_at`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_SOFT_CONTA_CORRENTE_ID` (`soft_conta_corrente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `c_movimentacao`
--

LOCK TABLES `c_movimentacao` WRITE;
/*!40000 ALTER TABLE `c_movimentacao` DISABLE KEYS */;
INSERT INTO `c_movimentacao` VALUES ('689bdb9a4d5cf906f','MV 1234',0,NULL,'2025-08-13 00:26:02','2025-08-13 00:26:02','2025-08-13 00:26:02','687bf5ab74919cb49',NULL,NULL,NULL,'00001','Débito','Verba Acordo objetivo',NULL,NULL,NULL,NULL),('68a0c8dbc778f2f5b','MV-123213',0,NULL,'2025-08-16 18:07:23','2025-08-16 18:07:23','2025-08-16 18:07:24','687bf5ab74919cb49',NULL,NULL,NULL,'00003','Débito','Verba Acordo de Marketing',1500.0000,'BRL','6880419d8378781b4',NULL),('68a0f604e70224f74',NULL,0,NULL,'2025-08-16 21:20:04','2025-08-16 21:20:04','2025-08-16 21:20:05','687bf5ab74919cb49',NULL,NULL,NULL,'00025','Crédito','Verba Acordo objetivo',6.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a0f7d798f7ce0eb',NULL,0,NULL,'2025-08-16 21:27:51','2025-08-16 21:27:51','2025-08-16 21:27:51','687bf5ab74919cb49',NULL,NULL,NULL,'00027','Crédito','Verba Acordo objetivo',1146.4000,'BRL',NULL,'689bd76702e7a0be2'),('68a0f7e9c95bb6def',NULL,0,NULL,'2025-08-16 21:28:09','2025-08-16 21:28:09','2025-08-16 21:28:09','687bf5ab74919cb49',NULL,NULL,NULL,'00028','Débito','Verba Acordo objetivo',1.0000,'BRL',NULL,'689bd76702e7a0be2'),('68a0f7fbdf410e695',NULL,0,NULL,'2025-08-16 21:28:27','2025-08-16 21:28:27','2025-08-16 21:28:28','687bf5ab74919cb49',NULL,NULL,NULL,'00029','Crédito','Verba Acordo objetivo',2.0000,'BRL',NULL,'689bd76702e7a0be2'),('68a0fe9056685253f',NULL,0,NULL,'2025-08-16 21:56:32','2025-08-16 21:56:32','2025-08-16 21:56:32','687bf5ab74919cb49',NULL,NULL,NULL,'00030','Débito','Verba Acordo objetivo',1146.4000,'BRL',NULL,'68a0d7576edc3f029'),('68a3a6804e34f1127',NULL,0,NULL,'2025-08-18 22:17:36','2025-08-18 22:17:36','2025-08-18 22:17:36','687bf5ab74919cb49',NULL,NULL,NULL,'00031','Crédito','Verba Acordo objetivo',1149.4000,'BRL',NULL,'68a0d7576edc3f029'),('68a3a9372e68a47bf',NULL,0,NULL,'2025-08-18 22:29:11','2025-08-18 22:29:11','2025-08-18 22:29:11','687bf5ab74919cb49',NULL,NULL,NULL,'00032','Crédito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3a9486c1ead84d',NULL,0,NULL,'2025-08-18 22:29:28','2025-08-18 22:29:28','2025-08-18 22:29:28','687bf5ab74919cb49',NULL,NULL,NULL,'00033','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3aa786dec198f4',NULL,0,NULL,'2025-08-18 22:34:32','2025-08-18 22:34:32','2025-08-18 22:34:32','687bf5ab74919cb49',NULL,NULL,NULL,'00034','Débito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3aacc257543d5f',NULL,0,NULL,'2025-08-18 22:35:56','2025-08-18 22:35:56','2025-08-18 22:35:56','687bf5ab74919cb49',NULL,NULL,NULL,'00035','Crédito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ad1e3f8b6f95d',NULL,0,NULL,'2025-08-18 22:45:50','2025-08-18 22:45:50','2025-08-18 22:45:50','687bf5ab74919cb49',NULL,NULL,NULL,'00036','Débito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ad32a27921601',NULL,0,NULL,'2025-08-18 22:46:10','2025-08-18 22:46:10','2025-08-18 22:46:10','687bf5ab74919cb49',NULL,NULL,NULL,'00037','Débito','Verba Acordo objetivo',10.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ad3e1f784d100',NULL,0,NULL,'2025-08-18 22:46:22','2025-08-18 22:46:22','2025-08-18 22:46:22','687bf5ab74919cb49',NULL,NULL,NULL,'00038','Crédito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ae1a758dc448b',NULL,0,NULL,'2025-08-18 22:50:02','2025-08-18 22:50:02','2025-08-18 22:50:02','687bf5ab74919cb49',NULL,NULL,NULL,'00039','Crédito','Verba Acordo objetivo',12.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ae9b468561a77',NULL,0,NULL,'2025-08-18 22:52:11','2025-08-18 22:52:11','2025-08-18 22:52:11','687bf5ab74919cb49',NULL,NULL,NULL,'00040','Débito','Verba Acordo objetivo',12.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3aeb887972f308',NULL,0,NULL,'2025-08-18 22:52:40','2025-08-18 22:52:40','2025-08-18 22:52:41','687bf5ab74919cb49',NULL,NULL,NULL,'00041','Débito','Verba Acordo objetivo',5.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3b2b2a9b23145c',NULL,0,NULL,'2025-08-18 23:09:38','2025-08-18 23:09:38','2025-08-18 23:09:38','687bf5ab74919cb49',NULL,NULL,NULL,'00042','Crédito','Verba Acordo objetivo',15.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3b2ede0736d4ed',NULL,0,NULL,'2025-08-18 23:10:37','2025-08-18 23:10:37','2025-08-18 23:10:38','687bf5ab74919cb49',NULL,NULL,NULL,'00043','Débito','Verba Acordo objetivo',11.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3b30ddb41b549c',NULL,0,NULL,'2025-08-18 23:11:09','2025-08-18 23:11:09','2025-08-18 23:11:10','687bf5ab74919cb49',NULL,NULL,NULL,'00044','Débito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3c5fc043119cdb',NULL,0,NULL,'2025-08-19 00:31:56','2025-08-19 00:31:56','2025-08-19 00:31:56','687bf5ab74919cb49',NULL,NULL,NULL,'00045','Débito','Verba Acordo objetivo',1.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3c943afd57653b',NULL,0,NULL,'2025-08-19 00:45:55','2025-08-19 00:45:55','2025-08-19 00:45:55','687bf5ab74919cb49',NULL,NULL,NULL,'00046','Débito','Verba Acordo objetivo',12.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3c94f0faf42022',NULL,0,NULL,'2025-08-19 00:46:07','2025-08-19 00:46:07','2025-08-19 00:46:07','687bf5ab74919cb49',NULL,NULL,NULL,'00047','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ca7045c5d1109',NULL,0,NULL,'2025-08-19 00:50:56','2025-08-19 00:50:56','2025-08-19 00:50:56','687bf5ab74919cb49',NULL,NULL,NULL,'00048','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ca8cc7a129e1a',NULL,0,NULL,'2025-08-19 00:51:24','2025-08-19 00:51:24','2025-08-19 00:51:25','687bf5ab74919cb49',NULL,NULL,NULL,'00049','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3cab06733b3b4b',NULL,0,NULL,'2025-08-19 00:52:00','2025-08-19 00:52:00','2025-08-19 00:52:00','687bf5ab74919cb49',NULL,NULL,NULL,'00050','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3cba3a9634eff9',NULL,0,NULL,'2025-08-19 00:56:03','2025-08-19 00:56:03','2025-08-19 00:56:04','687bf5ab74919cb49',NULL,NULL,NULL,'00051','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ccebc713d5ace',NULL,0,NULL,'2025-08-19 01:01:31','2025-08-19 01:01:31','2025-08-19 01:01:31','687bf5ab74919cb49',NULL,NULL,NULL,'00052','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ce4406c2d5793',NULL,0,NULL,'2025-08-19 01:07:16','2025-08-19 01:07:16','2025-08-19 01:07:16','687bf5ab74919cb49',NULL,NULL,NULL,'00053','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3ceb8bcca2f3c8',NULL,0,NULL,'2025-08-19 01:09:12','2025-08-19 01:09:12','2025-08-19 01:09:12','687bf5ab74919cb49',NULL,NULL,NULL,'00054','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3cf096c084c9aa',NULL,0,NULL,'2025-08-19 01:10:33','2025-08-19 01:10:33','2025-08-19 01:10:33','687bf5ab74919cb49',NULL,NULL,NULL,'00055','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3d3bf0935d906d',NULL,0,NULL,'2025-08-19 01:30:39','2025-08-19 01:30:39','2025-08-19 01:30:39','687bf5ab74919cb49',NULL,NULL,NULL,'00056','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3d3fbe4e30c312',NULL,0,NULL,'2025-08-19 01:31:39','2025-08-19 01:31:39','2025-08-19 01:31:40','687bf5ab74919cb49',NULL,NULL,NULL,'00057','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a3d40d4028bffdd',NULL,0,NULL,'2025-08-19 01:31:57','2025-08-19 01:31:57','2025-08-19 01:31:57','687bf5ab74919cb49',NULL,NULL,NULL,'00058','Débito','Verba Acordo objetivo',2.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a70b61669073566',NULL,0,NULL,'2025-08-21 12:04:49','2025-08-21 12:04:49','2025-08-21 12:04:49','687bf5ab74919cb49',NULL,NULL,NULL,'00060','Crédito','Verba Acordo objetivo',200.0000,'BRL',NULL,'68a0d7576edc3f029'),('68a70b79d2ea203db',NULL,0,NULL,'2025-08-21 12:05:13','2025-08-21 12:05:13','2025-08-21 12:05:14','687bf5ab74919cb49',NULL,NULL,NULL,'00061','Crédito','Verba Acordo objetivo',50.0000,'BRL',NULL,'68a0d7576edc3f029'),('68be08a675f1a9a74',NULL,0,NULL,'2025-09-07 22:35:18','2025-09-07 22:35:18','2025-09-07 22:35:19','687bf5ab74919cb49',NULL,NULL,NULL,'00062','Crédito','Verba Acordo objetivo',200.0000,'BRL',NULL,'68a0d7576edc3f029'),('68bf05d3409d0edad',NULL,0,NULL,'2025-09-08 16:35:31','2025-09-08 16:35:31','2025-09-08 16:35:31','687bf5ab74919cb49',NULL,NULL,NULL,'00064','Crédito','Verba Acordo objetivo',500.0000,'BRL',NULL,'68a0d7576edc3f029'),('68bf103e477fe0a53',NULL,0,NULL,'2025-09-08 17:19:58','2025-09-08 17:19:58','2025-09-08 17:19:58','687bf5ab74919cb49',NULL,NULL,NULL,'00065','Crédito','Verba Acordo objetivo',516.3700,'BRL',NULL,'68a0d7576edc3f029'),('68bf1538ee3396329',NULL,0,NULL,'2025-09-08 17:41:12','2025-09-08 17:41:12','2025-09-08 17:41:13','687bf5ab74919cb49',NULL,NULL,NULL,'00066','Crédito','Verba Acordo objetivo',500.0000,'BRL',NULL,'68a0d7576edc3f029'),('68bf1ab25b5358339',NULL,0,NULL,'2025-09-08 18:04:34','2025-09-08 18:04:34','2025-09-08 18:04:34','687bf5ab74919cb49',NULL,NULL,NULL,'00067','Crédito','Verba Acordo objetivo',523.0000,'BRL',NULL,'68a0d7576edc3f029'),('68c16cdfac182293c',NULL,0,NULL,'2025-09-10 12:19:43','2025-09-10 12:19:43','2025-09-10 12:19:43','687bf5ab74919cb49',NULL,NULL,NULL,'00068','Débito','Verba Acordo objetivo',100.0000,'BRL',NULL,'68a0d7576edc3f029'),('68c20313c32d87011',NULL,0,NULL,'2025-09-10 23:00:35','2025-09-10 23:00:35','2025-09-10 23:00:35','687bf5ab74919cb49',NULL,NULL,NULL,'00071','Crédito','Verba Acordo objetivo',111.0000,'BRL',NULL,'68a0d7576edc3f029'),('68c204927c1566213',NULL,0,NULL,'2025-09-10 23:06:58','2025-09-10 23:06:58','2025-09-10 23:06:58','687bf5ab74919cb49',NULL,NULL,NULL,'00072','Débito','Verba Acordo objetivo',11111.0000,'BRL',NULL,'68a0d7576edc3f029'),('68dace4eb0507e13b',NULL,0,NULL,'2025-09-29 18:22:06','2025-09-29 18:22:06','2025-09-29 18:22:07','687bf5ab74919cb49',NULL,NULL,NULL,'00073','Crédito','Verba Acordo objetivo',1500.0000,'BRL',NULL,'68a0d7576edc3f029'),('68db2c2a2859cf04e',NULL,0,NULL,'2025-09-30 01:02:34','2025-09-30 01:02:34','2025-09-30 01:02:34','687bf5ab74919cb49',NULL,NULL,NULL,'00075','Crédito','Verba Acordo objetivo',7378.1300,'BRL',NULL,'68a0d7576edc3f029'),('68db2c4ec39789bf0',NULL,0,NULL,'2025-09-30 01:03:10','2025-09-30 01:03:10','2025-09-30 01:03:10','687bf5ab74919cb49',NULL,NULL,NULL,'00077','Crédito','Verba Acordo objetivo',15.0000,'BRL',NULL,'68db2bcd526fde33c'),('68dbfd16b2f40d25d',NULL,0,NULL,'2025-09-30 15:53:58','2025-09-30 15:53:58','2025-09-30 15:53:58','687bf5ab74919cb49',NULL,NULL,NULL,'00078','Crédito','Verba Acordo objetivo',100.0000,'BRL',NULL,'68a0d7576edc3f029'),('68dbfd2761761b211',NULL,0,NULL,'2025-09-30 15:54:15','2025-09-30 15:54:15','2025-09-30 15:54:16','687bf5ab74919cb49',NULL,NULL,NULL,'00079','Crédito','Verba Acordo objetivo',100.0000,'BRL',NULL,'68db2bcd526fde33c'),('68dbfe02ed3d53465',NULL,0,NULL,'2025-09-30 15:57:54','2025-09-30 15:57:54','2025-09-30 15:57:55','687bf5ab74919cb49',NULL,NULL,NULL,'00080','Crédito','Verba Acordo objetivo',100.0000,'BRL',NULL,'68dbfde489b15f851'),('68dbfe1f4394ac365',NULL,0,NULL,'2025-09-30 15:58:23','2025-09-30 15:58:23','2025-09-30 15:58:23','687bf5ab74919cb49',NULL,NULL,NULL,'00081','Débito','Verba Acordo objetivo',20.0000,'BRL',NULL,'68dbfde489b15f851'),('68dc009e94d056dfd',NULL,0,NULL,'2025-09-30 16:09:02','2025-09-30 16:09:02','2025-09-30 16:09:02','687bf5ab74919cb49',NULL,NULL,NULL,'00084','Crédito','Verba Acordo objetivo',6000.0000,'BRL',NULL,'689bd76702e7a0be2'),('68dd86117db690e8b',NULL,0,NULL,'2025-10-01 19:50:41','2025-10-01 19:50:41','2025-10-01 19:50:42','687bf5ab74919cb49',NULL,NULL,NULL,'00085','Crédito','Verba Acordo objetivo',100.0000,'BRL',NULL,'68dd860735ad2846e'),('68dd8625ef237ad39',NULL,0,NULL,'2025-10-01 19:51:01','2025-10-01 19:51:01','2025-10-01 19:51:02','687bf5ab74919cb49',NULL,NULL,NULL,'00086','Crédito','Verba Acordo objetivo',50.0000,'BRL',NULL,'68dd8600b49af12cf'),('68dd9acd53ead22e2',NULL,0,NULL,'2025-10-01 21:19:09','2025-10-01 21:19:09','2025-10-01 21:19:09','687bf5ab74919cb49',NULL,NULL,NULL,'00087','Débito','Verba Acordo objetivo',50.0000,'BRL',NULL,'689bd76702e7a0be2'),('68dd9ad4987db3645',NULL,0,NULL,'2025-10-01 21:19:16','2025-10-01 21:19:16','2025-10-01 21:19:16','687bf5ab74919cb49',NULL,NULL,NULL,'00088','Débito','Verba Acordo objetivo',50.0000,'BRL',NULL,'68a0d7576edc3f029'),('68dd9aea4d20ad1ca',NULL,0,NULL,'2025-10-01 21:19:38','2025-10-01 21:19:38','2025-10-01 21:19:38','687bf5ab74919cb49',NULL,NULL,NULL,'00089','Débito','Verba Acordo objetivo',20.0000,'BRL',NULL,'68dbfde489b15f851'),('68dd9d00601f28b74',NULL,0,NULL,'2025-10-01 21:28:32','2025-10-01 21:28:32','2025-10-01 21:28:32','687bf5ab74919cb49',NULL,NULL,NULL,'00090','Crédito','Verba Acordo objetivo',50.0000,'BRL',NULL,'68dbfde489b15f851'),('68dd9d15792ba251c',NULL,0,NULL,'2025-10-01 21:28:53','2025-10-01 21:28:53','2025-10-01 21:28:53','687bf5ab74919cb49',NULL,NULL,NULL,'00091','Crédito','Verba Acordo objetivo',20.0000,'BRL',NULL,'68a0d7576edc3f029'),('68dd9d23d6ee99c5f',NULL,0,NULL,'2025-10-01 21:29:07','2025-10-01 21:29:07','2025-10-01 21:29:08','687bf5ab74919cb49',NULL,NULL,NULL,'00092','Débito','Verba Acordo objetivo',20.0000,'BRL',NULL,'68dbfde489b15f851'),('68dd9d3a4653272bc',NULL,0,NULL,'2025-10-01 21:29:30','2025-10-01 21:29:30','2025-10-01 21:29:30','687bf5ab74919cb49',NULL,NULL,NULL,'00093','Crédito','Verba Acordo objetivo',100.0000,'BRL',NULL,'689bd76702e7a0be2'),('68dd9dcb5fa386c03',NULL,0,NULL,'2025-10-01 21:31:55','2025-10-01 21:31:55','2025-10-01 21:31:55','687bf5ab74919cb49',NULL,NULL,NULL,'00094','Débito','Verba Acordo objetivo',11.0000,'BRL',NULL,'68dbfde489b15f851'),('68dd9ddeab7fd1af3',NULL,0,NULL,'2025-10-01 21:32:14','2025-10-01 21:32:14','2025-10-01 21:32:15','687bf5ab74919cb49',NULL,NULL,NULL,'00095','Débito','Verba Acordo objetivo',11.0000,'BRL',NULL,'68dbfde489b15f851'),('68df222ebce316f6e',NULL,0,NULL,'2025-10-03 01:09:02','2025-10-03 01:09:02','2025-10-03 01:09:03','687bf5ab74919cb49',NULL,NULL,NULL,'00096','Crédito','Verba Acordo objetivo',50.0000,'BRL',NULL,'68a0d7576edc3f029'),('68e6f9705ca760290','Alocação automática',0,NULL,'2025-10-08 23:53:20','2025-10-08 23:53:20','2025-10-08 23:53:22','687bf5ab74919cb49',NULL,NULL,NULL,'00097','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e6fa0641e9dad30','Alocação automática',0,NULL,'2025-10-08 23:55:50','2025-10-08 23:55:50','2025-10-08 23:55:50','687bf5ab74919cb49',NULL,NULL,NULL,'00098','Débito','Acordo Objetivo',9.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e6fa5c0dbc58117','Alocação automática',0,NULL,'2025-10-08 23:57:16','2025-10-08 23:57:16','2025-10-08 23:57:16','687bf5ab74919cb49',NULL,NULL,NULL,'00099','Débito','Acordo de Marketing',50.0000,'BRL','68803d9e8b9b09625','68dd8600b49af12cf'),('68e70b47d24ff23da',NULL,0,NULL,'2025-10-09 01:09:27','2025-10-09 01:09:27','2025-10-09 01:09:27','687bf5ab74919cb49',NULL,NULL,NULL,'00101','Crédito','Acordo objetivo',10.0000,'BRL',NULL,'68dbfde489b15f851'),('68e70b57617b40e8a',NULL,0,NULL,'2025-10-09 01:09:43','2025-10-09 01:09:43','2025-10-09 01:09:43','687bf5ab74919cb49',NULL,NULL,NULL,'00102','Débito','Acordo objetivo',5.0000,'BRL',NULL,'68dbfde489b15f851'),('68e70ba738779fc34','Alocação automática',0,NULL,'2025-10-09 01:11:03','2025-10-09 01:11:03','2025-10-09 01:11:03','687bf5ab74919cb49',NULL,NULL,NULL,'00103','Débito','Gerente de Marketing',5.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e70bbfb9e52df4e','Alocação automática',0,NULL,'2025-10-09 01:11:27','2025-10-09 01:11:27','2025-10-09 01:11:27','687bf5ab74919cb49',NULL,NULL,NULL,'00104','Débito','Gerente de Marketing',15.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e70c9d8e167a165','Alocação automática',0,NULL,'2025-10-09 01:15:09','2025-10-09 01:15:09','2025-10-09 01:15:09','687bf5ab74919cb49',NULL,NULL,NULL,'00105','Débito','Gerente de Marketing',5.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e70ce9b3270b8e7','Alocação automática',0,NULL,'2025-10-09 01:16:25','2025-10-09 01:16:25','2025-10-09 01:16:25','687bf5ab74919cb49',NULL,NULL,NULL,'00106','Débito','Gerente de Marketing',5.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e70d32af5a82d1b','Alocação automática',0,NULL,'2025-10-09 01:17:38','2025-10-09 01:17:38','2025-10-09 01:17:38','687bf5ab74919cb49',NULL,NULL,NULL,'00107','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e70d45c9acdad62','Alocação automática',0,NULL,'2025-10-09 01:17:57','2025-10-09 01:17:57','2025-10-09 01:17:58','687bf5ab74919cb49',NULL,NULL,NULL,'00108','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e71502260dabbca','Alocação automática',0,NULL,'2025-10-09 01:50:58','2025-10-09 01:50:58','2025-10-09 01:50:58','687bf5ab74919cb49',NULL,NULL,NULL,'00111','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e7150e804f05e0f','Alocação automática',0,NULL,'2025-10-09 01:51:10','2025-10-09 01:51:10','2025-10-09 01:51:10','687bf5ab74919cb49',NULL,NULL,NULL,'00112','Débito','Gerente de Marketing',2.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e715537e289e05f','Alocação automática',0,NULL,'2025-10-09 01:52:19','2025-10-09 01:52:19','2025-10-09 01:52:19','687bf5ab74919cb49',NULL,NULL,NULL,'00113','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e7176dc4c7f83e1','Alocação automática',0,NULL,'2025-10-09 02:01:17','2025-10-09 02:01:17','2025-10-09 02:01:18','687bf5ab74919cb49',NULL,NULL,NULL,'00114','Débito','Gerente de Marketing',3.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e717b3e7c54ffc4','Alocação automática',0,NULL,'2025-10-09 02:02:27','2025-10-09 02:02:27','2025-10-09 02:02:28','687bf5ab74919cb49',NULL,NULL,NULL,'00115','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e7181ce987e71ef','Alocação automática',0,NULL,'2025-10-09 02:04:12','2025-10-09 02:04:12','2025-10-09 02:04:13','687bf5ab74919cb49',NULL,NULL,NULL,'00116','Débito','Gerente de Marketing',2.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e7188c7b2b8fbf5','Alocação automática',0,NULL,'2025-10-09 02:06:04','2025-10-09 02:06:04','2025-10-09 02:06:04','687bf5ab74919cb49',NULL,NULL,NULL,'00117','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e71a88a6ecd1d17','Alocação automática',0,NULL,'2025-10-09 02:14:32','2025-10-09 02:14:32','2025-10-09 02:14:32','687bf5ab74919cb49',NULL,NULL,NULL,'00118','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68e71b2ecb1c08a8c','Alocação automática',0,NULL,'2025-10-09 02:17:18','2025-10-09 02:17:18','2025-10-09 02:17:18','687bf5ab74919cb49',NULL,NULL,NULL,'00119','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e71cd34ace5856c','Alocação automática',0,NULL,'2025-10-09 02:24:19','2025-10-09 02:24:19','2025-10-09 02:24:19','687bf5ab74919cb49',NULL,NULL,NULL,'00120','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68e71d6d428cc5b41','Alocação automática',0,NULL,'2025-10-09 02:26:53','2025-10-09 02:26:53','2025-10-09 02:26:53','687bf5ab74919cb49',NULL,NULL,NULL,'00121','Débito','Gerente de Marketing',1.0000,'BRL','68803d9e8b9b09625','68dbfde489b15f851'),('68eaa3393713b9a1f','Alocação automática',0,NULL,'2025-10-11 18:34:33','2025-10-11 18:34:33','2025-10-11 18:34:33','687bf5ab74919cb49',NULL,NULL,NULL,'00122','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa41150c0d3582','Alocação automática',0,NULL,'2025-10-11 18:38:09','2025-10-11 18:38:09','2025-10-11 18:38:09','687bf5ab74919cb49',NULL,NULL,NULL,'00123','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa450bb1a6517c','Alocação automática',0,NULL,'2025-10-11 18:39:12','2025-10-11 18:39:12','2025-10-11 18:39:12','687bf5ab74919cb49',NULL,NULL,NULL,'00124','Débito','Acordo Objetivo',2.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa516c79fe9717','Alocação automática',0,NULL,'2025-10-11 18:42:30','2025-10-11 18:42:30','2025-10-11 18:42:30','687bf5ab74919cb49',NULL,NULL,NULL,'00125','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa578249f80761','Alocação automática',0,NULL,'2025-10-11 18:44:08','2025-10-11 18:44:08','2025-10-11 18:44:08','687bf5ab74919cb49',NULL,NULL,NULL,'00126','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa5e33a4602dbf','Alocação automática',0,NULL,'2025-10-11 18:45:55','2025-10-11 18:45:55','2025-10-11 18:45:55','687bf5ab74919cb49',NULL,NULL,NULL,'00127','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eaa6082498f6131','Alocação automática',0,NULL,'2025-10-11 18:46:32','2025-10-11 18:46:32','2025-10-11 18:46:32','687bf5ab74919cb49',NULL,NULL,NULL,'00128','Débito','Acordo Objetivo',1.0000,'BRL','68803d9e8b9b09625','68dd860735ad2846e'),('68eac28bcc39b3f1c',NULL,0,NULL,'2025-10-11 20:48:11','2025-10-11 20:48:11','2025-10-11 20:48:12','687bf5ab74919cb49',NULL,NULL,NULL,'00129','Crédito','Acordo objetivo',5.0000,'BRL',NULL,'68dbfde489b15f851'),('68eebba9ddd1924e7',NULL,0,NULL,'2025-10-14 21:07:53','2025-10-14 21:07:53','2025-10-14 21:07:54','687bf5ab74919cb49',NULL,NULL,NULL,'00130','Crédito','Acordo objetivo',5.0000,'BRL',NULL,'68dd8600b49af12cf'),('68eebbdb8ef20d124',NULL,0,NULL,'2025-10-14 21:08:43','2025-10-14 21:08:43','2025-10-14 21:08:43','687bf5ab74919cb49',NULL,NULL,NULL,'00131','Crédito','Acordo objetivo',3.0000,'BRL',NULL,'68dd8600b49af12cf'),('68eebc29b4b0767e2','Alocação automática',0,NULL,'2025-10-14 21:10:01','2025-10-14 21:10:01','2025-10-14 21:10:01','687bf5ab74919cb49',NULL,NULL,NULL,'00132','Débito','Acordo de Marketing',5.0000,'BRL','68803d9e8b9b09625','68dd8600b49af12cf');
/*!40000 ALTER TABLE `c_movimentacao` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `c_soft_conta_corrente`
--

DROP TABLE IF EXISTS `c_soft_conta_corrente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `c_soft_conta_corrente` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credito` double DEFAULT NULL,
  `credito_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_de_debito` double DEFAULT NULL,
  `total_de_debito_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_de_credito` double DEFAULT NULL,
  `total_de_credito_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saldo` double DEFAULT NULL,
  `saldo_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_soft_tipo_c_c` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Acordo Objetivo',
  `movimentacao_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account1_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_soft_i_d_conta_corrente` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C_SOFT_I_D_CONTA_CORRENTE` (`c_soft_i_d_conta_corrente`),
  UNIQUE KEY `UNIQ_CREATED_AT_ID` (`created_at`,`id`),
  KEY `IDX_NAME` (`name`,`deleted`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_CREATED_AT` (`created_at`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_ACCOUNT1_ID` (`account1_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `c_soft_conta_corrente`
--

LOCK TABLES `c_soft_conta_corrente` WRITE;
/*!40000 ALTER TABLE `c_soft_conta_corrente` DISABLE KEYS */;
INSERT INTO `c_soft_conta_corrente` VALUES ('689bd76702e7a0be2','A.O - PONTOCOR COM DE TINTAS (REDE)',0,NULL,'2025-08-13 00:08:07','2025-10-01 21:29:30','2025-10-01 21:29:30','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,5250,'BRL',6150,'BRL',900,'BRL','Acordo Objetivo',NULL,NULL,'689d1ca1c69e778e3',1),('68a0d7576edc3f029','A.M - PONTOCOR COM DE TINTAS (REDE)',0,NULL,'2025-08-16 19:09:11','2025-10-03 01:09:03','2025-10-03 01:09:03','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,11568.5,'BRL',11688.5,'BRL',120,'BRL','Acordo de Marketing',NULL,NULL,'689d1ca1c69e778e3',2),('68dbfde489b15f851','Gerente de Marketing',0,NULL,'2025-09-30 15:57:24','2025-10-11 20:48:12','2025-10-11 20:48:12','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,68,'BRL',115,'BRL',47,'BRL','Gerente de Marketing',NULL,NULL,'68dbfdc48863525c1',4),('68dd8600b49af12cf','A.M - SOFT AUTOMACAO (REDE)',0,NULL,'2025-10-01 19:50:24','2025-10-14 21:10:01','2025-10-14 21:10:01','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,55,'BRL',58,'BRL',3,'BRL','Acordo de Marketing',NULL,NULL,'68dd85dd48f9365d0',5),('68dd860735ad2846e','A.O - SOFT AUTOMACAO (REDE)',0,NULL,'2025-10-01 19:50:31','2025-10-11 18:46:32','2025-10-11 18:46:32','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,22,'BRL',100,'BRL',78,'BRL','Acordo Objetivo',NULL,NULL,'68dd85dd48f9365d0',6);
/*!40000 ALTER TABLE `c_soft_conta_corrente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call`
--

DROP TABLE IF EXISTS `call`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `call` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Planned',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Outbound',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DATE_START_STATUS` (`date_start`,`status`),
  KEY `IDX_DATE_START` (`date_start`,`deleted`),
  KEY `IDX_STATUS` (`status`,`deleted`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_ASSIGNED_USER_STATUS` (`assigned_user_id`,`status`),
  KEY `IDX_UID` (`uid`),
  KEY `IDX_PARENT` (`parent_id`,`parent_type`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call`
--

LOCK TABLES `call` WRITE;
/*!40000 ALTER TABLE `call` DISABLE KEYS */;
/*!40000 ALTER TABLE `call` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_contact`
--

DROP TABLE IF EXISTS `call_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `call_contact` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `call_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'None',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CALL_ID_CONTACT_ID` (`call_id`,`contact_id`),
  KEY `IDX_CALL_ID` (`call_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_contact`
--

LOCK TABLES `call_contact` WRITE;
/*!40000 ALTER TABLE `call_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_lead`
--

DROP TABLE IF EXISTS `call_lead`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `call_lead` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `call_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lead_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'None',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CALL_ID_LEAD_ID` (`call_id`,`lead_id`),
  KEY `IDX_CALL_ID` (`call_id`),
  KEY `IDX_LEAD_ID` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_lead`
--

LOCK TABLES `call_lead` WRITE;
/*!40000 ALTER TABLE `call_lead` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_lead` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `call_user`
--

DROP TABLE IF EXISTS `call_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `call_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `call_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'None',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_USER_ID_CALL_ID` (`user_id`,`call_id`),
  KEY `IDX_USER_ID` (`user_id`),
  KEY `IDX_CALL_ID` (`call_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `call_user`
--

LOCK TABLES `call_user` WRITE;
/*!40000 ALTER TABLE `call_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `call_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign`
--

DROP TABLE IF EXISTS `campaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Planning',
  `type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Email',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `budget` double DEFAULT NULL,
  `mail_merge_only_with_address` tinyint(1) NOT NULL DEFAULT '1',
  `budget_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacts_template_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `leads_template_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accounts_template_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `users_template_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `c_movimentacao_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_campaigns_movimentacao_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_c_rede_acao_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_investimento_necessario` double DEFAULT NULL,
  `c_investimento_necessario_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_valor_alocado` double DEFAULT NULL,
  `c_valor_alocado_currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `c_id_rede` int unsigned DEFAULT NULL,
  `c_id_acao` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C_ID_ACAO` (`c_id_acao`),
  KEY `IDX_CREATED_AT` (`created_at`,`deleted`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_CONTACTS_TEMPLATE_ID` (`contacts_template_id`),
  KEY `IDX_LEADS_TEMPLATE_ID` (`leads_template_id`),
  KEY `IDX_ACCOUNTS_TEMPLATE_ID` (`accounts_template_id`),
  KEY `IDX_USERS_TEMPLATE_ID` (`users_template_id`),
  KEY `IDX_C_C_REDE_ACAO_ID` (`c_c_rede_acao_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign`
--

LOCK TABLES `campaign` WRITE;
/*!40000 ALTER TABLE `campaign` DISABLE KEYS */;
INSERT INTO `campaign` VALUES ('68803d9e8b9b09625','CM - 12346',0,'Active','Email',NULL,NULL,NULL,'2025-07-23 01:40:46','2025-10-14 21:21:48',200,1,'BRL','68802a379def674ac','687bf5ab74919cb49','687bf5ab74919cb49',NULL,NULL,NULL,NULL,'2025-10-14 21:21:48','689bdb9a4d5cf906f',NULL,'68dd85dd48f9365d0',0,'BRL',200,'BRL',2,2),('68853be1d169313f8','teste',0,'Inactive','Email',NULL,NULL,NULL,'2025-07-26 20:34:41','2025-10-01 20:35:09',NULL,1,NULL,'687bf5ab74919cb49','687bf5ab74919cb49','687bfc5c494e48ba9',NULL,NULL,NULL,NULL,'2025-08-14 00:07:51',NULL,NULL,'68dd85dd48f9365d0',NULL,NULL,NULL,NULL,4,4),('695a93d9b69392fee','dasdasdsa',0,'Planning','Email',NULL,NULL,NULL,'2026-01-04 16:22:49','2026-01-04 16:22:49',NULL,1,NULL,'687bf5ab74919cb49',NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-04 16:22:49',NULL,NULL,'68dd85dd48f9365d0',NULL,NULL,NULL,NULL,NULL,5),('695a960e997e58e76','fsdfsdf',0,'Planning','Email',NULL,NULL,NULL,'2026-01-04 16:32:14','2026-01-04 16:32:14',NULL,1,NULL,'687bf5ab74919cb49',NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-04 16:32:14',NULL,NULL,'68dd85dd48f9365d0',NULL,NULL,NULL,NULL,NULL,6);
/*!40000 ALTER TABLE `campaign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_log_record`
--

DROP TABLE IF EXISTS `campaign_log_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign_log_record` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_date` datetime DEFAULT NULL,
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `string_data` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `string_additional_data` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Espo',
  `created_at` datetime DEFAULT NULL,
  `is_test` tinyint(1) NOT NULL DEFAULT '0',
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `queue_item_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ACTION_DATE` (`action_date`,`deleted`),
  KEY `IDX_ACTION` (`action`,`deleted`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_PARENT` (`parent_id`,`parent_type`),
  KEY `IDX_OBJECT` (`object_id`,`object_type`),
  KEY `IDX_QUEUE_ITEM_ID` (`queue_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_log_record`
--

LOCK TABLES `campaign_log_record` WRITE;
/*!40000 ALTER TABLE `campaign_log_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_log_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_target_list`
--

DROP TABLE IF EXISTS `campaign_target_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign_target_list` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_list_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CAMPAIGN_ID_TARGET_LIST_ID` (`campaign_id`,`target_list_id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_TARGET_LIST_ID` (`target_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_target_list`
--

LOCK TABLES `campaign_target_list` WRITE;
/*!40000 ALTER TABLE `campaign_target_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_target_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_target_list_excluding`
--

DROP TABLE IF EXISTS `campaign_target_list_excluding`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign_target_list_excluding` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_list_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CAMPAIGN_ID_TARGET_LIST_ID` (`campaign_id`,`target_list_id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_TARGET_LIST_ID` (`target_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_target_list_excluding`
--

LOCK TABLES `campaign_target_list_excluding` WRITE;
/*!40000 ALTER TABLE `campaign_target_list_excluding` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_target_list_excluding` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_tracking_url`
--

DROP TABLE IF EXISTS `campaign_tracking_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign_tracking_url` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Redirect',
  `message` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `modified_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_tracking_url`
--

LOCK TABLES `campaign_tracking_url` WRITE;
/*!40000 ALTER TABLE `campaign_tracking_url` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_tracking_url` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `case`
--

DROP TABLE IF EXISTS `case`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `case` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `number` int unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'New',
  `priority` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Normal',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_internal` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lead_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_number` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NUMBER` (`number`),
  KEY `IDX_STATUS` (`status`,`deleted`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_ASSIGNED_USER_STATUS` (`assigned_user_id`,`status`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_LEAD_ID` (`lead_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`),
  KEY `IDX_INBOUND_EMAIL_ID` (`inbound_email_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  FULLTEXT KEY `IDX_SYSTEM_FULL_TEXT_SEARCH` (`name`,`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `case`
--

LOCK TABLES `case` WRITE;
/*!40000 ALTER TABLE `case` DISABLE KEYS */;
/*!40000 ALTER TABLE `case` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `case_contact`
--

DROP TABLE IF EXISTS `case_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `case_contact` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `case_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CASE_ID_CONTACT_ID` (`case_id`,`contact_id`),
  KEY `IDX_CASE_ID` (`case_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `case_contact`
--

LOCK TABLES `case_contact` WRITE;
/*!40000 ALTER TABLE `case_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `case_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `case_knowledge_base_article`
--

DROP TABLE IF EXISTS `case_knowledge_base_article`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `case_knowledge_base_article` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `case_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `knowledge_base_article_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CASE_ID_KNOWLEDGE_BASE_ARTICLE_ID` (`case_id`,`knowledge_base_article_id`),
  KEY `IDX_CASE_ID` (`case_id`),
  KEY `IDX_KNOWLEDGE_BASE_ARTICLE_ID` (`knowledge_base_article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `case_knowledge_base_article`
--

LOCK TABLES `case_knowledge_base_article` WRITE;
/*!40000 ALTER TABLE `case_knowledge_base_article` DISABLE KEYS */;
/*!40000 ALTER TABLE `case_knowledge_base_article` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact`
--

DROP TABLE IF EXISTS `contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `salutation_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `do_not_call` tinyint(1) NOT NULL DEFAULT '0',
  `address_street` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_postal_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `middle_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stream_updated_at` datetime DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CREATED_AT_ID` (`created_at`,`id`),
  KEY `IDX_CREATED_AT` (`created_at`,`deleted`),
  KEY `IDX_FIRST_NAME` (`first_name`,`deleted`),
  KEY `IDX_NAME` (`first_name`,`last_name`),
  KEY `IDX_ASSIGNED_USER` (`assigned_user_id`,`deleted`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  KEY `IDX_CAMPAIGN_ID` (`campaign_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact`
--

LOCK TABLES `contact` WRITE;
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
INSERT INTO `contact` VALUES ('687ebf8c4695452ae',0,'Mr.','dfff','fffff',NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-07-21 22:30:36','2025-07-21 22:30:36',NULL,'2025-07-21 22:30:36',NULL,NULL,'687bf5ab74919cb49',NULL,NULL),('68a3cd8a3b98c8213',0,'Mr.','a','aa',NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-08-19 01:04:10','2025-08-19 01:04:10',NULL,'2025-08-19 01:04:10',NULL,NULL,'687bf5ab74919cb49',NULL,NULL);
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_document`
--

DROP TABLE IF EXISTS `contact_document`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_document` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CONTACT_ID_DOCUMENT_ID` (`contact_id`,`document_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`),
  KEY `IDX_DOCUMENT_ID` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_document`
--

LOCK TABLES `contact_document` WRITE;
/*!40000 ALTER TABLE `contact_document` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_document` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_meeting`
--

DROP TABLE IF EXISTS `contact_meeting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_meeting` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meeting_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'None',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CONTACT_ID_MEETING_ID` (`contact_id`,`meeting_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`),
  KEY `IDX_MEETING_ID` (`meeting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_meeting`
--

LOCK TABLES `contact_meeting` WRITE;
/*!40000 ALTER TABLE `contact_meeting` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_meeting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_opportunity`
--

DROP TABLE IF EXISTS `contact_opportunity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_opportunity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opportunity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CONTACT_ID_OPPORTUNITY_ID` (`contact_id`,`opportunity_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`),
  KEY `IDX_OPPORTUNITY_ID` (`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_opportunity`
--

LOCK TABLES `contact_opportunity` WRITE;
/*!40000 ALTER TABLE `contact_opportunity` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_opportunity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_target_list`
--

DROP TABLE IF EXISTS `contact_target_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_target_list` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contact_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_list_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opted_out` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CONTACT_ID_TARGET_LIST_ID` (`contact_id`,`target_list_id`),
  KEY `IDX_CONTACT_ID` (`contact_id`),
  KEY `IDX_TARGET_LIST_ID` (`target_list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_target_list`
--

LOCK TABLES `contact_target_list` WRITE;
/*!40000 ALTER TABLE `contact_target_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_target_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currency` (
  `id` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency`
--

LOCK TABLES `currency` WRITE;
/*!40000 ALTER TABLE `currency` DISABLE KEYS */;
INSERT INTO `currency` VALUES ('BRL',1);
/*!40000 ALTER TABLE `currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_template`
--

DROP TABLE IF EXISTS `dashboard_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_template` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `layout` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `dashlets_options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_template`
--

LOCK TABLES `dashboard_template` WRITE;
/*!40000 ALTER TABLE `dashboard_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `document`
--

DROP TABLE IF EXISTS `document`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `file_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_FOLDER_ID` (`folder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document`
--

LOCK TABLES `document` WRITE;
/*!40000 ALTER TABLE `document` DISABLE KEYS */;
/*!40000 ALTER TABLE `document` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `document_folder`
--

DROP TABLE IF EXISTS `document_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_folder` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_PARENT_ID` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_folder`
--

LOCK TABLES `document_folder` WRITE;
/*!40000 ALTER TABLE `document_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `document_folder_path`
--

DROP TABLE IF EXISTS `document_folder_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_folder_path` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ascendor_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descendor_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ASCENDOR_ID` (`ascendor_id`),
  KEY `IDX_DESCENDOR_ID` (`descendor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_folder_path`
--

LOCK TABLES `document_folder_path` WRITE;
/*!40000 ALTER TABLE `document_folder_path` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_folder_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `document_lead`
--

DROP TABLE IF EXISTS `document_lead`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_lead` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `document_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lead_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_DOCUMENT_ID_LEAD_ID` (`document_id`,`lead_id`),
  KEY `IDX_DOCUMENT_ID` (`document_id`),
  KEY `IDX_LEAD_ID` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_lead`
--

LOCK TABLES `document_lead` WRITE;
/*!40000 ALTER TABLE `document_lead` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_lead` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `document_opportunity`
--

DROP TABLE IF EXISTS `document_opportunity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_opportunity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `document_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opportunity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_DOCUMENT_ID_OPPORTUNITY_ID` (`document_id`,`opportunity_id`),
  KEY `IDX_DOCUMENT_ID` (`document_id`),
  KEY `IDX_OPPORTUNITY_ID` (`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_opportunity`
--

LOCK TABLES `document_opportunity` WRITE;
/*!40000 ALTER TABLE `document_opportunity` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_opportunity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email`
--

DROP TABLE IF EXISTS `email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `from_string` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_to_string` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_name_map` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_replied` tinyint(1) NOT NULL DEFAULT '0',
  `message_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_id_internal` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body_plain` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_html` tinyint(1) NOT NULL DEFAULT '1',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Archived',
  `has_attachment` tinyint(1) NOT NULL DEFAULT '0',
  `date_sent` datetime DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `send_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `ics_contents` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ics_event_uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_status_folder` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_email_address_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sent_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replied_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_event_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_event_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_DATE_SENT` (`date_sent`,`deleted`),
  KEY `IDX_DATE_SENT_STATUS` (`date_sent`,`status`,`deleted`),
  KEY `IDX_MESSAGE_ID` (`message_id`),
  KEY `IDX_ICS_EVENT_UID` (`ics_event_uid`),
  KEY `IDX_GROUP_STATUS_FOLDER` (`group_status_folder`),
  KEY `IDX_FROM_EMAIL_ADDRESS_ID` (`from_email_address_id`),
  KEY `IDX_PARENT` (`parent_id`,`parent_type`),
  KEY `IDX_SENT_BY_ID` (`sent_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_REPLIED_ID` (`replied_id`),
  KEY `IDX_CREATED_EVENT` (`created_event_id`,`created_event_type`),
  KEY `IDX_GROUP_FOLDER_ID` (`group_folder_id`),
  KEY `IDX_ACCOUNT_ID` (`account_id`),
  FULLTEXT KEY `IDX_SYSTEM_FULL_TEXT_SEARCH` (`name`,`body_plain`,`body`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email`
--

LOCK TABLES `email` WRITE;
/*!40000 ALTER TABLE `email` DISABLE KEYS */;
INSERT INTO `email` VALUES ('687c0037e8e437cc9',NULL,0,NULL,NULL,NULL,0,'dummy:687c0037e8e6fc41c',NULL,NULL,NULL,1,'Archived',0,NULL,NULL,NULL,'2025-07-19 20:29:43','2025-07-19 20:29:43',0,NULL,NULL,NULL,NULL,NULL,NULL,'687bf5ab74919cb49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_account`
--

DROP TABLE IF EXISTS `email_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_account` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `email_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  `host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` int DEFAULT '993',
  `security` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'SSL',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monitored_folders` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sent_folder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_sent_emails` tinyint(1) NOT NULL DEFAULT '0',
  `keep_fetched_emails_unread` tinyint(1) NOT NULL DEFAULT '0',
  `fetch_since` date DEFAULT NULL,
  `fetch_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `connected_at` datetime DEFAULT NULL,
  `use_imap` tinyint(1) NOT NULL DEFAULT '1',
  `use_smtp` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` int DEFAULT '587',
  `smtp_auth` tinyint(1) NOT NULL DEFAULT '1',
  `smtp_security` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'TLS',
  `smtp_username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_auth_mechanism` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'login',
  `imap_handler` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_handler` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_EMAIL_FOLDER_ID` (`email_folder_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_account`
--

LOCK TABLES `email_account` WRITE;
/*!40000 ALTER TABLE `email_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_address`
--

DROP TABLE IF EXISTS `email_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_address` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `lower` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `opt_out` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `IDX_LOWER` (`lower`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_address`
--

LOCK TABLES `email_address` WRITE;
/*!40000 ALTER TABLE `email_address` DISABLE KEYS */;
INSERT INTO `email_address` VALUES ('687bfc5c8d742afd6','leonardomariani@msn.com',0,'leonardomariani@msn.com',0,0),('687f74b41b4390b3d','tyrson@softautomacao.com.br',0,'tyrson@softautomacao.com.br',0,0);
/*!40000 ALTER TABLE `email_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_email_account`
--

DROP TABLE IF EXISTS `email_email_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_email_account` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_account_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EMAIL_ID_EMAIL_ACCOUNT_ID` (`email_id`,`email_account_id`),
  KEY `IDX_EMAIL_ID` (`email_id`),
  KEY `IDX_EMAIL_ACCOUNT_ID` (`email_account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_email_account`
--

LOCK TABLES `email_email_account` WRITE;
/*!40000 ALTER TABLE `email_email_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_email_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_email_address`
--

DROP TABLE IF EXISTS `email_email_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_email_address` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_type` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EMAIL_ID_EMAIL_ADDRESS_ID_ADDRESS_TYPE` (`email_id`,`email_address_id`,`address_type`),
  KEY `IDX_EMAIL_ID` (`email_id`),
  KEY `IDX_EMAIL_ADDRESS_ID` (`email_address_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_email_address`
--

LOCK TABLES `email_email_address` WRITE;
/*!40000 ALTER TABLE `email_email_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_email_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_filter`
--

DROP TABLE IF EXISTS `email_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_filter` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `from` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body_contains` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `body_contains_all` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_global` tinyint(1) NOT NULL DEFAULT '0',
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Skip',
  `mark_as_read` tinyint(1) NOT NULL DEFAULT '0',
  `skip_notification` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_email_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_PARENT` (`parent_id`,`parent_type`),
  KEY `IDX_EMAIL_FOLDER_ID` (`email_folder_id`),
  KEY `IDX_GROUP_EMAIL_FOLDER_ID` (`group_email_folder_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_filter`
--

LOCK TABLES `email_filter` WRITE;
/*!40000 ALTER TABLE `email_filter` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_folder`
--

DROP TABLE IF EXISTS `email_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_folder` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `order` int DEFAULT NULL,
  `skip_notifications` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_folder`
--

LOCK TABLES `email_folder` WRITE;
/*!40000 ALTER TABLE `email_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_inbound_email`
--

DROP TABLE IF EXISTS `email_inbound_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_inbound_email` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EMAIL_ID_INBOUND_EMAIL_ID` (`email_id`,`inbound_email_id`),
  KEY `IDX_EMAIL_ID` (`email_id`),
  KEY `IDX_INBOUND_EMAIL_ID` (`inbound_email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_inbound_email`
--

LOCK TABLES `email_inbound_email` WRITE;
/*!40000 ALTER TABLE `email_inbound_email` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_inbound_email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_queue_item`
--

DROP TABLE IF EXISTS `email_queue_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_queue_item` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attempt_count` int DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `sent_at` datetime DEFAULT NULL,
  `email_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_test` tinyint(1) NOT NULL DEFAULT '0',
  `mass_email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_SENT_AT` (`sent_at`),
  KEY `IDX_MASS_EMAIL_ID` (`mass_email_id`),
  KEY `IDX_TARGET` (`target_id`,`target_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_queue_item`
--

LOCK TABLES `email_queue_item` WRITE;
/*!40000 ALTER TABLE `email_queue_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_queue_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_template`
--

DROP TABLE IF EXISTS `email_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_template` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_html` tinyint(1) NOT NULL DEFAULT '1',
  `one_off` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `category_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_number` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CATEGORY_ID` (`category_id`),
  KEY `IDX_ASSIGNED_USER_ID` (`assigned_user_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_template`
--

LOCK TABLES `email_template` WRITE;
/*!40000 ALTER TABLE `email_template` DISABLE KEYS */;
INSERT INTO `email_template` VALUES ('687bf5d3e404c6659','Case-to-Email auto-reply',0,'Case has been created','<p>{Person.name},</p><p>Case \'{Case.name}\' has been created with number {Case.number} and assigned to {User.name}.</p>',1,0,'2025-07-19 19:45:23','2025-07-19 19:45:23',NULL,NULL,'system',NULL,1);
/*!40000 ALTER TABLE `email_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_template_category`
--

DROP TABLE IF EXISTS `email_template_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_template_category` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `order` int DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`),
  KEY `IDX_PARENT_ID` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_template_category`
--

LOCK TABLES `email_template_category` WRITE;
/*!40000 ALTER TABLE `email_template_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_template_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_template_category_path`
--

DROP TABLE IF EXISTS `email_template_category_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_template_category_path` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ascendor_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descendor_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ASCENDOR_ID` (`ascendor_id`),
  KEY `IDX_DESCENDOR_ID` (`descendor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_template_category_path`
--

LOCK TABLES `email_template_category_path` WRITE;
/*!40000 ALTER TABLE `email_template_category_path` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_template_category_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_user`
--

DROP TABLE IF EXISTS `email_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `in_trash` tinyint(1) DEFAULT '0',
  `in_archive` tinyint(1) DEFAULT '0',
  `folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EMAIL_ID_USER_ID` (`email_id`,`user_id`),
  KEY `IDX_EMAIL_ID` (`email_id`),
  KEY `IDX_USER_ID` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_user`
--

LOCK TABLES `email_user` WRITE;
/*!40000 ALTER TABLE `email_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entity_email_address`
--

DROP TABLE IF EXISTS `entity_email_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entity_email_address` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_address_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ENTITY_ID_EMAIL_ADDRESS_ID_ENTITY_TYPE` (`entity_id`,`email_address_id`,`entity_type`),
  KEY `IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_EMAIL_ADDRESS_ID` (`email_address_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entity_email_address`
--

LOCK TABLES `entity_email_address` WRITE;
/*!40000 ALTER TABLE `entity_email_address` DISABLE KEYS */;
INSERT INTO `entity_email_address` VALUES (1,'687bfc5c494e48ba9','687bfc5c8d742afd6','User',1,0),(2,'687f74b3bb5a8c833','687f74b41b4390b3d','User',1,0);
/*!40000 ALTER TABLE `entity_email_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entity_phone_number`
--

DROP TABLE IF EXISTS `entity_phone_number`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entity_phone_number` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary` tinyint(1) DEFAULT '0',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ENTITY_ID_PHONE_NUMBER_ID_ENTITY_TYPE` (`entity_id`,`phone_number_id`,`entity_type`),
  KEY `IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_PHONE_NUMBER_ID` (`phone_number_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entity_phone_number`
--

LOCK TABLES `entity_phone_number` WRITE;
/*!40000 ALTER TABLE `entity_phone_number` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_phone_number` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entity_team`
--

DROP TABLE IF EXISTS `entity_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entity_team` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `team_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ENTITY_ID_TEAM_ID_ENTITY_TYPE` (`entity_id`,`team_id`,`entity_type`),
  KEY `IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_TEAM_ID` (`team_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entity_team`
--

LOCK TABLES `entity_team` WRITE;
/*!40000 ALTER TABLE `entity_team` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_team` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entity_user`
--

DROP TABLE IF EXISTS `entity_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entity_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ENTITY_ID_USER_ID_ENTITY_TYPE` (`entity_id`,`user_id`,`entity_type`),
  KEY `IDX_ENTITY_ID` (`entity_id`),
  KEY `IDX_USER_ID` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entity_user`
--

LOCK TABLES `entity_user` WRITE;
/*!40000 ALTER TABLE `entity_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export`
--

DROP TABLE IF EXISTS `export`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `export` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Pending',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `notify_on_finish` tinyint(1) NOT NULL DEFAULT '0',
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_ATTACHMENT` (`attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export`
--

LOCK TABLES `export` WRITE;
/*!40000 ALTER TABLE `export` DISABLE KEYS */;
/*!40000 ALTER TABLE `export` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `extension`
--

DROP TABLE IF EXISTS `extension`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `extension` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `version` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_list` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `license_status` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_status_message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_installed` tinyint(1) NOT NULL DEFAULT '0',
  `check_version_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_LICENSE_STATUS` (`license_status`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `extension`
--

LOCK TABLES `extension` WRITE;
/*!40000 ALTER TABLE `extension` DISABLE KEYS */;
/*!40000 ALTER TABLE `extension` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `external_account`
--

DROP TABLE IF EXISTS `external_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `external_account` (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `external_account`
--

LOCK TABLES `external_account` WRITE;
/*!40000 ALTER TABLE `external_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `external_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_email_folder`
--

DROP TABLE IF EXISTS `group_email_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_email_folder` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `order` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_email_folder`
--

LOCK TABLES `group_email_folder` WRITE;
/*!40000 ALTER TABLE `group_email_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_email_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_email_folder_team`
--

DROP TABLE IF EXISTS `group_email_folder_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_email_folder_team` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `group_email_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `team_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_GROUP_EMAIL_FOLDER_ID_TEAM_ID` (`group_email_folder_id`,`team_id`),
  KEY `IDX_GROUP_EMAIL_FOLDER_ID` (`group_email_folder_id`),
  KEY `IDX_TEAM_ID` (`team_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_email_folder_team`
--

LOCK TABLES `group_email_folder_team` WRITE;
/*!40000 ALTER TABLE `group_email_folder_team` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_email_folder_team` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import`
--

DROP TABLE IF EXISTS `import`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `import` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `entity_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_index` int DEFAULT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `attribute_list` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `file_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import`
--

LOCK TABLES `import` WRITE;
/*!40000 ALTER TABLE `import` DISABLE KEYS */;
/*!40000 ALTER TABLE `import` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import_entity`
--

DROP TABLE IF EXISTS `import_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `import_entity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) DEFAULT '0',
  `is_imported` tinyint(1) NOT NULL DEFAULT '0',
  `is_updated` tinyint(1) NOT NULL DEFAULT '0',
  `is_duplicate` tinyint(1) NOT NULL DEFAULT '0',
  `entity_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `import_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ENTITY_IMPORT` (`import_id`,`entity_type`),
  KEY `IDX_ENTITY` (`entity_id`,`entity_type`),
  KEY `IDX_IMPORT` (`import_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import_entity`
--

LOCK TABLES `import_entity` WRITE;
/*!40000 ALTER TABLE `import_entity` DISABLE KEYS */;
/*!40000 ALTER TABLE `import_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import_error`
--

DROP TABLE IF EXISTS `import_error`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `import_error` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `row_index` int DEFAULT NULL,
  `export_row_index` int DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validation_failures` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `row` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `import_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ROW_INDEX` (`row_index`),
  KEY `IDX_IMPORT_ROW_INDEX` (`import_id`,`row_index`),
  KEY `IDX_IMPORT_ID` (`import_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import_error`
--

LOCK TABLES `import_error` WRITE;
/*!40000 ALTER TABLE `import_error` DISABLE KEYS */;
/*!40000 ALTER TABLE `import_error` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inbound_email`
--

DROP TABLE IF EXISTS `inbound_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inbound_email` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `email_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Active',
  `host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` int DEFAULT '993',
  `security` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'SSL',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monitored_folders` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `fetch_since` date DEFAULT NULL,
  `fetch_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `add_all_team_users` tinyint(1) NOT NULL DEFAULT '1',
  `sent_folder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_sent_emails` tinyint(1) NOT NULL DEFAULT '0',
  `keep_fetched_emails_unread` tinyint(1) NOT NULL DEFAULT '0',
  `connected_at` datetime DEFAULT NULL,
  `exclude_from_reply` tinyint(1) NOT NULL DEFAULT '0',
  `use_imap` tinyint(1) NOT NULL DEFAULT '1',
  `use_smtp` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_is_shared` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_is_for_mass_email` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` int DEFAULT '587',
  `smtp_auth` tinyint(1) NOT NULL DEFAULT '1',
  `smtp_security` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'TLS',
  `smtp_username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_auth_mechanism` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'login',
  `create_case` tinyint(1) NOT NULL DEFAULT '0',
  `case_distribution` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Direct-Assignment',
  `target_user_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply` tinyint(1) NOT NULL DEFAULT '0',
  `reply_from_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_to_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_from_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_handler` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_handler` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `assign_to_user_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `team_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_email_template_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_email_folder_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ASSIGN_TO_USER_ID` (`assign_to_user_id`),
  KEY `IDX_TEAM_ID` (`team_id`),
  KEY `IDX_REPLY_EMAIL_TEMPLATE_ID` (`reply_email_template_id`),
  KEY `IDX_GROUP_EMAIL_FOLDER_ID` (`group_email_folder_id`),
  KEY `IDX_CREATED_BY_ID` (`created_by_id`),
  KEY `IDX_MODIFIED_BY_ID` (`modified_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inbound_email`
--

LOCK TABLES `inbound_email` WRITE;
/*!40000 ALTER TABLE `inbound_email` DISABLE KEYS */;
INSERT INTO `inbound_email` VALUES ('687bfc2d3ac6cee8b','LSM',0,'leonardosmariani@gmail.com','Active',NULL,993,'SSL',NULL,'Aybx+abcZP+WfELLmUo/IyR9BYL6pKUoomnHd1ClovA=','[\"INBOX\"]',NULL,NULL,1,NULL,0,0,NULL,0,0,1,0,0,'smtp.gmail.com',587,1,'TLS','leonardosmariani@gmail.com','ekgO+3fYT64FMuia/ca59QhLpcT1UgcG9B709dgt9EAkfQWC+qSlKKJpx3dQpaLw','login',0,'Direct-Assignment',NULL,0,NULL,'leonardosmariani@gmail.com',NULL,NULL,NULL,NULL,'2025-07-19 20:12:29','2025-07-19 20:12:29',NULL,NULL,NULL,NULL,'687bf5ab74919cb49',NULL);
/*!40000 ALTER TABLE `inbound_email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inbound_email_team`
--

DROP TABLE IF EXISTS `inbound_email_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inbound_email_team` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `inbound_email_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `team_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_INBOUND_EMAIL_ID_TEAM_ID` (`inbound_email_id`,`team_id`),
  KEY `IDX_INBOUND_EMAIL_ID` (`inbound_email_id`),
  KEY `IDX_TEAM_ID` (`team_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inbound_email_team`
--

LOCK TABLES `inbound_email_team` WRITE;
/*!40000 ALTER TABLE `inbound_email_team` DISABLE KEYS */;
/*!40000 ALTER TABLE `inbound_email_team` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `integration`
--

DROP TABLE IF EXISTS `integration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `integration` (
  `id` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `integration`
--

LOCK TABLES `integration` WRITE;
/*!40000 ALTER TABLE `integration` DISABLE KEYS */;
/*!40000 ALTER TABLE `integration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job`
--

DROP TABLE IF EXISTS `job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `job` (
  `id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT '0',
  `status` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Pending',
  `execute_time` datetime DEFAULT NULL,
  `number` bigint unsigned NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `method_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `queue` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_group` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `executed_at` datetime DEFAULT NULL,
  `pid` int DEFAULT NULL,
  `attempts` int DEFAULT NULL,
  `target_id` varchar(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failed_attempts` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `scheduled_job_id` varchar(17) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_NUMBER` (`number`),
  KEY `IDX_EXECUTE_TIME` (`status`,`execute_time`),
  KEY `IDX_STATUS` (`status`,`deleted`),
  KEY `IDX_STATUS_SCHEDULED_JOB_ID` (`status`,`scheduled_job_id`),
  KEY `IDX_SCHEDULED_JOB_ID` (`scheduled_job_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1352539 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job`
--

LOCK TABLES `job` WRITE;
/*!40000 ALTER TABLE `job` DISABLE KEYS */;
INSERT INTO `job` VALUES ('692bc17ebecceb642','Clean-up',0,'Success','2025-12-07 04:01:00',1054845,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-07 04:01:03','2025-12-07 04:20:57',1451407,1,NULL,NULL,NULL,'2025-11-30 04:01:02','2025-12-07 04:20:57','687bf5d48655b39ab'),('692fb81aa8ece4053','Control Knowledge Base Article Status',0,'Success','2025-12-04 04:10:00',1080032,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:04','2025-12-04 04:10:04',1338193,1,NULL,NULL,NULL,'2025-12-03 04:10:02','2025-12-04 04:10:04','687bf5d547a33169f'),('692ff18670f6d66a7','Check for New Version',0,'Success','2025-12-04 08:15:00',1081458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:15:02','2025-12-04 08:15:03',1346054,1,NULL,NULL,NULL,'2025-12-03 08:15:02','2025-12-04 08:15:03','687bf57e39c3298cd'),('692ff18724cef9cae','Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewVersion',0,'Success','2025-12-04 04:29:00',1081459,'Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewVersion',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:29:02','2025-12-04 04:29:03',1338514,1,NULL,NULL,NULL,'2025-12-03 08:15:03','2025-12-04 04:29:03',NULL),('692ff3dee5e9da667','Check for New Versions of Installed Extensions',0,'Success','2025-12-04 08:25:00',1081518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-04 08:25:03',1346457,1,NULL,NULL,NULL,'2025-12-03 08:25:02','2025-12-04 08:25:03','687bf57e4c0a76ca9'),('692ff3df9e689e542','Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewExtensionVersion',0,'Success','2025-12-04 05:47:00',1081519,'Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewExtensionVersion',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:47:02','2025-12-04 05:47:03',1340656,1,NULL,NULL,NULL,'2025-12-03 08:25:03','2025-12-04 05:47:03',NULL),('6930f96f4a265fa0c','Dummy',0,'Success','2025-12-04 15:01:00',1088013,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 15:01:02','2025-12-04 15:01:02',1361978,1,NULL,NULL,NULL,'2025-12-04 03:01:03','2025-12-04 15:01:02','687bf57e1513fe2aa'),('693104eb2d9ad0121','Send Mass Emails',0,'Success','2025-12-04 04:10:00',1088298,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:05','2025-12-04 04:10:06',1338193,1,NULL,NULL,NULL,'2025-12-04 03:50:03','2025-12-04 04:10:06','687bf5d4b535f913f'),('69310741eb52d4890','Send Email Reminders',0,'Success','2025-12-04 04:02:00',1088354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:03','2025-12-04 04:02:03',1337975,1,NULL,NULL,NULL,'2025-12-04 04:00:01','2025-12-04 04:02:03','687bf5d44d3e10813'),('693107421c63f6ec1','Send Email Notifications',0,'Success','2025-12-04 04:02:00',1088355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:04','2025-12-04 04:02:04',1337975,1,NULL,NULL,NULL,'2025-12-04 04:00:02','2025-12-04 04:02:04','687bf5d466067a4ba'),('6931074258ee22fcd','Auth Token Control',0,'Success','2025-12-04 04:06:00',1088356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:03','2025-12-04 04:06:04',1338038,1,NULL,NULL,NULL,'2025-12-04 04:00:02','2025-12-04 04:06:04','687bf5d511e08c57f'),('69310742a4ffa8929','Process Webhook Queue',0,'Success','2025-12-04 04:02:00',1088357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:05','2025-12-04 04:02:05',1337975,1,NULL,NULL,NULL,'2025-12-04 04:00:02','2025-12-04 04:02:05','687bf5d5788e2fe0e'),('693107431b37391e4','Send Scheduled Emails',0,'Success','2025-12-04 04:10:00',1088358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:06','2025-12-04 04:10:06',1338193,1,NULL,NULL,NULL,'2025-12-04 04:00:03','2025-12-04 04:10:06','687bf5d5eeb01d80d'),('6931077d86a531da2','Submit Popup Reminders',0,'Success','2025-12-04 04:01:01',1088359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:01:03','2025-12-04 04:01:03',1337961,1,NULL,NULL,NULL,'2025-12-04 04:01:01','2025-12-04 04:01:03','687bf57d2f9463790'),('6931077db89c8c65f','Process Job Queue q0',0,'Success','2025-12-04 04:01:01',1088360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:01:04','2025-12-04 04:01:04',1337961,1,NULL,NULL,NULL,'2025-12-04 04:01:01','2025-12-04 04:01:04','687bf57d693e0fc1f'),('6931077dd73693cc1','Process Job Queue q1',0,'Success','2025-12-04 04:02:00',1088361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:05','2025-12-04 04:02:05',1337975,1,NULL,NULL,NULL,'2025-12-04 04:01:01','2025-12-04 04:02:05','687bf57d8afb5c472'),('6931077e04e3331ea','Process Job Queue e0',0,'Success','2025-12-04 04:01:02',1088362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:01:05','2025-12-04 04:01:05',1337961,1,NULL,NULL,NULL,'2025-12-04 04:01:02','2025-12-04 04:01:05','687bf57dbba8299ef'),('693107b9da5bee66d','Submit Popup Reminders',0,'Success','2025-12-04 04:02:01',1088363,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:06','2025-12-04 04:02:06',1337975,1,NULL,NULL,NULL,'2025-12-04 04:02:01','2025-12-04 04:02:06','687bf57d2f9463790'),('693107ba3a012a0d6','Process Job Queue q0',0,'Success','2025-12-04 04:02:02',1088364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:07','2025-12-04 04:02:07',1337975,1,NULL,NULL,NULL,'2025-12-04 04:02:02','2025-12-04 04:02:07','687bf57d693e0fc1f'),('693107ba9c13663d3','Process Job Queue q1',0,'Success','2025-12-04 04:03:00',1088365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:03:02','2025-12-04 04:03:02',1337992,1,NULL,NULL,NULL,'2025-12-04 04:02:02','2025-12-04 04:03:02','687bf57d8afb5c472'),('693107bacee734730','Process Job Queue e0',0,'Success','2025-12-04 04:02:02',1088366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:02:08','2025-12-04 04:02:08',1337975,1,NULL,NULL,NULL,'2025-12-04 04:02:02','2025-12-04 04:02:08','687bf57dbba8299ef'),('693107bb2d478bacf','Send Email Reminders',0,'Success','2025-12-04 04:04:00',1088367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:04','2025-12-04 04:04:04',1338008,1,NULL,NULL,NULL,'2025-12-04 04:02:03','2025-12-04 04:04:04','687bf5d44d3e10813'),('693107bb6c75f4962','Send Email Notifications',0,'Success','2025-12-04 04:04:00',1088368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:05','2025-12-04 04:04:05',1338008,1,NULL,NULL,NULL,'2025-12-04 04:02:03','2025-12-04 04:04:05','687bf5d466067a4ba'),('693107bb9577e4ddd','Process Webhook Queue',0,'Success','2025-12-04 04:04:00',1088369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:05','2025-12-04 04:04:05',1338008,1,NULL,NULL,NULL,'2025-12-04 04:02:03','2025-12-04 04:04:05','687bf5d5788e2fe0e'),('693107f5654b535cb','Submit Popup Reminders',0,'Success','2025-12-04 04:03:01',1088370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:03:03','2025-12-04 04:03:04',1337992,1,NULL,NULL,NULL,'2025-12-04 04:03:01','2025-12-04 04:03:04','687bf57d2f9463790'),('693107f58a77124b6','Process Job Queue q0',0,'Success','2025-12-04 04:03:01',1088371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:03:04','2025-12-04 04:03:05',1337992,1,NULL,NULL,NULL,'2025-12-04 04:03:01','2025-12-04 04:03:05','687bf57d693e0fc1f'),('693107f5a51fcaf26','Process Job Queue q1',0,'Success','2025-12-04 04:04:00',1088372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:06','2025-12-04 04:04:06',1338008,1,NULL,NULL,NULL,'2025-12-04 04:03:01','2025-12-04 04:04:06','687bf57d8afb5c472'),('693107f5c2d71b2a6','Process Job Queue e0',0,'Success','2025-12-04 04:03:01',1088373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:03:05','2025-12-04 04:03:06',1337992,1,NULL,NULL,NULL,'2025-12-04 04:03:01','2025-12-04 04:03:06','687bf57dbba8299ef'),('69310831ebd2de298','Submit Popup Reminders',0,'Success','2025-12-04 04:04:01',1088374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:07','2025-12-04 04:04:07',1338008,1,NULL,NULL,NULL,'2025-12-04 04:04:01','2025-12-04 04:04:07','687bf57d2f9463790'),('693108322cf277b94','Process Job Queue q0',0,'Success','2025-12-04 04:04:02',1088375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:08','2025-12-04 04:04:08',1338008,1,NULL,NULL,NULL,'2025-12-04 04:04:02','2025-12-04 04:04:08','687bf57d693e0fc1f'),('6931083261c9c4530','Process Job Queue q1',0,'Success','2025-12-04 04:05:00',1088376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:05:02','2025-12-04 04:05:03',1338023,1,NULL,NULL,NULL,'2025-12-04 04:04:02','2025-12-04 04:05:03','687bf57d8afb5c472'),('6931083281baeda2a','Process Job Queue e0',0,'Success','2025-12-04 04:04:02',1088377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:04:08','2025-12-04 04:04:09',1338008,1,NULL,NULL,NULL,'2025-12-04 04:04:02','2025-12-04 04:04:09','687bf57dbba8299ef'),('693108333b868e79b','Send Email Reminders',0,'Success','2025-12-04 04:06:00',1088378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:04','2025-12-04 04:06:04',1338038,1,NULL,NULL,NULL,'2025-12-04 04:04:03','2025-12-04 04:06:04','687bf5d44d3e10813'),('69310833642caa26f','Send Email Notifications',0,'Success','2025-12-04 04:06:00',1088379,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:05','2025-12-04 04:06:05',1338038,1,NULL,NULL,NULL,'2025-12-04 04:04:03','2025-12-04 04:06:05','687bf5d466067a4ba'),('69310833b02315a7f','Process Webhook Queue',0,'Success','2025-12-04 04:06:00',1088380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:06','2025-12-04 04:06:06',1338038,1,NULL,NULL,NULL,'2025-12-04 04:04:03','2025-12-04 04:06:06','687bf5d5788e2fe0e'),('6931086e02b10c0ad','Submit Popup Reminders',0,'Success','2025-12-04 04:05:02',1088381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:05:04','2025-12-04 04:05:04',1338023,1,NULL,NULL,NULL,'2025-12-04 04:05:02','2025-12-04 04:05:04','687bf57d2f9463790'),('6931086e284beadb9','Process Job Queue q0',0,'Success','2025-12-04 04:05:02',1088382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:05:05','2025-12-04 04:05:05',1338023,1,NULL,NULL,NULL,'2025-12-04 04:05:02','2025-12-04 04:05:05','687bf57d693e0fc1f'),('6931086e4c2e637db','Process Job Queue q1',0,'Success','2025-12-04 04:06:00',1088383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:06','2025-12-04 04:06:07',1338038,1,NULL,NULL,NULL,'2025-12-04 04:05:02','2025-12-04 04:06:07','687bf57d8afb5c472'),('6931086e7117356f2','Process Job Queue e0',0,'Success','2025-12-04 04:05:02',1088384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:05:05','2025-12-04 04:05:05',1338023,1,NULL,NULL,NULL,'2025-12-04 04:05:02','2025-12-04 04:05:05','687bf57dbba8299ef'),('693108a9516cc4b1e','Submit Popup Reminders',0,'Success','2025-12-04 04:06:01',1088385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:07','2025-12-04 04:06:07',1338038,1,NULL,NULL,NULL,'2025-12-04 04:06:01','2025-12-04 04:06:07','687bf57d2f9463790'),('693108a9822b54fa4','Process Job Queue q0',0,'Success','2025-12-04 04:06:01',1088386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:08','2025-12-04 04:06:08',1338038,1,NULL,NULL,NULL,'2025-12-04 04:06:01','2025-12-04 04:06:08','687bf57d693e0fc1f'),('693108a9d5d24dc16','Process Job Queue q1',0,'Success','2025-12-04 04:07:00',1088387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:07:02','2025-12-04 04:07:02',1338054,1,NULL,NULL,NULL,'2025-12-04 04:06:01','2025-12-04 04:07:02','687bf57d8afb5c472'),('693108aa3c8ef87f1','Process Job Queue e0',0,'Success','2025-12-04 04:06:02',1088388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:06:08','2025-12-04 04:06:09',1338038,1,NULL,NULL,NULL,'2025-12-04 04:06:02','2025-12-04 04:06:09','687bf57dbba8299ef'),('693108ab170706c02','Send Email Reminders',0,'Success','2025-12-04 04:08:00',1088389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:04','2025-12-04 04:08:04',1338069,1,NULL,NULL,NULL,'2025-12-04 04:06:03','2025-12-04 04:08:04','687bf5d44d3e10813'),('693108ab43760074c','Send Email Notifications',0,'Success','2025-12-04 04:08:00',1088390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:05','2025-12-04 04:08:05',1338069,1,NULL,NULL,NULL,'2025-12-04 04:06:03','2025-12-04 04:08:05','687bf5d466067a4ba'),('693108ab840d696bc','Auth Token Control',0,'Success','2025-12-04 04:12:00',1088391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:03','2025-12-04 04:12:04',1338223,1,NULL,NULL,NULL,'2025-12-04 04:06:03','2025-12-04 04:12:04','687bf5d511e08c57f'),('693108abc0c37720d','Process Webhook Queue',0,'Success','2025-12-04 04:08:00',1088392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:05','2025-12-04 04:08:06',1338069,1,NULL,NULL,NULL,'2025-12-04 04:06:03','2025-12-04 04:08:06','687bf5d5788e2fe0e'),('693108e5e4ea43124','Submit Popup Reminders',0,'Success','2025-12-04 04:07:01',1088393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:07:03','2025-12-04 04:07:03',1338054,1,NULL,NULL,NULL,'2025-12-04 04:07:01','2025-12-04 04:07:03','687bf57d2f9463790'),('693108e625b0769ea','Process Job Queue q0',0,'Success','2025-12-04 04:07:02',1088394,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:07:04','2025-12-04 04:07:04',1338054,1,NULL,NULL,NULL,'2025-12-04 04:07:02','2025-12-04 04:07:04','687bf57d693e0fc1f'),('693108e64e14f87d5','Process Job Queue q1',0,'Success','2025-12-04 04:08:00',1088395,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:06','2025-12-04 04:08:07',1338069,1,NULL,NULL,NULL,'2025-12-04 04:07:02','2025-12-04 04:08:07','687bf57d8afb5c472'),('693108e66c3842142','Process Job Queue e0',0,'Success','2025-12-04 04:07:02',1088396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:07:05','2025-12-04 04:07:05',1338054,1,NULL,NULL,NULL,'2025-12-04 04:07:02','2025-12-04 04:07:05','687bf57dbba8299ef'),('6931092210c5685b0','Submit Popup Reminders',0,'Success','2025-12-04 04:08:02',1088397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:07','2025-12-04 04:08:07',1338069,1,NULL,NULL,NULL,'2025-12-04 04:08:02','2025-12-04 04:08:07','687bf57d2f9463790'),('6931092244d489b50','Process Job Queue q0',0,'Success','2025-12-04 04:08:02',1088398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:08','2025-12-04 04:08:08',1338069,1,NULL,NULL,NULL,'2025-12-04 04:08:02','2025-12-04 04:08:08','687bf57d693e0fc1f'),('6931092275d1ed097','Process Job Queue q1',0,'Success','2025-12-04 04:09:00',1088399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:09:02','2025-12-04 04:09:02',1338101,1,NULL,NULL,NULL,'2025-12-04 04:08:02','2025-12-04 04:09:02','687bf57d8afb5c472'),('69310922cca9d1ab7','Process Job Queue e0',0,'Success','2025-12-04 04:08:02',1088400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:08:09','2025-12-04 04:08:09',1338069,1,NULL,NULL,NULL,'2025-12-04 04:08:02','2025-12-04 04:08:09','687bf57dbba8299ef'),('6931092395d9724a4','Send Email Reminders',0,'Success','2025-12-04 04:10:00',1088401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:07','2025-12-04 04:10:07',1338193,1,NULL,NULL,NULL,'2025-12-04 04:08:03','2025-12-04 04:10:07','687bf5d44d3e10813'),('69310923d74422c6f','Send Email Notifications',0,'Success','2025-12-04 04:10:00',1088402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:08','2025-12-04 04:10:08',1338193,1,NULL,NULL,NULL,'2025-12-04 04:08:03','2025-12-04 04:10:08','687bf5d466067a4ba'),('693109240ee899120','Process Webhook Queue',0,'Success','2025-12-04 04:10:00',1088403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:09','2025-12-04 04:10:09',1338193,1,NULL,NULL,NULL,'2025-12-04 04:08:04','2025-12-04 04:10:09','687bf5d5788e2fe0e'),('6931095d8c6ba88da','Submit Popup Reminders',0,'Success','2025-12-04 04:09:01',1088404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:09:04','2025-12-04 04:09:04',1338101,1,NULL,NULL,NULL,'2025-12-04 04:09:01','2025-12-04 04:09:04','687bf57d2f9463790'),('6931095db8c7fd9a6','Process Job Queue q0',0,'Success','2025-12-04 04:09:01',1088405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:09:05','2025-12-04 04:09:05',1338101,1,NULL,NULL,NULL,'2025-12-04 04:09:01','2025-12-04 04:09:05','687bf57d693e0fc1f'),('6931095dd8a0a51a4','Process Job Queue q1',0,'Success','2025-12-04 04:10:00',1088406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:09','2025-12-04 04:10:10',1338193,1,NULL,NULL,NULL,'2025-12-04 04:09:01','2025-12-04 04:10:10','687bf57d8afb5c472'),('6931095e0754be455','Process Job Queue e0',0,'Success','2025-12-04 04:09:02',1088407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:09:06','2025-12-04 04:09:06',1338101,1,NULL,NULL,NULL,'2025-12-04 04:09:02','2025-12-04 04:09:06','687bf57dbba8299ef'),('6931099998c5e33ce','Submit Popup Reminders',0,'Success','2025-12-04 04:10:01',1088408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:10','2025-12-04 04:10:10',1338193,1,NULL,NULL,NULL,'2025-12-04 04:10:01','2025-12-04 04:10:10','687bf57d2f9463790'),('69310999bfcd49e85','Process Job Queue q0',0,'Success','2025-12-04 04:10:01',1088409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:11','2025-12-04 04:10:11',1338193,1,NULL,NULL,NULL,'2025-12-04 04:10:01','2025-12-04 04:10:11','687bf57d693e0fc1f'),('69310999e61e9f9d2','Process Job Queue q1',0,'Success','2025-12-04 04:11:00',1088410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:11:02','2025-12-04 04:11:03',1338206,1,NULL,NULL,NULL,'2025-12-04 04:10:01','2025-12-04 04:11:03','687bf57d8afb5c472'),('6931099a745a33a3e','Process Job Queue e0',0,'Success','2025-12-04 04:10:02',1088411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:10:12','2025-12-04 04:10:12',1338193,1,NULL,NULL,NULL,'2025-12-04 04:10:02','2025-12-04 04:10:12','687bf57dbba8299ef'),('6931099ab6552c31d','Send Email Reminders',0,'Success','2025-12-04 04:12:00',1088412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:04','2025-12-04 04:12:04',1338223,1,NULL,NULL,NULL,'2025-12-04 04:10:02','2025-12-04 04:12:04','687bf5d44d3e10813'),('6931099b078c5732b','Send Email Notifications',0,'Success','2025-12-04 04:12:00',1088413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:05','2025-12-04 04:12:05',1338223,1,NULL,NULL,NULL,'2025-12-04 04:10:03','2025-12-04 04:12:05','687bf5d466067a4ba'),('6931099b67d8c147f','Send Mass Emails',0,'Success','2025-12-04 04:30:00',1088414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:04','2025-12-04 04:30:04',1338534,1,NULL,NULL,NULL,'2025-12-04 04:10:03','2025-12-04 04:30:04','687bf5d4b535f913f'),('6931099ba534d21fd','Control Knowledge Base Article Status',0,'Success','2025-12-05 04:10:00',1088415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 04:10:04','2025-12-05 04:10:05',1386223,1,NULL,NULL,NULL,'2025-12-04 04:10:03','2025-12-05 04:10:05','687bf5d547a33169f'),('6931099bd9985a4a7','Process Webhook Queue',0,'Success','2025-12-04 04:12:00',1088416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:06','2025-12-04 04:12:06',1338223,1,NULL,NULL,NULL,'2025-12-04 04:10:03','2025-12-04 04:12:06','687bf5d5788e2fe0e'),('6931099c208936c9d','Send Scheduled Emails',0,'Success','2025-12-04 04:20:00',1088417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:03','2025-12-04 04:20:03',1338361,1,NULL,NULL,NULL,'2025-12-04 04:10:04','2025-12-04 04:20:03','687bf5d5eeb01d80d'),('693109d5f1a4a9778','Submit Popup Reminders',0,'Success','2025-12-04 04:11:01',1088418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:11:04','2025-12-04 04:11:04',1338206,1,NULL,NULL,NULL,'2025-12-04 04:11:01','2025-12-04 04:11:04','687bf57d2f9463790'),('693109d61bfe3f8a0','Process Job Queue q0',0,'Success','2025-12-04 04:11:02',1088419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:11:04','2025-12-04 04:11:05',1338206,1,NULL,NULL,NULL,'2025-12-04 04:11:02','2025-12-04 04:11:05','687bf57d693e0fc1f'),('693109d63ca3e41eb','Process Job Queue q1',0,'Success','2025-12-04 04:12:00',1088420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:06','2025-12-04 04:12:06',1338223,1,NULL,NULL,NULL,'2025-12-04 04:11:02','2025-12-04 04:12:06','687bf57d8afb5c472'),('693109d65b52a521a','Process Job Queue e0',0,'Success','2025-12-04 04:11:02',1088421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:11:05','2025-12-04 04:11:05',1338206,1,NULL,NULL,NULL,'2025-12-04 04:11:02','2025-12-04 04:11:05','687bf57dbba8299ef'),('69310a11c6c1a96a6','Submit Popup Reminders',0,'Success','2025-12-04 04:12:01',1088422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:07','2025-12-04 04:12:07',1338223,1,NULL,NULL,NULL,'2025-12-04 04:12:01','2025-12-04 04:12:07','687bf57d2f9463790'),('69310a12010f0cf0c','Process Job Queue q0',0,'Success','2025-12-04 04:12:02',1088423,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:08','2025-12-04 04:12:08',1338223,1,NULL,NULL,NULL,'2025-12-04 04:12:02','2025-12-04 04:12:08','687bf57d693e0fc1f'),('69310a124f691f41c','Process Job Queue q1',0,'Success','2025-12-04 04:13:00',1088424,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:13:02','2025-12-04 04:13:02',1338242,1,NULL,NULL,NULL,'2025-12-04 04:12:02','2025-12-04 04:13:02','687bf57d8afb5c472'),('69310a127e70c301b','Process Job Queue e0',0,'Success','2025-12-04 04:12:02',1088425,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:12:08','2025-12-04 04:12:08',1338223,1,NULL,NULL,NULL,'2025-12-04 04:12:02','2025-12-04 04:12:08','687bf57dbba8299ef'),('69310a12ca5ed6af1','Send Email Reminders',0,'Success','2025-12-04 04:14:00',1088426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:03','2025-12-04 04:14:03',1338256,1,NULL,NULL,NULL,'2025-12-04 04:12:02','2025-12-04 04:14:03','687bf5d44d3e10813'),('69310a1367afa9269','Send Email Notifications',0,'Success','2025-12-04 04:14:00',1088427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:04','2025-12-04 04:14:04',1338256,1,NULL,NULL,NULL,'2025-12-04 04:12:03','2025-12-04 04:14:04','687bf5d466067a4ba'),('69310a1391c94a984','Auth Token Control',0,'Success','2025-12-04 04:18:00',1088428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:04','2025-12-04 04:18:04',1338331,1,NULL,NULL,NULL,'2025-12-04 04:12:03','2025-12-04 04:18:04','687bf5d511e08c57f'),('69310a13c0193f070','Process Webhook Queue',0,'Success','2025-12-04 04:14:00',1088429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:05','2025-12-04 04:14:05',1338256,1,NULL,NULL,NULL,'2025-12-04 04:12:03','2025-12-04 04:14:05','687bf5d5788e2fe0e'),('69310a4d51f3d9fa7','Submit Popup Reminders',0,'Success','2025-12-04 04:13:01',1088430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:13:03','2025-12-04 04:13:03',1338242,1,NULL,NULL,NULL,'2025-12-04 04:13:01','2025-12-04 04:13:03','687bf57d2f9463790'),('69310a4d835800a06','Process Job Queue q0',0,'Success','2025-12-04 04:13:01',1088431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:13:04','2025-12-04 04:13:04',1338242,1,NULL,NULL,NULL,'2025-12-04 04:13:01','2025-12-04 04:13:04','687bf57d693e0fc1f'),('69310a4dc32f3d695','Process Job Queue q1',0,'Success','2025-12-04 04:14:00',1088432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:05','2025-12-04 04:14:06',1338256,1,NULL,NULL,NULL,'2025-12-04 04:13:01','2025-12-04 04:14:06','687bf57d8afb5c472'),('69310a4e5e1f5edba','Process Job Queue e0',0,'Success','2025-12-04 04:13:02',1088433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:13:04','2025-12-04 04:13:04',1338242,1,NULL,NULL,NULL,'2025-12-04 04:13:02','2025-12-04 04:13:04','687bf57dbba8299ef'),('69310a896c7087c10','Submit Popup Reminders',0,'Success','2025-12-04 04:14:01',1088434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:06','2025-12-04 04:14:06',1338256,1,NULL,NULL,NULL,'2025-12-04 04:14:01','2025-12-04 04:14:06','687bf57d2f9463790'),('69310a89933ff74a8','Process Job Queue q0',0,'Success','2025-12-04 04:14:01',1088435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:07','2025-12-04 04:14:07',1338256,1,NULL,NULL,NULL,'2025-12-04 04:14:01','2025-12-04 04:14:07','687bf57d693e0fc1f'),('69310a89b267c94ce','Process Job Queue q1',0,'Success','2025-12-04 04:15:00',1088436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:15:02','2025-12-04 04:15:02',1338283,1,NULL,NULL,NULL,'2025-12-04 04:14:01','2025-12-04 04:15:02','687bf57d8afb5c472'),('69310a89ec157cc71','Process Job Queue e0',0,'Success','2025-12-04 04:14:01',1088437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:14:08','2025-12-04 04:14:08',1338256,1,NULL,NULL,NULL,'2025-12-04 04:14:01','2025-12-04 04:14:08','687bf57dbba8299ef'),('69310a8a78431f503','Send Email Reminders',0,'Success','2025-12-04 04:16:00',1088438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:03','2025-12-04 04:16:03',1338298,1,NULL,NULL,NULL,'2025-12-04 04:14:02','2025-12-04 04:16:03','687bf5d44d3e10813'),('69310a8ab30bb7eb8','Send Email Notifications',0,'Success','2025-12-04 04:16:00',1088439,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:04','2025-12-04 04:16:04',1338298,1,NULL,NULL,NULL,'2025-12-04 04:14:02','2025-12-04 04:16:04','687bf5d466067a4ba'),('69310a8b144b308a1','Process Webhook Queue',0,'Success','2025-12-04 04:16:00',1088440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:05','2025-12-04 04:16:05',1338298,1,NULL,NULL,NULL,'2025-12-04 04:14:03','2025-12-04 04:16:05','687bf5d5788e2fe0e'),('69310ac5d2f52f37c','Submit Popup Reminders',0,'Success','2025-12-04 04:15:01',1088441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:15:03','2025-12-04 04:15:04',1338283,1,NULL,NULL,NULL,'2025-12-04 04:15:01','2025-12-04 04:15:04','687bf57d2f9463790'),('69310ac60f6eb40d3','Process Job Queue q0',0,'Success','2025-12-04 04:15:02',1088442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:15:04','2025-12-04 04:15:05',1338283,1,NULL,NULL,NULL,'2025-12-04 04:15:02','2025-12-04 04:15:05','687bf57d693e0fc1f'),('69310ac62db741d2c','Process Job Queue q1',0,'Success','2025-12-04 04:16:00',1088443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:05','2025-12-04 04:16:06',1338298,1,NULL,NULL,NULL,'2025-12-04 04:15:02','2025-12-04 04:16:06','687bf57d8afb5c472'),('69310ac6505e4c815','Process Job Queue e0',0,'Success','2025-12-04 04:15:02',1088444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:15:05','2025-12-04 04:15:05',1338283,1,NULL,NULL,NULL,'2025-12-04 04:15:02','2025-12-04 04:15:05','687bf57dbba8299ef'),('69310b01b4d703412','Submit Popup Reminders',0,'Success','2025-12-04 04:16:01',1088445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:06','2025-12-04 04:16:06',1338298,1,NULL,NULL,NULL,'2025-12-04 04:16:01','2025-12-04 04:16:06','687bf57d2f9463790'),('69310b01e7acd4588','Process Job Queue q0',0,'Success','2025-12-04 04:16:01',1088446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:07','2025-12-04 04:16:07',1338298,1,NULL,NULL,NULL,'2025-12-04 04:16:01','2025-12-04 04:16:07','687bf57d693e0fc1f'),('69310b020e152f7b0','Process Job Queue q1',0,'Success','2025-12-04 04:17:00',1088447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:17:02','2025-12-04 04:17:02',1338311,1,NULL,NULL,NULL,'2025-12-04 04:16:02','2025-12-04 04:17:02','687bf57d8afb5c472'),('69310b022dd83976d','Process Job Queue e0',0,'Success','2025-12-04 04:16:02',1088448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:16:08','2025-12-04 04:16:08',1338298,1,NULL,NULL,NULL,'2025-12-04 04:16:02','2025-12-04 04:16:08','687bf57dbba8299ef'),('69310b025f5dffee8','Send Email Reminders',0,'Success','2025-12-04 04:18:00',1088449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:05','2025-12-04 04:18:05',1338331,1,NULL,NULL,NULL,'2025-12-04 04:16:02','2025-12-04 04:18:05','687bf5d44d3e10813'),('69310b0280139a3b3','Send Email Notifications',0,'Success','2025-12-04 04:18:00',1088450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:06','2025-12-04 04:18:06',1338331,1,NULL,NULL,NULL,'2025-12-04 04:16:02','2025-12-04 04:18:06','687bf5d466067a4ba'),('69310b02c62f0259c','Process Webhook Queue',0,'Success','2025-12-04 04:18:00',1088451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:07','2025-12-04 04:18:07',1338331,1,NULL,NULL,NULL,'2025-12-04 04:16:02','2025-12-04 04:18:07','687bf5d5788e2fe0e'),('69310b3d6f580aae3','Submit Popup Reminders',0,'Success','2025-12-04 04:17:01',1088452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:17:03','2025-12-04 04:17:03',1338311,1,NULL,NULL,NULL,'2025-12-04 04:17:01','2025-12-04 04:17:03','687bf57d2f9463790'),('69310b3d9f9631ec5','Process Job Queue q0',0,'Success','2025-12-04 04:17:01',1088453,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:17:04','2025-12-04 04:17:04',1338311,1,NULL,NULL,NULL,'2025-12-04 04:17:01','2025-12-04 04:17:04','687bf57d693e0fc1f'),('69310b3dc36781697','Process Job Queue q1',0,'Success','2025-12-04 04:18:00',1088454,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:08','2025-12-04 04:18:08',1338331,1,NULL,NULL,NULL,'2025-12-04 04:17:01','2025-12-04 04:18:08','687bf57d8afb5c472'),('69310b3de32c9070f','Process Job Queue e0',0,'Success','2025-12-04 04:17:01',1088455,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:17:05','2025-12-04 04:17:05',1338311,1,NULL,NULL,NULL,'2025-12-04 04:17:01','2025-12-04 04:17:05','687bf57dbba8299ef'),('69310b7a10721e4d2','Submit Popup Reminders',0,'Success','2025-12-04 04:18:02',1088456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:09','2025-12-04 04:18:09',1338331,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:18:09','687bf57d2f9463790'),('69310b7a3f898d732','Process Job Queue q0',0,'Success','2025-12-04 04:18:02',1088457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:10','2025-12-04 04:18:10',1338331,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:18:10','687bf57d693e0fc1f'),('69310b7a5db742f80','Process Job Queue q1',0,'Success','2025-12-04 04:19:00',1088458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:19:02','2025-12-04 04:19:03',1338346,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:19:03','687bf57d8afb5c472'),('69310b7a8a1eb5337','Process Job Queue e0',0,'Success','2025-12-04 04:18:02',1088459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:18:10','2025-12-04 04:18:10',1338331,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:18:10','687bf57dbba8299ef'),('69310b7ab3615e63f','Send Email Reminders',0,'Success','2025-12-04 04:20:00',1088460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:04','2025-12-04 04:20:04',1338361,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:20:04','687bf5d44d3e10813'),('69310b7ad875afa88','Send Email Notifications',0,'Success','2025-12-04 04:20:00',1088461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:04','2025-12-04 04:20:05',1338361,1,NULL,NULL,NULL,'2025-12-04 04:18:02','2025-12-04 04:20:05','687bf5d466067a4ba'),('69310b7b09e14e68e','Auth Token Control',0,'Success','2025-12-04 04:24:00',1088462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:03','2025-12-04 04:24:04',1338434,1,NULL,NULL,NULL,'2025-12-04 04:18:03','2025-12-04 04:24:04','687bf5d511e08c57f'),('69310b7b42738085c','Process Webhook Queue',0,'Success','2025-12-04 04:20:00',1088463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:05','2025-12-04 04:20:05',1338361,1,NULL,NULL,NULL,'2025-12-04 04:18:03','2025-12-04 04:20:05','687bf5d5788e2fe0e'),('69310bb60fec4f45d','Submit Popup Reminders',0,'Success','2025-12-04 04:19:02',1088464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:19:04','2025-12-04 04:19:04',1338346,1,NULL,NULL,NULL,'2025-12-04 04:19:02','2025-12-04 04:19:04','687bf57d2f9463790'),('69310bb632e40721e','Process Job Queue q0',0,'Success','2025-12-04 04:19:02',1088465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:19:05','2025-12-04 04:19:05',1338346,1,NULL,NULL,NULL,'2025-12-04 04:19:02','2025-12-04 04:19:05','687bf57d693e0fc1f'),('69310bb657af9234f','Process Job Queue q1',0,'Success','2025-12-04 04:20:00',1088466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:06','2025-12-04 04:20:06',1338361,1,NULL,NULL,NULL,'2025-12-04 04:19:02','2025-12-04 04:20:06','687bf57d8afb5c472'),('69310bb67747717a4','Process Job Queue e0',0,'Success','2025-12-04 04:19:02',1088467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:19:05','2025-12-04 04:19:06',1338346,1,NULL,NULL,NULL,'2025-12-04 04:19:02','2025-12-04 04:19:06','687bf57dbba8299ef'),('69310bf18d5701a46','Submit Popup Reminders',0,'Success','2025-12-04 04:20:01',1088468,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:07','2025-12-04 04:20:07',1338361,1,NULL,NULL,NULL,'2025-12-04 04:20:01','2025-12-04 04:20:07','687bf57d2f9463790'),('69310bf1bcd3347ee','Process Job Queue q0',0,'Success','2025-12-04 04:20:01',1088469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:07','2025-12-04 04:20:08',1338361,1,NULL,NULL,NULL,'2025-12-04 04:20:01','2025-12-04 04:20:08','687bf57d693e0fc1f'),('69310bf201366c20d','Process Job Queue q1',0,'Success','2025-12-04 04:21:00',1088470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:21:02','2025-12-04 04:21:02',1338376,1,NULL,NULL,NULL,'2025-12-04 04:20:02','2025-12-04 04:21:02','687bf57d8afb5c472'),('69310bf24f3f7ea05','Process Job Queue e0',0,'Success','2025-12-04 04:20:02',1088471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:20:08','2025-12-04 04:20:08',1338361,1,NULL,NULL,NULL,'2025-12-04 04:20:02','2025-12-04 04:20:08','687bf57dbba8299ef'),('69310bf291a17656e','Send Email Reminders',0,'Success','2025-12-04 04:22:00',1088472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:03','2025-12-04 04:22:03',1338396,1,NULL,NULL,NULL,'2025-12-04 04:20:02','2025-12-04 04:22:03','687bf5d44d3e10813'),('69310bf2d076a9211','Send Email Notifications',0,'Success','2025-12-04 04:22:00',1088473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:04','2025-12-04 04:22:04',1338396,1,NULL,NULL,NULL,'2025-12-04 04:20:02','2025-12-04 04:22:04','687bf5d466067a4ba'),('69310bf34b5a7e5c4','Process Webhook Queue',0,'Success','2025-12-04 04:22:00',1088474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:05','2025-12-04 04:22:05',1338396,1,NULL,NULL,NULL,'2025-12-04 04:20:03','2025-12-04 04:22:05','687bf5d5788e2fe0e'),('69310bf385980a19e','Send Scheduled Emails',0,'Success','2025-12-04 04:30:00',1088475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:04','2025-12-04 04:30:05',1338534,1,NULL,NULL,NULL,'2025-12-04 04:20:03','2025-12-04 04:30:05','687bf5d5eeb01d80d'),('69310c2e10b0ae332','Submit Popup Reminders',0,'Success','2025-12-04 04:21:02',1088476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:21:03','2025-12-04 04:21:04',1338376,1,NULL,NULL,NULL,'2025-12-04 04:21:02','2025-12-04 04:21:04','687bf57d2f9463790'),('69310c2e3f09d7641','Process Job Queue q0',0,'Success','2025-12-04 04:21:02',1088477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:21:04','2025-12-04 04:21:04',1338376,1,NULL,NULL,NULL,'2025-12-04 04:21:02','2025-12-04 04:21:04','687bf57d693e0fc1f'),('69310c2e5dbf90210','Process Job Queue q1',0,'Success','2025-12-04 04:22:00',1088478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:06','2025-12-04 04:22:06',1338396,1,NULL,NULL,NULL,'2025-12-04 04:21:02','2025-12-04 04:22:06','687bf57d8afb5c472'),('69310c2e7f8f8a789','Process Job Queue e0',0,'Success','2025-12-04 04:21:02',1088479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:21:05','2025-12-04 04:21:05',1338376,1,NULL,NULL,NULL,'2025-12-04 04:21:02','2025-12-04 04:21:05','687bf57dbba8299ef'),('69310c698f6335ac5','Submit Popup Reminders',0,'Success','2025-12-04 04:22:01',1088480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:07','2025-12-04 04:22:07',1338396,1,NULL,NULL,NULL,'2025-12-04 04:22:01','2025-12-04 04:22:07','687bf57d2f9463790'),('69310c69b790a495c','Process Job Queue q0',0,'Success','2025-12-04 04:22:01',1088481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:07','2025-12-04 04:22:08',1338396,1,NULL,NULL,NULL,'2025-12-04 04:22:01','2025-12-04 04:22:08','687bf57d693e0fc1f'),('69310c69da642c180','Process Job Queue q1',0,'Success','2025-12-04 04:23:00',1088482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:23:02','2025-12-04 04:23:03',1338418,1,NULL,NULL,NULL,'2025-12-04 04:22:01','2025-12-04 04:23:03','687bf57d8afb5c472'),('69310c6a05e38b3f8','Process Job Queue e0',0,'Success','2025-12-04 04:22:02',1088483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:22:08','2025-12-04 04:22:09',1338396,1,NULL,NULL,NULL,'2025-12-04 04:22:02','2025-12-04 04:22:09','687bf57dbba8299ef'),('69310c6a2b0f57006','Send Email Reminders',0,'Success','2025-12-04 04:24:00',1088484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:04','2025-12-04 04:24:05',1338434,1,NULL,NULL,NULL,'2025-12-04 04:22:02','2025-12-04 04:24:05','687bf5d44d3e10813'),('69310c6a788bbca10','Send Email Notifications',0,'Success','2025-12-04 04:24:00',1088485,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:05','2025-12-04 04:24:05',1338434,1,NULL,NULL,NULL,'2025-12-04 04:22:02','2025-12-04 04:24:05','687bf5d466067a4ba'),('69310c6aba735e483','Process Webhook Queue',0,'Success','2025-12-04 04:24:00',1088486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:06','2025-12-04 04:24:06',1338434,1,NULL,NULL,NULL,'2025-12-04 04:22:02','2025-12-04 04:24:06','687bf5d5788e2fe0e'),('69310ca594ff6b8a7','Submit Popup Reminders',0,'Success','2025-12-04 04:23:01',1088487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:23:04','2025-12-04 04:23:04',1338418,1,NULL,NULL,NULL,'2025-12-04 04:23:01','2025-12-04 04:23:04','687bf57d2f9463790'),('69310ca5c3d92a756','Process Job Queue q0',0,'Success','2025-12-04 04:23:01',1088488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:23:04','2025-12-04 04:23:04',1338418,1,NULL,NULL,NULL,'2025-12-04 04:23:01','2025-12-04 04:23:04','687bf57d693e0fc1f'),('69310ca60731bae1b','Process Job Queue q1',0,'Success','2025-12-04 04:24:00',1088489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:07','2025-12-04 04:24:07',1338434,1,NULL,NULL,NULL,'2025-12-04 04:23:02','2025-12-04 04:24:07','687bf57d8afb5c472'),('69310ca6acf9ba01f','Process Job Queue e0',0,'Success','2025-12-04 04:23:02',1088490,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:23:05','2025-12-04 04:23:05',1338418,1,NULL,NULL,NULL,'2025-12-04 04:23:02','2025-12-04 04:23:05','687bf57dbba8299ef'),('69310ce16fbd5c730','Submit Popup Reminders',0,'Success','2025-12-04 04:24:01',1088491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:07','2025-12-04 04:24:07',1338434,1,NULL,NULL,NULL,'2025-12-04 04:24:01','2025-12-04 04:24:07','687bf57d2f9463790'),('69310ce1a411aaf27','Process Job Queue q0',0,'Success','2025-12-04 04:24:01',1088492,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:08','2025-12-04 04:24:08',1338434,1,NULL,NULL,NULL,'2025-12-04 04:24:01','2025-12-04 04:24:08','687bf57d693e0fc1f'),('69310ce1ccd7e6741','Process Job Queue q1',0,'Success','2025-12-04 04:25:00',1088493,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:25:03','2025-12-04 04:25:03',1338448,1,NULL,NULL,NULL,'2025-12-04 04:24:01','2025-12-04 04:25:03','687bf57d8afb5c472'),('69310ce200b403162','Process Job Queue e0',0,'Success','2025-12-04 04:24:01',1088494,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:24:09','2025-12-04 04:24:09',1338434,1,NULL,NULL,NULL,'2025-12-04 04:24:02','2025-12-04 04:24:09','687bf57dbba8299ef'),('69310ce230795a308','Send Email Reminders',0,'Success','2025-12-04 04:26:00',1088495,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:03','2025-12-04 04:26:03',1338462,1,NULL,NULL,NULL,'2025-12-04 04:24:02','2025-12-04 04:26:03','687bf5d44d3e10813'),('69310ce2c8c5b08c1','Send Email Notifications',0,'Success','2025-12-04 04:26:00',1088496,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:04','2025-12-04 04:26:04',1338462,1,NULL,NULL,NULL,'2025-12-04 04:24:02','2025-12-04 04:26:04','687bf5d466067a4ba'),('69310ce31680f98ed','Auth Token Control',0,'Success','2025-12-04 04:30:00',1088497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:05','2025-12-04 04:30:05',1338534,1,NULL,NULL,NULL,'2025-12-04 04:24:03','2025-12-04 04:30:05','687bf5d511e08c57f'),('69310ce3580f244ac','Process Webhook Queue',0,'Success','2025-12-04 04:26:00',1088498,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:05','2025-12-04 04:26:05',1338462,1,NULL,NULL,NULL,'2025-12-04 04:24:03','2025-12-04 04:26:05','687bf5d5788e2fe0e'),('69310d1db47ad31e5','Submit Popup Reminders',0,'Success','2025-12-04 04:25:01',1088499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:25:04','2025-12-04 04:25:04',1338448,1,NULL,NULL,NULL,'2025-12-04 04:25:01','2025-12-04 04:25:04','687bf57d2f9463790'),('69310d1e04c5efdcb','Process Job Queue q0',0,'Success','2025-12-04 04:25:02',1088500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:25:04','2025-12-04 04:25:05',1338448,1,NULL,NULL,NULL,'2025-12-04 04:25:02','2025-12-04 04:25:05','687bf57d693e0fc1f'),('69310d1e49f112cc4','Process Job Queue q1',0,'Success','2025-12-04 04:26:00',1088501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:06','2025-12-04 04:26:06',1338462,1,NULL,NULL,NULL,'2025-12-04 04:25:02','2025-12-04 04:26:06','687bf57d8afb5c472'),('69310d1e96db8d4be','Process Job Queue e0',0,'Success','2025-12-04 04:25:02',1088502,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:25:05','2025-12-04 04:25:05',1338448,1,NULL,NULL,NULL,'2025-12-04 04:25:02','2025-12-04 04:25:05','687bf57dbba8299ef'),('69310d59d809697b4','Submit Popup Reminders',0,'Success','2025-12-04 04:26:01',1088503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:07','2025-12-04 04:26:07',1338462,1,NULL,NULL,NULL,'2025-12-04 04:26:01','2025-12-04 04:26:07','687bf57d2f9463790'),('69310d5a0f9bc9cc2','Process Job Queue q0',0,'Success','2025-12-04 04:26:02',1088504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:08','2025-12-04 04:26:08',1338462,1,NULL,NULL,NULL,'2025-12-04 04:26:02','2025-12-04 04:26:08','687bf57d693e0fc1f'),('69310d5a316a2d9cb','Process Job Queue q1',0,'Success','2025-12-04 04:27:00',1088505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:27:02','2025-12-04 04:27:02',1338478,1,NULL,NULL,NULL,'2025-12-04 04:26:02','2025-12-04 04:27:02','687bf57d8afb5c472'),('69310d5a4e46733f9','Process Job Queue e0',0,'Success','2025-12-04 04:26:02',1088506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:26:08','2025-12-04 04:26:08',1338462,1,NULL,NULL,NULL,'2025-12-04 04:26:02','2025-12-04 04:26:08','687bf57dbba8299ef'),('69310d5a7dcdc6bdb','Send Email Reminders',0,'Success','2025-12-04 04:28:00',1088507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:03','2025-12-04 04:28:03',1338497,1,NULL,NULL,NULL,'2025-12-04 04:26:02','2025-12-04 04:28:03','687bf5d44d3e10813'),('69310d5adbb728cb3','Send Email Notifications',0,'Success','2025-12-04 04:28:00',1088508,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:04','2025-12-04 04:28:04',1338497,1,NULL,NULL,NULL,'2025-12-04 04:26:02','2025-12-04 04:28:04','687bf5d466067a4ba'),('69310d5b37b68e1bc','Process Webhook Queue',0,'Success','2025-12-04 04:28:00',1088509,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:05','2025-12-04 04:28:05',1338497,1,NULL,NULL,NULL,'2025-12-04 04:26:03','2025-12-04 04:28:05','687bf5d5788e2fe0e'),('69310d95a6dcdd4e7','Submit Popup Reminders',0,'Success','2025-12-04 04:27:01',1088510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:27:03','2025-12-04 04:27:03',1338478,1,NULL,NULL,NULL,'2025-12-04 04:27:01','2025-12-04 04:27:03','687bf57d2f9463790'),('69310d95cf4dfcd9c','Process Job Queue q0',0,'Success','2025-12-04 04:27:01',1088511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:27:04','2025-12-04 04:27:05',1338478,1,NULL,NULL,NULL,'2025-12-04 04:27:01','2025-12-04 04:27:05','687bf57d693e0fc1f'),('69310d96083341351','Process Job Queue q1',0,'Success','2025-12-04 04:28:00',1088512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:06','2025-12-04 04:28:06',1338497,1,NULL,NULL,NULL,'2025-12-04 04:27:02','2025-12-04 04:28:06','687bf57d8afb5c472'),('69310d962a0a1595f','Process Job Queue e0',0,'Success','2025-12-04 04:27:02',1088513,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:27:05','2025-12-04 04:27:06',1338478,1,NULL,NULL,NULL,'2025-12-04 04:27:02','2025-12-04 04:27:06','687bf57dbba8299ef'),('69310dd1bd75debc5','Submit Popup Reminders',0,'Success','2025-12-04 04:28:01',1088514,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:07','2025-12-04 04:28:07',1338497,1,NULL,NULL,NULL,'2025-12-04 04:28:01','2025-12-04 04:28:07','687bf57d2f9463790'),('69310dd1df3a3c6d3','Process Job Queue q0',0,'Success','2025-12-04 04:28:01',1088515,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:07','2025-12-04 04:28:08',1338497,1,NULL,NULL,NULL,'2025-12-04 04:28:01','2025-12-04 04:28:08','687bf57d693e0fc1f'),('69310dd20e849e07c','Process Job Queue q1',0,'Success','2025-12-04 04:29:00',1088516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:29:03','2025-12-04 04:29:04',1338514,1,NULL,NULL,NULL,'2025-12-04 04:28:02','2025-12-04 04:29:04','687bf57d8afb5c472'),('69310dd248ced1774','Process Job Queue e0',0,'Success','2025-12-04 04:28:02',1088517,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:28:08','2025-12-04 04:28:09',1338497,1,NULL,NULL,NULL,'2025-12-04 04:28:02','2025-12-04 04:28:09','687bf57dbba8299ef'),('69310dd28ecfce2d8','Send Email Reminders',0,'Success','2025-12-04 04:30:00',1088518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:06','2025-12-04 04:30:06',1338534,1,NULL,NULL,NULL,'2025-12-04 04:28:02','2025-12-04 04:30:06','687bf5d44d3e10813'),('69310dd2c7831024d','Send Email Notifications',0,'Success','2025-12-04 04:30:00',1088519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:07','2025-12-04 04:30:07',1338534,1,NULL,NULL,NULL,'2025-12-04 04:28:02','2025-12-04 04:30:07','687bf5d466067a4ba'),('69310dd3161088a5a','Process Webhook Queue',0,'Success','2025-12-04 04:30:00',1088520,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:07','2025-12-04 04:30:07',1338534,1,NULL,NULL,NULL,'2025-12-04 04:28:03','2025-12-04 04:30:07','687bf5d5788e2fe0e'),('69310e0dc187e58b5','Submit Popup Reminders',0,'Success','2025-12-04 04:29:01',1088521,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:29:04','2025-12-04 04:29:04',1338514,1,NULL,NULL,NULL,'2025-12-04 04:29:01','2025-12-04 04:29:04','687bf57d2f9463790'),('69310e0df00e8419e','Process Job Queue q0',0,'Success','2025-12-04 04:29:01',1088522,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:29:05','2025-12-04 04:29:05',1338514,1,NULL,NULL,NULL,'2025-12-04 04:29:01','2025-12-04 04:29:05','687bf57d693e0fc1f'),('69310e0e303aaaaa4','Process Job Queue q1',0,'Success','2025-12-04 04:30:00',1088523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:08','2025-12-04 04:30:08',1338534,1,NULL,NULL,NULL,'2025-12-04 04:29:02','2025-12-04 04:30:08','687bf57d8afb5c472'),('69310e0e65088da29','Process Job Queue e0',0,'Success','2025-12-04 04:29:02',1088524,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:29:06','2025-12-04 04:29:06',1338514,1,NULL,NULL,NULL,'2025-12-04 04:29:02','2025-12-04 04:29:06','687bf57dbba8299ef'),('69310e49a76d2d8bb','Submit Popup Reminders',0,'Success','2025-12-04 04:30:01',1088525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:09','2025-12-04 04:30:09',1338534,1,NULL,NULL,NULL,'2025-12-04 04:30:01','2025-12-04 04:30:09','687bf57d2f9463790'),('69310e49f3e682ca2','Process Job Queue q0',0,'Success','2025-12-04 04:30:01',1088526,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:09','2025-12-04 04:30:09',1338534,1,NULL,NULL,NULL,'2025-12-04 04:30:01','2025-12-04 04:30:09','687bf57d693e0fc1f'),('69310e4a6ea766a2c','Process Job Queue q1',0,'Success','2025-12-04 04:31:00',1088527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:31:02','2025-12-04 04:31:02',1338553,1,NULL,NULL,NULL,'2025-12-04 04:30:02','2025-12-04 04:31:02','687bf57d8afb5c472'),('69310e4ab120f795e','Process Job Queue e0',0,'Success','2025-12-04 04:30:02',1088528,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:30:10','2025-12-04 04:30:10',1338534,1,NULL,NULL,NULL,'2025-12-04 04:30:02','2025-12-04 04:30:10','687bf57dbba8299ef'),('69310e4aeeca529fa','Send Email Reminders',0,'Success','2025-12-04 04:32:00',1088529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:04','2025-12-04 04:32:04',1338571,1,NULL,NULL,NULL,'2025-12-04 04:30:02','2025-12-04 04:32:04','687bf5d44d3e10813'),('69310e4b31ea6ff98','Send Email Notifications',0,'Success','2025-12-04 04:32:00',1088530,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:05','2025-12-04 04:32:05',1338571,1,NULL,NULL,NULL,'2025-12-04 04:30:03','2025-12-04 04:32:05','687bf5d466067a4ba'),('69310e4b6d5767b45','Send Mass Emails',0,'Success','2025-12-04 04:50:00',1088531,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:03','2025-12-04 04:50:03',1339017,1,NULL,NULL,NULL,'2025-12-04 04:30:03','2025-12-04 04:50:03','687bf5d4b535f913f'),('69310e4b93e2e4e2d','Auth Token Control',0,'Success','2025-12-04 04:36:00',1088532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:03','2025-12-04 04:36:03',1338661,1,NULL,NULL,NULL,'2025-12-04 04:30:03','2025-12-04 04:36:03','687bf5d511e08c57f'),('69310e4bb92df21ec','Process Webhook Queue',0,'Success','2025-12-04 04:32:00',1088533,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:05','2025-12-04 04:32:05',1338571,1,NULL,NULL,NULL,'2025-12-04 04:30:03','2025-12-04 04:32:05','687bf5d5788e2fe0e'),('69310e4bdd402c319','Send Scheduled Emails',0,'Success','2025-12-04 04:40:00',1088534,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:03','2025-12-04 04:40:03',1338809,1,NULL,NULL,NULL,'2025-12-04 04:30:03','2025-12-04 04:40:03','687bf5d5eeb01d80d'),('69310e858b30fb0be','Submit Popup Reminders',0,'Success','2025-12-04 04:31:01',1088535,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:31:03','2025-12-04 04:31:04',1338553,1,NULL,NULL,NULL,'2025-12-04 04:31:01','2025-12-04 04:31:04','687bf57d2f9463790'),('69310e85b47d36791','Process Job Queue q0',0,'Success','2025-12-04 04:31:01',1088536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:31:04','2025-12-04 04:31:04',1338553,1,NULL,NULL,NULL,'2025-12-04 04:31:01','2025-12-04 04:31:04','687bf57d693e0fc1f'),('69310e860bab03d60','Process Job Queue q1',0,'Success','2025-12-04 04:32:00',1088537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:06','2025-12-04 04:32:06',1338571,1,NULL,NULL,NULL,'2025-12-04 04:31:02','2025-12-04 04:32:06','687bf57d8afb5c472'),('69310e864572089c0','Process Job Queue e0',0,'Success','2025-12-04 04:31:02',1088538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:31:05','2025-12-04 04:31:05',1338553,1,NULL,NULL,NULL,'2025-12-04 04:31:02','2025-12-04 04:31:05','687bf57dbba8299ef'),('69310ec1e3bc9c939','Submit Popup Reminders',0,'Success','2025-12-04 04:32:01',1088539,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:07','2025-12-04 04:32:07',1338571,1,NULL,NULL,NULL,'2025-12-04 04:32:01','2025-12-04 04:32:07','687bf57d2f9463790'),('69310ec21d58ea6f3','Process Job Queue q0',0,'Success','2025-12-04 04:32:02',1088540,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:07','2025-12-04 04:32:08',1338571,1,NULL,NULL,NULL,'2025-12-04 04:32:02','2025-12-04 04:32:08','687bf57d693e0fc1f'),('69310ec262df655be','Process Job Queue q1',0,'Success','2025-12-04 04:33:00',1088541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:33:03','2025-12-04 04:33:03',1338585,1,NULL,NULL,NULL,'2025-12-04 04:32:02','2025-12-04 04:33:03','687bf57d8afb5c472'),('69310ec2a6ff02827','Process Job Queue e0',0,'Success','2025-12-04 04:32:02',1088542,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:32:08','2025-12-04 04:32:08',1338571,1,NULL,NULL,NULL,'2025-12-04 04:32:02','2025-12-04 04:32:08','687bf57dbba8299ef'),('69310ec33b5954797','Send Email Reminders',0,'Success','2025-12-04 04:34:00',1088543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:03','2025-12-04 04:34:04',1338611,1,NULL,NULL,NULL,'2025-12-04 04:32:03','2025-12-04 04:34:04','687bf5d44d3e10813'),('69310ec39feae0f45','Send Email Notifications',0,'Success','2025-12-04 04:34:00',1088544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:04','2025-12-04 04:34:05',1338611,1,NULL,NULL,NULL,'2025-12-04 04:32:03','2025-12-04 04:34:05','687bf5d466067a4ba'),('69310ec40a473541c','Process Webhook Queue',0,'Success','2025-12-04 04:34:00',1088545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:05','2025-12-04 04:34:05',1338611,1,NULL,NULL,NULL,'2025-12-04 04:32:04','2025-12-04 04:34:05','687bf5d5788e2fe0e'),('69310efe0e9e00457','Submit Popup Reminders',0,'Success','2025-12-04 04:33:02',1088546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:33:04','2025-12-04 04:33:04',1338585,1,NULL,NULL,NULL,'2025-12-04 04:33:02','2025-12-04 04:33:04','687bf57d2f9463790'),('69310efe33c23dd9f','Process Job Queue q0',0,'Success','2025-12-04 04:33:02',1088547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:33:04','2025-12-04 04:33:05',1338585,1,NULL,NULL,NULL,'2025-12-04 04:33:02','2025-12-04 04:33:05','687bf57d693e0fc1f'),('69310efe7c7380833','Process Job Queue q1',0,'Success','2025-12-04 04:34:00',1088548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:06','2025-12-04 04:34:06',1338611,1,NULL,NULL,NULL,'2025-12-04 04:33:02','2025-12-04 04:34:06','687bf57d8afb5c472'),('69310efecb143034f','Process Job Queue e0',0,'Success','2025-12-04 04:33:02',1088549,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:33:05','2025-12-04 04:33:05',1338585,1,NULL,NULL,NULL,'2025-12-04 04:33:02','2025-12-04 04:33:05','687bf57dbba8299ef'),('69310f39e1dc283e0','Submit Popup Reminders',0,'Success','2025-12-04 04:34:01',1088550,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:07','2025-12-04 04:34:07',1338611,1,NULL,NULL,NULL,'2025-12-04 04:34:01','2025-12-04 04:34:07','687bf57d2f9463790'),('69310f3a298552c4e','Process Job Queue q0',0,'Success','2025-12-04 04:34:02',1088551,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:08','2025-12-04 04:34:08',1338611,1,NULL,NULL,NULL,'2025-12-04 04:34:02','2025-12-04 04:34:08','687bf57d693e0fc1f'),('69310f3a585db6f23','Process Job Queue q1',0,'Success','2025-12-04 04:35:00',1088552,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:35:02','2025-12-04 04:35:02',1338633,1,NULL,NULL,NULL,'2025-12-04 04:34:02','2025-12-04 04:35:02','687bf57d8afb5c472'),('69310f3a78282f09f','Process Job Queue e0',0,'Success','2025-12-04 04:34:02',1088553,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:34:09','2025-12-04 04:34:09',1338611,1,NULL,NULL,NULL,'2025-12-04 04:34:02','2025-12-04 04:34:09','687bf57dbba8299ef'),('69310f3ac8545d23a','Send Email Reminders',0,'Success','2025-12-04 04:36:00',1088554,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:04','2025-12-04 04:36:04',1338661,1,NULL,NULL,NULL,'2025-12-04 04:34:02','2025-12-04 04:36:04','687bf5d44d3e10813'),('69310f3b260ac1a4f','Send Email Notifications',0,'Success','2025-12-04 04:36:00',1088555,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:05','2025-12-04 04:36:05',1338661,1,NULL,NULL,NULL,'2025-12-04 04:34:03','2025-12-04 04:36:05','687bf5d466067a4ba'),('69310f3b841fa12d9','Process Webhook Queue',0,'Success','2025-12-04 04:36:00',1088556,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:05','2025-12-04 04:36:05',1338661,1,NULL,NULL,NULL,'2025-12-04 04:34:03','2025-12-04 04:36:05','687bf5d5788e2fe0e'),('69310f75aeb9fae68','Submit Popup Reminders',0,'Success','2025-12-04 04:35:01',1088557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:35:03','2025-12-04 04:35:03',1338633,1,NULL,NULL,NULL,'2025-12-04 04:35:01','2025-12-04 04:35:03','687bf57d2f9463790'),('69310f75d4f7edda4','Process Job Queue q0',0,'Success','2025-12-04 04:35:01',1088558,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:35:04','2025-12-04 04:35:04',1338633,1,NULL,NULL,NULL,'2025-12-04 04:35:01','2025-12-04 04:35:04','687bf57d693e0fc1f'),('69310f76052fcbb50','Process Job Queue q1',0,'Success','2025-12-04 04:36:00',1088559,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:06','2025-12-04 04:36:06',1338661,1,NULL,NULL,NULL,'2025-12-04 04:35:02','2025-12-04 04:36:06','687bf57d8afb5c472'),('69310f7625e573e81','Process Job Queue e0',0,'Success','2025-12-04 04:35:02',1088560,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:35:05','2025-12-04 04:35:05',1338633,1,NULL,NULL,NULL,'2025-12-04 04:35:02','2025-12-04 04:35:05','687bf57dbba8299ef'),('69310fb16c076fc81','Submit Popup Reminders',0,'Success','2025-12-04 04:36:01',1088561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:07','2025-12-04 04:36:07',1338661,1,NULL,NULL,NULL,'2025-12-04 04:36:01','2025-12-04 04:36:07','687bf57d2f9463790'),('69310fb196c27d322','Process Job Queue q0',0,'Success','2025-12-04 04:36:01',1088562,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:07','2025-12-04 04:36:07',1338661,1,NULL,NULL,NULL,'2025-12-04 04:36:01','2025-12-04 04:36:07','687bf57d693e0fc1f'),('69310fb1c0bb9c053','Process Job Queue q1',0,'Success','2025-12-04 04:37:00',1088563,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:37:02','2025-12-04 04:37:02',1338676,1,NULL,NULL,NULL,'2025-12-04 04:36:01','2025-12-04 04:37:02','687bf57d8afb5c472'),('69310fb2244463518','Process Job Queue e0',0,'Success','2025-12-04 04:36:02',1088564,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:36:08','2025-12-04 04:36:08',1338661,1,NULL,NULL,NULL,'2025-12-04 04:36:02','2025-12-04 04:36:08','687bf57dbba8299ef'),('69310fb26392d5624','Send Email Reminders',0,'Success','2025-12-04 04:38:00',1088565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:03','2025-12-04 04:38:03',1338702,1,NULL,NULL,NULL,'2025-12-04 04:36:02','2025-12-04 04:38:03','687bf5d44d3e10813'),('69310fb29d533569e','Send Email Notifications',0,'Success','2025-12-04 04:38:00',1088566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:04','2025-12-04 04:38:04',1338702,1,NULL,NULL,NULL,'2025-12-04 04:36:02','2025-12-04 04:38:04','687bf5d466067a4ba'),('69310fb2d98e4dd2d','Auth Token Control',0,'Success','2025-12-04 04:42:00',1088567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:04','2025-12-04 04:42:04',1338849,1,NULL,NULL,NULL,'2025-12-04 04:36:02','2025-12-04 04:42:04','687bf5d511e08c57f'),('69310fb31e650efee','Process Webhook Queue',0,'Success','2025-12-04 04:38:00',1088568,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:04','2025-12-04 04:38:04',1338702,1,NULL,NULL,NULL,'2025-12-04 04:36:03','2025-12-04 04:38:04','687bf5d5788e2fe0e'),('69310fed4152b43ec','Submit Popup Reminders',0,'Success','2025-12-04 04:37:01',1088569,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:37:03','2025-12-04 04:37:03',1338676,1,NULL,NULL,NULL,'2025-12-04 04:37:01','2025-12-04 04:37:03','687bf57d2f9463790'),('69310fed69bb369d8','Process Job Queue q0',0,'Success','2025-12-04 04:37:01',1088570,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:37:04','2025-12-04 04:37:04',1338676,1,NULL,NULL,NULL,'2025-12-04 04:37:01','2025-12-04 04:37:04','687bf57d693e0fc1f'),('69310fedbeb36ccc3','Process Job Queue q1',0,'Success','2025-12-04 04:38:00',1088571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:05','2025-12-04 04:38:05',1338702,1,NULL,NULL,NULL,'2025-12-04 04:37:01','2025-12-04 04:38:05','687bf57d8afb5c472'),('69310fee341fb28ff','Process Job Queue e0',0,'Success','2025-12-04 04:37:02',1088572,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:37:05','2025-12-04 04:37:05',1338676,1,NULL,NULL,NULL,'2025-12-04 04:37:02','2025-12-04 04:37:05','687bf57dbba8299ef'),('693110299a8a97e4f','Submit Popup Reminders',0,'Success','2025-12-04 04:38:01',1088573,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:06','2025-12-04 04:38:06',1338702,1,NULL,NULL,NULL,'2025-12-04 04:38:01','2025-12-04 04:38:06','687bf57d2f9463790'),('69311029c407c5186','Process Job Queue q0',0,'Success','2025-12-04 04:38:01',1088574,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:06','2025-12-04 04:38:07',1338702,1,NULL,NULL,NULL,'2025-12-04 04:38:01','2025-12-04 04:38:07','687bf57d693e0fc1f'),('69311029f0b68e34c','Process Job Queue q1',0,'Success','2025-12-04 04:39:00',1088575,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:39:02','2025-12-04 04:39:02',1338721,1,NULL,NULL,NULL,'2025-12-04 04:38:01','2025-12-04 04:39:02','687bf57d8afb5c472'),('6931102a64626c732','Process Job Queue e0',0,'Success','2025-12-04 04:38:02',1088576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:38:07','2025-12-04 04:38:07',1338702,1,NULL,NULL,NULL,'2025-12-04 04:38:02','2025-12-04 04:38:07','687bf57dbba8299ef'),('6931102aa5a9460b0','Send Email Reminders',0,'Success','2025-12-04 04:40:00',1088577,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:04','2025-12-04 04:40:04',1338809,1,NULL,NULL,NULL,'2025-12-04 04:38:02','2025-12-04 04:40:04','687bf5d44d3e10813'),('6931102b058e58123','Send Email Notifications',0,'Success','2025-12-04 04:40:00',1088578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:05','2025-12-04 04:40:05',1338809,1,NULL,NULL,NULL,'2025-12-04 04:38:03','2025-12-04 04:40:05','687bf5d466067a4ba'),('6931102b4ec6c57b0','Process Webhook Queue',0,'Success','2025-12-04 04:40:00',1088579,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:06','2025-12-04 04:40:06',1338809,1,NULL,NULL,NULL,'2025-12-04 04:38:03','2025-12-04 04:40:06','687bf5d5788e2fe0e'),('693110658fa9ca55d','Submit Popup Reminders',0,'Success','2025-12-04 04:39:01',1088580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:39:03','2025-12-04 04:39:03',1338721,1,NULL,NULL,NULL,'2025-12-04 04:39:01','2025-12-04 04:39:03','687bf57d2f9463790'),('69311065af3ccc616','Process Job Queue q0',0,'Success','2025-12-04 04:39:01',1088581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:39:05','2025-12-04 04:39:05',1338721,1,NULL,NULL,NULL,'2025-12-04 04:39:01','2025-12-04 04:39:05','687bf57d693e0fc1f'),('69311065d447adf30','Process Job Queue q1',0,'Success','2025-12-04 04:40:00',1088582,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:07','2025-12-04 04:40:07',1338809,1,NULL,NULL,NULL,'2025-12-04 04:39:01','2025-12-04 04:40:07','687bf57d8afb5c472'),('6931106601bf38cc9','Process Job Queue e0',0,'Success','2025-12-04 04:39:02',1088583,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:39:06','2025-12-04 04:39:06',1338721,1,NULL,NULL,NULL,'2025-12-04 04:39:02','2025-12-04 04:39:06','687bf57dbba8299ef'),('693110a19151257ad','Submit Popup Reminders',0,'Success','2025-12-04 04:40:01',1088584,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:07','2025-12-04 04:40:08',1338809,1,NULL,NULL,NULL,'2025-12-04 04:40:01','2025-12-04 04:40:08','687bf57d2f9463790'),('693110a1cac1528aa','Process Job Queue q0',0,'Success','2025-12-04 04:40:01',1088585,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:08','2025-12-04 04:40:08',1338809,1,NULL,NULL,NULL,'2025-12-04 04:40:01','2025-12-04 04:40:08','687bf57d693e0fc1f'),('693110a1ef6e7cfd5','Process Job Queue q1',0,'Success','2025-12-04 04:41:00',1088586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:41:02','2025-12-04 04:41:02',1338824,1,NULL,NULL,NULL,'2025-12-04 04:40:01','2025-12-04 04:41:02','687bf57d8afb5c472'),('693110a2234992c8e','Process Job Queue e0',0,'Success','2025-12-04 04:40:02',1088587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:40:09','2025-12-04 04:40:09',1338809,1,NULL,NULL,NULL,'2025-12-04 04:40:02','2025-12-04 04:40:09','687bf57dbba8299ef'),('693110a24e7bae032','Send Email Reminders',0,'Success','2025-12-04 04:42:00',1088588,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:05','2025-12-04 04:42:05',1338849,1,NULL,NULL,NULL,'2025-12-04 04:40:02','2025-12-04 04:42:05','687bf5d44d3e10813'),('693110a267451f9fa','Send Email Notifications',0,'Success','2025-12-04 04:42:00',1088589,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:06','2025-12-04 04:42:06',1338849,1,NULL,NULL,NULL,'2025-12-04 04:40:02','2025-12-04 04:42:06','687bf5d466067a4ba'),('693110a28e6216e5a','Process Webhook Queue',0,'Success','2025-12-04 04:42:00',1088590,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:06','2025-12-04 04:42:06',1338849,1,NULL,NULL,NULL,'2025-12-04 04:40:02','2025-12-04 04:42:06','687bf5d5788e2fe0e'),('693110a2c30ec4276','Send Scheduled Emails',0,'Success','2025-12-04 04:50:00',1088591,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:04','2025-12-04 04:50:04',1339017,1,NULL,NULL,NULL,'2025-12-04 04:40:02','2025-12-04 04:50:04','687bf5d5eeb01d80d'),('693110dd92f03b5aa','Submit Popup Reminders',0,'Success','2025-12-04 04:41:01',1088592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:41:03','2025-12-04 04:41:03',1338824,1,NULL,NULL,NULL,'2025-12-04 04:41:01','2025-12-04 04:41:03','687bf57d2f9463790'),('693110ddbb3eb7618','Process Job Queue q0',0,'Success','2025-12-04 04:41:01',1088593,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:41:04','2025-12-04 04:41:04',1338824,1,NULL,NULL,NULL,'2025-12-04 04:41:01','2025-12-04 04:41:04','687bf57d693e0fc1f'),('693110ddd7e7fc9f1','Process Job Queue q1',0,'Success','2025-12-04 04:42:00',1088594,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:07','2025-12-04 04:42:07',1338849,1,NULL,NULL,NULL,'2025-12-04 04:41:01','2025-12-04 04:42:07','687bf57d8afb5c472'),('693110de0bae4d0f3','Process Job Queue e0',0,'Success','2025-12-04 04:41:02',1088595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:41:05','2025-12-04 04:41:05',1338824,1,NULL,NULL,NULL,'2025-12-04 04:41:02','2025-12-04 04:41:05','687bf57dbba8299ef'),('6931111a208bbd1fb','Submit Popup Reminders',0,'Success','2025-12-04 04:42:02',1088596,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:08','2025-12-04 04:42:08',1338849,1,NULL,NULL,NULL,'2025-12-04 04:42:02','2025-12-04 04:42:08','687bf57d2f9463790'),('6931111a45d1d1f5d','Process Job Queue q0',0,'Success','2025-12-04 04:42:02',1088597,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:08','2025-12-04 04:42:09',1338849,1,NULL,NULL,NULL,'2025-12-04 04:42:02','2025-12-04 04:42:09','687bf57d693e0fc1f'),('6931111a6a9dfc941','Process Job Queue q1',0,'Success','2025-12-04 04:43:00',1088598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:43:02','2025-12-04 04:43:02',1338873,1,NULL,NULL,NULL,'2025-12-04 04:42:02','2025-12-04 04:43:02','687bf57d8afb5c472'),('6931111aa2f6a5773','Process Job Queue e0',0,'Success','2025-12-04 04:42:02',1088599,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:42:09','2025-12-04 04:42:09',1338849,1,NULL,NULL,NULL,'2025-12-04 04:42:02','2025-12-04 04:42:09','687bf57dbba8299ef'),('6931111b33c53d55d','Send Email Reminders',0,'Success','2025-12-04 04:44:00',1088600,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:03','2025-12-04 04:44:03',1338895,1,NULL,NULL,NULL,'2025-12-04 04:42:03','2025-12-04 04:44:03','687bf5d44d3e10813'),('6931111be8ec026bc','Send Email Notifications',0,'Success','2025-12-04 04:44:00',1088601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:04','2025-12-04 04:44:04',1338895,1,NULL,NULL,NULL,'2025-12-04 04:42:03','2025-12-04 04:44:04','687bf5d466067a4ba'),('6931111c2032fc2c3','Auth Token Control',0,'Success','2025-12-04 04:48:00',1088602,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:04','2025-12-04 04:48:04',1338977,1,NULL,NULL,NULL,'2025-12-04 04:42:04','2025-12-04 04:48:04','687bf5d511e08c57f'),('6931111c58aacc8f1','Process Webhook Queue',0,'Success','2025-12-04 04:44:00',1088603,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:05','2025-12-04 04:44:05',1338895,1,NULL,NULL,NULL,'2025-12-04 04:42:04','2025-12-04 04:44:05','687bf5d5788e2fe0e'),('69311155a73002c62','Submit Popup Reminders',0,'Success','2025-12-04 04:43:01',1088604,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:43:03','2025-12-04 04:43:03',1338873,1,NULL,NULL,NULL,'2025-12-04 04:43:01','2025-12-04 04:43:03','687bf57d2f9463790'),('69311155d47b58745','Process Job Queue q0',0,'Success','2025-12-04 04:43:01',1088605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:43:04','2025-12-04 04:43:04',1338873,1,NULL,NULL,NULL,'2025-12-04 04:43:01','2025-12-04 04:43:04','687bf57d693e0fc1f'),('693111560c8bd564f','Process Job Queue q1',0,'Success','2025-12-04 04:44:00',1088606,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:05','2025-12-04 04:44:05',1338895,1,NULL,NULL,NULL,'2025-12-04 04:43:02','2025-12-04 04:44:05','687bf57d8afb5c472'),('69311156313809015','Process Job Queue e0',0,'Success','2025-12-04 04:43:02',1088607,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:43:05','2025-12-04 04:43:05',1338873,1,NULL,NULL,NULL,'2025-12-04 04:43:02','2025-12-04 04:43:05','687bf57dbba8299ef'),('69311191e47290df2','Submit Popup Reminders',0,'Success','2025-12-04 04:44:01',1088608,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:06','2025-12-04 04:44:06',1338895,1,NULL,NULL,NULL,'2025-12-04 04:44:01','2025-12-04 04:44:06','687bf57d2f9463790'),('693111921b69f88cb','Process Job Queue q0',0,'Success','2025-12-04 04:44:02',1088609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:07','2025-12-04 04:44:07',1338895,1,NULL,NULL,NULL,'2025-12-04 04:44:02','2025-12-04 04:44:07','687bf57d693e0fc1f'),('693111924a2415535','Process Job Queue q1',0,'Success','2025-12-04 04:45:00',1088610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:45:02','2025-12-04 04:45:03',1338911,1,NULL,NULL,NULL,'2025-12-04 04:44:02','2025-12-04 04:45:03','687bf57d8afb5c472'),('693111928f6e275fd','Process Job Queue e0',0,'Success','2025-12-04 04:44:02',1088611,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:44:08','2025-12-04 04:44:08',1338895,1,NULL,NULL,NULL,'2025-12-04 04:44:02','2025-12-04 04:44:08','687bf57dbba8299ef'),('69311192c9d031032','Send Email Reminders',0,'Success','2025-12-04 04:46:00',1088612,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:04','2025-12-04 04:46:04',1338938,1,NULL,NULL,NULL,'2025-12-04 04:44:02','2025-12-04 04:46:04','687bf5d44d3e10813'),('6931119328b5ebd28','Send Email Notifications',0,'Success','2025-12-04 04:46:00',1088613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:05','2025-12-04 04:46:05',1338938,1,NULL,NULL,NULL,'2025-12-04 04:44:03','2025-12-04 04:46:05','687bf5d466067a4ba'),('69311193593548bbf','Process Webhook Queue',0,'Success','2025-12-04 04:46:00',1088614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:05','2025-12-04 04:46:05',1338938,1,NULL,NULL,NULL,'2025-12-04 04:44:03','2025-12-04 04:46:05','687bf5d5788e2fe0e'),('693111ce0f16ee015','Submit Popup Reminders',0,'Success','2025-12-04 04:45:02',1088615,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:45:04','2025-12-04 04:45:04',1338911,1,NULL,NULL,NULL,'2025-12-04 04:45:02','2025-12-04 04:45:04','687bf57d2f9463790'),('693111ce3abd75884','Process Job Queue q0',0,'Success','2025-12-04 04:45:02',1088616,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:45:05','2025-12-04 04:45:05',1338911,1,NULL,NULL,NULL,'2025-12-04 04:45:02','2025-12-04 04:45:05','687bf57d693e0fc1f'),('693111ce691ecb17a','Process Job Queue q1',0,'Success','2025-12-04 04:46:00',1088617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:06','2025-12-04 04:46:06',1338938,1,NULL,NULL,NULL,'2025-12-04 04:45:02','2025-12-04 04:46:06','687bf57d8afb5c472'),('693111ce8d07dad72','Process Job Queue e0',0,'Success','2025-12-04 04:45:02',1088618,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:45:06','2025-12-04 04:45:06',1338911,1,NULL,NULL,NULL,'2025-12-04 04:45:02','2025-12-04 04:45:06','687bf57dbba8299ef'),('6931120a1bdf62d8f','Submit Popup Reminders',0,'Success','2025-12-04 04:46:02',1088619,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:07','2025-12-04 04:46:07',1338938,1,NULL,NULL,NULL,'2025-12-04 04:46:02','2025-12-04 04:46:07','687bf57d2f9463790'),('6931120a5203b853a','Process Job Queue q0',0,'Success','2025-12-04 04:46:02',1088620,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:08','2025-12-04 04:46:08',1338938,1,NULL,NULL,NULL,'2025-12-04 04:46:02','2025-12-04 04:46:08','687bf57d693e0fc1f'),('6931120a70263a459','Process Job Queue q1',0,'Success','2025-12-04 04:47:00',1088621,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:47:01','2025-12-04 04:47:02',1338955,1,NULL,NULL,NULL,'2025-12-04 04:46:02','2025-12-04 04:47:02','687bf57d8afb5c472'),('6931120a9a0bbd463','Process Job Queue e0',0,'Success','2025-12-04 04:46:02',1088622,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:46:08','2025-12-04 04:46:08',1338938,1,NULL,NULL,NULL,'2025-12-04 04:46:02','2025-12-04 04:46:08','687bf57dbba8299ef'),('6931120b78bee0902','Send Email Reminders',0,'Success','2025-12-04 04:48:00',1088623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:05','2025-12-04 04:48:05',1338977,1,NULL,NULL,NULL,'2025-12-04 04:46:03','2025-12-04 04:48:05','687bf5d44d3e10813'),('6931120ba941d68b7','Send Email Notifications',0,'Success','2025-12-04 04:48:00',1088624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:06','2025-12-04 04:48:06',1338977,1,NULL,NULL,NULL,'2025-12-04 04:46:03','2025-12-04 04:48:06','687bf5d466067a4ba'),('6931120c08df670d8','Process Webhook Queue',0,'Success','2025-12-04 04:48:00',1088625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:07','2025-12-04 04:48:07',1338977,1,NULL,NULL,NULL,'2025-12-04 04:46:04','2025-12-04 04:48:07','687bf5d5788e2fe0e'),('693112454a913cc3b','Submit Popup Reminders',0,'Success','2025-12-04 04:47:01',1088626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:47:02','2025-12-04 04:47:03',1338955,1,NULL,NULL,NULL,'2025-12-04 04:47:01','2025-12-04 04:47:03','687bf57d2f9463790'),('693112456f6f5211b','Process Job Queue q0',0,'Success','2025-12-04 04:47:01',1088627,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:47:03','2025-12-04 04:47:04',1338955,1,NULL,NULL,NULL,'2025-12-04 04:47:01','2025-12-04 04:47:04','687bf57d693e0fc1f'),('6931124594f264721','Process Job Queue q1',0,'Success','2025-12-04 04:48:00',1088628,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:07','2025-12-04 04:48:07',1338977,1,NULL,NULL,NULL,'2025-12-04 04:47:01','2025-12-04 04:48:07','687bf57d8afb5c472'),('69311245b4bd9abdb','Process Job Queue e0',0,'Success','2025-12-04 04:47:01',1088629,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:47:04','2025-12-04 04:47:04',1338955,1,NULL,NULL,NULL,'2025-12-04 04:47:01','2025-12-04 04:47:04','687bf57dbba8299ef'),('693112820bc49160a','Submit Popup Reminders',0,'Success','2025-12-04 04:48:02',1088630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:08','2025-12-04 04:48:08',1338977,1,NULL,NULL,NULL,'2025-12-04 04:48:02','2025-12-04 04:48:08','687bf57d2f9463790'),('693112824ad4be54d','Process Job Queue q0',0,'Success','2025-12-04 04:48:02',1088631,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:09','2025-12-04 04:48:09',1338977,1,NULL,NULL,NULL,'2025-12-04 04:48:02','2025-12-04 04:48:09','687bf57d693e0fc1f'),('69311282771dfafc6','Process Job Queue q1',0,'Success','2025-12-04 04:49:00',1088632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:49:02','2025-12-04 04:49:02',1338999,1,NULL,NULL,NULL,'2025-12-04 04:48:02','2025-12-04 04:49:02','687bf57d8afb5c472'),('693112829d0c54e03','Process Job Queue e0',0,'Success','2025-12-04 04:48:02',1088633,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:48:10','2025-12-04 04:48:10',1338977,1,NULL,NULL,NULL,'2025-12-04 04:48:02','2025-12-04 04:48:10','687bf57dbba8299ef'),('69311282e0322bd81','Send Email Reminders',0,'Success','2025-12-04 04:50:00',1088634,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:05','2025-12-04 04:50:05',1339017,1,NULL,NULL,NULL,'2025-12-04 04:48:02','2025-12-04 04:50:05','687bf5d44d3e10813'),('6931128315c713e90','Send Email Notifications',0,'Success','2025-12-04 04:50:00',1088635,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:05','2025-12-04 04:50:05',1339017,1,NULL,NULL,NULL,'2025-12-04 04:48:03','2025-12-04 04:50:05','687bf5d466067a4ba'),('6931128369733487f','Auth Token Control',0,'Success','2025-12-04 04:54:00',1088636,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:04','2025-12-04 04:54:04',1339102,1,NULL,NULL,NULL,'2025-12-04 04:48:03','2025-12-04 04:54:04','687bf5d511e08c57f'),('69311283d9a16cc16','Process Webhook Queue',0,'Success','2025-12-04 04:50:00',1088637,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:06','2025-12-04 04:50:06',1339017,1,NULL,NULL,NULL,'2025-12-04 04:48:03','2025-12-04 04:50:06','687bf5d5788e2fe0e'),('693112bd78b8e1340','Submit Popup Reminders',0,'Success','2025-12-04 04:49:01',1088638,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:49:03','2025-12-04 04:49:03',1338999,1,NULL,NULL,NULL,'2025-12-04 04:49:01','2025-12-04 04:49:03','687bf57d2f9463790'),('693112bda32625d8b','Process Job Queue q0',0,'Success','2025-12-04 04:49:01',1088639,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:49:04','2025-12-04 04:49:04',1338999,1,NULL,NULL,NULL,'2025-12-04 04:49:01','2025-12-04 04:49:04','687bf57d693e0fc1f'),('693112bdcff7b0b6a','Process Job Queue q1',0,'Success','2025-12-04 04:50:00',1088640,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:06','2025-12-04 04:50:07',1339017,1,NULL,NULL,NULL,'2025-12-04 04:49:01','2025-12-04 04:50:07','687bf57d8afb5c472'),('693112bdebc6d71ae','Process Job Queue e0',0,'Success','2025-12-04 04:49:01',1088641,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:49:05','2025-12-04 04:49:05',1338999,1,NULL,NULL,NULL,'2025-12-04 04:49:01','2025-12-04 04:49:05','687bf57dbba8299ef'),('693112f95c6229294','Submit Popup Reminders',0,'Success','2025-12-04 04:50:01',1088642,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:07','2025-12-04 04:50:07',1339017,1,NULL,NULL,NULL,'2025-12-04 04:50:01','2025-12-04 04:50:07','687bf57d2f9463790'),('693112f9b7ada5177','Process Job Queue q0',0,'Success','2025-12-04 04:50:01',1088643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:08','2025-12-04 04:50:08',1339017,1,NULL,NULL,NULL,'2025-12-04 04:50:01','2025-12-04 04:50:08','687bf57d693e0fc1f'),('693112f9e471ad8f4','Process Job Queue q1',0,'Success','2025-12-04 04:51:00',1088644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:51:02','2025-12-04 04:51:03',1339039,1,NULL,NULL,NULL,'2025-12-04 04:50:01','2025-12-04 04:51:03','687bf57d8afb5c472'),('693112fa256729c0a','Process Job Queue e0',0,'Success','2025-12-04 04:50:02',1088645,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:50:09','2025-12-04 04:50:09',1339017,1,NULL,NULL,NULL,'2025-12-04 04:50:02','2025-12-04 04:50:09','687bf57dbba8299ef'),('693112faa7c0ad886','Send Email Reminders',0,'Success','2025-12-04 04:52:00',1088646,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:03','2025-12-04 04:52:03',1339057,1,NULL,NULL,NULL,'2025-12-04 04:50:02','2025-12-04 04:52:03','687bf5d44d3e10813'),('693112fad6d960539','Send Email Notifications',0,'Success','2025-12-04 04:52:00',1088647,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:04','2025-12-04 04:52:04',1339057,1,NULL,NULL,NULL,'2025-12-04 04:50:02','2025-12-04 04:52:04','687bf5d466067a4ba'),('693112fb12dc3a749','Send Mass Emails',0,'Success','2025-12-04 05:10:00',1088648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:04','2025-12-04 05:10:04',1339516,1,NULL,NULL,NULL,'2025-12-04 04:50:03','2025-12-04 05:10:04','687bf5d4b535f913f'),('693112fb2fa5b39d7','Process Webhook Queue',0,'Success','2025-12-04 04:52:00',1088649,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:04','2025-12-04 04:52:05',1339057,1,NULL,NULL,NULL,'2025-12-04 04:50:03','2025-12-04 04:52:05','687bf5d5788e2fe0e'),('693112fb550837935','Send Scheduled Emails',0,'Success','2025-12-04 05:00:00',1088650,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:03','2025-12-04 05:00:04',1339235,1,NULL,NULL,NULL,'2025-12-04 04:50:03','2025-12-04 05:00:04','687bf5d5eeb01d80d'),('69311335abb43eea8','Submit Popup Reminders',0,'Success','2025-12-04 04:51:01',1088651,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:51:04','2025-12-04 04:51:04',1339039,1,NULL,NULL,NULL,'2025-12-04 04:51:01','2025-12-04 04:51:04','687bf57d2f9463790'),('69311335cf836b672','Process Job Queue q0',0,'Success','2025-12-04 04:51:01',1088652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:51:04','2025-12-04 04:51:04',1339039,1,NULL,NULL,NULL,'2025-12-04 04:51:01','2025-12-04 04:51:04','687bf57d693e0fc1f'),('6931133616ce16771','Process Job Queue q1',0,'Success','2025-12-04 04:52:00',1088653,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:05','2025-12-04 04:52:05',1339057,1,NULL,NULL,NULL,'2025-12-04 04:51:02','2025-12-04 04:52:05','687bf57d8afb5c472'),('6931133652f3cde5a','Process Job Queue e0',0,'Success','2025-12-04 04:51:02',1088654,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:51:05','2025-12-04 04:51:05',1339039,1,NULL,NULL,NULL,'2025-12-04 04:51:02','2025-12-04 04:51:05','687bf57dbba8299ef'),('69311371919512e9a','Submit Popup Reminders',0,'Success','2025-12-04 04:52:01',1088655,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:06','2025-12-04 04:52:06',1339057,1,NULL,NULL,NULL,'2025-12-04 04:52:01','2025-12-04 04:52:06','687bf57d2f9463790'),('69311371ca7172c0d','Process Job Queue q0',0,'Success','2025-12-04 04:52:01',1088656,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:07','2025-12-04 04:52:07',1339057,1,NULL,NULL,NULL,'2025-12-04 04:52:01','2025-12-04 04:52:07','687bf57d693e0fc1f'),('693113720638b499d','Process Job Queue q1',0,'Success','2025-12-04 04:53:00',1088657,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:53:02','2025-12-04 04:53:02',1339078,1,NULL,NULL,NULL,'2025-12-04 04:52:02','2025-12-04 04:53:02','687bf57d8afb5c472'),('693113729f181ad3f','Process Job Queue e0',0,'Success','2025-12-04 04:52:02',1088658,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:52:07','2025-12-04 04:52:07',1339057,1,NULL,NULL,NULL,'2025-12-04 04:52:02','2025-12-04 04:52:07','687bf57dbba8299ef'),('693113731006517c3','Send Email Reminders',0,'Success','2025-12-04 04:54:00',1088659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:05','2025-12-04 04:54:05',1339102,1,NULL,NULL,NULL,'2025-12-04 04:52:03','2025-12-04 04:54:05','687bf5d44d3e10813'),('693113734c82d8651','Send Email Notifications',0,'Success','2025-12-04 04:54:00',1088660,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:05','2025-12-04 04:54:05',1339102,1,NULL,NULL,NULL,'2025-12-04 04:52:03','2025-12-04 04:54:05','687bf5d466067a4ba'),('693113736aa2361fa','Process Webhook Queue',0,'Success','2025-12-04 04:54:00',1088661,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:06','2025-12-04 04:54:06',1339102,1,NULL,NULL,NULL,'2025-12-04 04:52:03','2025-12-04 04:54:06','687bf5d5788e2fe0e'),('693113ad5417fc734','Submit Popup Reminders',0,'Success','2025-12-04 04:53:01',1088662,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:53:03','2025-12-04 04:53:04',1339078,1,NULL,NULL,NULL,'2025-12-04 04:53:01','2025-12-04 04:53:04','687bf57d2f9463790'),('693113ad8d6660ad0','Process Job Queue q0',0,'Success','2025-12-04 04:53:01',1088663,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:53:04','2025-12-04 04:53:04',1339078,1,NULL,NULL,NULL,'2025-12-04 04:53:01','2025-12-04 04:53:04','687bf57d693e0fc1f'),('693113adbc4faaf5e','Process Job Queue q1',0,'Success','2025-12-04 04:54:00',1088664,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:07','2025-12-04 04:54:07',1339102,1,NULL,NULL,NULL,'2025-12-04 04:53:01','2025-12-04 04:54:07','687bf57d8afb5c472'),('693113adf06461faf','Process Job Queue e0',0,'Success','2025-12-04 04:53:01',1088665,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:53:05','2025-12-04 04:53:05',1339078,1,NULL,NULL,NULL,'2025-12-04 04:53:01','2025-12-04 04:53:05','687bf57dbba8299ef'),('693113ea050cdcc22','Submit Popup Reminders',0,'Success','2025-12-04 04:54:02',1088666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:08','2025-12-04 04:54:08',1339102,1,NULL,NULL,NULL,'2025-12-04 04:54:02','2025-12-04 04:54:08','687bf57d2f9463790'),('693113ea44f08e42a','Process Job Queue q0',0,'Success','2025-12-04 04:54:02',1088667,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:08','2025-12-04 04:54:08',1339102,1,NULL,NULL,NULL,'2025-12-04 04:54:02','2025-12-04 04:54:08','687bf57d693e0fc1f'),('693113ea79334b31d','Process Job Queue q1',0,'Success','2025-12-04 04:55:00',1088668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:55:02','2025-12-04 04:55:02',1339119,1,NULL,NULL,NULL,'2025-12-04 04:54:02','2025-12-04 04:55:02','687bf57d8afb5c472'),('693113eac9443f15d','Process Job Queue e0',0,'Success','2025-12-04 04:54:02',1088669,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:54:09','2025-12-04 04:54:09',1339102,1,NULL,NULL,NULL,'2025-12-04 04:54:02','2025-12-04 04:54:09','687bf57dbba8299ef'),('693113eb8c9f0ec05','Send Email Reminders',0,'Success','2025-12-04 04:56:00',1088670,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:03','2025-12-04 04:56:03',1339143,1,NULL,NULL,NULL,'2025-12-04 04:54:03','2025-12-04 04:56:03','687bf5d44d3e10813'),('693113ebb71f07ccd','Send Email Notifications',0,'Success','2025-12-04 04:56:00',1088671,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:04','2025-12-04 04:56:04',1339143,1,NULL,NULL,NULL,'2025-12-04 04:54:03','2025-12-04 04:56:04','687bf5d466067a4ba'),('693113ebdf4cb9471','Auth Token Control',0,'Success','2025-12-04 05:00:00',1088672,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:05','2025-12-04 05:00:05',1339235,1,NULL,NULL,NULL,'2025-12-04 04:54:03','2025-12-04 05:00:05','687bf5d511e08c57f'),('693113ec0da7f480b','Process Webhook Queue',0,'Success','2025-12-04 04:56:00',1088673,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:04','2025-12-04 04:56:04',1339143,1,NULL,NULL,NULL,'2025-12-04 04:54:04','2025-12-04 04:56:04','687bf5d5788e2fe0e'),('693114256c8a94645','Submit Popup Reminders',0,'Success','2025-12-04 04:55:01',1088674,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:55:03','2025-12-04 04:55:03',1339119,1,NULL,NULL,NULL,'2025-12-04 04:55:01','2025-12-04 04:55:03','687bf57d2f9463790'),('693114259b6ca378c','Process Job Queue q0',0,'Success','2025-12-04 04:55:01',1088675,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:55:04','2025-12-04 04:55:04',1339119,1,NULL,NULL,NULL,'2025-12-04 04:55:01','2025-12-04 04:55:04','687bf57d693e0fc1f'),('69311425cc31c16b7','Process Job Queue q1',0,'Success','2025-12-04 04:56:00',1088676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:05','2025-12-04 04:56:05',1339143,1,NULL,NULL,NULL,'2025-12-04 04:55:01','2025-12-04 04:56:05','687bf57d8afb5c472'),('6931142616d22a905','Process Job Queue e0',0,'Success','2025-12-04 04:55:02',1088677,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:55:05','2025-12-04 04:55:05',1339119,1,NULL,NULL,NULL,'2025-12-04 04:55:02','2025-12-04 04:55:05','687bf57dbba8299ef'),('6931146165e5a7995','Submit Popup Reminders',0,'Success','2025-12-04 04:56:01',1088678,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:06','2025-12-04 04:56:06',1339143,1,NULL,NULL,NULL,'2025-12-04 04:56:01','2025-12-04 04:56:06','687bf57d2f9463790'),('69311461b5e4fbf50','Process Job Queue q0',0,'Success','2025-12-04 04:56:01',1088679,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:06','2025-12-04 04:56:07',1339143,1,NULL,NULL,NULL,'2025-12-04 04:56:01','2025-12-04 04:56:07','687bf57d693e0fc1f'),('693114622f7e8ec28','Process Job Queue q1',0,'Success','2025-12-04 04:57:00',1088680,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:57:02','2025-12-04 04:57:02',1339165,1,NULL,NULL,NULL,'2025-12-04 04:56:02','2025-12-04 04:57:02','687bf57d8afb5c472'),('6931146281297c0da','Process Job Queue e0',0,'Success','2025-12-04 04:56:02',1088681,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:56:07','2025-12-04 04:56:07',1339143,1,NULL,NULL,NULL,'2025-12-04 04:56:02','2025-12-04 04:56:07','687bf57dbba8299ef'),('69311462bd24fcc9a','Send Email Reminders',0,'Success','2025-12-04 04:58:00',1088682,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:02','2025-12-04 04:58:03',1339187,1,NULL,NULL,NULL,'2025-12-04 04:56:02','2025-12-04 04:58:03','687bf5d44d3e10813'),('69311462f3fc7f5ed','Send Email Notifications',0,'Success','2025-12-04 04:58:00',1088683,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:04','2025-12-04 04:58:04',1339187,1,NULL,NULL,NULL,'2025-12-04 04:56:02','2025-12-04 04:58:04','687bf5d466067a4ba'),('69311463267ab03f9','Process Webhook Queue',0,'Success','2025-12-04 04:58:00',1088684,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:05','2025-12-04 04:58:05',1339187,1,NULL,NULL,NULL,'2025-12-04 04:56:03','2025-12-04 04:58:05','687bf5d5788e2fe0e'),('6931149dab438ece3','Submit Popup Reminders',0,'Success','2025-12-04 04:57:01',1088685,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:57:03','2025-12-04 04:57:04',1339165,1,NULL,NULL,NULL,'2025-12-04 04:57:01','2025-12-04 04:57:04','687bf57d2f9463790'),('6931149ddba47a89f','Process Job Queue q0',0,'Success','2025-12-04 04:57:01',1088686,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:57:04','2025-12-04 04:57:04',1339165,1,NULL,NULL,NULL,'2025-12-04 04:57:01','2025-12-04 04:57:04','687bf57d693e0fc1f'),('6931149e0902bcb0e','Process Job Queue q1',0,'Success','2025-12-04 04:58:00',1088687,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:05','2025-12-04 04:58:06',1339187,1,NULL,NULL,NULL,'2025-12-04 04:57:02','2025-12-04 04:58:06','687bf57d8afb5c472'),('6931149e39feff2f7','Process Job Queue e0',0,'Success','2025-12-04 04:57:02',1088688,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:57:05','2025-12-04 04:57:05',1339165,1,NULL,NULL,NULL,'2025-12-04 04:57:02','2025-12-04 04:57:05','687bf57dbba8299ef'),('693114d9812d4d84f','Submit Popup Reminders',0,'Success','2025-12-04 04:58:01',1088689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:07','2025-12-04 04:58:07',1339187,1,NULL,NULL,NULL,'2025-12-04 04:58:01','2025-12-04 04:58:07','687bf57d2f9463790'),('693114d9a78fd7e86','Process Job Queue q0',0,'Success','2025-12-04 04:58:01',1088690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:07','2025-12-04 04:58:08',1339187,1,NULL,NULL,NULL,'2025-12-04 04:58:01','2025-12-04 04:58:08','687bf57d693e0fc1f'),('693114d9c60eb7270','Process Job Queue q1',0,'Success','2025-12-04 04:59:00',1088691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:59:02','2025-12-04 04:59:03',1339213,1,NULL,NULL,NULL,'2025-12-04 04:58:01','2025-12-04 04:59:03','687bf57d8afb5c472'),('693114d9f4022e47c','Process Job Queue e0',0,'Success','2025-12-04 04:58:01',1088692,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:58:08','2025-12-04 04:58:08',1339187,1,NULL,NULL,NULL,'2025-12-04 04:58:01','2025-12-04 04:58:08','687bf57dbba8299ef'),('693114da25033880d','Send Email Reminders',0,'Success','2025-12-04 05:00:00',1088693,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:05','2025-12-04 05:00:05',1339235,1,NULL,NULL,NULL,'2025-12-04 04:58:02','2025-12-04 05:00:05','687bf5d44d3e10813'),('693114da4421935cf','Send Email Notifications',0,'Success','2025-12-04 05:00:00',1088694,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:06','2025-12-04 05:00:06',1339235,1,NULL,NULL,NULL,'2025-12-04 04:58:02','2025-12-04 05:00:06','687bf5d466067a4ba'),('693114da76f912e05','Process Webhook Queue',0,'Success','2025-12-04 05:00:00',1088695,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:07','2025-12-04 05:00:07',1339235,1,NULL,NULL,NULL,'2025-12-04 04:58:02','2025-12-04 05:00:07','687bf5d5788e2fe0e'),('6931151570b2868cb','Submit Popup Reminders',0,'Success','2025-12-04 04:59:01',1088696,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:59:03','2025-12-04 04:59:03',1339213,1,NULL,NULL,NULL,'2025-12-04 04:59:01','2025-12-04 04:59:03','687bf57d2f9463790'),('69311515a7b8607c4','Process Job Queue q0',0,'Success','2025-12-04 04:59:01',1088697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:59:04','2025-12-04 04:59:04',1339213,1,NULL,NULL,NULL,'2025-12-04 04:59:01','2025-12-04 04:59:04','687bf57d693e0fc1f'),('69311515f1961651f','Process Job Queue q1',0,'Success','2025-12-04 05:00:00',1088698,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:07','2025-12-04 05:00:08',1339235,1,NULL,NULL,NULL,'2025-12-04 04:59:01','2025-12-04 05:00:08','687bf57d8afb5c472'),('69311516333971437','Process Job Queue e0',0,'Success','2025-12-04 04:59:02',1088699,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 04:59:05','2025-12-04 04:59:05',1339213,1,NULL,NULL,NULL,'2025-12-04 04:59:02','2025-12-04 04:59:05','687bf57dbba8299ef'),('693115517636accac','Submit Popup Reminders',0,'Success','2025-12-04 05:00:01',1088700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:08','2025-12-04 05:00:08',1339235,1,NULL,NULL,NULL,'2025-12-04 05:00:01','2025-12-04 05:00:08','687bf57d2f9463790'),('69311551923e730bc','Process Job Queue q0',0,'Success','2025-12-04 05:00:01',1088701,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:09','2025-12-04 05:00:09',1339235,1,NULL,NULL,NULL,'2025-12-04 05:00:01','2025-12-04 05:00:09','687bf57d693e0fc1f'),('69311551b4ca88a71','Process Job Queue q1',0,'Success','2025-12-04 05:01:00',1088702,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:01:02','2025-12-04 05:01:02',1339258,1,NULL,NULL,NULL,'2025-12-04 05:00:01','2025-12-04 05:01:02','687bf57d8afb5c472'),('69311551d48ebcc4e','Process Job Queue e0',0,'Success','2025-12-04 05:00:01',1088703,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:00:10','2025-12-04 05:00:10',1339235,1,NULL,NULL,NULL,'2025-12-04 05:00:01','2025-12-04 05:00:10','687bf57dbba8299ef'),('693115521c8e4cac2','Send Email Reminders',0,'Success','2025-12-04 05:02:00',1088704,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:03','2025-12-04 05:02:03',1339274,1,NULL,NULL,NULL,'2025-12-04 05:00:02','2025-12-04 05:02:03','687bf5d44d3e10813'),('6931155273c5f8b7d','Send Email Notifications',0,'Success','2025-12-04 05:02:00',1088705,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:04','2025-12-04 05:02:04',1339274,1,NULL,NULL,NULL,'2025-12-04 05:00:02','2025-12-04 05:02:04','687bf5d466067a4ba'),('69311552adba0668f','Auth Token Control',0,'Success','2025-12-04 05:06:00',1088706,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:03','2025-12-04 05:06:03',1339363,1,NULL,NULL,NULL,'2025-12-04 05:00:02','2025-12-04 05:06:03','687bf5d511e08c57f'),('69311552d649d6870','Process Webhook Queue',0,'Success','2025-12-04 05:02:00',1088707,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:05','2025-12-04 05:02:05',1339274,1,NULL,NULL,NULL,'2025-12-04 05:00:02','2025-12-04 05:02:05','687bf5d5788e2fe0e'),('69311553148c97342','Send Scheduled Emails',0,'Success','2025-12-04 05:10:00',1088708,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:04','2025-12-04 05:10:05',1339516,1,NULL,NULL,NULL,'2025-12-04 05:00:03','2025-12-04 05:10:05','687bf5d5eeb01d80d'),('6931158d89a9f6265','Submit Popup Reminders',0,'Success','2025-12-04 05:01:01',1088709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:01:02','2025-12-04 05:01:03',1339258,1,NULL,NULL,NULL,'2025-12-04 05:01:01','2025-12-04 05:01:03','687bf57d2f9463790'),('6931158db2225c353','Process Job Queue q0',0,'Success','2025-12-04 05:01:01',1088710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:01:04','2025-12-04 05:01:04',1339258,1,NULL,NULL,NULL,'2025-12-04 05:01:01','2025-12-04 05:01:04','687bf57d693e0fc1f'),('6931158dd635b9f07','Process Job Queue q1',0,'Success','2025-12-04 05:02:00',1088711,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:05','2025-12-04 05:02:05',1339274,1,NULL,NULL,NULL,'2025-12-04 05:01:01','2025-12-04 05:02:05','687bf57d8afb5c472'),('6931158e04b7c4871','Process Job Queue e0',0,'Success','2025-12-04 05:01:02',1088712,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:01:05','2025-12-04 05:01:05',1339258,1,NULL,NULL,NULL,'2025-12-04 05:01:02','2025-12-04 05:01:05','687bf57dbba8299ef'),('693115c940bacb5e4','Submit Popup Reminders',0,'Success','2025-12-04 05:02:01',1088713,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:06','2025-12-04 05:02:06',1339274,1,NULL,NULL,NULL,'2025-12-04 05:02:01','2025-12-04 05:02:06','687bf57d2f9463790'),('693115c98050ceb57','Process Job Queue q0',0,'Success','2025-12-04 05:02:01',1088714,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:07','2025-12-04 05:02:07',1339274,1,NULL,NULL,NULL,'2025-12-04 05:02:01','2025-12-04 05:02:07','687bf57d693e0fc1f'),('693115c9a7ef0b011','Process Job Queue q1',0,'Success','2025-12-04 05:03:00',1088715,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:03:02','2025-12-04 05:03:02',1339294,1,NULL,NULL,NULL,'2025-12-04 05:02:01','2025-12-04 05:03:02','687bf57d8afb5c472'),('693115c9c89929cd2','Process Job Queue e0',0,'Success','2025-12-04 05:02:01',1088716,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:02:08','2025-12-04 05:02:08',1339274,1,NULL,NULL,NULL,'2025-12-04 05:02:01','2025-12-04 05:02:08','687bf57dbba8299ef'),('693115ca0fee48678','Send Email Reminders',0,'Success','2025-12-04 05:04:00',1088717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:03','2025-12-04 05:04:03',1339320,1,NULL,NULL,NULL,'2025-12-04 05:02:02','2025-12-04 05:04:03','687bf5d44d3e10813'),('693115ca5791e5d0a','Send Email Notifications',0,'Success','2025-12-04 05:04:00',1088718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:04','2025-12-04 05:04:04',1339320,1,NULL,NULL,NULL,'2025-12-04 05:02:02','2025-12-04 05:04:04','687bf5d466067a4ba'),('693115caeb37bed44','Process Webhook Queue',0,'Success','2025-12-04 05:04:00',1088719,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:05','2025-12-04 05:04:05',1339320,1,NULL,NULL,NULL,'2025-12-04 05:02:02','2025-12-04 05:04:05','687bf5d5788e2fe0e'),('693116054cf48d35f','Submit Popup Reminders',0,'Success','2025-12-04 05:03:01',1088720,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:03:03','2025-12-04 05:03:04',1339294,1,NULL,NULL,NULL,'2025-12-04 05:03:01','2025-12-04 05:03:04','687bf57d2f9463790'),('693116057cfca91b4','Process Job Queue q0',0,'Success','2025-12-04 05:03:01',1088721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:03:04','2025-12-04 05:03:04',1339294,1,NULL,NULL,NULL,'2025-12-04 05:03:01','2025-12-04 05:03:04','687bf57d693e0fc1f'),('6931160599a17f0a4','Process Job Queue q1',0,'Success','2025-12-04 05:04:00',1088722,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:05','2025-12-04 05:04:05',1339320,1,NULL,NULL,NULL,'2025-12-04 05:03:01','2025-12-04 05:04:05','687bf57d8afb5c472'),('69311605cbe1f18a6','Process Job Queue e0',0,'Success','2025-12-04 05:03:01',1088723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:03:05','2025-12-04 05:03:05',1339294,1,NULL,NULL,NULL,'2025-12-04 05:03:01','2025-12-04 05:03:05','687bf57dbba8299ef'),('693116416f37b183d','Submit Popup Reminders',0,'Success','2025-12-04 05:04:01',1088724,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:06','2025-12-04 05:04:06',1339320,1,NULL,NULL,NULL,'2025-12-04 05:04:01','2025-12-04 05:04:06','687bf57d2f9463790'),('69311641b0a157edd','Process Job Queue q0',0,'Success','2025-12-04 05:04:01',1088725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:07','2025-12-04 05:04:07',1339320,1,NULL,NULL,NULL,'2025-12-04 05:04:01','2025-12-04 05:04:07','687bf57d693e0fc1f'),('69311641cf376729d','Process Job Queue q1',0,'Success','2025-12-04 05:05:00',1088726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:05:02','2025-12-04 05:05:03',1339339,1,NULL,NULL,NULL,'2025-12-04 05:04:01','2025-12-04 05:05:03','687bf57d8afb5c472'),('6931164204d750d28','Process Job Queue e0',0,'Success','2025-12-04 05:04:02',1088727,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:04:07','2025-12-04 05:04:07',1339320,1,NULL,NULL,NULL,'2025-12-04 05:04:02','2025-12-04 05:04:07','687bf57dbba8299ef'),('6931164238f460353','Send Email Reminders',0,'Success','2025-12-04 05:06:00',1088728,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:04','2025-12-04 05:06:04',1339363,1,NULL,NULL,NULL,'2025-12-04 05:04:02','2025-12-04 05:06:04','687bf5d44d3e10813'),('6931164273541bdbe','Send Email Notifications',0,'Success','2025-12-04 05:06:00',1088729,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:04','2025-12-04 05:06:05',1339363,1,NULL,NULL,NULL,'2025-12-04 05:04:02','2025-12-04 05:06:05','687bf5d466067a4ba'),('693116431bba49ba3','Process Webhook Queue',0,'Success','2025-12-04 05:06:00',1088730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:05','2025-12-04 05:06:05',1339363,1,NULL,NULL,NULL,'2025-12-04 05:04:03','2025-12-04 05:06:05','687bf5d5788e2fe0e'),('6931167db7183b7c1','Submit Popup Reminders',0,'Success','2025-12-04 05:05:01',1088731,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:05:03','2025-12-04 05:05:04',1339339,1,NULL,NULL,NULL,'2025-12-04 05:05:01','2025-12-04 05:05:04','687bf57d2f9463790'),('6931167de70ae5b23','Process Job Queue q0',0,'Success','2025-12-04 05:05:01',1088732,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:05:04','2025-12-04 05:05:05',1339339,1,NULL,NULL,NULL,'2025-12-04 05:05:01','2025-12-04 05:05:05','687bf57d693e0fc1f'),('6931167e105d8bd8b','Process Job Queue q1',0,'Success','2025-12-04 05:06:00',1088733,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:06','2025-12-04 05:06:06',1339363,1,NULL,NULL,NULL,'2025-12-04 05:05:02','2025-12-04 05:06:06','687bf57d8afb5c472'),('6931167e4a302d7b0','Process Job Queue e0',0,'Success','2025-12-04 05:05:02',1088734,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:05:05','2025-12-04 05:05:05',1339339,1,NULL,NULL,NULL,'2025-12-04 05:05:02','2025-12-04 05:05:05','687bf57dbba8299ef'),('693116b959d9d791c','Submit Popup Reminders',0,'Success','2025-12-04 05:06:01',1088735,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:07','2025-12-04 05:06:07',1339363,1,NULL,NULL,NULL,'2025-12-04 05:06:01','2025-12-04 05:06:07','687bf57d2f9463790'),('693116b981e8fb6de','Process Job Queue q0',0,'Success','2025-12-04 05:06:01',1088736,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:07','2025-12-04 05:06:07',1339363,1,NULL,NULL,NULL,'2025-12-04 05:06:01','2025-12-04 05:06:07','687bf57d693e0fc1f'),('693116b9a7f059705','Process Job Queue q1',0,'Success','2025-12-04 05:07:00',1088737,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:07:02','2025-12-04 05:07:03',1339382,1,NULL,NULL,NULL,'2025-12-04 05:06:01','2025-12-04 05:07:03','687bf57d8afb5c472'),('693116ba50f887ccf','Process Job Queue e0',0,'Success','2025-12-04 05:06:02',1088738,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:06:08','2025-12-04 05:06:08',1339363,1,NULL,NULL,NULL,'2025-12-04 05:06:02','2025-12-04 05:06:08','687bf57dbba8299ef'),('693116baaef09f4f3','Send Email Reminders',0,'Success','2025-12-04 05:08:00',1088739,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:02','2025-12-04 05:08:03',1339400,1,NULL,NULL,NULL,'2025-12-04 05:06:02','2025-12-04 05:08:03','687bf5d44d3e10813'),('693116baf0a08b556','Send Email Notifications',0,'Success','2025-12-04 05:08:00',1088740,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:03','2025-12-04 05:08:04',1339400,1,NULL,NULL,NULL,'2025-12-04 05:06:02','2025-12-04 05:08:04','687bf5d466067a4ba'),('693116bb377f4bfc3','Auth Token Control',0,'Success','2025-12-04 05:12:00',1088741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:03','2025-12-04 05:12:04',1339551,1,NULL,NULL,NULL,'2025-12-04 05:06:03','2025-12-04 05:12:04','687bf5d511e08c57f'),('693116bb65481307b','Process Webhook Queue',0,'Success','2025-12-04 05:08:00',1088742,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:04','2025-12-04 05:08:05',1339400,1,NULL,NULL,NULL,'2025-12-04 05:06:03','2025-12-04 05:08:05','687bf5d5788e2fe0e'),('693116f590ad2cb73','Submit Popup Reminders',0,'Success','2025-12-04 05:07:01',1088743,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:07:03','2025-12-04 05:07:03',1339382,1,NULL,NULL,NULL,'2025-12-04 05:07:01','2025-12-04 05:07:03','687bf57d2f9463790'),('693116f5b8f99687c','Process Job Queue q0',0,'Success','2025-12-04 05:07:01',1088744,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:07:04','2025-12-04 05:07:04',1339382,1,NULL,NULL,NULL,'2025-12-04 05:07:01','2025-12-04 05:07:04','687bf57d693e0fc1f'),('693116f5ed182c4a5','Process Job Queue q1',0,'Success','2025-12-04 05:08:00',1088745,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:05','2025-12-04 05:08:06',1339400,1,NULL,NULL,NULL,'2025-12-04 05:07:01','2025-12-04 05:08:06','687bf57d8afb5c472'),('693116f63851fbbee','Process Job Queue e0',0,'Success','2025-12-04 05:07:02',1088746,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:07:05','2025-12-04 05:07:05',1339382,1,NULL,NULL,NULL,'2025-12-04 05:07:02','2025-12-04 05:07:05','687bf57dbba8299ef'),('693117319fc612863','Submit Popup Reminders',0,'Success','2025-12-04 05:08:01',1088747,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:07','2025-12-04 05:08:07',1339400,1,NULL,NULL,NULL,'2025-12-04 05:08:01','2025-12-04 05:08:07','687bf57d2f9463790'),('69311731c80559d7a','Process Job Queue q0',0,'Success','2025-12-04 05:08:01',1088748,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:07','2025-12-04 05:08:08',1339400,1,NULL,NULL,NULL,'2025-12-04 05:08:01','2025-12-04 05:08:08','687bf57d693e0fc1f'),('69311731ecd95591d','Process Job Queue q1',0,'Success','2025-12-04 05:09:00',1088749,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:09:02','2025-12-04 05:09:03',1339427,1,NULL,NULL,NULL,'2025-12-04 05:08:01','2025-12-04 05:09:03','687bf57d8afb5c472'),('69311732165e13087','Process Job Queue e0',0,'Success','2025-12-04 05:08:02',1088750,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:08:08','2025-12-04 05:08:08',1339400,1,NULL,NULL,NULL,'2025-12-04 05:08:02','2025-12-04 05:08:08','687bf57dbba8299ef'),('6931173241ab488bf','Send Email Reminders',0,'Success','2025-12-04 05:10:00',1088751,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:05','2025-12-04 05:10:05',1339516,1,NULL,NULL,NULL,'2025-12-04 05:08:02','2025-12-04 05:10:05','687bf5d44d3e10813'),('69311732709e4ca5f','Send Email Notifications',0,'Success','2025-12-04 05:10:00',1088752,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:06','2025-12-04 05:10:06',1339516,1,NULL,NULL,NULL,'2025-12-04 05:08:02','2025-12-04 05:10:06','687bf5d466067a4ba'),('693117328ebe16155','Process Webhook Queue',0,'Success','2025-12-04 05:10:00',1088753,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:07','2025-12-04 05:10:07',1339516,1,NULL,NULL,NULL,'2025-12-04 05:08:02','2025-12-04 05:10:07','687bf5d5788e2fe0e'),('6931176e03e9c6703','Submit Popup Reminders',0,'Success','2025-12-04 05:09:02',1088754,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:09:04','2025-12-04 05:09:04',1339427,1,NULL,NULL,NULL,'2025-12-04 05:09:02','2025-12-04 05:09:04','687bf57d2f9463790'),('6931176e2d55bd1c6','Process Job Queue q0',0,'Success','2025-12-04 05:09:02',1088755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:09:05','2025-12-04 05:09:05',1339427,1,NULL,NULL,NULL,'2025-12-04 05:09:02','2025-12-04 05:09:05','687bf57d693e0fc1f'),('6931176e565d93281','Process Job Queue q1',0,'Success','2025-12-04 05:10:00',1088756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:08','2025-12-04 05:10:08',1339516,1,NULL,NULL,NULL,'2025-12-04 05:09:02','2025-12-04 05:10:08','687bf57d8afb5c472'),('6931176e7eb654979','Process Job Queue e0',0,'Success','2025-12-04 05:09:02',1088757,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:09:05','2025-12-04 05:09:06',1339427,1,NULL,NULL,NULL,'2025-12-04 05:09:02','2025-12-04 05:09:06','687bf57dbba8299ef'),('693117aa110194617','Submit Popup Reminders',0,'Success','2025-12-04 05:10:02',1088758,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:08','2025-12-04 05:10:09',1339516,1,NULL,NULL,NULL,'2025-12-04 05:10:02','2025-12-04 05:10:09','687bf57d2f9463790'),('693117aa492958c72','Process Job Queue q0',0,'Success','2025-12-04 05:10:02',1088759,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:09','2025-12-04 05:10:09',1339516,1,NULL,NULL,NULL,'2025-12-04 05:10:02','2025-12-04 05:10:09','687bf57d693e0fc1f'),('693117aa7c0683fba','Process Job Queue q1',0,'Success','2025-12-04 05:11:00',1088760,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:11:02','2025-12-04 05:11:02',1339534,1,NULL,NULL,NULL,'2025-12-04 05:10:02','2025-12-04 05:11:02','687bf57d8afb5c472'),('693117aae317d0797','Process Job Queue e0',0,'Success','2025-12-04 05:10:02',1088761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:10:10','2025-12-04 05:10:10',1339516,1,NULL,NULL,NULL,'2025-12-04 05:10:02','2025-12-04 05:10:10','687bf57dbba8299ef'),('693117ab50fe74c77','Send Email Reminders',0,'Success','2025-12-04 05:12:00',1088762,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:04','2025-12-04 05:12:05',1339551,1,NULL,NULL,NULL,'2025-12-04 05:10:03','2025-12-04 05:12:05','687bf5d44d3e10813'),('693117ab8a95eeee7','Send Email Notifications',0,'Success','2025-12-04 05:12:00',1088763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:05','2025-12-04 05:12:05',1339551,1,NULL,NULL,NULL,'2025-12-04 05:10:03','2025-12-04 05:12:05','687bf5d466067a4ba'),('693117abc288a6b39','Send Mass Emails',0,'Success','2025-12-04 05:30:00',1088764,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:04','2025-12-04 05:30:04',1339940,1,NULL,NULL,NULL,'2025-12-04 05:10:03','2025-12-04 05:30:04','687bf5d4b535f913f'),('693117abe9f23e794','Process Webhook Queue',0,'Success','2025-12-04 05:12:00',1088765,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:06','2025-12-04 05:12:06',1339551,1,NULL,NULL,NULL,'2025-12-04 05:10:03','2025-12-04 05:12:06','687bf5d5788e2fe0e'),('693117ac217747128','Send Scheduled Emails',0,'Success','2025-12-04 05:20:00',1088766,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:03','2025-12-04 05:20:04',1339704,1,NULL,NULL,NULL,'2025-12-04 05:10:04','2025-12-04 05:20:04','687bf5d5eeb01d80d'),('693117e5ea16ef6af','Submit Popup Reminders',0,'Success','2025-12-04 05:11:01',1088767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:11:03','2025-12-04 05:11:04',1339534,1,NULL,NULL,NULL,'2025-12-04 05:11:01','2025-12-04 05:11:04','687bf57d2f9463790'),('693117e61c8ec15d5','Process Job Queue q0',0,'Success','2025-12-04 05:11:02',1088768,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:11:04','2025-12-04 05:11:05',1339534,1,NULL,NULL,NULL,'2025-12-04 05:11:02','2025-12-04 05:11:05','687bf57d693e0fc1f'),('693117e63940e61b4','Process Job Queue q1',0,'Success','2025-12-04 05:12:00',1088769,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:06','2025-12-04 05:12:06',1339551,1,NULL,NULL,NULL,'2025-12-04 05:11:02','2025-12-04 05:12:06','687bf57d8afb5c472'),('693117e65f178a31a','Process Job Queue e0',0,'Success','2025-12-04 05:11:02',1088770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:11:05','2025-12-04 05:11:06',1339534,1,NULL,NULL,NULL,'2025-12-04 05:11:02','2025-12-04 05:11:06','687bf57dbba8299ef'),('69311821b21d7cce7','Submit Popup Reminders',0,'Success','2025-12-04 05:12:01',1088771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:07','2025-12-04 05:12:07',1339551,1,NULL,NULL,NULL,'2025-12-04 05:12:01','2025-12-04 05:12:07','687bf57d2f9463790'),('69311821d96a98835','Process Job Queue q0',0,'Success','2025-12-04 05:12:01',1088772,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:08','2025-12-04 05:12:08',1339551,1,NULL,NULL,NULL,'2025-12-04 05:12:01','2025-12-04 05:12:08','687bf57d693e0fc1f'),('69311822060fc6c0d','Process Job Queue q1',0,'Success','2025-12-04 05:13:00',1088773,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:13:02','2025-12-04 05:13:03',1339588,1,NULL,NULL,NULL,'2025-12-04 05:12:02','2025-12-04 05:13:03','687bf57d8afb5c472'),('6931182224733f816','Process Job Queue e0',0,'Success','2025-12-04 05:12:02',1088774,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:12:09','2025-12-04 05:12:09',1339551,1,NULL,NULL,NULL,'2025-12-04 05:12:02','2025-12-04 05:12:09','687bf57dbba8299ef'),('693118224b8d25fe5','Send Email Reminders',0,'Success','2025-12-04 05:14:00',1088775,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:03','2025-12-04 05:14:03',1339606,1,NULL,NULL,NULL,'2025-12-04 05:12:02','2025-12-04 05:14:03','687bf5d44d3e10813'),('6931182292c71fa40','Send Email Notifications',0,'Success','2025-12-04 05:14:00',1088776,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:04','2025-12-04 05:14:04',1339606,1,NULL,NULL,NULL,'2025-12-04 05:12:02','2025-12-04 05:14:04','687bf5d466067a4ba'),('69311823076e5ec5e','Auth Token Control',0,'Success','2025-12-04 05:18:00',1088777,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:04','2025-12-04 05:18:04',1339675,1,NULL,NULL,NULL,'2025-12-04 05:12:03','2025-12-04 05:18:04','687bf5d511e08c57f'),('693118235c0b8a4ab','Process Webhook Queue',0,'Success','2025-12-04 05:14:00',1088778,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:05','2025-12-04 05:14:05',1339606,1,NULL,NULL,NULL,'2025-12-04 05:12:03','2025-12-04 05:14:05','687bf5d5788e2fe0e'),('6931185dd7fba3e40','Submit Popup Reminders',0,'Success','2025-12-04 05:13:01',1088779,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:13:03','2025-12-04 05:13:03',1339588,1,NULL,NULL,NULL,'2025-12-04 05:13:01','2025-12-04 05:13:03','687bf57d2f9463790'),('6931185e11a597444','Process Job Queue q0',0,'Success','2025-12-04 05:13:02',1088780,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:13:04','2025-12-04 05:13:04',1339588,1,NULL,NULL,NULL,'2025-12-04 05:13:02','2025-12-04 05:13:04','687bf57d693e0fc1f'),('6931185e3fdc85ebd','Process Job Queue q1',0,'Success','2025-12-04 05:14:00',1088781,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:05','2025-12-04 05:14:05',1339606,1,NULL,NULL,NULL,'2025-12-04 05:13:02','2025-12-04 05:14:05','687bf57d8afb5c472'),('6931185e76e73190c','Process Job Queue e0',0,'Success','2025-12-04 05:13:02',1088782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:13:05','2025-12-04 05:13:05',1339588,1,NULL,NULL,NULL,'2025-12-04 05:13:02','2025-12-04 05:13:05','687bf57dbba8299ef'),('6931189941338ac1e','Submit Popup Reminders',0,'Success','2025-12-04 05:14:01',1088783,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:06','2025-12-04 05:14:06',1339606,1,NULL,NULL,NULL,'2025-12-04 05:14:01','2025-12-04 05:14:06','687bf57d2f9463790'),('69311899741f5c3c9','Process Job Queue q0',0,'Success','2025-12-04 05:14:01',1088784,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:07','2025-12-04 05:14:07',1339606,1,NULL,NULL,NULL,'2025-12-04 05:14:01','2025-12-04 05:14:07','687bf57d693e0fc1f'),('6931189996ddcfab4','Process Job Queue q1',0,'Success','2025-12-04 05:15:00',1088785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:15:02','2025-12-04 05:15:03',1339625,1,NULL,NULL,NULL,'2025-12-04 05:14:01','2025-12-04 05:15:03','687bf57d8afb5c472'),('69311899cac5d33f5','Process Job Queue e0',0,'Success','2025-12-04 05:14:01',1088786,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:14:08','2025-12-04 05:14:08',1339606,1,NULL,NULL,NULL,'2025-12-04 05:14:01','2025-12-04 05:14:08','687bf57dbba8299ef'),('6931189a16e201ef5','Send Email Reminders',0,'Success','2025-12-04 05:16:00',1088787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:03','2025-12-04 05:16:04',1339641,1,NULL,NULL,NULL,'2025-12-04 05:14:02','2025-12-04 05:16:04','687bf5d44d3e10813'),('6931189ae86f0530f','Send Email Notifications',0,'Success','2025-12-04 05:16:00',1088788,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:05','2025-12-04 05:16:05',1339641,1,NULL,NULL,NULL,'2025-12-04 05:14:02','2025-12-04 05:16:05','687bf5d466067a4ba'),('6931189b19794ce4b','Process Webhook Queue',0,'Success','2025-12-04 05:16:00',1088789,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:06','2025-12-04 05:16:06',1339641,1,NULL,NULL,NULL,'2025-12-04 05:14:03','2025-12-04 05:16:06','687bf5d5788e2fe0e'),('693118d58269ffc3e','Submit Popup Reminders',0,'Success','2025-12-04 05:15:01',1088790,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:15:04','2025-12-04 05:15:04',1339625,1,NULL,NULL,NULL,'2025-12-04 05:15:01','2025-12-04 05:15:04','687bf57d2f9463790'),('693118d5b7e9d56d2','Process Job Queue q0',0,'Success','2025-12-04 05:15:01',1088791,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:15:05','2025-12-04 05:15:05',1339625,1,NULL,NULL,NULL,'2025-12-04 05:15:01','2025-12-04 05:15:05','687bf57d693e0fc1f'),('693118d5ef396f8b7','Process Job Queue q1',0,'Success','2025-12-04 05:16:00',1088792,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:07','2025-12-04 05:16:07',1339641,1,NULL,NULL,NULL,'2025-12-04 05:15:01','2025-12-04 05:16:07','687bf57d8afb5c472'),('693118d6ab3bc221e','Process Job Queue e0',0,'Success','2025-12-04 05:15:02',1088793,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:15:05','2025-12-04 05:15:05',1339625,1,NULL,NULL,NULL,'2025-12-04 05:15:02','2025-12-04 05:15:05','687bf57dbba8299ef'),('69311912123f1c7ad','Submit Popup Reminders',0,'Success','2025-12-04 05:16:02',1088794,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:08','2025-12-04 05:16:08',1339641,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:16:08','687bf57d2f9463790'),('6931191246cd4fb54','Process Job Queue q0',0,'Success','2025-12-04 05:16:02',1088795,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:08','2025-12-04 05:16:08',1339641,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:16:08','687bf57d693e0fc1f'),('693119126b57d99ee','Process Job Queue q1',0,'Success','2025-12-04 05:17:00',1088796,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:17:02','2025-12-04 05:17:02',1339658,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:17:02','687bf57d8afb5c472'),('69311912a17b0999c','Process Job Queue e0',0,'Success','2025-12-04 05:16:02',1088797,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:16:09','2025-12-04 05:16:09',1339641,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:16:09','687bf57dbba8299ef'),('69311912c1307bcb4','Send Email Reminders',0,'Success','2025-12-04 05:18:00',1088798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:05','2025-12-04 05:18:05',1339675,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:18:05','687bf5d44d3e10813'),('69311912daea337df','Send Email Notifications',0,'Success','2025-12-04 05:18:00',1088799,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:05','2025-12-04 05:18:05',1339675,1,NULL,NULL,NULL,'2025-12-04 05:16:02','2025-12-04 05:18:05','687bf5d466067a4ba'),('69311913132061cd9','Process Webhook Queue',0,'Success','2025-12-04 05:18:00',1088800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:06','2025-12-04 05:18:06',1339675,1,NULL,NULL,NULL,'2025-12-04 05:16:03','2025-12-04 05:18:06','687bf5d5788e2fe0e'),('6931194daf8a6d32e','Submit Popup Reminders',0,'Success','2025-12-04 05:17:01',1088801,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:17:03','2025-12-04 05:17:04',1339658,1,NULL,NULL,NULL,'2025-12-04 05:17:01','2025-12-04 05:17:04','687bf57d2f9463790'),('6931194de9b23dc4a','Process Job Queue q0',0,'Success','2025-12-04 05:17:01',1088802,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:17:04','2025-12-04 05:17:04',1339658,1,NULL,NULL,NULL,'2025-12-04 05:17:01','2025-12-04 05:17:04','687bf57d693e0fc1f'),('6931194e192b41b6b','Process Job Queue q1',0,'Success','2025-12-04 05:18:00',1088803,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:07','2025-12-04 05:18:07',1339675,1,NULL,NULL,NULL,'2025-12-04 05:17:02','2025-12-04 05:18:07','687bf57d8afb5c472'),('6931194e3c0a5f996','Process Job Queue e0',0,'Success','2025-12-04 05:17:02',1088804,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:17:05','2025-12-04 05:17:05',1339658,1,NULL,NULL,NULL,'2025-12-04 05:17:02','2025-12-04 05:17:05','687bf57dbba8299ef'),('69311989c87409d0f','Submit Popup Reminders',0,'Success','2025-12-04 05:18:01',1088805,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:07','2025-12-04 05:18:07',1339675,1,NULL,NULL,NULL,'2025-12-04 05:18:01','2025-12-04 05:18:07','687bf57d2f9463790'),('6931198a0618a98e2','Process Job Queue q0',0,'Success','2025-12-04 05:18:02',1088806,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:08','2025-12-04 05:18:08',1339675,1,NULL,NULL,NULL,'2025-12-04 05:18:02','2025-12-04 05:18:08','687bf57d693e0fc1f'),('6931198a34f7abb25','Process Job Queue q1',0,'Success','2025-12-04 05:19:00',1088807,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:19:01','2025-12-04 05:19:02',1339689,1,NULL,NULL,NULL,'2025-12-04 05:18:02','2025-12-04 05:19:02','687bf57d8afb5c472'),('6931198a7d734c9d1','Process Job Queue e0',0,'Success','2025-12-04 05:18:02',1088808,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:18:08','2025-12-04 05:18:09',1339675,1,NULL,NULL,NULL,'2025-12-04 05:18:02','2025-12-04 05:18:09','687bf57dbba8299ef'),('6931198abac620ca7','Send Email Reminders',0,'Success','2025-12-04 05:20:00',1088809,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:04','2025-12-04 05:20:04',1339704,1,NULL,NULL,NULL,'2025-12-04 05:18:02','2025-12-04 05:20:04','687bf5d44d3e10813'),('6931198b30f7bf707','Send Email Notifications',0,'Success','2025-12-04 05:20:00',1088810,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:05','2025-12-04 05:20:05',1339704,1,NULL,NULL,NULL,'2025-12-04 05:18:03','2025-12-04 05:20:05','687bf5d466067a4ba'),('6931198b8d249f238','Auth Token Control',0,'Success','2025-12-04 05:24:00',1088811,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:04','2025-12-04 05:24:04',1339789,1,NULL,NULL,NULL,'2025-12-04 05:18:03','2025-12-04 05:24:04','687bf5d511e08c57f'),('6931198bc6c959efb','Process Webhook Queue',0,'Success','2025-12-04 05:20:00',1088812,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:06','2025-12-04 05:20:06',1339704,1,NULL,NULL,NULL,'2025-12-04 05:18:03','2025-12-04 05:20:06','687bf5d5788e2fe0e'),('693119c556206a801','Submit Popup Reminders',0,'Success','2025-12-04 05:19:01',1088813,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:19:03','2025-12-04 05:19:03',1339689,1,NULL,NULL,NULL,'2025-12-04 05:19:01','2025-12-04 05:19:03','687bf57d2f9463790'),('693119c5779ed899f','Process Job Queue q0',0,'Success','2025-12-04 05:19:01',1088814,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:19:04','2025-12-04 05:19:04',1339689,1,NULL,NULL,NULL,'2025-12-04 05:19:01','2025-12-04 05:19:04','687bf57d693e0fc1f'),('693119c59cb352dce','Process Job Queue q1',0,'Success','2025-12-04 05:20:00',1088815,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:06','2025-12-04 05:20:07',1339704,1,NULL,NULL,NULL,'2025-12-04 05:19:01','2025-12-04 05:20:07','687bf57d8afb5c472'),('693119c5bd213916f','Process Job Queue e0',0,'Success','2025-12-04 05:19:01',1088816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:19:05','2025-12-04 05:19:05',1339689,1,NULL,NULL,NULL,'2025-12-04 05:19:01','2025-12-04 05:19:05','687bf57dbba8299ef'),('69311a013f5a72caf','Submit Popup Reminders',0,'Success','2025-12-04 05:20:01',1088817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:07','2025-12-04 05:20:07',1339704,1,NULL,NULL,NULL,'2025-12-04 05:20:01','2025-12-04 05:20:07','687bf57d2f9463790'),('69311a0172e82c3d8','Process Job Queue q0',0,'Success','2025-12-04 05:20:01',1088818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:08','2025-12-04 05:20:08',1339704,1,NULL,NULL,NULL,'2025-12-04 05:20:01','2025-12-04 05:20:08','687bf57d693e0fc1f'),('69311a0197a668267','Process Job Queue q1',0,'Success','2025-12-04 05:21:00',1088819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:21:02','2025-12-04 05:21:03',1339724,1,NULL,NULL,NULL,'2025-12-04 05:20:01','2025-12-04 05:21:03','687bf57d8afb5c472'),('69311a020a80fcbc2','Process Job Queue e0',0,'Success','2025-12-04 05:20:02',1088820,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:20:09','2025-12-04 05:20:09',1339704,1,NULL,NULL,NULL,'2025-12-04 05:20:02','2025-12-04 05:20:09','687bf57dbba8299ef'),('69311a0267317f43a','Send Email Reminders',0,'Success','2025-12-04 05:22:00',1088821,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:02','2025-12-04 05:22:03',1339743,1,NULL,NULL,NULL,'2025-12-04 05:20:02','2025-12-04 05:22:03','687bf5d44d3e10813'),('69311a02a8337a6fa','Send Email Notifications',0,'Success','2025-12-04 05:22:00',1088822,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:04','2025-12-04 05:22:04',1339743,1,NULL,NULL,NULL,'2025-12-04 05:20:02','2025-12-04 05:22:04','687bf5d466067a4ba'),('69311a0305abf1edd','Process Webhook Queue',0,'Success','2025-12-04 05:22:00',1088823,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:05','2025-12-04 05:22:05',1339743,1,NULL,NULL,NULL,'2025-12-04 05:20:03','2025-12-04 05:22:05','687bf5d5788e2fe0e'),('69311a035e8282c8f','Send Scheduled Emails',0,'Success','2025-12-04 05:30:00',1088824,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:05','2025-12-04 05:30:05',1339940,1,NULL,NULL,NULL,'2025-12-04 05:20:03','2025-12-04 05:30:05','687bf5d5eeb01d80d'),('69311a3dd865394a3','Submit Popup Reminders',0,'Success','2025-12-04 05:21:01',1088825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:21:04','2025-12-04 05:21:04',1339724,1,NULL,NULL,NULL,'2025-12-04 05:21:01','2025-12-04 05:21:04','687bf57d2f9463790'),('69311a3e0c645ce36','Process Job Queue q0',0,'Success','2025-12-04 05:21:02',1088826,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:21:04','2025-12-04 05:21:05',1339724,1,NULL,NULL,NULL,'2025-12-04 05:21:02','2025-12-04 05:21:05','687bf57d693e0fc1f'),('69311a3e5f0c28fb6','Process Job Queue q1',0,'Success','2025-12-04 05:22:00',1088827,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:05','2025-12-04 05:22:06',1339743,1,NULL,NULL,NULL,'2025-12-04 05:21:02','2025-12-04 05:22:06','687bf57d8afb5c472'),('69311a3e9a3e62bdd','Process Job Queue e0',0,'Success','2025-12-04 05:21:02',1088828,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:21:05','2025-12-04 05:21:05',1339724,1,NULL,NULL,NULL,'2025-12-04 05:21:02','2025-12-04 05:21:05','687bf57dbba8299ef'),('69311a796ad9e9d36','Submit Popup Reminders',0,'Success','2025-12-04 05:22:01',1088829,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:06','2025-12-04 05:22:06',1339743,1,NULL,NULL,NULL,'2025-12-04 05:22:01','2025-12-04 05:22:06','687bf57d2f9463790'),('69311a7991be6a89a','Process Job Queue q0',0,'Success','2025-12-04 05:22:01',1088830,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:07','2025-12-04 05:22:07',1339743,1,NULL,NULL,NULL,'2025-12-04 05:22:01','2025-12-04 05:22:07','687bf57d693e0fc1f'),('69311a79b677cc2b2','Process Job Queue q1',0,'Success','2025-12-04 05:23:00',1088831,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:23:02','2025-12-04 05:23:02',1339759,1,NULL,NULL,NULL,'2025-12-04 05:22:01','2025-12-04 05:23:02','687bf57d8afb5c472'),('69311a79d43527fe4','Process Job Queue e0',0,'Success','2025-12-04 05:22:01',1088832,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:22:08','2025-12-04 05:22:08',1339743,1,NULL,NULL,NULL,'2025-12-04 05:22:01','2025-12-04 05:22:08','687bf57dbba8299ef'),('69311a7a072fd5222','Send Email Reminders',0,'Success','2025-12-04 05:24:00',1088833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:05','2025-12-04 05:24:05',1339789,1,NULL,NULL,NULL,'2025-12-04 05:22:02','2025-12-04 05:24:05','687bf5d44d3e10813'),('69311a7a2c6ccb905','Send Email Notifications',0,'Success','2025-12-04 05:24:00',1088834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:06','2025-12-04 05:24:06',1339789,1,NULL,NULL,NULL,'2025-12-04 05:22:02','2025-12-04 05:24:06','687bf5d466067a4ba'),('69311a7a85fb36a90','Process Webhook Queue',0,'Success','2025-12-04 05:24:00',1088835,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:07','2025-12-04 05:24:07',1339789,1,NULL,NULL,NULL,'2025-12-04 05:22:02','2025-12-04 05:24:07','687bf5d5788e2fe0e'),('69311ab5e4340be1c','Submit Popup Reminders',0,'Success','2025-12-04 05:23:01',1088836,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:23:03','2025-12-04 05:23:04',1339759,1,NULL,NULL,NULL,'2025-12-04 05:23:01','2025-12-04 05:23:04','687bf57d2f9463790'),('69311ab61e35823f3','Process Job Queue q0',0,'Success','2025-12-04 05:23:02',1088837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:23:05','2025-12-04 05:23:05',1339759,1,NULL,NULL,NULL,'2025-12-04 05:23:02','2025-12-04 05:23:05','687bf57d693e0fc1f'),('69311ab642f973ed6','Process Job Queue q1',0,'Success','2025-12-04 05:24:00',1088838,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:07','2025-12-04 05:24:07',1339789,1,NULL,NULL,NULL,'2025-12-04 05:23:02','2025-12-04 05:24:07','687bf57d8afb5c472'),('69311ab66b0b56a20','Process Job Queue e0',0,'Success','2025-12-04 05:23:02',1088839,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:23:06','2025-12-04 05:23:06',1339759,1,NULL,NULL,NULL,'2025-12-04 05:23:02','2025-12-04 05:23:06','687bf57dbba8299ef'),('69311af1eda0399c3','Submit Popup Reminders',0,'Success','2025-12-04 05:24:01',1088840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:08','2025-12-04 05:24:08',1339789,1,NULL,NULL,NULL,'2025-12-04 05:24:01','2025-12-04 05:24:08','687bf57d2f9463790'),('69311af22138baf2c','Process Job Queue q0',0,'Success','2025-12-04 05:24:02',1088841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:09','2025-12-04 05:24:09',1339789,1,NULL,NULL,NULL,'2025-12-04 05:24:02','2025-12-04 05:24:09','687bf57d693e0fc1f'),('69311af24b680e73a','Process Job Queue q1',0,'Success','2025-12-04 05:25:00',1088842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:25:03','2025-12-04 05:25:03',1339804,1,NULL,NULL,NULL,'2025-12-04 05:24:02','2025-12-04 05:25:03','687bf57d8afb5c472'),('69311af3027a2c16d','Process Job Queue e0',0,'Success','2025-12-04 05:24:03',1088843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:24:09','2025-12-04 05:24:09',1339789,1,NULL,NULL,NULL,'2025-12-04 05:24:03','2025-12-04 05:24:09','687bf57dbba8299ef'),('69311af35a6f57a90','Send Email Reminders',0,'Success','2025-12-04 05:26:00',1088844,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:03','2025-12-04 05:26:03',1339818,1,NULL,NULL,NULL,'2025-12-04 05:24:03','2025-12-04 05:26:03','687bf5d44d3e10813'),('69311af3b4c2434d0','Send Email Notifications',0,'Success','2025-12-04 05:26:00',1088845,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:04','2025-12-04 05:26:04',1339818,1,NULL,NULL,NULL,'2025-12-04 05:24:03','2025-12-04 05:26:04','687bf5d466067a4ba'),('69311af4059677103','Auth Token Control',0,'Success','2025-12-04 05:30:00',1088846,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:05','2025-12-04 05:30:06',1339940,1,NULL,NULL,NULL,'2025-12-04 05:24:04','2025-12-04 05:30:06','687bf5d511e08c57f'),('69311af44c2e4f260','Process Webhook Queue',0,'Success','2025-12-04 05:26:00',1088847,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:05','2025-12-04 05:26:05',1339818,1,NULL,NULL,NULL,'2025-12-04 05:24:04','2025-12-04 05:26:05','687bf5d5788e2fe0e'),('69311b2e05e2af5ab','Submit Popup Reminders',0,'Success','2025-12-04 05:25:02',1088848,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:25:04','2025-12-04 05:25:04',1339804,1,NULL,NULL,NULL,'2025-12-04 05:25:02','2025-12-04 05:25:04','687bf57d2f9463790'),('69311b2e36fc9138e','Process Job Queue q0',0,'Success','2025-12-04 05:25:02',1088849,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:25:05','2025-12-04 05:25:05',1339804,1,NULL,NULL,NULL,'2025-12-04 05:25:02','2025-12-04 05:25:05','687bf57d693e0fc1f'),('69311b2e631260873','Process Job Queue q1',0,'Success','2025-12-04 05:26:00',1088850,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:06','2025-12-04 05:26:06',1339818,1,NULL,NULL,NULL,'2025-12-04 05:25:02','2025-12-04 05:26:06','687bf57d8afb5c472'),('69311b2e998b119bf','Process Job Queue e0',0,'Success','2025-12-04 05:25:02',1088851,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:25:06','2025-12-04 05:25:06',1339804,1,NULL,NULL,NULL,'2025-12-04 05:25:02','2025-12-04 05:25:06','687bf57dbba8299ef'),('69311b69be416a4ea','Submit Popup Reminders',0,'Success','2025-12-04 05:26:01',1088852,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:07','2025-12-04 05:26:07',1339818,1,NULL,NULL,NULL,'2025-12-04 05:26:01','2025-12-04 05:26:07','687bf57d2f9463790'),('69311b6a05b0b57c8','Process Job Queue q0',0,'Success','2025-12-04 05:26:02',1088853,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:08','2025-12-04 05:26:08',1339818,1,NULL,NULL,NULL,'2025-12-04 05:26:02','2025-12-04 05:26:08','687bf57d693e0fc1f'),('69311b6a3490ad7dd','Process Job Queue q1',0,'Success','2025-12-04 05:27:00',1088854,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:27:02','2025-12-04 05:27:02',1339834,1,NULL,NULL,NULL,'2025-12-04 05:26:02','2025-12-04 05:27:02','687bf57d8afb5c472'),('69311b6a5a8317fac','Process Job Queue e0',0,'Success','2025-12-04 05:26:02',1088855,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:26:08','2025-12-04 05:26:08',1339818,1,NULL,NULL,NULL,'2025-12-04 05:26:02','2025-12-04 05:26:08','687bf57dbba8299ef'),('69311b6a8185c332c','Send Email Reminders',0,'Success','2025-12-04 05:28:00',1088856,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:03','2025-12-04 05:28:03',1339862,1,NULL,NULL,NULL,'2025-12-04 05:26:02','2025-12-04 05:28:03','687bf5d44d3e10813'),('69311b6aa4cf051e1','Send Email Notifications',0,'Success','2025-12-04 05:28:00',1088857,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:04','2025-12-04 05:28:04',1339862,1,NULL,NULL,NULL,'2025-12-04 05:26:02','2025-12-04 05:28:04','687bf5d466067a4ba'),('69311b6b06903a0c0','Process Webhook Queue',0,'Success','2025-12-04 05:28:00',1088858,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:04','2025-12-04 05:28:05',1339862,1,NULL,NULL,NULL,'2025-12-04 05:26:03','2025-12-04 05:28:05','687bf5d5788e2fe0e'),('69311ba576b3670c7','Submit Popup Reminders',0,'Success','2025-12-04 05:27:01',1088859,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:27:03','2025-12-04 05:27:03',1339834,1,NULL,NULL,NULL,'2025-12-04 05:27:01','2025-12-04 05:27:03','687bf57d2f9463790'),('69311ba59bb29fb1a','Process Job Queue q0',0,'Success','2025-12-04 05:27:01',1088860,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:27:04','2025-12-04 05:27:04',1339834,1,NULL,NULL,NULL,'2025-12-04 05:27:01','2025-12-04 05:27:04','687bf57d693e0fc1f'),('69311ba5c887a92eb','Process Job Queue q1',0,'Success','2025-12-04 05:28:00',1088861,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:05','2025-12-04 05:28:05',1339862,1,NULL,NULL,NULL,'2025-12-04 05:27:01','2025-12-04 05:28:05','687bf57d8afb5c472'),('69311ba5ece1abe98','Process Job Queue e0',0,'Success','2025-12-04 05:27:01',1088862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:27:05','2025-12-04 05:27:05',1339834,1,NULL,NULL,NULL,'2025-12-04 05:27:01','2025-12-04 05:27:05','687bf57dbba8299ef'),('69311be18c5a70ad9','Submit Popup Reminders',0,'Success','2025-12-04 05:28:01',1088863,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:06','2025-12-04 05:28:06',1339862,1,NULL,NULL,NULL,'2025-12-04 05:28:01','2025-12-04 05:28:06','687bf57d2f9463790'),('69311be1af0b92150','Process Job Queue q0',0,'Success','2025-12-04 05:28:01',1088864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:07','2025-12-04 05:28:07',1339862,1,NULL,NULL,NULL,'2025-12-04 05:28:01','2025-12-04 05:28:07','687bf57d693e0fc1f'),('69311be1dc0632f8e','Process Job Queue q1',0,'Success','2025-12-04 05:29:00',1088865,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:29:02','2025-12-04 05:29:03',1339902,1,NULL,NULL,NULL,'2025-12-04 05:28:01','2025-12-04 05:29:03','687bf57d8afb5c472'),('69311be2409f3c9f6','Process Job Queue e0',0,'Success','2025-12-04 05:28:02',1088866,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:28:07','2025-12-04 05:28:08',1339862,1,NULL,NULL,NULL,'2025-12-04 05:28:02','2025-12-04 05:28:08','687bf57dbba8299ef'),('69311be3054efe6f5','Send Email Reminders',0,'Success','2025-12-04 05:30:00',1088867,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:06','2025-12-04 05:30:07',1339940,1,NULL,NULL,NULL,'2025-12-04 05:28:03','2025-12-04 05:30:07','687bf5d44d3e10813'),('69311be3358a7d9b6','Send Email Notifications',0,'Success','2025-12-04 05:30:00',1088868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:07','2025-12-04 05:30:07',1339940,1,NULL,NULL,NULL,'2025-12-04 05:28:03','2025-12-04 05:30:07','687bf5d466067a4ba'),('69311be35b6fbd95f','Process Webhook Queue',0,'Success','2025-12-04 05:30:00',1088869,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:08','2025-12-04 05:30:08',1339940,1,NULL,NULL,NULL,'2025-12-04 05:28:03','2025-12-04 05:30:08','687bf5d5788e2fe0e'),('69311c1e09e1e3c21','Submit Popup Reminders',0,'Success','2025-12-04 05:29:02',1088870,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:29:04','2025-12-04 05:29:04',1339902,1,NULL,NULL,NULL,'2025-12-04 05:29:02','2025-12-04 05:29:04','687bf57d2f9463790'),('69311c1e43058028b','Process Job Queue q0',0,'Success','2025-12-04 05:29:02',1088871,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:29:05','2025-12-04 05:29:05',1339902,1,NULL,NULL,NULL,'2025-12-04 05:29:02','2025-12-04 05:29:05','687bf57d693e0fc1f'),('69311c1e6b6c43d45','Process Job Queue q1',0,'Success','2025-12-04 05:30:00',1088872,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:08','2025-12-04 05:30:09',1339940,1,NULL,NULL,NULL,'2025-12-04 05:29:02','2025-12-04 05:30:09','687bf57d8afb5c472'),('69311c1e9312a2bf8','Process Job Queue e0',0,'Success','2025-12-04 05:29:02',1088873,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:29:05','2025-12-04 05:29:06',1339902,1,NULL,NULL,NULL,'2025-12-04 05:29:02','2025-12-04 05:29:06','687bf57dbba8299ef'),('69311c5a0d183b144','Submit Popup Reminders',0,'Success','2025-12-04 05:30:02',1088874,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:09','2025-12-04 05:30:09',1339940,1,NULL,NULL,NULL,'2025-12-04 05:30:02','2025-12-04 05:30:09','687bf57d2f9463790'),('69311c5a386b45a3c','Process Job Queue q0',0,'Success','2025-12-04 05:30:02',1088875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:10','2025-12-04 05:30:10',1339940,1,NULL,NULL,NULL,'2025-12-04 05:30:02','2025-12-04 05:30:10','687bf57d693e0fc1f'),('69311c5a5c7853362','Process Job Queue q1',0,'Success','2025-12-04 05:31:00',1088876,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:31:01','2025-12-04 05:31:02',1339973,1,NULL,NULL,NULL,'2025-12-04 05:30:02','2025-12-04 05:31:02','687bf57d8afb5c472'),('69311c5acabe164bc','Process Job Queue e0',0,'Success','2025-12-04 05:30:02',1088877,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:30:11','2025-12-04 05:30:11',1339940,1,NULL,NULL,NULL,'2025-12-04 05:30:02','2025-12-04 05:30:11','687bf57dbba8299ef'),('69311c5b312865405','Send Email Reminders',0,'Success','2025-12-04 05:32:00',1088878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:03','2025-12-04 05:32:04',1340019,1,NULL,NULL,NULL,'2025-12-04 05:30:03','2025-12-04 05:32:04','687bf5d44d3e10813'),('69311c5b62ba6b502','Send Email Notifications',0,'Success','2025-12-04 05:32:00',1088879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:04','2025-12-04 05:32:05',1340019,1,NULL,NULL,NULL,'2025-12-04 05:30:03','2025-12-04 05:32:05','687bf5d466067a4ba'),('69311c5ba4db77b78','Send Mass Emails',0,'Success','2025-12-04 05:50:00',1088880,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:02','2025-12-04 05:50:03',1340809,1,NULL,NULL,NULL,'2025-12-04 05:30:03','2025-12-04 05:50:03','687bf5d4b535f913f'),('69311c5bd6c49dd75','Auth Token Control',0,'Success','2025-12-04 05:36:00',1088881,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:04','2025-12-04 05:36:04',1340177,1,NULL,NULL,NULL,'2025-12-04 05:30:03','2025-12-04 05:36:04','687bf5d511e08c57f'),('69311c5c09d97e33c','Process Webhook Queue',0,'Success','2025-12-04 05:32:00',1088882,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:05','2025-12-04 05:32:05',1340019,1,NULL,NULL,NULL,'2025-12-04 05:30:04','2025-12-04 05:32:05','687bf5d5788e2fe0e'),('69311c5c31e0589c0','Send Scheduled Emails',0,'Success','2025-12-04 05:40:00',1088883,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:04','2025-12-04 05:40:04',1340390,1,NULL,NULL,NULL,'2025-12-04 05:30:04','2025-12-04 05:40:04','687bf5d5eeb01d80d'),('69311c952dcd635cc','Submit Popup Reminders',0,'Success','2025-12-04 05:31:01',1088884,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:31:03','2025-12-04 05:31:04',1339973,1,NULL,NULL,NULL,'2025-12-04 05:31:01','2025-12-04 05:31:04','687bf57d2f9463790'),('69311c9561483d254','Process Job Queue q0',0,'Success','2025-12-04 05:31:01',1088885,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:31:04','2025-12-04 05:31:05',1339973,1,NULL,NULL,NULL,'2025-12-04 05:31:01','2025-12-04 05:31:05','687bf57d693e0fc1f'),('69311c958573d8a01','Process Job Queue q1',0,'Success','2025-12-04 05:32:00',1088886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:06','2025-12-04 05:32:06',1340019,1,NULL,NULL,NULL,'2025-12-04 05:31:01','2025-12-04 05:32:06','687bf57d8afb5c472'),('69311c95b217531ed','Process Job Queue e0',0,'Success','2025-12-04 05:31:01',1088887,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:31:05','2025-12-04 05:31:05',1339973,1,NULL,NULL,NULL,'2025-12-04 05:31:01','2025-12-04 05:31:05','687bf57dbba8299ef'),('69311cd1e57191e1d','Submit Popup Reminders',0,'Success','2025-12-04 05:32:01',1088888,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:07','2025-12-04 05:32:07',1340019,1,NULL,NULL,NULL,'2025-12-04 05:32:01','2025-12-04 05:32:07','687bf57d2f9463790'),('69311cd2120d030d4','Process Job Queue q0',0,'Success','2025-12-04 05:32:02',1088889,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:08','2025-12-04 05:32:08',1340019,1,NULL,NULL,NULL,'2025-12-04 05:32:02','2025-12-04 05:32:08','687bf57d693e0fc1f'),('69311cd23ed8b86a5','Process Job Queue q1',0,'Success','2025-12-04 05:33:00',1088890,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:33:02','2025-12-04 05:33:02',1340059,1,NULL,NULL,NULL,'2025-12-04 05:32:02','2025-12-04 05:33:02','687bf57d8afb5c472'),('69311cd2656737fb8','Process Job Queue e0',0,'Success','2025-12-04 05:32:02',1088891,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:32:08','2025-12-04 05:32:08',1340019,1,NULL,NULL,NULL,'2025-12-04 05:32:02','2025-12-04 05:32:08','687bf57dbba8299ef'),('69311cd28e4b7f225','Send Email Reminders',0,'Success','2025-12-04 05:34:00',1088892,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:03','2025-12-04 05:34:03',1340101,1,NULL,NULL,NULL,'2025-12-04 05:32:02','2025-12-04 05:34:03','687bf5d44d3e10813'),('69311cd3195a24c38','Send Email Notifications',0,'Success','2025-12-04 05:34:00',1088893,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:04','2025-12-04 05:34:04',1340101,1,NULL,NULL,NULL,'2025-12-04 05:32:03','2025-12-04 05:34:04','687bf5d466067a4ba'),('69311cd3677180561','Process Webhook Queue',0,'Success','2025-12-04 05:34:00',1088894,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:05','2025-12-04 05:34:05',1340101,1,NULL,NULL,NULL,'2025-12-04 05:32:03','2025-12-04 05:34:05','687bf5d5788e2fe0e'),('69311d0d396cafc08','Submit Popup Reminders',0,'Success','2025-12-04 05:33:01',1088895,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:33:03','2025-12-04 05:33:03',1340059,1,NULL,NULL,NULL,'2025-12-04 05:33:01','2025-12-04 05:33:03','687bf57d2f9463790'),('69311d0d92a2d8a93','Process Job Queue q0',0,'Success','2025-12-04 05:33:01',1088896,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:33:04','2025-12-04 05:33:04',1340059,1,NULL,NULL,NULL,'2025-12-04 05:33:01','2025-12-04 05:33:04','687bf57d693e0fc1f'),('69311d0dd81957742','Process Job Queue q1',0,'Success','2025-12-04 05:34:00',1088897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:06','2025-12-04 05:34:06',1340101,1,NULL,NULL,NULL,'2025-12-04 05:33:01','2025-12-04 05:34:06','687bf57d8afb5c472'),('69311d0e1cc9821eb','Process Job Queue e0',0,'Success','2025-12-04 05:33:02',1088898,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:33:05','2025-12-04 05:33:05',1340059,1,NULL,NULL,NULL,'2025-12-04 05:33:02','2025-12-04 05:33:05','687bf57dbba8299ef'),('69311d49c14306481','Submit Popup Reminders',0,'Success','2025-12-04 05:34:01',1088899,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:06','2025-12-04 05:34:06',1340101,1,NULL,NULL,NULL,'2025-12-04 05:34:01','2025-12-04 05:34:06','687bf57d2f9463790'),('69311d49f3c51de6d','Process Job Queue q0',0,'Success','2025-12-04 05:34:01',1088900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:07','2025-12-04 05:34:07',1340101,1,NULL,NULL,NULL,'2025-12-04 05:34:01','2025-12-04 05:34:07','687bf57d693e0fc1f'),('69311d4a3199c8275','Process Job Queue q1',0,'Success','2025-12-04 05:35:00',1088901,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:35:02','2025-12-04 05:35:02',1340142,1,NULL,NULL,NULL,'2025-12-04 05:34:02','2025-12-04 05:35:02','687bf57d8afb5c472'),('69311d4a750387842','Process Job Queue e0',0,'Success','2025-12-04 05:34:02',1088902,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:34:08','2025-12-04 05:34:08',1340101,1,NULL,NULL,NULL,'2025-12-04 05:34:02','2025-12-04 05:34:08','687bf57dbba8299ef'),('69311d4ac2c16ad99','Send Email Reminders',0,'Success','2025-12-04 05:36:00',1088903,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:05','2025-12-04 05:36:05',1340177,1,NULL,NULL,NULL,'2025-12-04 05:34:02','2025-12-04 05:36:05','687bf5d44d3e10813'),('69311d4b3cb37606d','Send Email Notifications',0,'Success','2025-12-04 05:36:00',1088904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:05','2025-12-04 05:36:05',1340177,1,NULL,NULL,NULL,'2025-12-04 05:34:03','2025-12-04 05:36:05','687bf5d466067a4ba'),('69311d4b7046d3a72','Process Webhook Queue',0,'Success','2025-12-04 05:36:00',1088905,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:06','2025-12-04 05:36:06',1340177,1,NULL,NULL,NULL,'2025-12-04 05:34:03','2025-12-04 05:36:06','687bf5d5788e2fe0e'),('69311d8580ef7e683','Submit Popup Reminders',0,'Success','2025-12-04 05:35:01',1088906,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:35:03','2025-12-04 05:35:03',1340142,1,NULL,NULL,NULL,'2025-12-04 05:35:01','2025-12-04 05:35:03','687bf57d2f9463790'),('69311d85a7f489036','Process Job Queue q0',0,'Success','2025-12-04 05:35:01',1088907,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:35:04','2025-12-04 05:35:04',1340142,1,NULL,NULL,NULL,'2025-12-04 05:35:01','2025-12-04 05:35:04','687bf57d693e0fc1f'),('69311d85ccafd801e','Process Job Queue q1',0,'Success','2025-12-04 05:36:00',1088908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:07','2025-12-04 05:36:07',1340177,1,NULL,NULL,NULL,'2025-12-04 05:35:01','2025-12-04 05:36:07','687bf57d8afb5c472'),('69311d85ee3f1a312','Process Job Queue e0',0,'Success','2025-12-04 05:35:01',1088909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:35:05','2025-12-04 05:35:05',1340142,1,NULL,NULL,NULL,'2025-12-04 05:35:01','2025-12-04 05:35:05','687bf57dbba8299ef'),('69311dc1eb2394a01','Submit Popup Reminders',0,'Success','2025-12-04 05:36:01',1088910,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:07','2025-12-04 05:36:08',1340177,1,NULL,NULL,NULL,'2025-12-04 05:36:01','2025-12-04 05:36:08','687bf57d2f9463790'),('69311dc226725395e','Process Job Queue q0',0,'Success','2025-12-04 05:36:02',1088911,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:09','2025-12-04 05:36:09',1340177,1,NULL,NULL,NULL,'2025-12-04 05:36:02','2025-12-04 05:36:09','687bf57d693e0fc1f'),('69311dc2506ae51c0','Process Job Queue q1',0,'Success','2025-12-04 05:37:00',1088912,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:37:02','2025-12-04 05:37:02',1340221,1,NULL,NULL,NULL,'2025-12-04 05:36:02','2025-12-04 05:37:02','687bf57d8afb5c472'),('69311dc26d0226c91','Process Job Queue e0',0,'Success','2025-12-04 05:36:02',1088913,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:36:09','2025-12-04 05:36:10',1340177,1,NULL,NULL,NULL,'2025-12-04 05:36:02','2025-12-04 05:36:10','687bf57dbba8299ef'),('69311dc3082873006','Send Email Reminders',0,'Success','2025-12-04 05:38:00',1088914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:03','2025-12-04 05:38:03',1340266,1,NULL,NULL,NULL,'2025-12-04 05:36:03','2025-12-04 05:38:03','687bf5d44d3e10813'),('69311dc35dece56b2','Send Email Notifications',0,'Success','2025-12-04 05:38:00',1088915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:04','2025-12-04 05:38:04',1340266,1,NULL,NULL,NULL,'2025-12-04 05:36:03','2025-12-04 05:38:04','687bf5d466067a4ba'),('69311dc3b32efe4e2','Auth Token Control',0,'Success','2025-12-04 05:42:00',1088916,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:03','2025-12-04 05:42:03',1340460,1,NULL,NULL,NULL,'2025-12-04 05:36:03','2025-12-04 05:42:03','687bf5d511e08c57f'),('69311dc3eb8960a09','Process Webhook Queue',0,'Success','2025-12-04 05:38:00',1088917,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:05','2025-12-04 05:38:05',1340266,1,NULL,NULL,NULL,'2025-12-04 05:36:03','2025-12-04 05:38:05','687bf5d5788e2fe0e'),('69311dfd2d752a725','Submit Popup Reminders',0,'Success','2025-12-04 05:37:01',1088918,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:37:03','2025-12-04 05:37:03',1340221,1,NULL,NULL,NULL,'2025-12-04 05:37:01','2025-12-04 05:37:03','687bf57d2f9463790'),('69311dfd677eac7db','Process Job Queue q0',0,'Success','2025-12-04 05:37:01',1088919,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:37:04','2025-12-04 05:37:04',1340221,1,NULL,NULL,NULL,'2025-12-04 05:37:01','2025-12-04 05:37:04','687bf57d693e0fc1f'),('69311dfd9246aec4d','Process Job Queue q1',0,'Success','2025-12-04 05:38:00',1088920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:06','2025-12-04 05:38:06',1340266,1,NULL,NULL,NULL,'2025-12-04 05:37:01','2025-12-04 05:38:06','687bf57d8afb5c472'),('69311dfe3c4b14226','Process Job Queue e0',0,'Success','2025-12-04 05:37:02',1088921,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:37:04','2025-12-04 05:37:05',1340221,1,NULL,NULL,NULL,'2025-12-04 05:37:02','2025-12-04 05:37:05','687bf57dbba8299ef'),('69311e39bf10ea346','Submit Popup Reminders',0,'Success','2025-12-04 05:38:01',1088922,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:07','2025-12-04 05:38:07',1340266,1,NULL,NULL,NULL,'2025-12-04 05:38:01','2025-12-04 05:38:07','687bf57d2f9463790'),('69311e39e8b9d34f2','Process Job Queue q0',0,'Success','2025-12-04 05:38:01',1088923,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:07','2025-12-04 05:38:08',1340266,1,NULL,NULL,NULL,'2025-12-04 05:38:01','2025-12-04 05:38:08','687bf57d693e0fc1f'),('69311e3a192d88300','Process Job Queue q1',0,'Success','2025-12-04 05:39:00',1088924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:39:01','2025-12-04 05:39:02',1340297,1,NULL,NULL,NULL,'2025-12-04 05:38:02','2025-12-04 05:39:02','687bf57d8afb5c472'),('69311e3a3af9459aa','Process Job Queue e0',0,'Success','2025-12-04 05:38:02',1088925,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:38:09','2025-12-04 05:38:09',1340266,1,NULL,NULL,NULL,'2025-12-04 05:38:02','2025-12-04 05:38:09','687bf57dbba8299ef'),('69311e3a68acc917c','Send Email Reminders',0,'Success','2025-12-04 05:40:00',1088926,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:04','2025-12-04 05:40:05',1340390,1,NULL,NULL,NULL,'2025-12-04 05:38:02','2025-12-04 05:40:05','687bf5d44d3e10813'),('69311e3aa77ad5035','Send Email Notifications',0,'Success','2025-12-04 05:40:00',1088927,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:06','2025-12-04 05:40:06',1340390,1,NULL,NULL,NULL,'2025-12-04 05:38:02','2025-12-04 05:40:06','687bf5d466067a4ba'),('69311e3af1e377af1','Process Webhook Queue',0,'Success','2025-12-04 05:40:00',1088928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:07','2025-12-04 05:40:07',1340390,1,NULL,NULL,NULL,'2025-12-04 05:38:02','2025-12-04 05:40:07','687bf5d5788e2fe0e'),('69311e75594ed5440','Submit Popup Reminders',0,'Success','2025-12-04 05:39:01',1088929,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:39:03','2025-12-04 05:39:03',1340297,1,NULL,NULL,NULL,'2025-12-04 05:39:01','2025-12-04 05:39:03','687bf57d2f9463790'),('69311e75790e19ffc','Process Job Queue q0',0,'Success','2025-12-04 05:39:01',1088930,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:39:04','2025-12-04 05:39:04',1340297,1,NULL,NULL,NULL,'2025-12-04 05:39:01','2025-12-04 05:39:04','687bf57d693e0fc1f'),('69311e759d04470d9','Process Job Queue q1',0,'Success','2025-12-04 05:40:00',1088931,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:08','2025-12-04 05:40:08',1340390,1,NULL,NULL,NULL,'2025-12-04 05:39:01','2025-12-04 05:40:08','687bf57d8afb5c472'),('69311e75b9b13266a','Process Job Queue e0',0,'Success','2025-12-04 05:39:01',1088932,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:39:05','2025-12-04 05:39:06',1340297,1,NULL,NULL,NULL,'2025-12-04 05:39:01','2025-12-04 05:39:06','687bf57dbba8299ef'),('69311eb1c79d9ddf8','Submit Popup Reminders',0,'Success','2025-12-04 05:40:01',1088933,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:08','2025-12-04 05:40:08',1340390,1,NULL,NULL,NULL,'2025-12-04 05:40:01','2025-12-04 05:40:08','687bf57d2f9463790'),('69311eb205c5e4675','Process Job Queue q0',0,'Success','2025-12-04 05:40:02',1088934,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:09','2025-12-04 05:40:09',1340390,1,NULL,NULL,NULL,'2025-12-04 05:40:02','2025-12-04 05:40:09','687bf57d693e0fc1f'),('69311eb234c60e484','Process Job Queue q1',0,'Success','2025-12-04 05:41:00',1088935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:41:02','2025-12-04 05:41:02',1340426,1,NULL,NULL,NULL,'2025-12-04 05:40:02','2025-12-04 05:41:02','687bf57d8afb5c472'),('69311eb250bd15428','Process Job Queue e0',0,'Success','2025-12-04 05:40:02',1088936,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:40:10','2025-12-04 05:40:10',1340390,1,NULL,NULL,NULL,'2025-12-04 05:40:02','2025-12-04 05:40:10','687bf57dbba8299ef'),('69311eb28a0b7aecf','Send Email Reminders',0,'Success','2025-12-04 05:42:00',1088937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:04','2025-12-04 05:42:05',1340460,1,NULL,NULL,NULL,'2025-12-04 05:40:02','2025-12-04 05:42:05','687bf5d44d3e10813'),('69311eb2b574ebe61','Send Email Notifications',0,'Success','2025-12-04 05:42:00',1088938,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:05','2025-12-04 05:42:06',1340460,1,NULL,NULL,NULL,'2025-12-04 05:40:02','2025-12-04 05:42:06','687bf5d466067a4ba'),('69311eb3144530acd','Process Webhook Queue',0,'Success','2025-12-04 05:42:00',1088939,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:06','2025-12-04 05:42:07',1340460,1,NULL,NULL,NULL,'2025-12-04 05:40:03','2025-12-04 05:42:07','687bf5d5788e2fe0e'),('69311eb3c61244e75','Send Scheduled Emails',0,'Success','2025-12-04 05:50:00',1088940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:04','2025-12-04 05:50:04',1340809,1,NULL,NULL,NULL,'2025-12-04 05:40:03','2025-12-04 05:50:04','687bf5d5eeb01d80d'),('69311eed866422263','Submit Popup Reminders',0,'Success','2025-12-04 05:41:01',1088941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:41:03','2025-12-04 05:41:03',1340426,1,NULL,NULL,NULL,'2025-12-04 05:41:01','2025-12-04 05:41:03','687bf57d2f9463790'),('69311eeda78ac63a9','Process Job Queue q0',0,'Success','2025-12-04 05:41:01',1088942,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:41:04','2025-12-04 05:41:04',1340426,1,NULL,NULL,NULL,'2025-12-04 05:41:01','2025-12-04 05:41:04','687bf57d693e0fc1f'),('69311eedc6353e6db','Process Job Queue q1',0,'Success','2025-12-04 05:42:00',1088943,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:07','2025-12-04 05:42:08',1340460,1,NULL,NULL,NULL,'2025-12-04 05:41:01','2025-12-04 05:42:08','687bf57d8afb5c472'),('69311eedeb1da25b6','Process Job Queue e0',0,'Success','2025-12-04 05:41:01',1088944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:41:05','2025-12-04 05:41:05',1340426,1,NULL,NULL,NULL,'2025-12-04 05:41:01','2025-12-04 05:41:05','687bf57dbba8299ef'),('69311f2a0f55d111b','Submit Popup Reminders',0,'Success','2025-12-04 05:42:02',1088945,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:08','2025-12-04 05:42:08',1340460,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:42:08','687bf57d2f9463790'),('69311f2a325f0b5f6','Process Job Queue q0',0,'Success','2025-12-04 05:42:02',1088946,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:09','2025-12-04 05:42:09',1340460,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:42:09','687bf57d693e0fc1f'),('69311f2a4ecf93ce9','Process Job Queue q1',0,'Success','2025-12-04 05:43:00',1088947,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:43:02','2025-12-04 05:43:02',1340498,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:43:02','687bf57d8afb5c472'),('69311f2a6f8e9f1cc','Process Job Queue e0',0,'Success','2025-12-04 05:42:02',1088948,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:42:10','2025-12-04 05:42:10',1340460,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:42:10','687bf57dbba8299ef'),('69311f2a9a21856e2','Send Email Reminders',0,'Success','2025-12-04 05:44:00',1088949,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:03','2025-12-04 05:44:03',1340537,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:44:03','687bf5d44d3e10813'),('69311f2ab38df68a8','Send Email Notifications',0,'Success','2025-12-04 05:44:00',1088950,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:04','2025-12-04 05:44:04',1340537,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:44:04','687bf5d466067a4ba'),('69311f2ad790b6795','Auth Token Control',0,'Success','2025-12-04 05:48:00',1088951,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:02','2025-12-04 05:48:03',1340707,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:48:03','687bf5d511e08c57f'),('69311f2af36119746','Process Webhook Queue',0,'Success','2025-12-04 05:44:00',1088952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:05','2025-12-04 05:44:05',1340537,1,NULL,NULL,NULL,'2025-12-04 05:42:02','2025-12-04 05:44:05','687bf5d5788e2fe0e'),('69311f657af753b6b','Submit Popup Reminders',0,'Success','2025-12-04 05:43:01',1088953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:43:03','2025-12-04 05:43:04',1340498,1,NULL,NULL,NULL,'2025-12-04 05:43:01','2025-12-04 05:43:04','687bf57d2f9463790'),('69311f65b59c39172','Process Job Queue q0',0,'Success','2025-12-04 05:43:01',1088954,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:43:04','2025-12-04 05:43:05',1340498,1,NULL,NULL,NULL,'2025-12-04 05:43:01','2025-12-04 05:43:05','687bf57d693e0fc1f'),('69311f65e6536ea92','Process Job Queue q1',0,'Success','2025-12-04 05:44:00',1088955,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:06','2025-12-04 05:44:06',1340537,1,NULL,NULL,NULL,'2025-12-04 05:43:01','2025-12-04 05:44:06','687bf57d8afb5c472'),('69311f661003d0dbc','Process Job Queue e0',0,'Success','2025-12-04 05:43:02',1088956,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:43:05','2025-12-04 05:43:06',1340498,1,NULL,NULL,NULL,'2025-12-04 05:43:02','2025-12-04 05:43:06','687bf57dbba8299ef'),('69311fa1a25d80c3c','Submit Popup Reminders',0,'Success','2025-12-04 05:44:01',1088957,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:07','2025-12-04 05:44:07',1340537,1,NULL,NULL,NULL,'2025-12-04 05:44:01','2025-12-04 05:44:07','687bf57d2f9463790'),('69311fa1d5197ad7c','Process Job Queue q0',0,'Success','2025-12-04 05:44:01',1088958,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:08','2025-12-04 05:44:08',1340537,1,NULL,NULL,NULL,'2025-12-04 05:44:01','2025-12-04 05:44:08','687bf57d693e0fc1f'),('69311fa203c0d4776','Process Job Queue q1',0,'Success','2025-12-04 05:45:00',1088959,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:45:02','2025-12-04 05:45:02',1340578,1,NULL,NULL,NULL,'2025-12-04 05:44:02','2025-12-04 05:45:02','687bf57d8afb5c472'),('69311fa22b8a2d712','Process Job Queue e0',0,'Success','2025-12-04 05:44:02',1088960,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:44:09','2025-12-04 05:44:09',1340537,1,NULL,NULL,NULL,'2025-12-04 05:44:02','2025-12-04 05:44:09','687bf57dbba8299ef'),('69311fa250a3a5ac1','Send Email Reminders',0,'Success','2025-12-04 05:46:00',1088961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:03','2025-12-04 05:46:03',1340620,1,NULL,NULL,NULL,'2025-12-04 05:44:02','2025-12-04 05:46:03','687bf5d44d3e10813'),('69311fa26fa13bd5e','Send Email Notifications',0,'Success','2025-12-04 05:46:00',1088962,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:04','2025-12-04 05:46:04',1340620,1,NULL,NULL,NULL,'2025-12-04 05:44:02','2025-12-04 05:46:04','687bf5d466067a4ba'),('69311fa2ad60488f9','Process Webhook Queue',0,'Success','2025-12-04 05:46:00',1088963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:05','2025-12-04 05:46:05',1340620,1,NULL,NULL,NULL,'2025-12-04 05:44:02','2025-12-04 05:46:05','687bf5d5788e2fe0e'),('69311fdd76a48f914','Submit Popup Reminders',0,'Success','2025-12-04 05:45:01',1088964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:45:03','2025-12-04 05:45:03',1340578,1,NULL,NULL,NULL,'2025-12-04 05:45:01','2025-12-04 05:45:03','687bf57d2f9463790'),('69311fdda126cd469','Process Job Queue q0',0,'Success','2025-12-04 05:45:01',1088965,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:45:04','2025-12-04 05:45:04',1340578,1,NULL,NULL,NULL,'2025-12-04 05:45:01','2025-12-04 05:45:04','687bf57d693e0fc1f'),('69311fddbae8ac4e4','Process Job Queue q1',0,'Success','2025-12-04 05:46:00',1088966,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:06','2025-12-04 05:46:06',1340620,1,NULL,NULL,NULL,'2025-12-04 05:45:01','2025-12-04 05:46:06','687bf57d8afb5c472'),('69311fdde5c60104a','Process Job Queue e0',0,'Success','2025-12-04 05:45:01',1088967,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:45:05','2025-12-04 05:45:05',1340578,1,NULL,NULL,NULL,'2025-12-04 05:45:01','2025-12-04 05:45:05','687bf57dbba8299ef'),('6931201996266a1a6','Submit Popup Reminders',0,'Success','2025-12-04 05:46:01',1088968,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:07','2025-12-04 05:46:07',1340620,1,NULL,NULL,NULL,'2025-12-04 05:46:01','2025-12-04 05:46:07','687bf57d2f9463790'),('69312019d3d65f305','Process Job Queue q0',0,'Success','2025-12-04 05:46:01',1088969,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:07','2025-12-04 05:46:07',1340620,1,NULL,NULL,NULL,'2025-12-04 05:46:01','2025-12-04 05:46:07','687bf57d693e0fc1f'),('6931201a01c60353f','Process Job Queue q1',0,'Success','2025-12-04 05:47:00',1088970,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:47:03','2025-12-04 05:47:04',1340656,1,NULL,NULL,NULL,'2025-12-04 05:46:02','2025-12-04 05:47:04','687bf57d8afb5c472'),('6931201a25a8c2189','Process Job Queue e0',0,'Success','2025-12-04 05:46:02',1088971,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:46:08','2025-12-04 05:46:08',1340620,1,NULL,NULL,NULL,'2025-12-04 05:46:02','2025-12-04 05:46:08','687bf57dbba8299ef'),('6931201a511dbf890','Send Email Reminders',0,'Success','2025-12-04 05:48:00',1088972,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:04','2025-12-04 05:48:05',1340707,1,NULL,NULL,NULL,'2025-12-04 05:46:02','2025-12-04 05:48:05','687bf5d44d3e10813'),('6931201a71df33f37','Send Email Notifications',0,'Success','2025-12-04 05:48:00',1088973,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:05','2025-12-04 05:48:06',1340707,1,NULL,NULL,NULL,'2025-12-04 05:46:02','2025-12-04 05:48:06','687bf5d466067a4ba'),('6931201aa06bd198b','Process Webhook Queue',0,'Success','2025-12-04 05:48:00',1088974,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:06','2025-12-04 05:48:06',1340707,1,NULL,NULL,NULL,'2025-12-04 05:46:02','2025-12-04 05:48:06','687bf5d5788e2fe0e'),('69312055d290e9005','Submit Popup Reminders',0,'Success','2025-12-04 05:47:01',1088975,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:47:05','2025-12-04 05:47:05',1340656,1,NULL,NULL,NULL,'2025-12-04 05:47:01','2025-12-04 05:47:05','687bf57d2f9463790'),('693120560905fccaa','Process Job Queue q0',0,'Success','2025-12-04 05:47:02',1088976,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:47:06','2025-12-04 05:47:06',1340656,1,NULL,NULL,NULL,'2025-12-04 05:47:02','2025-12-04 05:47:06','687bf57d693e0fc1f'),('6931205623aba0857','Process Job Queue q1',0,'Success','2025-12-04 05:48:00',1088977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:07','2025-12-04 05:48:07',1340707,1,NULL,NULL,NULL,'2025-12-04 05:47:02','2025-12-04 05:48:07','687bf57d8afb5c472'),('693120564b86228c4','Process Job Queue e0',0,'Success','2025-12-04 05:47:02',1088978,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:47:06','2025-12-04 05:47:06',1340656,1,NULL,NULL,NULL,'2025-12-04 05:47:02','2025-12-04 05:47:06','687bf57dbba8299ef'),('693120915994fc1cd','Submit Popup Reminders',0,'Success','2025-12-04 05:48:01',1088979,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:08','2025-12-04 05:48:08',1340707,1,NULL,NULL,NULL,'2025-12-04 05:48:01','2025-12-04 05:48:08','687bf57d2f9463790'),('693120917c6564093','Process Job Queue q0',0,'Success','2025-12-04 05:48:01',1088980,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:08','2025-12-04 05:48:08',1340707,1,NULL,NULL,NULL,'2025-12-04 05:48:01','2025-12-04 05:48:08','687bf57d693e0fc1f'),('69312091a513df2f8','Process Job Queue q1',0,'Success','2025-12-04 05:49:00',1088981,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:49:02','2025-12-04 05:49:02',1340773,1,NULL,NULL,NULL,'2025-12-04 05:48:01','2025-12-04 05:49:02','687bf57d8afb5c472'),('69312091c3048bf6c','Process Job Queue e0',0,'Success','2025-12-04 05:48:01',1088982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:48:09','2025-12-04 05:48:09',1340707,1,NULL,NULL,NULL,'2025-12-04 05:48:01','2025-12-04 05:48:09','687bf57dbba8299ef'),('69312091eac59eb3f','Send Email Reminders',0,'Success','2025-12-04 05:50:00',1088983,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:05','2025-12-04 05:50:05',1340809,1,NULL,NULL,NULL,'2025-12-04 05:48:01','2025-12-04 05:50:05','687bf5d44d3e10813'),('693120921cd0f1a63','Send Email Notifications',0,'Success','2025-12-04 05:50:00',1088984,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:06','2025-12-04 05:50:06',1340809,1,NULL,NULL,NULL,'2025-12-04 05:48:02','2025-12-04 05:50:06','687bf5d466067a4ba'),('69312092515cb7a5b','Auth Token Control',0,'Success','2025-12-04 05:54:00',1088985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:04','2025-12-04 05:54:04',1340914,1,NULL,NULL,NULL,'2025-12-04 05:48:02','2025-12-04 05:54:04','687bf5d511e08c57f'),('6931209287bc67f86','Process Webhook Queue',0,'Success','2025-12-04 05:50:00',1088986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:07','2025-12-04 05:50:07',1340809,1,NULL,NULL,NULL,'2025-12-04 05:48:02','2025-12-04 05:50:07','687bf5d5788e2fe0e'),('693120cddbd0808f7','Submit Popup Reminders',0,'Success','2025-12-04 05:49:01',1088987,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:49:03','2025-12-04 05:49:04',1340773,1,NULL,NULL,NULL,'2025-12-04 05:49:01','2025-12-04 05:49:04','687bf57d2f9463790'),('693120ce168e5a4a7','Process Job Queue q0',0,'Success','2025-12-04 05:49:02',1088988,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:49:04','2025-12-04 05:49:05',1340773,1,NULL,NULL,NULL,'2025-12-04 05:49:02','2025-12-04 05:49:05','687bf57d693e0fc1f'),('693120ce307b1c20c','Process Job Queue q1',0,'Success','2025-12-04 05:50:00',1088989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:07','2025-12-04 05:50:07',1340809,1,NULL,NULL,NULL,'2025-12-04 05:49:02','2025-12-04 05:50:07','687bf57d8afb5c472'),('693120ce4a9550d93','Process Job Queue e0',0,'Success','2025-12-04 05:49:02',1088990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:49:05','2025-12-04 05:49:06',1340773,1,NULL,NULL,NULL,'2025-12-04 05:49:02','2025-12-04 05:49:06','687bf57dbba8299ef'),('6931210952e6860a8','Submit Popup Reminders',0,'Success','2025-12-04 05:50:01',1088991,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:08','2025-12-04 05:50:08',1340809,1,NULL,NULL,NULL,'2025-12-04 05:50:01','2025-12-04 05:50:08','687bf57d2f9463790'),('6931210970608e212','Process Job Queue q0',0,'Success','2025-12-04 05:50:01',1088992,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:08','2025-12-04 05:50:09',1340809,1,NULL,NULL,NULL,'2025-12-04 05:50:01','2025-12-04 05:50:09','687bf57d693e0fc1f'),('693121098ae130730','Process Job Queue q1',0,'Success','2025-12-04 05:51:00',1088993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:51:02','2025-12-04 05:51:03',1340857,1,NULL,NULL,NULL,'2025-12-04 05:50:01','2025-12-04 05:51:03','687bf57d8afb5c472'),('69312109acc161551','Process Job Queue e0',0,'Success','2025-12-04 05:50:01',1088994,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:50:09','2025-12-04 05:50:09',1340809,1,NULL,NULL,NULL,'2025-12-04 05:50:01','2025-12-04 05:50:09','687bf57dbba8299ef'),('69312109daf91d592','Send Email Reminders',0,'Success','2025-12-04 05:52:00',1088995,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:04','2025-12-04 05:52:04',1340872,1,NULL,NULL,NULL,'2025-12-04 05:50:01','2025-12-04 05:52:04','687bf5d44d3e10813'),('6931210a0ae8f759a','Send Email Notifications',0,'Success','2025-12-04 05:52:00',1088996,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:05','2025-12-04 05:52:05',1340872,1,NULL,NULL,NULL,'2025-12-04 05:50:02','2025-12-04 05:52:05','687bf5d466067a4ba'),('6931210a2e23476bb','Send Mass Emails',0,'Success','2025-12-04 06:10:00',1088997,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:03','2025-12-04 06:10:04',1341472,1,NULL,NULL,NULL,'2025-12-04 05:50:02','2025-12-04 06:10:04','687bf5d4b535f913f'),('6931210a519f335b7','Process Webhook Queue',0,'Success','2025-12-04 05:52:00',1088998,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:05','2025-12-04 05:52:05',1340872,1,NULL,NULL,NULL,'2025-12-04 05:50:02','2025-12-04 05:52:05','687bf5d5788e2fe0e'),('6931210aaa69f3dc4','Send Scheduled Emails',0,'Success','2025-12-04 06:00:00',1088999,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:04','2025-12-04 06:00:04',1341017,1,NULL,NULL,NULL,'2025-12-04 05:50:02','2025-12-04 06:00:04','687bf5d5eeb01d80d'),('69312145bfa1d0b29','Submit Popup Reminders',0,'Success','2025-12-04 05:51:01',1089000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:51:03','2025-12-04 05:51:03',1340857,1,NULL,NULL,NULL,'2025-12-04 05:51:01','2025-12-04 05:51:03','687bf57d2f9463790'),('69312145e4e568c1d','Process Job Queue q0',0,'Success','2025-12-04 05:51:01',1089001,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:51:04','2025-12-04 05:51:04',1340857,1,NULL,NULL,NULL,'2025-12-04 05:51:01','2025-12-04 05:51:04','687bf57d693e0fc1f'),('693121462a8ba2cba','Process Job Queue q1',0,'Success','2025-12-04 05:52:00',1089002,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:06','2025-12-04 05:52:06',1340872,1,NULL,NULL,NULL,'2025-12-04 05:51:02','2025-12-04 05:52:06','687bf57d8afb5c472'),('69312146642cacb29','Process Job Queue e0',0,'Success','2025-12-04 05:51:02',1089003,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:51:05','2025-12-04 05:51:05',1340857,1,NULL,NULL,NULL,'2025-12-04 05:51:02','2025-12-04 05:51:05','687bf57dbba8299ef'),('693121821dcc365fb','Submit Popup Reminders',0,'Success','2025-12-04 05:52:02',1089004,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:07','2025-12-04 05:52:07',1340872,1,NULL,NULL,NULL,'2025-12-04 05:52:02','2025-12-04 05:52:07','687bf57d2f9463790'),('693121825b6faa99a','Process Job Queue q0',0,'Success','2025-12-04 05:52:02',1089005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:07','2025-12-04 05:52:07',1340872,1,NULL,NULL,NULL,'2025-12-04 05:52:02','2025-12-04 05:52:07','687bf57d693e0fc1f'),('693121828e070ce24','Process Job Queue q1',0,'Success','2025-12-04 05:53:00',1089006,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:53:02','2025-12-04 05:53:02',1340896,1,NULL,NULL,NULL,'2025-12-04 05:52:02','2025-12-04 05:53:02','687bf57d8afb5c472'),('693121832c59c8239','Process Job Queue e0',0,'Success','2025-12-04 05:52:03',1089007,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:52:08','2025-12-04 05:52:08',1340872,1,NULL,NULL,NULL,'2025-12-04 05:52:03','2025-12-04 05:52:08','687bf57dbba8299ef'),('693121837022631d7','Send Email Reminders',0,'Success','2025-12-04 05:54:00',1089008,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:04','2025-12-04 05:54:05',1340914,1,NULL,NULL,NULL,'2025-12-04 05:52:03','2025-12-04 05:54:05','687bf5d44d3e10813'),('69312183b40cd9a11','Send Email Notifications',0,'Success','2025-12-04 05:54:00',1089009,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:05','2025-12-04 05:54:05',1340914,1,NULL,NULL,NULL,'2025-12-04 05:52:03','2025-12-04 05:54:05','687bf5d466067a4ba'),('69312183ecaa782e5','Process Webhook Queue',0,'Success','2025-12-04 05:54:00',1089010,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:06','2025-12-04 05:54:06',1340914,1,NULL,NULL,NULL,'2025-12-04 05:52:03','2025-12-04 05:54:06','687bf5d5788e2fe0e'),('693121bd637161166','Submit Popup Reminders',0,'Success','2025-12-04 05:53:01',1089011,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:53:03','2025-12-04 05:53:03',1340896,1,NULL,NULL,NULL,'2025-12-04 05:53:01','2025-12-04 05:53:03','687bf57d2f9463790'),('693121bd8c9e02ac4','Process Job Queue q0',0,'Success','2025-12-04 05:53:01',1089012,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:53:04','2025-12-04 05:53:04',1340896,1,NULL,NULL,NULL,'2025-12-04 05:53:01','2025-12-04 05:53:04','687bf57d693e0fc1f'),('693121bdb1772af8b','Process Job Queue q1',0,'Success','2025-12-04 05:54:00',1089013,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:07','2025-12-04 05:54:07',1340914,1,NULL,NULL,NULL,'2025-12-04 05:53:01','2025-12-04 05:54:07','687bf57d8afb5c472'),('693121be0257bfca2','Process Job Queue e0',0,'Success','2025-12-04 05:53:02',1089014,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:53:05','2025-12-04 05:53:05',1340896,1,NULL,NULL,NULL,'2025-12-04 05:53:02','2025-12-04 05:53:05','687bf57dbba8299ef'),('693121f9e685fe9ab','Submit Popup Reminders',0,'Success','2025-12-04 05:54:01',1089015,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:07','2025-12-04 05:54:08',1340914,1,NULL,NULL,NULL,'2025-12-04 05:54:01','2025-12-04 05:54:08','687bf57d2f9463790'),('693121fa258ac47de','Process Job Queue q0',0,'Success','2025-12-04 05:54:02',1089016,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:08','2025-12-04 05:54:08',1340914,1,NULL,NULL,NULL,'2025-12-04 05:54:02','2025-12-04 05:54:08','687bf57d693e0fc1f'),('693121fa45f42a027','Process Job Queue q1',0,'Success','2025-12-04 05:55:00',1089017,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:55:01','2025-12-04 05:55:02',1340928,1,NULL,NULL,NULL,'2025-12-04 05:54:02','2025-12-04 05:55:02','687bf57d8afb5c472'),('693121fa907147f50','Process Job Queue e0',0,'Success','2025-12-04 05:54:02',1089018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:54:09','2025-12-04 05:54:09',1340914,1,NULL,NULL,NULL,'2025-12-04 05:54:02','2025-12-04 05:54:09','687bf57dbba8299ef'),('693121fb29197fa91','Send Email Reminders',0,'Success','2025-12-04 05:56:00',1089019,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:03','2025-12-04 05:56:03',1340950,1,NULL,NULL,NULL,'2025-12-04 05:54:03','2025-12-04 05:56:03','687bf5d44d3e10813'),('693121fb754555230','Send Email Notifications',0,'Success','2025-12-04 05:56:00',1089020,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:04','2025-12-04 05:56:04',1340950,1,NULL,NULL,NULL,'2025-12-04 05:54:03','2025-12-04 05:56:04','687bf5d466067a4ba'),('693121fba9a1dbc29','Auth Token Control',0,'Success','2025-12-04 06:00:00',1089021,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:05','2025-12-04 06:00:05',1341017,1,NULL,NULL,NULL,'2025-12-04 05:54:03','2025-12-04 06:00:05','687bf5d511e08c57f'),('693121fbe1f7db8b1','Process Webhook Queue',0,'Success','2025-12-04 05:56:00',1089022,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:04','2025-12-04 05:56:05',1340950,1,NULL,NULL,NULL,'2025-12-04 05:54:03','2025-12-04 05:56:05','687bf5d5788e2fe0e'),('6931223530264a15a','Submit Popup Reminders',0,'Success','2025-12-04 05:55:01',1089023,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:55:02','2025-12-04 05:55:03',1340928,1,NULL,NULL,NULL,'2025-12-04 05:55:01','2025-12-04 05:55:03','687bf57d2f9463790'),('693122355541f216e','Process Job Queue q0',0,'Success','2025-12-04 05:55:01',1089024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:55:04','2025-12-04 05:55:04',1340928,1,NULL,NULL,NULL,'2025-12-04 05:55:01','2025-12-04 05:55:04','687bf57d693e0fc1f'),('6931223571eb2930f','Process Job Queue q1',0,'Success','2025-12-04 05:56:00',1089025,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:05','2025-12-04 05:56:05',1340950,1,NULL,NULL,NULL,'2025-12-04 05:55:01','2025-12-04 05:56:05','687bf57d8afb5c472'),('693122359bf502887','Process Job Queue e0',0,'Success','2025-12-04 05:55:01',1089026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:55:04','2025-12-04 05:55:05',1340928,1,NULL,NULL,NULL,'2025-12-04 05:55:01','2025-12-04 05:55:05','687bf57dbba8299ef'),('6931227127cf559b6','Submit Popup Reminders',0,'Success','2025-12-04 05:56:01',1089027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:06','2025-12-04 05:56:06',1340950,1,NULL,NULL,NULL,'2025-12-04 05:56:01','2025-12-04 05:56:06','687bf57d2f9463790'),('693122714ab11032a','Process Job Queue q0',0,'Success','2025-12-04 05:56:01',1089028,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:06','2025-12-04 05:56:07',1340950,1,NULL,NULL,NULL,'2025-12-04 05:56:01','2025-12-04 05:56:07','687bf57d693e0fc1f'),('693122716df1c980f','Process Job Queue q1',0,'Success','2025-12-04 05:57:00',1089029,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:57:02','2025-12-04 05:57:03',1340964,1,NULL,NULL,NULL,'2025-12-04 05:56:01','2025-12-04 05:57:03','687bf57d8afb5c472'),('69312272454c4c1b3','Process Job Queue e0',0,'Success','2025-12-04 05:56:02',1089030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:56:07','2025-12-04 05:56:07',1340950,1,NULL,NULL,NULL,'2025-12-04 05:56:02','2025-12-04 05:56:07','687bf57dbba8299ef'),('6931227281806a678','Send Email Reminders',0,'Success','2025-12-04 05:58:00',1089031,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:02','2025-12-04 05:58:03',1340982,1,NULL,NULL,NULL,'2025-12-04 05:56:02','2025-12-04 05:58:03','687bf5d44d3e10813'),('69312272b82dc47d8','Send Email Notifications',0,'Success','2025-12-04 05:58:00',1089032,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:04','2025-12-04 05:58:04',1340982,1,NULL,NULL,NULL,'2025-12-04 05:56:02','2025-12-04 05:58:04','687bf5d466067a4ba'),('693122731f4ce6465','Process Webhook Queue',0,'Success','2025-12-04 05:58:00',1089033,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:04','2025-12-04 05:58:05',1340982,1,NULL,NULL,NULL,'2025-12-04 05:56:03','2025-12-04 05:58:05','687bf5d5788e2fe0e'),('693122ae036c24509','Submit Popup Reminders',0,'Success','2025-12-04 05:57:02',1089034,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:57:04','2025-12-04 05:57:04',1340964,1,NULL,NULL,NULL,'2025-12-04 05:57:02','2025-12-04 05:57:04','687bf57d2f9463790'),('693122ae2f8c7d665','Process Job Queue q0',0,'Success','2025-12-04 05:57:02',1089035,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:57:05','2025-12-04 05:57:05',1340964,1,NULL,NULL,NULL,'2025-12-04 05:57:02','2025-12-04 05:57:05','687bf57d693e0fc1f'),('693122ae5cc5d4b87','Process Job Queue q1',0,'Success','2025-12-04 05:58:00',1089036,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:05','2025-12-04 05:58:06',1340982,1,NULL,NULL,NULL,'2025-12-04 05:57:02','2025-12-04 05:58:06','687bf57d8afb5c472'),('693122ae887d74543','Process Job Queue e0',0,'Success','2025-12-04 05:57:02',1089037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:57:06','2025-12-04 05:57:06',1340964,1,NULL,NULL,NULL,'2025-12-04 05:57:02','2025-12-04 05:57:06','687bf57dbba8299ef'),('693122e9329994f92','Submit Popup Reminders',0,'Success','2025-12-04 05:58:01',1089038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:06','2025-12-04 05:58:06',1340982,1,NULL,NULL,NULL,'2025-12-04 05:58:01','2025-12-04 05:58:06','687bf57d2f9463790'),('693122e9657b32bb5','Process Job Queue q0',0,'Success','2025-12-04 05:58:01',1089039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:07','2025-12-04 05:58:07',1340982,1,NULL,NULL,NULL,'2025-12-04 05:58:01','2025-12-04 05:58:07','687bf57d693e0fc1f'),('693122e989831b468','Process Job Queue q1',0,'Success','2025-12-04 05:59:00',1089040,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:59:02','2025-12-04 05:59:02',1340998,1,NULL,NULL,NULL,'2025-12-04 05:58:01','2025-12-04 05:59:02','687bf57d8afb5c472'),('693122e9ba154daae','Process Job Queue e0',0,'Success','2025-12-04 05:58:01',1089041,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:58:08','2025-12-04 05:58:08',1340982,1,NULL,NULL,NULL,'2025-12-04 05:58:01','2025-12-04 05:58:08','687bf57dbba8299ef'),('693122e9e6e1962ae','Send Email Reminders',0,'Success','2025-12-04 06:00:00',1089042,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:06','2025-12-04 06:00:06',1341017,1,NULL,NULL,NULL,'2025-12-04 05:58:01','2025-12-04 06:00:06','687bf5d44d3e10813'),('693122ea0fd55086c','Send Email Notifications',0,'Success','2025-12-04 06:00:00',1089043,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:07','2025-12-04 06:00:07',1341017,1,NULL,NULL,NULL,'2025-12-04 05:58:02','2025-12-04 06:00:07','687bf5d466067a4ba'),('693122ea36610b77f','Process Webhook Queue',0,'Success','2025-12-04 06:00:00',1089044,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:07','2025-12-04 06:00:07',1341017,1,NULL,NULL,NULL,'2025-12-04 05:58:02','2025-12-04 06:00:07','687bf5d5788e2fe0e'),('69312325ca21747b3','Submit Popup Reminders',0,'Success','2025-12-04 05:59:01',1089045,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:59:03','2025-12-04 05:59:03',1340998,1,NULL,NULL,NULL,'2025-12-04 05:59:01','2025-12-04 05:59:03','687bf57d2f9463790'),('69312325ed654f06f','Process Job Queue q0',0,'Success','2025-12-04 05:59:01',1089046,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:59:04','2025-12-04 05:59:05',1340998,1,NULL,NULL,NULL,'2025-12-04 05:59:01','2025-12-04 05:59:05','687bf57d693e0fc1f'),('693123261f603c0e0','Process Job Queue q1',0,'Success','2025-12-04 06:00:00',1089047,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:08','2025-12-04 06:00:08',1341017,1,NULL,NULL,NULL,'2025-12-04 05:59:02','2025-12-04 06:00:08','687bf57d8afb5c472'),('6931232643ffbcc34','Process Job Queue e0',0,'Success','2025-12-04 05:59:02',1089048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 05:59:05','2025-12-04 05:59:05',1340998,1,NULL,NULL,NULL,'2025-12-04 05:59:02','2025-12-04 05:59:05','687bf57dbba8299ef'),('69312361af9fc4b96','Submit Popup Reminders',0,'Success','2025-12-04 06:00:01',1089049,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:09','2025-12-04 06:00:09',1341017,1,NULL,NULL,NULL,'2025-12-04 06:00:01','2025-12-04 06:00:09','687bf57d2f9463790'),('69312361dc25f123b','Process Job Queue q0',0,'Success','2025-12-04 06:00:01',1089050,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:09','2025-12-04 06:00:09',1341017,1,NULL,NULL,NULL,'2025-12-04 06:00:01','2025-12-04 06:00:09','687bf57d693e0fc1f'),('6931236206aca1eea','Process Job Queue q1',0,'Success','2025-12-04 06:01:00',1089051,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:01:02','2025-12-04 06:01:02',1341065,1,NULL,NULL,NULL,'2025-12-04 06:00:02','2025-12-04 06:01:02','687bf57d8afb5c472'),('693123622c8eab8ca','Process Job Queue e0',0,'Success','2025-12-04 06:00:02',1089052,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:00:10','2025-12-04 06:00:10',1341017,1,NULL,NULL,NULL,'2025-12-04 06:00:02','2025-12-04 06:00:10','687bf57dbba8299ef'),('693123626734983a1','Send Email Reminders',0,'Success','2025-12-04 06:02:00',1089053,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:03','2025-12-04 06:02:03',1341104,1,NULL,NULL,NULL,'2025-12-04 06:00:02','2025-12-04 06:02:03','687bf5d44d3e10813'),('69312362b8228bb3e','Send Email Notifications',0,'Success','2025-12-04 06:02:00',1089054,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:04','2025-12-04 06:02:04',1341104,1,NULL,NULL,NULL,'2025-12-04 06:00:02','2025-12-04 06:02:04','687bf5d466067a4ba'),('6931236317726f317','Auth Token Control',0,'Success','2025-12-04 06:06:00',1089055,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:03','2025-12-04 06:06:03',1341255,1,NULL,NULL,NULL,'2025-12-04 06:00:03','2025-12-04 06:06:03','687bf5d511e08c57f'),('69312363e9450ffc9','Process Webhook Queue',0,'Success','2025-12-04 06:02:00',1089056,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:04','2025-12-04 06:02:05',1341104,1,NULL,NULL,NULL,'2025-12-04 06:00:03','2025-12-04 06:02:05','687bf5d5788e2fe0e'),('693123643eac5d3d7','Send Scheduled Emails',0,'Success','2025-12-04 06:10:00',1089057,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:05','2025-12-04 06:10:05',1341472,1,NULL,NULL,NULL,'2025-12-04 06:00:04','2025-12-04 06:10:05','687bf5d5eeb01d80d'),('6931239d4bea90752','Submit Popup Reminders',0,'Success','2025-12-04 06:01:01',1089058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:01:03','2025-12-04 06:01:03',1341065,1,NULL,NULL,NULL,'2025-12-04 06:01:01','2025-12-04 06:01:03','687bf57d2f9463790'),('6931239d798aaf253','Process Job Queue q0',0,'Success','2025-12-04 06:01:01',1089059,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:01:04','2025-12-04 06:01:04',1341065,1,NULL,NULL,NULL,'2025-12-04 06:01:01','2025-12-04 06:01:04','687bf57d693e0fc1f'),('6931239da2686e21b','Process Job Queue q1',0,'Success','2025-12-04 06:02:00',1089060,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:05','2025-12-04 06:02:05',1341104,1,NULL,NULL,NULL,'2025-12-04 06:01:01','2025-12-04 06:02:05','687bf57d8afb5c472'),('6931239ddc7e03ee6','Process Job Queue e0',0,'Success','2025-12-04 06:01:01',1089061,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:01:05','2025-12-04 06:01:05',1341065,1,NULL,NULL,NULL,'2025-12-04 06:01:01','2025-12-04 06:01:05','687bf57dbba8299ef'),('693123d942acf3d93','Submit Popup Reminders',0,'Success','2025-12-04 06:02:01',1089062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:06','2025-12-04 06:02:06',1341104,1,NULL,NULL,NULL,'2025-12-04 06:02:01','2025-12-04 06:02:06','687bf57d2f9463790'),('693123d96d0616b95','Process Job Queue q0',0,'Success','2025-12-04 06:02:01',1089063,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:07','2025-12-04 06:02:07',1341104,1,NULL,NULL,NULL,'2025-12-04 06:02:01','2025-12-04 06:02:07','687bf57d693e0fc1f'),('693123d9a86e75aff','Process Job Queue q1',0,'Success','2025-12-04 06:03:00',1089064,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:03:02','2025-12-04 06:03:02',1341141,1,NULL,NULL,NULL,'2025-12-04 06:02:01','2025-12-04 06:03:02','687bf57d8afb5c472'),('693123da06c00f187','Process Job Queue e0',0,'Success','2025-12-04 06:02:02',1089065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:02:07','2025-12-04 06:02:07',1341104,1,NULL,NULL,NULL,'2025-12-04 06:02:02','2025-12-04 06:02:07','687bf57dbba8299ef'),('693123da685877b3f','Send Email Reminders',0,'Success','2025-12-04 06:04:00',1089066,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:03','2025-12-04 06:04:03',1341181,1,NULL,NULL,NULL,'2025-12-04 06:02:02','2025-12-04 06:04:03','687bf5d44d3e10813'),('693123daaea593a60','Send Email Notifications',0,'Success','2025-12-04 06:04:00',1089067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:04','2025-12-04 06:04:04',1341181,1,NULL,NULL,NULL,'2025-12-04 06:02:02','2025-12-04 06:04:04','687bf5d466067a4ba'),('693123daee52fc245','Process Webhook Queue',0,'Success','2025-12-04 06:04:00',1089068,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:05','2025-12-04 06:04:05',1341181,1,NULL,NULL,NULL,'2025-12-04 06:02:02','2025-12-04 06:04:05','687bf5d5788e2fe0e'),('69312415e126ec307','Submit Popup Reminders',0,'Success','2025-12-04 06:03:01',1089069,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:03:03','2025-12-04 06:03:04',1341141,1,NULL,NULL,NULL,'2025-12-04 06:03:01','2025-12-04 06:03:04','687bf57d2f9463790'),('693124160c3a4caf4','Process Job Queue q0',0,'Success','2025-12-04 06:03:02',1089070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:03:04','2025-12-04 06:03:04',1341141,1,NULL,NULL,NULL,'2025-12-04 06:03:02','2025-12-04 06:03:04','687bf57d693e0fc1f'),('693124162ce30b0f2','Process Job Queue q1',0,'Success','2025-12-04 06:04:00',1089071,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:05','2025-12-04 06:04:05',1341181,1,NULL,NULL,NULL,'2025-12-04 06:03:02','2025-12-04 06:04:05','687bf57d8afb5c472'),('69312416448c44cf8','Process Job Queue e0',0,'Success','2025-12-04 06:03:02',1089072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:03:05','2025-12-04 06:03:05',1341141,1,NULL,NULL,NULL,'2025-12-04 06:03:02','2025-12-04 06:03:05','687bf57dbba8299ef'),('69312451785a90a5b','Submit Popup Reminders',0,'Success','2025-12-04 06:04:01',1089073,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:06','2025-12-04 06:04:06',1341181,1,NULL,NULL,NULL,'2025-12-04 06:04:01','2025-12-04 06:04:06','687bf57d2f9463790'),('69312451a1bbf8b5d','Process Job Queue q0',0,'Success','2025-12-04 06:04:01',1089074,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:07','2025-12-04 06:04:07',1341181,1,NULL,NULL,NULL,'2025-12-04 06:04:01','2025-12-04 06:04:07','687bf57d693e0fc1f'),('69312451ca849d87b','Process Job Queue q1',0,'Success','2025-12-04 06:05:00',1089075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:05:02','2025-12-04 06:05:02',1341218,1,NULL,NULL,NULL,'2025-12-04 06:04:01','2025-12-04 06:05:02','687bf57d8afb5c472'),('693124520eb5acda7','Process Job Queue e0',0,'Success','2025-12-04 06:04:02',1089076,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:04:08','2025-12-04 06:04:08',1341181,1,NULL,NULL,NULL,'2025-12-04 06:04:02','2025-12-04 06:04:08','687bf57dbba8299ef'),('69312452323a1603f','Send Email Reminders',0,'Success','2025-12-04 06:06:00',1089077,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:04','2025-12-04 06:06:04',1341255,1,NULL,NULL,NULL,'2025-12-04 06:04:02','2025-12-04 06:06:04','687bf5d44d3e10813'),('69312452714cec825','Send Email Notifications',0,'Success','2025-12-04 06:06:00',1089078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:05','2025-12-04 06:06:05',1341255,1,NULL,NULL,NULL,'2025-12-04 06:04:02','2025-12-04 06:06:05','687bf5d466067a4ba'),('69312452d34008778','Process Webhook Queue',0,'Success','2025-12-04 06:06:00',1089079,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:06','2025-12-04 06:06:06',1341255,1,NULL,NULL,NULL,'2025-12-04 06:04:02','2025-12-04 06:06:06','687bf5d5788e2fe0e'),('6931248d4eb6f7f58','Submit Popup Reminders',0,'Success','2025-12-04 06:05:01',1089080,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:05:02','2025-12-04 06:05:03',1341218,1,NULL,NULL,NULL,'2025-12-04 06:05:01','2025-12-04 06:05:03','687bf57d2f9463790'),('6931248d797d0166d','Process Job Queue q0',0,'Success','2025-12-04 06:05:01',1089081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:05:04','2025-12-04 06:05:04',1341218,1,NULL,NULL,NULL,'2025-12-04 06:05:01','2025-12-04 06:05:04','687bf57d693e0fc1f'),('6931248d9efe0aca3','Process Job Queue q1',0,'Success','2025-12-04 06:06:00',1089082,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:06','2025-12-04 06:06:06',1341255,1,NULL,NULL,NULL,'2025-12-04 06:05:01','2025-12-04 06:06:06','687bf57d8afb5c472'),('6931248dc0b7f706c','Process Job Queue e0',0,'Success','2025-12-04 06:05:01',1089083,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:05:05','2025-12-04 06:05:05',1341218,1,NULL,NULL,NULL,'2025-12-04 06:05:01','2025-12-04 06:05:05','687bf57dbba8299ef'),('693124c985862043e','Submit Popup Reminders',0,'Success','2025-12-04 06:06:01',1089084,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:07','2025-12-04 06:06:07',1341255,1,NULL,NULL,NULL,'2025-12-04 06:06:01','2025-12-04 06:06:07','687bf57d2f9463790'),('693124c9b24cf2ac2','Process Job Queue q0',0,'Success','2025-12-04 06:06:01',1089085,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:08','2025-12-04 06:06:08',1341255,1,NULL,NULL,NULL,'2025-12-04 06:06:01','2025-12-04 06:06:08','687bf57d693e0fc1f'),('693124c9cf596dee2','Process Job Queue q1',0,'Success','2025-12-04 06:07:00',1089086,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:07:02','2025-12-04 06:07:02',1341290,1,NULL,NULL,NULL,'2025-12-04 06:06:01','2025-12-04 06:07:02','687bf57d8afb5c472'),('693124ca0aacad28b','Process Job Queue e0',0,'Success','2025-12-04 06:06:02',1089087,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:06:09','2025-12-04 06:06:09',1341255,1,NULL,NULL,NULL,'2025-12-04 06:06:02','2025-12-04 06:06:09','687bf57dbba8299ef'),('693124ca2f807aebb','Send Email Reminders',0,'Success','2025-12-04 06:08:00',1089088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:03','2025-12-04 06:08:03',1341328,1,NULL,NULL,NULL,'2025-12-04 06:06:02','2025-12-04 06:08:03','687bf5d44d3e10813'),('693124ca7542f46f0','Send Email Notifications',0,'Success','2025-12-04 06:08:00',1089089,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:04','2025-12-04 06:08:04',1341328,1,NULL,NULL,NULL,'2025-12-04 06:06:02','2025-12-04 06:08:04','687bf5d466067a4ba'),('693124cac5c380693','Auth Token Control',0,'Success','2025-12-04 06:12:00',1089090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:03','2025-12-04 06:12:04',1341555,1,NULL,NULL,NULL,'2025-12-04 06:06:02','2025-12-04 06:12:04','687bf5d511e08c57f'),('693124caf40906af7','Process Webhook Queue',0,'Success','2025-12-04 06:08:00',1089091,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:05','2025-12-04 06:08:05',1341328,1,NULL,NULL,NULL,'2025-12-04 06:06:02','2025-12-04 06:08:05','687bf5d5788e2fe0e'),('693125053bbd34046','Submit Popup Reminders',0,'Success','2025-12-04 06:07:01',1089092,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:07:03','2025-12-04 06:07:03',1341290,1,NULL,NULL,NULL,'2025-12-04 06:07:01','2025-12-04 06:07:03','687bf57d2f9463790'),('693125056e0da5b40','Process Job Queue q0',0,'Success','2025-12-04 06:07:01',1089093,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:07:04','2025-12-04 06:07:04',1341290,1,NULL,NULL,NULL,'2025-12-04 06:07:01','2025-12-04 06:07:04','687bf57d693e0fc1f'),('6931250591d2376fb','Process Job Queue q1',0,'Success','2025-12-04 06:08:00',1089094,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:06','2025-12-04 06:08:06',1341328,1,NULL,NULL,NULL,'2025-12-04 06:07:01','2025-12-04 06:08:06','687bf57d8afb5c472'),('69312505c6dfb31d9','Process Job Queue e0',0,'Success','2025-12-04 06:07:01',1089095,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:07:05','2025-12-04 06:07:05',1341290,1,NULL,NULL,NULL,'2025-12-04 06:07:01','2025-12-04 06:07:05','687bf57dbba8299ef'),('693125416c07bba2f','Submit Popup Reminders',0,'Success','2025-12-04 06:08:01',1089096,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:06','2025-12-04 06:08:07',1341328,1,NULL,NULL,NULL,'2025-12-04 06:08:01','2025-12-04 06:08:07','687bf57d2f9463790'),('693125418fc02e85e','Process Job Queue q0',0,'Success','2025-12-04 06:08:01',1089097,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:07','2025-12-04 06:08:07',1341328,1,NULL,NULL,NULL,'2025-12-04 06:08:01','2025-12-04 06:08:07','687bf57d693e0fc1f'),('69312541ae8d42af4','Process Job Queue q1',0,'Success','2025-12-04 06:09:00',1089098,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:09:03','2025-12-04 06:09:03',1341360,1,NULL,NULL,NULL,'2025-12-04 06:08:01','2025-12-04 06:09:03','687bf57d8afb5c472'),('69312541d0702976c','Process Job Queue e0',0,'Success','2025-12-04 06:08:01',1089099,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:08:08','2025-12-04 06:08:08',1341328,1,NULL,NULL,NULL,'2025-12-04 06:08:01','2025-12-04 06:08:08','687bf57dbba8299ef'),('69312542125f1ac53','Send Email Reminders',0,'Success','2025-12-04 06:10:00',1089100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:06','2025-12-04 06:10:06',1341472,1,NULL,NULL,NULL,'2025-12-04 06:08:02','2025-12-04 06:10:06','687bf5d44d3e10813'),('69312542593d2b3b8','Send Email Notifications',0,'Success','2025-12-04 06:10:00',1089101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:06','2025-12-04 06:10:07',1341472,1,NULL,NULL,NULL,'2025-12-04 06:08:02','2025-12-04 06:10:07','687bf5d466067a4ba'),('693125428c9394fc5','Process Webhook Queue',0,'Success','2025-12-04 06:10:00',1089102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:07','2025-12-04 06:10:07',1341472,1,NULL,NULL,NULL,'2025-12-04 06:08:02','2025-12-04 06:10:07','687bf5d5788e2fe0e'),('6931257df34a8061d','Submit Popup Reminders',0,'Success','2025-12-04 06:09:01',1089103,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:09:04','2025-12-04 06:09:05',1341360,1,NULL,NULL,NULL,'2025-12-04 06:09:01','2025-12-04 06:09:05','687bf57d2f9463790'),('6931257e8dcd59b08','Process Job Queue q0',0,'Success','2025-12-04 06:09:02',1089104,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:09:05','2025-12-04 06:09:05',1341360,1,NULL,NULL,NULL,'2025-12-04 06:09:02','2025-12-04 06:09:05','687bf57d693e0fc1f'),('6931257ee11caecb1','Process Job Queue q1',0,'Success','2025-12-04 06:10:00',1089105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:08','2025-12-04 06:10:08',1341472,1,NULL,NULL,NULL,'2025-12-04 06:09:02','2025-12-04 06:10:08','687bf57d8afb5c472'),('6931257f3ca1b465c','Process Job Queue e0',0,'Success','2025-12-04 06:09:03',1089106,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:09:06','2025-12-04 06:09:06',1341360,1,NULL,NULL,NULL,'2025-12-04 06:09:03','2025-12-04 06:09:06','687bf57dbba8299ef'),('693125b9a2fc744e8','Submit Popup Reminders',0,'Success','2025-12-04 06:10:01',1089107,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:08','2025-12-04 06:10:08',1341472,1,NULL,NULL,NULL,'2025-12-04 06:10:01','2025-12-04 06:10:08','687bf57d2f9463790'),('693125b9d5509d5a7','Process Job Queue q0',0,'Success','2025-12-04 06:10:01',1089108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:09','2025-12-04 06:10:09',1341472,1,NULL,NULL,NULL,'2025-12-04 06:10:01','2025-12-04 06:10:09','687bf57d693e0fc1f'),('693125ba07e543af3','Process Job Queue q1',0,'Success','2025-12-04 06:11:00',1089109,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:11:01','2025-12-04 06:11:02',1341515,1,NULL,NULL,NULL,'2025-12-04 06:10:02','2025-12-04 06:11:02','687bf57d8afb5c472'),('693125ba235fc7d0f','Process Job Queue e0',0,'Success','2025-12-04 06:10:02',1089110,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:10:10','2025-12-04 06:10:10',1341472,1,NULL,NULL,NULL,'2025-12-04 06:10:02','2025-12-04 06:10:10','687bf57dbba8299ef'),('693125ba52ed638f6','Send Email Reminders',0,'Success','2025-12-04 06:12:00',1089111,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:05','2025-12-04 06:12:05',1341555,1,NULL,NULL,NULL,'2025-12-04 06:10:02','2025-12-04 06:12:05','687bf5d44d3e10813'),('693125ba8f7569491','Send Email Notifications',0,'Success','2025-12-04 06:12:00',1089112,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:06','2025-12-04 06:12:06',1341555,1,NULL,NULL,NULL,'2025-12-04 06:10:02','2025-12-04 06:12:06','687bf5d466067a4ba'),('693125bad029c1c22','Send Mass Emails',0,'Success','2025-12-04 06:30:00',1089113,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:04','2025-12-04 06:30:04',1342087,1,NULL,NULL,NULL,'2025-12-04 06:10:02','2025-12-04 06:30:04','687bf5d4b535f913f'),('693125bb27304bf7d','Process Webhook Queue',0,'Success','2025-12-04 06:12:00',1089114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:07','2025-12-04 06:12:07',1341555,1,NULL,NULL,NULL,'2025-12-04 06:10:03','2025-12-04 06:12:07','687bf5d5788e2fe0e'),('693125bb67ec112d2','Send Scheduled Emails',0,'Success','2025-12-04 06:20:00',1089115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:03','2025-12-04 06:20:03',1341755,1,NULL,NULL,NULL,'2025-12-04 06:10:03','2025-12-04 06:20:03','687bf5d5eeb01d80d'),('693125f52f409eed2','Submit Popup Reminders',0,'Success','2025-12-04 06:11:01',1089116,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:11:03','2025-12-04 06:11:03',1341515,1,NULL,NULL,NULL,'2025-12-04 06:11:01','2025-12-04 06:11:03','687bf57d2f9463790'),('693125f55fed8418e','Process Job Queue q0',0,'Success','2025-12-04 06:11:01',1089117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:11:04','2025-12-04 06:11:04',1341515,1,NULL,NULL,NULL,'2025-12-04 06:11:01','2025-12-04 06:11:04','687bf57d693e0fc1f'),('693125f586c38b796','Process Job Queue q1',0,'Success','2025-12-04 06:12:00',1089118,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:08','2025-12-04 06:12:08',1341555,1,NULL,NULL,NULL,'2025-12-04 06:11:01','2025-12-04 06:12:08','687bf57d8afb5c472'),('693125f5a90a77cfa','Process Job Queue e0',0,'Success','2025-12-04 06:11:01',1089119,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:11:04','2025-12-04 06:11:05',1341515,1,NULL,NULL,NULL,'2025-12-04 06:11:01','2025-12-04 06:11:05','687bf57dbba8299ef'),('693126321c2e0f3ad','Submit Popup Reminders',0,'Success','2025-12-04 06:12:02',1089120,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:09','2025-12-04 06:12:09',1341555,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:12:09','687bf57d2f9463790'),('693126323bc58a540','Process Job Queue q0',0,'Success','2025-12-04 06:12:02',1089121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:09','2025-12-04 06:12:09',1341555,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:12:09','687bf57d693e0fc1f'),('693126325febf16e9','Process Job Queue q1',0,'Success','2025-12-04 06:13:00',1089122,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:13:02','2025-12-04 06:13:02',1341592,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:13:02','687bf57d8afb5c472'),('69312632806b9a886','Process Job Queue e0',0,'Success','2025-12-04 06:12:02',1089123,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:12:10','2025-12-04 06:12:10',1341555,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:12:10','687bf57dbba8299ef'),('69312632a47f4976e','Send Email Reminders',0,'Success','2025-12-04 06:14:00',1089124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:03','2025-12-04 06:14:03',1341630,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:14:03','687bf5d44d3e10813'),('69312632bfc744162','Send Email Notifications',0,'Success','2025-12-04 06:14:00',1089125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:04','2025-12-04 06:14:04',1341630,1,NULL,NULL,NULL,'2025-12-04 06:12:02','2025-12-04 06:14:04','687bf5d466067a4ba'),('6931263308a970940','Auth Token Control',0,'Success','2025-12-04 06:18:00',1089126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:03','2025-12-04 06:18:03',1341715,1,NULL,NULL,NULL,'2025-12-04 06:12:03','2025-12-04 06:18:03','687bf5d511e08c57f'),('693126335d41dc6b1','Process Webhook Queue',0,'Success','2025-12-04 06:14:00',1089127,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:05','2025-12-04 06:14:05',1341630,1,NULL,NULL,NULL,'2025-12-04 06:12:03','2025-12-04 06:14:05','687bf5d5788e2fe0e'),('6931266de126e3409','Submit Popup Reminders',0,'Success','2025-12-04 06:13:01',1089128,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:13:03','2025-12-04 06:13:04',1341592,1,NULL,NULL,NULL,'2025-12-04 06:13:01','2025-12-04 06:13:04','687bf57d2f9463790'),('6931266e169a86d29','Process Job Queue q0',0,'Success','2025-12-04 06:13:02',1089129,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:13:05','2025-12-04 06:13:05',1341592,1,NULL,NULL,NULL,'2025-12-04 06:13:02','2025-12-04 06:13:05','687bf57d693e0fc1f'),('6931266e51527d290','Process Job Queue q1',0,'Success','2025-12-04 06:14:00',1089130,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:06','2025-12-04 06:14:06',1341630,1,NULL,NULL,NULL,'2025-12-04 06:13:02','2025-12-04 06:14:06','687bf57d8afb5c472'),('6931266e6d7d9ab90','Process Job Queue e0',0,'Success','2025-12-04 06:13:02',1089131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:13:06','2025-12-04 06:13:06',1341592,1,NULL,NULL,NULL,'2025-12-04 06:13:02','2025-12-04 06:13:06','687bf57dbba8299ef'),('693126a94c9b6dca6','Submit Popup Reminders',0,'Success','2025-12-04 06:14:01',1089132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:06','2025-12-04 06:14:06',1341630,1,NULL,NULL,NULL,'2025-12-04 06:14:01','2025-12-04 06:14:06','687bf57d2f9463790'),('693126a971c7b1710','Process Job Queue q0',0,'Success','2025-12-04 06:14:01',1089133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:07','2025-12-04 06:14:07',1341630,1,NULL,NULL,NULL,'2025-12-04 06:14:01','2025-12-04 06:14:07','687bf57d693e0fc1f'),('693126a9a5387c89d','Process Job Queue q1',0,'Success','2025-12-04 06:15:00',1089134,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:15:02','2025-12-04 06:15:02',1341661,1,NULL,NULL,NULL,'2025-12-04 06:14:01','2025-12-04 06:15:02','687bf57d8afb5c472'),('693126a9e2988fe3f','Process Job Queue e0',0,'Success','2025-12-04 06:14:01',1089135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:14:08','2025-12-04 06:14:08',1341630,1,NULL,NULL,NULL,'2025-12-04 06:14:01','2025-12-04 06:14:08','687bf57dbba8299ef'),('693126aa7f1c79125','Send Email Reminders',0,'Success','2025-12-04 06:16:00',1089136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:03','2025-12-04 06:16:03',1341675,1,NULL,NULL,NULL,'2025-12-04 06:14:02','2025-12-04 06:16:03','687bf5d44d3e10813'),('693126aae43151f73','Send Email Notifications',0,'Success','2025-12-04 06:16:00',1089137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:04','2025-12-04 06:16:04',1341675,1,NULL,NULL,NULL,'2025-12-04 06:14:02','2025-12-04 06:16:04','687bf5d466067a4ba'),('693126ab4481bf9a6','Process Webhook Queue',0,'Success','2025-12-04 06:16:00',1089138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:05','2025-12-04 06:16:05',1341675,1,NULL,NULL,NULL,'2025-12-04 06:14:03','2025-12-04 06:16:05','687bf5d5788e2fe0e'),('693126e551d9558f2','Submit Popup Reminders',0,'Success','2025-12-04 06:15:01',1089139,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:15:03','2025-12-04 06:15:03',1341661,1,NULL,NULL,NULL,'2025-12-04 06:15:01','2025-12-04 06:15:03','687bf57d2f9463790'),('693126e5859de8318','Process Job Queue q0',0,'Success','2025-12-04 06:15:01',1089140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:15:04','2025-12-04 06:15:04',1341661,1,NULL,NULL,NULL,'2025-12-04 06:15:01','2025-12-04 06:15:04','687bf57d693e0fc1f'),('693126e5abf5fdb64','Process Job Queue q1',0,'Success','2025-12-04 06:16:00',1089141,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:06','2025-12-04 06:16:06',1341675,1,NULL,NULL,NULL,'2025-12-04 06:15:01','2025-12-04 06:16:06','687bf57d8afb5c472'),('693126e5cfc548098','Process Job Queue e0',0,'Success','2025-12-04 06:15:01',1089142,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:15:05','2025-12-04 06:15:05',1341661,1,NULL,NULL,NULL,'2025-12-04 06:15:01','2025-12-04 06:15:05','687bf57dbba8299ef'),('69312721e0a92a69d','Submit Popup Reminders',0,'Success','2025-12-04 06:16:01',1089143,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:07','2025-12-04 06:16:07',1341675,1,NULL,NULL,NULL,'2025-12-04 06:16:01','2025-12-04 06:16:07','687bf57d2f9463790'),('6931272210f675c8d','Process Job Queue q0',0,'Success','2025-12-04 06:16:02',1089144,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:08','2025-12-04 06:16:08',1341675,1,NULL,NULL,NULL,'2025-12-04 06:16:02','2025-12-04 06:16:08','687bf57d693e0fc1f'),('693127224104de36f','Process Job Queue q1',0,'Success','2025-12-04 06:17:00',1089145,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:17:02','2025-12-04 06:17:02',1341696,1,NULL,NULL,NULL,'2025-12-04 06:16:02','2025-12-04 06:17:02','687bf57d8afb5c472'),('693127225e9f449e7','Process Job Queue e0',0,'Success','2025-12-04 06:16:02',1089146,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:16:08','2025-12-04 06:16:09',1341675,1,NULL,NULL,NULL,'2025-12-04 06:16:02','2025-12-04 06:16:09','687bf57dbba8299ef'),('6931272292f703adf','Send Email Reminders',0,'Success','2025-12-04 06:18:00',1089147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:04','2025-12-04 06:18:04',1341715,1,NULL,NULL,NULL,'2025-12-04 06:16:02','2025-12-04 06:18:04','687bf5d44d3e10813'),('69312722c32f18e44','Send Email Notifications',0,'Success','2025-12-04 06:18:00',1089148,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:05','2025-12-04 06:18:05',1341715,1,NULL,NULL,NULL,'2025-12-04 06:16:02','2025-12-04 06:18:05','687bf5d466067a4ba'),('693127231ce88c03a','Process Webhook Queue',0,'Success','2025-12-04 06:18:00',1089149,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:06','2025-12-04 06:18:06',1341715,1,NULL,NULL,NULL,'2025-12-04 06:16:03','2025-12-04 06:18:06','687bf5d5788e2fe0e'),('6931275d5d8cae159','Submit Popup Reminders',0,'Success','2025-12-04 06:17:01',1089150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:17:03','2025-12-04 06:17:03',1341696,1,NULL,NULL,NULL,'2025-12-04 06:17:01','2025-12-04 06:17:03','687bf57d2f9463790'),('6931275d8470c8d4c','Process Job Queue q0',0,'Success','2025-12-04 06:17:01',1089151,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:17:04','2025-12-04 06:17:04',1341696,1,NULL,NULL,NULL,'2025-12-04 06:17:01','2025-12-04 06:17:04','687bf57d693e0fc1f'),('6931275dafa040447','Process Job Queue q1',0,'Success','2025-12-04 06:18:00',1089152,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:07','2025-12-04 06:18:07',1341715,1,NULL,NULL,NULL,'2025-12-04 06:17:01','2025-12-04 06:18:07','687bf57d8afb5c472'),('6931275de98ad0139','Process Job Queue e0',0,'Success','2025-12-04 06:17:01',1089153,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:17:04','2025-12-04 06:17:05',1341696,1,NULL,NULL,NULL,'2025-12-04 06:17:01','2025-12-04 06:17:05','687bf57dbba8299ef'),('693127996a62f9805','Submit Popup Reminders',0,'Success','2025-12-04 06:18:01',1089154,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:07','2025-12-04 06:18:07',1341715,1,NULL,NULL,NULL,'2025-12-04 06:18:01','2025-12-04 06:18:07','687bf57d2f9463790'),('6931279989ef75699','Process Job Queue q0',0,'Success','2025-12-04 06:18:01',1089155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:08','2025-12-04 06:18:08',1341715,1,NULL,NULL,NULL,'2025-12-04 06:18:01','2025-12-04 06:18:08','687bf57d693e0fc1f'),('69312799b8bc9be49','Process Job Queue q1',0,'Success','2025-12-04 06:19:00',1089156,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:19:02','2025-12-04 06:19:02',1341734,1,NULL,NULL,NULL,'2025-12-04 06:18:01','2025-12-04 06:19:02','687bf57d8afb5c472'),('69312799d9e738e0f','Process Job Queue e0',0,'Success','2025-12-04 06:18:01',1089157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:18:08','2025-12-04 06:18:09',1341715,1,NULL,NULL,NULL,'2025-12-04 06:18:01','2025-12-04 06:18:09','687bf57dbba8299ef'),('6931279a1edda404a','Send Email Reminders',0,'Success','2025-12-04 06:20:00',1089158,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:04','2025-12-04 06:20:04',1341755,1,NULL,NULL,NULL,'2025-12-04 06:18:02','2025-12-04 06:20:04','687bf5d44d3e10813'),('6931279a6e43e5866','Send Email Notifications',0,'Success','2025-12-04 06:20:00',1089159,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:05','2025-12-04 06:20:05',1341755,1,NULL,NULL,NULL,'2025-12-04 06:18:02','2025-12-04 06:20:05','687bf5d466067a4ba'),('6931279ad3f9b789d','Auth Token Control',0,'Success','2025-12-04 06:24:00',1089160,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:03','2025-12-04 06:24:03',1341857,1,NULL,NULL,NULL,'2025-12-04 06:18:02','2025-12-04 06:24:03','687bf5d511e08c57f'),('6931279b1231efe33','Process Webhook Queue',0,'Success','2025-12-04 06:20:00',1089161,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:06','2025-12-04 06:20:06',1341755,1,NULL,NULL,NULL,'2025-12-04 06:18:03','2025-12-04 06:20:06','687bf5d5788e2fe0e'),('693127d61bef01bd5','Submit Popup Reminders',0,'Success','2025-12-04 06:19:02',1089162,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:19:03','2025-12-04 06:19:04',1341734,1,NULL,NULL,NULL,'2025-12-04 06:19:02','2025-12-04 06:19:04','687bf57d2f9463790'),('693127d64c593d633','Process Job Queue q0',0,'Success','2025-12-04 06:19:02',1089163,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:19:05','2025-12-04 06:19:05',1341734,1,NULL,NULL,NULL,'2025-12-04 06:19:02','2025-12-04 06:19:05','687bf57d693e0fc1f'),('693127d66a9b083f0','Process Job Queue q1',0,'Success','2025-12-04 06:20:00',1089164,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:06','2025-12-04 06:20:06',1341755,1,NULL,NULL,NULL,'2025-12-04 06:19:02','2025-12-04 06:20:06','687bf57d8afb5c472'),('693127d68a5ec235b','Process Job Queue e0',0,'Success','2025-12-04 06:19:02',1089165,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:19:06','2025-12-04 06:19:06',1341734,1,NULL,NULL,NULL,'2025-12-04 06:19:02','2025-12-04 06:19:06','687bf57dbba8299ef'),('693128117b7c13827','Submit Popup Reminders',0,'Success','2025-12-04 06:20:01',1089166,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:07','2025-12-04 06:20:07',1341755,1,NULL,NULL,NULL,'2025-12-04 06:20:01','2025-12-04 06:20:07','687bf57d2f9463790'),('69312811a65e25a90','Process Job Queue q0',0,'Success','2025-12-04 06:20:01',1089167,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:08','2025-12-04 06:20:08',1341755,1,NULL,NULL,NULL,'2025-12-04 06:20:01','2025-12-04 06:20:08','687bf57d693e0fc1f'),('69312811c703d73b8','Process Job Queue q1',0,'Success','2025-12-04 06:21:00',1089168,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:21:03','2025-12-04 06:21:03',1341778,1,NULL,NULL,NULL,'2025-12-04 06:20:01','2025-12-04 06:21:03','687bf57d8afb5c472'),('69312811e4bca15ed','Process Job Queue e0',0,'Success','2025-12-04 06:20:01',1089169,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:20:09','2025-12-04 06:20:09',1341755,1,NULL,NULL,NULL,'2025-12-04 06:20:01','2025-12-04 06:20:09','687bf57dbba8299ef'),('69312812247bdfe0f','Send Email Reminders',0,'Success','2025-12-04 06:22:00',1089170,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:04','2025-12-04 06:22:04',1341798,1,NULL,NULL,NULL,'2025-12-04 06:20:02','2025-12-04 06:22:04','687bf5d44d3e10813'),('69312812598ce8fbe','Send Email Notifications',0,'Success','2025-12-04 06:22:00',1089171,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:05','2025-12-04 06:22:05',1341798,1,NULL,NULL,NULL,'2025-12-04 06:20:02','2025-12-04 06:22:05','687bf5d466067a4ba'),('6931281297770774d','Process Webhook Queue',0,'Success','2025-12-04 06:22:00',1089172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:05','2025-12-04 06:22:05',1341798,1,NULL,NULL,NULL,'2025-12-04 06:20:02','2025-12-04 06:22:05','687bf5d5788e2fe0e'),('6931281320728d32f','Send Scheduled Emails',0,'Success','2025-12-04 06:30:00',1089173,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:04','2025-12-04 06:30:05',1342087,1,NULL,NULL,NULL,'2025-12-04 06:20:03','2025-12-04 06:30:05','687bf5d5eeb01d80d'),('6931284dd677efca3','Submit Popup Reminders',0,'Success','2025-12-04 06:21:01',1089174,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:21:03','2025-12-04 06:21:04',1341778,1,NULL,NULL,NULL,'2025-12-04 06:21:01','2025-12-04 06:21:04','687bf57d2f9463790'),('6931284e457e5b03e','Process Job Queue q0',0,'Success','2025-12-04 06:21:02',1089175,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:21:04','2025-12-04 06:21:04',1341778,1,NULL,NULL,NULL,'2025-12-04 06:21:02','2025-12-04 06:21:04','687bf57d693e0fc1f'),('6931284e8306b8dfe','Process Job Queue q1',0,'Success','2025-12-04 06:22:00',1089176,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:06','2025-12-04 06:22:06',1341798,1,NULL,NULL,NULL,'2025-12-04 06:21:02','2025-12-04 06:22:06','687bf57d8afb5c472'),('6931284ebdce365af','Process Job Queue e0',0,'Success','2025-12-04 06:21:02',1089177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:21:05','2025-12-04 06:21:05',1341778,1,NULL,NULL,NULL,'2025-12-04 06:21:02','2025-12-04 06:21:05','687bf57dbba8299ef'),('6931288a1b28e3392','Submit Popup Reminders',0,'Success','2025-12-04 06:22:02',1089178,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:07','2025-12-04 06:22:07',1341798,1,NULL,NULL,NULL,'2025-12-04 06:22:02','2025-12-04 06:22:07','687bf57d2f9463790'),('6931288a477752b85','Process Job Queue q0',0,'Success','2025-12-04 06:22:02',1089179,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:07','2025-12-04 06:22:08',1341798,1,NULL,NULL,NULL,'2025-12-04 06:22:02','2025-12-04 06:22:08','687bf57d693e0fc1f'),('6931288a7e66f79a4','Process Job Queue q1',0,'Success','2025-12-04 06:23:00',1089180,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:23:02','2025-12-04 06:23:02',1341822,1,NULL,NULL,NULL,'2025-12-04 06:22:02','2025-12-04 06:23:02','687bf57d8afb5c472'),('6931288aa242facbb','Process Job Queue e0',0,'Success','2025-12-04 06:22:02',1089181,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:22:08','2025-12-04 06:22:09',1341798,1,NULL,NULL,NULL,'2025-12-04 06:22:02','2025-12-04 06:22:09','687bf57dbba8299ef'),('6931288b6358177b2','Send Email Reminders',0,'Success','2025-12-04 06:24:00',1089182,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:04','2025-12-04 06:24:04',1341857,1,NULL,NULL,NULL,'2025-12-04 06:22:03','2025-12-04 06:24:04','687bf5d44d3e10813'),('6931288ba513f4079','Send Email Notifications',0,'Success','2025-12-04 06:24:00',1089183,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:05','2025-12-04 06:24:05',1341857,1,NULL,NULL,NULL,'2025-12-04 06:22:03','2025-12-04 06:24:05','687bf5d466067a4ba'),('6931288bdb5bde6e6','Process Webhook Queue',0,'Success','2025-12-04 06:24:00',1089184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:06','2025-12-04 06:24:06',1341857,1,NULL,NULL,NULL,'2025-12-04 06:22:03','2025-12-04 06:24:06','687bf5d5788e2fe0e'),('693128c592e490d26','Submit Popup Reminders',0,'Success','2025-12-04 06:23:01',1089185,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:23:03','2025-12-04 06:23:03',1341822,1,NULL,NULL,NULL,'2025-12-04 06:23:01','2025-12-04 06:23:03','687bf57d2f9463790'),('693128c5cc953aee9','Process Job Queue q0',0,'Success','2025-12-04 06:23:01',1089186,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:23:04','2025-12-04 06:23:04',1341822,1,NULL,NULL,NULL,'2025-12-04 06:23:01','2025-12-04 06:23:04','687bf57d693e0fc1f'),('693128c5ef3f5d3c9','Process Job Queue q1',0,'Success','2025-12-04 06:24:00',1089187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:06','2025-12-04 06:24:07',1341857,1,NULL,NULL,NULL,'2025-12-04 06:23:01','2025-12-04 06:24:07','687bf57d8afb5c472'),('693128c618d854b24','Process Job Queue e0',0,'Success','2025-12-04 06:23:02',1089188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:23:05','2025-12-04 06:23:05',1341822,1,NULL,NULL,NULL,'2025-12-04 06:23:02','2025-12-04 06:23:05','687bf57dbba8299ef'),('693129016595395ea','Submit Popup Reminders',0,'Success','2025-12-04 06:24:01',1089189,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:07','2025-12-04 06:24:07',1341857,1,NULL,NULL,NULL,'2025-12-04 06:24:01','2025-12-04 06:24:07','687bf57d2f9463790'),('693129019f56a186e','Process Job Queue q0',0,'Success','2025-12-04 06:24:01',1089190,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:08','2025-12-04 06:24:08',1341857,1,NULL,NULL,NULL,'2025-12-04 06:24:01','2025-12-04 06:24:08','687bf57d693e0fc1f'),('69312901d977d91fe','Process Job Queue q1',0,'Success','2025-12-04 06:25:00',1089191,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:25:02','2025-12-04 06:25:03',1341892,1,NULL,NULL,NULL,'2025-12-04 06:24:01','2025-12-04 06:25:03','687bf57d8afb5c472'),('6931290218531d3e4','Process Job Queue e0',0,'Success','2025-12-04 06:24:02',1089192,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:24:09','2025-12-04 06:24:09',1341857,1,NULL,NULL,NULL,'2025-12-04 06:24:02','2025-12-04 06:24:09','687bf57dbba8299ef'),('69312902b0b3b25f0','Send Email Reminders',0,'Success','2025-12-04 06:26:00',1089193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:03','2025-12-04 06:26:03',1341937,1,NULL,NULL,NULL,'2025-12-04 06:24:02','2025-12-04 06:26:03','687bf5d44d3e10813'),('69312903158c157d3','Send Email Notifications',0,'Success','2025-12-04 06:26:00',1089194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:04','2025-12-04 06:26:04',1341937,1,NULL,NULL,NULL,'2025-12-04 06:24:03','2025-12-04 06:26:04','687bf5d466067a4ba'),('693129035a39b3f6c','Auth Token Control',0,'Success','2025-12-04 06:30:00',1089195,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:05','2025-12-04 06:30:05',1342087,1,NULL,NULL,NULL,'2025-12-04 06:24:03','2025-12-04 06:30:05','687bf5d511e08c57f'),('69312903906bd8ac3','Process Webhook Queue',0,'Success','2025-12-04 06:26:00',1089196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:05','2025-12-04 06:26:05',1341937,1,NULL,NULL,NULL,'2025-12-04 06:24:03','2025-12-04 06:26:05','687bf5d5788e2fe0e'),('6931293d353ec5abf','Submit Popup Reminders',0,'Success','2025-12-04 06:25:01',1089197,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:25:03','2025-12-04 06:25:04',1341892,1,NULL,NULL,NULL,'2025-12-04 06:25:01','2025-12-04 06:25:04','687bf57d2f9463790'),('6931293d58a186523','Process Job Queue q0',0,'Success','2025-12-04 06:25:01',1089198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:25:04','2025-12-04 06:25:04',1341892,1,NULL,NULL,NULL,'2025-12-04 06:25:01','2025-12-04 06:25:04','687bf57d693e0fc1f'),('6931293d9a3cd6461','Process Job Queue q1',0,'Success','2025-12-04 06:26:00',1089199,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:06','2025-12-04 06:26:06',1341937,1,NULL,NULL,NULL,'2025-12-04 06:25:01','2025-12-04 06:26:06','687bf57d8afb5c472'),('6931293dcaa956a20','Process Job Queue e0',0,'Success','2025-12-04 06:25:01',1089200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:25:05','2025-12-04 06:25:05',1341892,1,NULL,NULL,NULL,'2025-12-04 06:25:01','2025-12-04 06:25:05','687bf57dbba8299ef'),('6931297956d8751d6','Submit Popup Reminders',0,'Success','2025-12-04 06:26:01',1089201,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:06','2025-12-04 06:26:06',1341937,1,NULL,NULL,NULL,'2025-12-04 06:26:01','2025-12-04 06:26:06','687bf57d2f9463790'),('6931297983a596d2d','Process Job Queue q0',0,'Success','2025-12-04 06:26:01',1089202,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:07','2025-12-04 06:26:07',1341937,1,NULL,NULL,NULL,'2025-12-04 06:26:01','2025-12-04 06:26:07','687bf57d693e0fc1f'),('69312979a224a0ff4','Process Job Queue q1',0,'Success','2025-12-04 06:27:00',1089203,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:27:02','2025-12-04 06:27:03',1341971,1,NULL,NULL,NULL,'2025-12-04 06:26:01','2025-12-04 06:27:03','687bf57d8afb5c472'),('69312979c606f232a','Process Job Queue e0',0,'Success','2025-12-04 06:26:01',1089204,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:26:08','2025-12-04 06:26:08',1341937,1,NULL,NULL,NULL,'2025-12-04 06:26:01','2025-12-04 06:26:08','687bf57dbba8299ef'),('6931297a0913eb09b','Send Email Reminders',0,'Success','2025-12-04 06:28:00',1089205,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:03','2025-12-04 06:28:03',1342009,1,NULL,NULL,NULL,'2025-12-04 06:26:02','2025-12-04 06:28:03','687bf5d44d3e10813'),('6931297a2e6066f5f','Send Email Notifications',0,'Success','2025-12-04 06:28:00',1089206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:04','2025-12-04 06:28:04',1342009,1,NULL,NULL,NULL,'2025-12-04 06:26:02','2025-12-04 06:28:04','687bf5d466067a4ba'),('6931297a67139c3f7','Process Webhook Queue',0,'Success','2025-12-04 06:28:00',1089207,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:05','2025-12-04 06:28:05',1342009,1,NULL,NULL,NULL,'2025-12-04 06:26:02','2025-12-04 06:28:05','687bf5d5788e2fe0e'),('693129b60f82cb63b','Submit Popup Reminders',0,'Success','2025-12-04 06:27:02',1089208,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:27:04','2025-12-04 06:27:04',1341971,1,NULL,NULL,NULL,'2025-12-04 06:27:02','2025-12-04 06:27:04','687bf57d2f9463790'),('693129b647318c6a6','Process Job Queue q0',0,'Success','2025-12-04 06:27:02',1089209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:27:05','2025-12-04 06:27:05',1341971,1,NULL,NULL,NULL,'2025-12-04 06:27:02','2025-12-04 06:27:05','687bf57d693e0fc1f'),('693129b66c0fb9bae','Process Job Queue q1',0,'Success','2025-12-04 06:28:00',1089210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:06','2025-12-04 06:28:06',1342009,1,NULL,NULL,NULL,'2025-12-04 06:27:02','2025-12-04 06:28:06','687bf57d8afb5c472'),('693129b695e9fe041','Process Job Queue e0',0,'Success','2025-12-04 06:27:02',1089211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:27:06','2025-12-04 06:27:06',1341971,1,NULL,NULL,NULL,'2025-12-04 06:27:02','2025-12-04 06:27:06','687bf57dbba8299ef'),('693129f208b724808','Submit Popup Reminders',0,'Success','2025-12-04 06:28:02',1089212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:07','2025-12-04 06:28:07',1342009,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:28:07','687bf57d2f9463790'),('693129f2263b0328b','Process Job Queue q0',0,'Success','2025-12-04 06:28:02',1089213,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:07','2025-12-04 06:28:08',1342009,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:28:08','687bf57d693e0fc1f'),('693129f240fc288c2','Process Job Queue q1',0,'Success','2025-12-04 06:29:00',1089214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:29:01','2025-12-04 06:29:02',1342045,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:29:02','687bf57d8afb5c472'),('693129f25f87b7571','Process Job Queue e0',0,'Success','2025-12-04 06:28:02',1089215,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:28:08','2025-12-04 06:28:08',1342009,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:28:08','687bf57dbba8299ef'),('693129f28b476c10f','Send Email Reminders',0,'Success','2025-12-04 06:30:00',1089216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:06','2025-12-04 06:30:06',1342087,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:30:06','687bf5d44d3e10813'),('693129f2a37842e97','Send Email Notifications',0,'Success','2025-12-04 06:30:00',1089217,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:07','2025-12-04 06:30:07',1342087,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:30:07','687bf5d466067a4ba'),('693129f2cb7bcba44','Process Webhook Queue',0,'Success','2025-12-04 06:30:00',1089218,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:07','2025-12-04 06:30:07',1342087,1,NULL,NULL,NULL,'2025-12-04 06:28:02','2025-12-04 06:30:07','687bf5d5788e2fe0e'),('69312a2d3ee646199','Submit Popup Reminders',0,'Success','2025-12-04 06:29:01',1089219,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:29:03','2025-12-04 06:29:03',1342045,1,NULL,NULL,NULL,'2025-12-04 06:29:01','2025-12-04 06:29:03','687bf57d2f9463790'),('69312a2d71a7c7d1f','Process Job Queue q0',0,'Success','2025-12-04 06:29:01',1089220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:29:04','2025-12-04 06:29:04',1342045,1,NULL,NULL,NULL,'2025-12-04 06:29:01','2025-12-04 06:29:04','687bf57d693e0fc1f'),('69312a2d905b0bb20','Process Job Queue q1',0,'Success','2025-12-04 06:30:00',1089221,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:08','2025-12-04 06:30:08',1342087,1,NULL,NULL,NULL,'2025-12-04 06:29:01','2025-12-04 06:30:08','687bf57d8afb5c472'),('69312a2db43a65211','Process Job Queue e0',0,'Success','2025-12-04 06:29:01',1089222,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:29:05','2025-12-04 06:29:05',1342045,1,NULL,NULL,NULL,'2025-12-04 06:29:01','2025-12-04 06:29:05','687bf57dbba8299ef'),('69312a6993ff8c369','Submit Popup Reminders',0,'Success','2025-12-04 06:30:01',1089223,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:09','2025-12-04 06:30:09',1342087,1,NULL,NULL,NULL,'2025-12-04 06:30:01','2025-12-04 06:30:09','687bf57d2f9463790'),('69312a69bb6574e26','Process Job Queue q0',0,'Success','2025-12-04 06:30:01',1089224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:09','2025-12-04 06:30:09',1342087,1,NULL,NULL,NULL,'2025-12-04 06:30:01','2025-12-04 06:30:09','687bf57d693e0fc1f'),('69312a69d9feb3851','Process Job Queue q1',0,'Success','2025-12-04 06:31:00',1089225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:31:02','2025-12-04 06:31:02',1342126,1,NULL,NULL,NULL,'2025-12-04 06:30:01','2025-12-04 06:31:02','687bf57d8afb5c472'),('69312a6a1e2d12bb0','Process Job Queue e0',0,'Success','2025-12-04 06:30:02',1089226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:30:10','2025-12-04 06:30:11',1342087,1,NULL,NULL,NULL,'2025-12-04 06:30:02','2025-12-04 06:30:11','687bf57dbba8299ef'),('69312a6a83602db07','Send Email Reminders',0,'Success','2025-12-04 06:32:00',1089227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:03','2025-12-04 06:32:03',1342161,1,NULL,NULL,NULL,'2025-12-04 06:30:02','2025-12-04 06:32:03','687bf5d44d3e10813'),('69312a6ab56ccfa7c','Send Email Notifications',0,'Success','2025-12-04 06:32:00',1089228,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:04','2025-12-04 06:32:04',1342161,1,NULL,NULL,NULL,'2025-12-04 06:30:02','2025-12-04 06:32:04','687bf5d466067a4ba'),('69312a6ae53d8eaec','Send Mass Emails',0,'Success','2025-12-04 06:50:00',1089229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:04','2025-12-04 06:50:04',1342882,1,NULL,NULL,NULL,'2025-12-04 06:30:02','2025-12-04 06:50:04','687bf5d4b535f913f'),('69312a6b3bd8391c7','Auth Token Control',0,'Success','2025-12-04 06:36:00',1089230,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:03','2025-12-04 06:36:03',1342323,1,NULL,NULL,NULL,'2025-12-04 06:30:03','2025-12-04 06:36:03','687bf5d511e08c57f'),('69312a6b7648c41c5','Process Webhook Queue',0,'Success','2025-12-04 06:32:00',1089231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:04','2025-12-04 06:32:05',1342161,1,NULL,NULL,NULL,'2025-12-04 06:30:03','2025-12-04 06:32:05','687bf5d5788e2fe0e'),('69312a6bac381919b','Send Scheduled Emails',0,'Success','2025-12-04 06:40:00',1089232,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:03','2025-12-04 06:40:03',1342540,1,NULL,NULL,NULL,'2025-12-04 06:30:03','2025-12-04 06:40:03','687bf5d5eeb01d80d'),('69312aa5bd091437a','Submit Popup Reminders',0,'Success','2025-12-04 06:31:01',1089233,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:31:03','2025-12-04 06:31:03',1342126,1,NULL,NULL,NULL,'2025-12-04 06:31:01','2025-12-04 06:31:03','687bf57d2f9463790'),('69312aa5f1b0e02bc','Process Job Queue q0',0,'Success','2025-12-04 06:31:01',1089234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:31:04','2025-12-04 06:31:05',1342126,1,NULL,NULL,NULL,'2025-12-04 06:31:01','2025-12-04 06:31:05','687bf57d693e0fc1f'),('69312aa6200637801','Process Job Queue q1',0,'Success','2025-12-04 06:32:00',1089235,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:05','2025-12-04 06:32:05',1342161,1,NULL,NULL,NULL,'2025-12-04 06:31:02','2025-12-04 06:32:05','687bf57d8afb5c472'),('69312aa6441d425b7','Process Job Queue e0',0,'Success','2025-12-04 06:31:02',1089236,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:31:05','2025-12-04 06:31:05',1342126,1,NULL,NULL,NULL,'2025-12-04 06:31:02','2025-12-04 06:31:05','687bf57dbba8299ef'),('69312ae1a69d8e908','Submit Popup Reminders',0,'Success','2025-12-04 06:32:01',1089237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:06','2025-12-04 06:32:06',1342161,1,NULL,NULL,NULL,'2025-12-04 06:32:01','2025-12-04 06:32:06','687bf57d2f9463790'),('69312ae203554e7ea','Process Job Queue q0',0,'Success','2025-12-04 06:32:02',1089238,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:06','2025-12-04 06:32:07',1342161,1,NULL,NULL,NULL,'2025-12-04 06:32:02','2025-12-04 06:32:07','687bf57d693e0fc1f'),('69312ae2532ac6092','Process Job Queue q1',0,'Success','2025-12-04 06:33:00',1089239,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:33:02','2025-12-04 06:33:02',1342198,1,NULL,NULL,NULL,'2025-12-04 06:32:02','2025-12-04 06:33:02','687bf57d8afb5c472'),('69312ae2880b39bd0','Process Job Queue e0',0,'Success','2025-12-04 06:32:02',1089240,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:32:07','2025-12-04 06:32:07',1342161,1,NULL,NULL,NULL,'2025-12-04 06:32:02','2025-12-04 06:32:07','687bf57dbba8299ef'),('69312ae2c64d3287c','Send Email Reminders',0,'Success','2025-12-04 06:34:00',1089241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:04','2025-12-04 06:34:04',1342247,1,NULL,NULL,NULL,'2025-12-04 06:32:02','2025-12-04 06:34:04','687bf5d44d3e10813'),('69312ae2f0b61365e','Send Email Notifications',0,'Success','2025-12-04 06:34:00',1089242,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:05','2025-12-04 06:34:05',1342247,1,NULL,NULL,NULL,'2025-12-04 06:32:02','2025-12-04 06:34:05','687bf5d466067a4ba'),('69312ae3257042029','Process Webhook Queue',0,'Success','2025-12-04 06:34:00',1089243,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:05','2025-12-04 06:34:05',1342247,1,NULL,NULL,NULL,'2025-12-04 06:32:03','2025-12-04 06:34:05','687bf5d5788e2fe0e'),('69312b1db572d304a','Submit Popup Reminders',0,'Success','2025-12-04 06:33:01',1089244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:33:03','2025-12-04 06:33:04',1342198,1,NULL,NULL,NULL,'2025-12-04 06:33:01','2025-12-04 06:33:04','687bf57d2f9463790'),('69312b1ddc7e040b5','Process Job Queue q0',0,'Success','2025-12-04 06:33:01',1089245,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:33:04','2025-12-04 06:33:05',1342198,1,NULL,NULL,NULL,'2025-12-04 06:33:01','2025-12-04 06:33:05','687bf57d693e0fc1f'),('69312b1e0fb15115f','Process Job Queue q1',0,'Success','2025-12-04 06:34:00',1089246,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:06','2025-12-04 06:34:06',1342247,1,NULL,NULL,NULL,'2025-12-04 06:33:02','2025-12-04 06:34:06','687bf57d8afb5c472'),('69312b1e372d5abe1','Process Job Queue e0',0,'Success','2025-12-04 06:33:02',1089247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:33:05','2025-12-04 06:33:05',1342198,1,NULL,NULL,NULL,'2025-12-04 06:33:02','2025-12-04 06:33:05','687bf57dbba8299ef'),('69312b5a099103fed','Submit Popup Reminders',0,'Success','2025-12-04 06:34:02',1089248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:07','2025-12-04 06:34:07',1342247,1,NULL,NULL,NULL,'2025-12-04 06:34:02','2025-12-04 06:34:07','687bf57d2f9463790'),('69312b5a43f66d5b2','Process Job Queue q0',0,'Success','2025-12-04 06:34:02',1089249,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:08','2025-12-04 06:34:08',1342247,1,NULL,NULL,NULL,'2025-12-04 06:34:02','2025-12-04 06:34:08','687bf57d693e0fc1f'),('69312b5a87a99081d','Process Job Queue q1',0,'Success','2025-12-04 06:35:00',1089250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:35:02','2025-12-04 06:35:02',1342285,1,NULL,NULL,NULL,'2025-12-04 06:34:02','2025-12-04 06:35:02','687bf57d8afb5c472'),('69312b5b0080bef58','Process Job Queue e0',0,'Success','2025-12-04 06:34:02',1089251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:34:09','2025-12-04 06:34:09',1342247,1,NULL,NULL,NULL,'2025-12-04 06:34:03','2025-12-04 06:34:09','687bf57dbba8299ef'),('69312b5b9d880bdaa','Send Email Reminders',0,'Success','2025-12-04 06:36:00',1089252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:04','2025-12-04 06:36:04',1342323,1,NULL,NULL,NULL,'2025-12-04 06:34:03','2025-12-04 06:36:04','687bf5d44d3e10813'),('69312b5be1119325e','Send Email Notifications',0,'Success','2025-12-04 06:36:00',1089253,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:05','2025-12-04 06:36:05',1342323,1,NULL,NULL,NULL,'2025-12-04 06:34:03','2025-12-04 06:36:05','687bf5d466067a4ba'),('69312b5c1e4bb94b9','Process Webhook Queue',0,'Success','2025-12-04 06:36:00',1089254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:06','2025-12-04 06:36:06',1342323,1,NULL,NULL,NULL,'2025-12-04 06:34:04','2025-12-04 06:36:06','687bf5d5788e2fe0e'),('69312b95ce7069173','Submit Popup Reminders',0,'Success','2025-12-04 06:35:01',1089255,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:35:03','2025-12-04 06:35:03',1342285,1,NULL,NULL,NULL,'2025-12-04 06:35:01','2025-12-04 06:35:03','687bf57d2f9463790'),('69312b95f3bbbef37','Process Job Queue q0',0,'Success','2025-12-04 06:35:01',1089256,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:35:04','2025-12-04 06:35:04',1342285,1,NULL,NULL,NULL,'2025-12-04 06:35:01','2025-12-04 06:35:04','687bf57d693e0fc1f'),('69312b962eafa2a21','Process Job Queue q1',0,'Success','2025-12-04 06:36:00',1089257,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:06','2025-12-04 06:36:06',1342323,1,NULL,NULL,NULL,'2025-12-04 06:35:02','2025-12-04 06:36:06','687bf57d8afb5c472'),('69312b965a6e55aa2','Process Job Queue e0',0,'Success','2025-12-04 06:35:02',1089258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:35:05','2025-12-04 06:35:05',1342285,1,NULL,NULL,NULL,'2025-12-04 06:35:02','2025-12-04 06:35:05','687bf57dbba8299ef'),('69312bd178667d045','Submit Popup Reminders',0,'Success','2025-12-04 06:36:01',1089259,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:07','2025-12-04 06:36:07',1342323,1,NULL,NULL,NULL,'2025-12-04 06:36:01','2025-12-04 06:36:07','687bf57d2f9463790'),('69312bd1a72049461','Process Job Queue q0',0,'Success','2025-12-04 06:36:01',1089260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:08','2025-12-04 06:36:08',1342323,1,NULL,NULL,NULL,'2025-12-04 06:36:01','2025-12-04 06:36:08','687bf57d693e0fc1f'),('69312bd1ca8ab013a','Process Job Queue q1',0,'Success','2025-12-04 06:37:00',1089261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:37:01','2025-12-04 06:37:02',1342363,1,NULL,NULL,NULL,'2025-12-04 06:36:01','2025-12-04 06:37:02','687bf57d8afb5c472'),('69312bd1ed599bb9f','Process Job Queue e0',0,'Success','2025-12-04 06:36:01',1089262,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:36:08','2025-12-04 06:36:09',1342323,1,NULL,NULL,NULL,'2025-12-04 06:36:01','2025-12-04 06:36:09','687bf57dbba8299ef'),('69312bd21b8f9048d','Send Email Reminders',0,'Success','2025-12-04 06:38:00',1089263,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:03','2025-12-04 06:38:04',1342401,1,NULL,NULL,NULL,'2025-12-04 06:36:02','2025-12-04 06:38:04','687bf5d44d3e10813'),('69312bd251f231ee8','Send Email Notifications',0,'Success','2025-12-04 06:38:00',1089264,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:04','2025-12-04 06:38:05',1342401,1,NULL,NULL,NULL,'2025-12-04 06:36:02','2025-12-04 06:38:05','687bf5d466067a4ba'),('69312bd2a8f63fd9b','Auth Token Control',0,'Success','2025-12-04 06:42:00',1089265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:03','2025-12-04 06:42:03',1342617,1,NULL,NULL,NULL,'2025-12-04 06:36:02','2025-12-04 06:42:03','687bf5d511e08c57f'),('69312bd2e6bc5f010','Process Webhook Queue',0,'Success','2025-12-04 06:38:00',1089266,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:05','2025-12-04 06:38:05',1342401,1,NULL,NULL,NULL,'2025-12-04 06:36:02','2025-12-04 06:38:05','687bf5d5788e2fe0e'),('69312c0d2ffeeacd9','Submit Popup Reminders',0,'Success','2025-12-04 06:37:01',1089267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:37:02','2025-12-04 06:37:03',1342363,1,NULL,NULL,NULL,'2025-12-04 06:37:01','2025-12-04 06:37:03','687bf57d2f9463790'),('69312c0d5bac53dc8','Process Job Queue q0',0,'Success','2025-12-04 06:37:01',1089268,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:37:04','2025-12-04 06:37:04',1342363,1,NULL,NULL,NULL,'2025-12-04 06:37:01','2025-12-04 06:37:04','687bf57d693e0fc1f'),('69312c0d7bd413daa','Process Job Queue q1',0,'Success','2025-12-04 06:38:00',1089269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:06','2025-12-04 06:38:06',1342401,1,NULL,NULL,NULL,'2025-12-04 06:37:01','2025-12-04 06:38:06','687bf57d8afb5c472'),('69312c0d9c8c24bf9','Process Job Queue e0',0,'Success','2025-12-04 06:37:01',1089270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:37:05','2025-12-04 06:37:05',1342363,1,NULL,NULL,NULL,'2025-12-04 06:37:01','2025-12-04 06:37:05','687bf57dbba8299ef'),('69312c49c610dbc13','Submit Popup Reminders',0,'Success','2025-12-04 06:38:01',1089271,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:06','2025-12-04 06:38:07',1342401,1,NULL,NULL,NULL,'2025-12-04 06:38:01','2025-12-04 06:38:07','687bf57d2f9463790'),('69312c49f35845212','Process Job Queue q0',0,'Success','2025-12-04 06:38:01',1089272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:07','2025-12-04 06:38:07',1342401,1,NULL,NULL,NULL,'2025-12-04 06:38:01','2025-12-04 06:38:07','687bf57d693e0fc1f'),('69312c4a1f5e6ae73','Process Job Queue q1',0,'Success','2025-12-04 06:39:00',1089273,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:39:02','2025-12-04 06:39:03',1342436,1,NULL,NULL,NULL,'2025-12-04 06:38:02','2025-12-04 06:39:03','687bf57d8afb5c472'),('69312c4a45c8663dc','Process Job Queue e0',0,'Success','2025-12-04 06:38:02',1089274,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:38:08','2025-12-04 06:38:08',1342401,1,NULL,NULL,NULL,'2025-12-04 06:38:02','2025-12-04 06:38:08','687bf57dbba8299ef'),('69312c4a79e01d97e','Send Email Reminders',0,'Success','2025-12-04 06:40:00',1089275,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:04','2025-12-04 06:40:04',1342540,1,NULL,NULL,NULL,'2025-12-04 06:38:02','2025-12-04 06:40:04','687bf5d44d3e10813'),('69312c4ababccf055','Send Email Notifications',0,'Success','2025-12-04 06:40:00',1089276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:05','2025-12-04 06:40:05',1342540,1,NULL,NULL,NULL,'2025-12-04 06:38:02','2025-12-04 06:40:05','687bf5d466067a4ba'),('69312c4b1b5fc5943','Process Webhook Queue',0,'Success','2025-12-04 06:40:00',1089277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:05','2025-12-04 06:40:06',1342540,1,NULL,NULL,NULL,'2025-12-04 06:38:03','2025-12-04 06:40:06','687bf5d5788e2fe0e'),('69312c85d0ddde9c2','Submit Popup Reminders',0,'Success','2025-12-04 06:39:01',1089278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:39:04','2025-12-04 06:39:05',1342436,1,NULL,NULL,NULL,'2025-12-04 06:39:01','2025-12-04 06:39:05','687bf57d2f9463790'),('69312c86005762d83','Process Job Queue q0',0,'Success','2025-12-04 06:39:01',1089279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:39:05','2025-12-04 06:39:05',1342436,1,NULL,NULL,NULL,'2025-12-04 06:39:02','2025-12-04 06:39:05','687bf57d693e0fc1f'),('69312c861f760b10f','Process Job Queue q1',0,'Success','2025-12-04 06:40:00',1089280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:06','2025-12-04 06:40:07',1342540,1,NULL,NULL,NULL,'2025-12-04 06:39:02','2025-12-04 06:40:07','687bf57d8afb5c472'),('69312c8655fe2148c','Process Job Queue e0',0,'Success','2025-12-04 06:39:02',1089281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:39:06','2025-12-04 06:39:06',1342436,1,NULL,NULL,NULL,'2025-12-04 06:39:02','2025-12-04 06:39:06','687bf57dbba8299ef'),('69312cc13d4360a82','Submit Popup Reminders',0,'Success','2025-12-04 06:40:01',1089282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:07','2025-12-04 06:40:07',1342540,1,NULL,NULL,NULL,'2025-12-04 06:40:01','2025-12-04 06:40:07','687bf57d2f9463790'),('69312cc15e93da49e','Process Job Queue q0',0,'Success','2025-12-04 06:40:01',1089283,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:08','2025-12-04 06:40:08',1342540,1,NULL,NULL,NULL,'2025-12-04 06:40:01','2025-12-04 06:40:08','687bf57d693e0fc1f'),('69312cc188a6e2d33','Process Job Queue q1',0,'Success','2025-12-04 06:41:00',1089284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:41:02','2025-12-04 06:41:02',1342577,1,NULL,NULL,NULL,'2025-12-04 06:40:01','2025-12-04 06:41:02','687bf57d8afb5c472'),('69312cc1b246c2927','Process Job Queue e0',0,'Success','2025-12-04 06:40:01',1089285,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:40:09','2025-12-04 06:40:09',1342540,1,NULL,NULL,NULL,'2025-12-04 06:40:01','2025-12-04 06:40:09','687bf57dbba8299ef'),('69312cc1dd4850fcb','Send Email Reminders',0,'Success','2025-12-04 06:42:00',1089286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:04','2025-12-04 06:42:04',1342617,1,NULL,NULL,NULL,'2025-12-04 06:40:01','2025-12-04 06:42:04','687bf5d44d3e10813'),('69312cc218ae71069','Send Email Notifications',0,'Success','2025-12-04 06:42:00',1089287,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:05','2025-12-04 06:42:05',1342617,1,NULL,NULL,NULL,'2025-12-04 06:40:02','2025-12-04 06:42:05','687bf5d466067a4ba'),('69312cc259b6bfbb7','Process Webhook Queue',0,'Success','2025-12-04 06:42:00',1089288,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:06','2025-12-04 06:42:06',1342617,1,NULL,NULL,NULL,'2025-12-04 06:40:02','2025-12-04 06:42:06','687bf5d5788e2fe0e'),('69312cc28cdc6f293','Send Scheduled Emails',0,'Success','2025-12-04 06:50:00',1089289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:05','2025-12-04 06:50:05',1342882,1,NULL,NULL,NULL,'2025-12-04 06:40:02','2025-12-04 06:50:05','687bf5d5eeb01d80d'),('69312cfdd47bef824','Submit Popup Reminders',0,'Success','2025-12-04 06:41:01',1089290,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:41:04','2025-12-04 06:41:04',1342577,1,NULL,NULL,NULL,'2025-12-04 06:41:01','2025-12-04 06:41:04','687bf57d2f9463790'),('69312cfe0db02c1c0','Process Job Queue q0',0,'Success','2025-12-04 06:41:02',1089291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:41:05','2025-12-04 06:41:05',1342577,1,NULL,NULL,NULL,'2025-12-04 06:41:02','2025-12-04 06:41:05','687bf57d693e0fc1f'),('69312cfe4515c2c61','Process Job Queue q1',0,'Success','2025-12-04 06:42:00',1089292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:06','2025-12-04 06:42:07',1342617,1,NULL,NULL,NULL,'2025-12-04 06:41:02','2025-12-04 06:42:07','687bf57d8afb5c472'),('69312cfe8d2a0251e','Process Job Queue e0',0,'Success','2025-12-04 06:41:02',1089293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:41:05','2025-12-04 06:41:06',1342577,1,NULL,NULL,NULL,'2025-12-04 06:41:02','2025-12-04 06:41:06','687bf57dbba8299ef'),('69312d396b4e9a534','Submit Popup Reminders',0,'Success','2025-12-04 06:42:01',1089294,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:07','2025-12-04 06:42:07',1342617,1,NULL,NULL,NULL,'2025-12-04 06:42:01','2025-12-04 06:42:07','687bf57d2f9463790'),('69312d399720f74e0','Process Job Queue q0',0,'Success','2025-12-04 06:42:01',1089295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:08','2025-12-04 06:42:08',1342617,1,NULL,NULL,NULL,'2025-12-04 06:42:01','2025-12-04 06:42:08','687bf57d693e0fc1f'),('69312d39ec5cfc1ea','Process Job Queue q1',0,'Success','2025-12-04 06:43:00',1089296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:43:03','2025-12-04 06:43:03',1342656,1,NULL,NULL,NULL,'2025-12-04 06:42:01','2025-12-04 06:43:03','687bf57d8afb5c472'),('69312d3a49382982c','Process Job Queue e0',0,'Success','2025-12-04 06:42:02',1089297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:42:08','2025-12-04 06:42:09',1342617,1,NULL,NULL,NULL,'2025-12-04 06:42:02','2025-12-04 06:42:09','687bf57dbba8299ef'),('69312d3aa26871cb1','Send Email Reminders',0,'Success','2025-12-04 06:44:00',1089298,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:03','2025-12-04 06:44:03',1342749,1,NULL,NULL,NULL,'2025-12-04 06:42:02','2025-12-04 06:44:03','687bf5d44d3e10813'),('69312d3ad4435cf43','Send Email Notifications',0,'Success','2025-12-04 06:44:00',1089299,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:04','2025-12-04 06:44:04',1342749,1,NULL,NULL,NULL,'2025-12-04 06:42:02','2025-12-04 06:44:04','687bf5d466067a4ba'),('69312d3b20a0eb085','Auth Token Control',0,'Success','2025-12-04 06:48:00',1089300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:03','2025-12-04 06:48:03',1342845,1,NULL,NULL,NULL,'2025-12-04 06:42:03','2025-12-04 06:48:03','687bf5d511e08c57f'),('69312d3b5b0d138e6','Process Webhook Queue',0,'Success','2025-12-04 06:44:00',1089301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:05','2025-12-04 06:44:05',1342749,1,NULL,NULL,NULL,'2025-12-04 06:42:03','2025-12-04 06:44:05','687bf5d5788e2fe0e'),('69312d75d92ce8ac2','Submit Popup Reminders',0,'Success','2025-12-04 06:43:01',1089302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:43:04','2025-12-04 06:43:05',1342656,1,NULL,NULL,NULL,'2025-12-04 06:43:01','2025-12-04 06:43:05','687bf57d2f9463790'),('69312d761cb2d804a','Process Job Queue q0',0,'Success','2025-12-04 06:43:02',1089303,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:43:05','2025-12-04 06:43:05',1342656,1,NULL,NULL,NULL,'2025-12-04 06:43:02','2025-12-04 06:43:05','687bf57d693e0fc1f'),('69312d76638b4198b','Process Job Queue q1',0,'Success','2025-12-04 06:44:00',1089304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:06','2025-12-04 06:44:06',1342749,1,NULL,NULL,NULL,'2025-12-04 06:43:02','2025-12-04 06:44:06','687bf57d8afb5c472'),('69312d76b08dc2970','Process Job Queue e0',0,'Success','2025-12-04 06:43:02',1089305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:43:06','2025-12-04 06:43:06',1342656,1,NULL,NULL,NULL,'2025-12-04 06:43:02','2025-12-04 06:43:06','687bf57dbba8299ef'),('69312db1829e8f28c','Submit Popup Reminders',0,'Success','2025-12-04 06:44:01',1089306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:07','2025-12-04 06:44:07',1342749,1,NULL,NULL,NULL,'2025-12-04 06:44:01','2025-12-04 06:44:07','687bf57d2f9463790'),('69312db1babdc3e98','Process Job Queue q0',0,'Success','2025-12-04 06:44:01',1089307,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:07','2025-12-04 06:44:08',1342749,1,NULL,NULL,NULL,'2025-12-04 06:44:01','2025-12-04 06:44:08','687bf57d693e0fc1f'),('69312db1dc2f0762d','Process Job Queue q1',0,'Success','2025-12-04 06:45:00',1089308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:45:02','2025-12-04 06:45:02',1342792,1,NULL,NULL,NULL,'2025-12-04 06:44:01','2025-12-04 06:45:02','687bf57d8afb5c472'),('69312db220703b371','Process Job Queue e0',0,'Success','2025-12-04 06:44:02',1089309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:44:08','2025-12-04 06:44:09',1342749,1,NULL,NULL,NULL,'2025-12-04 06:44:02','2025-12-04 06:44:09','687bf57dbba8299ef'),('69312db28fe7e6dc5','Send Email Reminders',0,'Success','2025-12-04 06:46:00',1089310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:02','2025-12-04 06:46:03',1342807,1,NULL,NULL,NULL,'2025-12-04 06:44:02','2025-12-04 06:46:03','687bf5d44d3e10813'),('69312db2d2fa7fb91','Send Email Notifications',0,'Success','2025-12-04 06:46:00',1089311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:04','2025-12-04 06:46:04',1342807,1,NULL,NULL,NULL,'2025-12-04 06:44:02','2025-12-04 06:46:04','687bf5d466067a4ba'),('69312db3255171502','Process Webhook Queue',0,'Success','2025-12-04 06:46:00',1089312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:05','2025-12-04 06:46:05',1342807,1,NULL,NULL,NULL,'2025-12-04 06:44:03','2025-12-04 06:46:05','687bf5d5788e2fe0e'),('69312dedbe88c0fd1','Submit Popup Reminders',0,'Success','2025-12-04 06:45:01',1089313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:45:03','2025-12-04 06:45:04',1342792,1,NULL,NULL,NULL,'2025-12-04 06:45:01','2025-12-04 06:45:04','687bf57d2f9463790'),('69312dedefcbe8884','Process Job Queue q0',0,'Success','2025-12-04 06:45:01',1089314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:45:05','2025-12-04 06:45:05',1342792,1,NULL,NULL,NULL,'2025-12-04 06:45:01','2025-12-04 06:45:05','687bf57d693e0fc1f'),('69312dee1ecb05394','Process Job Queue q1',0,'Success','2025-12-04 06:46:00',1089315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:06','2025-12-04 06:46:06',1342807,1,NULL,NULL,NULL,'2025-12-04 06:45:02','2025-12-04 06:46:06','687bf57d8afb5c472'),('69312dee423a5e64c','Process Job Queue e0',0,'Success','2025-12-04 06:45:02',1089316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:45:06','2025-12-04 06:45:06',1342792,1,NULL,NULL,NULL,'2025-12-04 06:45:02','2025-12-04 06:45:06','687bf57dbba8299ef'),('69312e294c444c941','Submit Popup Reminders',0,'Success','2025-12-04 06:46:01',1089317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:07','2025-12-04 06:46:07',1342807,1,NULL,NULL,NULL,'2025-12-04 06:46:01','2025-12-04 06:46:07','687bf57d2f9463790'),('69312e29744a36a7c','Process Job Queue q0',0,'Success','2025-12-04 06:46:01',1089318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:07','2025-12-04 06:46:07',1342807,1,NULL,NULL,NULL,'2025-12-04 06:46:01','2025-12-04 06:46:07','687bf57d693e0fc1f'),('69312e299d1f8ef81','Process Job Queue q1',0,'Success','2025-12-04 06:47:00',1089319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:47:02','2025-12-04 06:47:03',1342827,1,NULL,NULL,NULL,'2025-12-04 06:46:01','2025-12-04 06:47:03','687bf57d8afb5c472'),('69312e29c0e2af667','Process Job Queue e0',0,'Success','2025-12-04 06:46:01',1089320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:46:08','2025-12-04 06:46:08',1342807,1,NULL,NULL,NULL,'2025-12-04 06:46:01','2025-12-04 06:46:08','687bf57dbba8299ef'),('69312e2a0ca28852f','Send Email Reminders',0,'Success','2025-12-04 06:48:00',1089321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:04','2025-12-04 06:48:04',1342845,1,NULL,NULL,NULL,'2025-12-04 06:46:02','2025-12-04 06:48:04','687bf5d44d3e10813'),('69312e2a3b752b336','Send Email Notifications',0,'Success','2025-12-04 06:48:00',1089322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:05','2025-12-04 06:48:05',1342845,1,NULL,NULL,NULL,'2025-12-04 06:46:02','2025-12-04 06:48:05','687bf5d466067a4ba'),('69312e2a854163aa1','Process Webhook Queue',0,'Success','2025-12-04 06:48:00',1089323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:06','2025-12-04 06:48:06',1342845,1,NULL,NULL,NULL,'2025-12-04 06:46:02','2025-12-04 06:48:06','687bf5d5788e2fe0e'),('69312e6572fab9dc2','Submit Popup Reminders',0,'Success','2025-12-04 06:47:01',1089324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:47:04','2025-12-04 06:47:04',1342827,1,NULL,NULL,NULL,'2025-12-04 06:47:01','2025-12-04 06:47:04','687bf57d2f9463790'),('69312e65a8a7c61ab','Process Job Queue q0',0,'Success','2025-12-04 06:47:01',1089325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:47:04','2025-12-04 06:47:05',1342827,1,NULL,NULL,NULL,'2025-12-04 06:47:01','2025-12-04 06:47:05','687bf57d693e0fc1f'),('69312e660cb0baa65','Process Job Queue q1',0,'Success','2025-12-04 06:48:00',1089326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:06','2025-12-04 06:48:07',1342845,1,NULL,NULL,NULL,'2025-12-04 06:47:02','2025-12-04 06:48:07','687bf57d8afb5c472'),('69312e663e234ea4e','Process Job Queue e0',0,'Success','2025-12-04 06:47:02',1089327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:47:05','2025-12-04 06:47:05',1342827,1,NULL,NULL,NULL,'2025-12-04 06:47:02','2025-12-04 06:47:05','687bf57dbba8299ef'),('69312ea19289b5e96','Submit Popup Reminders',0,'Success','2025-12-04 06:48:01',1089328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:07','2025-12-04 06:48:07',1342845,1,NULL,NULL,NULL,'2025-12-04 06:48:01','2025-12-04 06:48:07','687bf57d2f9463790'),('69312ea1b6db2e5b9','Process Job Queue q0',0,'Success','2025-12-04 06:48:01',1089329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:08','2025-12-04 06:48:08',1342845,1,NULL,NULL,NULL,'2025-12-04 06:48:01','2025-12-04 06:48:08','687bf57d693e0fc1f'),('69312ea1d6bc0d71e','Process Job Queue q1',0,'Success','2025-12-04 06:49:00',1089330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:49:02','2025-12-04 06:49:03',1342866,1,NULL,NULL,NULL,'2025-12-04 06:48:01','2025-12-04 06:49:03','687bf57d8afb5c472'),('69312ea201a525ce1','Process Job Queue e0',0,'Success','2025-12-04 06:48:02',1089331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:48:08','2025-12-04 06:48:09',1342845,1,NULL,NULL,NULL,'2025-12-04 06:48:02','2025-12-04 06:48:09','687bf57dbba8299ef'),('69312ea2399bb6acb','Send Email Reminders',0,'Success','2025-12-04 06:50:00',1089332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:05','2025-12-04 06:50:05',1342882,1,NULL,NULL,NULL,'2025-12-04 06:48:02','2025-12-04 06:50:05','687bf5d44d3e10813'),('69312ea280a4f46de','Send Email Notifications',0,'Success','2025-12-04 06:50:00',1089333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:06','2025-12-04 06:50:06',1342882,1,NULL,NULL,NULL,'2025-12-04 06:48:02','2025-12-04 06:50:06','687bf5d466067a4ba'),('69312ea2bedebbc86','Auth Token Control',0,'Success','2025-12-04 06:54:00',1089334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:03','2025-12-04 06:54:03',1342963,1,NULL,NULL,NULL,'2025-12-04 06:48:02','2025-12-04 06:54:03','687bf5d511e08c57f'),('69312ea30fb5ca94c','Process Webhook Queue',0,'Success','2025-12-04 06:50:00',1089335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:07','2025-12-04 06:50:07',1342882,1,NULL,NULL,NULL,'2025-12-04 06:48:03','2025-12-04 06:50:07','687bf5d5788e2fe0e'),('69312eddb9b34441e','Submit Popup Reminders',0,'Success','2025-12-04 06:49:01',1089336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:49:03','2025-12-04 06:49:04',1342866,1,NULL,NULL,NULL,'2025-12-04 06:49:01','2025-12-04 06:49:04','687bf57d2f9463790'),('69312edde50dd8942','Process Job Queue q0',0,'Success','2025-12-04 06:49:01',1089337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:49:05','2025-12-04 06:49:05',1342866,1,NULL,NULL,NULL,'2025-12-04 06:49:01','2025-12-04 06:49:05','687bf57d693e0fc1f'),('69312ede1921b1421','Process Job Queue q1',0,'Success','2025-12-04 06:50:00',1089338,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:07','2025-12-04 06:50:08',1342882,1,NULL,NULL,NULL,'2025-12-04 06:49:02','2025-12-04 06:50:08','687bf57d8afb5c472'),('69312ede38db91652','Process Job Queue e0',0,'Success','2025-12-04 06:49:02',1089339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:49:05','2025-12-04 06:49:05',1342866,1,NULL,NULL,NULL,'2025-12-04 06:49:02','2025-12-04 06:49:05','687bf57dbba8299ef'),('69312f199a536be27','Submit Popup Reminders',0,'Success','2025-12-04 06:50:01',1089340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:08','2025-12-04 06:50:08',1342882,1,NULL,NULL,NULL,'2025-12-04 06:50:01','2025-12-04 06:50:08','687bf57d2f9463790'),('69312f19d4328f7b1','Process Job Queue q0',0,'Success','2025-12-04 06:50:01',1089341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:09','2025-12-04 06:50:09',1342882,1,NULL,NULL,NULL,'2025-12-04 06:50:01','2025-12-04 06:50:09','687bf57d693e0fc1f'),('69312f1a13b12f10e','Process Job Queue q1',0,'Success','2025-12-04 06:51:00',1089342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:51:01','2025-12-04 06:51:02',1342905,1,NULL,NULL,NULL,'2025-12-04 06:50:02','2025-12-04 06:51:02','687bf57d8afb5c472'),('69312f1a8eeb84b5b','Process Job Queue e0',0,'Success','2025-12-04 06:50:02',1089343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:50:09','2025-12-04 06:50:10',1342882,1,NULL,NULL,NULL,'2025-12-04 06:50:02','2025-12-04 06:50:10','687bf57dbba8299ef'),('69312f1ace20d18b8','Send Email Reminders',0,'Success','2025-12-04 06:52:00',1089344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:03','2025-12-04 06:52:04',1342924,1,NULL,NULL,NULL,'2025-12-04 06:50:02','2025-12-04 06:52:04','687bf5d44d3e10813'),('69312f1b0da9a1e44','Send Email Notifications',0,'Success','2025-12-04 06:52:00',1089345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:04','2025-12-04 06:52:04',1342924,1,NULL,NULL,NULL,'2025-12-04 06:50:03','2025-12-04 06:52:04','687bf5d466067a4ba'),('69312f1b699d9769b','Send Mass Emails',0,'Success','2025-12-04 07:10:00',1089346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:04','2025-12-04 07:10:04',1343688,1,NULL,NULL,NULL,'2025-12-04 06:50:03','2025-12-04 07:10:04','687bf5d4b535f913f'),('69312f1bc17d70170','Process Webhook Queue',0,'Success','2025-12-04 06:52:00',1089347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:05','2025-12-04 06:52:05',1342924,1,NULL,NULL,NULL,'2025-12-04 06:50:03','2025-12-04 06:52:05','687bf5d5788e2fe0e'),('69312f1c0c3c57026','Send Scheduled Emails',0,'Success','2025-12-04 07:00:00',1089348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:04','2025-12-04 07:00:04',1343214,1,NULL,NULL,NULL,'2025-12-04 06:50:04','2025-12-04 07:00:04','687bf5d5eeb01d80d'),('69312f55333cacf93','Submit Popup Reminders',0,'Success','2025-12-04 06:51:01',1089349,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:51:02','2025-12-04 06:51:03',1342905,1,NULL,NULL,NULL,'2025-12-04 06:51:01','2025-12-04 06:51:03','687bf57d2f9463790'),('69312f555bc54d849','Process Job Queue q0',0,'Success','2025-12-04 06:51:01',1089350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:51:04','2025-12-04 06:51:04',1342905,1,NULL,NULL,NULL,'2025-12-04 06:51:01','2025-12-04 06:51:04','687bf57d693e0fc1f'),('69312f557877f1c8e','Process Job Queue q1',0,'Success','2025-12-04 06:52:00',1089351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:06','2025-12-04 06:52:06',1342924,1,NULL,NULL,NULL,'2025-12-04 06:51:01','2025-12-04 06:52:06','687bf57d8afb5c472'),('69312f55a49ad921a','Process Job Queue e0',0,'Success','2025-12-04 06:51:01',1089352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:51:05','2025-12-04 06:51:05',1342905,1,NULL,NULL,NULL,'2025-12-04 06:51:01','2025-12-04 06:51:05','687bf57dbba8299ef'),('69312f9223ed9d9d3','Submit Popup Reminders',0,'Success','2025-12-04 06:52:02',1089353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:06','2025-12-04 06:52:07',1342924,1,NULL,NULL,NULL,'2025-12-04 06:52:02','2025-12-04 06:52:07','687bf57d2f9463790'),('69312f92569c8b0bd','Process Job Queue q0',0,'Success','2025-12-04 06:52:02',1089354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:07','2025-12-04 06:52:07',1342924,1,NULL,NULL,NULL,'2025-12-04 06:52:02','2025-12-04 06:52:07','687bf57d693e0fc1f'),('69312f92860361d3e','Process Job Queue q1',0,'Success','2025-12-04 06:53:00',1089355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:53:01','2025-12-04 06:53:01',1342943,1,NULL,NULL,NULL,'2025-12-04 06:52:02','2025-12-04 06:53:01','687bf57d8afb5c472'),('69312f92ca0ae4400','Process Job Queue e0',0,'Success','2025-12-04 06:52:02',1089356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:52:08','2025-12-04 06:52:08',1342924,1,NULL,NULL,NULL,'2025-12-04 06:52:02','2025-12-04 06:52:08','687bf57dbba8299ef'),('69312f934ae43c63e','Send Email Reminders',0,'Success','2025-12-04 06:54:00',1089357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:04','2025-12-04 06:54:05',1342963,1,NULL,NULL,NULL,'2025-12-04 06:52:03','2025-12-04 06:54:05','687bf5d44d3e10813'),('69312f937ff310593','Send Email Notifications',0,'Success','2025-12-04 06:54:00',1089358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:05','2025-12-04 06:54:06',1342963,1,NULL,NULL,NULL,'2025-12-04 06:52:03','2025-12-04 06:54:06','687bf5d466067a4ba'),('69312f93c155169a6','Process Webhook Queue',0,'Success','2025-12-04 06:54:00',1089359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:07','2025-12-04 06:54:07',1342963,1,NULL,NULL,NULL,'2025-12-04 06:52:03','2025-12-04 06:54:07','687bf5d5788e2fe0e'),('69312fcd3f184d537','Submit Popup Reminders',0,'Success','2025-12-04 06:53:01',1089360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:53:02','2025-12-04 06:53:03',1342943,1,NULL,NULL,NULL,'2025-12-04 06:53:01','2025-12-04 06:53:03','687bf57d2f9463790'),('69312fcd644c1f514','Process Job Queue q0',0,'Success','2025-12-04 06:53:01',1089361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:53:04','2025-12-04 06:53:04',1342943,1,NULL,NULL,NULL,'2025-12-04 06:53:01','2025-12-04 06:53:04','687bf57d693e0fc1f'),('69312fcd81ed02b81','Process Job Queue q1',0,'Success','2025-12-04 06:54:00',1089362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:07','2025-12-04 06:54:07',1342963,1,NULL,NULL,NULL,'2025-12-04 06:53:01','2025-12-04 06:54:07','687bf57d8afb5c472'),('69312fcda38b194c5','Process Job Queue e0',0,'Success','2025-12-04 06:53:01',1089363,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:53:05','2025-12-04 06:53:05',1342943,1,NULL,NULL,NULL,'2025-12-04 06:53:01','2025-12-04 06:53:05','687bf57dbba8299ef'),('69313009dd5bd40dd','Submit Popup Reminders',0,'Success','2025-12-04 06:54:01',1089364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:08','2025-12-04 06:54:08',1342963,1,NULL,NULL,NULL,'2025-12-04 06:54:01','2025-12-04 06:54:08','687bf57d2f9463790'),('6931300a1b3db5e00','Process Job Queue q0',0,'Success','2025-12-04 06:54:02',1089365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:09','2025-12-04 06:54:09',1342963,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 06:54:09','687bf57d693e0fc1f'),('6931300a39d821639','Process Job Queue q1',0,'Success','2025-12-04 06:55:00',1089366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:55:02','2025-12-04 06:55:03',1343010,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 06:55:03','687bf57d8afb5c472'),('6931300a5fb76bf68','Process Job Queue e0',0,'Success','2025-12-04 06:54:02',1089367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:54:09','2025-12-04 06:54:10',1342963,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 06:54:10','687bf57dbba8299ef'),('6931300a8d64ce2f1','Send Email Reminders',0,'Success','2025-12-04 06:56:00',1089368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:02','2025-12-04 06:56:03',1343050,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 06:56:03','687bf5d44d3e10813'),('6931300ab433ab808','Send Email Notifications',0,'Success','2025-12-04 06:56:00',1089369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:04','2025-12-04 06:56:04',1343050,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 06:56:04','687bf5d466067a4ba'),('6931300ad87396c30','Auth Token Control',0,'Success','2025-12-04 07:00:00',1089370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:05','2025-12-04 07:00:05',1343214,1,NULL,NULL,NULL,'2025-12-04 06:54:02','2025-12-04 07:00:05','687bf5d511e08c57f'),('6931300b23ab1cf70','Process Webhook Queue',0,'Success','2025-12-04 06:56:00',1089371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:04','2025-12-04 06:56:04',1343050,1,NULL,NULL,NULL,'2025-12-04 06:54:03','2025-12-04 06:56:04','687bf5d5788e2fe0e'),('69313046076a652f1','Submit Popup Reminders',0,'Success','2025-12-04 06:55:02',1089372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:55:03','2025-12-04 06:55:04',1343010,1,NULL,NULL,NULL,'2025-12-04 06:55:02','2025-12-04 06:55:04','687bf57d2f9463790'),('6931304635d2082c8','Process Job Queue q0',0,'Success','2025-12-04 06:55:02',1089373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:55:04','2025-12-04 06:55:04',1343010,1,NULL,NULL,NULL,'2025-12-04 06:55:02','2025-12-04 06:55:04','687bf57d693e0fc1f'),('6931304685c4982cd','Process Job Queue q1',0,'Success','2025-12-04 06:56:00',1089374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:05','2025-12-04 06:56:05',1343050,1,NULL,NULL,NULL,'2025-12-04 06:55:02','2025-12-04 06:56:05','687bf57d8afb5c472'),('69313046a7288a061','Process Job Queue e0',0,'Success','2025-12-04 06:55:02',1089375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:55:05','2025-12-04 06:55:05',1343010,1,NULL,NULL,NULL,'2025-12-04 06:55:02','2025-12-04 06:55:05','687bf57dbba8299ef'),('6931308131de43a27','Submit Popup Reminders',0,'Success','2025-12-04 06:56:01',1089376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:06','2025-12-04 06:56:06',1343050,1,NULL,NULL,NULL,'2025-12-04 06:56:01','2025-12-04 06:56:06','687bf57d2f9463790'),('6931308151c8384c0','Process Job Queue q0',0,'Success','2025-12-04 06:56:01',1089377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:06','2025-12-04 06:56:07',1343050,1,NULL,NULL,NULL,'2025-12-04 06:56:01','2025-12-04 06:56:07','687bf57d693e0fc1f'),('693130816c54bfee4','Process Job Queue q1',0,'Success','2025-12-04 06:57:00',1089378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:57:03','2025-12-04 06:57:03',1343090,1,NULL,NULL,NULL,'2025-12-04 06:56:01','2025-12-04 06:57:03','687bf57d8afb5c472'),('693130819c6018510','Process Job Queue e0',0,'Success','2025-12-04 06:56:01',1089379,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:56:07','2025-12-04 06:56:07',1343050,1,NULL,NULL,NULL,'2025-12-04 06:56:01','2025-12-04 06:56:07','687bf57dbba8299ef'),('69313081cee78e1be','Send Email Reminders',0,'Success','2025-12-04 06:58:00',1089380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:03','2025-12-04 06:58:03',1343135,1,NULL,NULL,NULL,'2025-12-04 06:56:01','2025-12-04 06:58:03','687bf5d44d3e10813'),('69313082250e1002e','Send Email Notifications',0,'Success','2025-12-04 06:58:00',1089381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:04','2025-12-04 06:58:04',1343135,1,NULL,NULL,NULL,'2025-12-04 06:56:02','2025-12-04 06:58:04','687bf5d466067a4ba'),('6931308272cae82eb','Process Webhook Queue',0,'Success','2025-12-04 06:58:00',1089382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:05','2025-12-04 06:58:05',1343135,1,NULL,NULL,NULL,'2025-12-04 06:56:02','2025-12-04 06:58:05','687bf5d5788e2fe0e'),('693130be1fe0807f0','Submit Popup Reminders',0,'Success','2025-12-04 06:57:02',1089383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:57:04','2025-12-04 06:57:04',1343090,1,NULL,NULL,NULL,'2025-12-04 06:57:02','2025-12-04 06:57:04','687bf57d2f9463790'),('693130be4859d70f0','Process Job Queue q0',0,'Success','2025-12-04 06:57:02',1089384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:57:05','2025-12-04 06:57:05',1343090,1,NULL,NULL,NULL,'2025-12-04 06:57:02','2025-12-04 06:57:05','687bf57d693e0fc1f'),('693130be65020930f','Process Job Queue q1',0,'Success','2025-12-04 06:58:00',1089385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:06','2025-12-04 06:58:06',1343135,1,NULL,NULL,NULL,'2025-12-04 06:57:02','2025-12-04 06:58:06','687bf57d8afb5c472'),('693130bec265394a1','Process Job Queue e0',0,'Success','2025-12-04 06:57:02',1089386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:57:06','2025-12-04 06:57:06',1343090,1,NULL,NULL,NULL,'2025-12-04 06:57:02','2025-12-04 06:57:06','687bf57dbba8299ef'),('693130f990abeafb9','Submit Popup Reminders',0,'Success','2025-12-04 06:58:01',1089387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:07','2025-12-04 06:58:07',1343135,1,NULL,NULL,NULL,'2025-12-04 06:58:01','2025-12-04 06:58:07','687bf57d2f9463790'),('693130f9b2b7a46b9','Process Job Queue q0',0,'Success','2025-12-04 06:58:01',1089388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:07','2025-12-04 06:58:08',1343135,1,NULL,NULL,NULL,'2025-12-04 06:58:01','2025-12-04 06:58:08','687bf57d693e0fc1f'),('693130f9cf3bb9e49','Process Job Queue q1',0,'Success','2025-12-04 06:59:00',1089389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:59:02','2025-12-04 06:59:02',1343174,1,NULL,NULL,NULL,'2025-12-04 06:58:01','2025-12-04 06:59:02','687bf57d8afb5c472'),('693130f9f03541add','Process Job Queue e0',0,'Success','2025-12-04 06:58:01',1089390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:58:08','2025-12-04 06:58:08',1343135,1,NULL,NULL,NULL,'2025-12-04 06:58:01','2025-12-04 06:58:08','687bf57dbba8299ef'),('693130fa2a12229c0','Send Email Reminders',0,'Success','2025-12-04 07:00:00',1089391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:06','2025-12-04 07:00:06',1343214,1,NULL,NULL,NULL,'2025-12-04 06:58:02','2025-12-04 07:00:06','687bf5d44d3e10813'),('693130fa4819a3386','Send Email Notifications',0,'Success','2025-12-04 07:00:00',1089392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:06','2025-12-04 07:00:07',1343214,1,NULL,NULL,NULL,'2025-12-04 06:58:02','2025-12-04 07:00:07','687bf5d466067a4ba'),('693130fa71fabe30b','Process Webhook Queue',0,'Success','2025-12-04 07:00:00',1089393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:07','2025-12-04 07:00:07',1343214,1,NULL,NULL,NULL,'2025-12-04 06:58:02','2025-12-04 07:00:07','687bf5d5788e2fe0e'),('69313135bb6eee1bf','Submit Popup Reminders',0,'Success','2025-12-04 06:59:01',1089394,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:59:03','2025-12-04 06:59:03',1343174,1,NULL,NULL,NULL,'2025-12-04 06:59:01','2025-12-04 06:59:03','687bf57d2f9463790'),('69313135e138e1fe7','Process Job Queue q0',0,'Success','2025-12-04 06:59:01',1089395,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:59:04','2025-12-04 06:59:04',1343174,1,NULL,NULL,NULL,'2025-12-04 06:59:01','2025-12-04 06:59:04','687bf57d693e0fc1f'),('6931313613e479b6e','Process Job Queue q1',0,'Success','2025-12-04 07:00:00',1089396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:08','2025-12-04 07:00:08',1343214,1,NULL,NULL,NULL,'2025-12-04 06:59:02','2025-12-04 07:00:08','687bf57d8afb5c472'),('693131362f8480bfa','Process Job Queue e0',0,'Success','2025-12-04 06:59:02',1089397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 06:59:05','2025-12-04 06:59:05',1343174,1,NULL,NULL,NULL,'2025-12-04 06:59:02','2025-12-04 06:59:05','687bf57dbba8299ef'),('69313171df84ce375','Submit Popup Reminders',0,'Success','2025-12-04 07:00:01',1089398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:08','2025-12-04 07:00:09',1343214,1,NULL,NULL,NULL,'2025-12-04 07:00:01','2025-12-04 07:00:09','687bf57d2f9463790'),('69313172143fb5624','Process Job Queue q0',0,'Success','2025-12-04 07:00:02',1089399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:09','2025-12-04 07:00:09',1343214,1,NULL,NULL,NULL,'2025-12-04 07:00:02','2025-12-04 07:00:09','687bf57d693e0fc1f'),('693131723f2b9763d','Process Job Queue q1',0,'Success','2025-12-04 07:01:00',1089400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:01:02','2025-12-04 07:01:02',1343261,1,NULL,NULL,NULL,'2025-12-04 07:00:02','2025-12-04 07:01:02','687bf57d8afb5c472'),('6931317321e830834','Process Job Queue e0',0,'Success','2025-12-04 07:00:03',1089401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:00:10','2025-12-04 07:00:10',1343214,1,NULL,NULL,NULL,'2025-12-04 07:00:03','2025-12-04 07:00:10','687bf57dbba8299ef'),('693131736a1e4b0c0','Send Email Reminders',0,'Success','2025-12-04 07:02:00',1089402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:03','2025-12-04 07:02:04',1343299,1,NULL,NULL,NULL,'2025-12-04 07:00:03','2025-12-04 07:02:04','687bf5d44d3e10813'),('69313173b9b185b94','Send Email Notifications',0,'Success','2025-12-04 07:02:00',1089403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:05','2025-12-04 07:02:05',1343299,1,NULL,NULL,NULL,'2025-12-04 07:00:03','2025-12-04 07:02:05','687bf5d466067a4ba'),('69313173e80e09e17','Auth Token Control',0,'Success','2025-12-04 07:06:00',1089404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:03','2025-12-04 07:06:03',1343458,1,NULL,NULL,NULL,'2025-12-04 07:00:03','2025-12-04 07:06:03','687bf5d511e08c57f'),('69313174286e98030','Process Webhook Queue',0,'Success','2025-12-04 07:02:00',1089405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:05','2025-12-04 07:02:05',1343299,1,NULL,NULL,NULL,'2025-12-04 07:00:04','2025-12-04 07:02:05','687bf5d5788e2fe0e'),('693131745a805e75a','Send Scheduled Emails',0,'Success','2025-12-04 07:10:00',1089406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:05','2025-12-04 07:10:05',1343688,1,NULL,NULL,NULL,'2025-12-04 07:00:04','2025-12-04 07:10:05','687bf5d5eeb01d80d'),('693131ad4a022b457','Submit Popup Reminders',0,'Success','2025-12-04 07:01:01',1089407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:01:03','2025-12-04 07:01:03',1343261,1,NULL,NULL,NULL,'2025-12-04 07:01:01','2025-12-04 07:01:03','687bf57d2f9463790'),('693131ad77ecd7712','Process Job Queue q0',0,'Success','2025-12-04 07:01:01',1089408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:01:04','2025-12-04 07:01:04',1343261,1,NULL,NULL,NULL,'2025-12-04 07:01:01','2025-12-04 07:01:04','687bf57d693e0fc1f'),('693131ad9ff9103e9','Process Job Queue q1',0,'Success','2025-12-04 07:02:00',1089409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:06','2025-12-04 07:02:06',1343299,1,NULL,NULL,NULL,'2025-12-04 07:01:01','2025-12-04 07:02:06','687bf57d8afb5c472'),('693131adc4b2762ce','Process Job Queue e0',0,'Success','2025-12-04 07:01:01',1089410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:01:04','2025-12-04 07:01:05',1343261,1,NULL,NULL,NULL,'2025-12-04 07:01:01','2025-12-04 07:01:05','687bf57dbba8299ef'),('693131e9e9dbccc5a','Submit Popup Reminders',0,'Success','2025-12-04 07:02:01',1089411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:07','2025-12-04 07:02:07',1343299,1,NULL,NULL,NULL,'2025-12-04 07:02:01','2025-12-04 07:02:07','687bf57d2f9463790'),('693131ea2bbbef815','Process Job Queue q0',0,'Success','2025-12-04 07:02:02',1089412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:07','2025-12-04 07:02:08',1343299,1,NULL,NULL,NULL,'2025-12-04 07:02:02','2025-12-04 07:02:08','687bf57d693e0fc1f'),('693131ea6662442bf','Process Job Queue q1',0,'Success','2025-12-04 07:03:00',1089413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:03:02','2025-12-04 07:03:02',1343341,1,NULL,NULL,NULL,'2025-12-04 07:02:02','2025-12-04 07:03:02','687bf57d8afb5c472'),('693131ea82944f224','Process Job Queue e0',0,'Success','2025-12-04 07:02:02',1089414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:02:08','2025-12-04 07:02:08',1343299,1,NULL,NULL,NULL,'2025-12-04 07:02:02','2025-12-04 07:02:08','687bf57dbba8299ef'),('693131eac2ab699c3','Send Email Reminders',0,'Success','2025-12-04 07:04:00',1089415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:02','2025-12-04 07:04:02',1343384,1,NULL,NULL,NULL,'2025-12-04 07:02:02','2025-12-04 07:04:02','687bf5d44d3e10813'),('693131eb17d31d1bc','Send Email Notifications',0,'Success','2025-12-04 07:04:00',1089416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:03','2025-12-04 07:04:03',1343384,1,NULL,NULL,NULL,'2025-12-04 07:02:03','2025-12-04 07:04:03','687bf5d466067a4ba'),('693131eb9c9470e63','Process Webhook Queue',0,'Success','2025-12-04 07:04:00',1089417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:04','2025-12-04 07:04:04',1343384,1,NULL,NULL,NULL,'2025-12-04 07:02:03','2025-12-04 07:04:04','687bf5d5788e2fe0e'),('693132253137d4bd1','Submit Popup Reminders',0,'Success','2025-12-04 07:03:01',1089418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:03:03','2025-12-04 07:03:03',1343341,1,NULL,NULL,NULL,'2025-12-04 07:03:01','2025-12-04 07:03:03','687bf57d2f9463790'),('693132256bd993d1a','Process Job Queue q0',0,'Success','2025-12-04 07:03:01',1089419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:03:04','2025-12-04 07:03:04',1343341,1,NULL,NULL,NULL,'2025-12-04 07:03:01','2025-12-04 07:03:04','687bf57d693e0fc1f'),('693132259e01a2b26','Process Job Queue q1',0,'Success','2025-12-04 07:04:00',1089420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:05','2025-12-04 07:04:05',1343384,1,NULL,NULL,NULL,'2025-12-04 07:03:01','2025-12-04 07:04:05','687bf57d8afb5c472'),('69313225c8ac3e80b','Process Job Queue e0',0,'Success','2025-12-04 07:03:01',1089421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:03:05','2025-12-04 07:03:05',1343341,1,NULL,NULL,NULL,'2025-12-04 07:03:01','2025-12-04 07:03:05','687bf57dbba8299ef'),('693132617122b9a29','Submit Popup Reminders',0,'Success','2025-12-04 07:04:01',1089422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:06','2025-12-04 07:04:06',1343384,1,NULL,NULL,NULL,'2025-12-04 07:04:01','2025-12-04 07:04:06','687bf57d2f9463790'),('69313261907a4354b','Process Job Queue q0',0,'Success','2025-12-04 07:04:01',1089423,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:07','2025-12-04 07:04:07',1343384,1,NULL,NULL,NULL,'2025-12-04 07:04:01','2025-12-04 07:04:07','687bf57d693e0fc1f'),('69313261ab5bb646f','Process Job Queue q1',0,'Success','2025-12-04 07:05:00',1089424,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:05:03','2025-12-04 07:05:03',1343419,1,NULL,NULL,NULL,'2025-12-04 07:04:01','2025-12-04 07:05:03','687bf57d8afb5c472'),('69313261ca106b150','Process Job Queue e0',0,'Success','2025-12-04 07:04:01',1089425,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:04:08','2025-12-04 07:04:08',1343384,1,NULL,NULL,NULL,'2025-12-04 07:04:01','2025-12-04 07:04:08','687bf57dbba8299ef'),('69313261ea1954e0b','Send Email Reminders',0,'Success','2025-12-04 07:06:00',1089426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:04','2025-12-04 07:06:05',1343458,1,NULL,NULL,NULL,'2025-12-04 07:04:01','2025-12-04 07:06:05','687bf5d44d3e10813'),('693132620f0bccf8e','Send Email Notifications',0,'Success','2025-12-04 07:06:00',1089427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:06','2025-12-04 07:06:06',1343458,1,NULL,NULL,NULL,'2025-12-04 07:04:02','2025-12-04 07:06:06','687bf5d466067a4ba'),('6931326229be9ce12','Process Webhook Queue',0,'Success','2025-12-04 07:06:00',1089428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:07','2025-12-04 07:06:07',1343458,1,NULL,NULL,NULL,'2025-12-04 07:04:02','2025-12-04 07:06:07','687bf5d5788e2fe0e'),('6931329de6a83ae47','Submit Popup Reminders',0,'Success','2025-12-04 07:05:01',1089429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:05:04','2025-12-04 07:05:04',1343419,1,NULL,NULL,NULL,'2025-12-04 07:05:01','2025-12-04 07:05:04','687bf57d2f9463790'),('6931329e26382faa7','Process Job Queue q0',0,'Success','2025-12-04 07:05:02',1089430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:05:04','2025-12-04 07:05:05',1343419,1,NULL,NULL,NULL,'2025-12-04 07:05:02','2025-12-04 07:05:05','687bf57d693e0fc1f'),('6931329e8b78c2886','Process Job Queue q1',0,'Success','2025-12-04 07:06:00',1089431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:07','2025-12-04 07:06:08',1343458,1,NULL,NULL,NULL,'2025-12-04 07:05:02','2025-12-04 07:06:08','687bf57d8afb5c472'),('6931329ef0ddd16c0','Process Job Queue e0',0,'Success','2025-12-04 07:05:02',1089432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:05:05','2025-12-04 07:05:05',1343419,1,NULL,NULL,NULL,'2025-12-04 07:05:02','2025-12-04 07:05:05','687bf57dbba8299ef'),('693132da1c9e5a2bf','Submit Popup Reminders',0,'Success','2025-12-04 07:06:02',1089433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:08','2025-12-04 07:06:08',1343458,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:06:08','687bf57d2f9463790'),('693132da41ea29434','Process Job Queue q0',0,'Success','2025-12-04 07:06:02',1089434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:09','2025-12-04 07:06:09',1343458,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:06:09','687bf57d693e0fc1f'),('693132da6a407ccf0','Process Job Queue q1',0,'Success','2025-12-04 07:07:00',1089435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:07:02','2025-12-04 07:07:02',1343499,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:07:02','687bf57d8afb5c472'),('693132da8e1748597','Process Job Queue e0',0,'Success','2025-12-04 07:06:02',1089436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:06:10','2025-12-04 07:06:10',1343458,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:06:10','687bf57dbba8299ef'),('693132dabd5624ab3','Send Email Reminders',0,'Success','2025-12-04 07:08:00',1089437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:04','2025-12-04 07:08:04',1343538,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:08:04','687bf5d44d3e10813'),('693132dae6a92a486','Send Email Notifications',0,'Success','2025-12-04 07:08:00',1089438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:04','2025-12-04 07:08:04',1343538,1,NULL,NULL,NULL,'2025-12-04 07:06:02','2025-12-04 07:08:04','687bf5d466067a4ba'),('693132db2c91656bb','Auth Token Control',0,'Success','2025-12-04 07:12:00',1089439,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:03','2025-12-04 07:12:03',1343772,1,NULL,NULL,NULL,'2025-12-04 07:06:03','2025-12-04 07:12:03','687bf5d511e08c57f'),('693132db6f7761a41','Process Webhook Queue',0,'Success','2025-12-04 07:08:00',1089440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:05','2025-12-04 07:08:05',1343538,1,NULL,NULL,NULL,'2025-12-04 07:06:03','2025-12-04 07:08:05','687bf5d5788e2fe0e'),('693133158d45ec539','Submit Popup Reminders',0,'Success','2025-12-04 07:07:01',1089441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:07:03','2025-12-04 07:07:03',1343499,1,NULL,NULL,NULL,'2025-12-04 07:07:01','2025-12-04 07:07:03','687bf57d2f9463790'),('69313315aeaf10f68','Process Job Queue q0',0,'Success','2025-12-04 07:07:01',1089442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:07:04','2025-12-04 07:07:04',1343499,1,NULL,NULL,NULL,'2025-12-04 07:07:01','2025-12-04 07:07:04','687bf57d693e0fc1f'),('69313315e1dfefffc','Process Job Queue q1',0,'Success','2025-12-04 07:08:00',1089443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:05','2025-12-04 07:08:06',1343538,1,NULL,NULL,NULL,'2025-12-04 07:07:01','2025-12-04 07:08:06','687bf57d8afb5c472'),('6931331627e0b5a89','Process Job Queue e0',0,'Success','2025-12-04 07:07:02',1089444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:07:05','2025-12-04 07:07:05',1343499,1,NULL,NULL,NULL,'2025-12-04 07:07:02','2025-12-04 07:07:05','687bf57dbba8299ef'),('693133520b72ad6e3','Submit Popup Reminders',0,'Success','2025-12-04 07:08:02',1089445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:06','2025-12-04 07:08:06',1343538,1,NULL,NULL,NULL,'2025-12-04 07:08:02','2025-12-04 07:08:06','687bf57d2f9463790'),('693133524424ba066','Process Job Queue q0',0,'Success','2025-12-04 07:08:02',1089446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:07','2025-12-04 07:08:07',1343538,1,NULL,NULL,NULL,'2025-12-04 07:08:02','2025-12-04 07:08:07','687bf57d693e0fc1f'),('693133529f9bb73cc','Process Job Queue q1',0,'Success','2025-12-04 07:09:00',1089447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:09:02','2025-12-04 07:09:03',1343653,1,NULL,NULL,NULL,'2025-12-04 07:08:02','2025-12-04 07:09:03','687bf57d8afb5c472'),('69313352d9dd962bd','Process Job Queue e0',0,'Success','2025-12-04 07:08:02',1089448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:08:07','2025-12-04 07:08:08',1343538,1,NULL,NULL,NULL,'2025-12-04 07:08:02','2025-12-04 07:08:08','687bf57dbba8299ef'),('693133536ff58076a','Send Email Reminders',0,'Success','2025-12-04 07:10:00',1089449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:05','2025-12-04 07:10:06',1343688,1,NULL,NULL,NULL,'2025-12-04 07:08:03','2025-12-04 07:10:06','687bf5d44d3e10813'),('69313353aa3029896','Send Email Notifications',0,'Success','2025-12-04 07:10:00',1089450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:06','2025-12-04 07:10:06',1343688,1,NULL,NULL,NULL,'2025-12-04 07:08:03','2025-12-04 07:10:06','687bf5d466067a4ba'),('69313353d79d4d8d5','Process Webhook Queue',0,'Success','2025-12-04 07:10:00',1089451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:07','2025-12-04 07:10:07',1343688,1,NULL,NULL,NULL,'2025-12-04 07:08:03','2025-12-04 07:10:07','687bf5d5788e2fe0e'),('6931338d8b921899c','Submit Popup Reminders',0,'Success','2025-12-04 07:09:01',1089452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:09:03','2025-12-04 07:09:04',1343653,1,NULL,NULL,NULL,'2025-12-04 07:09:01','2025-12-04 07:09:04','687bf57d2f9463790'),('6931338dd578d33e3','Process Job Queue q0',0,'Success','2025-12-04 07:09:01',1089453,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:09:04','2025-12-04 07:09:04',1343653,1,NULL,NULL,NULL,'2025-12-04 07:09:01','2025-12-04 07:09:04','687bf57d693e0fc1f'),('6931338e5be13d6b6','Process Job Queue q1',0,'Success','2025-12-04 07:10:00',1089454,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:07','2025-12-04 07:10:08',1343688,1,NULL,NULL,NULL,'2025-12-04 07:09:02','2025-12-04 07:10:08','687bf57d8afb5c472'),('6931338eae0f73f89','Process Job Queue e0',0,'Success','2025-12-04 07:09:02',1089455,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:09:05','2025-12-04 07:09:05',1343653,1,NULL,NULL,NULL,'2025-12-04 07:09:02','2025-12-04 07:09:05','687bf57dbba8299ef'),('693133c9a086f1612','Submit Popup Reminders',0,'Success','2025-12-04 07:10:01',1089456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:08','2025-12-04 07:10:08',1343688,1,NULL,NULL,NULL,'2025-12-04 07:10:01','2025-12-04 07:10:08','687bf57d2f9463790'),('693133c9c4d17de66','Process Job Queue q0',0,'Success','2025-12-04 07:10:01',1089457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:09','2025-12-04 07:10:09',1343688,1,NULL,NULL,NULL,'2025-12-04 07:10:01','2025-12-04 07:10:09','687bf57d693e0fc1f'),('693133c9ecdd7bfb5','Process Job Queue q1',0,'Success','2025-12-04 07:11:00',1089458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:11:02','2025-12-04 07:11:02',1343727,1,NULL,NULL,NULL,'2025-12-04 07:10:01','2025-12-04 07:11:02','687bf57d8afb5c472'),('693133ca3cf89ffa0','Process Job Queue e0',0,'Success','2025-12-04 07:10:02',1089459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:10:09','2025-12-04 07:10:10',1343688,1,NULL,NULL,NULL,'2025-12-04 07:10:02','2025-12-04 07:10:10','687bf57dbba8299ef'),('693133ca77b3296db','Send Email Reminders',0,'Success','2025-12-04 07:12:00',1089460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:04','2025-12-04 07:12:04',1343772,1,NULL,NULL,NULL,'2025-12-04 07:10:02','2025-12-04 07:12:04','687bf5d44d3e10813'),('693133cae2f9ed09a','Send Email Notifications',0,'Success','2025-12-04 07:12:00',1089461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:05','2025-12-04 07:12:05',1343772,1,NULL,NULL,NULL,'2025-12-04 07:10:02','2025-12-04 07:12:05','687bf5d466067a4ba'),('693133cb4f4fc67d8','Send Mass Emails',0,'Success','2025-12-04 07:30:00',1089462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:03','2025-12-04 07:30:04',1344469,1,NULL,NULL,NULL,'2025-12-04 07:10:03','2025-12-04 07:30:04','687bf5d4b535f913f'),('693133cba6b1ccc8f','Process Webhook Queue',0,'Success','2025-12-04 07:12:00',1089463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:06','2025-12-04 07:12:06',1343772,1,NULL,NULL,NULL,'2025-12-04 07:10:03','2025-12-04 07:12:06','687bf5d5788e2fe0e'),('693133cc039c53dc4','Send Scheduled Emails',0,'Success','2025-12-04 07:20:00',1089464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:03','2025-12-04 07:20:03',1344110,1,NULL,NULL,NULL,'2025-12-04 07:10:04','2025-12-04 07:20:03','687bf5d5eeb01d80d'),('693134058bbda6729','Submit Popup Reminders',0,'Success','2025-12-04 07:11:01',1089465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:11:03','2025-12-04 07:11:03',1343727,1,NULL,NULL,NULL,'2025-12-04 07:11:01','2025-12-04 07:11:03','687bf57d2f9463790'),('69313405b829dcfd8','Process Job Queue q0',0,'Success','2025-12-04 07:11:01',1089466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:11:04','2025-12-04 07:11:04',1343727,1,NULL,NULL,NULL,'2025-12-04 07:11:01','2025-12-04 07:11:04','687bf57d693e0fc1f'),('69313405de2679b93','Process Job Queue q1',0,'Success','2025-12-04 07:12:00',1089467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:06','2025-12-04 07:12:07',1343772,1,NULL,NULL,NULL,'2025-12-04 07:11:01','2025-12-04 07:12:07','687bf57d8afb5c472'),('6931340606d7422a7','Process Job Queue e0',0,'Success','2025-12-04 07:11:02',1089468,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:11:05','2025-12-04 07:11:05',1343727,1,NULL,NULL,NULL,'2025-12-04 07:11:02','2025-12-04 07:11:05','687bf57dbba8299ef'),('69313441a27dc51b7','Submit Popup Reminders',0,'Success','2025-12-04 07:12:01',1089469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:07','2025-12-04 07:12:07',1343772,1,NULL,NULL,NULL,'2025-12-04 07:12:01','2025-12-04 07:12:07','687bf57d2f9463790'),('69313441c0f91d65a','Process Job Queue q0',0,'Success','2025-12-04 07:12:01',1089470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:08','2025-12-04 07:12:08',1343772,1,NULL,NULL,NULL,'2025-12-04 07:12:01','2025-12-04 07:12:08','687bf57d693e0fc1f'),('69313441e26f16e6e','Process Job Queue q1',0,'Success','2025-12-04 07:13:00',1089471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:13:02','2025-12-04 07:13:02',1343812,1,NULL,NULL,NULL,'2025-12-04 07:12:01','2025-12-04 07:13:02','687bf57d8afb5c472'),('693134420c76b48af','Process Job Queue e0',0,'Success','2025-12-04 07:12:02',1089472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:12:08','2025-12-04 07:12:09',1343772,1,NULL,NULL,NULL,'2025-12-04 07:12:02','2025-12-04 07:12:09','687bf57dbba8299ef'),('69313442374cd629a','Send Email Reminders',0,'Success','2025-12-04 07:14:00',1089473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:03','2025-12-04 07:14:03',1343858,1,NULL,NULL,NULL,'2025-12-04 07:12:02','2025-12-04 07:14:03','687bf5d44d3e10813'),('693134427ade45afa','Send Email Notifications',0,'Success','2025-12-04 07:14:00',1089474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:04','2025-12-04 07:14:04',1343858,1,NULL,NULL,NULL,'2025-12-04 07:12:02','2025-12-04 07:14:04','687bf5d466067a4ba'),('69313442cb44e0405','Auth Token Control',0,'Success','2025-12-04 07:18:00',1089475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:03','2025-12-04 07:18:03',1344023,1,NULL,NULL,NULL,'2025-12-04 07:12:02','2025-12-04 07:18:03','687bf5d511e08c57f'),('693134430de02422c','Process Webhook Queue',0,'Success','2025-12-04 07:14:00',1089476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:05','2025-12-04 07:14:05',1343858,1,NULL,NULL,NULL,'2025-12-04 07:12:03','2025-12-04 07:14:05','687bf5d5788e2fe0e'),('6931347dd4f7b5035','Submit Popup Reminders',0,'Success','2025-12-04 07:13:01',1089477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:13:03','2025-12-04 07:13:03',1343812,1,NULL,NULL,NULL,'2025-12-04 07:13:01','2025-12-04 07:13:03','687bf57d2f9463790'),('6931347e0f99feca1','Process Job Queue q0',0,'Success','2025-12-04 07:13:02',1089478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:13:04','2025-12-04 07:13:05',1343812,1,NULL,NULL,NULL,'2025-12-04 07:13:02','2025-12-04 07:13:05','687bf57d693e0fc1f'),('6931347e332af2303','Process Job Queue q1',0,'Success','2025-12-04 07:14:00',1089479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:06','2025-12-04 07:14:07',1343858,1,NULL,NULL,NULL,'2025-12-04 07:13:02','2025-12-04 07:14:07','687bf57d8afb5c472'),('6931347e51ae37823','Process Job Queue e0',0,'Success','2025-12-04 07:13:02',1089480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:13:05','2025-12-04 07:13:05',1343812,1,NULL,NULL,NULL,'2025-12-04 07:13:02','2025-12-04 07:13:05','687bf57dbba8299ef'),('693134b9d05a04ddf','Submit Popup Reminders',0,'Success','2025-12-04 07:14:01',1089481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:07','2025-12-04 07:14:07',1343858,1,NULL,NULL,NULL,'2025-12-04 07:14:01','2025-12-04 07:14:07','687bf57d2f9463790'),('693134ba0cb2092eb','Process Job Queue q0',0,'Success','2025-12-04 07:14:02',1089482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:08','2025-12-04 07:14:08',1343858,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:14:08','687bf57d693e0fc1f'),('693134ba2cb43fb5d','Process Job Queue q1',0,'Success','2025-12-04 07:15:00',1089483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:15:02','2025-12-04 07:15:02',1343901,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:15:02','687bf57d8afb5c472'),('693134ba49020d84e','Process Job Queue e0',0,'Success','2025-12-04 07:14:02',1089484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:14:08','2025-12-04 07:14:09',1343858,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:14:09','687bf57dbba8299ef'),('693134ba781bda1d3','Send Email Reminders',0,'Success','2025-12-04 07:16:00',1089485,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:03','2025-12-04 07:16:04',1343944,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:16:04','687bf5d44d3e10813'),('693134ba92ffbf4d3','Send Email Notifications',0,'Success','2025-12-04 07:16:00',1089486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:05','2025-12-04 07:16:05',1343944,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:16:05','687bf5d466067a4ba'),('693134bac237fa3d1','Process Webhook Queue',0,'Success','2025-12-04 07:16:00',1089487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:05','2025-12-04 07:16:05',1343944,1,NULL,NULL,NULL,'2025-12-04 07:14:02','2025-12-04 07:16:05','687bf5d5788e2fe0e'),('693134f5762ce4c0f','Submit Popup Reminders',0,'Success','2025-12-04 07:15:01',1089488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:15:03','2025-12-04 07:15:03',1343901,1,NULL,NULL,NULL,'2025-12-04 07:15:01','2025-12-04 07:15:03','687bf57d2f9463790'),('693134f5dbb10b38d','Process Job Queue q0',0,'Success','2025-12-04 07:15:01',1089489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:15:04','2025-12-04 07:15:04',1343901,1,NULL,NULL,NULL,'2025-12-04 07:15:01','2025-12-04 07:15:04','687bf57d693e0fc1f'),('693134f6294dc0b88','Process Job Queue q1',0,'Success','2025-12-04 07:16:00',1089490,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:06','2025-12-04 07:16:06',1343944,1,NULL,NULL,NULL,'2025-12-04 07:15:02','2025-12-04 07:16:06','687bf57d8afb5c472'),('693134f66469b947a','Process Job Queue e0',0,'Success','2025-12-04 07:15:02',1089491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:15:04','2025-12-04 07:15:05',1343901,1,NULL,NULL,NULL,'2025-12-04 07:15:02','2025-12-04 07:15:05','687bf57dbba8299ef'),('69313531e4063967b','Submit Popup Reminders',0,'Success','2025-12-04 07:16:01',1089492,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:07','2025-12-04 07:16:07',1343944,1,NULL,NULL,NULL,'2025-12-04 07:16:01','2025-12-04 07:16:07','687bf57d2f9463790'),('693135321da27134d','Process Job Queue q0',0,'Success','2025-12-04 07:16:02',1089493,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:07','2025-12-04 07:16:08',1343944,1,NULL,NULL,NULL,'2025-12-04 07:16:02','2025-12-04 07:16:08','687bf57d693e0fc1f'),('69313532476e7e6ce','Process Job Queue q1',0,'Success','2025-12-04 07:17:00',1089494,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:17:02','2025-12-04 07:17:02',1343981,1,NULL,NULL,NULL,'2025-12-04 07:16:02','2025-12-04 07:17:02','687bf57d8afb5c472'),('693135327796df657','Process Job Queue e0',0,'Success','2025-12-04 07:16:02',1089495,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:16:08','2025-12-04 07:16:09',1343944,1,NULL,NULL,NULL,'2025-12-04 07:16:02','2025-12-04 07:16:09','687bf57dbba8299ef'),('6931353302bbb9243','Send Email Reminders',0,'Success','2025-12-04 07:18:00',1089496,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:04','2025-12-04 07:18:05',1344023,1,NULL,NULL,NULL,'2025-12-04 07:16:03','2025-12-04 07:18:05','687bf5d44d3e10813'),('6931353343e2b1624','Send Email Notifications',0,'Success','2025-12-04 07:18:00',1089497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:05','2025-12-04 07:18:06',1344023,1,NULL,NULL,NULL,'2025-12-04 07:16:03','2025-12-04 07:18:06','687bf5d466067a4ba'),('69313533929565320','Process Webhook Queue',0,'Success','2025-12-04 07:18:00',1089498,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:06','2025-12-04 07:18:07',1344023,1,NULL,NULL,NULL,'2025-12-04 07:16:03','2025-12-04 07:18:07','687bf5d5788e2fe0e'),('6931356d7546cfdbd','Submit Popup Reminders',0,'Success','2025-12-04 07:17:01',1089499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:17:03','2025-12-04 07:17:03',1343981,1,NULL,NULL,NULL,'2025-12-04 07:17:01','2025-12-04 07:17:03','687bf57d2f9463790'),('6931356da25ef9015','Process Job Queue q0',0,'Success','2025-12-04 07:17:01',1089500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:17:04','2025-12-04 07:17:04',1343981,1,NULL,NULL,NULL,'2025-12-04 07:17:01','2025-12-04 07:17:04','687bf57d693e0fc1f'),('6931356dc334b7868','Process Job Queue q1',0,'Success','2025-12-04 07:18:00',1089501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:07','2025-12-04 07:18:07',1344023,1,NULL,NULL,NULL,'2025-12-04 07:17:01','2025-12-04 07:18:07','687bf57d8afb5c472'),('6931356de4d7f10b2','Process Job Queue e0',0,'Success','2025-12-04 07:17:01',1089502,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:17:05','2025-12-04 07:17:05',1343981,1,NULL,NULL,NULL,'2025-12-04 07:17:01','2025-12-04 07:17:05','687bf57dbba8299ef'),('693135a988f9fb7fc','Submit Popup Reminders',0,'Success','2025-12-04 07:18:01',1089503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:08','2025-12-04 07:18:08',1344023,1,NULL,NULL,NULL,'2025-12-04 07:18:01','2025-12-04 07:18:08','687bf57d2f9463790'),('693135a9b766bc4cd','Process Job Queue q0',0,'Success','2025-12-04 07:18:01',1089504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:09','2025-12-04 07:18:09',1344023,1,NULL,NULL,NULL,'2025-12-04 07:18:01','2025-12-04 07:18:09','687bf57d693e0fc1f'),('693135a9e02803f45','Process Job Queue q1',0,'Success','2025-12-04 07:19:00',1089505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:19:02','2025-12-04 07:19:02',1344064,1,NULL,NULL,NULL,'2025-12-04 07:18:01','2025-12-04 07:19:02','687bf57d8afb5c472'),('693135aa09b29aa00','Process Job Queue e0',0,'Success','2025-12-04 07:18:02',1089506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:18:10','2025-12-04 07:18:10',1344023,1,NULL,NULL,NULL,'2025-12-04 07:18:02','2025-12-04 07:18:10','687bf57dbba8299ef'),('693135aa2f757f886','Send Email Reminders',0,'Success','2025-12-04 07:20:00',1089507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:04','2025-12-04 07:20:04',1344110,1,NULL,NULL,NULL,'2025-12-04 07:18:02','2025-12-04 07:20:04','687bf5d44d3e10813'),('693135aa5801da647','Send Email Notifications',0,'Success','2025-12-04 07:20:00',1089508,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:05','2025-12-04 07:20:05',1344110,1,NULL,NULL,NULL,'2025-12-04 07:18:02','2025-12-04 07:20:05','687bf5d466067a4ba'),('693135aaae258ef94','Auth Token Control',0,'Success','2025-12-04 07:24:00',1089509,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:04','2025-12-04 07:24:04',1344291,1,NULL,NULL,NULL,'2025-12-04 07:18:02','2025-12-04 07:24:04','687bf5d511e08c57f'),('693135ab4837641ab','Process Webhook Queue',0,'Success','2025-12-04 07:20:00',1089510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:05','2025-12-04 07:20:06',1344110,1,NULL,NULL,NULL,'2025-12-04 07:18:03','2025-12-04 07:20:06','687bf5d5788e2fe0e'),('693135e5357077eb3','Submit Popup Reminders',0,'Success','2025-12-04 07:19:01',1089511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:19:03','2025-12-04 07:19:04',1344064,1,NULL,NULL,NULL,'2025-12-04 07:19:01','2025-12-04 07:19:04','687bf57d2f9463790'),('693135e5656476575','Process Job Queue q0',0,'Success','2025-12-04 07:19:01',1089512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:19:04','2025-12-04 07:19:04',1344064,1,NULL,NULL,NULL,'2025-12-04 07:19:01','2025-12-04 07:19:04','687bf57d693e0fc1f'),('693135e58a6c976e3','Process Job Queue q1',0,'Success','2025-12-04 07:20:00',1089513,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:06','2025-12-04 07:20:06',1344110,1,NULL,NULL,NULL,'2025-12-04 07:19:01','2025-12-04 07:20:06','687bf57d8afb5c472'),('693135e5b707532b0','Process Job Queue e0',0,'Success','2025-12-04 07:19:01',1089514,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:19:05','2025-12-04 07:19:05',1344064,1,NULL,NULL,NULL,'2025-12-04 07:19:01','2025-12-04 07:19:05','687bf57dbba8299ef'),('69313621800c67b39','Submit Popup Reminders',0,'Success','2025-12-04 07:20:01',1089515,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:07','2025-12-04 07:20:07',1344110,1,NULL,NULL,NULL,'2025-12-04 07:20:01','2025-12-04 07:20:07','687bf57d2f9463790'),('69313621ab481350e','Process Job Queue q0',0,'Success','2025-12-04 07:20:01',1089516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:07','2025-12-04 07:20:07',1344110,1,NULL,NULL,NULL,'2025-12-04 07:20:01','2025-12-04 07:20:07','687bf57d693e0fc1f'),('69313621c98dc601c','Process Job Queue q1',0,'Success','2025-12-04 07:21:00',1089517,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:21:02','2025-12-04 07:21:02',1344155,1,NULL,NULL,NULL,'2025-12-04 07:20:01','2025-12-04 07:21:02','687bf57d8afb5c472'),('69313621ec2c72e17','Process Job Queue e0',0,'Success','2025-12-04 07:20:01',1089518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:20:08','2025-12-04 07:20:08',1344110,1,NULL,NULL,NULL,'2025-12-04 07:20:01','2025-12-04 07:20:08','687bf57dbba8299ef'),('693136227ac1b6f37','Send Email Reminders',0,'Success','2025-12-04 07:22:00',1089519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:22:03',1344199,1,NULL,NULL,NULL,'2025-12-04 07:20:02','2025-12-04 07:22:03','687bf5d44d3e10813'),('69313622a7d154817','Send Email Notifications',0,'Success','2025-12-04 07:22:00',1089520,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:04','2025-12-04 07:22:04',1344199,1,NULL,NULL,NULL,'2025-12-04 07:20:02','2025-12-04 07:22:04','687bf5d466067a4ba'),('69313622d7237c7aa','Process Webhook Queue',0,'Success','2025-12-04 07:22:00',1089521,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:05','2025-12-04 07:22:05',1344199,1,NULL,NULL,NULL,'2025-12-04 07:20:02','2025-12-04 07:22:05','687bf5d5788e2fe0e'),('6931362315ccada9c','Send Scheduled Emails',0,'Success','2025-12-04 07:30:00',1089522,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:04','2025-12-04 07:30:04',1344469,1,NULL,NULL,NULL,'2025-12-04 07:20:03','2025-12-04 07:30:04','687bf5d5eeb01d80d'),('6931365db387a4925','Submit Popup Reminders',0,'Success','2025-12-04 07:21:01',1089523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:21:03','2025-12-04 07:21:03',1344155,1,NULL,NULL,NULL,'2025-12-04 07:21:01','2025-12-04 07:21:03','687bf57d2f9463790'),('6931365ddf120a39b','Process Job Queue q0',0,'Success','2025-12-04 07:21:01',1089524,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:21:04','2025-12-04 07:21:04',1344155,1,NULL,NULL,NULL,'2025-12-04 07:21:01','2025-12-04 07:21:04','687bf57d693e0fc1f'),('6931365e0ba5d563e','Process Job Queue q1',0,'Success','2025-12-04 07:22:00',1089525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:06','2025-12-04 07:22:07',1344199,1,NULL,NULL,NULL,'2025-12-04 07:21:02','2025-12-04 07:22:07','687bf57d8afb5c472'),('6931365e2d6618045','Process Job Queue e0',0,'Success','2025-12-04 07:21:02',1089526,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:21:05','2025-12-04 07:21:05',1344155,1,NULL,NULL,NULL,'2025-12-04 07:21:02','2025-12-04 07:21:05','687bf57dbba8299ef'),('69313699c8dafc88f','Submit Popup Reminders',0,'Success','2025-12-04 07:22:01',1089527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:07','2025-12-04 07:22:08',1344199,1,NULL,NULL,NULL,'2025-12-04 07:22:01','2025-12-04 07:22:08','687bf57d2f9463790'),('69313699e9d7e27e0','Process Job Queue q0',0,'Success','2025-12-04 07:22:01',1089528,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:08','2025-12-04 07:22:08',1344199,1,NULL,NULL,NULL,'2025-12-04 07:22:01','2025-12-04 07:22:08','687bf57d693e0fc1f'),('6931369a202850f05','Process Job Queue q1',0,'Success','2025-12-04 07:23:00',1089529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:23:02','2025-12-04 07:23:02',1344244,1,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:23:02','687bf57d8afb5c472'),('6931369a3f2831025','Process Job Queue e0',0,'Success','2025-12-04 07:22:02',1089530,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:22:09','2025-12-04 07:22:09',1344199,1,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:22:09','687bf57dbba8299ef'),('6931369a6657f57dd','Send Email Reminders',0,'Success','2025-12-04 07:24:00',1089531,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:05','2025-12-04 07:24:05',1344291,1,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:24:05','687bf5d44d3e10813'),('6931369a83044a2e1','Send Email Notifications',0,'Success','2025-12-04 07:24:00',1089532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:06','2025-12-04 07:24:06',1344291,1,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:24:06','687bf5d466067a4ba'),('6931369ab1deac87e','Process Webhook Queue',0,'Success','2025-12-04 07:24:00',1089533,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:06','2025-12-04 07:24:06',1344291,1,NULL,NULL,NULL,'2025-12-04 07:22:02','2025-12-04 07:24:06','687bf5d5788e2fe0e'),('693136d58a0d52cde','Submit Popup Reminders',0,'Success','2025-12-04 07:23:01',1089534,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:23:03','2025-12-04 07:23:04',1344244,1,NULL,NULL,NULL,'2025-12-04 07:23:01','2025-12-04 07:23:04','687bf57d2f9463790'),('693136d5aa6eb2349','Process Job Queue q0',0,'Success','2025-12-04 07:23:01',1089535,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:23:04','2025-12-04 07:23:04',1344244,1,NULL,NULL,NULL,'2025-12-04 07:23:01','2025-12-04 07:23:04','687bf57d693e0fc1f'),('693136d5cd1be9770','Process Job Queue q1',0,'Success','2025-12-04 07:24:00',1089536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:07','2025-12-04 07:24:07',1344291,1,NULL,NULL,NULL,'2025-12-04 07:23:01','2025-12-04 07:24:07','687bf57d8afb5c472'),('693136d6070d794d7','Process Job Queue e0',0,'Success','2025-12-04 07:23:02',1089537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:23:05','2025-12-04 07:23:05',1344244,1,NULL,NULL,NULL,'2025-12-04 07:23:02','2025-12-04 07:23:05','687bf57dbba8299ef'),('69313711eeb52adb5','Submit Popup Reminders',0,'Success','2025-12-04 07:24:01',1089538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:08','2025-12-04 07:24:08',1344291,1,NULL,NULL,NULL,'2025-12-04 07:24:01','2025-12-04 07:24:08','687bf57d2f9463790'),('693137122af665793','Process Job Queue q0',0,'Success','2025-12-04 07:24:02',1089539,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:09','2025-12-04 07:24:09',1344291,1,NULL,NULL,NULL,'2025-12-04 07:24:02','2025-12-04 07:24:09','687bf57d693e0fc1f'),('6931371257df869d2','Process Job Queue q1',0,'Success','2025-12-04 07:25:00',1089540,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:25:02','2025-12-04 07:25:02',1344331,1,NULL,NULL,NULL,'2025-12-04 07:24:02','2025-12-04 07:25:02','687bf57d8afb5c472'),('69313712e9b6f2569','Process Job Queue e0',0,'Success','2025-12-04 07:24:02',1089541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:24:09','2025-12-04 07:24:09',1344291,1,NULL,NULL,NULL,'2025-12-04 07:24:02','2025-12-04 07:24:09','687bf57dbba8299ef'),('693137133f1ca057a','Send Email Reminders',0,'Success','2025-12-04 07:26:00',1089542,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:26:03',1344377,1,NULL,NULL,NULL,'2025-12-04 07:24:03','2025-12-04 07:26:03','687bf5d44d3e10813'),('69313713776256016','Send Email Notifications',0,'Success','2025-12-04 07:26:00',1089543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:04','2025-12-04 07:26:04',1344377,1,NULL,NULL,NULL,'2025-12-04 07:24:03','2025-12-04 07:26:04','687bf5d466067a4ba'),('69313713c02313d77','Auth Token Control',0,'Success','2025-12-04 07:30:00',1089544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:05','2025-12-04 07:30:05',1344469,1,NULL,NULL,NULL,'2025-12-04 07:24:03','2025-12-04 07:30:05','687bf5d511e08c57f'),('693137141ab636439','Process Webhook Queue',0,'Success','2025-12-04 07:26:00',1089545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:05','2025-12-04 07:26:05',1344377,1,NULL,NULL,NULL,'2025-12-04 07:24:04','2025-12-04 07:26:05','687bf5d5788e2fe0e'),('6931374d5ef8667d9','Submit Popup Reminders',0,'Success','2025-12-04 07:25:01',1089546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:25:03','2025-12-04 07:25:03',1344331,1,NULL,NULL,NULL,'2025-12-04 07:25:01','2025-12-04 07:25:03','687bf57d2f9463790'),('6931374d8ec995786','Process Job Queue q0',0,'Success','2025-12-04 07:25:01',1089547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:25:04','2025-12-04 07:25:04',1344331,1,NULL,NULL,NULL,'2025-12-04 07:25:01','2025-12-04 07:25:04','687bf57d693e0fc1f'),('6931374db53960630','Process Job Queue q1',0,'Success','2025-12-04 07:26:00',1089548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:06','2025-12-04 07:26:06',1344377,1,NULL,NULL,NULL,'2025-12-04 07:25:01','2025-12-04 07:26:06','687bf57d8afb5c472'),('6931374dd9944dedd','Process Job Queue e0',0,'Success','2025-12-04 07:25:01',1089549,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:25:05','2025-12-04 07:25:05',1344331,1,NULL,NULL,NULL,'2025-12-04 07:25:01','2025-12-04 07:25:05','687bf57dbba8299ef'),('69313789b6606d9be','Submit Popup Reminders',0,'Success','2025-12-04 07:26:01',1089550,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:07','2025-12-04 07:26:07',1344377,1,NULL,NULL,NULL,'2025-12-04 07:26:01','2025-12-04 07:26:07','687bf57d2f9463790'),('69313789e188109cf','Process Job Queue q0',0,'Success','2025-12-04 07:26:01',1089551,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:08','2025-12-04 07:26:08',1344377,1,NULL,NULL,NULL,'2025-12-04 07:26:01','2025-12-04 07:26:08','687bf57d693e0fc1f'),('6931378a12322378d','Process Job Queue q1',0,'Success','2025-12-04 07:27:00',1089552,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:27:02','2025-12-04 07:27:02',1344399,1,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:27:02','687bf57d8afb5c472'),('6931378a2ff2ac79b','Process Job Queue e0',0,'Success','2025-12-04 07:26:02',1089553,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:26:09','2025-12-04 07:26:09',1344377,1,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:26:09','687bf57dbba8299ef'),('6931378a55177e39e','Send Email Reminders',0,'Success','2025-12-04 07:28:00',1089554,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:03','2025-12-04 07:28:04',1344422,1,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:28:04','687bf5d44d3e10813'),('6931378a6dd01e1ad','Send Email Notifications',0,'Success','2025-12-04 07:28:00',1089555,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:04','2025-12-04 07:28:04',1344422,1,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:28:04','687bf5d466067a4ba'),('6931378a9bbabfee8','Process Webhook Queue',0,'Success','2025-12-04 07:28:00',1089556,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:05','2025-12-04 07:28:05',1344422,1,NULL,NULL,NULL,'2025-12-04 07:26:02','2025-12-04 07:28:05','687bf5d5788e2fe0e'),('693137c5557365c6f','Submit Popup Reminders',0,'Success','2025-12-04 07:27:01',1089557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:27:03','2025-12-04 07:27:03',1344399,1,NULL,NULL,NULL,'2025-12-04 07:27:01','2025-12-04 07:27:03','687bf57d2f9463790'),('693137c57770903e5','Process Job Queue q0',0,'Success','2025-12-04 07:27:01',1089558,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:27:04','2025-12-04 07:27:04',1344399,1,NULL,NULL,NULL,'2025-12-04 07:27:01','2025-12-04 07:27:04','687bf57d693e0fc1f'),('693137c59bf52ee66','Process Job Queue q1',0,'Success','2025-12-04 07:28:00',1089559,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:05','2025-12-04 07:28:06',1344422,1,NULL,NULL,NULL,'2025-12-04 07:27:01','2025-12-04 07:28:06','687bf57d8afb5c472'),('693137c5c12b76606','Process Job Queue e0',0,'Success','2025-12-04 07:27:01',1089560,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:27:05','2025-12-04 07:27:05',1344399,1,NULL,NULL,NULL,'2025-12-04 07:27:01','2025-12-04 07:27:05','687bf57dbba8299ef'),('69313801c2055c0e3','Submit Popup Reminders',0,'Success','2025-12-04 07:28:01',1089561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:06','2025-12-04 07:28:06',1344422,1,NULL,NULL,NULL,'2025-12-04 07:28:01','2025-12-04 07:28:06','687bf57d2f9463790'),('69313801f0edd7711','Process Job Queue q0',0,'Success','2025-12-04 07:28:01',1089562,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:07','2025-12-04 07:28:07',1344422,1,NULL,NULL,NULL,'2025-12-04 07:28:01','2025-12-04 07:28:07','687bf57d693e0fc1f'),('69313802447287d00','Process Job Queue q1',0,'Success','2025-12-04 07:29:00',1089563,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:29:02','2025-12-04 07:29:02',1344445,1,NULL,NULL,NULL,'2025-12-04 07:28:02','2025-12-04 07:29:02','687bf57d8afb5c472'),('69313802d215889a2','Process Job Queue e0',0,'Success','2025-12-04 07:28:02',1089564,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:28:08','2025-12-04 07:28:08',1344422,1,NULL,NULL,NULL,'2025-12-04 07:28:02','2025-12-04 07:28:08','687bf57dbba8299ef'),('693138031ed775f9a','Send Email Reminders',0,'Success','2025-12-04 07:30:00',1089565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:05','2025-12-04 07:30:06',1344469,1,NULL,NULL,NULL,'2025-12-04 07:28:03','2025-12-04 07:30:06','687bf5d44d3e10813'),('693138035b04d61ea','Send Email Notifications',0,'Success','2025-12-04 07:30:00',1089566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:06','2025-12-04 07:30:06',1344469,1,NULL,NULL,NULL,'2025-12-04 07:28:03','2025-12-04 07:30:06','687bf5d466067a4ba'),('6931380394617940c','Process Webhook Queue',0,'Success','2025-12-04 07:30:00',1089567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:07','2025-12-04 07:30:07',1344469,1,NULL,NULL,NULL,'2025-12-04 07:28:03','2025-12-04 07:30:07','687bf5d5788e2fe0e'),('6931383d448bc00f3','Submit Popup Reminders',0,'Success','2025-12-04 07:29:01',1089568,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:29:03','2025-12-04 07:29:03',1344445,1,NULL,NULL,NULL,'2025-12-04 07:29:01','2025-12-04 07:29:03','687bf57d2f9463790'),('6931383d7059444ed','Process Job Queue q0',0,'Success','2025-12-04 07:29:01',1089569,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:29:04','2025-12-04 07:29:04',1344445,1,NULL,NULL,NULL,'2025-12-04 07:29:01','2025-12-04 07:29:04','687bf57d693e0fc1f'),('6931383da540cc5bd','Process Job Queue q1',0,'Success','2025-12-04 07:30:00',1089570,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:08','2025-12-04 07:30:08',1344469,1,NULL,NULL,NULL,'2025-12-04 07:29:01','2025-12-04 07:30:08','687bf57d8afb5c472'),('6931383dc9420fec0','Process Job Queue e0',0,'Success','2025-12-04 07:29:01',1089571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:29:05','2025-12-04 07:29:05',1344445,1,NULL,NULL,NULL,'2025-12-04 07:29:01','2025-12-04 07:29:05','687bf57dbba8299ef'),('69313879723cf16e1','Submit Popup Reminders',0,'Success','2025-12-04 07:30:01',1089572,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:08','2025-12-04 07:30:08',1344469,1,NULL,NULL,NULL,'2025-12-04 07:30:01','2025-12-04 07:30:08','687bf57d2f9463790'),('693138799a5161b61','Process Job Queue q0',0,'Success','2025-12-04 07:30:01',1089573,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:09','2025-12-04 07:30:09',1344469,1,NULL,NULL,NULL,'2025-12-04 07:30:01','2025-12-04 07:30:09','687bf57d693e0fc1f'),('69313879baa971cfe','Process Job Queue q1',0,'Success','2025-12-04 07:31:00',1089574,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:31:02','2025-12-04 07:31:03',1344489,1,NULL,NULL,NULL,'2025-12-04 07:30:01','2025-12-04 07:31:03','687bf57d8afb5c472'),('6931387a2e2b2c872','Process Job Queue e0',0,'Success','2025-12-04 07:30:02',1089575,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:30:10','2025-12-04 07:30:10',1344469,1,NULL,NULL,NULL,'2025-12-04 07:30:02','2025-12-04 07:30:10','687bf57dbba8299ef'),('6931387a66ae2382c','Send Email Reminders',0,'Success','2025-12-04 07:32:00',1089576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:03','2025-12-04 07:32:03',1344512,1,NULL,NULL,NULL,'2025-12-04 07:30:02','2025-12-04 07:32:03','687bf5d44d3e10813'),('6931387aa973cb00e','Send Email Notifications',0,'Success','2025-12-04 07:32:00',1089577,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:04','2025-12-04 07:32:04',1344512,1,NULL,NULL,NULL,'2025-12-04 07:30:02','2025-12-04 07:32:04','687bf5d466067a4ba'),('6931387aedc2a42da','Send Mass Emails',0,'Success','2025-12-04 07:50:00',1089578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:04','2025-12-04 07:50:04',1345219,1,NULL,NULL,NULL,'2025-12-04 07:30:02','2025-12-04 07:50:04','687bf5d4b535f913f'),('6931387b4214a043f','Auth Token Control',0,'Success','2025-12-04 07:36:00',1089579,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:03','2025-12-04 07:36:04',1344628,1,NULL,NULL,NULL,'2025-12-04 07:30:03','2025-12-04 07:36:04','687bf5d511e08c57f'),('6931387b75e4e34bd','Process Webhook Queue',0,'Success','2025-12-04 07:32:00',1089580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:05','2025-12-04 07:32:05',1344512,1,NULL,NULL,NULL,'2025-12-04 07:30:03','2025-12-04 07:32:05','687bf5d5788e2fe0e'),('6931387ba80fc052d','Send Scheduled Emails',0,'Success','2025-12-04 07:40:00',1089581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:03','2025-12-04 07:40:03',1344870,1,NULL,NULL,NULL,'2025-12-04 07:30:03','2025-12-04 07:40:03','687bf5d5eeb01d80d'),('693138b61b8fb4573','Submit Popup Reminders',0,'Success','2025-12-04 07:31:02',1089582,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:31:04','2025-12-04 07:31:04',1344489,1,NULL,NULL,NULL,'2025-12-04 07:31:02','2025-12-04 07:31:04','687bf57d2f9463790'),('693138b63b7ca8745','Process Job Queue q0',0,'Success','2025-12-04 07:31:02',1089583,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:31:05','2025-12-04 07:31:05',1344489,1,NULL,NULL,NULL,'2025-12-04 07:31:02','2025-12-04 07:31:05','687bf57d693e0fc1f'),('693138b65fc2d1346','Process Job Queue q1',0,'Success','2025-12-04 07:32:00',1089584,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:06','2025-12-04 07:32:06',1344512,1,NULL,NULL,NULL,'2025-12-04 07:31:02','2025-12-04 07:32:06','687bf57d8afb5c472'),('693138b6828577542','Process Job Queue e0',0,'Success','2025-12-04 07:31:02',1089585,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:31:05','2025-12-04 07:31:06',1344489,1,NULL,NULL,NULL,'2025-12-04 07:31:02','2025-12-04 07:31:06','687bf57dbba8299ef'),('693138f185d115aaf','Submit Popup Reminders',0,'Success','2025-12-04 07:32:01',1089586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:07','2025-12-04 07:32:07',1344512,1,NULL,NULL,NULL,'2025-12-04 07:32:01','2025-12-04 07:32:07','687bf57d2f9463790'),('693138f1b5e850f74','Process Job Queue q0',0,'Success','2025-12-04 07:32:01',1089587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:07','2025-12-04 07:32:08',1344512,1,NULL,NULL,NULL,'2025-12-04 07:32:01','2025-12-04 07:32:08','687bf57d693e0fc1f'),('693138f1d7dc4f1b9','Process Job Queue q1',0,'Success','2025-12-04 07:33:00',1089588,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:33:02','2025-12-04 07:33:03',1344532,1,NULL,NULL,NULL,'2025-12-04 07:32:01','2025-12-04 07:33:03','687bf57d8afb5c472'),('693138f20ca56b6c4','Process Job Queue e0',0,'Success','2025-12-04 07:32:02',1089589,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:32:08','2025-12-04 07:32:08',1344512,1,NULL,NULL,NULL,'2025-12-04 07:32:02','2025-12-04 07:32:08','687bf57dbba8299ef'),('693138f24607e0457','Send Email Reminders',0,'Success','2025-12-04 07:34:00',1089590,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:02','2025-12-04 07:34:03',1344559,1,NULL,NULL,NULL,'2025-12-04 07:32:02','2025-12-04 07:34:03','687bf5d44d3e10813'),('693138f26b64e9fbe','Send Email Notifications',0,'Success','2025-12-04 07:34:00',1089591,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:03','2025-12-04 07:34:04',1344559,1,NULL,NULL,NULL,'2025-12-04 07:32:02','2025-12-04 07:34:04','687bf5d466067a4ba'),('693138f2d1cdb26ee','Process Webhook Queue',0,'Success','2025-12-04 07:34:00',1089592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:04','2025-12-04 07:34:05',1344559,1,NULL,NULL,NULL,'2025-12-04 07:32:02','2025-12-04 07:34:05','687bf5d5788e2fe0e'),('6931392db04bc1b18','Submit Popup Reminders',0,'Success','2025-12-04 07:33:01',1089593,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:33:04','2025-12-04 07:33:04',1344532,1,NULL,NULL,NULL,'2025-12-04 07:33:01','2025-12-04 07:33:04','687bf57d2f9463790'),('6931392dd8ed82e3b','Process Job Queue q0',0,'Success','2025-12-04 07:33:01',1089594,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:33:04','2025-12-04 07:33:04',1344532,1,NULL,NULL,NULL,'2025-12-04 07:33:01','2025-12-04 07:33:04','687bf57d693e0fc1f'),('6931392e0cb741535','Process Job Queue q1',0,'Success','2025-12-04 07:34:00',1089595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:06','2025-12-04 07:34:06',1344559,1,NULL,NULL,NULL,'2025-12-04 07:33:02','2025-12-04 07:34:06','687bf57d8afb5c472'),('6931392e348d03cdf','Process Job Queue e0',0,'Success','2025-12-04 07:33:02',1089596,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:33:05','2025-12-04 07:33:05',1344532,1,NULL,NULL,NULL,'2025-12-04 07:33:02','2025-12-04 07:33:05','687bf57dbba8299ef'),('693139699cac32b09','Submit Popup Reminders',0,'Success','2025-12-04 07:34:01',1089597,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:06','2025-12-04 07:34:07',1344559,1,NULL,NULL,NULL,'2025-12-04 07:34:01','2025-12-04 07:34:07','687bf57d2f9463790'),('69313969c1ab88249','Process Job Queue q0',0,'Success','2025-12-04 07:34:01',1089598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:07','2025-12-04 07:34:07',1344559,1,NULL,NULL,NULL,'2025-12-04 07:34:01','2025-12-04 07:34:07','687bf57d693e0fc1f'),('69313969e671350a1','Process Job Queue q1',0,'Success','2025-12-04 07:35:00',1089599,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:35:02','2025-12-04 07:35:02',1344587,1,NULL,NULL,NULL,'2025-12-04 07:34:01','2025-12-04 07:35:02','687bf57d8afb5c472'),('6931396a1c482fa6c','Process Job Queue e0',0,'Success','2025-12-04 07:34:02',1089600,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:34:08','2025-12-04 07:34:08',1344559,1,NULL,NULL,NULL,'2025-12-04 07:34:02','2025-12-04 07:34:08','687bf57dbba8299ef'),('6931396a51b8b7630','Send Email Reminders',0,'Success','2025-12-04 07:36:00',1089601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:04','2025-12-04 07:36:05',1344628,1,NULL,NULL,NULL,'2025-12-04 07:34:02','2025-12-04 07:36:05','687bf5d44d3e10813'),('6931396a709603eaa','Send Email Notifications',0,'Success','2025-12-04 07:36:00',1089602,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:05','2025-12-04 07:36:06',1344628,1,NULL,NULL,NULL,'2025-12-04 07:34:02','2025-12-04 07:36:06','687bf5d466067a4ba'),('6931396ab21fab0e7','Process Webhook Queue',0,'Success','2025-12-04 07:36:00',1089603,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:06','2025-12-04 07:36:06',1344628,1,NULL,NULL,NULL,'2025-12-04 07:34:02','2025-12-04 07:36:06','687bf5d5788e2fe0e'),('693139a5644219af6','Submit Popup Reminders',0,'Success','2025-12-04 07:35:01',1089604,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:35:03','2025-12-04 07:35:03',1344587,1,NULL,NULL,NULL,'2025-12-04 07:35:01','2025-12-04 07:35:03','687bf57d2f9463790'),('693139a5a111f08f6','Process Job Queue q0',0,'Success','2025-12-04 07:35:01',1089605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:35:04','2025-12-04 07:35:04',1344587,1,NULL,NULL,NULL,'2025-12-04 07:35:01','2025-12-04 07:35:04','687bf57d693e0fc1f'),('693139a6047cd3641','Process Job Queue q1',0,'Success','2025-12-04 07:36:00',1089606,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:07','2025-12-04 07:36:07',1344628,1,NULL,NULL,NULL,'2025-12-04 07:35:02','2025-12-04 07:36:07','687bf57d8afb5c472'),('693139a648dcc29e5','Process Job Queue e0',0,'Success','2025-12-04 07:35:02',1089607,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:35:04','2025-12-04 07:35:05',1344587,1,NULL,NULL,NULL,'2025-12-04 07:35:02','2025-12-04 07:35:05','687bf57dbba8299ef'),('693139e179f6c40c3','Submit Popup Reminders',0,'Success','2025-12-04 07:36:01',1089608,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:08','2025-12-04 07:36:08',1344628,1,NULL,NULL,NULL,'2025-12-04 07:36:01','2025-12-04 07:36:08','687bf57d2f9463790'),('693139e1ac64bf05d','Process Job Queue q0',0,'Success','2025-12-04 07:36:01',1089609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:09','2025-12-04 07:36:09',1344628,1,NULL,NULL,NULL,'2025-12-04 07:36:01','2025-12-04 07:36:09','687bf57d693e0fc1f'),('693139e1d011a966c','Process Job Queue q1',0,'Success','2025-12-04 07:37:00',1089610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:37:02','2025-12-04 07:37:03',1344672,1,NULL,NULL,NULL,'2025-12-04 07:36:01','2025-12-04 07:37:03','687bf57d8afb5c472'),('693139e200c5436f1','Process Job Queue e0',0,'Success','2025-12-04 07:36:02',1089611,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:36:10','2025-12-04 07:36:10',1344628,1,NULL,NULL,NULL,'2025-12-04 07:36:02','2025-12-04 07:36:10','687bf57dbba8299ef'),('693139e21f479e6a5','Send Email Reminders',0,'Success','2025-12-04 07:38:00',1089612,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:02','2025-12-04 07:38:03',1344716,1,NULL,NULL,NULL,'2025-12-04 07:36:02','2025-12-04 07:38:03','687bf5d44d3e10813'),('693139e24ef576e7f','Send Email Notifications',0,'Success','2025-12-04 07:38:00',1089613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:04','2025-12-04 07:38:04',1344716,1,NULL,NULL,NULL,'2025-12-04 07:36:02','2025-12-04 07:38:04','687bf5d466067a4ba'),('693139e27268ae5b1','Auth Token Control',0,'Success','2025-12-04 07:42:00',1089614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:03','2025-12-04 07:42:04',1344961,1,NULL,NULL,NULL,'2025-12-04 07:36:02','2025-12-04 07:42:04','687bf5d511e08c57f'),('693139e2bd9cd8738','Process Webhook Queue',0,'Success','2025-12-04 07:38:00',1089615,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:04','2025-12-04 07:38:04',1344716,1,NULL,NULL,NULL,'2025-12-04 07:36:02','2025-12-04 07:38:04','687bf5d5788e2fe0e'),('69313a1d589f23ccb','Submit Popup Reminders',0,'Success','2025-12-04 07:37:01',1089616,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:37:04','2025-12-04 07:37:04',1344672,1,NULL,NULL,NULL,'2025-12-04 07:37:01','2025-12-04 07:37:04','687bf57d2f9463790'),('69313a1d8903f29c6','Process Job Queue q0',0,'Success','2025-12-04 07:37:01',1089617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:37:04','2025-12-04 07:37:04',1344672,1,NULL,NULL,NULL,'2025-12-04 07:37:01','2025-12-04 07:37:04','687bf57d693e0fc1f'),('69313a1dacbff76ed','Process Job Queue q1',0,'Success','2025-12-04 07:38:00',1089618,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:05','2025-12-04 07:38:05',1344716,1,NULL,NULL,NULL,'2025-12-04 07:37:01','2025-12-04 07:38:05','687bf57d8afb5c472'),('69313a1dedce8e3ea','Process Job Queue e0',0,'Success','2025-12-04 07:37:01',1089619,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:37:05','2025-12-04 07:37:05',1344672,1,NULL,NULL,NULL,'2025-12-04 07:37:01','2025-12-04 07:37:05','687bf57dbba8299ef'),('69313a595308bbdde','Submit Popup Reminders',0,'Success','2025-12-04 07:38:01',1089620,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:06','2025-12-04 07:38:06',1344716,1,NULL,NULL,NULL,'2025-12-04 07:38:01','2025-12-04 07:38:06','687bf57d2f9463790'),('69313a59782c02070','Process Job Queue q0',0,'Success','2025-12-04 07:38:01',1089621,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:07','2025-12-04 07:38:07',1344716,1,NULL,NULL,NULL,'2025-12-04 07:38:01','2025-12-04 07:38:07','687bf57d693e0fc1f'),('69313a59a09e372ac','Process Job Queue q1',0,'Success','2025-12-04 07:39:00',1089622,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:39:02','2025-12-04 07:39:03',1344763,1,NULL,NULL,NULL,'2025-12-04 07:38:01','2025-12-04 07:39:03','687bf57d8afb5c472'),('69313a59d4b932b75','Process Job Queue e0',0,'Success','2025-12-04 07:38:01',1089623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:38:07','2025-12-04 07:38:08',1344716,1,NULL,NULL,NULL,'2025-12-04 07:38:01','2025-12-04 07:38:08','687bf57dbba8299ef'),('69313a5a3087db0ba','Send Email Reminders',0,'Success','2025-12-04 07:40:00',1089624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:04','2025-12-04 07:40:04',1344870,1,NULL,NULL,NULL,'2025-12-04 07:38:02','2025-12-04 07:40:04','687bf5d44d3e10813'),('69313a5a73e816ed2','Send Email Notifications',0,'Success','2025-12-04 07:40:00',1089625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:04','2025-12-04 07:40:05',1344870,1,NULL,NULL,NULL,'2025-12-04 07:38:02','2025-12-04 07:40:05','687bf5d466067a4ba'),('69313a5aaad023f86','Process Webhook Queue',0,'Success','2025-12-04 07:40:00',1089626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:05','2025-12-04 07:40:05',1344870,1,NULL,NULL,NULL,'2025-12-04 07:38:02','2025-12-04 07:40:05','687bf5d5788e2fe0e'),('69313a95813aa1b30','Submit Popup Reminders',0,'Success','2025-12-04 07:39:01',1089627,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:39:03','2025-12-04 07:39:04',1344763,1,NULL,NULL,NULL,'2025-12-04 07:39:01','2025-12-04 07:39:04','687bf57d2f9463790'),('69313a95bc387d4bb','Process Job Queue q0',0,'Success','2025-12-04 07:39:01',1089628,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:39:04','2025-12-04 07:39:04',1344763,1,NULL,NULL,NULL,'2025-12-04 07:39:01','2025-12-04 07:39:04','687bf57d693e0fc1f'),('69313a96089bac06c','Process Job Queue q1',0,'Success','2025-12-04 07:40:00',1089629,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:06','2025-12-04 07:40:06',1344870,1,NULL,NULL,NULL,'2025-12-04 07:39:02','2025-12-04 07:40:06','687bf57d8afb5c472'),('69313a963fa9c4c91','Process Job Queue e0',0,'Success','2025-12-04 07:39:02',1089630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:39:05','2025-12-04 07:39:05',1344763,1,NULL,NULL,NULL,'2025-12-04 07:39:02','2025-12-04 07:39:05','687bf57dbba8299ef'),('69313ad15689c3993','Submit Popup Reminders',0,'Success','2025-12-04 07:40:01',1089631,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:07','2025-12-04 07:40:07',1344870,1,NULL,NULL,NULL,'2025-12-04 07:40:01','2025-12-04 07:40:07','687bf57d2f9463790'),('69313ad188679c209','Process Job Queue q0',0,'Success','2025-12-04 07:40:01',1089632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:07','2025-12-04 07:40:08',1344870,1,NULL,NULL,NULL,'2025-12-04 07:40:01','2025-12-04 07:40:08','687bf57d693e0fc1f'),('69313ad1b8b73def4','Process Job Queue q1',0,'Success','2025-12-04 07:41:00',1089633,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:41:02','2025-12-04 07:41:02',1344915,1,NULL,NULL,NULL,'2025-12-04 07:40:01','2025-12-04 07:41:02','687bf57d8afb5c472'),('69313ad2401d07e5f','Process Job Queue e0',0,'Success','2025-12-04 07:40:02',1089634,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:40:08','2025-12-04 07:40:09',1344870,1,NULL,NULL,NULL,'2025-12-04 07:40:02','2025-12-04 07:40:09','687bf57dbba8299ef'),('69313ad2806b2d6fb','Send Email Reminders',0,'Success','2025-12-04 07:42:00',1089635,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:04','2025-12-04 07:42:05',1344961,1,NULL,NULL,NULL,'2025-12-04 07:40:02','2025-12-04 07:42:05','687bf5d44d3e10813'),('69313ad2ad7d7dff1','Send Email Notifications',0,'Success','2025-12-04 07:42:00',1089636,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:05','2025-12-04 07:42:05',1344961,1,NULL,NULL,NULL,'2025-12-04 07:40:02','2025-12-04 07:42:05','687bf5d466067a4ba'),('69313ad2e6f02f033','Process Webhook Queue',0,'Success','2025-12-04 07:42:00',1089637,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:06','2025-12-04 07:42:06',1344961,1,NULL,NULL,NULL,'2025-12-04 07:40:02','2025-12-04 07:42:06','687bf5d5788e2fe0e'),('69313ad3152b46121','Send Scheduled Emails',0,'Success','2025-12-04 07:50:00',1089638,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:05','2025-12-04 07:50:05',1345219,1,NULL,NULL,NULL,'2025-12-04 07:40:03','2025-12-04 07:50:05','687bf5d5eeb01d80d'),('69313b0dd5ec4532d','Submit Popup Reminders',0,'Success','2025-12-04 07:41:01',1089639,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:41:03','2025-12-04 07:41:04',1344915,1,NULL,NULL,NULL,'2025-12-04 07:41:01','2025-12-04 07:41:04','687bf57d2f9463790'),('69313b0df13194308','Process Job Queue q0',0,'Success','2025-12-04 07:41:01',1089640,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:41:05','2025-12-04 07:41:05',1344915,1,NULL,NULL,NULL,'2025-12-04 07:41:01','2025-12-04 07:41:05','687bf57d693e0fc1f'),('69313b0e2f804df38','Process Job Queue q1',0,'Success','2025-12-04 07:42:00',1089641,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:07','2025-12-04 07:42:07',1344961,1,NULL,NULL,NULL,'2025-12-04 07:41:02','2025-12-04 07:42:07','687bf57d8afb5c472'),('69313b0e594fd8b05','Process Job Queue e0',0,'Success','2025-12-04 07:41:02',1089642,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:41:06','2025-12-04 07:41:06',1344915,1,NULL,NULL,NULL,'2025-12-04 07:41:02','2025-12-04 07:41:06','687bf57dbba8299ef'),('69313b49bc54555a2','Submit Popup Reminders',0,'Success','2025-12-04 07:42:01',1089643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:07','2025-12-04 07:42:07',1344961,1,NULL,NULL,NULL,'2025-12-04 07:42:01','2025-12-04 07:42:07','687bf57d2f9463790'),('69313b49e6624e519','Process Job Queue q0',0,'Success','2025-12-04 07:42:01',1089644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:08','2025-12-04 07:42:09',1344961,1,NULL,NULL,NULL,'2025-12-04 07:42:01','2025-12-04 07:42:09','687bf57d693e0fc1f'),('69313b4a0e29125b5','Process Job Queue q1',0,'Success','2025-12-04 07:43:00',1089645,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:43:02','2025-12-04 07:43:02',1345003,1,NULL,NULL,NULL,'2025-12-04 07:42:02','2025-12-04 07:43:02','687bf57d8afb5c472'),('69313b4a28dbbea15','Process Job Queue e0',0,'Success','2025-12-04 07:42:02',1089646,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:42:09','2025-12-04 07:42:09',1344961,1,NULL,NULL,NULL,'2025-12-04 07:42:02','2025-12-04 07:42:09','687bf57dbba8299ef'),('69313b4a5fde3cbfb','Send Email Reminders',0,'Success','2025-12-04 07:44:00',1089647,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:02','2025-12-04 07:44:03',1345048,1,NULL,NULL,NULL,'2025-12-04 07:42:02','2025-12-04 07:44:03','687bf5d44d3e10813'),('69313b4ae9af41f15','Send Email Notifications',0,'Success','2025-12-04 07:44:00',1089648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:04','2025-12-04 07:44:04',1345048,1,NULL,NULL,NULL,'2025-12-04 07:42:02','2025-12-04 07:44:04','687bf5d466067a4ba'),('69313b4b20fcee77f','Auth Token Control',0,'Success','2025-12-04 07:48:00',1089649,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:04','2025-12-04 07:48:04',1345174,1,NULL,NULL,NULL,'2025-12-04 07:42:03','2025-12-04 07:48:04','687bf5d511e08c57f'),('69313b4b6fccd6960','Process Webhook Queue',0,'Success','2025-12-04 07:44:00',1089650,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:05','2025-12-04 07:44:05',1345048,1,NULL,NULL,NULL,'2025-12-04 07:42:03','2025-12-04 07:44:05','687bf5d5788e2fe0e'),('69313b8531816f6d2','Submit Popup Reminders',0,'Success','2025-12-04 07:43:01',1089651,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:43:03','2025-12-04 07:43:03',1345003,1,NULL,NULL,NULL,'2025-12-04 07:43:01','2025-12-04 07:43:03','687bf57d2f9463790'),('69313b856cf594fb1','Process Job Queue q0',0,'Success','2025-12-04 07:43:01',1089652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:43:04','2025-12-04 07:43:04',1345003,1,NULL,NULL,NULL,'2025-12-04 07:43:01','2025-12-04 07:43:04','687bf57d693e0fc1f'),('69313b858dc414493','Process Job Queue q1',0,'Success','2025-12-04 07:44:00',1089653,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:06','2025-12-04 07:44:06',1345048,1,NULL,NULL,NULL,'2025-12-04 07:43:01','2025-12-04 07:44:06','687bf57d8afb5c472'),('69313b85c018e6d17','Process Job Queue e0',0,'Success','2025-12-04 07:43:01',1089654,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:43:05','2025-12-04 07:43:05',1345003,1,NULL,NULL,NULL,'2025-12-04 07:43:01','2025-12-04 07:43:05','687bf57dbba8299ef'),('69313bc1885b7ee92','Submit Popup Reminders',0,'Success','2025-12-04 07:44:01',1089655,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:06','2025-12-04 07:44:07',1345048,1,NULL,NULL,NULL,'2025-12-04 07:44:01','2025-12-04 07:44:07','687bf57d2f9463790'),('69313bc1bb7f48531','Process Job Queue q0',0,'Success','2025-12-04 07:44:01',1089656,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:07','2025-12-04 07:44:08',1345048,1,NULL,NULL,NULL,'2025-12-04 07:44:01','2025-12-04 07:44:08','687bf57d693e0fc1f'),('69313bc1da0d3e7d5','Process Job Queue q1',0,'Success','2025-12-04 07:45:00',1089657,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:45:03','2025-12-04 07:45:03',1345093,1,NULL,NULL,NULL,'2025-12-04 07:44:01','2025-12-04 07:45:03','687bf57d8afb5c472'),('69313bc21618fe449','Process Job Queue e0',0,'Success','2025-12-04 07:44:02',1089658,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:44:08','2025-12-04 07:44:08',1345048,1,NULL,NULL,NULL,'2025-12-04 07:44:02','2025-12-04 07:44:08','687bf57dbba8299ef'),('69313bc23915c1e7c','Send Email Reminders',0,'Success','2025-12-04 07:46:00',1089659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:03','2025-12-04 07:46:03',1345130,1,NULL,NULL,NULL,'2025-12-04 07:44:02','2025-12-04 07:46:03','687bf5d44d3e10813'),('69313bc2583badfa0','Send Email Notifications',0,'Success','2025-12-04 07:46:00',1089660,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:04','2025-12-04 07:46:04',1345130,1,NULL,NULL,NULL,'2025-12-04 07:44:02','2025-12-04 07:46:04','687bf5d466067a4ba'),('69313bc287d1e88f6','Process Webhook Queue',0,'Success','2025-12-04 07:46:00',1089661,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:04','2025-12-04 07:46:04',1345130,1,NULL,NULL,NULL,'2025-12-04 07:44:02','2025-12-04 07:46:04','687bf5d5788e2fe0e'),('69313bfe2d917440d','Submit Popup Reminders',0,'Success','2025-12-04 07:45:02',1089662,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:45:04','2025-12-04 07:45:04',1345093,1,NULL,NULL,NULL,'2025-12-04 07:45:02','2025-12-04 07:45:04','687bf57d2f9463790'),('69313bfe8b0d3879b','Process Job Queue q0',0,'Success','2025-12-04 07:45:02',1089663,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:45:05','2025-12-04 07:45:05',1345093,1,NULL,NULL,NULL,'2025-12-04 07:45:02','2025-12-04 07:45:05','687bf57d693e0fc1f'),('69313bfed9fd92c72','Process Job Queue q1',0,'Success','2025-12-04 07:46:00',1089664,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:05','2025-12-04 07:46:05',1345130,1,NULL,NULL,NULL,'2025-12-04 07:45:02','2025-12-04 07:46:05','687bf57d8afb5c472'),('69313bff2d3918e96','Process Job Queue e0',0,'Success','2025-12-04 07:45:03',1089665,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:45:06','2025-12-04 07:45:06',1345093,1,NULL,NULL,NULL,'2025-12-04 07:45:03','2025-12-04 07:45:06','687bf57dbba8299ef'),('69313c397b5bea0e9','Submit Popup Reminders',0,'Success','2025-12-04 07:46:01',1089666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:06','2025-12-04 07:46:06',1345130,1,NULL,NULL,NULL,'2025-12-04 07:46:01','2025-12-04 07:46:06','687bf57d2f9463790'),('69313c39b9f28916b','Process Job Queue q0',0,'Success','2025-12-04 07:46:01',1089667,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:06','2025-12-04 07:46:07',1345130,1,NULL,NULL,NULL,'2025-12-04 07:46:01','2025-12-04 07:46:07','687bf57d693e0fc1f'),('69313c3a25367d423','Process Job Queue q1',0,'Success','2025-12-04 07:47:00',1089668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:47:02','2025-12-04 07:47:02',1345150,1,NULL,NULL,NULL,'2025-12-04 07:46:02','2025-12-04 07:47:02','687bf57d8afb5c472'),('69313c3a69116a209','Process Job Queue e0',0,'Success','2025-12-04 07:46:02',1089669,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:46:07','2025-12-04 07:46:07',1345130,1,NULL,NULL,NULL,'2025-12-04 07:46:02','2025-12-04 07:46:07','687bf57dbba8299ef'),('69313c3aa472e0563','Send Email Reminders',0,'Success','2025-12-04 07:48:00',1089670,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:04','2025-12-04 07:48:05',1345174,1,NULL,NULL,NULL,'2025-12-04 07:46:02','2025-12-04 07:48:05','687bf5d44d3e10813'),('69313c3af1e5e1fb0','Send Email Notifications',0,'Success','2025-12-04 07:48:00',1089671,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:05','2025-12-04 07:48:05',1345174,1,NULL,NULL,NULL,'2025-12-04 07:46:02','2025-12-04 07:48:05','687bf5d466067a4ba'),('69313c3b44100f415','Process Webhook Queue',0,'Success','2025-12-04 07:48:00',1089672,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:06','2025-12-04 07:48:06',1345174,1,NULL,NULL,NULL,'2025-12-04 07:46:03','2025-12-04 07:48:06','687bf5d5788e2fe0e'),('69313c75b8b83c59c','Submit Popup Reminders',0,'Success','2025-12-04 07:47:01',1089673,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:47:03','2025-12-04 07:47:04',1345150,1,NULL,NULL,NULL,'2025-12-04 07:47:01','2025-12-04 07:47:04','687bf57d2f9463790'),('69313c75de4104191','Process Job Queue q0',0,'Success','2025-12-04 07:47:01',1089674,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:47:04','2025-12-04 07:47:04',1345150,1,NULL,NULL,NULL,'2025-12-04 07:47:01','2025-12-04 07:47:04','687bf57d693e0fc1f'),('69313c760cf9d9bd2','Process Job Queue q1',0,'Success','2025-12-04 07:48:00',1089675,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:07','2025-12-04 07:48:07',1345174,1,NULL,NULL,NULL,'2025-12-04 07:47:02','2025-12-04 07:48:07','687bf57d8afb5c472'),('69313c763d171d322','Process Job Queue e0',0,'Success','2025-12-04 07:47:02',1089676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:47:05','2025-12-04 07:47:05',1345150,1,NULL,NULL,NULL,'2025-12-04 07:47:02','2025-12-04 07:47:05','687bf57dbba8299ef'),('69313cb19a30d3295','Submit Popup Reminders',0,'Success','2025-12-04 07:48:01',1089677,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:07','2025-12-04 07:48:08',1345174,1,NULL,NULL,NULL,'2025-12-04 07:48:01','2025-12-04 07:48:08','687bf57d2f9463790'),('69313cb1c103b0bf9','Process Job Queue q0',0,'Success','2025-12-04 07:48:01',1089678,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:08','2025-12-04 07:48:09',1345174,1,NULL,NULL,NULL,'2025-12-04 07:48:01','2025-12-04 07:48:09','687bf57d693e0fc1f'),('69313cb1f07419d44','Process Job Queue q1',0,'Success','2025-12-04 07:49:00',1089679,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:49:02','2025-12-04 07:49:02',1345196,1,NULL,NULL,NULL,'2025-12-04 07:48:01','2025-12-04 07:49:02','687bf57d8afb5c472'),('69313cb22fb1cc226','Process Job Queue e0',0,'Success','2025-12-04 07:48:02',1089680,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:48:09','2025-12-04 07:48:09',1345174,1,NULL,NULL,NULL,'2025-12-04 07:48:02','2025-12-04 07:48:09','687bf57dbba8299ef'),('69313cb28de877efe','Send Email Reminders',0,'Success','2025-12-04 07:50:00',1089681,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:06','2025-12-04 07:50:06',1345219,1,NULL,NULL,NULL,'2025-12-04 07:48:02','2025-12-04 07:50:06','687bf5d44d3e10813'),('69313cb2e7b8df2ef','Send Email Notifications',0,'Success','2025-12-04 07:50:00',1089682,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:07','2025-12-04 07:50:07',1345219,1,NULL,NULL,NULL,'2025-12-04 07:48:02','2025-12-04 07:50:07','687bf5d466067a4ba'),('69313cb377e05e1a8','Auth Token Control',0,'Success','2025-12-04 07:54:00',1089683,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:03','2025-12-04 07:54:03',1345312,1,NULL,NULL,NULL,'2025-12-04 07:48:03','2025-12-04 07:54:03','687bf5d511e08c57f'),('69313cb3b0210ff80','Process Webhook Queue',0,'Success','2025-12-04 07:50:00',1089684,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:07','2025-12-04 07:50:08',1345219,1,NULL,NULL,NULL,'2025-12-04 07:48:03','2025-12-04 07:50:08','687bf5d5788e2fe0e'),('69313cedb613c9a07','Submit Popup Reminders',0,'Success','2025-12-04 07:49:01',1089685,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:49:03','2025-12-04 07:49:03',1345196,1,NULL,NULL,NULL,'2025-12-04 07:49:01','2025-12-04 07:49:03','687bf57d2f9463790'),('69313cedda15aeaaf','Process Job Queue q0',0,'Success','2025-12-04 07:49:01',1089686,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:49:04','2025-12-04 07:49:04',1345196,1,NULL,NULL,NULL,'2025-12-04 07:49:01','2025-12-04 07:49:04','687bf57d693e0fc1f'),('69313cee134fa820f','Process Job Queue q1',0,'Success','2025-12-04 07:50:00',1089687,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:08','2025-12-04 07:50:08',1345219,1,NULL,NULL,NULL,'2025-12-04 07:49:02','2025-12-04 07:50:08','687bf57d8afb5c472'),('69313cee415f7fd2f','Process Job Queue e0',0,'Success','2025-12-04 07:49:02',1089688,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:49:05','2025-12-04 07:49:05',1345196,1,NULL,NULL,NULL,'2025-12-04 07:49:02','2025-12-04 07:49:05','687bf57dbba8299ef'),('69313d29d0ea26bd6','Submit Popup Reminders',0,'Success','2025-12-04 07:50:01',1089689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:09','2025-12-04 07:50:09',1345219,1,NULL,NULL,NULL,'2025-12-04 07:50:01','2025-12-04 07:50:09','687bf57d2f9463790'),('69313d2a0b9c85b35','Process Job Queue q0',0,'Success','2025-12-04 07:50:02',1089690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:09','2025-12-04 07:50:10',1345219,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 07:50:10','687bf57d693e0fc1f'),('69313d2a2b7d54b88','Process Job Queue q1',0,'Success','2025-12-04 07:51:00',1089691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:51:02','2025-12-04 07:51:02',1345240,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 07:51:02','687bf57d8afb5c472'),('69313d2a45b46f3d9','Process Job Queue e0',0,'Success','2025-12-04 07:50:02',1089692,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:50:10','2025-12-04 07:50:10',1345219,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 07:50:10','687bf57dbba8299ef'),('69313d2a6c3216e30','Send Email Reminders',0,'Success','2025-12-04 07:52:00',1089693,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:03','2025-12-04 07:52:03',1345260,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 07:52:03','687bf5d44d3e10813'),('69313d2a93c36dceb','Send Email Notifications',0,'Success','2025-12-04 07:52:00',1089694,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:04','2025-12-04 07:52:04',1345260,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 07:52:04','687bf5d466067a4ba'),('69313d2ae01938d6c','Send Mass Emails',0,'Success','2025-12-04 08:10:00',1089695,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:03','2025-12-04 08:10:04',1345882,1,NULL,NULL,NULL,'2025-12-04 07:50:02','2025-12-04 08:10:04','687bf5d4b535f913f'),('69313d2b510736af1','Process Webhook Queue',0,'Success','2025-12-04 07:52:00',1089696,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:05','2025-12-04 07:52:05',1345260,1,NULL,NULL,NULL,'2025-12-04 07:50:03','2025-12-04 07:52:05','687bf5d5788e2fe0e'),('69313d2c127bb2225','Send Scheduled Emails',0,'Success','2025-12-04 08:00:00',1089697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:04','2025-12-04 08:00:04',1345565,1,NULL,NULL,NULL,'2025-12-04 07:50:04','2025-12-04 08:00:04','687bf5d5eeb01d80d'),('69313d652c4e2dbd1','Submit Popup Reminders',0,'Success','2025-12-04 07:51:01',1089698,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:51:03','2025-12-04 07:51:03',1345240,1,NULL,NULL,NULL,'2025-12-04 07:51:01','2025-12-04 07:51:03','687bf57d2f9463790'),('69313d65502b40676','Process Job Queue q0',0,'Success','2025-12-04 07:51:01',1089699,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:51:04','2025-12-04 07:51:04',1345240,1,NULL,NULL,NULL,'2025-12-04 07:51:01','2025-12-04 07:51:04','687bf57d693e0fc1f'),('69313d65787f98815','Process Job Queue q1',0,'Success','2025-12-04 07:52:00',1089700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:05','2025-12-04 07:52:06',1345260,1,NULL,NULL,NULL,'2025-12-04 07:51:01','2025-12-04 07:52:06','687bf57d8afb5c472'),('69313d65ae32a090f','Process Job Queue e0',0,'Success','2025-12-04 07:51:01',1089701,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:51:04','2025-12-04 07:51:04',1345240,1,NULL,NULL,NULL,'2025-12-04 07:51:01','2025-12-04 07:51:04','687bf57dbba8299ef'),('69313da12827bff21','Submit Popup Reminders',0,'Success','2025-12-04 07:52:01',1089702,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:06','2025-12-04 07:52:07',1345260,1,NULL,NULL,NULL,'2025-12-04 07:52:01','2025-12-04 07:52:07','687bf57d2f9463790'),('69313da1598c16d0f','Process Job Queue q0',0,'Success','2025-12-04 07:52:01',1089703,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:07','2025-12-04 07:52:07',1345260,1,NULL,NULL,NULL,'2025-12-04 07:52:01','2025-12-04 07:52:07','687bf57d693e0fc1f'),('69313da18b248fd9a','Process Job Queue q1',0,'Success','2025-12-04 07:53:00',1089704,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:53:02','2025-12-04 07:53:02',1345282,1,NULL,NULL,NULL,'2025-12-04 07:52:01','2025-12-04 07:53:02','687bf57d8afb5c472'),('69313da1b70e9162b','Process Job Queue e0',0,'Success','2025-12-04 07:52:01',1089705,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:52:08','2025-12-04 07:52:08',1345260,1,NULL,NULL,NULL,'2025-12-04 07:52:01','2025-12-04 07:52:08','687bf57dbba8299ef'),('69313da1ecb60f196','Send Email Reminders',0,'Success','2025-12-04 07:54:00',1089706,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:04','2025-12-04 07:54:04',1345312,1,NULL,NULL,NULL,'2025-12-04 07:52:01','2025-12-04 07:54:04','687bf5d44d3e10813'),('69313da2279f3aea4','Send Email Notifications',0,'Success','2025-12-04 07:54:00',1089707,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:05','2025-12-04 07:54:05',1345312,1,NULL,NULL,NULL,'2025-12-04 07:52:02','2025-12-04 07:54:05','687bf5d466067a4ba'),('69313da2b3e7a9af5','Process Webhook Queue',0,'Success','2025-12-04 07:54:00',1089708,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:06','2025-12-04 07:54:06',1345312,1,NULL,NULL,NULL,'2025-12-04 07:52:02','2025-12-04 07:54:06','687bf5d5788e2fe0e'),('69313ddd9cd701e22','Submit Popup Reminders',0,'Success','2025-12-04 07:53:01',1089709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:53:03','2025-12-04 07:53:03',1345282,1,NULL,NULL,NULL,'2025-12-04 07:53:01','2025-12-04 07:53:03','687bf57d2f9463790'),('69313dddc28535972','Process Job Queue q0',0,'Success','2025-12-04 07:53:01',1089710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:53:04','2025-12-04 07:53:04',1345282,1,NULL,NULL,NULL,'2025-12-04 07:53:01','2025-12-04 07:53:04','687bf57d693e0fc1f'),('69313ddde30f4bf9a','Process Job Queue q1',0,'Success','2025-12-04 07:54:00',1089711,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:06','2025-12-04 07:54:07',1345312,1,NULL,NULL,NULL,'2025-12-04 07:53:01','2025-12-04 07:54:07','687bf57d8afb5c472'),('69313dde0cb2f1403','Process Job Queue e0',0,'Success','2025-12-04 07:53:02',1089712,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:53:05','2025-12-04 07:53:05',1345282,1,NULL,NULL,NULL,'2025-12-04 07:53:02','2025-12-04 07:53:05','687bf57dbba8299ef'),('69313e192dc9915b9','Submit Popup Reminders',0,'Success','2025-12-04 07:54:01',1089713,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:07','2025-12-04 07:54:07',1345312,1,NULL,NULL,NULL,'2025-12-04 07:54:01','2025-12-04 07:54:07','687bf57d2f9463790'),('69313e19589ea438f','Process Job Queue q0',0,'Success','2025-12-04 07:54:01',1089714,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:08','2025-12-04 07:54:08',1345312,1,NULL,NULL,NULL,'2025-12-04 07:54:01','2025-12-04 07:54:08','687bf57d693e0fc1f'),('69313e198707c4b85','Process Job Queue q1',0,'Success','2025-12-04 07:55:00',1089715,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:55:02','2025-12-04 07:55:03',1345350,1,NULL,NULL,NULL,'2025-12-04 07:54:01','2025-12-04 07:55:03','687bf57d8afb5c472'),('69313e19f14bb401f','Process Job Queue e0',0,'Success','2025-12-04 07:54:01',1089716,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:54:09','2025-12-04 07:54:09',1345312,1,NULL,NULL,NULL,'2025-12-04 07:54:01','2025-12-04 07:54:09','687bf57dbba8299ef'),('69313e1a646d86723','Send Email Reminders',0,'Success','2025-12-04 07:56:00',1089717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:03','2025-12-04 07:56:03',1345395,1,NULL,NULL,NULL,'2025-12-04 07:54:02','2025-12-04 07:56:03','687bf5d44d3e10813'),('69313e1aad0f5c060','Send Email Notifications',0,'Success','2025-12-04 07:56:00',1089718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:04','2025-12-04 07:56:04',1345395,1,NULL,NULL,NULL,'2025-12-04 07:54:02','2025-12-04 07:56:04','687bf5d466067a4ba'),('69313e1af2d178f22','Auth Token Control',0,'Success','2025-12-04 08:00:00',1089719,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:05','2025-12-04 08:00:05',1345565,1,NULL,NULL,NULL,'2025-12-04 07:54:02','2025-12-04 08:00:05','687bf5d511e08c57f'),('69313e1b2fcf45da2','Process Webhook Queue',0,'Success','2025-12-04 07:56:00',1089720,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:04','2025-12-04 07:56:04',1345395,1,NULL,NULL,NULL,'2025-12-04 07:54:03','2025-12-04 07:56:04','687bf5d5788e2fe0e'),('69313e55dc683cd01','Submit Popup Reminders',0,'Success','2025-12-04 07:55:01',1089721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:55:04','2025-12-04 07:55:04',1345350,1,NULL,NULL,NULL,'2025-12-04 07:55:01','2025-12-04 07:55:04','687bf57d2f9463790'),('69313e561e8f60e64','Process Job Queue q0',0,'Success','2025-12-04 07:55:02',1089722,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:55:05','2025-12-04 07:55:05',1345350,1,NULL,NULL,NULL,'2025-12-04 07:55:02','2025-12-04 07:55:05','687bf57d693e0fc1f'),('69313e56472597ed3','Process Job Queue q1',0,'Success','2025-12-04 07:56:00',1089723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:05','2025-12-04 07:56:05',1345395,1,NULL,NULL,NULL,'2025-12-04 07:55:02','2025-12-04 07:56:05','687bf57d8afb5c472'),('69313e567f7f0dab6','Process Job Queue e0',0,'Success','2025-12-04 07:55:02',1089724,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:55:05','2025-12-04 07:55:05',1345350,1,NULL,NULL,NULL,'2025-12-04 07:55:02','2025-12-04 07:55:05','687bf57dbba8299ef'),('69313e9130b3102ee','Submit Popup Reminders',0,'Success','2025-12-04 07:56:01',1089725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:06','2025-12-04 07:56:06',1345395,1,NULL,NULL,NULL,'2025-12-04 07:56:01','2025-12-04 07:56:06','687bf57d2f9463790'),('69313e9174a5f0bca','Process Job Queue q0',0,'Success','2025-12-04 07:56:01',1089726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:06','2025-12-04 07:56:07',1345395,1,NULL,NULL,NULL,'2025-12-04 07:56:01','2025-12-04 07:56:07','687bf57d693e0fc1f'),('69313e92152480150','Process Job Queue q1',0,'Success','2025-12-04 07:57:00',1089727,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:57:02','2025-12-04 07:57:02',1345435,1,NULL,NULL,NULL,'2025-12-04 07:56:02','2025-12-04 07:57:02','687bf57d8afb5c472'),('69313e926b665c076','Process Job Queue e0',0,'Success','2025-12-04 07:56:02',1089728,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:56:07','2025-12-04 07:56:07',1345395,1,NULL,NULL,NULL,'2025-12-04 07:56:02','2025-12-04 07:56:07','687bf57dbba8299ef'),('69313e92ad811c51e','Send Email Reminders',0,'Success','2025-12-04 07:58:00',1089729,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:03','2025-12-04 07:58:03',1345481,1,NULL,NULL,NULL,'2025-12-04 07:56:02','2025-12-04 07:58:03','687bf5d44d3e10813'),('69313e92cec907df0','Send Email Notifications',0,'Success','2025-12-04 07:58:00',1089730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:04','2025-12-04 07:58:04',1345481,1,NULL,NULL,NULL,'2025-12-04 07:56:02','2025-12-04 07:58:04','687bf5d466067a4ba'),('69313e9306b81d657','Process Webhook Queue',0,'Success','2025-12-04 07:58:00',1089731,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:04','2025-12-04 07:58:05',1345481,1,NULL,NULL,NULL,'2025-12-04 07:56:03','2025-12-04 07:58:05','687bf5d5788e2fe0e'),('69313ecd533fdd5d6','Submit Popup Reminders',0,'Success','2025-12-04 07:57:01',1089732,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:57:03','2025-12-04 07:57:03',1345435,1,NULL,NULL,NULL,'2025-12-04 07:57:01','2025-12-04 07:57:03','687bf57d2f9463790'),('69313ecd7b134d439','Process Job Queue q0',0,'Success','2025-12-04 07:57:01',1089733,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:57:04','2025-12-04 07:57:04',1345435,1,NULL,NULL,NULL,'2025-12-04 07:57:01','2025-12-04 07:57:04','687bf57d693e0fc1f'),('69313ecd9f53d9d33','Process Job Queue q1',0,'Success','2025-12-04 07:58:00',1089734,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:05','2025-12-04 07:58:05',1345481,1,NULL,NULL,NULL,'2025-12-04 07:57:01','2025-12-04 07:58:05','687bf57d8afb5c472'),('69313ecdc6076fffb','Process Job Queue e0',0,'Success','2025-12-04 07:57:01',1089735,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:57:05','2025-12-04 07:57:05',1345435,1,NULL,NULL,NULL,'2025-12-04 07:57:01','2025-12-04 07:57:05','687bf57dbba8299ef'),('69313f0995c990f02','Submit Popup Reminders',0,'Success','2025-12-04 07:58:01',1089736,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:06','2025-12-04 07:58:06',1345481,1,NULL,NULL,NULL,'2025-12-04 07:58:01','2025-12-04 07:58:06','687bf57d2f9463790'),('69313f09c195916c8','Process Job Queue q0',0,'Success','2025-12-04 07:58:01',1089737,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:06','2025-12-04 07:58:07',1345481,1,NULL,NULL,NULL,'2025-12-04 07:58:01','2025-12-04 07:58:07','687bf57d693e0fc1f'),('69313f0a0ac888efd','Process Job Queue q1',0,'Success','2025-12-04 07:59:00',1089738,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:59:02','2025-12-04 07:59:02',1345526,1,NULL,NULL,NULL,'2025-12-04 07:58:02','2025-12-04 07:59:02','687bf57d8afb5c472'),('69313f0a46c52846c','Process Job Queue e0',0,'Success','2025-12-04 07:58:02',1089739,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:58:07','2025-12-04 07:58:07',1345481,1,NULL,NULL,NULL,'2025-12-04 07:58:02','2025-12-04 07:58:07','687bf57dbba8299ef'),('69313f0a8e6c149e3','Send Email Reminders',0,'Success','2025-12-04 08:00:00',1089740,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:06','2025-12-04 08:00:06',1345565,1,NULL,NULL,NULL,'2025-12-04 07:58:02','2025-12-04 08:00:06','687bf5d44d3e10813'),('69313f0abed4e48d9','Send Email Notifications',0,'Success','2025-12-04 08:00:00',1089741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:07','2025-12-04 08:00:07',1345565,1,NULL,NULL,NULL,'2025-12-04 07:58:02','2025-12-04 08:00:07','687bf5d466067a4ba'),('69313f0b5645eee7a','Process Webhook Queue',0,'Success','2025-12-04 08:00:00',1089742,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:08','2025-12-04 08:00:08',1345565,1,NULL,NULL,NULL,'2025-12-04 07:58:03','2025-12-04 08:00:08','687bf5d5788e2fe0e'),('69313f45eba0ad57c','Submit Popup Reminders',0,'Success','2025-12-04 07:59:01',1089743,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:59:03','2025-12-04 07:59:04',1345526,1,NULL,NULL,NULL,'2025-12-04 07:59:01','2025-12-04 07:59:04','687bf57d2f9463790'),('69313f46203b7e7cc','Process Job Queue q0',0,'Success','2025-12-04 07:59:02',1089744,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:59:04','2025-12-04 07:59:05',1345526,1,NULL,NULL,NULL,'2025-12-04 07:59:02','2025-12-04 07:59:05','687bf57d693e0fc1f'),('69313f46482b8b649','Process Job Queue q1',0,'Success','2025-12-04 08:00:00',1089745,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:08','2025-12-04 08:00:08',1345565,1,NULL,NULL,NULL,'2025-12-04 07:59:02','2025-12-04 08:00:08','687bf57d8afb5c472'),('69313f4667a8a92ab','Process Job Queue e0',0,'Success','2025-12-04 07:59:02',1089746,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 07:59:05','2025-12-04 07:59:05',1345526,1,NULL,NULL,NULL,'2025-12-04 07:59:02','2025-12-04 07:59:05','687bf57dbba8299ef'),('69313f81dc3e37d90','Submit Popup Reminders',0,'Success','2025-12-04 08:00:01',1089747,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:09','2025-12-04 08:00:09',1345565,1,NULL,NULL,NULL,'2025-12-04 08:00:01','2025-12-04 08:00:09','687bf57d2f9463790'),('69313f820eda69d28','Process Job Queue q0',0,'Success','2025-12-04 08:00:02',1089748,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:10','2025-12-04 08:00:10',1345565,1,NULL,NULL,NULL,'2025-12-04 08:00:02','2025-12-04 08:00:10','687bf57d693e0fc1f'),('69313f8238412292f','Process Job Queue q1',0,'Success','2025-12-04 08:01:00',1089749,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:01:03','2025-12-04 08:01:03',1345609,1,NULL,NULL,NULL,'2025-12-04 08:00:02','2025-12-04 08:01:03','687bf57d8afb5c472'),('69313f826859e93b3','Process Job Queue e0',0,'Success','2025-12-04 08:00:02',1089750,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:00:10','2025-12-04 08:00:11',1345565,1,NULL,NULL,NULL,'2025-12-04 08:00:02','2025-12-04 08:00:11','687bf57dbba8299ef'),('69313f828c9a88067','Send Email Reminders',0,'Success','2025-12-04 08:02:00',1089751,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:03','2025-12-04 08:02:03',1345646,1,NULL,NULL,NULL,'2025-12-04 08:00:02','2025-12-04 08:02:03','687bf5d44d3e10813'),('69313f82cabc6b274','Send Email Notifications',0,'Success','2025-12-04 08:02:00',1089752,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:04','2025-12-04 08:02:04',1345646,1,NULL,NULL,NULL,'2025-12-04 08:00:02','2025-12-04 08:02:04','687bf5d466067a4ba'),('69313f831d6166090','Auth Token Control',0,'Success','2025-12-04 08:06:00',1089753,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:03','2025-12-04 08:06:03',1345735,1,NULL,NULL,NULL,'2025-12-04 08:00:03','2025-12-04 08:06:03','687bf5d511e08c57f'),('69313f837c1f6a723','Process Webhook Queue',0,'Success','2025-12-04 08:02:00',1089754,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:05','2025-12-04 08:02:05',1345646,1,NULL,NULL,NULL,'2025-12-04 08:00:03','2025-12-04 08:02:05','687bf5d5788e2fe0e'),('69313f83c958c1873','Send Scheduled Emails',0,'Success','2025-12-04 08:10:00',1089755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:04','2025-12-04 08:10:04',1345882,1,NULL,NULL,NULL,'2025-12-04 08:00:03','2025-12-04 08:10:04','687bf5d5eeb01d80d'),('69313fbe07b7a32a0','Submit Popup Reminders',0,'Success','2025-12-04 08:01:02',1089756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:01:04','2025-12-04 08:01:04',1345609,1,NULL,NULL,NULL,'2025-12-04 08:01:02','2025-12-04 08:01:04','687bf57d2f9463790'),('69313fbe3fa7bd9d5','Process Job Queue q0',0,'Success','2025-12-04 08:01:02',1089757,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:01:04','2025-12-04 08:01:05',1345609,1,NULL,NULL,NULL,'2025-12-04 08:01:02','2025-12-04 08:01:05','687bf57d693e0fc1f'),('69313fbe72d032e67','Process Job Queue q1',0,'Success','2025-12-04 08:02:00',1089758,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:05','2025-12-04 08:02:05',1345646,1,NULL,NULL,NULL,'2025-12-04 08:01:02','2025-12-04 08:02:05','687bf57d8afb5c472'),('69313fbf0026bd5ca','Process Job Queue e0',0,'Success','2025-12-04 08:01:02',1089759,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:01:05','2025-12-04 08:01:05',1345609,1,NULL,NULL,NULL,'2025-12-04 08:01:03','2025-12-04 08:01:05','687bf57dbba8299ef'),('69313ff97d2f6e32e','Submit Popup Reminders',0,'Success','2025-12-04 08:02:01',1089760,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:06','2025-12-04 08:02:06',1345646,1,NULL,NULL,NULL,'2025-12-04 08:02:01','2025-12-04 08:02:06','687bf57d2f9463790'),('69313ff9a8e28d25f','Process Job Queue q0',0,'Success','2025-12-04 08:02:01',1089761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:07','2025-12-04 08:02:07',1345646,1,NULL,NULL,NULL,'2025-12-04 08:02:01','2025-12-04 08:02:07','687bf57d693e0fc1f'),('69313ff9d6c73c1b7','Process Job Queue q1',0,'Success','2025-12-04 08:03:00',1089762,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:03:02','2025-12-04 08:03:02',1345677,1,NULL,NULL,NULL,'2025-12-04 08:02:01','2025-12-04 08:03:02','687bf57d8afb5c472'),('69313ffa36853e76f','Process Job Queue e0',0,'Success','2025-12-04 08:02:02',1089763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:02:07','2025-12-04 08:02:07',1345646,1,NULL,NULL,NULL,'2025-12-04 08:02:02','2025-12-04 08:02:07','687bf57dbba8299ef'),('69313ffa867eafb22','Send Email Reminders',0,'Success','2025-12-04 08:04:00',1089764,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:03','2025-12-04 08:04:03',1345697,1,NULL,NULL,NULL,'2025-12-04 08:02:02','2025-12-04 08:04:03','687bf5d44d3e10813'),('69313ffb10acb98be','Send Email Notifications',0,'Success','2025-12-04 08:04:00',1089765,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:04','2025-12-04 08:04:05',1345697,1,NULL,NULL,NULL,'2025-12-04 08:02:03','2025-12-04 08:04:05','687bf5d466067a4ba'),('69313ffb410f528d8','Process Webhook Queue',0,'Success','2025-12-04 08:04:00',1089766,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:05','2025-12-04 08:04:05',1345697,1,NULL,NULL,NULL,'2025-12-04 08:02:03','2025-12-04 08:04:05','687bf5d5788e2fe0e'),('69314035bf6f83241','Submit Popup Reminders',0,'Success','2025-12-04 08:03:01',1089767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:03:03','2025-12-04 08:03:03',1345677,1,NULL,NULL,NULL,'2025-12-04 08:03:01','2025-12-04 08:03:03','687bf57d2f9463790'),('69314035e684ad6ad','Process Job Queue q0',0,'Success','2025-12-04 08:03:01',1089768,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:03:04','2025-12-04 08:03:04',1345677,1,NULL,NULL,NULL,'2025-12-04 08:03:01','2025-12-04 08:03:04','687bf57d693e0fc1f'),('69314036110c7a1df','Process Job Queue q1',0,'Success','2025-12-04 08:04:00',1089769,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:06','2025-12-04 08:04:06',1345697,1,NULL,NULL,NULL,'2025-12-04 08:03:02','2025-12-04 08:04:06','687bf57d8afb5c472'),('6931403638e739efd','Process Job Queue e0',0,'Success','2025-12-04 08:03:02',1089770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:03:05','2025-12-04 08:03:05',1345677,1,NULL,NULL,NULL,'2025-12-04 08:03:02','2025-12-04 08:03:05','687bf57dbba8299ef'),('693140721466defb0','Submit Popup Reminders',0,'Success','2025-12-04 08:04:02',1089771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:07','2025-12-04 08:04:07',1345697,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:04:07','687bf57d2f9463790'),('69314072442b2cc1b','Process Job Queue q0',0,'Success','2025-12-04 08:04:02',1089772,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:08','2025-12-04 08:04:08',1345697,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:04:08','687bf57d693e0fc1f'),('693140725c44c068e','Process Job Queue q1',0,'Success','2025-12-04 08:05:00',1089773,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:05:02','2025-12-04 08:05:02',1345716,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:05:02','687bf57d8afb5c472'),('6931407280c959596','Process Job Queue e0',0,'Success','2025-12-04 08:04:02',1089774,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:04:09','2025-12-04 08:04:09',1345697,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:04:09','687bf57dbba8299ef'),('69314072a3763e386','Send Email Reminders',0,'Success','2025-12-04 08:06:00',1089775,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:04','2025-12-04 08:06:04',1345735,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:06:04','687bf5d44d3e10813'),('69314072c685c3618','Send Email Notifications',0,'Success','2025-12-04 08:06:00',1089776,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:05','2025-12-04 08:06:05',1345735,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:06:05','687bf5d466067a4ba'),('69314072ebe95d416','Process Webhook Queue',0,'Success','2025-12-04 08:06:00',1089777,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:05','2025-12-04 08:06:06',1345735,1,NULL,NULL,NULL,'2025-12-04 08:04:02','2025-12-04 08:06:06','687bf5d5788e2fe0e'),('693140ae109955cfb','Submit Popup Reminders',0,'Success','2025-12-04 08:05:02',1089778,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:05:03','2025-12-04 08:05:03',1345716,1,NULL,NULL,NULL,'2025-12-04 08:05:02','2025-12-04 08:05:03','687bf57d2f9463790'),('693140ae3a42809b9','Process Job Queue q0',0,'Success','2025-12-04 08:05:02',1089779,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:05:04','2025-12-04 08:05:05',1345716,1,NULL,NULL,NULL,'2025-12-04 08:05:02','2025-12-04 08:05:05','687bf57d693e0fc1f'),('693140ae5f1bb30f2','Process Job Queue q1',0,'Success','2025-12-04 08:06:00',1089780,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:06','2025-12-04 08:06:06',1345735,1,NULL,NULL,NULL,'2025-12-04 08:05:02','2025-12-04 08:06:06','687bf57d8afb5c472'),('693140ae82e7ed0ae','Process Job Queue e0',0,'Success','2025-12-04 08:05:02',1089781,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:05:05','2025-12-04 08:05:05',1345716,1,NULL,NULL,NULL,'2025-12-04 08:05:02','2025-12-04 08:05:05','687bf57dbba8299ef'),('693140e940c389ddb','Submit Popup Reminders',0,'Success','2025-12-04 08:06:01',1089782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:07','2025-12-04 08:06:07',1345735,1,NULL,NULL,NULL,'2025-12-04 08:06:01','2025-12-04 08:06:07','687bf57d2f9463790'),('693140e960877a7ae','Process Job Queue q0',0,'Success','2025-12-04 08:06:01',1089783,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:08','2025-12-04 08:06:08',1345735,1,NULL,NULL,NULL,'2025-12-04 08:06:01','2025-12-04 08:06:08','687bf57d693e0fc1f'),('693140e9835f0c6f2','Process Job Queue q1',0,'Success','2025-12-04 08:07:00',1089784,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:07:02','2025-12-04 08:07:03',1345753,1,NULL,NULL,NULL,'2025-12-04 08:06:01','2025-12-04 08:07:03','687bf57d8afb5c472'),('693140e9aa64ea0ae','Process Job Queue e0',0,'Success','2025-12-04 08:06:01',1089785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:06:09','2025-12-04 08:06:09',1345735,1,NULL,NULL,NULL,'2025-12-04 08:06:01','2025-12-04 08:06:09','687bf57dbba8299ef'),('693140e9e7434bd2d','Send Email Reminders',0,'Success','2025-12-04 08:08:00',1089786,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:03','2025-12-04 08:08:03',1345771,1,NULL,NULL,NULL,'2025-12-04 08:06:01','2025-12-04 08:08:03','687bf5d44d3e10813'),('693140ea53a75a58f','Send Email Notifications',0,'Success','2025-12-04 08:08:00',1089787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:04','2025-12-04 08:08:04',1345771,1,NULL,NULL,NULL,'2025-12-04 08:06:02','2025-12-04 08:08:04','687bf5d466067a4ba'),('693140ea9a9ed9658','Auth Token Control',0,'Success','2025-12-04 08:12:00',1089788,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:03','2025-12-04 08:12:04',1345942,1,NULL,NULL,NULL,'2025-12-04 08:06:02','2025-12-04 08:12:04','687bf5d511e08c57f'),('693140eaf0ef1f832','Process Webhook Queue',0,'Success','2025-12-04 08:08:00',1089789,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:05','2025-12-04 08:08:05',1345771,1,NULL,NULL,NULL,'2025-12-04 08:06:02','2025-12-04 08:08:05','687bf5d5788e2fe0e'),('693141258ebb9a7d0','Submit Popup Reminders',0,'Success','2025-12-04 08:07:01',1089790,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:07:03','2025-12-04 08:07:03',1345753,1,NULL,NULL,NULL,'2025-12-04 08:07:01','2025-12-04 08:07:03','687bf57d2f9463790'),('69314125d6c06db7b','Process Job Queue q0',0,'Success','2025-12-04 08:07:01',1089791,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:07:04','2025-12-04 08:07:04',1345753,1,NULL,NULL,NULL,'2025-12-04 08:07:01','2025-12-04 08:07:04','687bf57d693e0fc1f'),('693141262d79f050d','Process Job Queue q1',0,'Success','2025-12-04 08:08:00',1089792,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:05','2025-12-04 08:08:05',1345771,1,NULL,NULL,NULL,'2025-12-04 08:07:02','2025-12-04 08:08:05','687bf57d8afb5c472'),('69314126a733a1346','Process Job Queue e0',0,'Success','2025-12-04 08:07:02',1089793,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:07:04','2025-12-04 08:07:05',1345753,1,NULL,NULL,NULL,'2025-12-04 08:07:02','2025-12-04 08:07:05','687bf57dbba8299ef'),('69314161447021dd4','Submit Popup Reminders',0,'Success','2025-12-04 08:08:01',1089794,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:06','2025-12-04 08:08:06',1345771,1,NULL,NULL,NULL,'2025-12-04 08:08:01','2025-12-04 08:08:06','687bf57d2f9463790'),('693141616d0d37cb1','Process Job Queue q0',0,'Success','2025-12-04 08:08:01',1089795,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:07','2025-12-04 08:08:07',1345771,1,NULL,NULL,NULL,'2025-12-04 08:08:01','2025-12-04 08:08:07','687bf57d693e0fc1f'),('693141619b3bd871e','Process Job Queue q1',0,'Success','2025-12-04 08:09:00',1089796,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:09:02','2025-12-04 08:09:02',1345797,1,NULL,NULL,NULL,'2025-12-04 08:08:01','2025-12-04 08:09:02','687bf57d8afb5c472'),('69314162131eed5d2','Process Job Queue e0',0,'Success','2025-12-04 08:08:02',1089797,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:08:08','2025-12-04 08:08:08',1345771,1,NULL,NULL,NULL,'2025-12-04 08:08:02','2025-12-04 08:08:08','687bf57dbba8299ef'),('693141624d0630458','Send Email Reminders',0,'Success','2025-12-04 08:10:00',1089798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:05','2025-12-04 08:10:05',1345882,1,NULL,NULL,NULL,'2025-12-04 08:08:02','2025-12-04 08:10:05','687bf5d44d3e10813'),('693141629e5d49da2','Send Email Notifications',0,'Success','2025-12-04 08:10:00',1089799,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:06','2025-12-04 08:10:06',1345882,1,NULL,NULL,NULL,'2025-12-04 08:08:02','2025-12-04 08:10:06','687bf5d466067a4ba'),('69314162cd60810af','Process Webhook Queue',0,'Success','2025-12-04 08:10:00',1089800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:07','2025-12-04 08:10:07',1345882,1,NULL,NULL,NULL,'2025-12-04 08:08:02','2025-12-04 08:10:07','687bf5d5788e2fe0e'),('6931419d27e93b11d','Submit Popup Reminders',0,'Success','2025-12-04 08:09:01',1089801,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:09:03','2025-12-04 08:09:03',1345797,1,NULL,NULL,NULL,'2025-12-04 08:09:01','2025-12-04 08:09:03','687bf57d2f9463790'),('6931419d633e14c4a','Process Job Queue q0',0,'Success','2025-12-04 08:09:01',1089802,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:09:04','2025-12-04 08:09:04',1345797,1,NULL,NULL,NULL,'2025-12-04 08:09:01','2025-12-04 08:09:04','687bf57d693e0fc1f'),('6931419dbf2547e28','Process Job Queue q1',0,'Success','2025-12-04 08:10:00',1089803,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:07','2025-12-04 08:10:08',1345882,1,NULL,NULL,NULL,'2025-12-04 08:09:01','2025-12-04 08:10:08','687bf57d8afb5c472'),('6931419e25c285b70','Process Job Queue e0',0,'Success','2025-12-04 08:09:02',1089804,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:09:05','2025-12-04 08:09:05',1345797,1,NULL,NULL,NULL,'2025-12-04 08:09:02','2025-12-04 08:09:05','687bf57dbba8299ef'),('693141d986324674f','Submit Popup Reminders',0,'Success','2025-12-04 08:10:01',1089805,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:08','2025-12-04 08:10:08',1345882,1,NULL,NULL,NULL,'2025-12-04 08:10:01','2025-12-04 08:10:08','687bf57d2f9463790'),('693141d9ad04abaa1','Process Job Queue q0',0,'Success','2025-12-04 08:10:01',1089806,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:09','2025-12-04 08:10:09',1345882,1,NULL,NULL,NULL,'2025-12-04 08:10:01','2025-12-04 08:10:09','687bf57d693e0fc1f'),('693141d9d1c8bd50b','Process Job Queue q1',0,'Success','2025-12-04 08:11:00',1089807,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:11:02','2025-12-04 08:11:03',1345902,1,NULL,NULL,NULL,'2025-12-04 08:10:01','2025-12-04 08:11:03','687bf57d8afb5c472'),('693141d9f3c7d30e1','Process Job Queue e0',0,'Success','2025-12-04 08:10:01',1089808,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:10:10','2025-12-04 08:10:10',1345882,1,NULL,NULL,NULL,'2025-12-04 08:10:01','2025-12-04 08:10:10','687bf57dbba8299ef'),('693141da418b6476a','Send Email Reminders',0,'Success','2025-12-04 08:12:00',1089809,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:05','2025-12-04 08:12:05',1345942,1,NULL,NULL,NULL,'2025-12-04 08:10:02','2025-12-04 08:12:05','687bf5d44d3e10813'),('693141da8cc6e7b3e','Send Email Notifications',0,'Success','2025-12-04 08:12:00',1089810,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:06','2025-12-04 08:12:06',1345942,1,NULL,NULL,NULL,'2025-12-04 08:10:02','2025-12-04 08:12:06','687bf5d466067a4ba'),('693141daba1f9cd7e','Send Mass Emails',0,'Success','2025-12-04 08:30:00',1089811,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:04','2025-12-04 08:30:05',1346647,1,NULL,NULL,NULL,'2025-12-04 08:10:02','2025-12-04 08:30:05','687bf5d4b535f913f'),('693141db10885e0b3','Process Webhook Queue',0,'Success','2025-12-04 08:12:00',1089812,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:07','2025-12-04 08:12:07',1345942,1,NULL,NULL,NULL,'2025-12-04 08:10:03','2025-12-04 08:12:07','687bf5d5788e2fe0e'),('693141db9d9379ed1','Send Scheduled Emails',0,'Success','2025-12-04 08:20:00',1089813,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:04','2025-12-04 08:20:04',1346257,1,NULL,NULL,NULL,'2025-12-04 08:10:03','2025-12-04 08:20:04','687bf5d5eeb01d80d'),('69314215c6cc67310','Submit Popup Reminders',0,'Success','2025-12-04 08:11:01',1089814,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:11:04','2025-12-04 08:11:04',1345902,1,NULL,NULL,NULL,'2025-12-04 08:11:01','2025-12-04 08:11:04','687bf57d2f9463790'),('69314215f02167579','Process Job Queue q0',0,'Success','2025-12-04 08:11:01',1089815,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:11:04','2025-12-04 08:11:05',1345902,1,NULL,NULL,NULL,'2025-12-04 08:11:01','2025-12-04 08:11:05','687bf57d693e0fc1f'),('693142162b337b9a7','Process Job Queue q1',0,'Success','2025-12-04 08:12:00',1089816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:07','2025-12-04 08:12:07',1345942,1,NULL,NULL,NULL,'2025-12-04 08:11:02','2025-12-04 08:12:07','687bf57d8afb5c472'),('69314216551f775ba','Process Job Queue e0',0,'Success','2025-12-04 08:11:02',1089817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:11:05','2025-12-04 08:11:05',1345902,1,NULL,NULL,NULL,'2025-12-04 08:11:02','2025-12-04 08:11:05','687bf57dbba8299ef'),('6931425208a631673','Submit Popup Reminders',0,'Success','2025-12-04 08:12:02',1089818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:08','2025-12-04 08:12:08',1345942,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:12:08','687bf57d2f9463790'),('693142523ccb14ec3','Process Job Queue q0',0,'Success','2025-12-04 08:12:02',1089819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:09','2025-12-04 08:12:09',1345942,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:12:09','687bf57d693e0fc1f'),('69314252656841eaa','Process Job Queue q1',0,'Success','2025-12-04 08:13:00',1089820,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:13:01','2025-12-04 08:13:02',1345981,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:13:02','687bf57d8afb5c472'),('69314252874a041aa','Process Job Queue e0',0,'Success','2025-12-04 08:12:02',1089821,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:12:09','2025-12-04 08:12:10',1345942,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:12:10','687bf57dbba8299ef'),('69314252ac56d17fd','Send Email Reminders',0,'Success','2025-12-04 08:14:00',1089822,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:02','2025-12-04 08:14:03',1346018,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:14:03','687bf5d44d3e10813'),('69314252e1a4dbe65','Send Email Notifications',0,'Success','2025-12-04 08:14:00',1089823,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:04','2025-12-04 08:14:04',1346018,1,NULL,NULL,NULL,'2025-12-04 08:12:02','2025-12-04 08:14:04','687bf5d466067a4ba'),('69314253142dd136f','Auth Token Control',0,'Success','2025-12-04 08:18:00',1089824,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:03','2025-12-04 08:18:04',1346179,1,NULL,NULL,NULL,'2025-12-04 08:12:03','2025-12-04 08:18:04','687bf5d511e08c57f'),('6931425367e938216','Process Webhook Queue',0,'Success','2025-12-04 08:14:00',1089825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:05','2025-12-04 08:14:05',1346018,1,NULL,NULL,NULL,'2025-12-04 08:12:03','2025-12-04 08:14:05','687bf5d5788e2fe0e'),('6931428d39c915b6f','Submit Popup Reminders',0,'Success','2025-12-04 08:13:01',1089826,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:13:02','2025-12-04 08:13:03',1345981,1,NULL,NULL,NULL,'2025-12-04 08:13:01','2025-12-04 08:13:03','687bf57d2f9463790'),('6931428d68e0af51d','Process Job Queue q0',0,'Success','2025-12-04 08:13:01',1089827,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:13:03','2025-12-04 08:13:04',1345981,1,NULL,NULL,NULL,'2025-12-04 08:13:01','2025-12-04 08:13:04','687bf57d693e0fc1f'),('6931428d92d0618bb','Process Job Queue q1',0,'Success','2025-12-04 08:14:00',1089828,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:06','2025-12-04 08:14:06',1346018,1,NULL,NULL,NULL,'2025-12-04 08:13:01','2025-12-04 08:14:06','687bf57d8afb5c472'),('6931428db06defc03','Process Job Queue e0',0,'Success','2025-12-04 08:13:01',1089829,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:13:04','2025-12-04 08:13:05',1345981,1,NULL,NULL,NULL,'2025-12-04 08:13:01','2025-12-04 08:13:05','687bf57dbba8299ef'),('693142c96f331fdc6','Submit Popup Reminders',0,'Success','2025-12-04 08:14:01',1089830,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:07','2025-12-04 08:14:07',1346018,1,NULL,NULL,NULL,'2025-12-04 08:14:01','2025-12-04 08:14:07','687bf57d2f9463790'),('693142c999497321a','Process Job Queue q0',0,'Success','2025-12-04 08:14:01',1089831,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:07','2025-12-04 08:14:07',1346018,1,NULL,NULL,NULL,'2025-12-04 08:14:01','2025-12-04 08:14:07','687bf57d693e0fc1f'),('693142c9b5b64c1fb','Process Job Queue q1',0,'Success','2025-12-04 08:15:00',1089832,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:15:04','2025-12-04 08:15:04',1346054,1,NULL,NULL,NULL,'2025-12-04 08:14:01','2025-12-04 08:15:04','687bf57d8afb5c472'),('693142c9ddce21179','Process Job Queue e0',0,'Success','2025-12-04 08:14:01',1089833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:14:08','2025-12-04 08:14:08',1346018,1,NULL,NULL,NULL,'2025-12-04 08:14:01','2025-12-04 08:14:08','687bf57dbba8299ef'),('693142ca20fe9b2df','Send Email Reminders',0,'Success','2025-12-04 08:16:00',1089834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:02','2025-12-04 08:16:02',1346099,1,NULL,NULL,NULL,'2025-12-04 08:14:02','2025-12-04 08:16:02','687bf5d44d3e10813'),('693142ca40035947a','Send Email Notifications',0,'Success','2025-12-04 08:16:00',1089835,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:03','2025-12-04 08:16:04',1346099,1,NULL,NULL,NULL,'2025-12-04 08:14:02','2025-12-04 08:16:04','687bf5d466067a4ba'),('693142ca83b08873d','Process Webhook Queue',0,'Success','2025-12-04 08:16:00',1089836,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:04','2025-12-04 08:16:05',1346099,1,NULL,NULL,NULL,'2025-12-04 08:14:02','2025-12-04 08:16:05','687bf5d5788e2fe0e'),('69314305c87316222','Submit Popup Reminders',0,'Success','2025-12-04 08:15:01',1089837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:15:05','2025-12-04 08:15:05',1346054,1,NULL,NULL,NULL,'2025-12-04 08:15:01','2025-12-04 08:15:05','687bf57d2f9463790'),('69314305f0b49c083','Process Job Queue q0',0,'Success','2025-12-04 08:15:01',1089838,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:15:06','2025-12-04 08:15:06',1346054,1,NULL,NULL,NULL,'2025-12-04 08:15:01','2025-12-04 08:15:06','687bf57d693e0fc1f'),('6931430622f402929','Process Job Queue q1',0,'Success','2025-12-04 08:16:00',1089839,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:05','2025-12-04 08:16:06',1346099,1,NULL,NULL,NULL,'2025-12-04 08:15:02','2025-12-04 08:16:06','687bf57d8afb5c472'),('693143063fb053703','Process Job Queue e0',0,'Success','2025-12-04 08:15:02',1089840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:15:07','2025-12-04 08:15:07',1346054,1,NULL,NULL,NULL,'2025-12-04 08:15:02','2025-12-04 08:15:07','687bf57dbba8299ef'),('69314306613657c95','Check for New Version',0,'Success','2025-12-05 08:15:00',1089841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 08:15:02','2025-12-05 08:15:03',1391654,1,NULL,NULL,NULL,'2025-12-04 08:15:02','2025-12-05 08:15:03','687bf57e39c3298cd'),('6931430700e1bfccd','Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewVersion',0,'Success','2025-12-05 07:21:00',1089842,'Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewVersion',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 07:21:02','2025-12-05 07:21:03',1390571,1,NULL,NULL,NULL,'2025-12-04 08:15:03','2025-12-05 07:21:03',NULL),('6931434187a68f5cc','Submit Popup Reminders',0,'Success','2025-12-04 08:16:01',1089843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:06','2025-12-04 08:16:07',1346099,1,NULL,NULL,NULL,'2025-12-04 08:16:01','2025-12-04 08:16:07','687bf57d2f9463790'),('69314341b6c80f8e7','Process Job Queue q0',0,'Success','2025-12-04 08:16:01',1089844,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:07','2025-12-04 08:16:07',1346099,1,NULL,NULL,NULL,'2025-12-04 08:16:01','2025-12-04 08:16:07','687bf57d693e0fc1f'),('69314341d53dffffd','Process Job Queue q1',0,'Success','2025-12-04 08:17:00',1089845,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:17:02','2025-12-04 08:17:02',1346139,1,NULL,NULL,NULL,'2025-12-04 08:16:01','2025-12-04 08:17:02','687bf57d8afb5c472'),('6931434200ea37269','Process Job Queue e0',0,'Success','2025-12-04 08:16:02',1089846,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:16:08','2025-12-04 08:16:08',1346099,1,NULL,NULL,NULL,'2025-12-04 08:16:02','2025-12-04 08:16:08','687bf57dbba8299ef'),('693143422483338c5','Send Email Reminders',0,'Success','2025-12-04 08:18:00',1089847,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:05','2025-12-04 08:18:05',1346179,1,NULL,NULL,NULL,'2025-12-04 08:16:02','2025-12-04 08:18:05','687bf5d44d3e10813'),('693143424d1cb26b9','Send Email Notifications',0,'Success','2025-12-04 08:18:00',1089848,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:06','2025-12-04 08:18:06',1346179,1,NULL,NULL,NULL,'2025-12-04 08:16:02','2025-12-04 08:18:06','687bf5d466067a4ba'),('69314342791f60b26','Process Webhook Queue',0,'Success','2025-12-04 08:18:00',1089849,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:06','2025-12-04 08:18:06',1346179,1,NULL,NULL,NULL,'2025-12-04 08:16:02','2025-12-04 08:18:06','687bf5d5788e2fe0e'),('6931437d7d34e519d','Submit Popup Reminders',0,'Success','2025-12-04 08:17:01',1089850,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:17:03','2025-12-04 08:17:04',1346139,1,NULL,NULL,NULL,'2025-12-04 08:17:01','2025-12-04 08:17:04','687bf57d2f9463790'),('6931437db805c83f1','Process Job Queue q0',0,'Success','2025-12-04 08:17:01',1089851,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:17:04','2025-12-04 08:17:04',1346139,1,NULL,NULL,NULL,'2025-12-04 08:17:01','2025-12-04 08:17:04','687bf57d693e0fc1f'),('6931437dd6953bf44','Process Job Queue q1',0,'Success','2025-12-04 08:18:00',1089852,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:07','2025-12-04 08:18:07',1346179,1,NULL,NULL,NULL,'2025-12-04 08:17:01','2025-12-04 08:18:07','687bf57d8afb5c472'),('6931437e063919cbb','Process Job Queue e0',0,'Success','2025-12-04 08:17:02',1089853,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:17:05','2025-12-04 08:17:05',1346139,1,NULL,NULL,NULL,'2025-12-04 08:17:02','2025-12-04 08:17:05','687bf57dbba8299ef'),('693143ba0bc51407f','Submit Popup Reminders',0,'Success','2025-12-04 08:18:02',1089854,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:07','2025-12-04 08:18:08',1346179,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:18:08','687bf57d2f9463790'),('693143ba3054f4a30','Process Job Queue q0',0,'Success','2025-12-04 08:18:02',1089855,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:08','2025-12-04 08:18:08',1346179,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:18:08','687bf57d693e0fc1f'),('693143ba52f5c16d1','Process Job Queue q1',0,'Success','2025-12-04 08:19:00',1089856,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:19:02','2025-12-04 08:19:03',1346218,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:19:03','687bf57d8afb5c472'),('693143ba70c1a80f0','Process Job Queue e0',0,'Success','2025-12-04 08:18:02',1089857,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:18:09','2025-12-04 08:18:09',1346179,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:18:09','687bf57dbba8299ef'),('693143baa4229a3cf','Send Email Reminders',0,'Success','2025-12-04 08:20:00',1089858,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:05','2025-12-04 08:20:05',1346257,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:20:05','687bf5d44d3e10813'),('693143bad157e2f4c','Send Email Notifications',0,'Success','2025-12-04 08:20:00',1089859,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:06','2025-12-04 08:20:06',1346257,1,NULL,NULL,NULL,'2025-12-04 08:18:02','2025-12-04 08:20:06','687bf5d466067a4ba'),('693143bb189344829','Auth Token Control',0,'Success','2025-12-04 08:24:00',1089860,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:03','2025-12-04 08:24:03',1346414,1,NULL,NULL,NULL,'2025-12-04 08:18:03','2025-12-04 08:24:03','687bf5d511e08c57f'),('693143bb6362ec451','Process Webhook Queue',0,'Success','2025-12-04 08:20:00',1089861,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:07','2025-12-04 08:20:07',1346257,1,NULL,NULL,NULL,'2025-12-04 08:18:03','2025-12-04 08:20:07','687bf5d5788e2fe0e'),('693143f5b81f79045','Submit Popup Reminders',0,'Success','2025-12-04 08:19:01',1089862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:19:03','2025-12-04 08:19:04',1346218,1,NULL,NULL,NULL,'2025-12-04 08:19:01','2025-12-04 08:19:04','687bf57d2f9463790'),('693143f5e7e495f5b','Process Job Queue q0',0,'Success','2025-12-04 08:19:01',1089863,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:19:04','2025-12-04 08:19:05',1346218,1,NULL,NULL,NULL,'2025-12-04 08:19:01','2025-12-04 08:19:05','687bf57d693e0fc1f'),('693143f624f1b12ec','Process Job Queue q1',0,'Success','2025-12-04 08:20:00',1089864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:07','2025-12-04 08:20:07',1346257,1,NULL,NULL,NULL,'2025-12-04 08:19:02','2025-12-04 08:20:07','687bf57d8afb5c472'),('693143f654e18a05a','Process Job Queue e0',0,'Success','2025-12-04 08:19:02',1089865,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:19:05','2025-12-04 08:19:05',1346218,1,NULL,NULL,NULL,'2025-12-04 08:19:02','2025-12-04 08:19:05','687bf57dbba8299ef'),('69314432251ff7c2b','Submit Popup Reminders',0,'Success','2025-12-04 08:20:02',1089866,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:08','2025-12-04 08:20:08',1346257,1,NULL,NULL,NULL,'2025-12-04 08:20:02','2025-12-04 08:20:08','687bf57d2f9463790'),('693144324e2fe1ee9','Process Job Queue q0',0,'Success','2025-12-04 08:20:02',1089867,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:09','2025-12-04 08:20:09',1346257,1,NULL,NULL,NULL,'2025-12-04 08:20:02','2025-12-04 08:20:09','687bf57d693e0fc1f'),('69314432707950b0e','Process Job Queue q1',0,'Success','2025-12-04 08:21:00',1089868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:21:02','2025-12-04 08:21:02',1346295,1,NULL,NULL,NULL,'2025-12-04 08:20:02','2025-12-04 08:21:02','687bf57d8afb5c472'),('6931443292957d75a','Process Job Queue e0',0,'Success','2025-12-04 08:20:02',1089869,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:20:09','2025-12-04 08:20:10',1346257,1,NULL,NULL,NULL,'2025-12-04 08:20:02','2025-12-04 08:20:10','687bf57dbba8299ef'),('69314432bca105b0e','Send Email Reminders',0,'Success','2025-12-04 08:22:00',1089870,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:04','2025-12-04 08:22:04',1346334,1,NULL,NULL,NULL,'2025-12-04 08:20:02','2025-12-04 08:22:04','687bf5d44d3e10813'),('69314433074685e6a','Send Email Notifications',0,'Success','2025-12-04 08:22:00',1089871,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:05','2025-12-04 08:22:05',1346334,1,NULL,NULL,NULL,'2025-12-04 08:20:03','2025-12-04 08:22:05','687bf5d466067a4ba'),('693144333e278b791','Process Webhook Queue',0,'Success','2025-12-04 08:22:00',1089872,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:05','2025-12-04 08:22:05',1346334,1,NULL,NULL,NULL,'2025-12-04 08:20:03','2025-12-04 08:22:05','687bf5d5788e2fe0e'),('69314433793ee6993','Send Scheduled Emails',0,'Success','2025-12-04 08:30:00',1089873,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:05','2025-12-04 08:30:05',1346647,1,NULL,NULL,NULL,'2025-12-04 08:20:03','2025-12-04 08:30:05','687bf5d5eeb01d80d'),('6931446d6a9c2b76f','Submit Popup Reminders',0,'Success','2025-12-04 08:21:01',1089874,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:21:03','2025-12-04 08:21:03',1346295,1,NULL,NULL,NULL,'2025-12-04 08:21:01','2025-12-04 08:21:03','687bf57d2f9463790'),('6931446da2fdca5e6','Process Job Queue q0',0,'Success','2025-12-04 08:21:01',1089875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:21:04','2025-12-04 08:21:04',1346295,1,NULL,NULL,NULL,'2025-12-04 08:21:01','2025-12-04 08:21:04','687bf57d693e0fc1f'),('6931446dcaf3dc036','Process Job Queue q1',0,'Success','2025-12-04 08:22:00',1089876,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:06','2025-12-04 08:22:06',1346334,1,NULL,NULL,NULL,'2025-12-04 08:21:01','2025-12-04 08:22:06','687bf57d8afb5c472'),('6931446debb43f63e','Process Job Queue e0',0,'Success','2025-12-04 08:21:01',1089877,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:21:05','2025-12-04 08:21:05',1346295,1,NULL,NULL,NULL,'2025-12-04 08:21:01','2025-12-04 08:21:05','687bf57dbba8299ef'),('693144aa21ed84ce0','Submit Popup Reminders',0,'Success','2025-12-04 08:22:02',1089878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:07','2025-12-04 08:22:07',1346334,1,NULL,NULL,NULL,'2025-12-04 08:22:02','2025-12-04 08:22:07','687bf57d2f9463790'),('693144aa55828b48f','Process Job Queue q0',0,'Success','2025-12-04 08:22:02',1089879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:07','2025-12-04 08:22:08',1346334,1,NULL,NULL,NULL,'2025-12-04 08:22:02','2025-12-04 08:22:08','687bf57d693e0fc1f'),('693144aa7e3798d1c','Process Job Queue q1',0,'Success','2025-12-04 08:23:00',1089880,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:23:02','2025-12-04 08:23:02',1346377,1,NULL,NULL,NULL,'2025-12-04 08:22:02','2025-12-04 08:23:02','687bf57d8afb5c472'),('693144aabc97a18a6','Process Job Queue e0',0,'Success','2025-12-04 08:22:02',1089881,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:22:08','2025-12-04 08:22:08',1346334,1,NULL,NULL,NULL,'2025-12-04 08:22:02','2025-12-04 08:22:08','687bf57dbba8299ef'),('693144ab023a70ff6','Send Email Reminders',0,'Success','2025-12-04 08:24:00',1089882,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:04','2025-12-04 08:24:04',1346414,1,NULL,NULL,NULL,'2025-12-04 08:22:03','2025-12-04 08:24:04','687bf5d44d3e10813'),('693144ab867d426a8','Send Email Notifications',0,'Success','2025-12-04 08:24:00',1089883,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:05','2025-12-04 08:24:05',1346414,1,NULL,NULL,NULL,'2025-12-04 08:22:03','2025-12-04 08:24:05','687bf5d466067a4ba'),('693144abd204f0879','Process Webhook Queue',0,'Success','2025-12-04 08:24:00',1089884,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:06','2025-12-04 08:24:06',1346414,1,NULL,NULL,NULL,'2025-12-04 08:22:03','2025-12-04 08:24:06','687bf5d5788e2fe0e'),('693144e5905b16bd8','Submit Popup Reminders',0,'Success','2025-12-04 08:23:01',1089885,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:23:03','2025-12-04 08:23:03',1346377,1,NULL,NULL,NULL,'2025-12-04 08:23:01','2025-12-04 08:23:03','687bf57d2f9463790'),('693144e5c076d6648','Process Job Queue q0',0,'Success','2025-12-04 08:23:01',1089886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:23:04','2025-12-04 08:23:04',1346377,1,NULL,NULL,NULL,'2025-12-04 08:23:01','2025-12-04 08:23:04','687bf57d693e0fc1f'),('693144e5daf0624aa','Process Job Queue q1',0,'Success','2025-12-04 08:24:00',1089887,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:07','2025-12-04 08:24:07',1346414,1,NULL,NULL,NULL,'2025-12-04 08:23:01','2025-12-04 08:24:07','687bf57d8afb5c472'),('693144e60cd3caa1d','Process Job Queue e0',0,'Success','2025-12-04 08:23:02',1089888,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:23:05','2025-12-04 08:23:05',1346377,1,NULL,NULL,NULL,'2025-12-04 08:23:02','2025-12-04 08:23:05','687bf57dbba8299ef'),('69314521a123f26b3','Submit Popup Reminders',0,'Success','2025-12-04 08:24:01',1089889,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:07','2025-12-04 08:24:08',1346414,1,NULL,NULL,NULL,'2025-12-04 08:24:01','2025-12-04 08:24:08','687bf57d2f9463790'),('69314521c43186254','Process Job Queue q0',0,'Success','2025-12-04 08:24:01',1089890,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:08','2025-12-04 08:24:08',1346414,1,NULL,NULL,NULL,'2025-12-04 08:24:01','2025-12-04 08:24:08','687bf57d693e0fc1f'),('69314521e2d5e6e00','Process Job Queue q1',0,'Success','2025-12-04 08:25:00',1089891,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:25:04','2025-12-04 08:25:05',1346457,1,NULL,NULL,NULL,'2025-12-04 08:24:01','2025-12-04 08:25:05','687bf57d8afb5c472'),('693145221591c4e27','Process Job Queue e0',0,'Success','2025-12-04 08:24:02',1089892,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:24:09','2025-12-04 08:24:09',1346414,1,NULL,NULL,NULL,'2025-12-04 08:24:02','2025-12-04 08:24:09','687bf57dbba8299ef'),('693145228da3bf379','Send Email Reminders',0,'Success','2025-12-04 08:26:00',1089893,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:03','2025-12-04 08:26:03',1346495,1,NULL,NULL,NULL,'2025-12-04 08:24:02','2025-12-04 08:26:03','687bf5d44d3e10813'),('69314522c5b174851','Send Email Notifications',0,'Success','2025-12-04 08:26:00',1089894,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:04','2025-12-04 08:26:05',1346495,1,NULL,NULL,NULL,'2025-12-04 08:24:02','2025-12-04 08:26:05','687bf5d466067a4ba'),('6931452307e14726a','Auth Token Control',0,'Success','2025-12-04 08:30:00',1089895,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:06','2025-12-04 08:30:06',1346647,1,NULL,NULL,NULL,'2025-12-04 08:24:03','2025-12-04 08:30:06','687bf5d511e08c57f'),('693145234015ce10b','Process Webhook Queue',0,'Success','2025-12-04 08:26:00',1089896,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:05','2025-12-04 08:26:06',1346495,1,NULL,NULL,NULL,'2025-12-04 08:24:03','2025-12-04 08:26:06','687bf5d5788e2fe0e'),('6931455e0613d9b56','Submit Popup Reminders',0,'Success','2025-12-04 08:25:02',1089897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:25:05','2025-12-04 08:25:06',1346457,1,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-04 08:25:06','687bf57d2f9463790'),('6931455e392a869b2','Process Job Queue q0',0,'Success','2025-12-04 08:25:02',1089898,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:25:06','2025-12-04 08:25:07',1346457,1,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-04 08:25:07','687bf57d693e0fc1f'),('6931455e5bf01e64b','Process Job Queue q1',0,'Success','2025-12-04 08:26:00',1089899,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:06','2025-12-04 08:26:06',1346495,1,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-04 08:26:06','687bf57d8afb5c472'),('6931455e7f4e42e61','Process Job Queue e0',0,'Success','2025-12-04 08:25:02',1089900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:25:08','2025-12-04 08:25:08',1346457,1,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-04 08:25:08','687bf57dbba8299ef'),('6931455ea29bb2ff7','Check for New Versions of Installed Extensions',0,'Success','2025-12-05 08:25:00',1089901,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 08:25:03','2025-12-05 08:25:04',1391814,1,NULL,NULL,NULL,'2025-12-04 08:25:02','2025-12-05 08:25:04','687bf57e4c0a76ca9'),('6931455f7c1fabb00','Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewExtensionVersion',0,'Success','2025-12-05 07:31:00',1089902,'Espo\\Tools\\AdminNotifications\\Jobs\\CheckNewExtensionVersion',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 07:31:02','2025-12-05 07:31:02',1390732,1,NULL,NULL,NULL,'2025-12-04 08:25:03','2025-12-05 07:31:02',NULL),('69314599cf2a59090','Submit Popup Reminders',0,'Success','2025-12-04 08:26:01',1089903,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:07','2025-12-04 08:26:07',1346495,1,NULL,NULL,NULL,'2025-12-04 08:26:01','2025-12-04 08:26:07','687bf57d2f9463790'),('6931459a05d4ba33e','Process Job Queue q0',0,'Success','2025-12-04 08:26:02',1089904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:08','2025-12-04 08:26:08',1346495,1,NULL,NULL,NULL,'2025-12-04 08:26:02','2025-12-04 08:26:08','687bf57d693e0fc1f'),('6931459a36d6e02ad','Process Job Queue q1',0,'Success','2025-12-04 08:27:00',1089905,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:27:02','2025-12-04 08:27:02',1346531,1,NULL,NULL,NULL,'2025-12-04 08:26:02','2025-12-04 08:27:02','687bf57d8afb5c472'),('6931459a56a06d235','Process Job Queue e0',0,'Success','2025-12-04 08:26:02',1089906,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:26:09','2025-12-04 08:26:09',1346495,1,NULL,NULL,NULL,'2025-12-04 08:26:02','2025-12-04 08:26:09','687bf57dbba8299ef'),('6931459a8363b8eab','Send Email Reminders',0,'Success','2025-12-04 08:28:00',1089907,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:28:03',1346569,1,NULL,NULL,NULL,'2025-12-04 08:26:02','2025-12-04 08:28:03','687bf5d44d3e10813'),('6931459ab8daf105f','Send Email Notifications',0,'Success','2025-12-04 08:28:00',1089908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:04','2025-12-04 08:28:04',1346569,1,NULL,NULL,NULL,'2025-12-04 08:26:02','2025-12-04 08:28:04','687bf5d466067a4ba'),('6931459b060ff6f36','Process Webhook Queue',0,'Success','2025-12-04 08:28:00',1089909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:05','2025-12-04 08:28:05',1346569,1,NULL,NULL,NULL,'2025-12-04 08:26:03','2025-12-04 08:28:05','687bf5d5788e2fe0e'),('693145d53dc612357','Submit Popup Reminders',0,'Success','2025-12-04 08:27:01',1089910,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:27:03','2025-12-04 08:27:03',1346531,1,NULL,NULL,NULL,'2025-12-04 08:27:01','2025-12-04 08:27:03','687bf57d2f9463790'),('693145d56708ee888','Process Job Queue q0',0,'Success','2025-12-04 08:27:01',1089911,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:27:04','2025-12-04 08:27:04',1346531,1,NULL,NULL,NULL,'2025-12-04 08:27:01','2025-12-04 08:27:04','687bf57d693e0fc1f'),('693145d5984181ec5','Process Job Queue q1',0,'Success','2025-12-04 08:28:00',1089912,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:06','2025-12-04 08:28:06',1346569,1,NULL,NULL,NULL,'2025-12-04 08:27:01','2025-12-04 08:28:06','687bf57d8afb5c472'),('693145d5c5f9f5eca','Process Job Queue e0',0,'Success','2025-12-04 08:27:01',1089913,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:27:05','2025-12-04 08:27:05',1346531,1,NULL,NULL,NULL,'2025-12-04 08:27:01','2025-12-04 08:27:05','687bf57dbba8299ef'),('69314611c8d69724b','Submit Popup Reminders',0,'Success','2025-12-04 08:28:01',1089914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:07','2025-12-04 08:28:07',1346569,1,NULL,NULL,NULL,'2025-12-04 08:28:01','2025-12-04 08:28:07','687bf57d2f9463790'),('6931461208f488881','Process Job Queue q0',0,'Success','2025-12-04 08:28:02',1089915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:08','2025-12-04 08:28:08',1346569,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:28:08','687bf57d693e0fc1f'),('693146122638250cb','Process Job Queue q1',0,'Success','2025-12-04 08:29:00',1089916,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:29:02','2025-12-04 08:29:02',1346607,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:29:02','687bf57d8afb5c472'),('6931461240e3247a2','Process Job Queue e0',0,'Success','2025-12-04 08:28:02',1089917,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:28:08','2025-12-04 08:28:09',1346569,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:28:09','687bf57dbba8299ef'),('69314612638402744','Send Email Reminders',0,'Success','2025-12-04 08:30:00',1089918,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:07','2025-12-04 08:30:07',1346647,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:30:07','687bf5d44d3e10813'),('693146127ef5dba6d','Send Email Notifications',0,'Success','2025-12-04 08:30:00',1089919,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:08','2025-12-04 08:30:08',1346647,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:30:08','687bf5d466067a4ba'),('69314612a6d7a0420','Process Webhook Queue',0,'Success','2025-12-04 08:30:00',1089920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:08','2025-12-04 08:30:09',1346647,1,NULL,NULL,NULL,'2025-12-04 08:28:02','2025-12-04 08:30:09','687bf5d5788e2fe0e'),('6931464d6b0f433d3','Submit Popup Reminders',0,'Success','2025-12-04 08:29:01',1089921,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:29:03','2025-12-04 08:29:03',1346607,1,NULL,NULL,NULL,'2025-12-04 08:29:01','2025-12-04 08:29:03','687bf57d2f9463790'),('6931464d8fa1566d5','Process Job Queue q0',0,'Success','2025-12-04 08:29:01',1089922,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:29:04','2025-12-04 08:29:04',1346607,1,NULL,NULL,NULL,'2025-12-04 08:29:01','2025-12-04 08:29:04','687bf57d693e0fc1f'),('6931464db04bfa503','Process Job Queue q1',0,'Success','2025-12-04 08:30:00',1089923,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:09','2025-12-04 08:30:09',1346647,1,NULL,NULL,NULL,'2025-12-04 08:29:01','2025-12-04 08:30:09','687bf57d8afb5c472'),('6931464dd5a70c042','Process Job Queue e0',0,'Success','2025-12-04 08:29:01',1089924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:29:05','2025-12-04 08:29:05',1346607,1,NULL,NULL,NULL,'2025-12-04 08:29:01','2025-12-04 08:29:05','687bf57dbba8299ef'),('69314689dcea51ebe','Submit Popup Reminders',0,'Success','2025-12-04 08:30:01',1089925,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:10','2025-12-04 08:30:10',1346647,1,NULL,NULL,NULL,'2025-12-04 08:30:01','2025-12-04 08:30:10','687bf57d2f9463790'),('6931468a15236b26b','Process Job Queue q0',0,'Success','2025-12-04 08:30:02',1089926,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:10','2025-12-04 08:30:11',1346647,1,NULL,NULL,NULL,'2025-12-04 08:30:02','2025-12-04 08:30:11','687bf57d693e0fc1f'),('6931468a3d7079300','Process Job Queue q1',0,'Success','2025-12-04 08:31:00',1089927,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:31:02','2025-12-04 08:31:03',1346688,1,NULL,NULL,NULL,'2025-12-04 08:30:02','2025-12-04 08:31:03','687bf57d8afb5c472'),('6931468a849893d4b','Process Job Queue e0',0,'Success','2025-12-04 08:30:02',1089928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:30:11','2025-12-04 08:30:11',1346647,1,NULL,NULL,NULL,'2025-12-04 08:30:02','2025-12-04 08:30:11','687bf57dbba8299ef'),('6931468aee0ce1df4','Send Email Reminders',0,'Success','2025-12-04 08:32:00',1089929,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:03','2025-12-04 08:32:03',1346725,1,NULL,NULL,NULL,'2025-12-04 08:30:02','2025-12-04 08:32:03','687bf5d44d3e10813'),('6931468b2bed178a3','Send Email Notifications',0,'Success','2025-12-04 08:32:00',1089930,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:04','2025-12-04 08:32:04',1346725,1,NULL,NULL,NULL,'2025-12-04 08:30:03','2025-12-04 08:32:04','687bf5d466067a4ba'),('6931468b8e65ff41b','Send Mass Emails',0,'Success','2025-12-04 08:50:00',1089931,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:04','2025-12-04 08:50:04',1347488,1,NULL,NULL,NULL,'2025-12-04 08:30:03','2025-12-04 08:50:04','687bf5d4b535f913f'),('6931468bdd4fa7958','Auth Token Control',0,'Success','2025-12-04 08:36:00',1089932,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:03','2025-12-04 08:36:03',1346884,1,NULL,NULL,NULL,'2025-12-04 08:30:03','2025-12-04 08:36:03','687bf5d511e08c57f'),('6931468c347eb8078','Process Webhook Queue',0,'Success','2025-12-04 08:32:00',1089933,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:05','2025-12-04 08:32:05',1346725,1,NULL,NULL,NULL,'2025-12-04 08:30:04','2025-12-04 08:32:05','687bf5d5788e2fe0e'),('6931468c8e7e55a38','Send Scheduled Emails',0,'Success','2025-12-04 08:40:00',1089934,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:03','2025-12-04 08:40:03',1347105,1,NULL,NULL,NULL,'2025-12-04 08:30:04','2025-12-04 08:40:03','687bf5d5eeb01d80d'),('693146c62e82d7efd','Submit Popup Reminders',0,'Success','2025-12-04 08:31:02',1089935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:31:04','2025-12-04 08:31:04',1346688,1,NULL,NULL,NULL,'2025-12-04 08:31:02','2025-12-04 08:31:04','687bf57d2f9463790'),('693146c651e42b945','Process Job Queue q0',0,'Success','2025-12-04 08:31:02',1089936,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:31:05','2025-12-04 08:31:05',1346688,1,NULL,NULL,NULL,'2025-12-04 08:31:02','2025-12-04 08:31:05','687bf57d693e0fc1f'),('693146c670b0327d3','Process Job Queue q1',0,'Success','2025-12-04 08:32:00',1089937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:06','2025-12-04 08:32:06',1346725,1,NULL,NULL,NULL,'2025-12-04 08:31:02','2025-12-04 08:32:06','687bf57d8afb5c472'),('693146c692626c360','Process Job Queue e0',0,'Success','2025-12-04 08:31:02',1089938,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:31:05','2025-12-04 08:31:06',1346688,1,NULL,NULL,NULL,'2025-12-04 08:31:02','2025-12-04 08:31:06','687bf57dbba8299ef'),('693147021d4b400e7','Submit Popup Reminders',0,'Success','2025-12-04 08:32:02',1089939,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:07','2025-12-04 08:32:07',1346725,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:32:07','687bf57d2f9463790'),('693147024b8725b46','Process Job Queue q0',0,'Success','2025-12-04 08:32:02',1089940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:08','2025-12-04 08:32:08',1346725,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:32:08','687bf57d693e0fc1f'),('69314702722f97cf9','Process Job Queue q1',0,'Success','2025-12-04 08:33:00',1089941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:33:02','2025-12-04 08:33:02',1346759,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:33:02','687bf57d8afb5c472'),('69314702981c70ea5','Process Job Queue e0',0,'Success','2025-12-04 08:32:02',1089942,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:32:08','2025-12-04 08:32:09',1346725,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:32:09','687bf57dbba8299ef'),('69314702c15d4e109','Send Email Reminders',0,'Success','2025-12-04 08:34:00',1089943,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:03','2025-12-04 08:34:03',1346797,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:34:03','687bf5d44d3e10813'),('69314702e42eb4c28','Send Email Notifications',0,'Success','2025-12-04 08:34:00',1089944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:04','2025-12-04 08:34:04',1346797,1,NULL,NULL,NULL,'2025-12-04 08:32:02','2025-12-04 08:34:04','687bf5d466067a4ba'),('693147032398d1b11','Process Webhook Queue',0,'Success','2025-12-04 08:34:00',1089945,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:04','2025-12-04 08:34:05',1346797,1,NULL,NULL,NULL,'2025-12-04 08:32:03','2025-12-04 08:34:05','687bf5d5788e2fe0e'),('6931473d5a1d6bc25','Submit Popup Reminders',0,'Success','2025-12-04 08:33:01',1089946,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:33:03','2025-12-04 08:33:03',1346759,1,NULL,NULL,NULL,'2025-12-04 08:33:01','2025-12-04 08:33:03','687bf57d2f9463790'),('6931473d7b4ebc0b8','Process Job Queue q0',0,'Success','2025-12-04 08:33:01',1089947,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:33:04','2025-12-04 08:33:04',1346759,1,NULL,NULL,NULL,'2025-12-04 08:33:01','2025-12-04 08:33:04','687bf57d693e0fc1f'),('6931473da43283928','Process Job Queue q1',0,'Success','2025-12-04 08:34:00',1089948,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:05','2025-12-04 08:34:05',1346797,1,NULL,NULL,NULL,'2025-12-04 08:33:01','2025-12-04 08:34:05','687bf57d8afb5c472'),('6931473dc6f05ee9e','Process Job Queue e0',0,'Success','2025-12-04 08:33:01',1089949,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:33:05','2025-12-04 08:33:05',1346759,1,NULL,NULL,NULL,'2025-12-04 08:33:01','2025-12-04 08:33:05','687bf57dbba8299ef'),('693147795a93871f6','Submit Popup Reminders',0,'Success','2025-12-04 08:34:01',1089950,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:06','2025-12-04 08:34:07',1346797,1,NULL,NULL,NULL,'2025-12-04 08:34:01','2025-12-04 08:34:07','687bf57d2f9463790'),('6931477989abf87af','Process Job Queue q0',0,'Success','2025-12-04 08:34:01',1089951,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:07','2025-12-04 08:34:07',1346797,1,NULL,NULL,NULL,'2025-12-04 08:34:01','2025-12-04 08:34:07','687bf57d693e0fc1f'),('69314779a8558ebab','Process Job Queue q1',0,'Success','2025-12-04 08:35:00',1089952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:35:02','2025-12-04 08:35:02',1346833,1,NULL,NULL,NULL,'2025-12-04 08:34:01','2025-12-04 08:35:02','687bf57d8afb5c472'),('69314779d245ca00e','Process Job Queue e0',0,'Success','2025-12-04 08:34:01',1089953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:34:08','2025-12-04 08:34:08',1346797,1,NULL,NULL,NULL,'2025-12-04 08:34:01','2025-12-04 08:34:08','687bf57dbba8299ef'),('6931477a2e03834d7','Send Email Reminders',0,'Success','2025-12-04 08:36:00',1089954,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:04','2025-12-04 08:36:05',1346884,1,NULL,NULL,NULL,'2025-12-04 08:34:02','2025-12-04 08:36:05','687bf5d44d3e10813'),('6931477a81ccc3e60','Send Email Notifications',0,'Success','2025-12-04 08:36:00',1089955,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:05','2025-12-04 08:36:05',1346884,1,NULL,NULL,NULL,'2025-12-04 08:34:02','2025-12-04 08:36:05','687bf5d466067a4ba'),('6931477b12e0f0231','Process Webhook Queue',0,'Success','2025-12-04 08:36:00',1089956,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:06','2025-12-04 08:36:06',1346884,1,NULL,NULL,NULL,'2025-12-04 08:34:03','2025-12-04 08:36:06','687bf5d5788e2fe0e'),('693147b55d62e3656','Submit Popup Reminders',0,'Success','2025-12-04 08:35:01',1089957,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:35:03','2025-12-04 08:35:03',1346833,1,NULL,NULL,NULL,'2025-12-04 08:35:01','2025-12-04 08:35:03','687bf57d2f9463790'),('693147b58871c6c7f','Process Job Queue q0',0,'Success','2025-12-04 08:35:01',1089958,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:35:04','2025-12-04 08:35:04',1346833,1,NULL,NULL,NULL,'2025-12-04 08:35:01','2025-12-04 08:35:04','687bf57d693e0fc1f'),('693147b5d4069e58d','Process Job Queue q1',0,'Success','2025-12-04 08:36:00',1089959,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:06','2025-12-04 08:36:07',1346884,1,NULL,NULL,NULL,'2025-12-04 08:35:01','2025-12-04 08:36:07','687bf57d8afb5c472'),('693147b605b122cfd','Process Job Queue e0',0,'Success','2025-12-04 08:35:02',1089960,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:35:05','2025-12-04 08:35:05',1346833,1,NULL,NULL,NULL,'2025-12-04 08:35:02','2025-12-04 08:35:05','687bf57dbba8299ef'),('693147f15a69f2339','Submit Popup Reminders',0,'Success','2025-12-04 08:36:01',1089961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:07','2025-12-04 08:36:07',1346884,1,NULL,NULL,NULL,'2025-12-04 08:36:01','2025-12-04 08:36:07','687bf57d2f9463790'),('693147f1a1a75bdca','Process Job Queue q0',0,'Success','2025-12-04 08:36:01',1089962,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:08','2025-12-04 08:36:08',1346884,1,NULL,NULL,NULL,'2025-12-04 08:36:01','2025-12-04 08:36:08','687bf57d693e0fc1f'),('693147f1e35ab5656','Process Job Queue q1',0,'Success','2025-12-04 08:37:00',1089963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:37:02','2025-12-04 08:37:02',1346923,1,NULL,NULL,NULL,'2025-12-04 08:36:01','2025-12-04 08:37:02','687bf57d8afb5c472'),('693147f231678e914','Process Job Queue e0',0,'Success','2025-12-04 08:36:02',1089964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:36:09','2025-12-04 08:36:09',1346884,1,NULL,NULL,NULL,'2025-12-04 08:36:02','2025-12-04 08:36:09','687bf57dbba8299ef'),('693147f288d7779cf','Send Email Reminders',0,'Success','2025-12-04 08:38:00',1089965,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:03','2025-12-04 08:38:03',1346964,1,NULL,NULL,NULL,'2025-12-04 08:36:02','2025-12-04 08:38:03','687bf5d44d3e10813'),('693147f2c6d78dd40','Send Email Notifications',0,'Success','2025-12-04 08:38:00',1089966,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:04','2025-12-04 08:38:04',1346964,1,NULL,NULL,NULL,'2025-12-04 08:36:02','2025-12-04 08:38:04','687bf5d466067a4ba'),('693147f304324fe50','Auth Token Control',0,'Success','2025-12-04 08:42:00',1089967,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:03','2025-12-04 08:42:04',1347184,1,NULL,NULL,NULL,'2025-12-04 08:36:03','2025-12-04 08:42:04','687bf5d511e08c57f'),('693147f338d930f7e','Process Webhook Queue',0,'Success','2025-12-04 08:38:00',1089968,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:05','2025-12-04 08:38:06',1346964,1,NULL,NULL,NULL,'2025-12-04 08:36:03','2025-12-04 08:38:06','687bf5d5788e2fe0e'),('6931482d86367d323','Submit Popup Reminders',0,'Success','2025-12-04 08:37:01',1089969,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:37:03','2025-12-04 08:37:03',1346923,1,NULL,NULL,NULL,'2025-12-04 08:37:01','2025-12-04 08:37:03','687bf57d2f9463790'),('6931482da430e66b6','Process Job Queue q0',0,'Success','2025-12-04 08:37:01',1089970,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:37:04','2025-12-04 08:37:04',1346923,1,NULL,NULL,NULL,'2025-12-04 08:37:01','2025-12-04 08:37:04','687bf57d693e0fc1f'),('6931482dc8530292c','Process Job Queue q1',0,'Success','2025-12-04 08:38:00',1089971,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:06','2025-12-04 08:38:06',1346964,1,NULL,NULL,NULL,'2025-12-04 08:37:01','2025-12-04 08:38:06','687bf57d8afb5c472'),('6931482de929b7275','Process Job Queue e0',0,'Success','2025-12-04 08:37:01',1089972,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:37:05','2025-12-04 08:37:05',1346923,1,NULL,NULL,NULL,'2025-12-04 08:37:01','2025-12-04 08:37:05','687bf57dbba8299ef'),('6931486a1b1576b9e','Submit Popup Reminders',0,'Success','2025-12-04 08:38:02',1089973,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:07','2025-12-04 08:38:07',1346964,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:38:07','687bf57d2f9463790'),('6931486a3e25e61ab','Process Job Queue q0',0,'Success','2025-12-04 08:38:02',1089974,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:08','2025-12-04 08:38:08',1346964,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:38:08','687bf57d693e0fc1f'),('6931486a62ca2e464','Process Job Queue q1',0,'Success','2025-12-04 08:39:00',1089975,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:39:02','2025-12-04 08:39:02',1347070,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:39:02','687bf57d8afb5c472'),('6931486a869cc8909','Process Job Queue e0',0,'Success','2025-12-04 08:38:02',1089976,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:38:08','2025-12-04 08:38:08',1346964,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:38:08','687bf57dbba8299ef'),('6931486ab5da3e5bd','Send Email Reminders',0,'Success','2025-12-04 08:40:00',1089977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:04','2025-12-04 08:40:04',1347105,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:40:04','687bf5d44d3e10813'),('6931486ae73daca9d','Send Email Notifications',0,'Success','2025-12-04 08:40:00',1089978,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:05','2025-12-04 08:40:05',1347105,1,NULL,NULL,NULL,'2025-12-04 08:38:02','2025-12-04 08:40:05','687bf5d466067a4ba'),('6931486b1bcecc805','Process Webhook Queue',0,'Success','2025-12-04 08:40:00',1089979,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:05','2025-12-04 08:40:05',1347105,1,NULL,NULL,NULL,'2025-12-04 08:38:03','2025-12-04 08:40:05','687bf5d5788e2fe0e'),('693148a56e1cc20f3','Submit Popup Reminders',0,'Success','2025-12-04 08:39:01',1089980,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:39:03','2025-12-04 08:39:03',1347070,1,NULL,NULL,NULL,'2025-12-04 08:39:01','2025-12-04 08:39:03','687bf57d2f9463790'),('693148a59a788a6de','Process Job Queue q0',0,'Success','2025-12-04 08:39:01',1089981,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:39:04','2025-12-04 08:39:04',1347070,1,NULL,NULL,NULL,'2025-12-04 08:39:01','2025-12-04 08:39:04','687bf57d693e0fc1f'),('693148a5c8109d985','Process Job Queue q1',0,'Success','2025-12-04 08:40:00',1089982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:06','2025-12-04 08:40:06',1347105,1,NULL,NULL,NULL,'2025-12-04 08:39:01','2025-12-04 08:40:06','687bf57d8afb5c472'),('693148a5ebdc1b9a5','Process Job Queue e0',0,'Success','2025-12-04 08:39:01',1089983,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:39:05','2025-12-04 08:39:05',1347070,1,NULL,NULL,NULL,'2025-12-04 08:39:01','2025-12-04 08:39:05','687bf57dbba8299ef'),('693148e16dbfd642a','Submit Popup Reminders',0,'Success','2025-12-04 08:40:01',1089984,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:07','2025-12-04 08:40:07',1347105,1,NULL,NULL,NULL,'2025-12-04 08:40:01','2025-12-04 08:40:07','687bf57d2f9463790'),('693148e1c6bca50e8','Process Job Queue q0',0,'Success','2025-12-04 08:40:01',1089985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:07','2025-12-04 08:40:08',1347105,1,NULL,NULL,NULL,'2025-12-04 08:40:01','2025-12-04 08:40:08','687bf57d693e0fc1f'),('693148e2198d21602','Process Job Queue q1',0,'Success','2025-12-04 08:41:00',1089986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:41:02','2025-12-04 08:41:03',1347142,1,NULL,NULL,NULL,'2025-12-04 08:40:02','2025-12-04 08:41:03','687bf57d8afb5c472'),('693148e270613828b','Process Job Queue e0',0,'Success','2025-12-04 08:40:02',1089987,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:40:08','2025-12-04 08:40:08',1347105,1,NULL,NULL,NULL,'2025-12-04 08:40:02','2025-12-04 08:40:08','687bf57dbba8299ef'),('693148e29f8137e80','Send Email Reminders',0,'Success','2025-12-04 08:42:00',1089988,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:04','2025-12-04 08:42:05',1347184,1,NULL,NULL,NULL,'2025-12-04 08:40:02','2025-12-04 08:42:05','687bf5d44d3e10813'),('693148e301977e8c8','Send Email Notifications',0,'Success','2025-12-04 08:42:00',1089989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:05','2025-12-04 08:42:05',1347184,1,NULL,NULL,NULL,'2025-12-04 08:40:03','2025-12-04 08:42:05','687bf5d466067a4ba'),('693148e32f4e1f8ce','Process Webhook Queue',0,'Success','2025-12-04 08:42:00',1089990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:06','2025-12-04 08:42:06',1347184,1,NULL,NULL,NULL,'2025-12-04 08:40:03','2025-12-04 08:42:06','687bf5d5788e2fe0e'),('693148e34f47eca13','Send Scheduled Emails',0,'Success','2025-12-04 08:50:00',1089991,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:05','2025-12-04 08:50:05',1347488,1,NULL,NULL,NULL,'2025-12-04 08:40:03','2025-12-04 08:50:05','687bf5d5eeb01d80d'),('6931491e1c39ca4ea','Submit Popup Reminders',0,'Success','2025-12-04 08:41:02',1089992,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:41:04','2025-12-04 08:41:04',1347142,1,NULL,NULL,NULL,'2025-12-04 08:41:02','2025-12-04 08:41:04','687bf57d2f9463790'),('6931491e4620505c4','Process Job Queue q0',0,'Success','2025-12-04 08:41:02',1089993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:41:05','2025-12-04 08:41:05',1347142,1,NULL,NULL,NULL,'2025-12-04 08:41:02','2025-12-04 08:41:05','687bf57d693e0fc1f'),('6931491e69a66bb2b','Process Job Queue q1',0,'Success','2025-12-04 08:42:00',1089994,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:07','2025-12-04 08:42:07',1347184,1,NULL,NULL,NULL,'2025-12-04 08:41:02','2025-12-04 08:42:07','687bf57d8afb5c472'),('6931491eb37d7ef32','Process Job Queue e0',0,'Success','2025-12-04 08:41:02',1089995,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:41:05','2025-12-04 08:41:06',1347142,1,NULL,NULL,NULL,'2025-12-04 08:41:02','2025-12-04 08:41:06','687bf57dbba8299ef'),('69314959a804b5c26','Submit Popup Reminders',0,'Success','2025-12-04 08:42:01',1089996,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:07','2025-12-04 08:42:08',1347184,1,NULL,NULL,NULL,'2025-12-04 08:42:01','2025-12-04 08:42:08','687bf57d2f9463790'),('69314959d607d21c2','Process Job Queue q0',0,'Success','2025-12-04 08:42:01',1089997,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:08','2025-12-04 08:42:08',1347184,1,NULL,NULL,NULL,'2025-12-04 08:42:01','2025-12-04 08:42:08','687bf57d693e0fc1f'),('6931495a0a458bdf8','Process Job Queue q1',0,'Success','2025-12-04 08:43:00',1089998,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:43:02','2025-12-04 08:43:03',1347225,1,NULL,NULL,NULL,'2025-12-04 08:42:02','2025-12-04 08:43:03','687bf57d8afb5c472'),('6931495a30817066b','Process Job Queue e0',0,'Success','2025-12-04 08:42:02',1089999,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:42:09','2025-12-04 08:42:09',1347184,1,NULL,NULL,NULL,'2025-12-04 08:42:02','2025-12-04 08:42:09','687bf57dbba8299ef'),('6931495a63bd90183','Send Email Reminders',0,'Success','2025-12-04 08:44:00',1090000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:02','2025-12-04 08:44:03',1347261,1,NULL,NULL,NULL,'2025-12-04 08:42:02','2025-12-04 08:44:03','687bf5d44d3e10813'),('6931495a98a3c49e3','Send Email Notifications',0,'Success','2025-12-04 08:44:00',1090001,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:03','2025-12-04 08:44:04',1347261,1,NULL,NULL,NULL,'2025-12-04 08:42:02','2025-12-04 08:44:04','687bf5d466067a4ba'),('6931495b449511c44','Auth Token Control',0,'Success','2025-12-04 08:48:00',1090002,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:03','2025-12-04 08:48:03',1347412,1,NULL,NULL,NULL,'2025-12-04 08:42:03','2025-12-04 08:48:03','687bf5d511e08c57f'),('6931495b85b00e7e2','Process Webhook Queue',0,'Success','2025-12-04 08:44:00',1090003,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:04','2025-12-04 08:44:05',1347261,1,NULL,NULL,NULL,'2025-12-04 08:42:03','2025-12-04 08:44:05','687bf5d5788e2fe0e'),('69314995be1727f38','Submit Popup Reminders',0,'Success','2025-12-04 08:43:01',1090004,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:43:03','2025-12-04 08:43:04',1347225,1,NULL,NULL,NULL,'2025-12-04 08:43:01','2025-12-04 08:43:04','687bf57d2f9463790'),('69314995eafdff7d5','Process Job Queue q0',0,'Success','2025-12-04 08:43:01',1090005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:43:04','2025-12-04 08:43:04',1347225,1,NULL,NULL,NULL,'2025-12-04 08:43:01','2025-12-04 08:43:04','687bf57d693e0fc1f'),('693149964900086e5','Process Job Queue q1',0,'Success','2025-12-04 08:44:00',1090006,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:05','2025-12-04 08:44:06',1347261,1,NULL,NULL,NULL,'2025-12-04 08:43:02','2025-12-04 08:44:06','687bf57d8afb5c472'),('69314996937917755','Process Job Queue e0',0,'Success','2025-12-04 08:43:02',1090007,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:43:05','2025-12-04 08:43:05',1347225,1,NULL,NULL,NULL,'2025-12-04 08:43:02','2025-12-04 08:43:05','687bf57dbba8299ef'),('693149d16f05c1f42','Submit Popup Reminders',0,'Success','2025-12-04 08:44:01',1090008,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:06','2025-12-04 08:44:07',1347261,1,NULL,NULL,NULL,'2025-12-04 08:44:01','2025-12-04 08:44:07','687bf57d2f9463790'),('693149d19ccdb6652','Process Job Queue q0',0,'Success','2025-12-04 08:44:01',1090009,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:07','2025-12-04 08:44:07',1347261,1,NULL,NULL,NULL,'2025-12-04 08:44:01','2025-12-04 08:44:07','687bf57d693e0fc1f'),('693149d1c194be382','Process Job Queue q1',0,'Success','2025-12-04 08:45:00',1090010,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:45:02','2025-12-04 08:45:02',1347298,1,NULL,NULL,NULL,'2025-12-04 08:44:01','2025-12-04 08:45:02','687bf57d8afb5c472'),('693149d1e358f93b1','Process Job Queue e0',0,'Success','2025-12-04 08:44:01',1090011,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:44:08','2025-12-04 08:44:08',1347261,1,NULL,NULL,NULL,'2025-12-04 08:44:01','2025-12-04 08:44:08','687bf57dbba8299ef'),('693149d21abdd1b78','Send Email Reminders',0,'Success','2025-12-04 08:46:00',1090012,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:03','2025-12-04 08:46:03',1347337,1,NULL,NULL,NULL,'2025-12-04 08:44:02','2025-12-04 08:46:03','687bf5d44d3e10813'),('693149d2373a131c9','Send Email Notifications',0,'Success','2025-12-04 08:46:00',1090013,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:03','2025-12-04 08:46:04',1347337,1,NULL,NULL,NULL,'2025-12-04 08:44:02','2025-12-04 08:46:04','687bf5d466067a4ba'),('693149d264c8720ff','Process Webhook Queue',0,'Success','2025-12-04 08:46:00',1090014,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:04','2025-12-04 08:46:04',1347337,1,NULL,NULL,NULL,'2025-12-04 08:44:02','2025-12-04 08:46:04','687bf5d5788e2fe0e'),('69314a0d977ff42b4','Submit Popup Reminders',0,'Success','2025-12-04 08:45:01',1090015,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:45:03','2025-12-04 08:45:03',1347298,1,NULL,NULL,NULL,'2025-12-04 08:45:01','2025-12-04 08:45:03','687bf57d2f9463790'),('69314a0dbce01f2dd','Process Job Queue q0',0,'Success','2025-12-04 08:45:01',1090016,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:45:04','2025-12-04 08:45:04',1347298,1,NULL,NULL,NULL,'2025-12-04 08:45:01','2025-12-04 08:45:04','687bf57d693e0fc1f'),('69314a0dd99d1db50','Process Job Queue q1',0,'Success','2025-12-04 08:46:00',1090017,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:05','2025-12-04 08:46:05',1347337,1,NULL,NULL,NULL,'2025-12-04 08:45:01','2025-12-04 08:46:05','687bf57d8afb5c472'),('69314a0e09ba8ddf9','Process Job Queue e0',0,'Success','2025-12-04 08:45:02',1090018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:45:05','2025-12-04 08:45:05',1347298,1,NULL,NULL,NULL,'2025-12-04 08:45:02','2025-12-04 08:45:05','687bf57dbba8299ef'),('69314a492f797080b','Submit Popup Reminders',0,'Success','2025-12-04 08:46:01',1090019,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:05','2025-12-04 08:46:06',1347337,1,NULL,NULL,NULL,'2025-12-04 08:46:01','2025-12-04 08:46:06','687bf57d2f9463790'),('69314a4959f2c85f4','Process Job Queue q0',0,'Success','2025-12-04 08:46:01',1090020,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:06','2025-12-04 08:46:06',1347337,1,NULL,NULL,NULL,'2025-12-04 08:46:01','2025-12-04 08:46:06','687bf57d693e0fc1f'),('69314a49804fbaf95','Process Job Queue q1',0,'Success','2025-12-04 08:47:00',1090021,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:47:02','2025-12-04 08:47:02',1347375,1,NULL,NULL,NULL,'2025-12-04 08:46:01','2025-12-04 08:47:02','687bf57d8afb5c472'),('69314a4a18a20d17e','Process Job Queue e0',0,'Success','2025-12-04 08:46:02',1090022,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:46:07','2025-12-04 08:46:07',1347337,1,NULL,NULL,NULL,'2025-12-04 08:46:02','2025-12-04 08:46:07','687bf57dbba8299ef'),('69314a4a4efe58bc5','Send Email Reminders',0,'Success','2025-12-04 08:48:00',1090023,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:04','2025-12-04 08:48:04',1347412,1,NULL,NULL,NULL,'2025-12-04 08:46:02','2025-12-04 08:48:04','687bf5d44d3e10813'),('69314a4a93b5831ab','Send Email Notifications',0,'Success','2025-12-04 08:48:00',1090024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:05','2025-12-04 08:48:05',1347412,1,NULL,NULL,NULL,'2025-12-04 08:46:02','2025-12-04 08:48:05','687bf5d466067a4ba'),('69314a4adda72972f','Process Webhook Queue',0,'Success','2025-12-04 08:48:00',1090025,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:06','2025-12-04 08:48:06',1347412,1,NULL,NULL,NULL,'2025-12-04 08:46:02','2025-12-04 08:48:06','687bf5d5788e2fe0e'),('69314a85c71e1d22b','Submit Popup Reminders',0,'Success','2025-12-04 08:47:01',1090026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:47:03','2025-12-04 08:47:04',1347375,1,NULL,NULL,NULL,'2025-12-04 08:47:01','2025-12-04 08:47:04','687bf57d2f9463790'),('69314a85e95967c04','Process Job Queue q0',0,'Success','2025-12-04 08:47:01',1090027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:47:04','2025-12-04 08:47:05',1347375,1,NULL,NULL,NULL,'2025-12-04 08:47:01','2025-12-04 08:47:05','687bf57d693e0fc1f'),('69314a861a27aa675','Process Job Queue q1',0,'Success','2025-12-04 08:48:00',1090028,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:06','2025-12-04 08:48:06',1347412,1,NULL,NULL,NULL,'2025-12-04 08:47:02','2025-12-04 08:48:06','687bf57d8afb5c472'),('69314a864823af717','Process Job Queue e0',0,'Success','2025-12-04 08:47:02',1090029,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:47:05','2025-12-04 08:47:06',1347375,1,NULL,NULL,NULL,'2025-12-04 08:47:02','2025-12-04 08:47:06','687bf57dbba8299ef'),('69314ac1992751124','Submit Popup Reminders',0,'Success','2025-12-04 08:48:01',1090030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:07','2025-12-04 08:48:07',1347412,1,NULL,NULL,NULL,'2025-12-04 08:48:01','2025-12-04 08:48:07','687bf57d2f9463790'),('69314ac1c2550747a','Process Job Queue q0',0,'Success','2025-12-04 08:48:01',1090031,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:08','2025-12-04 08:48:08',1347412,1,NULL,NULL,NULL,'2025-12-04 08:48:01','2025-12-04 08:48:08','687bf57d693e0fc1f'),('69314ac1ed4958341','Process Job Queue q1',0,'Success','2025-12-04 08:49:00',1090032,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:49:02','2025-12-04 08:49:02',1347450,1,NULL,NULL,NULL,'2025-12-04 08:48:01','2025-12-04 08:49:02','687bf57d8afb5c472'),('69314ac21b65b4e07','Process Job Queue e0',0,'Success','2025-12-04 08:48:02',1090033,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:48:09','2025-12-04 08:48:09',1347412,1,NULL,NULL,NULL,'2025-12-04 08:48:02','2025-12-04 08:48:09','687bf57dbba8299ef'),('69314ac242dd2ddf9','Send Email Reminders',0,'Success','2025-12-04 08:50:00',1090034,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:06','2025-12-04 08:50:06',1347488,1,NULL,NULL,NULL,'2025-12-04 08:48:02','2025-12-04 08:50:06','687bf5d44d3e10813'),('69314ac261cf2f8e6','Send Email Notifications',0,'Success','2025-12-04 08:50:00',1090035,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:07','2025-12-04 08:50:07',1347488,1,NULL,NULL,NULL,'2025-12-04 08:48:02','2025-12-04 08:50:07','687bf5d466067a4ba'),('69314ac2be29319e7','Auth Token Control',0,'Success','2025-12-04 08:54:00',1090036,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:02','2025-12-04 08:54:03',1347639,1,NULL,NULL,NULL,'2025-12-04 08:48:02','2025-12-04 08:54:03','687bf5d511e08c57f'),('69314ac313784e702','Process Webhook Queue',0,'Success','2025-12-04 08:50:00',1090037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:07','2025-12-04 08:50:08',1347488,1,NULL,NULL,NULL,'2025-12-04 08:48:03','2025-12-04 08:50:08','687bf5d5788e2fe0e'),('69314afdeaa025783','Submit Popup Reminders',0,'Success','2025-12-04 08:49:01',1090038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:49:04','2025-12-04 08:49:04',1347450,1,NULL,NULL,NULL,'2025-12-04 08:49:01','2025-12-04 08:49:04','687bf57d2f9463790'),('69314afe2d57c5be2','Process Job Queue q0',0,'Success','2025-12-04 08:49:02',1090039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:49:05','2025-12-04 08:49:05',1347450,1,NULL,NULL,NULL,'2025-12-04 08:49:02','2025-12-04 08:49:05','687bf57d693e0fc1f'),('69314afe4b53c6837','Process Job Queue q1',0,'Success','2025-12-04 08:50:00',1090040,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:08','2025-12-04 08:50:08',1347488,1,NULL,NULL,NULL,'2025-12-04 08:49:02','2025-12-04 08:50:08','687bf57d8afb5c472'),('69314afe65f67b68e','Process Job Queue e0',0,'Success','2025-12-04 08:49:02',1090041,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:49:06','2025-12-04 08:49:06',1347450,1,NULL,NULL,NULL,'2025-12-04 08:49:02','2025-12-04 08:49:06','687bf57dbba8299ef'),('69314b3a0719efa8e','Submit Popup Reminders',0,'Success','2025-12-04 08:50:02',1090042,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:09','2025-12-04 08:50:09',1347488,1,NULL,NULL,NULL,'2025-12-04 08:50:02','2025-12-04 08:50:09','687bf57d2f9463790'),('69314b3a38bb05fa5','Process Job Queue q0',0,'Success','2025-12-04 08:50:02',1090043,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:09','2025-12-04 08:50:10',1347488,1,NULL,NULL,NULL,'2025-12-04 08:50:02','2025-12-04 08:50:10','687bf57d693e0fc1f'),('69314b3a64072b7bb','Process Job Queue q1',0,'Success','2025-12-04 08:51:00',1090044,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:51:02','2025-12-04 08:51:02',1347525,1,NULL,NULL,NULL,'2025-12-04 08:50:02','2025-12-04 08:51:02','687bf57d8afb5c472'),('69314b3aaea179335','Process Job Queue e0',0,'Success','2025-12-04 08:50:02',1090045,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:50:10','2025-12-04 08:50:11',1347488,1,NULL,NULL,NULL,'2025-12-04 08:50:02','2025-12-04 08:50:11','687bf57dbba8299ef'),('69314b3b0e65e63b9','Send Email Reminders',0,'Success','2025-12-04 08:52:00',1090046,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:03','2025-12-04 08:52:03',1347564,1,NULL,NULL,NULL,'2025-12-04 08:50:03','2025-12-04 08:52:03','687bf5d44d3e10813'),('69314b3b66e9716c9','Send Email Notifications',0,'Success','2025-12-04 08:52:00',1090047,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:04','2025-12-04 08:52:04',1347564,1,NULL,NULL,NULL,'2025-12-04 08:50:03','2025-12-04 08:52:04','687bf5d466067a4ba'),('69314b3bb09c24a59','Send Mass Emails',0,'Success','2025-12-04 09:10:00',1090048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:04','2025-12-04 09:10:04',1348275,1,NULL,NULL,NULL,'2025-12-04 08:50:03','2025-12-04 09:10:04','687bf5d4b535f913f'),('69314b3c080b4d996','Process Webhook Queue',0,'Success','2025-12-04 08:52:00',1090049,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:05','2025-12-04 08:52:05',1347564,1,NULL,NULL,NULL,'2025-12-04 08:50:04','2025-12-04 08:52:05','687bf5d5788e2fe0e'),('69314b3c5210ba352','Send Scheduled Emails',0,'Success','2025-12-04 09:00:00',1090050,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:04','2025-12-04 09:00:04',1347876,1,NULL,NULL,NULL,'2025-12-04 08:50:04','2025-12-04 09:00:04','687bf5d5eeb01d80d'),('69314b759c8644da5','Submit Popup Reminders',0,'Success','2025-12-04 08:51:01',1090051,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:51:03','2025-12-04 08:51:03',1347525,1,NULL,NULL,NULL,'2025-12-04 08:51:01','2025-12-04 08:51:03','687bf57d2f9463790'),('69314b75cb0efc6f8','Process Job Queue q0',0,'Success','2025-12-04 08:51:01',1090052,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:51:04','2025-12-04 08:51:04',1347525,1,NULL,NULL,NULL,'2025-12-04 08:51:01','2025-12-04 08:51:04','687bf57d693e0fc1f'),('69314b75f3ed27d5b','Process Job Queue q1',0,'Success','2025-12-04 08:52:00',1090053,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:05','2025-12-04 08:52:06',1347564,1,NULL,NULL,NULL,'2025-12-04 08:51:01','2025-12-04 08:52:06','687bf57d8afb5c472'),('69314b7629c12cf2a','Process Job Queue e0',0,'Success','2025-12-04 08:51:02',1090054,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:51:05','2025-12-04 08:51:05',1347525,1,NULL,NULL,NULL,'2025-12-04 08:51:02','2025-12-04 08:51:05','687bf57dbba8299ef'),('69314bb1a8c61db67','Submit Popup Reminders',0,'Success','2025-12-04 08:52:01',1090055,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:06','2025-12-04 08:52:06',1347564,1,NULL,NULL,NULL,'2025-12-04 08:52:01','2025-12-04 08:52:06','687bf57d2f9463790'),('69314bb1da3793381','Process Job Queue q0',0,'Success','2025-12-04 08:52:01',1090056,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:07','2025-12-04 08:52:07',1347564,1,NULL,NULL,NULL,'2025-12-04 08:52:01','2025-12-04 08:52:07','687bf57d693e0fc1f'),('69314bb208c7f8294','Process Job Queue q1',0,'Success','2025-12-04 08:53:00',1090057,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:53:02','2025-12-04 08:53:03',1347599,1,NULL,NULL,NULL,'2025-12-04 08:52:02','2025-12-04 08:53:03','687bf57d8afb5c472'),('69314bb22883a38a2','Process Job Queue e0',0,'Success','2025-12-04 08:52:02',1090058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:52:08','2025-12-04 08:52:08',1347564,1,NULL,NULL,NULL,'2025-12-04 08:52:02','2025-12-04 08:52:08','687bf57dbba8299ef'),('69314bb2568582dce','Send Email Reminders',0,'Success','2025-12-04 08:54:00',1090059,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:04','2025-12-04 08:54:04',1347639,1,NULL,NULL,NULL,'2025-12-04 08:52:02','2025-12-04 08:54:04','687bf5d44d3e10813'),('69314bb29b828f007','Send Email Notifications',0,'Success','2025-12-04 08:54:00',1090060,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:05','2025-12-04 08:54:05',1347639,1,NULL,NULL,NULL,'2025-12-04 08:52:02','2025-12-04 08:54:05','687bf5d466067a4ba'),('69314bb2cf1bb24a5','Process Webhook Queue',0,'Success','2025-12-04 08:54:00',1090061,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:05','2025-12-04 08:54:05',1347639,1,NULL,NULL,NULL,'2025-12-04 08:52:02','2025-12-04 08:54:05','687bf5d5788e2fe0e'),('69314bede4f92488a','Submit Popup Reminders',0,'Success','2025-12-04 08:53:01',1090062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:53:03','2025-12-04 08:53:04',1347599,1,NULL,NULL,NULL,'2025-12-04 08:53:01','2025-12-04 08:53:04','687bf57d2f9463790'),('69314bee1c0633529','Process Job Queue q0',0,'Success','2025-12-04 08:53:02',1090063,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:53:04','2025-12-04 08:53:05',1347599,1,NULL,NULL,NULL,'2025-12-04 08:53:02','2025-12-04 08:53:05','687bf57d693e0fc1f'),('69314bee525a7502b','Process Job Queue q1',0,'Success','2025-12-04 08:54:00',1090064,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:06','2025-12-04 08:54:06',1347639,1,NULL,NULL,NULL,'2025-12-04 08:53:02','2025-12-04 08:54:06','687bf57d8afb5c472'),('69314bee811055322','Process Job Queue e0',0,'Success','2025-12-04 08:53:02',1090065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:53:05','2025-12-04 08:53:05',1347599,1,NULL,NULL,NULL,'2025-12-04 08:53:02','2025-12-04 08:53:05','687bf57dbba8299ef'),('69314c2937039aaf8','Submit Popup Reminders',0,'Success','2025-12-04 08:54:01',1090066,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:07','2025-12-04 08:54:07',1347639,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:54:07','687bf57d2f9463790'),('69314c29623bc5237','Process Job Queue q0',0,'Success','2025-12-04 08:54:01',1090067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:07','2025-12-04 08:54:08',1347639,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:54:08','687bf57d693e0fc1f'),('69314c29835882122','Process Job Queue q1',0,'Success','2025-12-04 08:55:00',1090068,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:55:02','2025-12-04 08:55:03',1347678,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:55:03','687bf57d8afb5c472'),('69314c29a4af191fe','Process Job Queue e0',0,'Success','2025-12-04 08:54:01',1090069,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:54:08','2025-12-04 08:54:08',1347639,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:54:08','687bf57dbba8299ef'),('69314c29c5d7c2f81','Send Email Reminders',0,'Success','2025-12-04 08:56:00',1090070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:03','2025-12-04 08:56:03',1347716,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:56:03','687bf5d44d3e10813'),('69314c29e8e0db0ef','Send Email Notifications',0,'Success','2025-12-04 08:56:00',1090071,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:04','2025-12-04 08:56:04',1347716,1,NULL,NULL,NULL,'2025-12-04 08:54:01','2025-12-04 08:56:04','687bf5d466067a4ba'),('69314c2a2d246a5c4','Auth Token Control',0,'Success','2025-12-04 09:00:00',1090072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:05','2025-12-04 09:00:05',1347876,1,NULL,NULL,NULL,'2025-12-04 08:54:02','2025-12-04 09:00:05','687bf5d511e08c57f'),('69314c2a58ccb8c7f','Process Webhook Queue',0,'Success','2025-12-04 08:56:00',1090073,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:05','2025-12-04 08:56:05',1347716,1,NULL,NULL,NULL,'2025-12-04 08:54:02','2025-12-04 08:56:05','687bf5d5788e2fe0e'),('69314c65d5855cc31','Submit Popup Reminders',0,'Success','2025-12-04 08:55:01',1090074,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:55:04','2025-12-04 08:55:04',1347678,1,NULL,NULL,NULL,'2025-12-04 08:55:01','2025-12-04 08:55:04','687bf57d2f9463790'),('69314c65f1b2a7c43','Process Job Queue q0',0,'Success','2025-12-04 08:55:01',1090075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:55:04','2025-12-04 08:55:05',1347678,1,NULL,NULL,NULL,'2025-12-04 08:55:01','2025-12-04 08:55:05','687bf57d693e0fc1f'),('69314c663f2a744d6','Process Job Queue q1',0,'Success','2025-12-04 08:56:00',1090076,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:05','2025-12-04 08:56:06',1347716,1,NULL,NULL,NULL,'2025-12-04 08:55:02','2025-12-04 08:56:06','687bf57d8afb5c472'),('69314c668455afa2f','Process Job Queue e0',0,'Success','2025-12-04 08:55:02',1090077,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:55:05','2025-12-04 08:55:05',1347678,1,NULL,NULL,NULL,'2025-12-04 08:55:02','2025-12-04 08:55:05','687bf57dbba8299ef'),('69314ca1ab71aa89b','Submit Popup Reminders',0,'Success','2025-12-04 08:56:01',1090078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:06','2025-12-04 08:56:06',1347716,1,NULL,NULL,NULL,'2025-12-04 08:56:01','2025-12-04 08:56:06','687bf57d2f9463790'),('69314ca1cf0a9ccac','Process Job Queue q0',0,'Success','2025-12-04 08:56:01',1090079,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:07','2025-12-04 08:56:07',1347716,1,NULL,NULL,NULL,'2025-12-04 08:56:01','2025-12-04 08:56:07','687bf57d693e0fc1f'),('69314ca1f24faf84c','Process Job Queue q1',0,'Success','2025-12-04 08:57:00',1090080,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:57:02','2025-12-04 08:57:02',1347763,1,NULL,NULL,NULL,'2025-12-04 08:56:01','2025-12-04 08:57:02','687bf57d8afb5c472'),('69314ca22605c512d','Process Job Queue e0',0,'Success','2025-12-04 08:56:02',1090081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:56:08','2025-12-04 08:56:08',1347716,1,NULL,NULL,NULL,'2025-12-04 08:56:02','2025-12-04 08:56:08','687bf57dbba8299ef'),('69314ca278feee756','Send Email Reminders',0,'Success','2025-12-04 08:58:00',1090082,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 08:58:03',1347799,1,NULL,NULL,NULL,'2025-12-04 08:56:02','2025-12-04 08:58:03','687bf5d44d3e10813'),('69314ca2d1ea7de11','Send Email Notifications',0,'Success','2025-12-04 08:58:00',1090083,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:03','2025-12-04 08:58:04',1347799,1,NULL,NULL,NULL,'2025-12-04 08:56:02','2025-12-04 08:58:04','687bf5d466067a4ba'),('69314ca31fd07bbf7','Process Webhook Queue',0,'Success','2025-12-04 08:58:00',1090084,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:04','2025-12-04 08:58:05',1347799,1,NULL,NULL,NULL,'2025-12-04 08:56:03','2025-12-04 08:58:05','687bf5d5788e2fe0e'),('69314cdd61f7de262','Submit Popup Reminders',0,'Success','2025-12-04 08:57:01',1090085,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:57:03','2025-12-04 08:57:03',1347763,1,NULL,NULL,NULL,'2025-12-04 08:57:01','2025-12-04 08:57:03','687bf57d2f9463790'),('69314cdd84f0c1d2f','Process Job Queue q0',0,'Success','2025-12-04 08:57:01',1090086,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:57:04','2025-12-04 08:57:04',1347763,1,NULL,NULL,NULL,'2025-12-04 08:57:01','2025-12-04 08:57:04','687bf57d693e0fc1f'),('69314cdda3a1ab15b','Process Job Queue q1',0,'Success','2025-12-04 08:58:00',1090087,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:05','2025-12-04 08:58:06',1347799,1,NULL,NULL,NULL,'2025-12-04 08:57:01','2025-12-04 08:58:06','687bf57d8afb5c472'),('69314cddc98fadc17','Process Job Queue e0',0,'Success','2025-12-04 08:57:01',1090088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:57:04','2025-12-04 08:57:05',1347763,1,NULL,NULL,NULL,'2025-12-04 08:57:01','2025-12-04 08:57:05','687bf57dbba8299ef'),('69314d19a66affa28','Submit Popup Reminders',0,'Success','2025-12-04 08:58:01',1090089,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:07','2025-12-04 08:58:07',1347799,1,NULL,NULL,NULL,'2025-12-04 08:58:01','2025-12-04 08:58:07','687bf57d2f9463790'),('69314d19d9ceb04d9','Process Job Queue q0',0,'Success','2025-12-04 08:58:01',1090090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:07','2025-12-04 08:58:08',1347799,1,NULL,NULL,NULL,'2025-12-04 08:58:01','2025-12-04 08:58:08','687bf57d693e0fc1f'),('69314d1a0a92f1810','Process Job Queue q1',0,'Success','2025-12-04 08:59:00',1090091,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:59:02','2025-12-04 08:59:02',1347838,1,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 08:59:02','687bf57d8afb5c472'),('69314d1a3ed392cfc','Process Job Queue e0',0,'Success','2025-12-04 08:58:02',1090092,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:58:08','2025-12-04 08:58:08',1347799,1,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 08:58:08','687bf57dbba8299ef'),('69314d1a617a04458','Send Email Reminders',0,'Success','2025-12-04 09:00:00',1090093,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:06','2025-12-04 09:00:06',1347876,1,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 09:00:06','687bf5d44d3e10813'),('69314d1a7a11c787f','Send Email Notifications',0,'Success','2025-12-04 09:00:00',1090094,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:06','2025-12-04 09:00:07',1347876,1,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 09:00:07','687bf5d466067a4ba'),('69314d1a9a428bdd9','Process Webhook Queue',0,'Success','2025-12-04 09:00:00',1090095,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:07','2025-12-04 09:00:07',1347876,1,NULL,NULL,NULL,'2025-12-04 08:58:02','2025-12-04 09:00:07','687bf5d5788e2fe0e'),('69314d55bd9c31219','Submit Popup Reminders',0,'Success','2025-12-04 08:59:01',1090096,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:59:03','2025-12-04 08:59:04',1347838,1,NULL,NULL,NULL,'2025-12-04 08:59:01','2025-12-04 08:59:04','687bf57d2f9463790'),('69314d55eaf2f13c7','Process Job Queue q0',0,'Success','2025-12-04 08:59:01',1090097,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:59:04','2025-12-04 08:59:04',1347838,1,NULL,NULL,NULL,'2025-12-04 08:59:01','2025-12-04 08:59:04','687bf57d693e0fc1f'),('69314d561db7b9184','Process Job Queue q1',0,'Success','2025-12-04 09:00:00',1090098,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:08','2025-12-04 09:00:08',1347876,1,NULL,NULL,NULL,'2025-12-04 08:59:02','2025-12-04 09:00:08','687bf57d8afb5c472'),('69314d5641affec10','Process Job Queue e0',0,'Success','2025-12-04 08:59:02',1090099,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 08:59:05','2025-12-04 08:59:05',1347838,1,NULL,NULL,NULL,'2025-12-04 08:59:02','2025-12-04 08:59:05','687bf57dbba8299ef'),('69314d91d3f0885fa','Submit Popup Reminders',0,'Success','2025-12-04 09:00:01',1090100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:08','2025-12-04 09:00:09',1347876,1,NULL,NULL,NULL,'2025-12-04 09:00:01','2025-12-04 09:00:09','687bf57d2f9463790'),('69314d921aaec8a83','Process Job Queue q0',0,'Success','2025-12-04 09:00:02',1090101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:09','2025-12-04 09:00:09',1347876,1,NULL,NULL,NULL,'2025-12-04 09:00:02','2025-12-04 09:00:09','687bf57d693e0fc1f'),('69314d923c1987fbf','Process Job Queue q1',0,'Success','2025-12-04 09:01:00',1090102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:01:02','2025-12-04 09:01:03',1347913,1,NULL,NULL,NULL,'2025-12-04 09:00:02','2025-12-04 09:01:03','687bf57d8afb5c472'),('69314d925cff35209','Process Job Queue e0',0,'Success','2025-12-04 09:00:02',1090103,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:00:10','2025-12-04 09:00:10',1347876,1,NULL,NULL,NULL,'2025-12-04 09:00:02','2025-12-04 09:00:10','687bf57dbba8299ef'),('69314d929152c675b','Send Email Reminders',0,'Success','2025-12-04 09:02:00',1090104,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:03','2025-12-04 09:02:03',1347952,1,NULL,NULL,NULL,'2025-12-04 09:00:02','2025-12-04 09:02:03','687bf5d44d3e10813'),('69314d931ebf0878b','Send Email Notifications',0,'Success','2025-12-04 09:02:00',1090105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:04','2025-12-04 09:02:04',1347952,1,NULL,NULL,NULL,'2025-12-04 09:00:03','2025-12-04 09:02:04','687bf5d466067a4ba'),('69314d9381cab386f','Auth Token Control',0,'Success','2025-12-04 09:06:00',1090106,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:03','2025-12-04 09:06:03',1348103,1,NULL,NULL,NULL,'2025-12-04 09:00:03','2025-12-04 09:06:03','687bf5d511e08c57f'),('69314d93cd04359e5','Process Webhook Queue',0,'Success','2025-12-04 09:02:00',1090107,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:05','2025-12-04 09:02:05',1347952,1,NULL,NULL,NULL,'2025-12-04 09:00:03','2025-12-04 09:02:05','687bf5d5788e2fe0e'),('69314d94279bae2ce','Send Scheduled Emails',0,'Success','2025-12-04 09:10:00',1090108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:04','2025-12-04 09:10:05',1348275,1,NULL,NULL,NULL,'2025-12-04 09:00:04','2025-12-04 09:10:05','687bf5d5eeb01d80d'),('69314dcdd5fdadc68','Submit Popup Reminders',0,'Success','2025-12-04 09:01:01',1090109,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:01:04','2025-12-04 09:01:04',1347913,1,NULL,NULL,NULL,'2025-12-04 09:01:01','2025-12-04 09:01:04','687bf57d2f9463790'),('69314dce09c0f3356','Process Job Queue q0',0,'Success','2025-12-04 09:01:02',1090110,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:01:05','2025-12-04 09:01:05',1347913,1,NULL,NULL,NULL,'2025-12-04 09:01:02','2025-12-04 09:01:05','687bf57d693e0fc1f'),('69314dce276c1fe7a','Process Job Queue q1',0,'Success','2025-12-04 09:02:00',1090111,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:06','2025-12-04 09:02:06',1347952,1,NULL,NULL,NULL,'2025-12-04 09:01:02','2025-12-04 09:02:06','687bf57d8afb5c472'),('69314dce5787f7a95','Process Job Queue e0',0,'Success','2025-12-04 09:01:02',1090112,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:01:05','2025-12-04 09:01:05',1347913,1,NULL,NULL,NULL,'2025-12-04 09:01:02','2025-12-04 09:01:05','687bf57dbba8299ef'),('69314e09dde676101','Submit Popup Reminders',0,'Success','2025-12-04 09:02:01',1090113,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:07','2025-12-04 09:02:07',1347952,1,NULL,NULL,NULL,'2025-12-04 09:02:01','2025-12-04 09:02:07','687bf57d2f9463790'),('69314e0a0f6846244','Process Job Queue q0',0,'Success','2025-12-04 09:02:02',1090114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:07','2025-12-04 09:02:08',1347952,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:02:08','687bf57d693e0fc1f'),('69314e0a37764613a','Process Job Queue q1',0,'Success','2025-12-04 09:03:00',1090115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:03:02','2025-12-04 09:03:02',1347992,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:03:02','687bf57d8afb5c472'),('69314e0a5a3070f95','Process Job Queue e0',0,'Success','2025-12-04 09:02:02',1090116,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:02:08','2025-12-04 09:02:09',1347952,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:02:09','687bf57dbba8299ef'),('69314e0a913003319','Send Email Reminders',0,'Success','2025-12-04 09:04:00',1090117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:03','2025-12-04 09:04:03',1348028,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:04:03','687bf5d44d3e10813'),('69314e0aaeae59cf6','Send Email Notifications',0,'Success','2025-12-04 09:04:00',1090118,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:04','2025-12-04 09:04:04',1348028,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:04:04','687bf5d466067a4ba'),('69314e0acfb256fb5','Process Webhook Queue',0,'Success','2025-12-04 09:04:00',1090119,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:05','2025-12-04 09:04:05',1348028,1,NULL,NULL,NULL,'2025-12-04 09:02:02','2025-12-04 09:04:05','687bf5d5788e2fe0e'),('69314e455199f3369','Submit Popup Reminders',0,'Success','2025-12-04 09:03:01',1090120,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:03:03','2025-12-04 09:03:03',1347992,1,NULL,NULL,NULL,'2025-12-04 09:03:01','2025-12-04 09:03:03','687bf57d2f9463790'),('69314e4588dd2feaa','Process Job Queue q0',0,'Success','2025-12-04 09:03:01',1090121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:03:04','2025-12-04 09:03:04',1347992,1,NULL,NULL,NULL,'2025-12-04 09:03:01','2025-12-04 09:03:04','687bf57d693e0fc1f'),('69314e45ad9fe3875','Process Job Queue q1',0,'Success','2025-12-04 09:04:00',1090122,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:06','2025-12-04 09:04:06',1348028,1,NULL,NULL,NULL,'2025-12-04 09:03:01','2025-12-04 09:04:06','687bf57d8afb5c472'),('69314e45d1862da84','Process Job Queue e0',0,'Success','2025-12-04 09:03:01',1090123,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:03:05','2025-12-04 09:03:05',1347992,1,NULL,NULL,NULL,'2025-12-04 09:03:01','2025-12-04 09:03:05','687bf57dbba8299ef'),('69314e81d9e18b05c','Submit Popup Reminders',0,'Success','2025-12-04 09:04:01',1090124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:07','2025-12-04 09:04:07',1348028,1,NULL,NULL,NULL,'2025-12-04 09:04:01','2025-12-04 09:04:07','687bf57d2f9463790'),('69314e820f42b4aad','Process Job Queue q0',0,'Success','2025-12-04 09:04:02',1090125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:08','2025-12-04 09:04:08',1348028,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:04:08','687bf57d693e0fc1f'),('69314e8233fe7153e','Process Job Queue q1',0,'Success','2025-12-04 09:05:00',1090126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:05:02','2025-12-04 09:05:02',1348067,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:05:02','687bf57d8afb5c472'),('69314e82600cff7d1','Process Job Queue e0',0,'Success','2025-12-04 09:04:02',1090127,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:04:08','2025-12-04 09:04:08',1348028,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:04:08','687bf57dbba8299ef'),('69314e8288a426cf4','Send Email Reminders',0,'Success','2025-12-04 09:06:00',1090128,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:04','2025-12-04 09:06:04',1348103,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:06:04','687bf5d44d3e10813'),('69314e82a7cc06b59','Send Email Notifications',0,'Success','2025-12-04 09:06:00',1090129,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:05','2025-12-04 09:06:05',1348103,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:06:05','687bf5d466067a4ba'),('69314e82df03c6360','Process Webhook Queue',0,'Success','2025-12-04 09:06:00',1090130,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:05','2025-12-04 09:06:05',1348103,1,NULL,NULL,NULL,'2025-12-04 09:04:02','2025-12-04 09:06:05','687bf5d5788e2fe0e'),('69314ebd64bb5363e','Submit Popup Reminders',0,'Success','2025-12-04 09:05:01',1090131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:05:03','2025-12-04 09:05:03',1348067,1,NULL,NULL,NULL,'2025-12-04 09:05:01','2025-12-04 09:05:03','687bf57d2f9463790'),('69314ebd85b4ca2b2','Process Job Queue q0',0,'Success','2025-12-04 09:05:01',1090132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:05:04','2025-12-04 09:05:04',1348067,1,NULL,NULL,NULL,'2025-12-04 09:05:01','2025-12-04 09:05:04','687bf57d693e0fc1f'),('69314ebda685545d0','Process Job Queue q1',0,'Success','2025-12-04 09:06:00',1090133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:06','2025-12-04 09:06:06',1348103,1,NULL,NULL,NULL,'2025-12-04 09:05:01','2025-12-04 09:06:06','687bf57d8afb5c472'),('69314ebdc665ed57f','Process Job Queue e0',0,'Success','2025-12-04 09:05:01',1090134,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:05:05','2025-12-04 09:05:05',1348067,1,NULL,NULL,NULL,'2025-12-04 09:05:01','2025-12-04 09:05:05','687bf57dbba8299ef'),('69314ef973650f096','Submit Popup Reminders',0,'Success','2025-12-04 09:06:01',1090135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:07','2025-12-04 09:06:07',1348103,1,NULL,NULL,NULL,'2025-12-04 09:06:01','2025-12-04 09:06:07','687bf57d2f9463790'),('69314ef9d6e8e3241','Process Job Queue q0',0,'Success','2025-12-04 09:06:01',1090136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:07','2025-12-04 09:06:07',1348103,1,NULL,NULL,NULL,'2025-12-04 09:06:01','2025-12-04 09:06:07','687bf57d693e0fc1f'),('69314efa3ea01a913','Process Job Queue q1',0,'Success','2025-12-04 09:07:00',1090137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:07:02','2025-12-04 09:07:03',1348137,1,NULL,NULL,NULL,'2025-12-04 09:06:02','2025-12-04 09:07:03','687bf57d8afb5c472'),('69314efa6f8f285da','Process Job Queue e0',0,'Success','2025-12-04 09:06:02',1090138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:06:08','2025-12-04 09:06:08',1348103,1,NULL,NULL,NULL,'2025-12-04 09:06:02','2025-12-04 09:06:08','687bf57dbba8299ef'),('69314efaab5ba074e','Send Email Reminders',0,'Success','2025-12-04 09:08:00',1090139,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:08:03',1348171,1,NULL,NULL,NULL,'2025-12-04 09:06:02','2025-12-04 09:08:03','687bf5d44d3e10813'),('69314efade4cda8d7','Send Email Notifications',0,'Success','2025-12-04 09:08:00',1090140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:04','2025-12-04 09:08:04',1348171,1,NULL,NULL,NULL,'2025-12-04 09:06:02','2025-12-04 09:08:04','687bf5d466067a4ba'),('69314efb28dad227a','Auth Token Control',0,'Success','2025-12-04 09:12:00',1090141,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:03','2025-12-04 09:12:04',1348308,1,NULL,NULL,NULL,'2025-12-04 09:06:03','2025-12-04 09:12:04','687bf5d511e08c57f'),('69314efb654c6434c','Process Webhook Queue',0,'Success','2025-12-04 09:08:00',1090142,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:05','2025-12-04 09:08:05',1348171,1,NULL,NULL,NULL,'2025-12-04 09:06:03','2025-12-04 09:08:05','687bf5d5788e2fe0e'),('69314f3602fc1e581','Submit Popup Reminders',0,'Success','2025-12-04 09:07:02',1090143,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:07:04','2025-12-04 09:07:04',1348137,1,NULL,NULL,NULL,'2025-12-04 09:07:02','2025-12-04 09:07:04','687bf57d2f9463790'),('69314f362864461cf','Process Job Queue q0',0,'Success','2025-12-04 09:07:02',1090144,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:07:04','2025-12-04 09:07:04',1348137,1,NULL,NULL,NULL,'2025-12-04 09:07:02','2025-12-04 09:07:04','687bf57d693e0fc1f'),('69314f365337a205b','Process Job Queue q1',0,'Success','2025-12-04 09:08:00',1090145,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:06','2025-12-04 09:08:06',1348171,1,NULL,NULL,NULL,'2025-12-04 09:07:02','2025-12-04 09:08:06','687bf57d8afb5c472'),('69314f369597f3542','Process Job Queue e0',0,'Success','2025-12-04 09:07:02',1090146,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:07:05','2025-12-04 09:07:05',1348137,1,NULL,NULL,NULL,'2025-12-04 09:07:02','2025-12-04 09:07:05','687bf57dbba8299ef'),('69314f71d91ec4c35','Submit Popup Reminders',0,'Success','2025-12-04 09:08:01',1090147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:07','2025-12-04 09:08:07',1348171,1,NULL,NULL,NULL,'2025-12-04 09:08:01','2025-12-04 09:08:07','687bf57d2f9463790'),('69314f720f2064771','Process Job Queue q0',0,'Success','2025-12-04 09:08:02',1090148,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:07','2025-12-04 09:08:08',1348171,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:08:08','687bf57d693e0fc1f'),('69314f722bb01d056','Process Job Queue q1',0,'Success','2025-12-04 09:09:00',1090149,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:09:02','2025-12-04 09:09:02',1348192,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:09:02','687bf57d8afb5c472'),('69314f724d9c8622b','Process Job Queue e0',0,'Success','2025-12-04 09:08:02',1090150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:08:08','2025-12-04 09:08:09',1348171,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:08:09','687bf57dbba8299ef'),('69314f727ac34c5db','Send Email Reminders',0,'Success','2025-12-04 09:10:00',1090151,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:05','2025-12-04 09:10:05',1348275,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:10:05','687bf5d44d3e10813'),('69314f7299b1b484d','Send Email Notifications',0,'Success','2025-12-04 09:10:00',1090152,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:06','2025-12-04 09:10:06',1348275,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:10:06','687bf5d466067a4ba'),('69314f72bca42ef8e','Process Webhook Queue',0,'Success','2025-12-04 09:10:00',1090153,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:07','2025-12-04 09:10:07',1348275,1,NULL,NULL,NULL,'2025-12-04 09:08:02','2025-12-04 09:10:07','687bf5d5788e2fe0e'),('69314fada9737ea85','Submit Popup Reminders',0,'Success','2025-12-04 09:09:01',1090154,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:09:03','2025-12-04 09:09:04',1348192,1,NULL,NULL,NULL,'2025-12-04 09:09:01','2025-12-04 09:09:04','687bf57d2f9463790'),('69314faddcf14a2b9','Process Job Queue q0',0,'Success','2025-12-04 09:09:01',1090155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:09:05','2025-12-04 09:09:05',1348192,1,NULL,NULL,NULL,'2025-12-04 09:09:01','2025-12-04 09:09:05','687bf57d693e0fc1f'),('69314fae037287f44','Process Job Queue q1',0,'Success','2025-12-04 09:10:00',1090156,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:07','2025-12-04 09:10:08',1348275,1,NULL,NULL,NULL,'2025-12-04 09:09:02','2025-12-04 09:10:08','687bf57d8afb5c472'),('69314fae21350d116','Process Job Queue e0',0,'Success','2025-12-04 09:09:02',1090157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:09:06','2025-12-04 09:09:06',1348192,1,NULL,NULL,NULL,'2025-12-04 09:09:02','2025-12-04 09:09:06','687bf57dbba8299ef'),('69314fe9cf4a10ab0','Submit Popup Reminders',0,'Success','2025-12-04 09:10:01',1090158,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:08','2025-12-04 09:10:08',1348275,1,NULL,NULL,NULL,'2025-12-04 09:10:01','2025-12-04 09:10:08','687bf57d2f9463790'),('69314fea24ffd9959','Process Job Queue q0',0,'Success','2025-12-04 09:10:02',1090159,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:09','2025-12-04 09:10:09',1348275,1,NULL,NULL,NULL,'2025-12-04 09:10:02','2025-12-04 09:10:09','687bf57d693e0fc1f'),('69314fea6f5ea941f','Process Job Queue q1',0,'Success','2025-12-04 09:11:00',1090160,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:11:01','2025-12-04 09:11:02',1348291,1,NULL,NULL,NULL,'2025-12-04 09:10:02','2025-12-04 09:11:02','687bf57d8afb5c472'),('69314feae59d494e7','Process Job Queue e0',0,'Success','2025-12-04 09:10:02',1090161,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:10:10','2025-12-04 09:10:10',1348275,1,NULL,NULL,NULL,'2025-12-04 09:10:02','2025-12-04 09:10:10','687bf57dbba8299ef'),('69314feb2b1189705','Send Email Reminders',0,'Success','2025-12-04 09:12:00',1090162,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:04','2025-12-04 09:12:05',1348308,1,NULL,NULL,NULL,'2025-12-04 09:10:03','2025-12-04 09:12:05','687bf5d44d3e10813'),('69314feb562dd57cb','Send Email Notifications',0,'Success','2025-12-04 09:12:00',1090163,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:05','2025-12-04 09:12:05',1348308,1,NULL,NULL,NULL,'2025-12-04 09:10:03','2025-12-04 09:12:05','687bf5d466067a4ba'),('69314feb7d695c6de','Send Mass Emails',0,'Success','2025-12-04 09:30:00',1090164,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:04','2025-12-04 09:30:04',1348927,1,NULL,NULL,NULL,'2025-12-04 09:10:03','2025-12-04 09:30:04','687bf5d4b535f913f'),('69314febad312ab2f','Process Webhook Queue',0,'Success','2025-12-04 09:12:00',1090165,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:06','2025-12-04 09:12:06',1348308,1,NULL,NULL,NULL,'2025-12-04 09:10:03','2025-12-04 09:12:06','687bf5d5788e2fe0e'),('69314febf11aaf303','Send Scheduled Emails',0,'Success','2025-12-04 09:20:00',1090166,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:04','2025-12-04 09:20:04',1348548,1,NULL,NULL,NULL,'2025-12-04 09:10:03','2025-12-04 09:20:04','687bf5d5eeb01d80d'),('6931502526d780cd2','Submit Popup Reminders',0,'Success','2025-12-04 09:11:01',1090167,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:11:03','2025-12-04 09:11:03',1348291,1,NULL,NULL,NULL,'2025-12-04 09:11:01','2025-12-04 09:11:03','687bf57d2f9463790'),('69315025491d67378','Process Job Queue q0',0,'Success','2025-12-04 09:11:01',1090168,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:11:04','2025-12-04 09:11:04',1348291,1,NULL,NULL,NULL,'2025-12-04 09:11:01','2025-12-04 09:11:04','687bf57d693e0fc1f'),('693150256fea331b3','Process Job Queue q1',0,'Success','2025-12-04 09:12:00',1090169,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:06','2025-12-04 09:12:07',1348308,1,NULL,NULL,NULL,'2025-12-04 09:11:01','2025-12-04 09:12:07','687bf57d8afb5c472'),('6931502590a53ebcf','Process Job Queue e0',0,'Success','2025-12-04 09:11:01',1090170,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:11:04','2025-12-04 09:11:05',1348291,1,NULL,NULL,NULL,'2025-12-04 09:11:01','2025-12-04 09:11:05','687bf57dbba8299ef'),('6931506189935a2b7','Submit Popup Reminders',0,'Success','2025-12-04 09:12:01',1090171,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:07','2025-12-04 09:12:07',1348308,1,NULL,NULL,NULL,'2025-12-04 09:12:01','2025-12-04 09:12:07','687bf57d2f9463790'),('69315061b2a2ea0db','Process Job Queue q0',0,'Success','2025-12-04 09:12:01',1090172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:08','2025-12-04 09:12:08',1348308,1,NULL,NULL,NULL,'2025-12-04 09:12:01','2025-12-04 09:12:08','687bf57d693e0fc1f'),('69315061d96a5135e','Process Job Queue q1',0,'Success','2025-12-04 09:13:00',1090173,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:13:02','2025-12-04 09:13:02',1348328,1,NULL,NULL,NULL,'2025-12-04 09:12:01','2025-12-04 09:13:02','687bf57d8afb5c472'),('6931506200fdb40af','Process Job Queue e0',0,'Success','2025-12-04 09:12:02',1090174,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:12:09','2025-12-04 09:12:09',1348308,1,NULL,NULL,NULL,'2025-12-04 09:12:02','2025-12-04 09:12:09','687bf57dbba8299ef'),('693150623335d5ad6','Send Email Reminders',0,'Success','2025-12-04 09:14:00',1090175,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:03','2025-12-04 09:14:03',1348344,1,NULL,NULL,NULL,'2025-12-04 09:12:02','2025-12-04 09:14:03','687bf5d44d3e10813'),('693150627bfdeb991','Send Email Notifications',0,'Success','2025-12-04 09:14:00',1090176,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:04','2025-12-04 09:14:04',1348344,1,NULL,NULL,NULL,'2025-12-04 09:12:02','2025-12-04 09:14:04','687bf5d466067a4ba'),('69315062d769e07a4','Auth Token Control',0,'Success','2025-12-04 09:18:00',1090177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:03','2025-12-04 09:18:04',1348470,1,NULL,NULL,NULL,'2025-12-04 09:12:02','2025-12-04 09:18:04','687bf5d511e08c57f'),('69315063915305272','Process Webhook Queue',0,'Success','2025-12-04 09:14:00',1090178,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:04','2025-12-04 09:14:04',1348344,1,NULL,NULL,NULL,'2025-12-04 09:12:03','2025-12-04 09:14:04','687bf5d5788e2fe0e'),('6931509d6f2b09e56','Submit Popup Reminders',0,'Success','2025-12-04 09:13:01',1090179,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:13:03','2025-12-04 09:13:03',1348328,1,NULL,NULL,NULL,'2025-12-04 09:13:01','2025-12-04 09:13:03','687bf57d2f9463790'),('6931509d9a0561077','Process Job Queue q0',0,'Success','2025-12-04 09:13:01',1090180,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:13:04','2025-12-04 09:13:04',1348328,1,NULL,NULL,NULL,'2025-12-04 09:13:01','2025-12-04 09:13:04','687bf57d693e0fc1f'),('6931509dc1f18c7f4','Process Job Queue q1',0,'Success','2025-12-04 09:14:00',1090181,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:05','2025-12-04 09:14:05',1348344,1,NULL,NULL,NULL,'2025-12-04 09:13:01','2025-12-04 09:14:05','687bf57d8afb5c472'),('6931509e07379aa58','Process Job Queue e0',0,'Success','2025-12-04 09:13:02',1090182,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:13:05','2025-12-04 09:13:05',1348328,1,NULL,NULL,NULL,'2025-12-04 09:13:02','2025-12-04 09:13:05','687bf57dbba8299ef'),('693150d93188a8e02','Submit Popup Reminders',0,'Success','2025-12-04 09:14:01',1090183,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:06','2025-12-04 09:14:06',1348344,1,NULL,NULL,NULL,'2025-12-04 09:14:01','2025-12-04 09:14:06','687bf57d2f9463790'),('693150d965eb6a70e','Process Job Queue q0',0,'Success','2025-12-04 09:14:01',1090184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:07','2025-12-04 09:14:07',1348344,1,NULL,NULL,NULL,'2025-12-04 09:14:01','2025-12-04 09:14:07','687bf57d693e0fc1f'),('693150d99d3e0cd8f','Process Job Queue q1',0,'Success','2025-12-04 09:15:00',1090185,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:15:02','2025-12-04 09:15:02',1348358,1,NULL,NULL,NULL,'2025-12-04 09:14:01','2025-12-04 09:15:02','687bf57d8afb5c472'),('693150d9daf2462b0','Process Job Queue e0',0,'Success','2025-12-04 09:14:01',1090186,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:14:07','2025-12-04 09:14:07',1348344,1,NULL,NULL,NULL,'2025-12-04 09:14:01','2025-12-04 09:14:07','687bf57dbba8299ef'),('693150da360a46f2c','Send Email Reminders',0,'Success','2025-12-04 09:16:00',1090187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:04','2025-12-04 09:16:04',1348396,1,NULL,NULL,NULL,'2025-12-04 09:14:02','2025-12-04 09:16:04','687bf5d44d3e10813'),('693150da9d30e76ee','Send Email Notifications',0,'Success','2025-12-04 09:16:00',1090188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:04','2025-12-04 09:16:04',1348396,1,NULL,NULL,NULL,'2025-12-04 09:14:02','2025-12-04 09:16:04','687bf5d466067a4ba'),('693150db0bccf25d9','Process Webhook Queue',0,'Success','2025-12-04 09:16:00',1090189,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:05','2025-12-04 09:16:05',1348396,1,NULL,NULL,NULL,'2025-12-04 09:14:03','2025-12-04 09:16:05','687bf5d5788e2fe0e'),('693151153a474929b','Submit Popup Reminders',0,'Success','2025-12-04 09:15:01',1090190,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:15:03','2025-12-04 09:15:03',1348358,1,NULL,NULL,NULL,'2025-12-04 09:15:01','2025-12-04 09:15:03','687bf57d2f9463790'),('6931511582840fa81','Process Job Queue q0',0,'Success','2025-12-04 09:15:01',1090191,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:15:03','2025-12-04 09:15:04',1348358,1,NULL,NULL,NULL,'2025-12-04 09:15:01','2025-12-04 09:15:04','687bf57d693e0fc1f'),('69315115b4e649d04','Process Job Queue q1',0,'Success','2025-12-04 09:16:00',1090192,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:06','2025-12-04 09:16:06',1348396,1,NULL,NULL,NULL,'2025-12-04 09:15:01','2025-12-04 09:16:06','687bf57d8afb5c472'),('69315115e7db7827e','Process Job Queue e0',0,'Success','2025-12-04 09:15:01',1090193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:15:04','2025-12-04 09:15:04',1348358,1,NULL,NULL,NULL,'2025-12-04 09:15:01','2025-12-04 09:15:04','687bf57dbba8299ef'),('69315151d2b874a21','Submit Popup Reminders',0,'Success','2025-12-04 09:16:01',1090194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:06','2025-12-04 09:16:07',1348396,1,NULL,NULL,NULL,'2025-12-04 09:16:01','2025-12-04 09:16:07','687bf57d2f9463790'),('6931515234e3aa925','Process Job Queue q0',0,'Success','2025-12-04 09:16:02',1090195,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:07','2025-12-04 09:16:07',1348396,1,NULL,NULL,NULL,'2025-12-04 09:16:02','2025-12-04 09:16:07','687bf57d693e0fc1f'),('69315152753de385b','Process Job Queue q1',0,'Success','2025-12-04 09:17:00',1090196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:17:03','2025-12-04 09:17:03',1348435,1,NULL,NULL,NULL,'2025-12-04 09:16:02','2025-12-04 09:17:03','687bf57d8afb5c472'),('69315152cc8757696','Process Job Queue e0',0,'Success','2025-12-04 09:16:02',1090197,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:16:08','2025-12-04 09:16:08',1348396,1,NULL,NULL,NULL,'2025-12-04 09:16:02','2025-12-04 09:16:08','687bf57dbba8299ef'),('693151535cf404ce9','Send Email Reminders',0,'Success','2025-12-04 09:18:00',1090198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:04','2025-12-04 09:18:04',1348470,1,NULL,NULL,NULL,'2025-12-04 09:16:03','2025-12-04 09:18:04','687bf5d44d3e10813'),('693151538abe844b7','Send Email Notifications',0,'Success','2025-12-04 09:18:00',1090199,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:05','2025-12-04 09:18:05',1348470,1,NULL,NULL,NULL,'2025-12-04 09:16:03','2025-12-04 09:18:05','687bf5d466067a4ba'),('69315153c03cebc86','Process Webhook Queue',0,'Success','2025-12-04 09:18:00',1090200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:06','2025-12-04 09:18:06',1348470,1,NULL,NULL,NULL,'2025-12-04 09:16:03','2025-12-04 09:18:06','687bf5d5788e2fe0e'),('6931518e16f22cc35','Submit Popup Reminders',0,'Success','2025-12-04 09:17:02',1090201,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:17:04','2025-12-04 09:17:04',1348435,1,NULL,NULL,NULL,'2025-12-04 09:17:02','2025-12-04 09:17:04','687bf57d2f9463790'),('6931518e50f95fb2a','Process Job Queue q0',0,'Success','2025-12-04 09:17:02',1090202,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:17:05','2025-12-04 09:17:05',1348435,1,NULL,NULL,NULL,'2025-12-04 09:17:02','2025-12-04 09:17:05','687bf57d693e0fc1f'),('6931518e7974b3bda','Process Job Queue q1',0,'Success','2025-12-04 09:18:00',1090203,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:06','2025-12-04 09:18:07',1348470,1,NULL,NULL,NULL,'2025-12-04 09:17:02','2025-12-04 09:18:07','687bf57d8afb5c472'),('6931518ebe82d6386','Process Job Queue e0',0,'Success','2025-12-04 09:17:02',1090204,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:17:05','2025-12-04 09:17:05',1348435,1,NULL,NULL,NULL,'2025-12-04 09:17:02','2025-12-04 09:17:05','687bf57dbba8299ef'),('693151c9e0546df4b','Submit Popup Reminders',0,'Success','2025-12-04 09:18:01',1090205,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:07','2025-12-04 09:18:07',1348470,1,NULL,NULL,NULL,'2025-12-04 09:18:01','2025-12-04 09:18:07','687bf57d2f9463790'),('693151ca0d22626d9','Process Job Queue q0',0,'Success','2025-12-04 09:18:02',1090206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:08','2025-12-04 09:18:08',1348470,1,NULL,NULL,NULL,'2025-12-04 09:18:02','2025-12-04 09:18:08','687bf57d693e0fc1f'),('693151ca318935a73','Process Job Queue q1',0,'Success','2025-12-04 09:19:00',1090207,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:19:02','2025-12-04 09:19:02',1348507,1,NULL,NULL,NULL,'2025-12-04 09:18:02','2025-12-04 09:19:02','687bf57d8afb5c472'),('693151ca4ea6cb365','Process Job Queue e0',0,'Success','2025-12-04 09:18:02',1090208,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:18:09','2025-12-04 09:18:09',1348470,1,NULL,NULL,NULL,'2025-12-04 09:18:02','2025-12-04 09:18:09','687bf57dbba8299ef'),('693151cace866e53a','Send Email Reminders',0,'Success','2025-12-04 09:20:00',1090209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:04','2025-12-04 09:20:05',1348548,1,NULL,NULL,NULL,'2025-12-04 09:18:02','2025-12-04 09:20:05','687bf5d44d3e10813'),('693151cb18b3b47cc','Send Email Notifications',0,'Success','2025-12-04 09:20:00',1090210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:05','2025-12-04 09:20:05',1348548,1,NULL,NULL,NULL,'2025-12-04 09:18:03','2025-12-04 09:20:05','687bf5d466067a4ba'),('693151cb5d321e557','Auth Token Control',0,'Success','2025-12-04 09:24:00',1090211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:03','2025-12-04 09:24:04',1348702,1,NULL,NULL,NULL,'2025-12-04 09:18:03','2025-12-04 09:24:04','687bf5d511e08c57f'),('693151cb95fe043dc','Process Webhook Queue',0,'Success','2025-12-04 09:20:00',1090212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:06','2025-12-04 09:20:06',1348548,1,NULL,NULL,NULL,'2025-12-04 09:18:03','2025-12-04 09:20:06','687bf5d5788e2fe0e'),('69315205ad6c42c70','Submit Popup Reminders',0,'Success','2025-12-04 09:19:01',1090213,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:19:03','2025-12-04 09:19:04',1348507,1,NULL,NULL,NULL,'2025-12-04 09:19:01','2025-12-04 09:19:04','687bf57d2f9463790'),('69315205dce2f792c','Process Job Queue q0',0,'Success','2025-12-04 09:19:01',1090214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:19:05','2025-12-04 09:19:05',1348507,1,NULL,NULL,NULL,'2025-12-04 09:19:01','2025-12-04 09:19:05','687bf57d693e0fc1f'),('69315206198e7619e','Process Job Queue q1',0,'Success','2025-12-04 09:20:00',1090215,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:06','2025-12-04 09:20:07',1348548,1,NULL,NULL,NULL,'2025-12-04 09:19:02','2025-12-04 09:20:07','687bf57d8afb5c472'),('693152063da7807e4','Process Job Queue e0',0,'Success','2025-12-04 09:19:02',1090216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:19:06','2025-12-04 09:19:06',1348507,1,NULL,NULL,NULL,'2025-12-04 09:19:02','2025-12-04 09:19:06','687bf57dbba8299ef'),('69315241e820bccaa','Submit Popup Reminders',0,'Success','2025-12-04 09:20:01',1090217,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:07','2025-12-04 09:20:07',1348548,1,NULL,NULL,NULL,'2025-12-04 09:20:01','2025-12-04 09:20:07','687bf57d2f9463790'),('693152421c25b3e3a','Process Job Queue q0',0,'Success','2025-12-04 09:20:02',1090218,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:08','2025-12-04 09:20:08',1348548,1,NULL,NULL,NULL,'2025-12-04 09:20:02','2025-12-04 09:20:08','687bf57d693e0fc1f'),('693152424f5402b43','Process Job Queue q1',0,'Success','2025-12-04 09:21:00',1090219,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:21:02','2025-12-04 09:21:03',1348592,1,NULL,NULL,NULL,'2025-12-04 09:20:02','2025-12-04 09:21:03','687bf57d8afb5c472'),('69315242ac1162af4','Process Job Queue e0',0,'Success','2025-12-04 09:20:02',1090220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:20:08','2025-12-04 09:20:09',1348548,1,NULL,NULL,NULL,'2025-12-04 09:20:02','2025-12-04 09:20:09','687bf57dbba8299ef'),('69315243453823afe','Send Email Reminders',0,'Success','2025-12-04 09:22:00',1090221,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:03','2025-12-04 09:22:03',1348631,1,NULL,NULL,NULL,'2025-12-04 09:20:03','2025-12-04 09:22:03','687bf5d44d3e10813'),('693152438fc70bcbc','Send Email Notifications',0,'Success','2025-12-04 09:22:00',1090222,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:04','2025-12-04 09:22:04',1348631,1,NULL,NULL,NULL,'2025-12-04 09:20:03','2025-12-04 09:22:04','687bf5d466067a4ba'),('69315243cdf7afa81','Process Webhook Queue',0,'Success','2025-12-04 09:22:00',1090223,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:05','2025-12-04 09:22:05',1348631,1,NULL,NULL,NULL,'2025-12-04 09:20:03','2025-12-04 09:22:05','687bf5d5788e2fe0e'),('69315243f40ba06d4','Send Scheduled Emails',0,'Success','2025-12-04 09:30:00',1090224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:05','2025-12-04 09:30:05',1348927,1,NULL,NULL,NULL,'2025-12-04 09:20:03','2025-12-04 09:30:05','687bf5d5eeb01d80d'),('6931527d48f5bc20b','Submit Popup Reminders',0,'Success','2025-12-04 09:21:01',1090225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:21:04','2025-12-04 09:21:04',1348592,1,NULL,NULL,NULL,'2025-12-04 09:21:01','2025-12-04 09:21:04','687bf57d2f9463790'),('6931527d7fe3503f3','Process Job Queue q0',0,'Success','2025-12-04 09:21:01',1090226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:21:04','2025-12-04 09:21:04',1348592,1,NULL,NULL,NULL,'2025-12-04 09:21:01','2025-12-04 09:21:04','687bf57d693e0fc1f'),('6931527e2109281b4','Process Job Queue q1',0,'Success','2025-12-04 09:22:00',1090227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:06','2025-12-04 09:22:06',1348631,1,NULL,NULL,NULL,'2025-12-04 09:21:02','2025-12-04 09:22:06','687bf57d8afb5c472'),('6931527e5cb3208b6','Process Job Queue e0',0,'Success','2025-12-04 09:21:02',1090228,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:21:05','2025-12-04 09:21:05',1348592,1,NULL,NULL,NULL,'2025-12-04 09:21:02','2025-12-04 09:21:05','687bf57dbba8299ef'),('693152ba1bb203d3b','Submit Popup Reminders',0,'Success','2025-12-04 09:22:02',1090229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:07','2025-12-04 09:22:07',1348631,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:22:07','687bf57d2f9463790'),('693152ba4013cd018','Process Job Queue q0',0,'Success','2025-12-04 09:22:02',1090230,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:07','2025-12-04 09:22:08',1348631,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:22:08','687bf57d693e0fc1f'),('693152ba66d2ec81f','Process Job Queue q1',0,'Success','2025-12-04 09:23:00',1090231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:23:02','2025-12-04 09:23:02',1348668,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:23:02','687bf57d8afb5c472'),('693152ba8ac056fda','Process Job Queue e0',0,'Success','2025-12-04 09:22:02',1090232,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:22:08','2025-12-04 09:22:08',1348631,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:22:08','687bf57dbba8299ef'),('693152bab0c1deea0','Send Email Reminders',0,'Success','2025-12-04 09:24:00',1090233,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:04','2025-12-04 09:24:05',1348702,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:24:05','687bf5d44d3e10813'),('693152bae56ddeba9','Send Email Notifications',0,'Success','2025-12-04 09:24:00',1090234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:05','2025-12-04 09:24:05',1348702,1,NULL,NULL,NULL,'2025-12-04 09:22:02','2025-12-04 09:24:05','687bf5d466067a4ba'),('693152bb3cafc727f','Process Webhook Queue',0,'Success','2025-12-04 09:24:00',1090235,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:06','2025-12-04 09:24:06',1348702,1,NULL,NULL,NULL,'2025-12-04 09:22:03','2025-12-04 09:24:06','687bf5d5788e2fe0e'),('693152f564c0b82fc','Submit Popup Reminders',0,'Success','2025-12-04 09:23:01',1090236,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:23:03','2025-12-04 09:23:03',1348668,1,NULL,NULL,NULL,'2025-12-04 09:23:01','2025-12-04 09:23:03','687bf57d2f9463790'),('693152f58b7e7007a','Process Job Queue q0',0,'Success','2025-12-04 09:23:01',1090237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:23:04','2025-12-04 09:23:05',1348668,1,NULL,NULL,NULL,'2025-12-04 09:23:01','2025-12-04 09:23:05','687bf57d693e0fc1f'),('693152f5b4647b093','Process Job Queue q1',0,'Success','2025-12-04 09:24:00',1090238,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:06','2025-12-04 09:24:07',1348702,1,NULL,NULL,NULL,'2025-12-04 09:23:01','2025-12-04 09:24:07','687bf57d8afb5c472'),('693152f5dc6221536','Process Job Queue e0',0,'Success','2025-12-04 09:23:01',1090239,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:23:05','2025-12-04 09:23:05',1348668,1,NULL,NULL,NULL,'2025-12-04 09:23:01','2025-12-04 09:23:05','687bf57dbba8299ef'),('69315331a4659b6cd','Submit Popup Reminders',0,'Success','2025-12-04 09:24:01',1090240,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:07','2025-12-04 09:24:07',1348702,1,NULL,NULL,NULL,'2025-12-04 09:24:01','2025-12-04 09:24:07','687bf57d2f9463790'),('69315331ce07141e4','Process Job Queue q0',0,'Success','2025-12-04 09:24:01',1090241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:08','2025-12-04 09:24:08',1348702,1,NULL,NULL,NULL,'2025-12-04 09:24:01','2025-12-04 09:24:08','687bf57d693e0fc1f'),('69315332125763fb7','Process Job Queue q1',0,'Success','2025-12-04 09:25:00',1090242,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:25:02','2025-12-04 09:25:03',1348740,1,NULL,NULL,NULL,'2025-12-04 09:24:02','2025-12-04 09:25:03','687bf57d8afb5c472'),('69315332619bc4577','Process Job Queue e0',0,'Success','2025-12-04 09:24:02',1090243,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:24:09','2025-12-04 09:24:09',1348702,1,NULL,NULL,NULL,'2025-12-04 09:24:02','2025-12-04 09:24:09','687bf57dbba8299ef'),('69315332ce7842783','Send Email Reminders',0,'Success','2025-12-04 09:26:00',1090244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:02','2025-12-04 09:26:03',1348777,1,NULL,NULL,NULL,'2025-12-04 09:24:02','2025-12-04 09:26:03','687bf5d44d3e10813'),('6931533370b795bba','Send Email Notifications',0,'Success','2025-12-04 09:26:00',1090245,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:03','2025-12-04 09:26:04',1348777,1,NULL,NULL,NULL,'2025-12-04 09:24:03','2025-12-04 09:26:04','687bf5d466067a4ba'),('693153339472394f7','Auth Token Control',0,'Success','2025-12-04 09:30:00',1090246,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:06','2025-12-04 09:30:06',1348927,1,NULL,NULL,NULL,'2025-12-04 09:24:03','2025-12-04 09:30:06','687bf5d511e08c57f'),('69315333bb494619a','Process Webhook Queue',0,'Success','2025-12-04 09:26:00',1090247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:04','2025-12-04 09:26:04',1348777,1,NULL,NULL,NULL,'2025-12-04 09:24:03','2025-12-04 09:26:04','687bf5d5788e2fe0e'),('6931536dc1d768572','Submit Popup Reminders',0,'Success','2025-12-04 09:25:01',1090248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:25:03','2025-12-04 09:25:04',1348740,1,NULL,NULL,NULL,'2025-12-04 09:25:01','2025-12-04 09:25:04','687bf57d2f9463790'),('6931536e0d64228fa','Process Job Queue q0',0,'Success','2025-12-04 09:25:02',1090249,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:25:04','2025-12-04 09:25:04',1348740,1,NULL,NULL,NULL,'2025-12-04 09:25:02','2025-12-04 09:25:04','687bf57d693e0fc1f'),('6931536e4b3b455ce','Process Job Queue q1',0,'Success','2025-12-04 09:26:00',1090250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:05','2025-12-04 09:26:05',1348777,1,NULL,NULL,NULL,'2025-12-04 09:25:02','2025-12-04 09:26:05','687bf57d8afb5c472'),('6931536e775bd4f08','Process Job Queue e0',0,'Success','2025-12-04 09:25:02',1090251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:25:05','2025-12-04 09:25:05',1348740,1,NULL,NULL,NULL,'2025-12-04 09:25:02','2025-12-04 09:25:05','687bf57dbba8299ef'),('693153a92ef5789f1','Submit Popup Reminders',0,'Success','2025-12-04 09:26:01',1090252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:05','2025-12-04 09:26:06',1348777,1,NULL,NULL,NULL,'2025-12-04 09:26:01','2025-12-04 09:26:06','687bf57d2f9463790'),('693153a9590fe860d','Process Job Queue q0',0,'Success','2025-12-04 09:26:01',1090253,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:06','2025-12-04 09:26:06',1348777,1,NULL,NULL,NULL,'2025-12-04 09:26:01','2025-12-04 09:26:06','687bf57d693e0fc1f'),('693153a977f78041c','Process Job Queue q1',0,'Success','2025-12-04 09:27:00',1090254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:27:02','2025-12-04 09:27:02',1348814,1,NULL,NULL,NULL,'2025-12-04 09:26:01','2025-12-04 09:27:02','687bf57d8afb5c472'),('693153a99f9b38d0c','Process Job Queue e0',0,'Success','2025-12-04 09:26:01',1090255,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:26:07','2025-12-04 09:26:07',1348777,1,NULL,NULL,NULL,'2025-12-04 09:26:01','2025-12-04 09:26:07','687bf57dbba8299ef'),('693153a9dc82e31db','Send Email Reminders',0,'Success','2025-12-04 09:28:00',1090256,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:03','2025-12-04 09:28:03',1348852,1,NULL,NULL,NULL,'2025-12-04 09:26:01','2025-12-04 09:28:03','687bf5d44d3e10813'),('693153aa21ef480fc','Send Email Notifications',0,'Success','2025-12-04 09:28:00',1090257,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:04','2025-12-04 09:28:04',1348852,1,NULL,NULL,NULL,'2025-12-04 09:26:02','2025-12-04 09:28:04','687bf5d466067a4ba'),('693153aa7bf68db6f','Process Webhook Queue',0,'Success','2025-12-04 09:28:00',1090258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:05','2025-12-04 09:28:05',1348852,1,NULL,NULL,NULL,'2025-12-04 09:26:02','2025-12-04 09:28:05','687bf5d5788e2fe0e'),('693153e5514ee82ce','Submit Popup Reminders',0,'Success','2025-12-04 09:27:01',1090259,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:27:03','2025-12-04 09:27:03',1348814,1,NULL,NULL,NULL,'2025-12-04 09:27:01','2025-12-04 09:27:03','687bf57d2f9463790'),('693153e58477ee681','Process Job Queue q0',0,'Success','2025-12-04 09:27:01',1090260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:27:04','2025-12-04 09:27:04',1348814,1,NULL,NULL,NULL,'2025-12-04 09:27:01','2025-12-04 09:27:04','687bf57d693e0fc1f'),('693153e5a985b53d9','Process Job Queue q1',0,'Success','2025-12-04 09:28:00',1090261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:06','2025-12-04 09:28:06',1348852,1,NULL,NULL,NULL,'2025-12-04 09:27:01','2025-12-04 09:28:06','687bf57d8afb5c472'),('693153e5cf2bf0865','Process Job Queue e0',0,'Success','2025-12-04 09:27:01',1090262,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:27:05','2025-12-04 09:27:05',1348814,1,NULL,NULL,NULL,'2025-12-04 09:27:01','2025-12-04 09:27:05','687bf57dbba8299ef'),('69315421c2a71b98e','Submit Popup Reminders',0,'Success','2025-12-04 09:28:01',1090263,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:07','2025-12-04 09:28:07',1348852,1,NULL,NULL,NULL,'2025-12-04 09:28:01','2025-12-04 09:28:07','687bf57d2f9463790'),('69315422010e7a7c7','Process Job Queue q0',0,'Success','2025-12-04 09:28:02',1090264,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:08','2025-12-04 09:28:08',1348852,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:28:08','687bf57d693e0fc1f'),('6931542225be79dab','Process Job Queue q1',0,'Success','2025-12-04 09:29:00',1090265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:29:03','2025-12-04 09:29:03',1348891,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:29:03','687bf57d8afb5c472'),('69315422499fb79bb','Process Job Queue e0',0,'Success','2025-12-04 09:28:02',1090266,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:28:09','2025-12-04 09:28:09',1348852,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:28:09','687bf57dbba8299ef'),('6931542274bb331e4','Send Email Reminders',0,'Success','2025-12-04 09:30:00',1090267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:07','2025-12-04 09:30:07',1348927,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:30:07','687bf5d44d3e10813'),('6931542293c857356','Send Email Notifications',0,'Success','2025-12-04 09:30:00',1090268,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:08','2025-12-04 09:30:08',1348927,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:30:08','687bf5d466067a4ba'),('69315422bcddceca4','Process Webhook Queue',0,'Success','2025-12-04 09:30:00',1090269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:08','2025-12-04 09:30:09',1348927,1,NULL,NULL,NULL,'2025-12-04 09:28:02','2025-12-04 09:30:09','687bf5d5788e2fe0e'),('6931545e02b13f828','Submit Popup Reminders',0,'Success','2025-12-04 09:29:02',1090270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:29:04','2025-12-04 09:29:04',1348891,1,NULL,NULL,NULL,'2025-12-04 09:29:02','2025-12-04 09:29:04','687bf57d2f9463790'),('6931545e21cd4bff4','Process Job Queue q0',0,'Success','2025-12-04 09:29:02',1090271,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:29:04','2025-12-04 09:29:04',1348891,1,NULL,NULL,NULL,'2025-12-04 09:29:02','2025-12-04 09:29:04','687bf57d693e0fc1f'),('6931545e68d43f4f8','Process Job Queue q1',0,'Success','2025-12-04 09:30:00',1090272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:09','2025-12-04 09:30:09',1348927,1,NULL,NULL,NULL,'2025-12-04 09:29:02','2025-12-04 09:30:09','687bf57d8afb5c472'),('6931545ecaa07e7fe','Process Job Queue e0',0,'Success','2025-12-04 09:29:02',1090273,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:29:05','2025-12-04 09:29:05',1348891,1,NULL,NULL,NULL,'2025-12-04 09:29:02','2025-12-04 09:29:05','687bf57dbba8299ef'),('69315499d694d8947','Submit Popup Reminders',0,'Success','2025-12-04 09:30:01',1090274,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:10','2025-12-04 09:30:10',1348927,1,NULL,NULL,NULL,'2025-12-04 09:30:01','2025-12-04 09:30:10','687bf57d2f9463790'),('6931549a15146f407','Process Job Queue q0',0,'Success','2025-12-04 09:30:02',1090275,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:11','2025-12-04 09:30:11',1348927,1,NULL,NULL,NULL,'2025-12-04 09:30:02','2025-12-04 09:30:11','687bf57d693e0fc1f'),('6931549a3dc96c2bb','Process Job Queue q1',0,'Success','2025-12-04 09:31:00',1090276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:31:02','2025-12-04 09:31:02',1348966,1,NULL,NULL,NULL,'2025-12-04 09:30:02','2025-12-04 09:31:02','687bf57d8afb5c472'),('6931549a7008dd3b1','Process Job Queue e0',0,'Success','2025-12-04 09:30:02',1090277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:30:12','2025-12-04 09:30:12',1348927,1,NULL,NULL,NULL,'2025-12-04 09:30:02','2025-12-04 09:30:12','687bf57dbba8299ef'),('6931549aa0be3685e','Send Email Reminders',0,'Success','2025-12-04 09:32:00',1090278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:02','2025-12-04 09:32:03',1349001,1,NULL,NULL,NULL,'2025-12-04 09:30:02','2025-12-04 09:32:03','687bf5d44d3e10813'),('6931549ad1e11f620','Send Email Notifications',0,'Success','2025-12-04 09:32:00',1090279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:04','2025-12-04 09:32:04',1349001,1,NULL,NULL,NULL,'2025-12-04 09:30:02','2025-12-04 09:32:04','687bf5d466067a4ba'),('6931549b5cd7900ad','Send Mass Emails',0,'Success','2025-12-04 09:50:00',1090280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:03','2025-12-04 09:50:03',1349756,1,NULL,NULL,NULL,'2025-12-04 09:30:03','2025-12-04 09:50:03','687bf5d4b535f913f'),('6931549b9de54a3c3','Auth Token Control',0,'Success','2025-12-04 09:36:00',1090281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:03','2025-12-04 09:36:04',1349157,1,NULL,NULL,NULL,'2025-12-04 09:30:03','2025-12-04 09:36:04','687bf5d511e08c57f'),('6931549bcfb7748ce','Process Webhook Queue',0,'Success','2025-12-04 09:32:00',1090282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:05','2025-12-04 09:32:05',1349001,1,NULL,NULL,NULL,'2025-12-04 09:30:03','2025-12-04 09:32:05','687bf5d5788e2fe0e'),('6931549c3c7ec4fbf','Send Scheduled Emails',0,'Success','2025-12-04 09:40:00',1090283,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:03','2025-12-04 09:40:04',1349372,1,NULL,NULL,NULL,'2025-12-04 09:30:04','2025-12-04 09:40:04','687bf5d5eeb01d80d'),('693154d56adb95971','Submit Popup Reminders',0,'Success','2025-12-04 09:31:01',1090284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:31:03','2025-12-04 09:31:03',1348966,1,NULL,NULL,NULL,'2025-12-04 09:31:01','2025-12-04 09:31:03','687bf57d2f9463790'),('693154d596e6b5a38','Process Job Queue q0',0,'Success','2025-12-04 09:31:01',1090285,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:31:04','2025-12-04 09:31:04',1348966,1,NULL,NULL,NULL,'2025-12-04 09:31:01','2025-12-04 09:31:04','687bf57d693e0fc1f'),('693154d5ba948d0b5','Process Job Queue q1',0,'Success','2025-12-04 09:32:00',1090286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:06','2025-12-04 09:32:06',1349001,1,NULL,NULL,NULL,'2025-12-04 09:31:01','2025-12-04 09:32:06','687bf57d8afb5c472'),('693154d5efae22862','Process Job Queue e0',0,'Success','2025-12-04 09:31:01',1090287,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:31:05','2025-12-04 09:31:05',1348966,1,NULL,NULL,NULL,'2025-12-04 09:31:01','2025-12-04 09:31:05','687bf57dbba8299ef'),('693155116d6a48880','Submit Popup Reminders',0,'Success','2025-12-04 09:32:01',1090288,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:06','2025-12-04 09:32:07',1349001,1,NULL,NULL,NULL,'2025-12-04 09:32:01','2025-12-04 09:32:07','687bf57d2f9463790'),('6931551193813b7ee','Process Job Queue q0',0,'Success','2025-12-04 09:32:01',1090289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:07','2025-12-04 09:32:08',1349001,1,NULL,NULL,NULL,'2025-12-04 09:32:01','2025-12-04 09:32:08','687bf57d693e0fc1f'),('69315511b3670a9ba','Process Job Queue q1',0,'Success','2025-12-04 09:33:00',1090290,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:33:02','2025-12-04 09:33:02',1349040,1,NULL,NULL,NULL,'2025-12-04 09:32:01','2025-12-04 09:33:02','687bf57d8afb5c472'),('69315511d65354ab8','Process Job Queue e0',0,'Success','2025-12-04 09:32:01',1090291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:32:08','2025-12-04 09:32:08',1349001,1,NULL,NULL,NULL,'2025-12-04 09:32:01','2025-12-04 09:32:08','687bf57dbba8299ef'),('693155120f4e16e0e','Send Email Reminders',0,'Success','2025-12-04 09:34:00',1090292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:04','2025-12-04 09:34:04',1349078,1,NULL,NULL,NULL,'2025-12-04 09:32:02','2025-12-04 09:34:04','687bf5d44d3e10813'),('693155123011dff3f','Send Email Notifications',0,'Success','2025-12-04 09:34:00',1090293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:05','2025-12-04 09:34:05',1349078,1,NULL,NULL,NULL,'2025-12-04 09:32:02','2025-12-04 09:34:05','687bf5d466067a4ba'),('6931551250ef41bf3','Process Webhook Queue',0,'Success','2025-12-04 09:34:00',1090294,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:05','2025-12-04 09:34:05',1349078,1,NULL,NULL,NULL,'2025-12-04 09:32:02','2025-12-04 09:34:05','687bf5d5788e2fe0e'),('6931554dbea27973b','Submit Popup Reminders',0,'Success','2025-12-04 09:33:01',1090295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:33:03','2025-12-04 09:33:03',1349040,1,NULL,NULL,NULL,'2025-12-04 09:33:01','2025-12-04 09:33:03','687bf57d2f9463790'),('6931554de77e589f6','Process Job Queue q0',0,'Success','2025-12-04 09:33:01',1090296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:33:04','2025-12-04 09:33:04',1349040,1,NULL,NULL,NULL,'2025-12-04 09:33:01','2025-12-04 09:33:04','687bf57d693e0fc1f'),('6931554e26afe61bd','Process Job Queue q1',0,'Success','2025-12-04 09:34:00',1090297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:06','2025-12-04 09:34:06',1349078,1,NULL,NULL,NULL,'2025-12-04 09:33:02','2025-12-04 09:34:06','687bf57d8afb5c472'),('6931554e4c638bb82','Process Job Queue e0',0,'Success','2025-12-04 09:33:02',1090298,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:33:05','2025-12-04 09:33:05',1349040,1,NULL,NULL,NULL,'2025-12-04 09:33:02','2025-12-04 09:33:05','687bf57dbba8299ef'),('6931558a19e223e88','Submit Popup Reminders',0,'Success','2025-12-04 09:34:02',1090299,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:06','2025-12-04 09:34:07',1349078,1,NULL,NULL,NULL,'2025-12-04 09:34:02','2025-12-04 09:34:07','687bf57d2f9463790'),('6931558a47f990969','Process Job Queue q0',0,'Success','2025-12-04 09:34:02',1090300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:07','2025-12-04 09:34:07',1349078,1,NULL,NULL,NULL,'2025-12-04 09:34:02','2025-12-04 09:34:07','687bf57d693e0fc1f'),('6931558a76d7663f0','Process Job Queue q1',0,'Success','2025-12-04 09:35:00',1090301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:35:02','2025-12-04 09:35:02',1349113,1,NULL,NULL,NULL,'2025-12-04 09:34:02','2025-12-04 09:35:02','687bf57d8afb5c472'),('6931558a9aa9d31d7','Process Job Queue e0',0,'Success','2025-12-04 09:34:02',1090302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:34:08','2025-12-04 09:34:08',1349078,1,NULL,NULL,NULL,'2025-12-04 09:34:02','2025-12-04 09:34:08','687bf57dbba8299ef'),('6931558ad9ec30250','Send Email Reminders',0,'Success','2025-12-04 09:36:00',1090303,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:04','2025-12-04 09:36:04',1349157,1,NULL,NULL,NULL,'2025-12-04 09:34:02','2025-12-04 09:36:04','687bf5d44d3e10813'),('6931558b8362bbe52','Send Email Notifications',0,'Success','2025-12-04 09:36:00',1090304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:05','2025-12-04 09:36:05',1349157,1,NULL,NULL,NULL,'2025-12-04 09:34:03','2025-12-04 09:36:05','687bf5d466067a4ba'),('6931558bd6fb7e817','Process Webhook Queue',0,'Success','2025-12-04 09:36:00',1090305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:06','2025-12-04 09:36:06',1349157,1,NULL,NULL,NULL,'2025-12-04 09:34:03','2025-12-04 09:36:06','687bf5d5788e2fe0e'),('693155c5d6cdba62e','Submit Popup Reminders',0,'Success','2025-12-04 09:35:01',1090306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:35:04','2025-12-04 09:35:04',1349113,1,NULL,NULL,NULL,'2025-12-04 09:35:01','2025-12-04 09:35:04','687bf57d2f9463790'),('693155c6066768dcc','Process Job Queue q0',0,'Success','2025-12-04 09:35:02',1090307,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:35:05','2025-12-04 09:35:05',1349113,1,NULL,NULL,NULL,'2025-12-04 09:35:02','2025-12-04 09:35:05','687bf57d693e0fc1f'),('693155c6359830706','Process Job Queue q1',0,'Success','2025-12-04 09:36:00',1090308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:07','2025-12-04 09:36:07',1349157,1,NULL,NULL,NULL,'2025-12-04 09:35:02','2025-12-04 09:36:07','687bf57d8afb5c472'),('693155c6552231235','Process Job Queue e0',0,'Success','2025-12-04 09:35:02',1090309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:35:05','2025-12-04 09:35:05',1349113,1,NULL,NULL,NULL,'2025-12-04 09:35:02','2025-12-04 09:35:05','687bf57dbba8299ef'),('69315601c81648914','Submit Popup Reminders',0,'Success','2025-12-04 09:36:01',1090310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:07','2025-12-04 09:36:08',1349157,1,NULL,NULL,NULL,'2025-12-04 09:36:01','2025-12-04 09:36:08','687bf57d2f9463790'),('6931560215b5ce3af','Process Job Queue q0',0,'Success','2025-12-04 09:36:02',1090311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:08','2025-12-04 09:36:08',1349157,1,NULL,NULL,NULL,'2025-12-04 09:36:02','2025-12-04 09:36:08','687bf57d693e0fc1f'),('693156024fb18cf53','Process Job Queue q1',0,'Success','2025-12-04 09:37:00',1090312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:37:02','2025-12-04 09:37:02',1349196,1,NULL,NULL,NULL,'2025-12-04 09:36:02','2025-12-04 09:37:02','687bf57d8afb5c472'),('6931560282c3d547c','Process Job Queue e0',0,'Success','2025-12-04 09:36:02',1090313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:36:09','2025-12-04 09:36:09',1349157,1,NULL,NULL,NULL,'2025-12-04 09:36:02','2025-12-04 09:36:09','687bf57dbba8299ef'),('69315602cf84e8d6b','Send Email Reminders',0,'Success','2025-12-04 09:38:00',1090314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:03','2025-12-04 09:38:03',1349229,1,NULL,NULL,NULL,'2025-12-04 09:36:02','2025-12-04 09:38:03','687bf5d44d3e10813'),('693156032bebd3ec7','Send Email Notifications',0,'Success','2025-12-04 09:38:00',1090315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:04','2025-12-04 09:38:04',1349229,1,NULL,NULL,NULL,'2025-12-04 09:36:03','2025-12-04 09:38:04','687bf5d466067a4ba'),('693156035823c58cf','Auth Token Control',0,'Success','2025-12-04 09:42:00',1090316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:03','2025-12-04 09:42:04',1349448,1,NULL,NULL,NULL,'2025-12-04 09:36:03','2025-12-04 09:42:04','687bf5d511e08c57f'),('69315603896d6b271','Process Webhook Queue',0,'Success','2025-12-04 09:38:00',1090317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:05','2025-12-04 09:38:05',1349229,1,NULL,NULL,NULL,'2025-12-04 09:36:03','2025-12-04 09:38:05','687bf5d5788e2fe0e'),('6931563d57406160f','Submit Popup Reminders',0,'Success','2025-12-04 09:37:01',1090318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:37:02','2025-12-04 09:37:03',1349196,1,NULL,NULL,NULL,'2025-12-04 09:37:01','2025-12-04 09:37:03','687bf57d2f9463790'),('6931563d78b7112dc','Process Job Queue q0',0,'Success','2025-12-04 09:37:01',1090319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:37:03','2025-12-04 09:37:04',1349196,1,NULL,NULL,NULL,'2025-12-04 09:37:01','2025-12-04 09:37:04','687bf57d693e0fc1f'),('6931563da2f9718c3','Process Job Queue q1',0,'Success','2025-12-04 09:38:00',1090320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:06','2025-12-04 09:38:06',1349229,1,NULL,NULL,NULL,'2025-12-04 09:37:01','2025-12-04 09:38:06','687bf57d8afb5c472'),('6931563dcddb8dad3','Process Job Queue e0',0,'Success','2025-12-04 09:37:01',1090321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:37:04','2025-12-04 09:37:05',1349196,1,NULL,NULL,NULL,'2025-12-04 09:37:01','2025-12-04 09:37:05','687bf57dbba8299ef'),('69315679a79a7ecfa','Submit Popup Reminders',0,'Success','2025-12-04 09:38:01',1090322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:07','2025-12-04 09:38:07',1349229,1,NULL,NULL,NULL,'2025-12-04 09:38:01','2025-12-04 09:38:07','687bf57d2f9463790'),('69315679ce64b8a40','Process Job Queue q0',0,'Success','2025-12-04 09:38:01',1090323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:07','2025-12-04 09:38:08',1349229,1,NULL,NULL,NULL,'2025-12-04 09:38:01','2025-12-04 09:38:08','687bf57d693e0fc1f'),('69315679f0a794040','Process Job Queue q1',0,'Success','2025-12-04 09:39:00',1090324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:39:02','2025-12-04 09:39:02',1349312,1,NULL,NULL,NULL,'2025-12-04 09:38:01','2025-12-04 09:39:02','687bf57d8afb5c472'),('6931567a2a43ba3d2','Process Job Queue e0',0,'Success','2025-12-04 09:38:02',1090325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:38:08','2025-12-04 09:38:08',1349229,1,NULL,NULL,NULL,'2025-12-04 09:38:02','2025-12-04 09:38:08','687bf57dbba8299ef'),('6931567a5a57d661b','Send Email Reminders',0,'Success','2025-12-04 09:40:00',1090326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:04','2025-12-04 09:40:04',1349372,1,NULL,NULL,NULL,'2025-12-04 09:38:02','2025-12-04 09:40:04','687bf5d44d3e10813'),('6931567a82c47efd1','Send Email Notifications',0,'Success','2025-12-04 09:40:00',1090327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:05','2025-12-04 09:40:05',1349372,1,NULL,NULL,NULL,'2025-12-04 09:38:02','2025-12-04 09:40:05','687bf5d466067a4ba'),('6931567abca266101','Process Webhook Queue',0,'Success','2025-12-04 09:40:00',1090328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:06','2025-12-04 09:40:06',1349372,1,NULL,NULL,NULL,'2025-12-04 09:38:02','2025-12-04 09:40:06','687bf5d5788e2fe0e'),('693156b5557f98e2d','Submit Popup Reminders',0,'Success','2025-12-04 09:39:01',1090329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:39:03','2025-12-04 09:39:04',1349312,1,NULL,NULL,NULL,'2025-12-04 09:39:01','2025-12-04 09:39:04','687bf57d2f9463790'),('693156b57b128c407','Process Job Queue q0',0,'Success','2025-12-04 09:39:01',1090330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:39:04','2025-12-04 09:39:05',1349312,1,NULL,NULL,NULL,'2025-12-04 09:39:01','2025-12-04 09:39:05','687bf57d693e0fc1f'),('693156b5a5c09b8b4','Process Job Queue q1',0,'Success','2025-12-04 09:40:00',1090331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:07','2025-12-04 09:40:07',1349372,1,NULL,NULL,NULL,'2025-12-04 09:39:01','2025-12-04 09:40:07','687bf57d8afb5c472'),('693156b5d1ac4e458','Process Job Queue e0',0,'Success','2025-12-04 09:39:01',1090332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:39:05','2025-12-04 09:39:05',1349312,1,NULL,NULL,NULL,'2025-12-04 09:39:01','2025-12-04 09:39:05','687bf57dbba8299ef'),('693156f1aea289b9b','Submit Popup Reminders',0,'Success','2025-12-04 09:40:01',1090333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:08','2025-12-04 09:40:08',1349372,1,NULL,NULL,NULL,'2025-12-04 09:40:01','2025-12-04 09:40:08','687bf57d2f9463790'),('693156f1e4b5ee271','Process Job Queue q0',0,'Success','2025-12-04 09:40:01',1090334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:09','2025-12-04 09:40:09',1349372,1,NULL,NULL,NULL,'2025-12-04 09:40:01','2025-12-04 09:40:09','687bf57d693e0fc1f'),('693156f2286370d16','Process Job Queue q1',0,'Success','2025-12-04 09:41:00',1090335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:41:02','2025-12-04 09:41:02',1349409,1,NULL,NULL,NULL,'2025-12-04 09:40:02','2025-12-04 09:41:02','687bf57d8afb5c472'),('693156f2b3e3f7bc3','Process Job Queue e0',0,'Success','2025-12-04 09:40:02',1090336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:40:09','2025-12-04 09:40:10',1349372,1,NULL,NULL,NULL,'2025-12-04 09:40:02','2025-12-04 09:40:10','687bf57dbba8299ef'),('693156f30c7961356','Send Email Reminders',0,'Success','2025-12-04 09:42:00',1090337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:04','2025-12-04 09:42:05',1349448,1,NULL,NULL,NULL,'2025-12-04 09:40:03','2025-12-04 09:42:05','687bf5d44d3e10813'),('693156f338b782dbc','Send Email Notifications',0,'Success','2025-12-04 09:42:00',1090338,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:05','2025-12-04 09:42:05',1349448,1,NULL,NULL,NULL,'2025-12-04 09:40:03','2025-12-04 09:42:05','687bf5d466067a4ba'),('693156f372e5e1d09','Process Webhook Queue',0,'Success','2025-12-04 09:42:00',1090339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:06','2025-12-04 09:42:06',1349448,1,NULL,NULL,NULL,'2025-12-04 09:40:03','2025-12-04 09:42:06','687bf5d5788e2fe0e'),('693156f396b5691ad','Send Scheduled Emails',0,'Success','2025-12-04 09:50:00',1090340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:04','2025-12-04 09:50:04',1349756,1,NULL,NULL,NULL,'2025-12-04 09:40:03','2025-12-04 09:50:04','687bf5d5eeb01d80d'),('6931572d5cb11ea54','Submit Popup Reminders',0,'Success','2025-12-04 09:41:01',1090341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:41:03','2025-12-04 09:41:04',1349409,1,NULL,NULL,NULL,'2025-12-04 09:41:01','2025-12-04 09:41:04','687bf57d2f9463790'),('6931572d8c5abfe1f','Process Job Queue q0',0,'Success','2025-12-04 09:41:01',1090342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:41:04','2025-12-04 09:41:04',1349409,1,NULL,NULL,NULL,'2025-12-04 09:41:01','2025-12-04 09:41:04','687bf57d693e0fc1f'),('6931572db6901da89','Process Job Queue q1',0,'Success','2025-12-04 09:42:00',1090343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:07','2025-12-04 09:42:07',1349448,1,NULL,NULL,NULL,'2025-12-04 09:41:01','2025-12-04 09:42:07','687bf57d8afb5c472'),('6931572e24ae15a38','Process Job Queue e0',0,'Success','2025-12-04 09:41:02',1090344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:41:05','2025-12-04 09:41:05',1349409,1,NULL,NULL,NULL,'2025-12-04 09:41:02','2025-12-04 09:41:05','687bf57dbba8299ef'),('693157696bb52d429','Submit Popup Reminders',0,'Success','2025-12-04 09:42:01',1090345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:08','2025-12-04 09:42:08',1349448,1,NULL,NULL,NULL,'2025-12-04 09:42:01','2025-12-04 09:42:08','687bf57d2f9463790'),('69315769964aa9d31','Process Job Queue q0',0,'Success','2025-12-04 09:42:01',1090346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:09','2025-12-04 09:42:09',1349448,1,NULL,NULL,NULL,'2025-12-04 09:42:01','2025-12-04 09:42:09','687bf57d693e0fc1f'),('69315769bef1b9893','Process Job Queue q1',0,'Success','2025-12-04 09:43:00',1090347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:43:02','2025-12-04 09:43:02',1349484,1,NULL,NULL,NULL,'2025-12-04 09:42:01','2025-12-04 09:43:02','687bf57d8afb5c472'),('69315769e0c7436e6','Process Job Queue e0',0,'Success','2025-12-04 09:42:01',1090348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:42:09','2025-12-04 09:42:10',1349448,1,NULL,NULL,NULL,'2025-12-04 09:42:01','2025-12-04 09:42:10','687bf57dbba8299ef'),('6931576a1e72c9d3e','Send Email Reminders',0,'Success','2025-12-04 09:44:00',1090349,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:03','2025-12-04 09:44:03',1349532,1,NULL,NULL,NULL,'2025-12-04 09:42:02','2025-12-04 09:44:03','687bf5d44d3e10813'),('6931576a5b8086b86','Send Email Notifications',0,'Success','2025-12-04 09:44:00',1090350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:04','2025-12-04 09:44:04',1349532,1,NULL,NULL,NULL,'2025-12-04 09:42:02','2025-12-04 09:44:04','687bf5d466067a4ba'),('6931576b2294c3b85','Auth Token Control',0,'Success','2025-12-04 09:48:00',1090351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:03','2025-12-04 09:48:03',1349689,1,NULL,NULL,NULL,'2025-12-04 09:42:03','2025-12-04 09:48:03','687bf5d511e08c57f'),('6931576b7ab523539','Process Webhook Queue',0,'Success','2025-12-04 09:44:00',1090352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:04','2025-12-04 09:44:04',1349532,1,NULL,NULL,NULL,'2025-12-04 09:42:03','2025-12-04 09:44:04','687bf5d5788e2fe0e'),('693157a5b9f71c832','Submit Popup Reminders',0,'Success','2025-12-04 09:43:01',1090353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:43:03','2025-12-04 09:43:03',1349484,1,NULL,NULL,NULL,'2025-12-04 09:43:01','2025-12-04 09:43:03','687bf57d2f9463790'),('693157a5e048cc79a','Process Job Queue q0',0,'Success','2025-12-04 09:43:01',1090354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:43:04','2025-12-04 09:43:04',1349484,1,NULL,NULL,NULL,'2025-12-04 09:43:01','2025-12-04 09:43:04','687bf57d693e0fc1f'),('693157a6186005f88','Process Job Queue q1',0,'Success','2025-12-04 09:44:00',1090355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:05','2025-12-04 09:44:05',1349532,1,NULL,NULL,NULL,'2025-12-04 09:43:02','2025-12-04 09:44:05','687bf57d8afb5c472'),('693157a632d47b270','Process Job Queue e0',0,'Success','2025-12-04 09:43:02',1090356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:43:05','2025-12-04 09:43:05',1349484,1,NULL,NULL,NULL,'2025-12-04 09:43:02','2025-12-04 09:43:05','687bf57dbba8299ef'),('693157e14f0f4c834','Submit Popup Reminders',0,'Success','2025-12-04 09:44:01',1090357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:06','2025-12-04 09:44:06',1349532,1,NULL,NULL,NULL,'2025-12-04 09:44:01','2025-12-04 09:44:06','687bf57d2f9463790'),('693157e184eefbca4','Process Job Queue q0',0,'Success','2025-12-04 09:44:01',1090358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:06','2025-12-04 09:44:06',1349532,1,NULL,NULL,NULL,'2025-12-04 09:44:01','2025-12-04 09:44:06','687bf57d693e0fc1f'),('693157e23a8873b79','Process Job Queue q1',0,'Success','2025-12-04 09:45:00',1090359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:45:03','2025-12-04 09:45:03',1349570,1,NULL,NULL,NULL,'2025-12-04 09:44:02','2025-12-04 09:45:03','687bf57d8afb5c472'),('693157e274189a0eb','Process Job Queue e0',0,'Success','2025-12-04 09:44:02',1090360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:44:07','2025-12-04 09:44:07',1349532,1,NULL,NULL,NULL,'2025-12-04 09:44:02','2025-12-04 09:44:07','687bf57dbba8299ef'),('693157e2c1151822b','Send Email Reminders',0,'Success','2025-12-04 09:46:00',1090361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:02','2025-12-04 09:46:03',1349606,1,NULL,NULL,NULL,'2025-12-04 09:44:02','2025-12-04 09:46:03','687bf5d44d3e10813'),('693157e30f5c11bc7','Send Email Notifications',0,'Success','2025-12-04 09:46:00',1090362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:03','2025-12-04 09:46:04',1349606,1,NULL,NULL,NULL,'2025-12-04 09:44:03','2025-12-04 09:46:04','687bf5d466067a4ba'),('693157e340bdd6bb9','Process Webhook Queue',0,'Success','2025-12-04 09:46:00',1090363,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:05','2025-12-04 09:46:05',1349606,1,NULL,NULL,NULL,'2025-12-04 09:44:03','2025-12-04 09:46:05','687bf5d5788e2fe0e'),('6931581e2632c5d1e','Submit Popup Reminders',0,'Success','2025-12-04 09:45:02',1090364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:45:04','2025-12-04 09:45:04',1349570,1,NULL,NULL,NULL,'2025-12-04 09:45:02','2025-12-04 09:45:04','687bf57d2f9463790'),('6931581e5301ccd3b','Process Job Queue q0',0,'Success','2025-12-04 09:45:02',1090365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:45:05','2025-12-04 09:45:05',1349570,1,NULL,NULL,NULL,'2025-12-04 09:45:02','2025-12-04 09:45:05','687bf57d693e0fc1f'),('6931581eaa7c61a26','Process Job Queue q1',0,'Success','2025-12-04 09:46:00',1090366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:06','2025-12-04 09:46:06',1349606,1,NULL,NULL,NULL,'2025-12-04 09:45:02','2025-12-04 09:46:06','687bf57d8afb5c472'),('6931581eef8637e3a','Process Job Queue e0',0,'Success','2025-12-04 09:45:02',1090367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:45:05','2025-12-04 09:45:05',1349570,1,NULL,NULL,NULL,'2025-12-04 09:45:02','2025-12-04 09:45:05','687bf57dbba8299ef'),('6931585996c81bfd9','Submit Popup Reminders',0,'Success','2025-12-04 09:46:01',1090368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:07','2025-12-04 09:46:07',1349606,1,NULL,NULL,NULL,'2025-12-04 09:46:01','2025-12-04 09:46:07','687bf57d2f9463790'),('69315859b535f0c70','Process Job Queue q0',0,'Success','2025-12-04 09:46:01',1090369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:07','2025-12-04 09:46:07',1349606,1,NULL,NULL,NULL,'2025-12-04 09:46:01','2025-12-04 09:46:07','687bf57d693e0fc1f'),('69315859d206cde78','Process Job Queue q1',0,'Success','2025-12-04 09:47:00',1090370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:47:03','2025-12-04 09:47:03',1349651,1,NULL,NULL,NULL,'2025-12-04 09:46:01','2025-12-04 09:47:03','687bf57d8afb5c472'),('69315859f3c6009e6','Process Job Queue e0',0,'Success','2025-12-04 09:46:01',1090371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:46:08','2025-12-04 09:46:08',1349606,1,NULL,NULL,NULL,'2025-12-04 09:46:01','2025-12-04 09:46:08','687bf57dbba8299ef'),('6931585a26b6e39f9','Send Email Reminders',0,'Success','2025-12-04 09:48:00',1090372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:04','2025-12-04 09:48:04',1349689,1,NULL,NULL,NULL,'2025-12-04 09:46:02','2025-12-04 09:48:04','687bf5d44d3e10813'),('6931585a41b749eb3','Send Email Notifications',0,'Success','2025-12-04 09:48:00',1090373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:05','2025-12-04 09:48:05',1349689,1,NULL,NULL,NULL,'2025-12-04 09:46:02','2025-12-04 09:48:05','687bf5d466067a4ba'),('6931585a791d4dce7','Process Webhook Queue',0,'Success','2025-12-04 09:48:00',1090374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:06','2025-12-04 09:48:06',1349689,1,NULL,NULL,NULL,'2025-12-04 09:46:02','2025-12-04 09:48:06','687bf5d5788e2fe0e'),('69315895a65c89704','Submit Popup Reminders',0,'Success','2025-12-04 09:47:01',1090375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:47:04','2025-12-04 09:47:04',1349651,1,NULL,NULL,NULL,'2025-12-04 09:47:01','2025-12-04 09:47:04','687bf57d2f9463790'),('69315895d54d52195','Process Job Queue q0',0,'Success','2025-12-04 09:47:01',1090376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:47:04','2025-12-04 09:47:05',1349651,1,NULL,NULL,NULL,'2025-12-04 09:47:01','2025-12-04 09:47:05','687bf57d693e0fc1f'),('693158961ed7aa797','Process Job Queue q1',0,'Success','2025-12-04 09:48:00',1090377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:07','2025-12-04 09:48:07',1349689,1,NULL,NULL,NULL,'2025-12-04 09:47:02','2025-12-04 09:48:07','687bf57d8afb5c472'),('69315896785998167','Process Job Queue e0',0,'Success','2025-12-04 09:47:02',1090378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:47:05','2025-12-04 09:47:05',1349651,1,NULL,NULL,NULL,'2025-12-04 09:47:02','2025-12-04 09:47:05','687bf57dbba8299ef'),('693158d14fbcd5f5a','Submit Popup Reminders',0,'Success','2025-12-04 09:48:01',1090379,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:08','2025-12-04 09:48:08',1349689,1,NULL,NULL,NULL,'2025-12-04 09:48:01','2025-12-04 09:48:08','687bf57d2f9463790'),('693158d172b61bf00','Process Job Queue q0',0,'Success','2025-12-04 09:48:01',1090380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:08','2025-12-04 09:48:09',1349689,1,NULL,NULL,NULL,'2025-12-04 09:48:01','2025-12-04 09:48:09','687bf57d693e0fc1f'),('693158d199d26ffca','Process Job Queue q1',0,'Success','2025-12-04 09:49:00',1090381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:49:02','2025-12-04 09:49:02',1349724,1,NULL,NULL,NULL,'2025-12-04 09:48:01','2025-12-04 09:49:02','687bf57d8afb5c472'),('693158d1bda72d86c','Process Job Queue e0',0,'Success','2025-12-04 09:48:01',1090382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:48:09','2025-12-04 09:48:09',1349689,1,NULL,NULL,NULL,'2025-12-04 09:48:01','2025-12-04 09:48:09','687bf57dbba8299ef'),('693158d1e51c787e3','Send Email Reminders',0,'Success','2025-12-04 09:50:00',1090383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:05','2025-12-04 09:50:05',1349756,1,NULL,NULL,NULL,'2025-12-04 09:48:01','2025-12-04 09:50:05','687bf5d44d3e10813'),('693158d225b866c81','Send Email Notifications',0,'Success','2025-12-04 09:50:00',1090384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:06','2025-12-04 09:50:06',1349756,1,NULL,NULL,NULL,'2025-12-04 09:48:02','2025-12-04 09:50:06','687bf5d466067a4ba'),('693158d274221cfd1','Auth Token Control',0,'Success','2025-12-04 09:54:00',1090385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:04','2025-12-04 09:54:04',1349905,1,NULL,NULL,NULL,'2025-12-04 09:48:02','2025-12-04 09:54:04','687bf5d511e08c57f'),('693158d2a8f86044e','Process Webhook Queue',0,'Success','2025-12-04 09:50:00',1090386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:06','2025-12-04 09:50:06',1349756,1,NULL,NULL,NULL,'2025-12-04 09:48:02','2025-12-04 09:50:06','687bf5d5788e2fe0e'),('6931590db4c17c74b','Submit Popup Reminders',0,'Success','2025-12-04 09:49:01',1090387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:49:03','2025-12-04 09:49:03',1349724,1,NULL,NULL,NULL,'2025-12-04 09:49:01','2025-12-04 09:49:03','687bf57d2f9463790'),('6931590ddcaa496fb','Process Job Queue q0',0,'Success','2025-12-04 09:49:01',1090388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:49:04','2025-12-04 09:49:04',1349724,1,NULL,NULL,NULL,'2025-12-04 09:49:01','2025-12-04 09:49:04','687bf57d693e0fc1f'),('6931590e225fcfd67','Process Job Queue q1',0,'Success','2025-12-04 09:50:00',1090389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:07','2025-12-04 09:50:07',1349756,1,NULL,NULL,NULL,'2025-12-04 09:49:02','2025-12-04 09:50:07','687bf57d8afb5c472'),('6931590e63ab7d0fd','Process Job Queue e0',0,'Success','2025-12-04 09:49:02',1090390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:49:05','2025-12-04 09:49:05',1349724,1,NULL,NULL,NULL,'2025-12-04 09:49:02','2025-12-04 09:49:05','687bf57dbba8299ef'),('693159495af26cd2d','Submit Popup Reminders',0,'Success','2025-12-04 09:50:01',1090391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:08','2025-12-04 09:50:08',1349756,1,NULL,NULL,NULL,'2025-12-04 09:50:01','2025-12-04 09:50:08','687bf57d2f9463790'),('69315949994ec8883','Process Job Queue q0',0,'Success','2025-12-04 09:50:01',1090392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:08','2025-12-04 09:50:08',1349756,1,NULL,NULL,NULL,'2025-12-04 09:50:01','2025-12-04 09:50:08','687bf57d693e0fc1f'),('69315949cea94bbf9','Process Job Queue q1',0,'Success','2025-12-04 09:51:00',1090393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:51:03','2025-12-04 09:51:03',1349795,1,NULL,NULL,NULL,'2025-12-04 09:50:01','2025-12-04 09:51:03','687bf57d8afb5c472'),('6931594a0f930b831','Process Job Queue e0',0,'Success','2025-12-04 09:50:02',1090394,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:50:09','2025-12-04 09:50:09',1349756,1,NULL,NULL,NULL,'2025-12-04 09:50:02','2025-12-04 09:50:09','687bf57dbba8299ef'),('6931594abe0c28a04','Send Email Reminders',0,'Success','2025-12-04 09:52:00',1090395,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:03','2025-12-04 09:52:03',1349833,1,NULL,NULL,NULL,'2025-12-04 09:50:02','2025-12-04 09:52:03','687bf5d44d3e10813'),('6931594ae64577060','Send Email Notifications',0,'Success','2025-12-04 09:52:00',1090396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:04','2025-12-04 09:52:04',1349833,1,NULL,NULL,NULL,'2025-12-04 09:50:02','2025-12-04 09:52:04','687bf5d466067a4ba'),('6931594b1dd5dcc63','Send Mass Emails',0,'Success','2025-12-04 10:10:00',1090397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:04','2025-12-04 10:10:04',1350322,1,NULL,NULL,NULL,'2025-12-04 09:50:03','2025-12-04 10:10:04','687bf5d4b535f913f'),('6931594b473acf7e7','Process Webhook Queue',0,'Success','2025-12-04 09:52:00',1090398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:04','2025-12-04 09:52:05',1349833,1,NULL,NULL,NULL,'2025-12-04 09:50:03','2025-12-04 09:52:05','687bf5d5788e2fe0e'),('6931594b72c3142d4','Send Scheduled Emails',0,'Success','2025-12-04 10:00:00',1090399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:04','2025-12-04 10:00:04',1350089,1,NULL,NULL,NULL,'2025-12-04 09:50:03','2025-12-04 10:00:04','687bf5d5eeb01d80d'),('69315985e5fb0398d','Submit Popup Reminders',0,'Success','2025-12-04 09:51:01',1090400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:51:04','2025-12-04 09:51:04',1349795,1,NULL,NULL,NULL,'2025-12-04 09:51:01','2025-12-04 09:51:04','687bf57d2f9463790'),('693159861cbf6d7b3','Process Job Queue q0',0,'Success','2025-12-04 09:51:02',1090401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:51:05','2025-12-04 09:51:05',1349795,1,NULL,NULL,NULL,'2025-12-04 09:51:02','2025-12-04 09:51:05','687bf57d693e0fc1f'),('693159863e2acb9ee','Process Job Queue q1',0,'Success','2025-12-04 09:52:00',1090402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:05','2025-12-04 09:52:05',1349833,1,NULL,NULL,NULL,'2025-12-04 09:51:02','2025-12-04 09:52:05','687bf57d8afb5c472'),('69315986e4125e973','Process Job Queue e0',0,'Success','2025-12-04 09:51:02',1090403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:51:05','2025-12-04 09:51:06',1349795,1,NULL,NULL,NULL,'2025-12-04 09:51:02','2025-12-04 09:51:06','687bf57dbba8299ef'),('693159c19ce98d9ce','Submit Popup Reminders',0,'Success','2025-12-04 09:52:01',1090404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:06','2025-12-04 09:52:06',1349833,1,NULL,NULL,NULL,'2025-12-04 09:52:01','2025-12-04 09:52:06','687bf57d2f9463790'),('693159c1bd650b594','Process Job Queue q0',0,'Success','2025-12-04 09:52:01',1090405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:06','2025-12-04 09:52:06',1349833,1,NULL,NULL,NULL,'2025-12-04 09:52:01','2025-12-04 09:52:06','687bf57d693e0fc1f'),('693159c1ec7bbb00e','Process Job Queue q1',0,'Success','2025-12-04 09:53:00',1090406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:53:02','2025-12-04 09:53:02',1349868,1,NULL,NULL,NULL,'2025-12-04 09:52:01','2025-12-04 09:53:02','687bf57d8afb5c472'),('693159c22700bbd36','Process Job Queue e0',0,'Success','2025-12-04 09:52:02',1090407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:52:07','2025-12-04 09:52:07',1349833,1,NULL,NULL,NULL,'2025-12-04 09:52:02','2025-12-04 09:52:07','687bf57dbba8299ef'),('693159c2799fdfd1b','Send Email Reminders',0,'Success','2025-12-04 09:54:00',1090408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:05','2025-12-04 09:54:05',1349905,1,NULL,NULL,NULL,'2025-12-04 09:52:02','2025-12-04 09:54:05','687bf5d44d3e10813'),('693159c2c032c5758','Send Email Notifications',0,'Success','2025-12-04 09:54:00',1090409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:06','2025-12-04 09:54:06',1349905,1,NULL,NULL,NULL,'2025-12-04 09:52:02','2025-12-04 09:54:06','687bf5d466067a4ba'),('693159c354de9bf74','Process Webhook Queue',0,'Success','2025-12-04 09:54:00',1090410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:07','2025-12-04 09:54:07',1349905,1,NULL,NULL,NULL,'2025-12-04 09:52:03','2025-12-04 09:54:07','687bf5d5788e2fe0e'),('693159fe23b4bd817','Submit Popup Reminders',0,'Success','2025-12-04 09:53:02',1090411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:53:04','2025-12-04 09:53:04',1349868,1,NULL,NULL,NULL,'2025-12-04 09:53:02','2025-12-04 09:53:04','687bf57d2f9463790'),('693159fe407074179','Process Job Queue q0',0,'Success','2025-12-04 09:53:02',1090412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:53:05','2025-12-04 09:53:05',1349868,1,NULL,NULL,NULL,'2025-12-04 09:53:02','2025-12-04 09:53:05','687bf57d693e0fc1f'),('693159fe635027928','Process Job Queue q1',0,'Success','2025-12-04 09:54:00',1090413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:08','2025-12-04 09:54:08',1349905,1,NULL,NULL,NULL,'2025-12-04 09:53:02','2025-12-04 09:54:08','687bf57d8afb5c472'),('693159fe8a1ca8d21','Process Job Queue e0',0,'Success','2025-12-04 09:53:02',1090414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:53:06','2025-12-04 09:53:06',1349868,1,NULL,NULL,NULL,'2025-12-04 09:53:02','2025-12-04 09:53:06','687bf57dbba8299ef'),('69315a3a0190408e3','Submit Popup Reminders',0,'Success','2025-12-04 09:54:02',1090415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:08','2025-12-04 09:54:08',1349905,1,NULL,NULL,NULL,'2025-12-04 09:54:02','2025-12-04 09:54:08','687bf57d2f9463790'),('69315a3a345846031','Process Job Queue q0',0,'Success','2025-12-04 09:54:02',1090416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:09','2025-12-04 09:54:09',1349905,1,NULL,NULL,NULL,'2025-12-04 09:54:02','2025-12-04 09:54:09','687bf57d693e0fc1f'),('69315a3a6f06dbe46','Process Job Queue q1',0,'Success','2025-12-04 09:55:00',1090417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:55:01','2025-12-04 09:55:02',1349940,1,NULL,NULL,NULL,'2025-12-04 09:54:02','2025-12-04 09:55:02','687bf57d8afb5c472'),('69315a3ab9957bd68','Process Job Queue e0',0,'Success','2025-12-04 09:54:02',1090418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:54:10','2025-12-04 09:54:10',1349905,1,NULL,NULL,NULL,'2025-12-04 09:54:02','2025-12-04 09:54:10','687bf57dbba8299ef'),('69315a3b101a5f458','Send Email Reminders',0,'Success','2025-12-04 09:56:00',1090419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:03','2025-12-04 09:56:04',1349980,1,NULL,NULL,NULL,'2025-12-04 09:54:03','2025-12-04 09:56:04','687bf5d44d3e10813'),('69315a3b5ef4033d7','Send Email Notifications',0,'Success','2025-12-04 09:56:00',1090420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:04','2025-12-04 09:56:05',1349980,1,NULL,NULL,NULL,'2025-12-04 09:54:03','2025-12-04 09:56:05','687bf5d466067a4ba'),('69315a3bc96adaca7','Auth Token Control',0,'Success','2025-12-04 10:00:00',1090421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:05','2025-12-04 10:00:05',1350089,1,NULL,NULL,NULL,'2025-12-04 09:54:03','2025-12-04 10:00:05','687bf5d511e08c57f'),('69315a3c1e7ea39ed','Process Webhook Queue',0,'Success','2025-12-04 09:56:00',1090422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:05','2025-12-04 09:56:06',1349980,1,NULL,NULL,NULL,'2025-12-04 09:54:04','2025-12-04 09:56:06','687bf5d5788e2fe0e'),('69315a75459b555fe','Submit Popup Reminders',0,'Success','2025-12-04 09:55:01',1090423,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:55:03','2025-12-04 09:55:03',1349940,1,NULL,NULL,NULL,'2025-12-04 09:55:01','2025-12-04 09:55:03','687bf57d2f9463790'),('69315a756a80ba6d4','Process Job Queue q0',0,'Success','2025-12-04 09:55:01',1090424,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:55:04','2025-12-04 09:55:04',1349940,1,NULL,NULL,NULL,'2025-12-04 09:55:01','2025-12-04 09:55:04','687bf57d693e0fc1f'),('69315a75915512299','Process Job Queue q1',0,'Success','2025-12-04 09:56:00',1090425,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:06','2025-12-04 09:56:06',1349980,1,NULL,NULL,NULL,'2025-12-04 09:55:01','2025-12-04 09:56:06','687bf57d8afb5c472'),('69315a75b947be505','Process Job Queue e0',0,'Success','2025-12-04 09:55:01',1090426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:55:04','2025-12-04 09:55:05',1349940,1,NULL,NULL,NULL,'2025-12-04 09:55:01','2025-12-04 09:55:05','687bf57dbba8299ef'),('69315ab20c7248f62','Submit Popup Reminders',0,'Success','2025-12-04 09:56:02',1090427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:07','2025-12-04 09:56:07',1349980,1,NULL,NULL,NULL,'2025-12-04 09:56:02','2025-12-04 09:56:07','687bf57d2f9463790'),('69315ab22c5f11774','Process Job Queue q0',0,'Success','2025-12-04 09:56:02',1090428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:08','2025-12-04 09:56:08',1349980,1,NULL,NULL,NULL,'2025-12-04 09:56:02','2025-12-04 09:56:08','687bf57d693e0fc1f'),('69315ab248fb6131a','Process Job Queue q1',0,'Success','2025-12-04 09:57:00',1090429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:57:02','2025-12-04 09:57:02',1350038,1,NULL,NULL,NULL,'2025-12-04 09:56:02','2025-12-04 09:57:02','687bf57d8afb5c472'),('69315ab268c8918d8','Process Job Queue e0',0,'Success','2025-12-04 09:56:02',1090430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:56:08','2025-12-04 09:56:08',1349980,1,NULL,NULL,NULL,'2025-12-04 09:56:02','2025-12-04 09:56:08','687bf57dbba8299ef'),('69315ab2a16757d8c','Send Email Reminders',0,'Success','2025-12-04 09:58:00',1090431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:02','2025-12-04 09:58:03',1350054,1,NULL,NULL,NULL,'2025-12-04 09:56:02','2025-12-04 09:58:03','687bf5d44d3e10813'),('69315ab309f5845b0','Send Email Notifications',0,'Success','2025-12-04 09:58:00',1090432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:03','2025-12-04 09:58:04',1350054,1,NULL,NULL,NULL,'2025-12-04 09:56:03','2025-12-04 09:58:04','687bf5d466067a4ba'),('69315ab359f46f9f3','Process Webhook Queue',0,'Success','2025-12-04 09:58:00',1090433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:04','2025-12-04 09:58:04',1350054,1,NULL,NULL,NULL,'2025-12-04 09:56:03','2025-12-04 09:58:04','687bf5d5788e2fe0e'),('69315aed5e907fcef','Submit Popup Reminders',0,'Success','2025-12-04 09:57:01',1090434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:57:03','2025-12-04 09:57:03',1350038,1,NULL,NULL,NULL,'2025-12-04 09:57:01','2025-12-04 09:57:03','687bf57d2f9463790'),('69315aed8a11da411','Process Job Queue q0',0,'Success','2025-12-04 09:57:01',1090435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:57:04','2025-12-04 09:57:04',1350038,1,NULL,NULL,NULL,'2025-12-04 09:57:01','2025-12-04 09:57:04','687bf57d693e0fc1f'),('69315aeda6b2700e5','Process Job Queue q1',0,'Success','2025-12-04 09:58:00',1090436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:05','2025-12-04 09:58:05',1350054,1,NULL,NULL,NULL,'2025-12-04 09:57:01','2025-12-04 09:58:05','687bf57d8afb5c472'),('69315aedcec475d40','Process Job Queue e0',0,'Success','2025-12-04 09:57:01',1090437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:57:05','2025-12-04 09:57:05',1350038,1,NULL,NULL,NULL,'2025-12-04 09:57:01','2025-12-04 09:57:05','687bf57dbba8299ef'),('69315b2932c868aaf','Submit Popup Reminders',0,'Success','2025-12-04 09:58:01',1090438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:05','2025-12-04 09:58:06',1350054,1,NULL,NULL,NULL,'2025-12-04 09:58:01','2025-12-04 09:58:06','687bf57d2f9463790'),('69315b2957f83b410','Process Job Queue q0',0,'Success','2025-12-04 09:58:01',1090439,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:06','2025-12-04 09:58:06',1350054,1,NULL,NULL,NULL,'2025-12-04 09:58:01','2025-12-04 09:58:06','687bf57d693e0fc1f'),('69315b297abfabc8b','Process Job Queue q1',0,'Success','2025-12-04 09:59:00',1090440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:59:03','2025-12-04 09:59:03',1350072,1,NULL,NULL,NULL,'2025-12-04 09:58:01','2025-12-04 09:59:03','687bf57d8afb5c472'),('69315b29b35e7709e','Process Job Queue e0',0,'Success','2025-12-04 09:58:01',1090441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:58:07','2025-12-04 09:58:07',1350054,1,NULL,NULL,NULL,'2025-12-04 09:58:01','2025-12-04 09:58:07','687bf57dbba8299ef'),('69315b29e23c07ea0','Send Email Reminders',0,'Success','2025-12-04 10:00:00',1090442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:05','2025-12-04 10:00:06',1350089,1,NULL,NULL,NULL,'2025-12-04 09:58:01','2025-12-04 10:00:06','687bf5d44d3e10813'),('69315b2a3dd7ba4e2','Send Email Notifications',0,'Success','2025-12-04 10:00:00',1090443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:06','2025-12-04 10:00:06',1350089,1,NULL,NULL,NULL,'2025-12-04 09:58:02','2025-12-04 10:00:06','687bf5d466067a4ba'),('69315b2a9996e4b6b','Process Webhook Queue',0,'Success','2025-12-04 10:00:00',1090444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:07','2025-12-04 10:00:07',1350089,1,NULL,NULL,NULL,'2025-12-04 09:58:02','2025-12-04 10:00:07','687bf5d5788e2fe0e'),('69315b660140648b6','Submit Popup Reminders',0,'Success','2025-12-04 09:59:02',1090445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:59:04','2025-12-04 09:59:04',1350072,1,NULL,NULL,NULL,'2025-12-04 09:59:02','2025-12-04 09:59:04','687bf57d2f9463790'),('69315b6627978aa0e','Process Job Queue q0',0,'Success','2025-12-04 09:59:02',1090446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:59:05','2025-12-04 09:59:05',1350072,1,NULL,NULL,NULL,'2025-12-04 09:59:02','2025-12-04 09:59:05','687bf57d693e0fc1f'),('69315b6658c4102fe','Process Job Queue q1',0,'Success','2025-12-04 10:00:00',1090447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:08','2025-12-04 10:00:08',1350089,1,NULL,NULL,NULL,'2025-12-04 09:59:02','2025-12-04 10:00:08','687bf57d8afb5c472'),('69315b6692e586d3c','Process Job Queue e0',0,'Success','2025-12-04 09:59:02',1090448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 09:59:05','2025-12-04 09:59:05',1350072,1,NULL,NULL,NULL,'2025-12-04 09:59:02','2025-12-04 09:59:05','687bf57dbba8299ef'),('69315ba2206a04aef','Submit Popup Reminders',0,'Success','2025-12-04 10:00:02',1090449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:08','2025-12-04 10:00:08',1350089,1,NULL,NULL,NULL,'2025-12-04 10:00:02','2025-12-04 10:00:08','687bf57d2f9463790'),('69315ba252c296ea2','Process Job Queue q0',0,'Success','2025-12-04 10:00:02',1090450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:09','2025-12-04 10:00:09',1350089,1,NULL,NULL,NULL,'2025-12-04 10:00:02','2025-12-04 10:00:09','687bf57d693e0fc1f'),('69315ba283e8ef3e2','Process Job Queue q1',0,'Success','2025-12-04 10:01:00',1090451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:01:02','2025-12-04 10:01:02',1350104,1,NULL,NULL,NULL,'2025-12-04 10:00:02','2025-12-04 10:01:02','687bf57d8afb5c472'),('69315ba3279b3af07','Process Job Queue e0',0,'Success','2025-12-04 10:00:03',1090452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:00:09','2025-12-04 10:00:09',1350089,1,NULL,NULL,NULL,'2025-12-04 10:00:03','2025-12-04 10:00:09','687bf57dbba8299ef'),('69315ba37f3dc140e','Send Email Reminders',0,'Success','2025-12-04 10:02:00',1090453,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:02','2025-12-04 10:02:03',1350121,1,NULL,NULL,NULL,'2025-12-04 10:00:03','2025-12-04 10:02:03','687bf5d44d3e10813'),('69315ba3cb5bac15f','Send Email Notifications',0,'Success','2025-12-04 10:02:00',1090454,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:04','2025-12-04 10:02:04',1350121,1,NULL,NULL,NULL,'2025-12-04 10:00:03','2025-12-04 10:02:04','687bf5d466067a4ba'),('69315ba413cf5010d','Auth Token Control',0,'Success','2025-12-04 10:06:00',1090455,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:04','2025-12-04 10:06:04',1350182,1,NULL,NULL,NULL,'2025-12-04 10:00:04','2025-12-04 10:06:04','687bf5d511e08c57f'),('69315ba4461ebc9a3','Process Webhook Queue',0,'Success','2025-12-04 10:02:00',1090456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:05','2025-12-04 10:02:05',1350121,1,NULL,NULL,NULL,'2025-12-04 10:00:04','2025-12-04 10:02:05','687bf5d5788e2fe0e'),('69315ba46a14ec9bd','Send Scheduled Emails',0,'Success','2025-12-04 10:10:00',1090457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:04','2025-12-04 10:10:05',1350322,1,NULL,NULL,NULL,'2025-12-04 10:00:04','2025-12-04 10:10:05','687bf5d5eeb01d80d'),('69315bdd3821e46e5','Submit Popup Reminders',0,'Success','2025-12-04 10:01:01',1090458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:01:03','2025-12-04 10:01:03',1350104,1,NULL,NULL,NULL,'2025-12-04 10:01:01','2025-12-04 10:01:03','687bf57d2f9463790'),('69315bdda9850d12a','Process Job Queue q0',0,'Success','2025-12-04 10:01:01',1090459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:01:04','2025-12-04 10:01:05',1350104,1,NULL,NULL,NULL,'2025-12-04 10:01:01','2025-12-04 10:01:05','687bf57d693e0fc1f'),('69315bdde353f2a1d','Process Job Queue q1',0,'Success','2025-12-04 10:02:00',1090460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:06','2025-12-04 10:02:06',1350121,1,NULL,NULL,NULL,'2025-12-04 10:01:01','2025-12-04 10:02:06','687bf57d8afb5c472'),('69315bde23f156cf0','Process Job Queue e0',0,'Success','2025-12-04 10:01:02',1090461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:01:05','2025-12-04 10:01:05',1350104,1,NULL,NULL,NULL,'2025-12-04 10:01:02','2025-12-04 10:01:05','687bf57dbba8299ef'),('69315c196d91f4fde','Submit Popup Reminders',0,'Success','2025-12-04 10:02:01',1090462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:07','2025-12-04 10:02:07',1350121,1,NULL,NULL,NULL,'2025-12-04 10:02:01','2025-12-04 10:02:07','687bf57d2f9463790'),('69315c199988a6b42','Process Job Queue q0',0,'Success','2025-12-04 10:02:01',1090463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:08','2025-12-04 10:02:08',1350121,1,NULL,NULL,NULL,'2025-12-04 10:02:01','2025-12-04 10:02:08','687bf57d693e0fc1f'),('69315c19b692af692','Process Job Queue q1',0,'Success','2025-12-04 10:03:00',1090464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:03:02','2025-12-04 10:03:03',1350136,1,NULL,NULL,NULL,'2025-12-04 10:02:01','2025-12-04 10:03:03','687bf57d8afb5c472'),('69315c19dab25155f','Process Job Queue e0',0,'Success','2025-12-04 10:02:01',1090465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:02:08','2025-12-04 10:02:09',1350121,1,NULL,NULL,NULL,'2025-12-04 10:02:01','2025-12-04 10:02:09','687bf57dbba8299ef'),('69315c1a08b78d884','Send Email Reminders',0,'Success','2025-12-04 10:04:00',1090466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:03','2025-12-04 10:04:03',1350151,1,NULL,NULL,NULL,'2025-12-04 10:02:02','2025-12-04 10:04:03','687bf5d44d3e10813'),('69315c1a3045d6ec2','Send Email Notifications',0,'Success','2025-12-04 10:04:00',1090467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:04','2025-12-04 10:04:04',1350151,1,NULL,NULL,NULL,'2025-12-04 10:02:02','2025-12-04 10:04:04','687bf5d466067a4ba'),('69315c1a6f1ccbecf','Process Webhook Queue',0,'Success','2025-12-04 10:04:00',1090468,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:04','2025-12-04 10:04:05',1350151,1,NULL,NULL,NULL,'2025-12-04 10:02:02','2025-12-04 10:04:05','687bf5d5788e2fe0e'),('69315c55ef1cd9407','Submit Popup Reminders',0,'Success','2025-12-04 10:03:01',1090469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:03:04','2025-12-04 10:03:04',1350136,1,NULL,NULL,NULL,'2025-12-04 10:03:01','2025-12-04 10:03:04','687bf57d2f9463790'),('69315c562843d8740','Process Job Queue q0',0,'Success','2025-12-04 10:03:02',1090470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:03:05','2025-12-04 10:03:05',1350136,1,NULL,NULL,NULL,'2025-12-04 10:03:02','2025-12-04 10:03:05','687bf57d693e0fc1f'),('69315c5650813feae','Process Job Queue q1',0,'Success','2025-12-04 10:04:00',1090471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:05','2025-12-04 10:04:05',1350151,1,NULL,NULL,NULL,'2025-12-04 10:03:02','2025-12-04 10:04:05','687bf57d8afb5c472'),('69315c567abcdb765','Process Job Queue e0',0,'Success','2025-12-04 10:03:02',1090472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:03:06','2025-12-04 10:03:06',1350136,1,NULL,NULL,NULL,'2025-12-04 10:03:02','2025-12-04 10:03:06','687bf57dbba8299ef'),('69315c91a801a1067','Submit Popup Reminders',0,'Success','2025-12-04 10:04:01',1090473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:06','2025-12-04 10:04:06',1350151,1,NULL,NULL,NULL,'2025-12-04 10:04:01','2025-12-04 10:04:06','687bf57d2f9463790'),('69315c91d449a4ecd','Process Job Queue q0',0,'Success','2025-12-04 10:04:01',1090474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:07','2025-12-04 10:04:07',1350151,1,NULL,NULL,NULL,'2025-12-04 10:04:01','2025-12-04 10:04:07','687bf57d693e0fc1f'),('69315c92092c0adad','Process Job Queue q1',0,'Success','2025-12-04 10:05:00',1090475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:05:02','2025-12-04 10:05:03',1350166,1,NULL,NULL,NULL,'2025-12-04 10:04:02','2025-12-04 10:05:03','687bf57d8afb5c472'),('69315c92351276526','Process Job Queue e0',0,'Success','2025-12-04 10:04:02',1090476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:04:07','2025-12-04 10:04:07',1350151,1,NULL,NULL,NULL,'2025-12-04 10:04:02','2025-12-04 10:04:07','687bf57dbba8299ef'),('69315c9276f64c906','Send Email Reminders',0,'Success','2025-12-04 10:06:00',1090477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:04','2025-12-04 10:06:05',1350182,1,NULL,NULL,NULL,'2025-12-04 10:04:02','2025-12-04 10:06:05','687bf5d44d3e10813'),('69315c92a7eadd482','Send Email Notifications',0,'Success','2025-12-04 10:06:00',1090478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:05','2025-12-04 10:06:05',1350182,1,NULL,NULL,NULL,'2025-12-04 10:04:02','2025-12-04 10:06:05','687bf5d466067a4ba'),('69315c9305a5177d2','Process Webhook Queue',0,'Success','2025-12-04 10:06:00',1090479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:06','2025-12-04 10:06:06',1350182,1,NULL,NULL,NULL,'2025-12-04 10:04:03','2025-12-04 10:06:06','687bf5d5788e2fe0e'),('69315ccdb9359ab9c','Submit Popup Reminders',0,'Success','2025-12-04 10:05:01',1090480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:05:03','2025-12-04 10:05:04',1350166,1,NULL,NULL,NULL,'2025-12-04 10:05:01','2025-12-04 10:05:04','687bf57d2f9463790'),('69315ccdefa58d2dd','Process Job Queue q0',0,'Success','2025-12-04 10:05:01',1090481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:05:04','2025-12-04 10:05:05',1350166,1,NULL,NULL,NULL,'2025-12-04 10:05:01','2025-12-04 10:05:05','687bf57d693e0fc1f'),('69315cce1ebacfa3b','Process Job Queue q1',0,'Success','2025-12-04 10:06:00',1090482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:07','2025-12-04 10:06:07',1350182,1,NULL,NULL,NULL,'2025-12-04 10:05:02','2025-12-04 10:06:07','687bf57d8afb5c472'),('69315cce59d6b094b','Process Job Queue e0',0,'Success','2025-12-04 10:05:02',1090483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:05:05','2025-12-04 10:05:05',1350166,1,NULL,NULL,NULL,'2025-12-04 10:05:02','2025-12-04 10:05:05','687bf57dbba8299ef'),('69315d0a0df2edebd','Submit Popup Reminders',0,'Success','2025-12-04 10:06:02',1090484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:08','2025-12-04 10:06:08',1350182,1,NULL,NULL,NULL,'2025-12-04 10:06:02','2025-12-04 10:06:08','687bf57d2f9463790'),('69315d0a368534d74','Process Job Queue q0',0,'Success','2025-12-04 10:06:02',1090485,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:08','2025-12-04 10:06:08',1350182,1,NULL,NULL,NULL,'2025-12-04 10:06:02','2025-12-04 10:06:08','687bf57d693e0fc1f'),('69315d0a5dc8ef7a5','Process Job Queue q1',0,'Success','2025-12-04 10:07:00',1090486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:07:03','2025-12-04 10:07:03',1350199,1,NULL,NULL,NULL,'2025-12-04 10:06:02','2025-12-04 10:07:03','687bf57d8afb5c472'),('69315d0a9fee29a65','Process Job Queue e0',0,'Success','2025-12-04 10:06:02',1090487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:06:09','2025-12-04 10:06:09',1350182,1,NULL,NULL,NULL,'2025-12-04 10:06:02','2025-12-04 10:06:09','687bf57dbba8299ef'),('69315d0b1dcfaa149','Send Email Reminders',0,'Success','2025-12-04 10:08:00',1090488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:03','2025-12-04 10:08:03',1350223,1,NULL,NULL,NULL,'2025-12-04 10:06:03','2025-12-04 10:08:03','687bf5d44d3e10813'),('69315d0b84a53e1bb','Send Email Notifications',0,'Success','2025-12-04 10:08:00',1090489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:04','2025-12-04 10:08:04',1350223,1,NULL,NULL,NULL,'2025-12-04 10:06:03','2025-12-04 10:08:04','687bf5d466067a4ba'),('69315d0bcd0c33f39','Auth Token Control',0,'Success','2025-12-04 10:12:00',1090490,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:03','2025-12-04 10:12:04',1350376,1,NULL,NULL,NULL,'2025-12-04 10:06:03','2025-12-04 10:12:04','687bf5d511e08c57f'),('69315d0c02a10f8bd','Process Webhook Queue',0,'Success','2025-12-04 10:08:00',1090491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:05','2025-12-04 10:08:05',1350223,1,NULL,NULL,NULL,'2025-12-04 10:06:04','2025-12-04 10:08:05','687bf5d5788e2fe0e'),('69315d45f2729435d','Submit Popup Reminders',0,'Success','2025-12-04 10:07:01',1090492,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:07:04','2025-12-04 10:07:04',1350199,1,NULL,NULL,NULL,'2025-12-04 10:07:01','2025-12-04 10:07:04','687bf57d2f9463790'),('69315d4639df8b395','Process Job Queue q0',0,'Success','2025-12-04 10:07:02',1090493,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:07:05','2025-12-04 10:07:05',1350199,1,NULL,NULL,NULL,'2025-12-04 10:07:02','2025-12-04 10:07:05','687bf57d693e0fc1f'),('69315d4658eeabac2','Process Job Queue q1',0,'Success','2025-12-04 10:08:00',1090494,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:06','2025-12-04 10:08:06',1350223,1,NULL,NULL,NULL,'2025-12-04 10:07:02','2025-12-04 10:08:06','687bf57d8afb5c472'),('69315d4744a2ab53a','Process Job Queue e0',0,'Success','2025-12-04 10:07:03',1090495,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:07:05','2025-12-04 10:07:05',1350199,1,NULL,NULL,NULL,'2025-12-04 10:07:03','2025-12-04 10:07:05','687bf57dbba8299ef'),('69315d81709f33e78','Submit Popup Reminders',0,'Success','2025-12-04 10:08:01',1090496,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:06','2025-12-04 10:08:06',1350223,1,NULL,NULL,NULL,'2025-12-04 10:08:01','2025-12-04 10:08:06','687bf57d2f9463790'),('69315d8192d6f3866','Process Job Queue q0',0,'Success','2025-12-04 10:08:01',1090497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:07','2025-12-04 10:08:07',1350223,1,NULL,NULL,NULL,'2025-12-04 10:08:01','2025-12-04 10:08:07','687bf57d693e0fc1f'),('69315d81b5554bd21','Process Job Queue q1',0,'Success','2025-12-04 10:09:00',1090498,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:09:02','2025-12-04 10:09:02',1350242,1,NULL,NULL,NULL,'2025-12-04 10:08:01','2025-12-04 10:09:02','687bf57d8afb5c472'),('69315d81dd32fbd0d','Process Job Queue e0',0,'Success','2025-12-04 10:08:01',1090499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:08:08','2025-12-04 10:08:08',1350223,1,NULL,NULL,NULL,'2025-12-04 10:08:01','2025-12-04 10:08:08','687bf57dbba8299ef'),('69315d821fad47b75','Send Email Reminders',0,'Success','2025-12-04 10:10:00',1090500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:05','2025-12-04 10:10:05',1350322,1,NULL,NULL,NULL,'2025-12-04 10:08:02','2025-12-04 10:10:05','687bf5d44d3e10813'),('69315d825dff3e1fc','Send Email Notifications',0,'Success','2025-12-04 10:10:00',1090501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:06','2025-12-04 10:10:06',1350322,1,NULL,NULL,NULL,'2025-12-04 10:08:02','2025-12-04 10:10:06','687bf5d466067a4ba'),('69315d82a423ed0ea','Process Webhook Queue',0,'Success','2025-12-04 10:10:00',1090502,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:07','2025-12-04 10:10:07',1350322,1,NULL,NULL,NULL,'2025-12-04 10:08:02','2025-12-04 10:10:07','687bf5d5788e2fe0e'),('69315dbd6fe6724a1','Submit Popup Reminders',0,'Success','2025-12-04 10:09:01',1090503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:09:03','2025-12-04 10:09:03',1350242,1,NULL,NULL,NULL,'2025-12-04 10:09:01','2025-12-04 10:09:03','687bf57d2f9463790'),('69315dbd9e7a27049','Process Job Queue q0',0,'Success','2025-12-04 10:09:01',1090504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:09:04','2025-12-04 10:09:04',1350242,1,NULL,NULL,NULL,'2025-12-04 10:09:01','2025-12-04 10:09:04','687bf57d693e0fc1f'),('69315dbdc35773613','Process Job Queue q1',0,'Success','2025-12-04 10:10:00',1090505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:07','2025-12-04 10:10:08',1350322,1,NULL,NULL,NULL,'2025-12-04 10:09:01','2025-12-04 10:10:08','687bf57d8afb5c472'),('69315dbde71d982c3','Process Job Queue e0',0,'Success','2025-12-04 10:09:01',1090506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:09:05','2025-12-04 10:09:05',1350242,1,NULL,NULL,NULL,'2025-12-04 10:09:01','2025-12-04 10:09:05','687bf57dbba8299ef'),('69315df9e2c6090e7','Submit Popup Reminders',0,'Success','2025-12-04 10:10:01',1090507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:08','2025-12-04 10:10:08',1350322,1,NULL,NULL,NULL,'2025-12-04 10:10:01','2025-12-04 10:10:08','687bf57d2f9463790'),('69315dfa443ea7a3b','Process Job Queue q0',0,'Success','2025-12-04 10:10:02',1090508,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:09','2025-12-04 10:10:09',1350322,1,NULL,NULL,NULL,'2025-12-04 10:10:02','2025-12-04 10:10:09','687bf57d693e0fc1f'),('69315dfa8e988eb11','Process Job Queue q1',0,'Success','2025-12-04 10:11:00',1090509,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:11:02','2025-12-04 10:11:02',1350338,1,NULL,NULL,NULL,'2025-12-04 10:10:02','2025-12-04 10:11:02','687bf57d8afb5c472'),('69315dfb0d175dd6f','Process Job Queue e0',0,'Success','2025-12-04 10:10:03',1090510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:10:09','2025-12-04 10:10:10',1350322,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:10:10','687bf57dbba8299ef'),('69315dfb5b09ba663','Send Email Reminders',0,'Success','2025-12-04 10:12:00',1090511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:04','2025-12-04 10:12:04',1350376,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:12:04','687bf5d44d3e10813'),('69315dfb87de547a6','Send Email Notifications',0,'Success','2025-12-04 10:12:00',1090512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:05','2025-12-04 10:12:05',1350376,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:12:05','687bf5d466067a4ba'),('69315dfbad77d9a4d','Send Mass Emails',0,'Success','2025-12-04 10:30:00',1090513,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:04','2025-12-04 10:30:04',1351008,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:30:04','687bf5d4b535f913f'),('69315dfbcea1e8fed','Process Webhook Queue',0,'Success','2025-12-04 10:12:00',1090514,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:05','2025-12-04 10:12:05',1350376,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:12:05','687bf5d5788e2fe0e'),('69315dfbeb36355a7','Send Scheduled Emails',0,'Success','2025-12-04 10:20:00',1090515,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:02','2025-12-04 10:20:03',1350676,1,NULL,NULL,NULL,'2025-12-04 10:10:03','2025-12-04 10:20:03','687bf5d5eeb01d80d'),('69315e35d64f04aa3','Submit Popup Reminders',0,'Success','2025-12-04 10:11:01',1090516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:11:03','2025-12-04 10:11:04',1350338,1,NULL,NULL,NULL,'2025-12-04 10:11:01','2025-12-04 10:11:04','687bf57d2f9463790'),('69315e360600513eb','Process Job Queue q0',0,'Success','2025-12-04 10:11:02',1090517,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:11:04','2025-12-04 10:11:04',1350338,1,NULL,NULL,NULL,'2025-12-04 10:11:02','2025-12-04 10:11:04','687bf57d693e0fc1f'),('69315e3626cae7a3b','Process Job Queue q1',0,'Success','2025-12-04 10:12:00',1090518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:06','2025-12-04 10:12:06',1350376,1,NULL,NULL,NULL,'2025-12-04 10:11:02','2025-12-04 10:12:06','687bf57d8afb5c472'),('69315e36471b06fdd','Process Job Queue e0',0,'Success','2025-12-04 10:11:02',1090519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:11:05','2025-12-04 10:11:05',1350338,1,NULL,NULL,NULL,'2025-12-04 10:11:02','2025-12-04 10:11:05','687bf57dbba8299ef'),('69315e716f2ddf0df','Submit Popup Reminders',0,'Success','2025-12-04 10:12:01',1090520,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:07','2025-12-04 10:12:07',1350376,1,NULL,NULL,NULL,'2025-12-04 10:12:01','2025-12-04 10:12:07','687bf57d2f9463790'),('69315e71a76be24db','Process Job Queue q0',0,'Success','2025-12-04 10:12:01',1090521,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:07','2025-12-04 10:12:08',1350376,1,NULL,NULL,NULL,'2025-12-04 10:12:01','2025-12-04 10:12:08','687bf57d693e0fc1f'),('69315e71caec15ce7','Process Job Queue q1',0,'Success','2025-12-04 10:13:00',1090522,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:13:02','2025-12-04 10:13:03',1350417,1,NULL,NULL,NULL,'2025-12-04 10:12:01','2025-12-04 10:13:03','687bf57d8afb5c472'),('69315e7203af6ebe2','Process Job Queue e0',0,'Success','2025-12-04 10:12:02',1090523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:12:08','2025-12-04 10:12:08',1350376,1,NULL,NULL,NULL,'2025-12-04 10:12:02','2025-12-04 10:12:08','687bf57dbba8299ef'),('69315e7240b470ad6','Send Email Reminders',0,'Success','2025-12-04 10:14:00',1090524,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:03','2025-12-04 10:14:03',1350453,1,NULL,NULL,NULL,'2025-12-04 10:12:02','2025-12-04 10:14:03','687bf5d44d3e10813'),('69315e72bead4ac77','Send Email Notifications',0,'Success','2025-12-04 10:14:00',1090525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:04','2025-12-04 10:14:04',1350453,1,NULL,NULL,NULL,'2025-12-04 10:12:02','2025-12-04 10:14:04','687bf5d466067a4ba'),('69315e731dd7a0e66','Auth Token Control',0,'Success','2025-12-04 10:18:00',1090526,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:03','2025-12-04 10:18:03',1350599,1,NULL,NULL,NULL,'2025-12-04 10:12:03','2025-12-04 10:18:03','687bf5d511e08c57f'),('69315e737768a0e84','Process Webhook Queue',0,'Success','2025-12-04 10:14:00',1090527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:05','2025-12-04 10:14:05',1350453,1,NULL,NULL,NULL,'2025-12-04 10:12:03','2025-12-04 10:14:05','687bf5d5788e2fe0e'),('69315eada1df77975','Submit Popup Reminders',0,'Success','2025-12-04 10:13:01',1090528,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:13:03','2025-12-04 10:13:03',1350417,1,NULL,NULL,NULL,'2025-12-04 10:13:01','2025-12-04 10:13:03','687bf57d2f9463790'),('69315eadd5b73d598','Process Job Queue q0',0,'Success','2025-12-04 10:13:01',1090529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:13:04','2025-12-04 10:13:04',1350417,1,NULL,NULL,NULL,'2025-12-04 10:13:01','2025-12-04 10:13:04','687bf57d693e0fc1f'),('69315eae17dfc172e','Process Job Queue q1',0,'Success','2025-12-04 10:14:00',1090530,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:05','2025-12-04 10:14:05',1350453,1,NULL,NULL,NULL,'2025-12-04 10:13:02','2025-12-04 10:14:05','687bf57d8afb5c472'),('69315eae54c725508','Process Job Queue e0',0,'Success','2025-12-04 10:13:02',1090531,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:13:04','2025-12-04 10:13:05',1350417,1,NULL,NULL,NULL,'2025-12-04 10:13:02','2025-12-04 10:13:05','687bf57dbba8299ef'),('69315ee9a4546b115','Submit Popup Reminders',0,'Success','2025-12-04 10:14:01',1090532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:06','2025-12-04 10:14:06',1350453,1,NULL,NULL,NULL,'2025-12-04 10:14:01','2025-12-04 10:14:06','687bf57d2f9463790'),('69315ee9cd007d914','Process Job Queue q0',0,'Success','2025-12-04 10:14:01',1090533,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:07','2025-12-04 10:14:07',1350453,1,NULL,NULL,NULL,'2025-12-04 10:14:01','2025-12-04 10:14:07','687bf57d693e0fc1f'),('69315ee9eddb6b089','Process Job Queue q1',0,'Success','2025-12-04 10:15:00',1090534,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:15:02','2025-12-04 10:15:02',1350491,1,NULL,NULL,NULL,'2025-12-04 10:14:01','2025-12-04 10:15:02','687bf57d8afb5c472'),('69315eea25c4cf44d','Process Job Queue e0',0,'Success','2025-12-04 10:14:02',1090535,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:14:07','2025-12-04 10:14:08',1350453,1,NULL,NULL,NULL,'2025-12-04 10:14:02','2025-12-04 10:14:08','687bf57dbba8299ef'),('69315eeaae6661d7b','Send Email Reminders',0,'Success','2025-12-04 10:16:00',1090536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:03','2025-12-04 10:16:04',1350527,1,NULL,NULL,NULL,'2025-12-04 10:14:02','2025-12-04 10:16:04','687bf5d44d3e10813'),('69315eeadfbb1ece7','Send Email Notifications',0,'Success','2025-12-04 10:16:00',1090537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:04','2025-12-04 10:16:04',1350527,1,NULL,NULL,NULL,'2025-12-04 10:14:02','2025-12-04 10:16:04','687bf5d466067a4ba'),('69315eeb4835c6cdc','Process Webhook Queue',0,'Success','2025-12-04 10:16:00',1090538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:05','2025-12-04 10:16:05',1350527,1,NULL,NULL,NULL,'2025-12-04 10:14:03','2025-12-04 10:16:05','687bf5d5788e2fe0e'),('69315f25b6bc283f0','Submit Popup Reminders',0,'Success','2025-12-04 10:15:01',1090539,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:15:03','2025-12-04 10:15:04',1350491,1,NULL,NULL,NULL,'2025-12-04 10:15:01','2025-12-04 10:15:04','687bf57d2f9463790'),('69315f25ec5871409','Process Job Queue q0',0,'Success','2025-12-04 10:15:01',1090540,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:15:05','2025-12-04 10:15:05',1350491,1,NULL,NULL,NULL,'2025-12-04 10:15:01','2025-12-04 10:15:05','687bf57d693e0fc1f'),('69315f26231e37b28','Process Job Queue q1',0,'Success','2025-12-04 10:16:00',1090541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:06','2025-12-04 10:16:06',1350527,1,NULL,NULL,NULL,'2025-12-04 10:15:02','2025-12-04 10:16:06','687bf57d8afb5c472'),('69315f2646dc42dc9','Process Job Queue e0',0,'Success','2025-12-04 10:15:02',1090542,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:15:05','2025-12-04 10:15:05',1350491,1,NULL,NULL,NULL,'2025-12-04 10:15:02','2025-12-04 10:15:05','687bf57dbba8299ef'),('69315f61c168a5e7f','Submit Popup Reminders',0,'Success','2025-12-04 10:16:01',1090543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:06','2025-12-04 10:16:06',1350527,1,NULL,NULL,NULL,'2025-12-04 10:16:01','2025-12-04 10:16:06','687bf57d2f9463790'),('69315f61e4cc6ad70','Process Job Queue q0',0,'Success','2025-12-04 10:16:01',1090544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:07','2025-12-04 10:16:07',1350527,1,NULL,NULL,NULL,'2025-12-04 10:16:01','2025-12-04 10:16:07','687bf57d693e0fc1f'),('69315f620d6d9594b','Process Job Queue q1',0,'Success','2025-12-04 10:17:00',1090545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:17:02','2025-12-04 10:17:02',1350562,1,NULL,NULL,NULL,'2025-12-04 10:16:02','2025-12-04 10:17:02','687bf57d8afb5c472'),('69315f6294f067377','Process Job Queue e0',0,'Success','2025-12-04 10:16:02',1090546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:16:08','2025-12-04 10:16:08',1350527,1,NULL,NULL,NULL,'2025-12-04 10:16:02','2025-12-04 10:16:08','687bf57dbba8299ef'),('69315f62ca33a5165','Send Email Reminders',0,'Success','2025-12-04 10:18:00',1090547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:04','2025-12-04 10:18:04',1350599,1,NULL,NULL,NULL,'2025-12-04 10:16:02','2025-12-04 10:18:04','687bf5d44d3e10813'),('69315f6317e4bc4bf','Send Email Notifications',0,'Success','2025-12-04 10:18:00',1090548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:05','2025-12-04 10:18:05',1350599,1,NULL,NULL,NULL,'2025-12-04 10:16:03','2025-12-04 10:18:05','687bf5d466067a4ba'),('69315f635a587b49d','Process Webhook Queue',0,'Success','2025-12-04 10:18:00',1090549,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:05','2025-12-04 10:18:05',1350599,1,NULL,NULL,NULL,'2025-12-04 10:16:03','2025-12-04 10:18:05','687bf5d5788e2fe0e'),('69315f9d3f1f4b3be','Submit Popup Reminders',0,'Success','2025-12-04 10:17:01',1090550,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:17:03','2025-12-04 10:17:03',1350562,1,NULL,NULL,NULL,'2025-12-04 10:17:01','2025-12-04 10:17:03','687bf57d2f9463790'),('69315f9d69d7898e3','Process Job Queue q0',0,'Success','2025-12-04 10:17:01',1090551,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:17:04','2025-12-04 10:17:04',1350562,1,NULL,NULL,NULL,'2025-12-04 10:17:01','2025-12-04 10:17:04','687bf57d693e0fc1f'),('69315f9e24c45b71f','Process Job Queue q1',0,'Success','2025-12-04 10:18:00',1090552,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:06','2025-12-04 10:18:06',1350599,1,NULL,NULL,NULL,'2025-12-04 10:17:02','2025-12-04 10:18:06','687bf57d8afb5c472'),('69315f9e5d9b22b6f','Process Job Queue e0',0,'Success','2025-12-04 10:17:02',1090553,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:17:04','2025-12-04 10:17:05',1350562,1,NULL,NULL,NULL,'2025-12-04 10:17:02','2025-12-04 10:17:05','687bf57dbba8299ef'),('69315fd9ae0b22437','Submit Popup Reminders',0,'Success','2025-12-04 10:18:01',1090554,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:07','2025-12-04 10:18:07',1350599,1,NULL,NULL,NULL,'2025-12-04 10:18:01','2025-12-04 10:18:07','687bf57d2f9463790'),('69315fd9eb6620398','Process Job Queue q0',0,'Success','2025-12-04 10:18:01',1090555,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:07','2025-12-04 10:18:08',1350599,1,NULL,NULL,NULL,'2025-12-04 10:18:01','2025-12-04 10:18:08','687bf57d693e0fc1f'),('69315fda357a546fd','Process Job Queue q1',0,'Success','2025-12-04 10:19:00',1090556,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:19:03','2025-12-04 10:19:03',1350639,1,NULL,NULL,NULL,'2025-12-04 10:18:02','2025-12-04 10:19:03','687bf57d8afb5c472'),('69315fda7ed587b39','Process Job Queue e0',0,'Success','2025-12-04 10:18:02',1090557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:18:08','2025-12-04 10:18:08',1350599,1,NULL,NULL,NULL,'2025-12-04 10:18:02','2025-12-04 10:18:08','687bf57dbba8299ef'),('69315fdae118fa83a','Send Email Reminders',0,'Success','2025-12-04 10:20:00',1090558,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:04','2025-12-04 10:20:04',1350676,1,NULL,NULL,NULL,'2025-12-04 10:18:02','2025-12-04 10:20:04','687bf5d44d3e10813'),('69315fdb15c09be72','Send Email Notifications',0,'Success','2025-12-04 10:20:00',1090559,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:05','2025-12-04 10:20:05',1350676,1,NULL,NULL,NULL,'2025-12-04 10:18:03','2025-12-04 10:20:05','687bf5d466067a4ba'),('69315fdb3dfedc4c7','Auth Token Control',0,'Success','2025-12-04 10:24:00',1090560,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:03','2025-12-04 10:24:03',1350831,1,NULL,NULL,NULL,'2025-12-04 10:18:03','2025-12-04 10:24:03','687bf5d511e08c57f'),('69315fdb63f504a9e','Process Webhook Queue',0,'Success','2025-12-04 10:20:00',1090561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:06','2025-12-04 10:20:06',1350676,1,NULL,NULL,NULL,'2025-12-04 10:18:03','2025-12-04 10:20:06','687bf5d5788e2fe0e'),('69316015d2bd33751','Submit Popup Reminders',0,'Success','2025-12-04 10:19:01',1090562,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:19:04','2025-12-04 10:19:04',1350639,1,NULL,NULL,NULL,'2025-12-04 10:19:01','2025-12-04 10:19:04','687bf57d2f9463790'),('6931601607566e373','Process Job Queue q0',0,'Success','2025-12-04 10:19:02',1090563,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:19:04','2025-12-04 10:19:04',1350639,1,NULL,NULL,NULL,'2025-12-04 10:19:02','2025-12-04 10:19:04','687bf57d693e0fc1f'),('6931601625d1f433e','Process Job Queue q1',0,'Success','2025-12-04 10:20:00',1090564,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:07','2025-12-04 10:20:07',1350676,1,NULL,NULL,NULL,'2025-12-04 10:19:02','2025-12-04 10:20:07','687bf57d8afb5c472'),('69316016d62b987fd','Process Job Queue e0',0,'Success','2025-12-04 10:19:02',1090565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:19:05','2025-12-04 10:19:05',1350639,1,NULL,NULL,NULL,'2025-12-04 10:19:02','2025-12-04 10:19:05','687bf57dbba8299ef'),('69316051589c28270','Submit Popup Reminders',0,'Success','2025-12-04 10:20:01',1090566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:07','2025-12-04 10:20:07',1350676,1,NULL,NULL,NULL,'2025-12-04 10:20:01','2025-12-04 10:20:07','687bf57d2f9463790'),('693160518a3cc5077','Process Job Queue q0',0,'Success','2025-12-04 10:20:01',1090567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:08','2025-12-04 10:20:08',1350676,1,NULL,NULL,NULL,'2025-12-04 10:20:01','2025-12-04 10:20:08','687bf57d693e0fc1f'),('69316051a545f6e4d','Process Job Queue q1',0,'Success','2025-12-04 10:21:00',1090568,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:21:02','2025-12-04 10:21:03',1350716,1,NULL,NULL,NULL,'2025-12-04 10:20:01','2025-12-04 10:21:03','687bf57d8afb5c472'),('69316051c311a18b6','Process Job Queue e0',0,'Success','2025-12-04 10:20:01',1090569,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:20:09','2025-12-04 10:20:09',1350676,1,NULL,NULL,NULL,'2025-12-04 10:20:01','2025-12-04 10:20:09','687bf57dbba8299ef'),('69316051e88adaf2b','Send Email Reminders',0,'Success','2025-12-04 10:22:00',1090570,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:03','2025-12-04 10:22:04',1350753,1,NULL,NULL,NULL,'2025-12-04 10:20:01','2025-12-04 10:22:04','687bf5d44d3e10813'),('693160521ccfa8f4e','Send Email Notifications',0,'Success','2025-12-04 10:22:00',1090571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:04','2025-12-04 10:22:04',1350753,1,NULL,NULL,NULL,'2025-12-04 10:20:02','2025-12-04 10:22:04','687bf5d466067a4ba'),('69316052437b4fdcf','Process Webhook Queue',0,'Success','2025-12-04 10:22:00',1090572,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:05','2025-12-04 10:22:05',1350753,1,NULL,NULL,NULL,'2025-12-04 10:20:02','2025-12-04 10:22:05','687bf5d5788e2fe0e'),('6931605272531aaa7','Send Scheduled Emails',0,'Success','2025-12-04 10:30:00',1090573,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:05','2025-12-04 10:30:05',1351008,1,NULL,NULL,NULL,'2025-12-04 10:20:02','2025-12-04 10:30:05','687bf5d5eeb01d80d'),('6931608de8af25482','Submit Popup Reminders',0,'Success','2025-12-04 10:21:01',1090574,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:21:04','2025-12-04 10:21:04',1350716,1,NULL,NULL,NULL,'2025-12-04 10:21:01','2025-12-04 10:21:04','687bf57d2f9463790'),('6931608e207f66dd8','Process Job Queue q0',0,'Success','2025-12-04 10:21:02',1090575,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:21:05','2025-12-04 10:21:05',1350716,1,NULL,NULL,NULL,'2025-12-04 10:21:02','2025-12-04 10:21:05','687bf57d693e0fc1f'),('6931608e4953573b7','Process Job Queue q1',0,'Success','2025-12-04 10:22:00',1090576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:05','2025-12-04 10:22:05',1350753,1,NULL,NULL,NULL,'2025-12-04 10:21:02','2025-12-04 10:22:05','687bf57d8afb5c472'),('6931608e6d2626ff2','Process Job Queue e0',0,'Success','2025-12-04 10:21:02',1090577,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:21:05','2025-12-04 10:21:05',1350716,1,NULL,NULL,NULL,'2025-12-04 10:21:02','2025-12-04 10:21:05','687bf57dbba8299ef'),('693160c9600abf189','Submit Popup Reminders',0,'Success','2025-12-04 10:22:01',1090578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:06','2025-12-04 10:22:06',1350753,1,NULL,NULL,NULL,'2025-12-04 10:22:01','2025-12-04 10:22:06','687bf57d2f9463790'),('693160c98cf97d33d','Process Job Queue q0',0,'Success','2025-12-04 10:22:01',1090579,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:07','2025-12-04 10:22:07',1350753,1,NULL,NULL,NULL,'2025-12-04 10:22:01','2025-12-04 10:22:07','687bf57d693e0fc1f'),('693160c9bdee59a6b','Process Job Queue q1',0,'Success','2025-12-04 10:23:00',1090580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:23:02','2025-12-04 10:23:03',1350792,1,NULL,NULL,NULL,'2025-12-04 10:22:01','2025-12-04 10:23:03','687bf57d8afb5c472'),('693160ca06602cad2','Process Job Queue e0',0,'Success','2025-12-04 10:22:02',1090581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:22:08','2025-12-04 10:22:08',1350753,1,NULL,NULL,NULL,'2025-12-04 10:22:02','2025-12-04 10:22:08','687bf57dbba8299ef'),('693160cabffe673a0','Send Email Reminders',0,'Success','2025-12-04 10:24:00',1090582,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:04','2025-12-04 10:24:04',1350831,1,NULL,NULL,NULL,'2025-12-04 10:22:02','2025-12-04 10:24:04','687bf5d44d3e10813'),('693160cb19db25fe6','Send Email Notifications',0,'Success','2025-12-04 10:24:00',1090583,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:05','2025-12-04 10:24:05',1350831,1,NULL,NULL,NULL,'2025-12-04 10:22:03','2025-12-04 10:24:05','687bf5d466067a4ba'),('693160cb7ea2847ac','Process Webhook Queue',0,'Success','2025-12-04 10:24:00',1090584,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:06','2025-12-04 10:24:06',1350831,1,NULL,NULL,NULL,'2025-12-04 10:22:03','2025-12-04 10:24:06','687bf5d5788e2fe0e'),('693161060c8103c1a','Submit Popup Reminders',0,'Success','2025-12-04 10:23:02',1090585,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:23:04','2025-12-04 10:23:04',1350792,1,NULL,NULL,NULL,'2025-12-04 10:23:02','2025-12-04 10:23:04','687bf57d2f9463790'),('69316106372178c25','Process Job Queue q0',0,'Success','2025-12-04 10:23:02',1090586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:23:04','2025-12-04 10:23:04',1350792,1,NULL,NULL,NULL,'2025-12-04 10:23:02','2025-12-04 10:23:04','687bf57d693e0fc1f'),('69316106666c70fd7','Process Job Queue q1',0,'Success','2025-12-04 10:24:00',1090587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:06','2025-12-04 10:24:07',1350831,1,NULL,NULL,NULL,'2025-12-04 10:23:02','2025-12-04 10:24:07','687bf57d8afb5c472'),('6931610692cdb60b6','Process Job Queue e0',0,'Success','2025-12-04 10:23:02',1090588,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:23:05','2025-12-04 10:23:05',1350792,1,NULL,NULL,NULL,'2025-12-04 10:23:02','2025-12-04 10:23:05','687bf57dbba8299ef'),('69316141683eb2e73','Submit Popup Reminders',0,'Success','2025-12-04 10:24:01',1090589,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:07','2025-12-04 10:24:07',1350831,1,NULL,NULL,NULL,'2025-12-04 10:24:01','2025-12-04 10:24:07','687bf57d2f9463790'),('693161419f5f27c84','Process Job Queue q0',0,'Success','2025-12-04 10:24:01',1090590,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:08','2025-12-04 10:24:08',1350831,1,NULL,NULL,NULL,'2025-12-04 10:24:01','2025-12-04 10:24:08','687bf57d693e0fc1f'),('69316141be05c37dd','Process Job Queue q1',0,'Success','2025-12-04 10:25:00',1090591,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:25:02','2025-12-04 10:25:02',1350867,1,NULL,NULL,NULL,'2025-12-04 10:24:01','2025-12-04 10:25:02','687bf57d8afb5c472'),('69316142043439cc2','Process Job Queue e0',0,'Success','2025-12-04 10:24:02',1090592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:24:09','2025-12-04 10:24:09',1350831,1,NULL,NULL,NULL,'2025-12-04 10:24:02','2025-12-04 10:24:09','687bf57dbba8299ef'),('693161428f3338fb1','Send Email Reminders',0,'Success','2025-12-04 10:26:00',1090593,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:03','2025-12-04 10:26:03',1350906,1,NULL,NULL,NULL,'2025-12-04 10:24:02','2025-12-04 10:26:03','687bf5d44d3e10813'),('69316142ce746086e','Send Email Notifications',0,'Success','2025-12-04 10:26:00',1090594,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:04','2025-12-04 10:26:04',1350906,1,NULL,NULL,NULL,'2025-12-04 10:24:02','2025-12-04 10:26:04','687bf5d466067a4ba'),('6931614320fc5e73b','Auth Token Control',0,'Success','2025-12-04 10:30:00',1090595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:06','2025-12-04 10:30:06',1351008,1,NULL,NULL,NULL,'2025-12-04 10:24:03','2025-12-04 10:30:06','687bf5d511e08c57f'),('693161435b15ba2d9','Process Webhook Queue',0,'Success','2025-12-04 10:26:00',1090596,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:04','2025-12-04 10:26:04',1350906,1,NULL,NULL,NULL,'2025-12-04 10:24:03','2025-12-04 10:26:04','687bf5d5788e2fe0e'),('6931617dbdf60e411','Submit Popup Reminders',0,'Success','2025-12-04 10:25:01',1090597,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:25:03','2025-12-04 10:25:04',1350867,1,NULL,NULL,NULL,'2025-12-04 10:25:01','2025-12-04 10:25:04','687bf57d2f9463790'),('6931617de67885057','Process Job Queue q0',0,'Success','2025-12-04 10:25:01',1090598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:25:04','2025-12-04 10:25:04',1350867,1,NULL,NULL,NULL,'2025-12-04 10:25:01','2025-12-04 10:25:04','687bf57d693e0fc1f'),('6931617e133ff76b1','Process Job Queue q1',0,'Success','2025-12-04 10:26:00',1090599,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:05','2025-12-04 10:26:05',1350906,1,NULL,NULL,NULL,'2025-12-04 10:25:02','2025-12-04 10:26:05','687bf57d8afb5c472'),('6931617e50f4c67bb','Process Job Queue e0',0,'Success','2025-12-04 10:25:02',1090600,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:25:05','2025-12-04 10:25:05',1350867,1,NULL,NULL,NULL,'2025-12-04 10:25:02','2025-12-04 10:25:05','687bf57dbba8299ef'),('693161b95a8602f71','Submit Popup Reminders',0,'Success','2025-12-04 10:26:01',1090601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:06','2025-12-04 10:26:06',1350906,1,NULL,NULL,NULL,'2025-12-04 10:26:01','2025-12-04 10:26:06','687bf57d2f9463790'),('693161b9873969678','Process Job Queue q0',0,'Success','2025-12-04 10:26:01',1090602,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:07','2025-12-04 10:26:07',1350906,1,NULL,NULL,NULL,'2025-12-04 10:26:01','2025-12-04 10:26:07','687bf57d693e0fc1f'),('693161b9abfba9cce','Process Job Queue q1',0,'Success','2025-12-04 10:27:00',1090603,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:27:02','2025-12-04 10:27:02',1350944,1,NULL,NULL,NULL,'2025-12-04 10:26:01','2025-12-04 10:27:02','687bf57d8afb5c472'),('693161b9d82076799','Process Job Queue e0',0,'Success','2025-12-04 10:26:01',1090604,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:26:07','2025-12-04 10:26:07',1350906,1,NULL,NULL,NULL,'2025-12-04 10:26:01','2025-12-04 10:26:07','687bf57dbba8299ef'),('693161ba1925b5612','Send Email Reminders',0,'Success','2025-12-04 10:28:00',1090605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:03','2025-12-04 10:28:03',1350975,1,NULL,NULL,NULL,'2025-12-04 10:26:02','2025-12-04 10:28:03','687bf5d44d3e10813'),('693161ba4c6b18713','Send Email Notifications',0,'Success','2025-12-04 10:28:00',1090606,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:04','2025-12-04 10:28:04',1350975,1,NULL,NULL,NULL,'2025-12-04 10:26:02','2025-12-04 10:28:04','687bf5d466067a4ba'),('693161baa14b16006','Process Webhook Queue',0,'Success','2025-12-04 10:28:00',1090607,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:05','2025-12-04 10:28:05',1350975,1,NULL,NULL,NULL,'2025-12-04 10:26:02','2025-12-04 10:28:05','687bf5d5788e2fe0e'),('693161f548967f071','Submit Popup Reminders',0,'Success','2025-12-04 10:27:01',1090608,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:27:04','2025-12-04 10:27:04',1350944,1,NULL,NULL,NULL,'2025-12-04 10:27:01','2025-12-04 10:27:04','687bf57d2f9463790'),('693161f574fb6e252','Process Job Queue q0',0,'Success','2025-12-04 10:27:01',1090609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:27:05','2025-12-04 10:27:05',1350944,1,NULL,NULL,NULL,'2025-12-04 10:27:01','2025-12-04 10:27:05','687bf57d693e0fc1f'),('693161f5961e27d11','Process Job Queue q1',0,'Success','2025-12-04 10:28:00',1090610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:06','2025-12-04 10:28:06',1350975,1,NULL,NULL,NULL,'2025-12-04 10:27:01','2025-12-04 10:28:06','687bf57d8afb5c472'),('693161f5f27d0ae70','Process Job Queue e0',0,'Success','2025-12-04 10:27:01',1090611,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:27:05','2025-12-04 10:27:05',1350944,1,NULL,NULL,NULL,'2025-12-04 10:27:01','2025-12-04 10:27:05','687bf57dbba8299ef'),('69316231d9ec2ba56','Submit Popup Reminders',0,'Success','2025-12-04 10:28:01',1090612,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:07','2025-12-04 10:28:07',1350975,1,NULL,NULL,NULL,'2025-12-04 10:28:01','2025-12-04 10:28:07','687bf57d2f9463790'),('69316232149662352','Process Job Queue q0',0,'Success','2025-12-04 10:28:02',1090613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:08','2025-12-04 10:28:08',1350975,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:28:08','687bf57d693e0fc1f'),('693162323d585f1e0','Process Job Queue q1',0,'Success','2025-12-04 10:29:00',1090614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:29:02','2025-12-04 10:29:02',1350991,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:29:02','687bf57d8afb5c472'),('69316232590a3d162','Process Job Queue e0',0,'Success','2025-12-04 10:28:02',1090615,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:28:09','2025-12-04 10:28:09',1350975,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:28:09','687bf57dbba8299ef'),('693162327ca18651e','Send Email Reminders',0,'Success','2025-12-04 10:30:00',1090616,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:06','2025-12-04 10:30:07',1351008,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:30:07','687bf5d44d3e10813'),('69316232ad23005b0','Send Email Notifications',0,'Success','2025-12-04 10:30:00',1090617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:07','2025-12-04 10:30:07',1351008,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:30:07','687bf5d466067a4ba'),('69316232ec633458c','Process Webhook Queue',0,'Success','2025-12-04 10:30:00',1090618,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:08','2025-12-04 10:30:08',1351008,1,NULL,NULL,NULL,'2025-12-04 10:28:02','2025-12-04 10:30:08','687bf5d5788e2fe0e'),('6931626d48d08cb42','Submit Popup Reminders',0,'Success','2025-12-04 10:29:01',1090619,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:29:03','2025-12-04 10:29:03',1350991,1,NULL,NULL,NULL,'2025-12-04 10:29:01','2025-12-04 10:29:03','687bf57d2f9463790'),('6931626d759ff43d9','Process Job Queue q0',0,'Success','2025-12-04 10:29:01',1090620,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:29:03','2025-12-04 10:29:04',1350991,1,NULL,NULL,NULL,'2025-12-04 10:29:01','2025-12-04 10:29:04','687bf57d693e0fc1f'),('6931626db88011d83','Process Job Queue q1',0,'Success','2025-12-04 10:30:00',1090621,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:08','2025-12-04 10:30:08',1351008,1,NULL,NULL,NULL,'2025-12-04 10:29:01','2025-12-04 10:30:08','687bf57d8afb5c472'),('6931626e0bdf704d1','Process Job Queue e0',0,'Success','2025-12-04 10:29:02',1090622,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:29:04','2025-12-04 10:29:04',1350991,1,NULL,NULL,NULL,'2025-12-04 10:29:02','2025-12-04 10:29:04','687bf57dbba8299ef'),('693162a9a2bd40a93','Submit Popup Reminders',0,'Success','2025-12-04 10:30:01',1090623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:09','2025-12-04 10:30:09',1351008,1,NULL,NULL,NULL,'2025-12-04 10:30:01','2025-12-04 10:30:09','687bf57d2f9463790'),('693162a9cc1046cf7','Process Job Queue q0',0,'Success','2025-12-04 10:30:01',1090624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:10','2025-12-04 10:30:10',1351008,1,NULL,NULL,NULL,'2025-12-04 10:30:01','2025-12-04 10:30:10','687bf57d693e0fc1f'),('693162a9e7cad6aa6','Process Job Queue q1',0,'Success','2025-12-04 10:31:00',1090625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:31:02','2025-12-04 10:31:02',1351025,1,NULL,NULL,NULL,'2025-12-04 10:30:01','2025-12-04 10:31:02','687bf57d8afb5c472'),('693162aa1a966f5df','Process Job Queue e0',0,'Success','2025-12-04 10:30:02',1090626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:30:11','2025-12-04 10:30:11',1351008,1,NULL,NULL,NULL,'2025-12-04 10:30:02','2025-12-04 10:30:11','687bf57dbba8299ef'),('693162aa4205a3486','Send Email Reminders',0,'Success','2025-12-04 10:32:00',1090627,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:02','2025-12-04 10:32:02',1351048,1,NULL,NULL,NULL,'2025-12-04 10:30:02','2025-12-04 10:32:02','687bf5d44d3e10813'),('693162aa93250628c','Send Email Notifications',0,'Success','2025-12-04 10:32:00',1090628,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:03','2025-12-04 10:32:04',1351048,1,NULL,NULL,NULL,'2025-12-04 10:30:02','2025-12-04 10:32:04','687bf5d466067a4ba'),('693162aad19d078f7','Send Mass Emails',0,'Success','2025-12-04 10:50:00',1090629,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:04','2025-12-04 10:50:04',1351702,1,NULL,NULL,NULL,'2025-12-04 10:30:02','2025-12-04 10:50:04','687bf5d4b535f913f'),('693162ab0fdbbaf26','Auth Token Control',0,'Success','2025-12-04 10:36:00',1090630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:03','2025-12-04 10:36:03',1351121,1,NULL,NULL,NULL,'2025-12-04 10:30:03','2025-12-04 10:36:03','687bf5d511e08c57f'),('693162ab900e88bee','Process Webhook Queue',0,'Success','2025-12-04 10:32:00',1090631,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:04','2025-12-04 10:32:04',1351048,1,NULL,NULL,NULL,'2025-12-04 10:30:03','2025-12-04 10:32:04','687bf5d5788e2fe0e'),('693162abc8ae80ded','Send Scheduled Emails',0,'Success','2025-12-04 10:40:00',1090632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:03','2025-12-04 10:40:03',1351320,1,NULL,NULL,NULL,'2025-12-04 10:30:03','2025-12-04 10:40:03','687bf5d5eeb01d80d'),('693162e59eaeb772b','Submit Popup Reminders',0,'Success','2025-12-04 10:31:01',1090633,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:31:03','2025-12-04 10:31:03',1351025,1,NULL,NULL,NULL,'2025-12-04 10:31:01','2025-12-04 10:31:03','687bf57d2f9463790'),('693162e5bf21d0ae3','Process Job Queue q0',0,'Success','2025-12-04 10:31:01',1090634,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:31:04','2025-12-04 10:31:04',1351025,1,NULL,NULL,NULL,'2025-12-04 10:31:01','2025-12-04 10:31:04','687bf57d693e0fc1f'),('693162e5d9ea2e88c','Process Job Queue q1',0,'Success','2025-12-04 10:32:00',1090635,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:05','2025-12-04 10:32:06',1351048,1,NULL,NULL,NULL,'2025-12-04 10:31:01','2025-12-04 10:32:06','687bf57d8afb5c472'),('693162e6064018426','Process Job Queue e0',0,'Success','2025-12-04 10:31:02',1090636,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:31:05','2025-12-04 10:31:05',1351025,1,NULL,NULL,NULL,'2025-12-04 10:31:02','2025-12-04 10:31:05','687bf57dbba8299ef'),('6931632158dfb9574','Submit Popup Reminders',0,'Success','2025-12-04 10:32:01',1090637,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:07','2025-12-04 10:32:07',1351048,1,NULL,NULL,NULL,'2025-12-04 10:32:01','2025-12-04 10:32:07','687bf57d2f9463790'),('6931632174a6f61b8','Process Job Queue q0',0,'Success','2025-12-04 10:32:01',1090638,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:08','2025-12-04 10:32:08',1351048,1,NULL,NULL,NULL,'2025-12-04 10:32:01','2025-12-04 10:32:08','687bf57d693e0fc1f'),('6931632193fd0cbc7','Process Job Queue q1',0,'Success','2025-12-04 10:33:00',1090639,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:33:01','2025-12-04 10:33:02',1351065,1,NULL,NULL,NULL,'2025-12-04 10:32:01','2025-12-04 10:33:02','687bf57d8afb5c472'),('69316321af8adda89','Process Job Queue e0',0,'Success','2025-12-04 10:32:01',1090640,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:32:08','2025-12-04 10:32:08',1351048,1,NULL,NULL,NULL,'2025-12-04 10:32:01','2025-12-04 10:32:08','687bf57dbba8299ef'),('69316321e7c267b3d','Send Email Reminders',0,'Success','2025-12-04 10:34:00',1090641,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:03','2025-12-04 10:34:03',1351081,1,NULL,NULL,NULL,'2025-12-04 10:32:01','2025-12-04 10:34:03','687bf5d44d3e10813'),('69316322248fed1b2','Send Email Notifications',0,'Success','2025-12-04 10:34:00',1090642,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:04','2025-12-04 10:34:04',1351081,1,NULL,NULL,NULL,'2025-12-04 10:32:02','2025-12-04 10:34:04','687bf5d466067a4ba'),('6931632247714d435','Process Webhook Queue',0,'Success','2025-12-04 10:34:00',1090643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:05','2025-12-04 10:34:05',1351081,1,NULL,NULL,NULL,'2025-12-04 10:32:02','2025-12-04 10:34:05','687bf5d5788e2fe0e'),('6931635d5753e81a6','Submit Popup Reminders',0,'Success','2025-12-04 10:33:01',1090644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:33:03','2025-12-04 10:33:03',1351065,1,NULL,NULL,NULL,'2025-12-04 10:33:01','2025-12-04 10:33:03','687bf57d2f9463790'),('6931635d841acd705','Process Job Queue q0',0,'Success','2025-12-04 10:33:01',1090645,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:33:04','2025-12-04 10:33:04',1351065,1,NULL,NULL,NULL,'2025-12-04 10:33:01','2025-12-04 10:33:04','687bf57d693e0fc1f'),('6931635da2dbb30a5','Process Job Queue q1',0,'Success','2025-12-04 10:34:00',1090646,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:05','2025-12-04 10:34:05',1351081,1,NULL,NULL,NULL,'2025-12-04 10:33:01','2025-12-04 10:34:05','687bf57d8afb5c472'),('6931635dcab055075','Process Job Queue e0',0,'Success','2025-12-04 10:33:01',1090647,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:33:05','2025-12-04 10:33:05',1351065,1,NULL,NULL,NULL,'2025-12-04 10:33:01','2025-12-04 10:33:05','687bf57dbba8299ef'),('6931639960bd2196b','Submit Popup Reminders',0,'Success','2025-12-04 10:34:01',1090648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:06','2025-12-04 10:34:06',1351081,1,NULL,NULL,NULL,'2025-12-04 10:34:01','2025-12-04 10:34:06','687bf57d2f9463790'),('69316399a3add3fa2','Process Job Queue q0',0,'Success','2025-12-04 10:34:01',1090649,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:07','2025-12-04 10:34:07',1351081,1,NULL,NULL,NULL,'2025-12-04 10:34:01','2025-12-04 10:34:07','687bf57d693e0fc1f'),('69316399da8a25593','Process Job Queue q1',0,'Success','2025-12-04 10:35:00',1090650,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:35:02','2025-12-04 10:35:02',1351108,1,NULL,NULL,NULL,'2025-12-04 10:34:01','2025-12-04 10:35:02','687bf57d8afb5c472'),('6931639a2e9663b86','Process Job Queue e0',0,'Success','2025-12-04 10:34:02',1090651,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:34:07','2025-12-04 10:34:08',1351081,1,NULL,NULL,NULL,'2025-12-04 10:34:02','2025-12-04 10:34:08','687bf57dbba8299ef'),('6931639abe1471a91','Send Email Reminders',0,'Success','2025-12-04 10:36:00',1090652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:04','2025-12-04 10:36:05',1351121,1,NULL,NULL,NULL,'2025-12-04 10:34:02','2025-12-04 10:36:05','687bf5d44d3e10813'),('6931639af33923115','Send Email Notifications',0,'Success','2025-12-04 10:36:00',1090653,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:05','2025-12-04 10:36:05',1351121,1,NULL,NULL,NULL,'2025-12-04 10:34:02','2025-12-04 10:36:05','687bf5d466067a4ba'),('6931639b2e9cf01a3','Process Webhook Queue',0,'Success','2025-12-04 10:36:00',1090654,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:06','2025-12-04 10:36:06',1351121,1,NULL,NULL,NULL,'2025-12-04 10:34:03','2025-12-04 10:36:06','687bf5d5788e2fe0e'),('693163d57b7abf4d4','Submit Popup Reminders',0,'Success','2025-12-04 10:35:01',1090655,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:35:03','2025-12-04 10:35:04',1351108,1,NULL,NULL,NULL,'2025-12-04 10:35:01','2025-12-04 10:35:04','687bf57d2f9463790'),('693163d5abc290bc8','Process Job Queue q0',0,'Success','2025-12-04 10:35:01',1090656,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:35:04','2025-12-04 10:35:04',1351108,1,NULL,NULL,NULL,'2025-12-04 10:35:01','2025-12-04 10:35:04','687bf57d693e0fc1f'),('693163d5d8bd347e5','Process Job Queue q1',0,'Success','2025-12-04 10:36:00',1090657,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:07','2025-12-04 10:36:07',1351121,1,NULL,NULL,NULL,'2025-12-04 10:35:01','2025-12-04 10:36:07','687bf57d8afb5c472'),('693163d6127ddd670','Process Job Queue e0',0,'Success','2025-12-04 10:35:02',1090658,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:35:05','2025-12-04 10:35:05',1351108,1,NULL,NULL,NULL,'2025-12-04 10:35:02','2025-12-04 10:35:05','687bf57dbba8299ef'),('69316411c95eb4048','Submit Popup Reminders',0,'Success','2025-12-04 10:36:01',1090659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:07','2025-12-04 10:36:07',1351121,1,NULL,NULL,NULL,'2025-12-04 10:36:01','2025-12-04 10:36:07','687bf57d2f9463790'),('6931641205d2f3819','Process Job Queue q0',0,'Success','2025-12-04 10:36:02',1090660,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:08','2025-12-04 10:36:08',1351121,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:36:08','687bf57d693e0fc1f'),('6931641225464b406','Process Job Queue q1',0,'Success','2025-12-04 10:37:00',1090661,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:37:02','2025-12-04 10:37:03',1351144,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:37:03','687bf57d8afb5c472'),('6931641243e4d1095','Process Job Queue e0',0,'Success','2025-12-04 10:36:02',1090662,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:36:09','2025-12-04 10:36:09',1351121,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:36:09','687bf57dbba8299ef'),('6931641273034c6d2','Send Email Reminders',0,'Success','2025-12-04 10:38:00',1090663,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:03','2025-12-04 10:38:04',1351180,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:38:04','687bf5d44d3e10813'),('69316412b08b0e15f','Send Email Notifications',0,'Success','2025-12-04 10:38:00',1090664,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:05','2025-12-04 10:38:05',1351180,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:38:05','687bf5d466067a4ba'),('69316412ec978f8cb','Auth Token Control',0,'Success','2025-12-04 10:42:00',1090665,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:03','2025-12-04 10:42:04',1351395,1,NULL,NULL,NULL,'2025-12-04 10:36:02','2025-12-04 10:42:04','687bf5d511e08c57f'),('693164133d19a14e2','Process Webhook Queue',0,'Success','2025-12-04 10:38:00',1090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:06','2025-12-04 10:38:06',1351180,1,NULL,NULL,NULL,'2025-12-04 10:36:03','2025-12-04 10:38:06','687bf5d5788e2fe0e'),('6931644d52b8cdc62','Submit Popup Reminders',0,'Success','2025-12-04 10:37:01',1090667,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:37:03','2025-12-04 10:37:03',1351144,1,NULL,NULL,NULL,'2025-12-04 10:37:01','2025-12-04 10:37:03','687bf57d2f9463790'),('6931644db24f2b034','Process Job Queue q0',0,'Success','2025-12-04 10:37:01',1090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:37:04','2025-12-04 10:37:04',1351144,1,NULL,NULL,NULL,'2025-12-04 10:37:01','2025-12-04 10:37:04','687bf57d693e0fc1f'),('6931644dee9547ae5','Process Job Queue q1',0,'Success','2025-12-04 10:38:00',1090669,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:06','2025-12-04 10:38:07',1351180,1,NULL,NULL,NULL,'2025-12-04 10:37:01','2025-12-04 10:38:07','687bf57d8afb5c472'),('6931644e29a17a862','Process Job Queue e0',0,'Success','2025-12-04 10:37:02',1090670,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:37:05','2025-12-04 10:37:05',1351144,1,NULL,NULL,NULL,'2025-12-04 10:37:02','2025-12-04 10:37:05','687bf57dbba8299ef'),('6931648a07e6ae3f1','Submit Popup Reminders',0,'Success','2025-12-04 10:38:02',1090671,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:07','2025-12-04 10:38:07',1351180,1,NULL,NULL,NULL,'2025-12-04 10:38:02','2025-12-04 10:38:07','687bf57d2f9463790'),('6931648a4386dc9a5','Process Job Queue q0',0,'Success','2025-12-04 10:38:02',1090672,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:08','2025-12-04 10:38:08',1351180,1,NULL,NULL,NULL,'2025-12-04 10:38:02','2025-12-04 10:38:08','687bf57d693e0fc1f'),('6931648a7e930cd73','Process Job Queue q1',0,'Success','2025-12-04 10:39:00',1090673,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:02','2025-12-04 10:39:02',1351289,1,NULL,NULL,NULL,'2025-12-04 10:38:02','2025-12-04 10:39:02','687bf57d8afb5c472'),('6931648aa84162740','Process Job Queue e0',0,'Success','2025-12-04 10:38:02',1090674,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:38:08','2025-12-04 10:38:08',1351180,1,NULL,NULL,NULL,'2025-12-04 10:38:02','2025-12-04 10:38:08','687bf57dbba8299ef'),('6931648ad1db2a789','Send Email Reminders',0,'Success','2025-12-04 10:40:00',1090675,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:04','2025-12-04 10:40:04',1351320,1,NULL,NULL,NULL,'2025-12-04 10:38:02','2025-12-04 10:40:04','687bf5d44d3e10813'),('6931648b00ad8f645','Send Email Notifications',0,'Success','2025-12-04 10:40:00',1090676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:05','2025-12-04 10:40:05',1351320,1,NULL,NULL,NULL,'2025-12-04 10:38:03','2025-12-04 10:40:05','687bf5d466067a4ba'),('6931648b482a9331b','Process Webhook Queue',0,'Success','2025-12-04 10:40:00',1090677,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:05','2025-12-04 10:40:05',1351320,1,NULL,NULL,NULL,'2025-12-04 10:38:03','2025-12-04 10:40:05','687bf5d5788e2fe0e'),('693164c53c65147f5','Submit Popup Reminders',0,'Success','2025-12-04 10:39:01',1090678,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:03','2025-12-04 10:39:03',1351289,1,NULL,NULL,NULL,'2025-12-04 10:39:01','2025-12-04 10:39:03','687bf57d2f9463790'),('693164c566cf82a15','Process Job Queue q0',0,'Success','2025-12-04 10:39:01',1090679,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:04','2025-12-04 10:39:04',1351289,1,NULL,NULL,NULL,'2025-12-04 10:39:01','2025-12-04 10:39:04','687bf57d693e0fc1f'),('693164c5845267a07','Process Job Queue q1',0,'Success','2025-12-04 10:40:00',1090680,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:06','2025-12-04 10:40:06',1351320,1,NULL,NULL,NULL,'2025-12-04 10:39:01','2025-12-04 10:40:06','687bf57d8afb5c472'),('693164c5c39afcc5a','Process Job Queue e0',0,'Success','2025-12-04 10:39:01',1090681,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:04','2025-12-04 10:39:04',1351289,1,NULL,NULL,NULL,'2025-12-04 10:39:01','2025-12-04 10:39:04','687bf57dbba8299ef'),('693165018880b4f0b','Submit Popup Reminders',0,'Success','2025-12-04 10:40:01',1090682,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:07','2025-12-04 10:40:07',1351320,1,NULL,NULL,NULL,'2025-12-04 10:40:01','2025-12-04 10:40:07','687bf57d2f9463790'),('69316501c4ff922f2','Process Job Queue q0',0,'Success','2025-12-04 10:40:01',1090683,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:07','2025-12-04 10:40:07',1351320,1,NULL,NULL,NULL,'2025-12-04 10:40:01','2025-12-04 10:40:07','687bf57d693e0fc1f'),('69316501ed238050f','Process Job Queue q1',0,'Success','2025-12-04 10:41:00',1090684,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:02','2025-12-04 10:41:02',1351356,1,NULL,NULL,NULL,'2025-12-04 10:40:01','2025-12-04 10:41:02','687bf57d8afb5c472'),('69316502737b90abe','Process Job Queue e0',0,'Success','2025-12-04 10:40:02',1090685,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:08','2025-12-04 10:40:08',1351320,1,NULL,NULL,NULL,'2025-12-04 10:40:02','2025-12-04 10:40:08','687bf57dbba8299ef'),('69316502c2edfa78e','Send Email Reminders',0,'Success','2025-12-04 10:42:00',1090686,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:05','2025-12-04 10:42:05',1351395,1,NULL,NULL,NULL,'2025-12-04 10:40:02','2025-12-04 10:42:05','687bf5d44d3e10813'),('69316502f2ba32c8f','Send Email Notifications',0,'Success','2025-12-04 10:42:00',1090687,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:06','2025-12-04 10:42:06',1351395,1,NULL,NULL,NULL,'2025-12-04 10:40:02','2025-12-04 10:42:06','687bf5d466067a4ba'),('6931650323b918e36','Process Webhook Queue',0,'Success','2025-12-04 10:42:00',1090688,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:07','2025-12-04 10:42:07',1351395,1,NULL,NULL,NULL,'2025-12-04 10:40:03','2025-12-04 10:42:07','687bf5d5788e2fe0e'),('6931650353f6338ec','Send Scheduled Emails',0,'Success','2025-12-04 10:50:00',1090689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:05','2025-12-04 10:50:05',1351702,1,NULL,NULL,NULL,'2025-12-04 10:40:03','2025-12-04 10:50:05','687bf5d5eeb01d80d'),('6931653db550439a7','Submit Popup Reminders',0,'Success','2025-12-04 10:41:01',1090690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:03','2025-12-04 10:41:03',1351356,1,NULL,NULL,NULL,'2025-12-04 10:41:01','2025-12-04 10:41:03','687bf57d2f9463790'),('6931653dd90e45750','Process Job Queue q0',0,'Success','2025-12-04 10:41:01',1090691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:04','2025-12-04 10:41:04',1351356,1,NULL,NULL,NULL,'2025-12-04 10:41:01','2025-12-04 10:41:04','687bf57d693e0fc1f'),('6931653e095afabb1','Process Job Queue q1',0,'Success','2025-12-04 10:42:00',1090692,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:07','2025-12-04 10:42:08',1351395,1,NULL,NULL,NULL,'2025-12-04 10:41:02','2025-12-04 10:42:08','687bf57d8afb5c472'),('6931653e2a1c882b5','Process Job Queue e0',0,'Success','2025-12-04 10:41:02',1090693,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:05','2025-12-04 10:41:05',1351356,1,NULL,NULL,NULL,'2025-12-04 10:41:02','2025-12-04 10:41:05','687bf57dbba8299ef'),('69316579c385189e4','Submit Popup Reminders',0,'Success','2025-12-04 10:42:01',1090694,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:08','2025-12-04 10:42:08',1351395,1,NULL,NULL,NULL,'2025-12-04 10:42:01','2025-12-04 10:42:08','687bf57d2f9463790'),('6931657a050c7ea3a','Process Job Queue q0',0,'Success','2025-12-04 10:42:02',1090695,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:09','2025-12-04 10:42:09',1351395,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:42:09','687bf57d693e0fc1f'),('6931657a2a3d55f15','Process Job Queue q1',0,'Success','2025-12-04 10:43:00',1090696,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:01','2025-12-04 10:43:02',1351435,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:43:02','687bf57d8afb5c472'),('6931657a57b39ade9','Process Job Queue e0',0,'Success','2025-12-04 10:42:02',1090697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:09','2025-12-04 10:42:10',1351395,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:42:10','687bf57dbba8299ef'),('6931657a88e9d9123','Send Email Reminders',0,'Success','2025-12-04 10:44:00',1090698,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:03','2025-12-04 10:44:03',1351474,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:44:03','687bf5d44d3e10813'),('6931657aa9f595919','Send Email Notifications',0,'Success','2025-12-04 10:44:00',1090699,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:04','2025-12-04 10:44:04',1351474,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:44:04','687bf5d466067a4ba'),('6931657adc43b987b','Auth Token Control',0,'Success','2025-12-04 10:48:00',1090700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:04','2025-12-04 10:48:04',1351629,1,NULL,NULL,NULL,'2025-12-04 10:42:02','2025-12-04 10:48:04','687bf5d511e08c57f'),('6931657b6bf9b2ff9','Process Webhook Queue',0,'Success','2025-12-04 10:44:00',1090701,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:04','2025-12-04 10:44:05',1351474,1,NULL,NULL,NULL,'2025-12-04 10:42:03','2025-12-04 10:44:05','687bf5d5788e2fe0e'),('693165b53f2cd8a38','Submit Popup Reminders',0,'Success','2025-12-04 10:43:01',1090702,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:03','2025-12-04 10:43:03',1351435,1,NULL,NULL,NULL,'2025-12-04 10:43:01','2025-12-04 10:43:03','687bf57d2f9463790'),('693165b566ee65da4','Process Job Queue q0',0,'Success','2025-12-04 10:43:01',1090703,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:04','2025-12-04 10:43:04',1351435,1,NULL,NULL,NULL,'2025-12-04 10:43:01','2025-12-04 10:43:04','687bf57d693e0fc1f'),('693165b585a37f19d','Process Job Queue q1',0,'Success','2025-12-04 10:44:00',1090704,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:05','2025-12-04 10:44:05',1351474,1,NULL,NULL,NULL,'2025-12-04 10:43:01','2025-12-04 10:44:05','687bf57d8afb5c472'),('693165b5b3bbccabe','Process Job Queue e0',0,'Success','2025-12-04 10:43:01',1090705,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:05','2025-12-04 10:43:05',1351435,1,NULL,NULL,NULL,'2025-12-04 10:43:01','2025-12-04 10:43:05','687bf57dbba8299ef'),('693165f164833b91e','Submit Popup Reminders',0,'Success','2025-12-04 10:44:01',1090706,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:06','2025-12-04 10:44:06',1351474,1,NULL,NULL,NULL,'2025-12-04 10:44:01','2025-12-04 10:44:06','687bf57d2f9463790'),('693165f184002d2e0','Process Job Queue q0',0,'Success','2025-12-04 10:44:01',1090707,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:07','2025-12-04 10:44:07',1351474,1,NULL,NULL,NULL,'2025-12-04 10:44:01','2025-12-04 10:44:07','687bf57d693e0fc1f'),('693165f1a2c34397d','Process Job Queue q1',0,'Success','2025-12-04 10:45:00',1090708,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:02','2025-12-04 10:45:02',1351513,1,NULL,NULL,NULL,'2025-12-04 10:44:01','2025-12-04 10:45:02','687bf57d8afb5c472'),('693165f1ed285d98b','Process Job Queue e0',0,'Success','2025-12-04 10:44:01',1090709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:07','2025-12-04 10:44:07',1351474,1,NULL,NULL,NULL,'2025-12-04 10:44:01','2025-12-04 10:44:07','687bf57dbba8299ef'),('693165f240554a20a','Send Email Reminders',0,'Success','2025-12-04 10:46:00',1090710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:03','2025-12-04 10:46:03',1351552,1,NULL,NULL,NULL,'2025-12-04 10:44:02','2025-12-04 10:46:03','687bf5d44d3e10813'),('693165f27c3eb041b','Send Email Notifications',0,'Success','2025-12-04 10:46:00',1090711,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:04','2025-12-04 10:46:04',1351552,1,NULL,NULL,NULL,'2025-12-04 10:44:02','2025-12-04 10:46:04','687bf5d466067a4ba'),('693165f31da931faf','Process Webhook Queue',0,'Success','2025-12-04 10:46:00',1090712,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:04','2025-12-04 10:46:04',1351552,1,NULL,NULL,NULL,'2025-12-04 10:44:03','2025-12-04 10:46:04','687bf5d5788e2fe0e'),('6931662de1a54fd49','Submit Popup Reminders',0,'Success','2025-12-04 10:45:01',1090713,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:03','2025-12-04 10:45:03',1351513,1,NULL,NULL,NULL,'2025-12-04 10:45:01','2025-12-04 10:45:03','687bf57d2f9463790'),('6931662e13e705330','Process Job Queue q0',0,'Success','2025-12-04 10:45:02',1090714,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:04','2025-12-04 10:45:04',1351513,1,NULL,NULL,NULL,'2025-12-04 10:45:02','2025-12-04 10:45:04','687bf57d693e0fc1f'),('6931662e2e08ebf42','Process Job Queue q1',0,'Success','2025-12-04 10:46:00',1090715,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:05','2025-12-04 10:46:05',1351552,1,NULL,NULL,NULL,'2025-12-04 10:45:02','2025-12-04 10:46:05','687bf57d8afb5c472'),('6931662e4c9100fa8','Process Job Queue e0',0,'Success','2025-12-04 10:45:02',1090716,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:05','2025-12-04 10:45:05',1351513,1,NULL,NULL,NULL,'2025-12-04 10:45:02','2025-12-04 10:45:05','687bf57dbba8299ef'),('693166696d5c8af94','Submit Popup Reminders',0,'Success','2025-12-04 10:46:01',1090717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:05','2025-12-04 10:46:06',1351552,1,NULL,NULL,NULL,'2025-12-04 10:46:01','2025-12-04 10:46:06','687bf57d2f9463790'),('6931666999508f797','Process Job Queue q0',0,'Success','2025-12-04 10:46:01',1090718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:06','2025-12-04 10:46:06',1351552,1,NULL,NULL,NULL,'2025-12-04 10:46:01','2025-12-04 10:46:06','687bf57d693e0fc1f'),('69316669bf29dd622','Process Job Queue q1',0,'Success','2025-12-04 10:47:00',1090719,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:02','2025-12-04 10:47:03',1351588,1,NULL,NULL,NULL,'2025-12-04 10:46:01','2025-12-04 10:47:03','687bf57d8afb5c472'),('69316669e236141b3','Process Job Queue e0',0,'Success','2025-12-04 10:46:01',1090720,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:46:07','2025-12-04 10:46:07',1351552,1,NULL,NULL,NULL,'2025-12-04 10:46:01','2025-12-04 10:46:07','687bf57dbba8299ef'),('6931666a456b9d1b8','Send Email Reminders',0,'Success','2025-12-04 10:48:00',1090721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:04','2025-12-04 10:48:05',1351629,1,NULL,NULL,NULL,'2025-12-04 10:46:02','2025-12-04 10:48:05','687bf5d44d3e10813'),('6931666a87a01a3d0','Send Email Notifications',0,'Success','2025-12-04 10:48:00',1090722,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:05','2025-12-04 10:48:06',1351629,1,NULL,NULL,NULL,'2025-12-04 10:46:02','2025-12-04 10:48:06','687bf5d466067a4ba'),('6931666abd6a37e1e','Process Webhook Queue',0,'Success','2025-12-04 10:48:00',1090723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:07','2025-12-04 10:48:07',1351629,1,NULL,NULL,NULL,'2025-12-04 10:46:02','2025-12-04 10:48:07','687bf5d5788e2fe0e'),('693166a58191b15b0','Submit Popup Reminders',0,'Success','2025-12-04 10:47:01',1090724,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:04','2025-12-04 10:47:04',1351588,1,NULL,NULL,NULL,'2025-12-04 10:47:01','2025-12-04 10:47:04','687bf57d2f9463790'),('693166a5bca78e76b','Process Job Queue q0',0,'Success','2025-12-04 10:47:01',1090725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:04','2025-12-04 10:47:05',1351588,1,NULL,NULL,NULL,'2025-12-04 10:47:01','2025-12-04 10:47:05','687bf57d693e0fc1f'),('693166a60000a80e1','Process Job Queue q1',0,'Success','2025-12-04 10:48:00',1090726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:07','2025-12-04 10:48:07',1351629,1,NULL,NULL,NULL,'2025-12-04 10:47:02','2025-12-04 10:48:07','687bf57d8afb5c472'),('693166a64bb03b207','Process Job Queue e0',0,'Success','2025-12-04 10:47:02',1090727,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:05','2025-12-04 10:47:05',1351588,1,NULL,NULL,NULL,'2025-12-04 10:47:02','2025-12-04 10:47:05','687bf57dbba8299ef'),('693166e2099e6d3dc','Submit Popup Reminders',0,'Success','2025-12-04 10:48:02',1090728,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:08','2025-12-04 10:48:08',1351629,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:48:08','687bf57d2f9463790'),('693166e22dc0d09e0','Process Job Queue q0',0,'Success','2025-12-04 10:48:02',1090729,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:09','2025-12-04 10:48:09',1351629,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:48:09','687bf57d693e0fc1f'),('693166e257155d649','Process Job Queue q1',0,'Success','2025-12-04 10:49:00',1090730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:49:02','2025-12-04 10:49:02',1351664,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:49:02','687bf57d8afb5c472'),('693166e27f1fcaea7','Process Job Queue e0',0,'Success','2025-12-04 10:48:02',1090731,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:09','2025-12-04 10:48:10',1351629,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:48:10','687bf57dbba8299ef'),('693166e2b2a9d2727','Send Email Reminders',0,'Success','2025-12-04 10:50:00',1090732,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:06','2025-12-04 10:50:06',1351702,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:50:06','687bf5d44d3e10813'),('693166e2df58c2aa9','Send Email Notifications',0,'Success','2025-12-04 10:50:00',1090733,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:07','2025-12-04 10:50:07',1351702,1,NULL,NULL,NULL,'2025-12-04 10:48:02','2025-12-04 10:50:07','687bf5d466067a4ba'),('693166e325c1e117c','Auth Token Control',0,'Success','2025-12-04 10:54:00',1090734,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:04','2025-12-04 10:54:04',1351861,1,NULL,NULL,NULL,'2025-12-04 10:48:03','2025-12-04 10:54:04','687bf5d511e08c57f'),('693166e37aa98b3e5','Process Webhook Queue',0,'Success','2025-12-04 10:50:00',1090735,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:08','2025-12-04 10:50:08',1351702,1,NULL,NULL,NULL,'2025-12-04 10:48:03','2025-12-04 10:50:08','687bf5d5788e2fe0e'),('6931671daa6f65662','Submit Popup Reminders',0,'Success','2025-12-04 10:49:01',1090736,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:49:03','2025-12-04 10:49:03',1351664,1,NULL,NULL,NULL,'2025-12-04 10:49:01','2025-12-04 10:49:03','687bf57d2f9463790'),('6931671dda4e8f023','Process Job Queue q0',0,'Success','2025-12-04 10:49:01',1090737,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:49:04','2025-12-04 10:49:05',1351664,1,NULL,NULL,NULL,'2025-12-04 10:49:01','2025-12-04 10:49:05','687bf57d693e0fc1f'),('6931671e17702dc84','Process Job Queue q1',0,'Success','2025-12-04 10:50:00',1090738,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:08','2025-12-04 10:50:08',1351702,1,NULL,NULL,NULL,'2025-12-04 10:49:02','2025-12-04 10:50:08','687bf57d8afb5c472'),('6931671e3b2537725','Process Job Queue e0',0,'Success','2025-12-04 10:49:02',1090739,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:49:05','2025-12-04 10:49:06',1351664,1,NULL,NULL,NULL,'2025-12-04 10:49:02','2025-12-04 10:49:06','687bf57dbba8299ef'),('6931675a103200e08','Submit Popup Reminders',0,'Success','2025-12-04 10:50:02',1090740,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:09','2025-12-04 10:50:09',1351702,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:50:09','687bf57d2f9463790'),('6931675a4198b6a57','Process Job Queue q0',0,'Success','2025-12-04 10:50:02',1090741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:10','2025-12-04 10:50:10',1351702,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:50:10','687bf57d693e0fc1f'),('6931675a6c32bda52','Process Job Queue q1',0,'Success','2025-12-04 10:51:00',1090742,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:01','2025-12-04 10:51:01',1351737,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:51:01','687bf57d8afb5c472'),('6931675a8fff230b2','Process Job Queue e0',0,'Success','2025-12-04 10:50:02',1090743,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:11','2025-12-04 10:50:11',1351702,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:50:11','687bf57dbba8299ef'),('6931675abd0f5d7f9','Send Email Reminders',0,'Success','2025-12-04 10:52:00',1090744,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:03','2025-12-04 10:52:03',1351779,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:52:03','687bf5d44d3e10813'),('6931675adbb89f6ca','Send Email Notifications',0,'Success','2025-12-04 10:52:00',1090745,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:04','2025-12-04 10:52:04',1351779,1,NULL,NULL,NULL,'2025-12-04 10:50:02','2025-12-04 10:52:04','687bf5d466067a4ba'),('6931675b3eaf0ab89','Send Mass Emails',0,'Success','2025-12-04 11:10:00',1090746,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:03','2025-12-04 11:10:04',1352562,1,NULL,NULL,NULL,'2025-12-04 10:50:03','2025-12-04 11:10:04','687bf5d4b535f913f'),('6931675babf28aec9','Process Webhook Queue',0,'Success','2025-12-04 10:52:00',1090747,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:05','2025-12-04 10:52:05',1351779,1,NULL,NULL,NULL,'2025-12-04 10:50:03','2025-12-04 10:52:05','687bf5d5788e2fe0e'),('6931675bf2f30df13','Send Scheduled Emails',0,'Success','2025-12-04 11:00:00',1090748,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:04','2025-12-04 11:00:04',1352088,1,NULL,NULL,NULL,'2025-12-04 10:50:03','2025-12-04 11:00:04','687bf5d5eeb01d80d'),('6931679539328a13b','Submit Popup Reminders',0,'Success','2025-12-04 10:51:01',1090749,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:02','2025-12-04 10:51:03',1351737,1,NULL,NULL,NULL,'2025-12-04 10:51:01','2025-12-04 10:51:03','687bf57d2f9463790'),('6931679562c98db1f','Process Job Queue q0',0,'Success','2025-12-04 10:51:01',1090750,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:04','2025-12-04 10:51:04',1351737,1,NULL,NULL,NULL,'2025-12-04 10:51:01','2025-12-04 10:51:04','687bf57d693e0fc1f'),('693167957f80832a2','Process Job Queue q1',0,'Success','2025-12-04 10:52:00',1090751,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:06','2025-12-04 10:52:06',1351779,1,NULL,NULL,NULL,'2025-12-04 10:51:01','2025-12-04 10:52:06','687bf57d8afb5c472'),('69316795a35228707','Process Job Queue e0',0,'Success','2025-12-04 10:51:01',1090752,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:05','2025-12-04 10:51:05',1351737,1,NULL,NULL,NULL,'2025-12-04 10:51:01','2025-12-04 10:51:05','687bf57dbba8299ef'),('693167d19c4418ce2','Submit Popup Reminders',0,'Success','2025-12-04 10:52:01',1090753,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:07','2025-12-04 10:52:07',1351779,1,NULL,NULL,NULL,'2025-12-04 10:52:01','2025-12-04 10:52:07','687bf57d2f9463790'),('693167d1c7e4e33f4','Process Job Queue q0',0,'Success','2025-12-04 10:52:01',1090754,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:08','2025-12-04 10:52:08',1351779,1,NULL,NULL,NULL,'2025-12-04 10:52:01','2025-12-04 10:52:08','687bf57d693e0fc1f'),('693167d204d751ff1','Process Job Queue q1',0,'Success','2025-12-04 10:53:00',1090755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:53:03','2025-12-04 10:53:03',1351822,1,NULL,NULL,NULL,'2025-12-04 10:52:02','2025-12-04 10:53:03','687bf57d8afb5c472'),('693167d22464b8527','Process Job Queue e0',0,'Success','2025-12-04 10:52:02',1090756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:52:08','2025-12-04 10:52:08',1351779,1,NULL,NULL,NULL,'2025-12-04 10:52:02','2025-12-04 10:52:08','687bf57dbba8299ef'),('693167d25d93f9412','Send Email Reminders',0,'Success','2025-12-04 10:54:00',1090757,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:04','2025-12-04 10:54:04',1351861,1,NULL,NULL,NULL,'2025-12-04 10:52:02','2025-12-04 10:54:04','687bf5d44d3e10813'),('693167d289145be65','Send Email Notifications',0,'Success','2025-12-04 10:54:00',1090758,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:05','2025-12-04 10:54:05',1351861,1,NULL,NULL,NULL,'2025-12-04 10:52:02','2025-12-04 10:54:05','687bf5d466067a4ba'),('693167d31d71b42fe','Process Webhook Queue',0,'Success','2025-12-04 10:54:00',1090759,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:06','2025-12-04 10:54:06',1351861,1,NULL,NULL,NULL,'2025-12-04 10:52:03','2025-12-04 10:54:06','687bf5d5788e2fe0e'),('6931680e13078b2fa','Submit Popup Reminders',0,'Success','2025-12-04 10:53:02',1090760,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:53:04','2025-12-04 10:53:04',1351822,1,NULL,NULL,NULL,'2025-12-04 10:53:02','2025-12-04 10:53:04','687bf57d2f9463790'),('6931680e321f08cab','Process Job Queue q0',0,'Success','2025-12-04 10:53:02',1090761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:53:05','2025-12-04 10:53:05',1351822,1,NULL,NULL,NULL,'2025-12-04 10:53:02','2025-12-04 10:53:05','687bf57d693e0fc1f'),('6931680e4e0b254bd','Process Job Queue q1',0,'Success','2025-12-04 10:54:00',1090762,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:06','2025-12-04 10:54:07',1351861,1,NULL,NULL,NULL,'2025-12-04 10:53:02','2025-12-04 10:54:07','687bf57d8afb5c472'),('6931680e78ee83ef1','Process Job Queue e0',0,'Success','2025-12-04 10:53:02',1090763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:53:06','2025-12-04 10:53:06',1351822,1,NULL,NULL,NULL,'2025-12-04 10:53:02','2025-12-04 10:53:06','687bf57dbba8299ef'),('69316849926eda3cc','Submit Popup Reminders',0,'Success','2025-12-04 10:54:01',1090764,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:07','2025-12-04 10:54:08',1351861,1,NULL,NULL,NULL,'2025-12-04 10:54:01','2025-12-04 10:54:08','687bf57d2f9463790'),('69316849c3df58d0e','Process Job Queue q0',0,'Success','2025-12-04 10:54:01',1090765,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:08','2025-12-04 10:54:08',1351861,1,NULL,NULL,NULL,'2025-12-04 10:54:01','2025-12-04 10:54:08','687bf57d693e0fc1f'),('69316849e94b4ea31','Process Job Queue q1',0,'Success','2025-12-04 10:55:00',1090766,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:55:02','2025-12-04 10:55:03',1351896,1,NULL,NULL,NULL,'2025-12-04 10:54:01','2025-12-04 10:55:03','687bf57d8afb5c472'),('6931684a7eb5efe05','Process Job Queue e0',0,'Success','2025-12-04 10:54:02',1090767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:54:09','2025-12-04 10:54:09',1351861,1,NULL,NULL,NULL,'2025-12-04 10:54:02','2025-12-04 10:54:09','687bf57dbba8299ef'),('6931684aca84bcd81','Send Email Reminders',0,'Success','2025-12-04 10:56:00',1090768,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:03','2025-12-04 10:56:03',1351931,1,NULL,NULL,NULL,'2025-12-04 10:54:02','2025-12-04 10:56:03','687bf5d44d3e10813'),('6931684b3047515ca','Send Email Notifications',0,'Success','2025-12-04 10:56:00',1090769,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:04','2025-12-04 10:56:04',1351931,1,NULL,NULL,NULL,'2025-12-04 10:54:03','2025-12-04 10:56:04','687bf5d466067a4ba'),('6931684b7f5672de4','Auth Token Control',0,'Success','2025-12-04 11:00:00',1090770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:05','2025-12-04 11:00:05',1352088,1,NULL,NULL,NULL,'2025-12-04 10:54:03','2025-12-04 11:00:05','687bf5d511e08c57f'),('6931684bc2151be79','Process Webhook Queue',0,'Success','2025-12-04 10:56:00',1090771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:05','2025-12-04 10:56:05',1351931,1,NULL,NULL,NULL,'2025-12-04 10:54:03','2025-12-04 10:56:05','687bf5d5788e2fe0e'),('693168860c27d43f9','Submit Popup Reminders',0,'Success','2025-12-04 10:55:02',1090772,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:55:04','2025-12-04 10:55:04',1351896,1,NULL,NULL,NULL,'2025-12-04 10:55:02','2025-12-04 10:55:04','687bf57d2f9463790'),('6931688627a548e30','Process Job Queue q0',0,'Success','2025-12-04 10:55:02',1090773,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:55:05','2025-12-04 10:55:05',1351896,1,NULL,NULL,NULL,'2025-12-04 10:55:02','2025-12-04 10:55:05','687bf57d693e0fc1f'),('69316886509f82f89','Process Job Queue q1',0,'Success','2025-12-04 10:56:00',1090774,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:06','2025-12-04 10:56:06',1351931,1,NULL,NULL,NULL,'2025-12-04 10:55:02','2025-12-04 10:56:06','687bf57d8afb5c472'),('693168867a9f43794','Process Job Queue e0',0,'Success','2025-12-04 10:55:02',1090775,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:55:05','2025-12-04 10:55:05',1351896,1,NULL,NULL,NULL,'2025-12-04 10:55:02','2025-12-04 10:55:05','687bf57dbba8299ef'),('693168c1b5515306e','Submit Popup Reminders',0,'Success','2025-12-04 10:56:01',1090776,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:07','2025-12-04 10:56:07',1351931,1,NULL,NULL,NULL,'2025-12-04 10:56:01','2025-12-04 10:56:07','687bf57d2f9463790'),('693168c1dfa1105bc','Process Job Queue q0',0,'Success','2025-12-04 10:56:01',1090777,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:07','2025-12-04 10:56:07',1351931,1,NULL,NULL,NULL,'2025-12-04 10:56:01','2025-12-04 10:56:07','687bf57d693e0fc1f'),('693168c20a302d179','Process Job Queue q1',0,'Success','2025-12-04 10:57:00',1090778,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:57:03','2025-12-04 10:57:03',1351967,1,NULL,NULL,NULL,'2025-12-04 10:56:02','2025-12-04 10:57:03','687bf57d8afb5c472'),('693168c2381f8c952','Process Job Queue e0',0,'Success','2025-12-04 10:56:02',1090779,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:56:08','2025-12-04 10:56:08',1351931,1,NULL,NULL,NULL,'2025-12-04 10:56:02','2025-12-04 10:56:08','687bf57dbba8299ef'),('693168c25d4558da6','Send Email Reminders',0,'Success','2025-12-04 10:58:00',1090780,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:03','2025-12-04 10:58:04',1352008,1,NULL,NULL,NULL,'2025-12-04 10:56:02','2025-12-04 10:58:04','687bf5d44d3e10813'),('693168c28a5a30736','Send Email Notifications',0,'Success','2025-12-04 10:58:00',1090781,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:05','2025-12-04 10:58:05',1352008,1,NULL,NULL,NULL,'2025-12-04 10:56:02','2025-12-04 10:58:05','687bf5d466067a4ba'),('693168c31f59511ed','Process Webhook Queue',0,'Success','2025-12-04 10:58:00',1090782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:06','2025-12-04 10:58:06',1352008,1,NULL,NULL,NULL,'2025-12-04 10:56:03','2025-12-04 10:58:06','687bf5d5788e2fe0e'),('693168fe263854efa','Submit Popup Reminders',0,'Success','2025-12-04 10:57:02',1090783,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:57:04','2025-12-04 10:57:04',1351967,1,NULL,NULL,NULL,'2025-12-04 10:57:02','2025-12-04 10:57:04','687bf57d2f9463790'),('693168fe601b9be8a','Process Job Queue q0',0,'Success','2025-12-04 10:57:02',1090784,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:57:05','2025-12-04 10:57:05',1351967,1,NULL,NULL,NULL,'2025-12-04 10:57:02','2025-12-04 10:57:05','687bf57d693e0fc1f'),('693168fe92244269c','Process Job Queue q1',0,'Success','2025-12-04 10:58:00',1090785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:07','2025-12-04 10:58:07',1352008,1,NULL,NULL,NULL,'2025-12-04 10:57:02','2025-12-04 10:58:07','687bf57d8afb5c472'),('693168fec97d2d4e9','Process Job Queue e0',0,'Success','2025-12-04 10:57:02',1090786,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:57:06','2025-12-04 10:57:06',1351967,1,NULL,NULL,NULL,'2025-12-04 10:57:02','2025-12-04 10:57:06','687bf57dbba8299ef'),('6931693a13caaf42c','Submit Popup Reminders',0,'Success','2025-12-04 10:58:02',1090787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:08','2025-12-04 10:58:08',1352008,1,NULL,NULL,NULL,'2025-12-04 10:58:02','2025-12-04 10:58:08','687bf57d2f9463790'),('6931693a3e8afebe8','Process Job Queue q0',0,'Success','2025-12-04 10:58:02',1090788,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:09','2025-12-04 10:58:09',1352008,1,NULL,NULL,NULL,'2025-12-04 10:58:02','2025-12-04 10:58:09','687bf57d693e0fc1f'),('6931693a5d3191ea9','Process Job Queue q1',0,'Success','2025-12-04 10:59:00',1090789,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:59:02','2025-12-04 10:59:02',1352047,1,NULL,NULL,NULL,'2025-12-04 10:58:02','2025-12-04 10:59:02','687bf57d8afb5c472'),('6931693a810872131','Process Job Queue e0',0,'Success','2025-12-04 10:58:02',1090790,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:58:09','2025-12-04 10:58:09',1352008,1,NULL,NULL,NULL,'2025-12-04 10:58:02','2025-12-04 10:58:09','687bf57dbba8299ef'),('6931693ab9480b6a6','Send Email Reminders',0,'Success','2025-12-04 11:00:00',1090791,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:06','2025-12-04 11:00:06',1352088,1,NULL,NULL,NULL,'2025-12-04 10:58:02','2025-12-04 11:00:06','687bf5d44d3e10813'),('6931693b035cb3655','Send Email Notifications',0,'Success','2025-12-04 11:00:00',1090792,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:07','2025-12-04 11:00:07',1352088,1,NULL,NULL,NULL,'2025-12-04 10:58:03','2025-12-04 11:00:07','687bf5d466067a4ba'),('6931693b9bc56f355','Process Webhook Queue',0,'Success','2025-12-04 11:00:00',1090793,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:07','2025-12-04 11:00:07',1352088,1,NULL,NULL,NULL,'2025-12-04 10:58:03','2025-12-04 11:00:07','687bf5d5788e2fe0e'),('6931697546f48ff58','Submit Popup Reminders',0,'Success','2025-12-04 10:59:01',1090794,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:59:03','2025-12-04 10:59:03',1352047,1,NULL,NULL,NULL,'2025-12-04 10:59:01','2025-12-04 10:59:03','687bf57d2f9463790'),('6931697576156b8d9','Process Job Queue q0',0,'Success','2025-12-04 10:59:01',1090795,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:59:04','2025-12-04 10:59:05',1352047,1,NULL,NULL,NULL,'2025-12-04 10:59:01','2025-12-04 10:59:05','687bf57d693e0fc1f'),('693169759cf8cd83b','Process Job Queue q1',0,'Success','2025-12-04 11:00:00',1090796,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:08','2025-12-04 11:00:08',1352088,1,NULL,NULL,NULL,'2025-12-04 10:59:01','2025-12-04 11:00:08','687bf57d8afb5c472'),('69316975c6e9d85df','Process Job Queue e0',0,'Success','2025-12-04 10:59:01',1090797,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:59:05','2025-12-04 10:59:05',1352047,1,NULL,NULL,NULL,'2025-12-04 10:59:01','2025-12-04 10:59:05','687bf57dbba8299ef'),('693169b1d0a43da64','Submit Popup Reminders',0,'Success','2025-12-04 11:00:01',1090798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:08','2025-12-04 11:00:09',1352088,1,NULL,NULL,NULL,'2025-12-04 11:00:01','2025-12-04 11:00:09','687bf57d2f9463790'),('693169b2007c7c226','Process Job Queue q0',0,'Success','2025-12-04 11:00:01',1090799,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:09','2025-12-04 11:00:09',1352088,1,NULL,NULL,NULL,'2025-12-04 11:00:02','2025-12-04 11:00:09','687bf57d693e0fc1f'),('693169b251f1fc422','Process Job Queue q1',0,'Success','2025-12-04 11:01:00',1090800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:01:02','2025-12-04 11:01:02',1352123,1,NULL,NULL,NULL,'2025-12-04 11:00:02','2025-12-04 11:01:02','687bf57d8afb5c472'),('693169b28217d9d5e','Process Job Queue e0',0,'Success','2025-12-04 11:00:02',1090801,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:00:10','2025-12-04 11:00:10',1352088,1,NULL,NULL,NULL,'2025-12-04 11:00:02','2025-12-04 11:00:10','687bf57dbba8299ef'),('693169b2b0aaecd8a','Send Email Reminders',0,'Success','2025-12-04 11:02:00',1090802,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:03','2025-12-04 11:02:03',1352166,1,NULL,NULL,NULL,'2025-12-04 11:00:02','2025-12-04 11:02:03','687bf5d44d3e10813'),('693169b2e4b8d520f','Send Email Notifications',0,'Success','2025-12-04 11:02:00',1090803,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:04','2025-12-04 11:02:04',1352166,1,NULL,NULL,NULL,'2025-12-04 11:00:02','2025-12-04 11:02:04','687bf5d466067a4ba'),('693169b3140dcc2c1','Auth Token Control',0,'Success','2025-12-04 11:06:00',1090804,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:04','2025-12-04 11:06:04',1352335,1,NULL,NULL,NULL,'2025-12-04 11:00:03','2025-12-04 11:06:04','687bf5d511e08c57f'),('693169b3564f972a4','Process Webhook Queue',0,'Success','2025-12-04 11:02:00',1090805,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:05','2025-12-04 11:02:05',1352166,1,NULL,NULL,NULL,'2025-12-04 11:00:03','2025-12-04 11:02:05','687bf5d5788e2fe0e'),('693169b3d4bc7e58d','Send Scheduled Emails',0,'Success','2025-12-04 11:10:00',1090806,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:04','2025-12-04 11:10:04',1352562,1,NULL,NULL,NULL,'2025-12-04 11:00:03','2025-12-04 11:10:04','687bf5d5eeb01d80d'),('693169ed685a247d6','Submit Popup Reminders',0,'Success','2025-12-04 11:01:01',1090807,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:01:03','2025-12-04 11:01:03',1352123,1,NULL,NULL,NULL,'2025-12-04 11:01:01','2025-12-04 11:01:03','687bf57d2f9463790'),('693169ed9f3048572','Process Job Queue q0',0,'Success','2025-12-04 11:01:01',1090808,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:01:04','2025-12-04 11:01:04',1352123,1,NULL,NULL,NULL,'2025-12-04 11:01:01','2025-12-04 11:01:04','687bf57d693e0fc1f'),('693169eddf8aafc87','Process Job Queue q1',0,'Success','2025-12-04 11:02:00',1090809,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:05','2025-12-04 11:02:06',1352166,1,NULL,NULL,NULL,'2025-12-04 11:01:01','2025-12-04 11:02:06','687bf57d8afb5c472'),('693169ee32b9a191f','Process Job Queue e0',0,'Success','2025-12-04 11:01:02',1090810,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:01:04','2025-12-04 11:01:05',1352123,1,NULL,NULL,NULL,'2025-12-04 11:01:02','2025-12-04 11:01:05','687bf57dbba8299ef'),('69316a298663cc834','Submit Popup Reminders',0,'Success','2025-12-04 11:02:01',1090811,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:06','2025-12-04 11:02:06',1352166,1,NULL,NULL,NULL,'2025-12-04 11:02:01','2025-12-04 11:02:06','687bf57d2f9463790'),('69316a29abf4c5fe3','Process Job Queue q0',0,'Success','2025-12-04 11:02:01',1090812,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:07','2025-12-04 11:02:07',1352166,1,NULL,NULL,NULL,'2025-12-04 11:02:01','2025-12-04 11:02:07','687bf57d693e0fc1f'),('69316a29dacea30b9','Process Job Queue q1',0,'Success','2025-12-04 11:03:00',1090813,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:03:01','2025-12-04 11:03:02',1352207,1,NULL,NULL,NULL,'2025-12-04 11:02:01','2025-12-04 11:03:02','687bf57d8afb5c472'),('69316a2a18bb09c9d','Process Job Queue e0',0,'Success','2025-12-04 11:02:02',1090814,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:02:08','2025-12-04 11:02:08',1352166,1,NULL,NULL,NULL,'2025-12-04 11:02:02','2025-12-04 11:02:08','687bf57dbba8299ef'),('69316a2ab1826fa77','Send Email Reminders',0,'Success','2025-12-04 11:04:00',1090815,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:03','2025-12-04 11:04:03',1352254,1,NULL,NULL,NULL,'2025-12-04 11:02:02','2025-12-04 11:04:03','687bf5d44d3e10813'),('69316a2b052b22fe1','Send Email Notifications',0,'Success','2025-12-04 11:04:00',1090816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:04','2025-12-04 11:04:05',1352254,1,NULL,NULL,NULL,'2025-12-04 11:02:03','2025-12-04 11:04:05','687bf5d466067a4ba'),('69316a2b3ecb9485c','Process Webhook Queue',0,'Success','2025-12-04 11:04:00',1090817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:05','2025-12-04 11:04:06',1352254,1,NULL,NULL,NULL,'2025-12-04 11:02:03','2025-12-04 11:04:06','687bf5d5788e2fe0e'),('69316a654f755f118','Submit Popup Reminders',0,'Success','2025-12-04 11:03:01',1090818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:03:02','2025-12-04 11:03:03',1352207,1,NULL,NULL,NULL,'2025-12-04 11:03:01','2025-12-04 11:03:03','687bf57d2f9463790'),('69316a657192f46ec','Process Job Queue q0',0,'Success','2025-12-04 11:03:01',1090819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:03:03','2025-12-04 11:03:04',1352207,1,NULL,NULL,NULL,'2025-12-04 11:03:01','2025-12-04 11:03:04','687bf57d693e0fc1f'),('69316a659680a9d31','Process Job Queue q1',0,'Success','2025-12-04 11:04:00',1090820,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:06','2025-12-04 11:04:07',1352254,1,NULL,NULL,NULL,'2025-12-04 11:03:01','2025-12-04 11:04:07','687bf57d8afb5c472'),('69316a65be3d562ed','Process Job Queue e0',0,'Success','2025-12-04 11:03:01',1090821,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:03:04','2025-12-04 11:03:05',1352207,1,NULL,NULL,NULL,'2025-12-04 11:03:01','2025-12-04 11:03:05','687bf57dbba8299ef'),('69316aa1e00bb430e','Submit Popup Reminders',0,'Success','2025-12-04 11:04:01',1090822,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:07','2025-12-04 11:04:07',1352254,1,NULL,NULL,NULL,'2025-12-04 11:04:01','2025-12-04 11:04:07','687bf57d2f9463790'),('69316aa20c3c62dbb','Process Job Queue q0',0,'Success','2025-12-04 11:04:02',1090823,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:08','2025-12-04 11:04:08',1352254,1,NULL,NULL,NULL,'2025-12-04 11:04:02','2025-12-04 11:04:08','687bf57d693e0fc1f'),('69316aa23dca3987c','Process Job Queue q1',0,'Success','2025-12-04 11:05:00',1090824,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:05:02','2025-12-04 11:05:03',1352295,1,NULL,NULL,NULL,'2025-12-04 11:04:02','2025-12-04 11:05:03','687bf57d8afb5c472'),('69316aa26dba707b5','Process Job Queue e0',0,'Success','2025-12-04 11:04:02',1090825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:04:08','2025-12-04 11:04:09',1352254,1,NULL,NULL,NULL,'2025-12-04 11:04:02','2025-12-04 11:04:09','687bf57dbba8299ef'),('69316aa2a7b22bda6','Send Email Reminders',0,'Success','2025-12-04 11:06:00',1090826,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:05','2025-12-04 11:06:05',1352335,1,NULL,NULL,NULL,'2025-12-04 11:04:02','2025-12-04 11:06:05','687bf5d44d3e10813'),('69316aa2ce5b77312','Send Email Notifications',0,'Success','2025-12-04 11:06:00',1090827,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:06','2025-12-04 11:06:06',1352335,1,NULL,NULL,NULL,'2025-12-04 11:04:02','2025-12-04 11:06:06','687bf5d466067a4ba'),('69316aa306ece55b5','Process Webhook Queue',0,'Success','2025-12-04 11:06:00',1090828,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:07','2025-12-04 11:06:07',1352335,1,NULL,NULL,NULL,'2025-12-04 11:04:03','2025-12-04 11:06:07','687bf5d5788e2fe0e'),('69316adda35f3f3a9','Submit Popup Reminders',0,'Success','2025-12-04 11:05:01',1090829,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:05:04','2025-12-04 11:05:04',1352295,1,NULL,NULL,NULL,'2025-12-04 11:05:01','2025-12-04 11:05:04','687bf57d2f9463790'),('69316addcfd48ed00','Process Job Queue q0',0,'Success','2025-12-04 11:05:01',1090830,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:05:05','2025-12-04 11:05:05',1352295,1,NULL,NULL,NULL,'2025-12-04 11:05:01','2025-12-04 11:05:05','687bf57d693e0fc1f'),('69316addee8bac05f','Process Job Queue q1',0,'Success','2025-12-04 11:06:00',1090831,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:07','2025-12-04 11:06:08',1352335,1,NULL,NULL,NULL,'2025-12-04 11:05:01','2025-12-04 11:06:08','687bf57d8afb5c472'),('69316ade3abf6091e','Process Job Queue e0',0,'Success','2025-12-04 11:05:02',1090832,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:05:05','2025-12-04 11:05:05',1352295,1,NULL,NULL,NULL,'2025-12-04 11:05:02','2025-12-04 11:05:05','687bf57dbba8299ef'),('69316b1a0676c55db','Submit Popup Reminders',0,'Success','2025-12-04 11:06:02',1090833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:08','2025-12-04 11:06:08',1352335,1,NULL,NULL,NULL,'2025-12-04 11:06:02','2025-12-04 11:06:08','687bf57d2f9463790'),('69316b1a2c8cb6ef8','Process Job Queue q0',0,'Success','2025-12-04 11:06:02',1090834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:09','2025-12-04 11:06:09',1352335,1,NULL,NULL,NULL,'2025-12-04 11:06:02','2025-12-04 11:06:09','687bf57d693e0fc1f'),('69316b1a508a250ad','Process Job Queue q1',0,'Success','2025-12-04 11:07:00',1090835,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:07:02','2025-12-04 11:07:03',1352373,1,NULL,NULL,NULL,'2025-12-04 11:06:02','2025-12-04 11:07:03','687bf57d8afb5c472'),('69316b1a7a6a8c393','Process Job Queue e0',0,'Success','2025-12-04 11:06:02',1090836,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:06:10','2025-12-04 11:06:10',1352335,1,NULL,NULL,NULL,'2025-12-04 11:06:02','2025-12-04 11:06:10','687bf57dbba8299ef'),('69316b1ac6476fc91','Send Email Reminders',0,'Success','2025-12-04 11:08:00',1090837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:04','2025-12-04 11:08:04',1352413,1,NULL,NULL,NULL,'2025-12-04 11:06:02','2025-12-04 11:08:04','687bf5d44d3e10813'),('69316b1b1b5556540','Send Email Notifications',0,'Success','2025-12-04 11:08:00',1090838,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:05','2025-12-04 11:08:05',1352413,1,NULL,NULL,NULL,'2025-12-04 11:06:03','2025-12-04 11:08:05','687bf5d466067a4ba'),('69316b1b5eff995d5','Auth Token Control',0,'Success','2025-12-04 11:12:00',1090839,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:03','2025-12-04 11:12:04',1352642,1,NULL,NULL,NULL,'2025-12-04 11:06:03','2025-12-04 11:12:04','687bf5d511e08c57f'),('69316b1ba27a100c9','Process Webhook Queue',0,'Success','2025-12-04 11:08:00',1090840,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:05','2025-12-04 11:08:05',1352413,1,NULL,NULL,NULL,'2025-12-04 11:06:03','2025-12-04 11:08:05','687bf5d5788e2fe0e'),('69316b55dc61ae686','Submit Popup Reminders',0,'Success','2025-12-04 11:07:01',1090841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:07:04','2025-12-04 11:07:04',1352373,1,NULL,NULL,NULL,'2025-12-04 11:07:01','2025-12-04 11:07:04','687bf57d2f9463790'),('69316b56053ec459a','Process Job Queue q0',0,'Success','2025-12-04 11:07:02',1090842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:07:05','2025-12-04 11:07:05',1352373,1,NULL,NULL,NULL,'2025-12-04 11:07:02','2025-12-04 11:07:05','687bf57d693e0fc1f'),('69316b562a7daca87','Process Job Queue q1',0,'Success','2025-12-04 11:08:00',1090843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:06','2025-12-04 11:08:06',1352413,1,NULL,NULL,NULL,'2025-12-04 11:07:02','2025-12-04 11:08:06','687bf57d8afb5c472'),('69316b564eb552c33','Process Job Queue e0',0,'Success','2025-12-04 11:07:02',1090844,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:07:06','2025-12-04 11:07:06',1352373,1,NULL,NULL,NULL,'2025-12-04 11:07:02','2025-12-04 11:07:06','687bf57dbba8299ef'),('69316b922a20154f3','Submit Popup Reminders',0,'Success','2025-12-04 11:08:02',1090845,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:07','2025-12-04 11:08:07',1352413,1,NULL,NULL,NULL,'2025-12-04 11:08:02','2025-12-04 11:08:07','687bf57d2f9463790'),('69316b92515bfbc2e','Process Job Queue q0',0,'Success','2025-12-04 11:08:02',1090846,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:07','2025-12-04 11:08:08',1352413,1,NULL,NULL,NULL,'2025-12-04 11:08:02','2025-12-04 11:08:08','687bf57d693e0fc1f'),('69316b9298d10f794','Process Job Queue q1',0,'Success','2025-12-04 11:09:00',1090847,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:09:02','2025-12-04 11:09:02',1352524,1,NULL,NULL,NULL,'2025-12-04 11:08:02','2025-12-04 11:09:02','687bf57d8afb5c472'),('69316b92ed5b87e79','Process Job Queue e0',0,'Success','2025-12-04 11:08:02',1090848,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:08:08','2025-12-04 11:08:08',1352413,1,NULL,NULL,NULL,'2025-12-04 11:08:02','2025-12-04 11:08:08','687bf57dbba8299ef'),('69316b932accf1a62','Send Email Reminders',0,'Success','2025-12-04 11:10:00',1090849,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:05','2025-12-04 11:10:05',1352562,1,NULL,NULL,NULL,'2025-12-04 11:08:03','2025-12-04 11:10:05','687bf5d44d3e10813'),('69316b937224d2d4c','Send Email Notifications',0,'Success','2025-12-04 11:10:00',1090850,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:06','2025-12-04 11:10:06',1352562,1,NULL,NULL,NULL,'2025-12-04 11:08:03','2025-12-04 11:10:06','687bf5d466067a4ba'),('69316b93d04db3f6f','Process Webhook Queue',0,'Success','2025-12-04 11:10:00',1090851,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:06','2025-12-04 11:10:07',1352562,1,NULL,NULL,NULL,'2025-12-04 11:08:03','2025-12-04 11:10:07','687bf5d5788e2fe0e'),('69316bcd6a07781e7','Submit Popup Reminders',0,'Success','2025-12-04 11:09:01',1090852,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:09:03','2025-12-04 11:09:04',1352524,1,NULL,NULL,NULL,'2025-12-04 11:09:01','2025-12-04 11:09:04','687bf57d2f9463790'),('69316bcd9da8e72b1','Process Job Queue q0',0,'Success','2025-12-04 11:09:01',1090853,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:09:04','2025-12-04 11:09:05',1352524,1,NULL,NULL,NULL,'2025-12-04 11:09:01','2025-12-04 11:09:05','687bf57d693e0fc1f'),('69316bcdbc5cbcbf2','Process Job Queue q1',0,'Success','2025-12-04 11:10:00',1090854,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:07','2025-12-04 11:10:07',1352562,1,NULL,NULL,NULL,'2025-12-04 11:09:01','2025-12-04 11:10:07','687bf57d8afb5c472'),('69316bce21078f1d7','Process Job Queue e0',0,'Success','2025-12-04 11:09:02',1090855,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:09:05','2025-12-04 11:09:05',1352524,1,NULL,NULL,NULL,'2025-12-04 11:09:02','2025-12-04 11:09:05','687bf57dbba8299ef'),('69316c092b33b75b4','Submit Popup Reminders',0,'Success','2025-12-04 11:10:01',1090856,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:08','2025-12-04 11:10:08',1352562,1,NULL,NULL,NULL,'2025-12-04 11:10:01','2025-12-04 11:10:08','687bf57d2f9463790'),('69316c0974c423ea2','Process Job Queue q0',0,'Success','2025-12-04 11:10:01',1090857,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:09','2025-12-04 11:10:09',1352562,1,NULL,NULL,NULL,'2025-12-04 11:10:01','2025-12-04 11:10:09','687bf57d693e0fc1f'),('69316c0a1b612a048','Process Job Queue q1',0,'Success','2025-12-04 11:11:00',1090858,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:11:02','2025-12-04 11:11:02',1352601,1,NULL,NULL,NULL,'2025-12-04 11:10:02','2025-12-04 11:11:02','687bf57d8afb5c472'),('69316c0a69e83d26d','Process Job Queue e0',0,'Success','2025-12-04 11:10:02',1090859,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:10:10','2025-12-04 11:10:10',1352562,1,NULL,NULL,NULL,'2025-12-04 11:10:02','2025-12-04 11:10:10','687bf57dbba8299ef'),('69316c0ac8194df7a','Send Email Reminders',0,'Success','2025-12-04 11:12:00',1090860,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:04','2025-12-04 11:12:05',1352642,1,NULL,NULL,NULL,'2025-12-04 11:10:02','2025-12-04 11:12:05','687bf5d44d3e10813'),('69316c0b27b2519c4','Send Email Notifications',0,'Success','2025-12-04 11:12:00',1090861,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:05','2025-12-04 11:12:05',1352642,1,NULL,NULL,NULL,'2025-12-04 11:10:03','2025-12-04 11:12:05','687bf5d466067a4ba'),('69316c0b57592bc06','Send Mass Emails',0,'Success','2025-12-04 11:30:00',1090862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:04','2025-12-04 11:30:04',1353343,1,NULL,NULL,NULL,'2025-12-04 11:10:03','2025-12-04 11:30:04','687bf5d4b535f913f'),('69316c0b740d3578f','Process Webhook Queue',0,'Success','2025-12-04 11:12:00',1090863,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:06','2025-12-04 11:12:06',1352642,1,NULL,NULL,NULL,'2025-12-04 11:10:03','2025-12-04 11:12:06','687bf5d5788e2fe0e'),('69316c0b9bcd27361','Send Scheduled Emails',0,'Success','2025-12-04 11:20:00',1090864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:03','2025-12-04 11:20:03',1352957,1,NULL,NULL,NULL,'2025-12-04 11:10:03','2025-12-04 11:20:03','687bf5d5eeb01d80d'),('69316c45a8de00ffc','Submit Popup Reminders',0,'Success','2025-12-04 11:11:01',1090865,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:11:03','2025-12-04 11:11:03',1352601,1,NULL,NULL,NULL,'2025-12-04 11:11:01','2025-12-04 11:11:03','687bf57d2f9463790'),('69316c45d141c85f6','Process Job Queue q0',0,'Success','2025-12-04 11:11:01',1090866,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:11:04','2025-12-04 11:11:04',1352601,1,NULL,NULL,NULL,'2025-12-04 11:11:01','2025-12-04 11:11:04','687bf57d693e0fc1f'),('69316c45f20bd8219','Process Job Queue q1',0,'Success','2025-12-04 11:12:00',1090867,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:07','2025-12-04 11:12:07',1352642,1,NULL,NULL,NULL,'2025-12-04 11:11:01','2025-12-04 11:12:07','687bf57d8afb5c472'),('69316c4627d74d76a','Process Job Queue e0',0,'Success','2025-12-04 11:11:02',1090868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:11:05','2025-12-04 11:11:05',1352601,1,NULL,NULL,NULL,'2025-12-04 11:11:02','2025-12-04 11:11:05','687bf57dbba8299ef'),('69316c81baad9a03f','Submit Popup Reminders',0,'Success','2025-12-04 11:12:01',1090869,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:07','2025-12-04 11:12:07',1352642,1,NULL,NULL,NULL,'2025-12-04 11:12:01','2025-12-04 11:12:07','687bf57d2f9463790'),('69316c81e6f54b89c','Process Job Queue q0',0,'Success','2025-12-04 11:12:01',1090870,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:08','2025-12-04 11:12:08',1352642,1,NULL,NULL,NULL,'2025-12-04 11:12:01','2025-12-04 11:12:08','687bf57d693e0fc1f'),('69316c8222e3692eb','Process Job Queue q1',0,'Success','2025-12-04 11:13:00',1090871,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:13:02','2025-12-04 11:13:02',1352680,1,NULL,NULL,NULL,'2025-12-04 11:12:02','2025-12-04 11:13:02','687bf57d8afb5c472'),('69316c824558296c5','Process Job Queue e0',0,'Success','2025-12-04 11:12:02',1090872,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:12:09','2025-12-04 11:12:09',1352642,1,NULL,NULL,NULL,'2025-12-04 11:12:02','2025-12-04 11:12:09','687bf57dbba8299ef'),('69316c826c863577a','Send Email Reminders',0,'Success','2025-12-04 11:14:00',1090873,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:03','2025-12-04 11:14:03',1352719,1,NULL,NULL,NULL,'2025-12-04 11:12:02','2025-12-04 11:14:03','687bf5d44d3e10813'),('69316c82aec45b477','Send Email Notifications',0,'Success','2025-12-04 11:14:00',1090874,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:04','2025-12-04 11:14:04',1352719,1,NULL,NULL,NULL,'2025-12-04 11:12:02','2025-12-04 11:14:04','687bf5d466067a4ba'),('69316c8324247e367','Auth Token Control',0,'Success','2025-12-04 11:18:00',1090875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:03','2025-12-04 11:18:03',1352884,1,NULL,NULL,NULL,'2025-12-04 11:12:03','2025-12-04 11:18:03','687bf5d511e08c57f'),('69316c835a9e0f3b4','Process Webhook Queue',0,'Success','2025-12-04 11:14:00',1090876,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:04','2025-12-04 11:14:05',1352719,1,NULL,NULL,NULL,'2025-12-04 11:12:03','2025-12-04 11:14:05','687bf5d5788e2fe0e'),('69316cbd9f0c33a9a','Submit Popup Reminders',0,'Success','2025-12-04 11:13:01',1090877,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:13:03','2025-12-04 11:13:03',1352680,1,NULL,NULL,NULL,'2025-12-04 11:13:01','2025-12-04 11:13:03','687bf57d2f9463790'),('69316cbdcbe33aba8','Process Job Queue q0',0,'Success','2025-12-04 11:13:01',1090878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:13:04','2025-12-04 11:13:04',1352680,1,NULL,NULL,NULL,'2025-12-04 11:13:01','2025-12-04 11:13:04','687bf57d693e0fc1f'),('69316cbe02a53bf3b','Process Job Queue q1',0,'Success','2025-12-04 11:14:00',1090879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:05','2025-12-04 11:14:05',1352719,1,NULL,NULL,NULL,'2025-12-04 11:13:02','2025-12-04 11:14:05','687bf57d8afb5c472'),('69316cbe267fd2394','Process Job Queue e0',0,'Success','2025-12-04 11:13:02',1090880,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:13:05','2025-12-04 11:13:05',1352680,1,NULL,NULL,NULL,'2025-12-04 11:13:02','2025-12-04 11:13:05','687bf57dbba8299ef'),('69316cf952d233c82','Submit Popup Reminders',0,'Success','2025-12-04 11:14:01',1090881,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:06','2025-12-04 11:14:06',1352719,1,NULL,NULL,NULL,'2025-12-04 11:14:01','2025-12-04 11:14:06','687bf57d2f9463790'),('69316cf988969d669','Process Job Queue q0',0,'Success','2025-12-04 11:14:01',1090882,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:06','2025-12-04 11:14:07',1352719,1,NULL,NULL,NULL,'2025-12-04 11:14:01','2025-12-04 11:14:07','687bf57d693e0fc1f'),('69316cf9c69137159','Process Job Queue q1',0,'Success','2025-12-04 11:15:00',1090883,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:15:02','2025-12-04 11:15:02',1352762,1,NULL,NULL,NULL,'2025-12-04 11:14:01','2025-12-04 11:15:02','687bf57d8afb5c472'),('69316cfa0ae6914e6','Process Job Queue e0',0,'Success','2025-12-04 11:14:02',1090884,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:14:07','2025-12-04 11:14:07',1352719,1,NULL,NULL,NULL,'2025-12-04 11:14:02','2025-12-04 11:14:07','687bf57dbba8299ef'),('69316cfa49f5f74e7','Send Email Reminders',0,'Success','2025-12-04 11:16:00',1090885,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:03','2025-12-04 11:16:04',1352804,1,NULL,NULL,NULL,'2025-12-04 11:14:02','2025-12-04 11:16:04','687bf5d44d3e10813'),('69316cfa817e6965d','Send Email Notifications',0,'Success','2025-12-04 11:16:00',1090886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:05','2025-12-04 11:16:05',1352804,1,NULL,NULL,NULL,'2025-12-04 11:14:02','2025-12-04 11:16:05','687bf5d466067a4ba'),('69316cfb41c767c22','Process Webhook Queue',0,'Success','2025-12-04 11:16:00',1090887,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:05','2025-12-04 11:16:06',1352804,1,NULL,NULL,NULL,'2025-12-04 11:14:03','2025-12-04 11:16:06','687bf5d5788e2fe0e'),('69316d3524fd14592','Submit Popup Reminders',0,'Success','2025-12-04 11:15:01',1090888,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:15:03','2025-12-04 11:15:03',1352762,1,NULL,NULL,NULL,'2025-12-04 11:15:01','2025-12-04 11:15:03','687bf57d2f9463790'),('69316d354640221e2','Process Job Queue q0',0,'Success','2025-12-04 11:15:01',1090889,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:15:03','2025-12-04 11:15:03',1352762,1,NULL,NULL,NULL,'2025-12-04 11:15:01','2025-12-04 11:15:03','687bf57d693e0fc1f'),('69316d35961310bf1','Process Job Queue q1',0,'Success','2025-12-04 11:16:00',1090890,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:06','2025-12-04 11:16:06',1352804,1,NULL,NULL,NULL,'2025-12-04 11:15:01','2025-12-04 11:16:06','687bf57d8afb5c472'),('69316d35c6e19a096','Process Job Queue e0',0,'Success','2025-12-04 11:15:01',1090891,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:15:04','2025-12-04 11:15:04',1352762,1,NULL,NULL,NULL,'2025-12-04 11:15:01','2025-12-04 11:15:04','687bf57dbba8299ef'),('69316d71dac6bcf48','Submit Popup Reminders',0,'Success','2025-12-04 11:16:01',1090892,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:07','2025-12-04 11:16:07',1352804,1,NULL,NULL,NULL,'2025-12-04 11:16:01','2025-12-04 11:16:07','687bf57d2f9463790'),('69316d720c7c64fe4','Process Job Queue q0',0,'Success','2025-12-04 11:16:02',1090893,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:08','2025-12-04 11:16:08',1352804,1,NULL,NULL,NULL,'2025-12-04 11:16:02','2025-12-04 11:16:08','687bf57d693e0fc1f'),('69316d72367f46732','Process Job Queue q1',0,'Success','2025-12-04 11:17:00',1090894,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:17:02','2025-12-04 11:17:02',1352842,1,NULL,NULL,NULL,'2025-12-04 11:16:02','2025-12-04 11:17:02','687bf57d8afb5c472'),('69316d7260095e7db','Process Job Queue e0',0,'Success','2025-12-04 11:16:02',1090895,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:16:09','2025-12-04 11:16:09',1352804,1,NULL,NULL,NULL,'2025-12-04 11:16:02','2025-12-04 11:16:09','687bf57dbba8299ef'),('69316d729bd122e66','Send Email Reminders',0,'Success','2025-12-04 11:18:00',1090896,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:04','2025-12-04 11:18:04',1352884,1,NULL,NULL,NULL,'2025-12-04 11:16:02','2025-12-04 11:18:04','687bf5d44d3e10813'),('69316d72d3262cfbf','Send Email Notifications',0,'Success','2025-12-04 11:18:00',1090897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:05','2025-12-04 11:18:05',1352884,1,NULL,NULL,NULL,'2025-12-04 11:16:02','2025-12-04 11:18:05','687bf5d466067a4ba'),('69316d739a718dc2b','Process Webhook Queue',0,'Success','2025-12-04 11:18:00',1090898,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:06','2025-12-04 11:18:06',1352884,1,NULL,NULL,NULL,'2025-12-04 11:16:03','2025-12-04 11:18:06','687bf5d5788e2fe0e'),('69316dad7b2a4b983','Submit Popup Reminders',0,'Success','2025-12-04 11:17:01',1090899,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:17:03','2025-12-04 11:17:03',1352842,1,NULL,NULL,NULL,'2025-12-04 11:17:01','2025-12-04 11:17:03','687bf57d2f9463790'),('69316dad9fd0fd191','Process Job Queue q0',0,'Success','2025-12-04 11:17:01',1090900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:17:04','2025-12-04 11:17:05',1352842,1,NULL,NULL,NULL,'2025-12-04 11:17:01','2025-12-04 11:17:05','687bf57d693e0fc1f'),('69316dadbeab28006','Process Job Queue q1',0,'Success','2025-12-04 11:18:00',1090901,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:06','2025-12-04 11:18:07',1352884,1,NULL,NULL,NULL,'2025-12-04 11:17:01','2025-12-04 11:18:07','687bf57d8afb5c472'),('69316dade64f3ebd6','Process Job Queue e0',0,'Success','2025-12-04 11:17:01',1090902,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:17:05','2025-12-04 11:17:05',1352842,1,NULL,NULL,NULL,'2025-12-04 11:17:01','2025-12-04 11:17:05','687bf57dbba8299ef'),('69316de97e49236bc','Submit Popup Reminders',0,'Success','2025-12-04 11:18:01',1090903,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:07','2025-12-04 11:18:07',1352884,1,NULL,NULL,NULL,'2025-12-04 11:18:01','2025-12-04 11:18:07','687bf57d2f9463790'),('69316de9a92bb24d0','Process Job Queue q0',0,'Success','2025-12-04 11:18:01',1090904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:08','2025-12-04 11:18:08',1352884,1,NULL,NULL,NULL,'2025-12-04 11:18:01','2025-12-04 11:18:08','687bf57d693e0fc1f'),('69316de9c5d90b464','Process Job Queue q1',0,'Success','2025-12-04 11:19:00',1090905,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:19:02','2025-12-04 11:19:03',1352920,1,NULL,NULL,NULL,'2025-12-04 11:18:01','2025-12-04 11:19:03','687bf57d8afb5c472'),('69316dea01b360a63','Process Job Queue e0',0,'Success','2025-12-04 11:18:02',1090906,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:18:08','2025-12-04 11:18:09',1352884,1,NULL,NULL,NULL,'2025-12-04 11:18:02','2025-12-04 11:18:09','687bf57dbba8299ef'),('69316dea5c787566d','Send Email Reminders',0,'Success','2025-12-04 11:20:00',1090907,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:05','2025-12-04 11:20:05',1352957,1,NULL,NULL,NULL,'2025-12-04 11:18:02','2025-12-04 11:20:05','687bf5d44d3e10813'),('69316dea9b6303743','Send Email Notifications',0,'Success','2025-12-04 11:20:00',1090908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:06','2025-12-04 11:20:06',1352957,1,NULL,NULL,NULL,'2025-12-04 11:18:02','2025-12-04 11:20:06','687bf5d466067a4ba'),('69316deb044715264','Auth Token Control',0,'Success','2025-12-04 11:24:00',1090909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:04','2025-12-04 11:24:04',1353125,1,NULL,NULL,NULL,'2025-12-04 11:18:03','2025-12-04 11:24:04','687bf5d511e08c57f'),('69316deb3ee90c050','Process Webhook Queue',0,'Success','2025-12-04 11:20:00',1090910,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:06','2025-12-04 11:20:07',1352957,1,NULL,NULL,NULL,'2025-12-04 11:18:03','2025-12-04 11:20:07','687bf5d5788e2fe0e'),('69316e25dabdfa87c','Submit Popup Reminders',0,'Success','2025-12-04 11:19:01',1090911,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:19:04','2025-12-04 11:19:04',1352920,1,NULL,NULL,NULL,'2025-12-04 11:19:01','2025-12-04 11:19:04','687bf57d2f9463790'),('69316e260fa4c021d','Process Job Queue q0',0,'Success','2025-12-04 11:19:02',1090912,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:19:04','2025-12-04 11:19:04',1352920,1,NULL,NULL,NULL,'2025-12-04 11:19:02','2025-12-04 11:19:04','687bf57d693e0fc1f'),('69316e264b40c71a5','Process Job Queue q1',0,'Success','2025-12-04 11:20:00',1090913,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:07','2025-12-04 11:20:07',1352957,1,NULL,NULL,NULL,'2025-12-04 11:19:02','2025-12-04 11:20:07','687bf57d8afb5c472'),('69316e268109d625a','Process Job Queue e0',0,'Success','2025-12-04 11:19:02',1090914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:19:05','2025-12-04 11:19:05',1352920,1,NULL,NULL,NULL,'2025-12-04 11:19:02','2025-12-04 11:19:05','687bf57dbba8299ef'),('69316e618fcdd228d','Submit Popup Reminders',0,'Success','2025-12-04 11:20:01',1090915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:08','2025-12-04 11:20:08',1352957,1,NULL,NULL,NULL,'2025-12-04 11:20:01','2025-12-04 11:20:08','687bf57d2f9463790'),('69316e61bf945c204','Process Job Queue q0',0,'Success','2025-12-04 11:20:01',1090916,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:08','2025-12-04 11:20:09',1352957,1,NULL,NULL,NULL,'2025-12-04 11:20:01','2025-12-04 11:20:09','687bf57d693e0fc1f'),('69316e61e303bae67','Process Job Queue q1',0,'Success','2025-12-04 11:21:00',1090917,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:21:02','2025-12-04 11:21:03',1352990,1,NULL,NULL,NULL,'2025-12-04 11:20:01','2025-12-04 11:21:03','687bf57d8afb5c472'),('69316e621c4de528f','Process Job Queue e0',0,'Success','2025-12-04 11:20:02',1090918,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:20:09','2025-12-04 11:20:09',1352957,1,NULL,NULL,NULL,'2025-12-04 11:20:02','2025-12-04 11:20:09','687bf57dbba8299ef'),('69316e6251208a4a6','Send Email Reminders',0,'Success','2025-12-04 11:22:00',1090919,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:03','2025-12-04 11:22:04',1353031,1,NULL,NULL,NULL,'2025-12-04 11:20:02','2025-12-04 11:22:04','687bf5d44d3e10813'),('69316e6274c0a81cf','Send Email Notifications',0,'Success','2025-12-04 11:22:00',1090920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:04','2025-12-04 11:22:05',1353031,1,NULL,NULL,NULL,'2025-12-04 11:20:02','2025-12-04 11:22:05','687bf5d466067a4ba'),('69316e62a162c54eb','Process Webhook Queue',0,'Success','2025-12-04 11:22:00',1090921,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:05','2025-12-04 11:22:05',1353031,1,NULL,NULL,NULL,'2025-12-04 11:20:02','2025-12-04 11:22:05','687bf5d5788e2fe0e'),('69316e62eccd20416','Send Scheduled Emails',0,'Success','2025-12-04 11:30:00',1090922,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:05','2025-12-04 11:30:05',1353343,1,NULL,NULL,NULL,'2025-12-04 11:20:02','2025-12-04 11:30:05','687bf5d5eeb01d80d'),('69316e9dc4bb7d2d9','Submit Popup Reminders',0,'Success','2025-12-04 11:21:01',1090923,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:21:04','2025-12-04 11:21:04',1352990,1,NULL,NULL,NULL,'2025-12-04 11:21:01','2025-12-04 11:21:04','687bf57d2f9463790'),('69316e9de805b5e40','Process Job Queue q0',0,'Success','2025-12-04 11:21:01',1090924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:21:04','2025-12-04 11:21:04',1352990,1,NULL,NULL,NULL,'2025-12-04 11:21:01','2025-12-04 11:21:04','687bf57d693e0fc1f'),('69316e9e148e25d51','Process Job Queue q1',0,'Success','2025-12-04 11:22:00',1090925,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:06','2025-12-04 11:22:06',1353031,1,NULL,NULL,NULL,'2025-12-04 11:21:02','2025-12-04 11:22:06','687bf57d8afb5c472'),('69316e9e4ebc8762e','Process Job Queue e0',0,'Success','2025-12-04 11:21:02',1090926,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:21:05','2025-12-04 11:21:05',1352990,1,NULL,NULL,NULL,'2025-12-04 11:21:02','2025-12-04 11:21:05','687bf57dbba8299ef'),('69316ed9ea91628bf','Submit Popup Reminders',0,'Success','2025-12-04 11:22:01',1090927,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:06','2025-12-04 11:22:07',1353031,1,NULL,NULL,NULL,'2025-12-04 11:22:01','2025-12-04 11:22:07','687bf57d2f9463790'),('69316eda3a831e5ca','Process Job Queue q0',0,'Success','2025-12-04 11:22:02',1090928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:07','2025-12-04 11:22:07',1353031,1,NULL,NULL,NULL,'2025-12-04 11:22:02','2025-12-04 11:22:07','687bf57d693e0fc1f'),('69316edabaae91c1e','Process Job Queue q1',0,'Success','2025-12-04 11:23:00',1090929,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:23:02','2025-12-04 11:23:02',1353080,1,NULL,NULL,NULL,'2025-12-04 11:22:02','2025-12-04 11:23:02','687bf57d8afb5c472'),('69316edb008e969d2','Process Job Queue e0',0,'Success','2025-12-04 11:22:02',1090930,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:22:08','2025-12-04 11:22:08',1353031,1,NULL,NULL,NULL,'2025-12-04 11:22:03','2025-12-04 11:22:08','687bf57dbba8299ef'),('69316edb40a19d40e','Send Email Reminders',0,'Success','2025-12-04 11:24:00',1090931,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:04','2025-12-04 11:24:05',1353125,1,NULL,NULL,NULL,'2025-12-04 11:22:03','2025-12-04 11:24:05','687bf5d44d3e10813'),('69316edb75769fd75','Send Email Notifications',0,'Success','2025-12-04 11:24:00',1090932,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:05','2025-12-04 11:24:05',1353125,1,NULL,NULL,NULL,'2025-12-04 11:22:03','2025-12-04 11:24:05','687bf5d466067a4ba'),('69316edba96429df6','Process Webhook Queue',0,'Success','2025-12-04 11:24:00',1090933,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:06','2025-12-04 11:24:06',1353125,1,NULL,NULL,NULL,'2025-12-04 11:22:03','2025-12-04 11:24:06','687bf5d5788e2fe0e'),('69316f15ee528c708','Submit Popup Reminders',0,'Success','2025-12-04 11:23:01',1090934,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:23:03','2025-12-04 11:23:04',1353080,1,NULL,NULL,NULL,'2025-12-04 11:23:01','2025-12-04 11:23:04','687bf57d2f9463790'),('69316f1649413b6e2','Process Job Queue q0',0,'Success','2025-12-04 11:23:02',1090935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:23:04','2025-12-04 11:23:05',1353080,1,NULL,NULL,NULL,'2025-12-04 11:23:02','2025-12-04 11:23:05','687bf57d693e0fc1f'),('69316f1671dcc0ad3','Process Job Queue q1',0,'Success','2025-12-04 11:24:00',1090936,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:07','2025-12-04 11:24:07',1353125,1,NULL,NULL,NULL,'2025-12-04 11:23:02','2025-12-04 11:24:07','687bf57d8afb5c472'),('69316f169c53ffe9d','Process Job Queue e0',0,'Success','2025-12-04 11:23:02',1090937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:23:05','2025-12-04 11:23:06',1353080,1,NULL,NULL,NULL,'2025-12-04 11:23:02','2025-12-04 11:23:06','687bf57dbba8299ef'),('69316f5209de6194c','Submit Popup Reminders',0,'Success','2025-12-04 11:24:02',1090938,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:07','2025-12-04 11:24:07',1353125,1,NULL,NULL,NULL,'2025-12-04 11:24:02','2025-12-04 11:24:07','687bf57d2f9463790'),('69316f52684f87857','Process Job Queue q0',0,'Success','2025-12-04 11:24:02',1090939,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:08','2025-12-04 11:24:08',1353125,1,NULL,NULL,NULL,'2025-12-04 11:24:02','2025-12-04 11:24:08','687bf57d693e0fc1f'),('69316f52a7704f9df','Process Job Queue q1',0,'Success','2025-12-04 11:25:00',1090940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:25:02','2025-12-04 11:25:03',1353160,1,NULL,NULL,NULL,'2025-12-04 11:24:02','2025-12-04 11:25:03','687bf57d8afb5c472'),('69316f52e64058ca3','Process Job Queue e0',0,'Success','2025-12-04 11:24:02',1090941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:24:09','2025-12-04 11:24:09',1353125,1,NULL,NULL,NULL,'2025-12-04 11:24:02','2025-12-04 11:24:09','687bf57dbba8299ef'),('69316f53447a97f28','Send Email Reminders',0,'Success','2025-12-04 11:26:00',1090942,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:02','2025-12-04 11:26:02',1353196,1,NULL,NULL,NULL,'2025-12-04 11:24:03','2025-12-04 11:26:02','687bf5d44d3e10813'),('69316f5381e3759a7','Send Email Notifications',0,'Success','2025-12-04 11:26:00',1090943,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:03','2025-12-04 11:26:03',1353196,1,NULL,NULL,NULL,'2025-12-04 11:24:03','2025-12-04 11:26:03','687bf5d466067a4ba'),('69316f53ba778c4f4','Auth Token Control',0,'Success','2025-12-04 11:30:00',1090944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:06','2025-12-04 11:30:06',1353343,1,NULL,NULL,NULL,'2025-12-04 11:24:03','2025-12-04 11:30:06','687bf5d511e08c57f'),('69316f54049c50b68','Process Webhook Queue',0,'Success','2025-12-04 11:26:00',1090945,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:04','2025-12-04 11:26:04',1353196,1,NULL,NULL,NULL,'2025-12-04 11:24:04','2025-12-04 11:26:04','687bf5d5788e2fe0e'),('69316f8e00a0e5d8e','Submit Popup Reminders',0,'Success','2025-12-04 11:25:02',1090946,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:25:03','2025-12-04 11:25:04',1353160,1,NULL,NULL,NULL,'2025-12-04 11:25:02','2025-12-04 11:25:04','687bf57d2f9463790'),('69316f8e3016b15fa','Process Job Queue q0',0,'Success','2025-12-04 11:25:02',1090947,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:25:05','2025-12-04 11:25:05',1353160,1,NULL,NULL,NULL,'2025-12-04 11:25:02','2025-12-04 11:25:05','687bf57d693e0fc1f'),('69316f8e5468ba098','Process Job Queue q1',0,'Success','2025-12-04 11:26:00',1090948,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:05','2025-12-04 11:26:05',1353196,1,NULL,NULL,NULL,'2025-12-04 11:25:02','2025-12-04 11:26:05','687bf57d8afb5c472'),('69316f8e7902a2150','Process Job Queue e0',0,'Success','2025-12-04 11:25:02',1090949,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:25:05','2025-12-04 11:25:06',1353160,1,NULL,NULL,NULL,'2025-12-04 11:25:02','2025-12-04 11:25:06','687bf57dbba8299ef'),('69316fc93bdf498f1','Submit Popup Reminders',0,'Success','2025-12-04 11:26:01',1090950,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:06','2025-12-04 11:26:07',1353196,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:26:07','687bf57d2f9463790'),('69316fc95ded85588','Process Job Queue q0',0,'Success','2025-12-04 11:26:01',1090951,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:07','2025-12-04 11:26:07',1353196,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:26:07','687bf57d693e0fc1f'),('69316fc9849e87526','Process Job Queue q1',0,'Success','2025-12-04 11:27:00',1090952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:27:02','2025-12-04 11:27:02',1353231,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:27:02','687bf57d8afb5c472'),('69316fc9a53fc2fad','Process Job Queue e0',0,'Success','2025-12-04 11:26:01',1090953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:26:08','2025-12-04 11:26:08',1353196,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:26:08','687bf57dbba8299ef'),('69316fc9c8e5e3487','Send Email Reminders',0,'Success','2025-12-04 11:28:00',1090954,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:03','2025-12-04 11:28:03',1353268,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:28:03','687bf5d44d3e10813'),('69316fc9e4ca9b8d0','Send Email Notifications',0,'Success','2025-12-04 11:28:00',1090955,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:04','2025-12-04 11:28:05',1353268,1,NULL,NULL,NULL,'2025-12-04 11:26:01','2025-12-04 11:28:05','687bf5d466067a4ba'),('69316fca1618b7d1c','Process Webhook Queue',0,'Success','2025-12-04 11:28:00',1090956,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:05','2025-12-04 11:28:06',1353268,1,NULL,NULL,NULL,'2025-12-04 11:26:02','2025-12-04 11:28:06','687bf5d5788e2fe0e'),('693170061d1b67adf','Submit Popup Reminders',0,'Success','2025-12-04 11:27:02',1090957,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:27:04','2025-12-04 11:27:04',1353231,1,NULL,NULL,NULL,'2025-12-04 11:27:02','2025-12-04 11:27:04','687bf57d2f9463790'),('693170063ba6d6183','Process Job Queue q0',0,'Success','2025-12-04 11:27:02',1090958,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:27:05','2025-12-04 11:27:05',1353231,1,NULL,NULL,NULL,'2025-12-04 11:27:02','2025-12-04 11:27:05','687bf57d693e0fc1f'),('6931700660a7d9282','Process Job Queue q1',0,'Success','2025-12-04 11:28:00',1090959,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:06','2025-12-04 11:28:06',1353268,1,NULL,NULL,NULL,'2025-12-04 11:27:02','2025-12-04 11:28:06','687bf57d8afb5c472'),('6931700681613d9d5','Process Job Queue e0',0,'Success','2025-12-04 11:27:02',1090960,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:27:05','2025-12-04 11:27:06',1353231,1,NULL,NULL,NULL,'2025-12-04 11:27:02','2025-12-04 11:27:06','687bf57dbba8299ef'),('693170420a4c624da','Submit Popup Reminders',0,'Success','2025-12-04 11:28:02',1090961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:07','2025-12-04 11:28:07',1353268,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:28:07','687bf57d2f9463790'),('693170422bcdfa64e','Process Job Queue q0',0,'Success','2025-12-04 11:28:02',1090962,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:08','2025-12-04 11:28:08',1353268,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:28:08','687bf57d693e0fc1f'),('6931704249cab4843','Process Job Queue q1',0,'Success','2025-12-04 11:29:00',1090963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:29:03','2025-12-04 11:29:03',1353304,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:29:03','687bf57d8afb5c472'),('693170426e54025a1','Process Job Queue e0',0,'Success','2025-12-04 11:28:02',1090964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:28:09','2025-12-04 11:28:09',1353268,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:28:09','687bf57dbba8299ef'),('6931704298df02b9b','Send Email Reminders',0,'Success','2025-12-04 11:30:00',1090965,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:06','2025-12-04 11:30:07',1353343,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:30:07','687bf5d44d3e10813'),('69317042c0539c9ba','Send Email Notifications',0,'Success','2025-12-04 11:30:00',1090966,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:07','2025-12-04 11:30:07',1353343,1,NULL,NULL,NULL,'2025-12-04 11:28:02','2025-12-04 11:30:07','687bf5d466067a4ba'),('6931704332f44f3ff','Process Webhook Queue',0,'Success','2025-12-04 11:30:00',1090967,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:08','2025-12-04 11:30:08',1353343,1,NULL,NULL,NULL,'2025-12-04 11:28:03','2025-12-04 11:30:08','687bf5d5788e2fe0e'),('6931707e0ca20e2b6','Submit Popup Reminders',0,'Success','2025-12-04 11:29:02',1090968,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:29:03','2025-12-04 11:29:04',1353304,1,NULL,NULL,NULL,'2025-12-04 11:29:02','2025-12-04 11:29:04','687bf57d2f9463790'),('6931707e342c3fefe','Process Job Queue q0',0,'Success','2025-12-04 11:29:02',1090969,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:29:04','2025-12-04 11:29:04',1353304,1,NULL,NULL,NULL,'2025-12-04 11:29:02','2025-12-04 11:29:04','687bf57d693e0fc1f'),('6931707e85ee3b172','Process Job Queue q1',0,'Success','2025-12-04 11:30:00',1090970,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:08','2025-12-04 11:30:09',1353343,1,NULL,NULL,NULL,'2025-12-04 11:29:02','2025-12-04 11:30:09','687bf57d8afb5c472'),('6931707ec70f86aad','Process Job Queue e0',0,'Success','2025-12-04 11:29:02',1090971,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:29:05','2025-12-04 11:29:05',1353304,1,NULL,NULL,NULL,'2025-12-04 11:29:02','2025-12-04 11:29:05','687bf57dbba8299ef'),('693170b9d22f0b0d5','Submit Popup Reminders',0,'Success','2025-12-04 11:30:01',1090972,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:09','2025-12-04 11:30:09',1353343,1,NULL,NULL,NULL,'2025-12-04 11:30:01','2025-12-04 11:30:09','687bf57d2f9463790'),('693170b9f191aba21','Process Job Queue q0',0,'Success','2025-12-04 11:30:01',1090973,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:10','2025-12-04 11:30:10',1353343,1,NULL,NULL,NULL,'2025-12-04 11:30:01','2025-12-04 11:30:10','687bf57d693e0fc1f'),('693170ba1a69e9eae','Process Job Queue q1',0,'Success','2025-12-04 11:31:00',1090974,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:31:02','2025-12-04 11:31:02',1353377,1,NULL,NULL,NULL,'2025-12-04 11:30:02','2025-12-04 11:31:02','687bf57d8afb5c472'),('693170ba3724d5441','Process Job Queue e0',0,'Success','2025-12-04 11:30:02',1090975,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:30:11','2025-12-04 11:30:11',1353343,1,NULL,NULL,NULL,'2025-12-04 11:30:02','2025-12-04 11:30:11','687bf57dbba8299ef'),('693170ba65a66051a','Send Email Reminders',0,'Success','2025-12-04 11:32:00',1090976,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:03','2025-12-04 11:32:03',1353414,1,NULL,NULL,NULL,'2025-12-04 11:30:02','2025-12-04 11:32:03','687bf5d44d3e10813'),('693170ba8a7e9496b','Send Email Notifications',0,'Success','2025-12-04 11:32:00',1090977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:03','2025-12-04 11:32:03',1353414,1,NULL,NULL,NULL,'2025-12-04 11:30:02','2025-12-04 11:32:03','687bf5d466067a4ba'),('693170babc2ee47e7','Send Mass Emails',0,'Success','2025-12-04 11:50:00',1090978,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:04','2025-12-04 11:50:04',1354163,1,NULL,NULL,NULL,'2025-12-04 11:30:02','2025-12-04 11:50:04','687bf5d4b535f913f'),('693170bb1681a2046','Auth Token Control',0,'Success','2025-12-04 11:36:00',1090979,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:04','2025-12-04 11:36:04',1353565,1,NULL,NULL,NULL,'2025-12-04 11:30:03','2025-12-04 11:36:04','687bf5d511e08c57f'),('693170bb66d9d5c4a','Process Webhook Queue',0,'Success','2025-12-04 11:32:00',1090980,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:04','2025-12-04 11:32:04',1353414,1,NULL,NULL,NULL,'2025-12-04 11:30:03','2025-12-04 11:32:04','687bf5d5788e2fe0e'),('693170bbeabc9a545','Send Scheduled Emails',0,'Success','2025-12-04 11:40:00',1090981,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:03','2025-12-04 11:40:04',1353782,1,NULL,NULL,NULL,'2025-12-04 11:30:03','2025-12-04 11:40:04','687bf5d5eeb01d80d'),('693170f57f7d31a52','Submit Popup Reminders',0,'Success','2025-12-04 11:31:01',1090982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:31:03','2025-12-04 11:31:03',1353377,1,NULL,NULL,NULL,'2025-12-04 11:31:01','2025-12-04 11:31:03','687bf57d2f9463790'),('693170f5b62662597','Process Job Queue q0',0,'Success','2025-12-04 11:31:01',1090983,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:31:03','2025-12-04 11:31:04',1353377,1,NULL,NULL,NULL,'2025-12-04 11:31:01','2025-12-04 11:31:04','687bf57d693e0fc1f'),('693170f5f2b434c3e','Process Job Queue q1',0,'Success','2025-12-04 11:32:00',1090984,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:05','2025-12-04 11:32:05',1353414,1,NULL,NULL,NULL,'2025-12-04 11:31:01','2025-12-04 11:32:05','687bf57d8afb5c472'),('693170f6338e203a9','Process Job Queue e0',0,'Success','2025-12-04 11:31:02',1090985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:31:04','2025-12-04 11:31:04',1353377,1,NULL,NULL,NULL,'2025-12-04 11:31:02','2025-12-04 11:31:04','687bf57dbba8299ef'),('693171313b82e66ca','Submit Popup Reminders',0,'Success','2025-12-04 11:32:01',1090986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:05','2025-12-04 11:32:05',1353414,1,NULL,NULL,NULL,'2025-12-04 11:32:01','2025-12-04 11:32:05','687bf57d2f9463790'),('693171318694425ea','Process Job Queue q0',0,'Success','2025-12-04 11:32:01',1090987,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:06','2025-12-04 11:32:06',1353414,1,NULL,NULL,NULL,'2025-12-04 11:32:01','2025-12-04 11:32:06','687bf57d693e0fc1f'),('6931713200409cfc8','Process Job Queue q1',0,'Success','2025-12-04 11:33:00',1090988,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:33:03','2025-12-04 11:33:03',1353454,1,NULL,NULL,NULL,'2025-12-04 11:32:02','2025-12-04 11:33:03','687bf57d8afb5c472'),('69317132369e64e4a','Process Job Queue e0',0,'Success','2025-12-04 11:32:02',1090989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:32:07','2025-12-04 11:32:07',1353414,1,NULL,NULL,NULL,'2025-12-04 11:32:02','2025-12-04 11:32:07','687bf57dbba8299ef'),('693171326f517bbb4','Send Email Reminders',0,'Success','2025-12-04 11:34:00',1090990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:02','2025-12-04 11:34:03',1353494,1,NULL,NULL,NULL,'2025-12-04 11:32:02','2025-12-04 11:34:03','687bf5d44d3e10813'),('6931713290e070c27','Send Email Notifications',0,'Success','2025-12-04 11:34:00',1090991,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:04','2025-12-04 11:34:04',1353494,1,NULL,NULL,NULL,'2025-12-04 11:32:02','2025-12-04 11:34:04','687bf5d466067a4ba'),('69317132c53d6e634','Process Webhook Queue',0,'Success','2025-12-04 11:34:00',1090992,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:04','2025-12-04 11:34:05',1353494,1,NULL,NULL,NULL,'2025-12-04 11:32:02','2025-12-04 11:34:05','687bf5d5788e2fe0e'),('6931716e21cc2985b','Submit Popup Reminders',0,'Success','2025-12-04 11:33:02',1090993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:33:04','2025-12-04 11:33:04',1353454,1,NULL,NULL,NULL,'2025-12-04 11:33:02','2025-12-04 11:33:04','687bf57d2f9463790'),('6931716e56fd58e85','Process Job Queue q0',0,'Success','2025-12-04 11:33:02',1090994,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:33:04','2025-12-04 11:33:05',1353454,1,NULL,NULL,NULL,'2025-12-04 11:33:02','2025-12-04 11:33:05','687bf57d693e0fc1f'),('6931716e831182073','Process Job Queue q1',0,'Success','2025-12-04 11:34:00',1090995,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:05','2025-12-04 11:34:05',1353494,1,NULL,NULL,NULL,'2025-12-04 11:33:02','2025-12-04 11:34:05','687bf57d8afb5c472'),('6931716ef2deb363d','Process Job Queue e0',0,'Success','2025-12-04 11:33:02',1090996,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:33:05','2025-12-04 11:33:05',1353454,1,NULL,NULL,NULL,'2025-12-04 11:33:02','2025-12-04 11:33:05','687bf57dbba8299ef'),('693171a959cf55137','Submit Popup Reminders',0,'Success','2025-12-04 11:34:01',1090997,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:06','2025-12-04 11:34:07',1353494,1,NULL,NULL,NULL,'2025-12-04 11:34:01','2025-12-04 11:34:07','687bf57d2f9463790'),('693171a9870e885cf','Process Job Queue q0',0,'Success','2025-12-04 11:34:01',1090998,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:07','2025-12-04 11:34:07',1353494,1,NULL,NULL,NULL,'2025-12-04 11:34:01','2025-12-04 11:34:07','687bf57d693e0fc1f'),('693171a9a4705826f','Process Job Queue q1',0,'Success','2025-12-04 11:35:00',1090999,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:35:02','2025-12-04 11:35:03',1353529,1,NULL,NULL,NULL,'2025-12-04 11:34:01','2025-12-04 11:35:03','687bf57d8afb5c472'),('693171a9c535b524b','Process Job Queue e0',0,'Success','2025-12-04 11:34:01',1091000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:34:08','2025-12-04 11:34:08',1353494,1,NULL,NULL,NULL,'2025-12-04 11:34:01','2025-12-04 11:34:08','687bf57dbba8299ef'),('693171a9ee49aa793','Send Email Reminders',0,'Success','2025-12-04 11:36:00',1091001,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:05','2025-12-04 11:36:05',1353565,1,NULL,NULL,NULL,'2025-12-04 11:34:01','2025-12-04 11:36:05','687bf5d44d3e10813'),('693171aa443131e1f','Send Email Notifications',0,'Success','2025-12-04 11:36:00',1091002,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:06','2025-12-04 11:36:06',1353565,1,NULL,NULL,NULL,'2025-12-04 11:34:02','2025-12-04 11:36:06','687bf5d466067a4ba'),('693171aaadee358c3','Process Webhook Queue',0,'Success','2025-12-04 11:36:00',1091003,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:06','2025-12-04 11:36:07',1353565,1,NULL,NULL,NULL,'2025-12-04 11:34:02','2025-12-04 11:36:07','687bf5d5788e2fe0e'),('693171e5aa8efa214','Submit Popup Reminders',0,'Success','2025-12-04 11:35:01',1091004,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:35:03','2025-12-04 11:35:04',1353529,1,NULL,NULL,NULL,'2025-12-04 11:35:01','2025-12-04 11:35:04','687bf57d2f9463790'),('693171e5d737436c6','Process Job Queue q0',0,'Success','2025-12-04 11:35:01',1091005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:35:04','2025-12-04 11:35:05',1353529,1,NULL,NULL,NULL,'2025-12-04 11:35:01','2025-12-04 11:35:05','687bf57d693e0fc1f'),('693171e5f1dd2d875','Process Job Queue q1',0,'Success','2025-12-04 11:36:00',1091006,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:07','2025-12-04 11:36:07',1353565,1,NULL,NULL,NULL,'2025-12-04 11:35:01','2025-12-04 11:36:07','687bf57d8afb5c472'),('693171e619b95522c','Process Job Queue e0',0,'Success','2025-12-04 11:35:02',1091007,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:35:05','2025-12-04 11:35:05',1353529,1,NULL,NULL,NULL,'2025-12-04 11:35:02','2025-12-04 11:35:05','687bf57dbba8299ef'),('69317221e6186aac1','Submit Popup Reminders',0,'Success','2025-12-04 11:36:01',1091008,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:08','2025-12-04 11:36:08',1353565,1,NULL,NULL,NULL,'2025-12-04 11:36:01','2025-12-04 11:36:08','687bf57d2f9463790'),('693172221ec658b75','Process Job Queue q0',0,'Success','2025-12-04 11:36:02',1091009,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:08','2025-12-04 11:36:09',1353565,1,NULL,NULL,NULL,'2025-12-04 11:36:02','2025-12-04 11:36:09','687bf57d693e0fc1f'),('693172224e24f001f','Process Job Queue q1',0,'Success','2025-12-04 11:37:00',1091010,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:37:02','2025-12-04 11:37:03',1353606,1,NULL,NULL,NULL,'2025-12-04 11:36:02','2025-12-04 11:37:03','687bf57d8afb5c472'),('69317222738693afd','Process Job Queue e0',0,'Success','2025-12-04 11:36:02',1091011,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:36:09','2025-12-04 11:36:09',1353565,1,NULL,NULL,NULL,'2025-12-04 11:36:02','2025-12-04 11:36:09','687bf57dbba8299ef'),('69317223338df694a','Send Email Reminders',0,'Success','2025-12-04 11:38:00',1091012,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:38:03',1353642,1,NULL,NULL,NULL,'2025-12-04 11:36:03','2025-12-04 11:38:03','687bf5d44d3e10813'),('693172238518b22f5','Send Email Notifications',0,'Success','2025-12-04 11:38:00',1091013,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:03','2025-12-04 11:38:04',1353642,1,NULL,NULL,NULL,'2025-12-04 11:36:03','2025-12-04 11:38:04','687bf5d466067a4ba'),('69317223d8f3824d0','Auth Token Control',0,'Success','2025-12-04 11:42:00',1091014,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:03','2025-12-04 11:42:03',1353860,1,NULL,NULL,NULL,'2025-12-04 11:36:03','2025-12-04 11:42:03','687bf5d511e08c57f'),('6931722435f34b6cc','Process Webhook Queue',0,'Success','2025-12-04 11:38:00',1091015,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:04','2025-12-04 11:38:05',1353642,1,NULL,NULL,NULL,'2025-12-04 11:36:04','2025-12-04 11:38:05','687bf5d5788e2fe0e'),('6931725de35be1aa7','Submit Popup Reminders',0,'Success','2025-12-04 11:37:01',1091016,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:37:03','2025-12-04 11:37:04',1353606,1,NULL,NULL,NULL,'2025-12-04 11:37:01','2025-12-04 11:37:04','687bf57d2f9463790'),('6931725e13397984c','Process Job Queue q0',0,'Success','2025-12-04 11:37:02',1091017,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:37:04','2025-12-04 11:37:05',1353606,1,NULL,NULL,NULL,'2025-12-04 11:37:02','2025-12-04 11:37:05','687bf57d693e0fc1f'),('6931725e426faf144','Process Job Queue q1',0,'Success','2025-12-04 11:38:00',1091018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:05','2025-12-04 11:38:06',1353642,1,NULL,NULL,NULL,'2025-12-04 11:37:02','2025-12-04 11:38:06','687bf57d8afb5c472'),('6931725e784bc176a','Process Job Queue e0',0,'Success','2025-12-04 11:37:02',1091019,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:37:05','2025-12-04 11:37:05',1353606,1,NULL,NULL,NULL,'2025-12-04 11:37:02','2025-12-04 11:37:05','687bf57dbba8299ef'),('69317299b4bb0c35a','Submit Popup Reminders',0,'Success','2025-12-04 11:38:01',1091020,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:07','2025-12-04 11:38:07',1353642,1,NULL,NULL,NULL,'2025-12-04 11:38:01','2025-12-04 11:38:07','687bf57d2f9463790'),('69317299e55e21643','Process Job Queue q0',0,'Success','2025-12-04 11:38:01',1091021,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:08','2025-12-04 11:38:08',1353642,1,NULL,NULL,NULL,'2025-12-04 11:38:01','2025-12-04 11:38:08','687bf57d693e0fc1f'),('6931729a183e6975e','Process Job Queue q1',0,'Success','2025-12-04 11:39:00',1091022,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:39:02','2025-12-04 11:39:03',1353680,1,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:39:03','687bf57d8afb5c472'),('6931729a358acbd89','Process Job Queue e0',0,'Success','2025-12-04 11:38:02',1091023,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:38:09','2025-12-04 11:38:09',1353642,1,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:38:09','687bf57dbba8299ef'),('6931729a5bafec8ef','Send Email Reminders',0,'Success','2025-12-04 11:40:00',1091024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:04','2025-12-04 11:40:04',1353782,1,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:40:04','687bf5d44d3e10813'),('6931729a7bb22204d','Send Email Notifications',0,'Success','2025-12-04 11:40:00',1091025,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:05','2025-12-04 11:40:05',1353782,1,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:40:05','687bf5d466067a4ba'),('6931729a9e8aa124e','Process Webhook Queue',0,'Success','2025-12-04 11:40:00',1091026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:06','2025-12-04 11:40:06',1353782,1,NULL,NULL,NULL,'2025-12-04 11:38:02','2025-12-04 11:40:06','687bf5d5788e2fe0e'),('693172d57259fee6a','Submit Popup Reminders',0,'Success','2025-12-04 11:39:01',1091027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:39:04','2025-12-04 11:39:04',1353680,1,NULL,NULL,NULL,'2025-12-04 11:39:01','2025-12-04 11:39:04','687bf57d2f9463790'),('693172d5960e4747a','Process Job Queue q0',0,'Success','2025-12-04 11:39:01',1091028,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:39:05','2025-12-04 11:39:05',1353680,1,NULL,NULL,NULL,'2025-12-04 11:39:01','2025-12-04 11:39:05','687bf57d693e0fc1f'),('693172d5d16d1a414','Process Job Queue q1',0,'Success','2025-12-04 11:40:00',1091029,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:07','2025-12-04 11:40:07',1353782,1,NULL,NULL,NULL,'2025-12-04 11:39:01','2025-12-04 11:40:07','687bf57d8afb5c472'),('693172d6154bde6f9','Process Job Queue e0',0,'Success','2025-12-04 11:39:02',1091030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:39:05','2025-12-04 11:39:06',1353680,1,NULL,NULL,NULL,'2025-12-04 11:39:02','2025-12-04 11:39:06','687bf57dbba8299ef'),('69317311b5234b64b','Submit Popup Reminders',0,'Success','2025-12-04 11:40:01',1091031,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:07','2025-12-04 11:40:07',1353782,1,NULL,NULL,NULL,'2025-12-04 11:40:01','2025-12-04 11:40:07','687bf57d2f9463790'),('69317311e0a718efc','Process Job Queue q0',0,'Success','2025-12-04 11:40:01',1091032,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:08','2025-12-04 11:40:09',1353782,1,NULL,NULL,NULL,'2025-12-04 11:40:01','2025-12-04 11:40:09','687bf57d693e0fc1f'),('693173120df23d2cf','Process Job Queue q1',0,'Success','2025-12-04 11:41:00',1091033,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:41:02','2025-12-04 11:41:02',1353822,1,NULL,NULL,NULL,'2025-12-04 11:40:02','2025-12-04 11:41:02','687bf57d8afb5c472'),('69317312390fba68a','Process Job Queue e0',0,'Success','2025-12-04 11:40:02',1091034,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:40:09','2025-12-04 11:40:10',1353782,1,NULL,NULL,NULL,'2025-12-04 11:40:02','2025-12-04 11:40:10','687bf57dbba8299ef'),('69317312791dc7da0','Send Email Reminders',0,'Success','2025-12-04 11:42:00',1091035,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:04','2025-12-04 11:42:04',1353860,1,NULL,NULL,NULL,'2025-12-04 11:40:02','2025-12-04 11:42:04','687bf5d44d3e10813'),('69317312d4a85d271','Send Email Notifications',0,'Success','2025-12-04 11:42:00',1091036,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:05','2025-12-04 11:42:05',1353860,1,NULL,NULL,NULL,'2025-12-04 11:40:02','2025-12-04 11:42:05','687bf5d466067a4ba'),('693173130b87d2020','Process Webhook Queue',0,'Success','2025-12-04 11:42:00',1091037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:06','2025-12-04 11:42:06',1353860,1,NULL,NULL,NULL,'2025-12-04 11:40:03','2025-12-04 11:42:06','687bf5d5788e2fe0e'),('69317313a78c4cd8a','Send Scheduled Emails',0,'Success','2025-12-04 11:50:00',1091038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:05','2025-12-04 11:50:05',1354163,1,NULL,NULL,NULL,'2025-12-04 11:40:03','2025-12-04 11:50:05','687bf5d5eeb01d80d'),('6931734dcf3834190','Submit Popup Reminders',0,'Success','2025-12-04 11:41:01',1091039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:41:03','2025-12-04 11:41:04',1353822,1,NULL,NULL,NULL,'2025-12-04 11:41:01','2025-12-04 11:41:04','687bf57d2f9463790'),('6931734e0aaa669a7','Process Job Queue q0',0,'Success','2025-12-04 11:41:02',1091040,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:41:04','2025-12-04 11:41:05',1353822,1,NULL,NULL,NULL,'2025-12-04 11:41:02','2025-12-04 11:41:05','687bf57d693e0fc1f'),('6931734e335970a8e','Process Job Queue q1',0,'Success','2025-12-04 11:42:00',1091041,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:07','2025-12-04 11:42:07',1353860,1,NULL,NULL,NULL,'2025-12-04 11:41:02','2025-12-04 11:42:07','687bf57d8afb5c472'),('6931734e572fab765','Process Job Queue e0',0,'Success','2025-12-04 11:41:02',1091042,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:41:05','2025-12-04 11:41:06',1353822,1,NULL,NULL,NULL,'2025-12-04 11:41:02','2025-12-04 11:41:06','687bf57dbba8299ef'),('6931738991fa34dde','Submit Popup Reminders',0,'Success','2025-12-04 11:42:01',1091043,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:07','2025-12-04 11:42:07',1353860,1,NULL,NULL,NULL,'2025-12-04 11:42:01','2025-12-04 11:42:07','687bf57d2f9463790'),('69317389bf8fc2010','Process Job Queue q0',0,'Success','2025-12-04 11:42:01',1091044,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:08','2025-12-04 11:42:08',1353860,1,NULL,NULL,NULL,'2025-12-04 11:42:01','2025-12-04 11:42:08','687bf57d693e0fc1f'),('69317389e1b241902','Process Job Queue q1',0,'Success','2025-12-04 11:43:00',1091045,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:43:02','2025-12-04 11:43:02',1353902,1,NULL,NULL,NULL,'2025-12-04 11:42:01','2025-12-04 11:43:02','687bf57d8afb5c472'),('6931738a2042371e1','Process Job Queue e0',0,'Success','2025-12-04 11:42:02',1091046,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:42:09','2025-12-04 11:42:09',1353860,1,NULL,NULL,NULL,'2025-12-04 11:42:02','2025-12-04 11:42:09','687bf57dbba8299ef'),('6931738a84975816b','Send Email Reminders',0,'Success','2025-12-04 11:44:00',1091047,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:03','2025-12-04 11:44:03',1353938,1,NULL,NULL,NULL,'2025-12-04 11:42:02','2025-12-04 11:44:03','687bf5d44d3e10813'),('6931738ab3b9aa314','Send Email Notifications',0,'Success','2025-12-04 11:44:00',1091048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:04','2025-12-04 11:44:04',1353938,1,NULL,NULL,NULL,'2025-12-04 11:42:02','2025-12-04 11:44:04','687bf5d466067a4ba'),('6931738b1369fede3','Auth Token Control',0,'Success','2025-12-04 11:48:00',1091049,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:03','2025-12-04 11:48:03',1354091,1,NULL,NULL,NULL,'2025-12-04 11:42:03','2025-12-04 11:48:03','687bf5d511e08c57f'),('6931738b3c542db93','Process Webhook Queue',0,'Success','2025-12-04 11:44:00',1091050,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:05','2025-12-04 11:44:05',1353938,1,NULL,NULL,NULL,'2025-12-04 11:42:03','2025-12-04 11:44:05','687bf5d5788e2fe0e'),('693173c6043666842','Submit Popup Reminders',0,'Success','2025-12-04 11:43:02',1091051,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:43:03','2025-12-04 11:43:04',1353902,1,NULL,NULL,NULL,'2025-12-04 11:43:02','2025-12-04 11:43:04','687bf57d2f9463790'),('693173c629ee9f5cd','Process Job Queue q0',0,'Success','2025-12-04 11:43:02',1091052,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:43:05','2025-12-04 11:43:05',1353902,1,NULL,NULL,NULL,'2025-12-04 11:43:02','2025-12-04 11:43:05','687bf57d693e0fc1f'),('693173c6578b3338e','Process Job Queue q1',0,'Success','2025-12-04 11:44:00',1091053,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:05','2025-12-04 11:44:06',1353938,1,NULL,NULL,NULL,'2025-12-04 11:43:02','2025-12-04 11:44:06','687bf57d8afb5c472'),('693173c682edf5a41','Process Job Queue e0',0,'Success','2025-12-04 11:43:02',1091054,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:43:06','2025-12-04 11:43:06',1353902,1,NULL,NULL,NULL,'2025-12-04 11:43:02','2025-12-04 11:43:06','687bf57dbba8299ef'),('693174018402c5876','Submit Popup Reminders',0,'Success','2025-12-04 11:44:01',1091055,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:06','2025-12-04 11:44:07',1353938,1,NULL,NULL,NULL,'2025-12-04 11:44:01','2025-12-04 11:44:07','687bf57d2f9463790'),('69317401b5206c9ee','Process Job Queue q0',0,'Success','2025-12-04 11:44:01',1091056,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:07','2025-12-04 11:44:07',1353938,1,NULL,NULL,NULL,'2025-12-04 11:44:01','2025-12-04 11:44:07','687bf57d693e0fc1f'),('69317401e7eab3645','Process Job Queue q1',0,'Success','2025-12-04 11:45:00',1091057,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:45:02','2025-12-04 11:45:02',1353974,1,NULL,NULL,NULL,'2025-12-04 11:44:01','2025-12-04 11:45:02','687bf57d8afb5c472'),('693174022a1320020','Process Job Queue e0',0,'Success','2025-12-04 11:44:02',1091058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:44:08','2025-12-04 11:44:08',1353938,1,NULL,NULL,NULL,'2025-12-04 11:44:02','2025-12-04 11:44:08','687bf57dbba8299ef'),('69317402502817151','Send Email Reminders',0,'Success','2025-12-04 11:46:00',1091059,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:03','2025-12-04 11:46:03',1354009,1,NULL,NULL,NULL,'2025-12-04 11:44:02','2025-12-04 11:46:03','687bf5d44d3e10813'),('69317402ab0177702','Send Email Notifications',0,'Success','2025-12-04 11:46:00',1091060,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:04','2025-12-04 11:46:04',1354009,1,NULL,NULL,NULL,'2025-12-04 11:44:02','2025-12-04 11:46:04','687bf5d466067a4ba'),('6931740349d9309fd','Process Webhook Queue',0,'Success','2025-12-04 11:46:00',1091061,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:05','2025-12-04 11:46:06',1354009,1,NULL,NULL,NULL,'2025-12-04 11:44:03','2025-12-04 11:46:06','687bf5d5788e2fe0e'),('6931743d5ca706f83','Submit Popup Reminders',0,'Success','2025-12-04 11:45:01',1091062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:45:03','2025-12-04 11:45:04',1353974,1,NULL,NULL,NULL,'2025-12-04 11:45:01','2025-12-04 11:45:04','687bf57d2f9463790'),('6931743d8f8cee5c1','Process Job Queue q0',0,'Success','2025-12-04 11:45:01',1091063,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:45:04','2025-12-04 11:45:05',1353974,1,NULL,NULL,NULL,'2025-12-04 11:45:01','2025-12-04 11:45:05','687bf57d693e0fc1f'),('6931743db778af330','Process Job Queue q1',0,'Success','2025-12-04 11:46:00',1091064,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:06','2025-12-04 11:46:07',1354009,1,NULL,NULL,NULL,'2025-12-04 11:45:01','2025-12-04 11:46:07','687bf57d8afb5c472'),('6931743e019a45b25','Process Job Queue e0',0,'Success','2025-12-04 11:45:02',1091065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:45:05','2025-12-04 11:45:05',1353974,1,NULL,NULL,NULL,'2025-12-04 11:45:02','2025-12-04 11:45:05','687bf57dbba8299ef'),('6931747a0674ada3b','Submit Popup Reminders',0,'Success','2025-12-04 11:46:02',1091066,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:07','2025-12-04 11:46:08',1354009,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:46:08','687bf57d2f9463790'),('6931747a388632e90','Process Job Queue q0',0,'Success','2025-12-04 11:46:02',1091067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:08','2025-12-04 11:46:08',1354009,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:46:08','687bf57d693e0fc1f'),('6931747a6343b1e28','Process Job Queue q1',0,'Success','2025-12-04 11:47:00',1091068,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:47:02','2025-12-04 11:47:03',1354053,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:47:03','687bf57d8afb5c472'),('6931747a851b8b651','Process Job Queue e0',0,'Success','2025-12-04 11:46:02',1091069,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:46:09','2025-12-04 11:46:09',1354009,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:46:09','687bf57dbba8299ef'),('6931747aa78ed6a39','Send Email Reminders',0,'Success','2025-12-04 11:48:00',1091070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:04','2025-12-04 11:48:04',1354091,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:48:04','687bf5d44d3e10813'),('6931747ac96281557','Send Email Notifications',0,'Success','2025-12-04 11:48:00',1091071,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:05','2025-12-04 11:48:05',1354091,1,NULL,NULL,NULL,'2025-12-04 11:46:02','2025-12-04 11:48:05','687bf5d466067a4ba'),('6931747b088e06a70','Process Webhook Queue',0,'Success','2025-12-04 11:48:00',1091072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:06','2025-12-04 11:48:06',1354091,1,NULL,NULL,NULL,'2025-12-04 11:46:03','2025-12-04 11:48:06','687bf5d5788e2fe0e'),('693174b60229307e7','Submit Popup Reminders',0,'Success','2025-12-04 11:47:02',1091073,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:47:04','2025-12-04 11:47:04',1354053,1,NULL,NULL,NULL,'2025-12-04 11:47:02','2025-12-04 11:47:04','687bf57d2f9463790'),('693174b62894688dd','Process Job Queue q0',0,'Success','2025-12-04 11:47:02',1091074,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:47:05','2025-12-04 11:47:05',1354053,1,NULL,NULL,NULL,'2025-12-04 11:47:02','2025-12-04 11:47:05','687bf57d693e0fc1f'),('693174b6475efc2c7','Process Job Queue q1',0,'Success','2025-12-04 11:48:00',1091075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:07','2025-12-04 11:48:07',1354091,1,NULL,NULL,NULL,'2025-12-04 11:47:02','2025-12-04 11:48:07','687bf57d8afb5c472'),('693174b66b35cb329','Process Job Queue e0',0,'Success','2025-12-04 11:47:02',1091076,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:47:05','2025-12-04 11:47:05',1354053,1,NULL,NULL,NULL,'2025-12-04 11:47:02','2025-12-04 11:47:05','687bf57dbba8299ef'),('693174f185f9a7306','Submit Popup Reminders',0,'Success','2025-12-04 11:48:01',1091077,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:07','2025-12-04 11:48:08',1354091,1,NULL,NULL,NULL,'2025-12-04 11:48:01','2025-12-04 11:48:08','687bf57d2f9463790'),('693174f1b283f92b9','Process Job Queue q0',0,'Success','2025-12-04 11:48:01',1091078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:08','2025-12-04 11:48:08',1354091,1,NULL,NULL,NULL,'2025-12-04 11:48:01','2025-12-04 11:48:08','687bf57d693e0fc1f'),('693174f1e110019f8','Process Job Queue q1',0,'Success','2025-12-04 11:49:00',1091079,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:49:02','2025-12-04 11:49:02',1354125,1,NULL,NULL,NULL,'2025-12-04 11:48:01','2025-12-04 11:49:02','687bf57d8afb5c472'),('693174f2129c7b4f6','Process Job Queue e0',0,'Success','2025-12-04 11:48:02',1091080,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:48:09','2025-12-04 11:48:09',1354091,1,NULL,NULL,NULL,'2025-12-04 11:48:02','2025-12-04 11:48:09','687bf57dbba8299ef'),('693174f2a10421e57','Send Email Reminders',0,'Success','2025-12-04 11:50:00',1091081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:06','2025-12-04 11:50:06',1354163,1,NULL,NULL,NULL,'2025-12-04 11:48:02','2025-12-04 11:50:06','687bf5d44d3e10813'),('693174f2d311079be','Send Email Notifications',0,'Success','2025-12-04 11:50:00',1091082,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:06','2025-12-04 11:50:07',1354163,1,NULL,NULL,NULL,'2025-12-04 11:48:02','2025-12-04 11:50:07','687bf5d466067a4ba'),('693174f330d5802cd','Auth Token Control',0,'Success','2025-12-04 11:54:00',1091083,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:03','2025-12-04 11:54:04',1354316,1,NULL,NULL,NULL,'2025-12-04 11:48:03','2025-12-04 11:54:04','687bf5d511e08c57f'),('693174f38849942e1','Process Webhook Queue',0,'Success','2025-12-04 11:50:00',1091084,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:07','2025-12-04 11:50:07',1354163,1,NULL,NULL,NULL,'2025-12-04 11:48:03','2025-12-04 11:50:07','687bf5d5788e2fe0e'),('6931752da4e7587a9','Submit Popup Reminders',0,'Success','2025-12-04 11:49:01',1091085,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:49:03','2025-12-04 11:49:04',1354125,1,NULL,NULL,NULL,'2025-12-04 11:49:01','2025-12-04 11:49:04','687bf57d2f9463790'),('6931752dce017ab15','Process Job Queue q0',0,'Success','2025-12-04 11:49:01',1091086,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:49:04','2025-12-04 11:49:05',1354125,1,NULL,NULL,NULL,'2025-12-04 11:49:01','2025-12-04 11:49:05','687bf57d693e0fc1f'),('6931752debf575de7','Process Job Queue q1',0,'Success','2025-12-04 11:50:00',1091087,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:08','2025-12-04 11:50:08',1354163,1,NULL,NULL,NULL,'2025-12-04 11:49:01','2025-12-04 11:50:08','687bf57d8afb5c472'),('6931752e16b62ed61','Process Job Queue e0',0,'Success','2025-12-04 11:49:02',1091088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:49:05','2025-12-04 11:49:06',1354125,1,NULL,NULL,NULL,'2025-12-04 11:49:02','2025-12-04 11:49:06','687bf57dbba8299ef'),('693175699745d77db','Submit Popup Reminders',0,'Success','2025-12-04 11:50:01',1091089,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:08','2025-12-04 11:50:09',1354163,1,NULL,NULL,NULL,'2025-12-04 11:50:01','2025-12-04 11:50:09','687bf57d2f9463790'),('69317569bd6a663bc','Process Job Queue q0',0,'Success','2025-12-04 11:50:01',1091090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:09','2025-12-04 11:50:09',1354163,1,NULL,NULL,NULL,'2025-12-04 11:50:01','2025-12-04 11:50:09','687bf57d693e0fc1f'),('69317569e63e8d885','Process Job Queue q1',0,'Success','2025-12-04 11:51:00',1091091,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:51:02','2025-12-04 11:51:02',1354197,1,NULL,NULL,NULL,'2025-12-04 11:50:01','2025-12-04 11:51:02','687bf57d8afb5c472'),('6931756a15f724aef','Process Job Queue e0',0,'Success','2025-12-04 11:50:02',1091092,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:50:10','2025-12-04 11:50:10',1354163,1,NULL,NULL,NULL,'2025-12-04 11:50:02','2025-12-04 11:50:10','687bf57dbba8299ef'),('6931756a43561b962','Send Email Reminders',0,'Success','2025-12-04 11:52:00',1091093,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:03','2025-12-04 11:52:03',1354235,1,NULL,NULL,NULL,'2025-12-04 11:50:02','2025-12-04 11:52:03','687bf5d44d3e10813'),('6931756a84aa522d1','Send Email Notifications',0,'Success','2025-12-04 11:52:00',1091094,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:04','2025-12-04 11:52:04',1354235,1,NULL,NULL,NULL,'2025-12-04 11:50:02','2025-12-04 11:52:04','687bf5d466067a4ba'),('6931756b572e1f878','Send Mass Emails',0,'Success','2025-12-04 12:10:00',1091095,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:03','2025-12-04 12:10:04',1354983,1,NULL,NULL,NULL,'2025-12-04 11:50:03','2025-12-04 12:10:04','687bf5d4b535f913f'),('6931756b927296e75','Process Webhook Queue',0,'Success','2025-12-04 11:52:00',1091096,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:05','2025-12-04 11:52:05',1354235,1,NULL,NULL,NULL,'2025-12-04 11:50:03','2025-12-04 11:52:05','687bf5d5788e2fe0e'),('6931756bec79afe12','Send Scheduled Emails',0,'Success','2025-12-04 12:00:00',1091097,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:04','2025-12-04 12:00:04',1354540,1,NULL,NULL,NULL,'2025-12-04 11:50:03','2025-12-04 12:00:04','687bf5d5eeb01d80d'),('693175a5b6c840733','Submit Popup Reminders',0,'Success','2025-12-04 11:51:01',1091098,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:51:03','2025-12-04 11:51:03',1354197,1,NULL,NULL,NULL,'2025-12-04 11:51:01','2025-12-04 11:51:03','687bf57d2f9463790'),('693175a5d35730f91','Process Job Queue q0',0,'Success','2025-12-04 11:51:01',1091099,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:51:04','2025-12-04 11:51:04',1354197,1,NULL,NULL,NULL,'2025-12-04 11:51:01','2025-12-04 11:51:04','687bf57d693e0fc1f'),('693175a5f41f9b016','Process Job Queue q1',0,'Success','2025-12-04 11:52:00',1091100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:06','2025-12-04 11:52:06',1354235,1,NULL,NULL,NULL,'2025-12-04 11:51:01','2025-12-04 11:52:06','687bf57d8afb5c472'),('693175a61ea8f1060','Process Job Queue e0',0,'Success','2025-12-04 11:51:02',1091101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:51:05','2025-12-04 11:51:05',1354197,1,NULL,NULL,NULL,'2025-12-04 11:51:02','2025-12-04 11:51:05','687bf57dbba8299ef'),('693175e1d636e3f8f','Submit Popup Reminders',0,'Success','2025-12-04 11:52:01',1091102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:07','2025-12-04 11:52:07',1354235,1,NULL,NULL,NULL,'2025-12-04 11:52:01','2025-12-04 11:52:07','687bf57d2f9463790'),('693175e205a8d6077','Process Job Queue q0',0,'Success','2025-12-04 11:52:02',1091103,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:07','2025-12-04 11:52:07',1354235,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:52:07','687bf57d693e0fc1f'),('693175e22bbcd551b','Process Job Queue q1',0,'Success','2025-12-04 11:53:00',1091104,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:53:01','2025-12-04 11:53:02',1354276,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:53:02','687bf57d8afb5c472'),('693175e24aa029814','Process Job Queue e0',0,'Success','2025-12-04 11:52:02',1091105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:52:08','2025-12-04 11:52:08',1354235,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:52:08','687bf57dbba8299ef'),('693175e26ab4e64d8','Send Email Reminders',0,'Success','2025-12-04 11:54:00',1091106,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:05','2025-12-04 11:54:05',1354316,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:54:05','687bf5d44d3e10813'),('693175e292bfb0488','Send Email Notifications',0,'Success','2025-12-04 11:54:00',1091107,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:06','2025-12-04 11:54:06',1354316,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:54:06','687bf5d466067a4ba'),('693175e2b72d98468','Process Webhook Queue',0,'Success','2025-12-04 11:54:00',1091108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:07','2025-12-04 11:54:07',1354316,1,NULL,NULL,NULL,'2025-12-04 11:52:02','2025-12-04 11:54:07','687bf5d5788e2fe0e'),('6931761d66c5e699f','Submit Popup Reminders',0,'Success','2025-12-04 11:53:01',1091109,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:53:02','2025-12-04 11:53:03',1354276,1,NULL,NULL,NULL,'2025-12-04 11:53:01','2025-12-04 11:53:03','687bf57d2f9463790'),('6931761d88656314c','Process Job Queue q0',0,'Success','2025-12-04 11:53:01',1091110,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:53:04','2025-12-04 11:53:04',1354276,1,NULL,NULL,NULL,'2025-12-04 11:53:01','2025-12-04 11:53:04','687bf57d693e0fc1f'),('6931761da63bc709e','Process Job Queue q1',0,'Success','2025-12-04 11:54:00',1091111,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:08','2025-12-04 11:54:08',1354316,1,NULL,NULL,NULL,'2025-12-04 11:53:01','2025-12-04 11:54:08','687bf57d8afb5c472'),('6931761dbce2d5b8b','Process Job Queue e0',0,'Success','2025-12-04 11:53:01',1091112,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:53:05','2025-12-04 11:53:05',1354276,1,NULL,NULL,NULL,'2025-12-04 11:53:01','2025-12-04 11:53:05','687bf57dbba8299ef'),('69317659e5b56733c','Submit Popup Reminders',0,'Success','2025-12-04 11:54:01',1091113,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:08','2025-12-04 11:54:08',1354316,1,NULL,NULL,NULL,'2025-12-04 11:54:01','2025-12-04 11:54:08','687bf57d2f9463790'),('6931765a21b1f4925','Process Job Queue q0',0,'Success','2025-12-04 11:54:02',1091114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:09','2025-12-04 11:54:09',1354316,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 11:54:09','687bf57d693e0fc1f'),('6931765a4aa99f548','Process Job Queue q1',0,'Success','2025-12-04 11:55:00',1091115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:55:02','2025-12-04 11:55:02',1354354,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 11:55:02','687bf57d8afb5c472'),('6931765a6a1486822','Process Job Queue e0',0,'Success','2025-12-04 11:54:02',1091116,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:54:09','2025-12-04 11:54:09',1354316,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 11:54:09','687bf57dbba8299ef'),('6931765a92941dfc8','Send Email Reminders',0,'Success','2025-12-04 11:56:00',1091117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:02','2025-12-04 11:56:03',1354391,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 11:56:03','687bf5d44d3e10813'),('6931765ab45e0f037','Send Email Notifications',0,'Success','2025-12-04 11:56:00',1091118,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:04','2025-12-04 11:56:04',1354391,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 11:56:04','687bf5d466067a4ba'),('6931765ae4e01ef87','Auth Token Control',0,'Success','2025-12-04 12:00:00',1091119,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:05','2025-12-04 12:00:05',1354540,1,NULL,NULL,NULL,'2025-12-04 11:54:02','2025-12-04 12:00:05','687bf5d511e08c57f'),('6931765b4228cc5a4','Process Webhook Queue',0,'Success','2025-12-04 11:56:00',1091120,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:05','2025-12-04 11:56:05',1354391,1,NULL,NULL,NULL,'2025-12-04 11:54:03','2025-12-04 11:56:05','687bf5d5788e2fe0e'),('693176956cdcffd7c','Submit Popup Reminders',0,'Success','2025-12-04 11:55:01',1091121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:55:03','2025-12-04 11:55:03',1354354,1,NULL,NULL,NULL,'2025-12-04 11:55:01','2025-12-04 11:55:03','687bf57d2f9463790'),('693176958986f5777','Process Job Queue q0',0,'Success','2025-12-04 11:55:01',1091122,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:55:04','2025-12-04 11:55:04',1354354,1,NULL,NULL,NULL,'2025-12-04 11:55:01','2025-12-04 11:55:04','687bf57d693e0fc1f'),('69317695ae95cbf40','Process Job Queue q1',0,'Success','2025-12-04 11:56:00',1091123,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:05','2025-12-04 11:56:06',1354391,1,NULL,NULL,NULL,'2025-12-04 11:55:01','2025-12-04 11:56:06','687bf57d8afb5c472'),('69317696203519c11','Process Job Queue e0',0,'Success','2025-12-04 11:55:02',1091124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:55:04','2025-12-04 11:55:05',1354354,1,NULL,NULL,NULL,'2025-12-04 11:55:02','2025-12-04 11:55:05','687bf57dbba8299ef'),('693176d12fb31102b','Submit Popup Reminders',0,'Success','2025-12-04 11:56:01',1091125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:06','2025-12-04 11:56:06',1354391,1,NULL,NULL,NULL,'2025-12-04 11:56:01','2025-12-04 11:56:06','687bf57d2f9463790'),('693176d155ae1d0f8','Process Job Queue q0',0,'Success','2025-12-04 11:56:01',1091126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:07','2025-12-04 11:56:07',1354391,1,NULL,NULL,NULL,'2025-12-04 11:56:01','2025-12-04 11:56:07','687bf57d693e0fc1f'),('693176d17ad7da6cb','Process Job Queue q1',0,'Success','2025-12-04 11:57:00',1091127,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:57:02','2025-12-04 11:57:03',1354429,1,NULL,NULL,NULL,'2025-12-04 11:56:01','2025-12-04 11:57:03','687bf57d8afb5c472'),('693176d1992b40c52','Process Job Queue e0',0,'Success','2025-12-04 11:56:01',1091128,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:56:08','2025-12-04 11:56:08',1354391,1,NULL,NULL,NULL,'2025-12-04 11:56:01','2025-12-04 11:56:08','687bf57dbba8299ef'),('693176d1d88318cdf','Send Email Reminders',0,'Success','2025-12-04 11:58:00',1091129,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:03','2025-12-04 11:58:03',1354466,1,NULL,NULL,NULL,'2025-12-04 11:56:01','2025-12-04 11:58:03','687bf5d44d3e10813'),('693176d23ead3da23','Send Email Notifications',0,'Success','2025-12-04 11:58:00',1091130,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:04','2025-12-04 11:58:04',1354466,1,NULL,NULL,NULL,'2025-12-04 11:56:02','2025-12-04 11:58:04','687bf5d466067a4ba'),('693176d288ed80ac9','Process Webhook Queue',0,'Success','2025-12-04 11:58:00',1091131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:05','2025-12-04 11:58:05',1354466,1,NULL,NULL,NULL,'2025-12-04 11:56:02','2025-12-04 11:58:05','687bf5d5788e2fe0e'),('6931770d7268a4ddb','Submit Popup Reminders',0,'Success','2025-12-04 11:57:01',1091132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:57:03','2025-12-04 11:57:04',1354429,1,NULL,NULL,NULL,'2025-12-04 11:57:01','2025-12-04 11:57:04','687bf57d2f9463790'),('6931770d9b52b6275','Process Job Queue q0',0,'Success','2025-12-04 11:57:01',1091133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:57:04','2025-12-04 11:57:04',1354429,1,NULL,NULL,NULL,'2025-12-04 11:57:01','2025-12-04 11:57:04','687bf57d693e0fc1f'),('6931770dc07292400','Process Job Queue q1',0,'Success','2025-12-04 11:58:00',1091134,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:05','2025-12-04 11:58:06',1354466,1,NULL,NULL,NULL,'2025-12-04 11:57:01','2025-12-04 11:58:06','687bf57d8afb5c472'),('6931770e164eb704d','Process Job Queue e0',0,'Success','2025-12-04 11:57:02',1091135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:57:05','2025-12-04 11:57:05',1354429,1,NULL,NULL,NULL,'2025-12-04 11:57:02','2025-12-04 11:57:05','687bf57dbba8299ef'),('693177499471b41d6','Submit Popup Reminders',0,'Success','2025-12-04 11:58:01',1091136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:06','2025-12-04 11:58:06',1354466,1,NULL,NULL,NULL,'2025-12-04 11:58:01','2025-12-04 11:58:06','687bf57d2f9463790'),('69317749de60d6f6d','Process Job Queue q0',0,'Success','2025-12-04 11:58:01',1091137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:07','2025-12-04 11:58:07',1354466,1,NULL,NULL,NULL,'2025-12-04 11:58:01','2025-12-04 11:58:07','687bf57d693e0fc1f'),('6931774a225f94794','Process Job Queue q1',0,'Success','2025-12-04 11:59:00',1091138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:59:02','2025-12-04 11:59:02',1354501,1,NULL,NULL,NULL,'2025-12-04 11:58:02','2025-12-04 11:59:02','687bf57d8afb5c472'),('6931774a52c0beb01','Process Job Queue e0',0,'Success','2025-12-04 11:58:02',1091139,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:58:07','2025-12-04 11:58:08',1354466,1,NULL,NULL,NULL,'2025-12-04 11:58:02','2025-12-04 11:58:08','687bf57dbba8299ef'),('6931774a9671fce9b','Send Email Reminders',0,'Success','2025-12-04 12:00:00',1091140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:06','2025-12-04 12:00:06',1354540,1,NULL,NULL,NULL,'2025-12-04 11:58:02','2025-12-04 12:00:06','687bf5d44d3e10813'),('6931774adf82e9fa8','Send Email Notifications',0,'Success','2025-12-04 12:00:00',1091141,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:06','2025-12-04 12:00:06',1354540,1,NULL,NULL,NULL,'2025-12-04 11:58:02','2025-12-04 12:00:06','687bf5d466067a4ba'),('6931774b1d2351951','Process Webhook Queue',0,'Success','2025-12-04 12:00:00',1091142,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:07','2025-12-04 12:00:07',1354540,1,NULL,NULL,NULL,'2025-12-04 11:58:03','2025-12-04 12:00:07','687bf5d5788e2fe0e'),('693177858690828c2','Submit Popup Reminders',0,'Success','2025-12-04 11:59:01',1091143,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:59:03','2025-12-04 11:59:03',1354501,1,NULL,NULL,NULL,'2025-12-04 11:59:01','2025-12-04 11:59:03','687bf57d2f9463790'),('69317785adf620d2d','Process Job Queue q0',0,'Success','2025-12-04 11:59:01',1091144,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:59:04','2025-12-04 11:59:04',1354501,1,NULL,NULL,NULL,'2025-12-04 11:59:01','2025-12-04 11:59:04','687bf57d693e0fc1f'),('69317785ca8c99ac9','Process Job Queue q1',0,'Success','2025-12-04 12:00:00',1091145,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:08','2025-12-04 12:00:08',1354540,1,NULL,NULL,NULL,'2025-12-04 11:59:01','2025-12-04 12:00:08','687bf57d8afb5c472'),('69317785f0777b07e','Process Job Queue e0',0,'Success','2025-12-04 11:59:01',1091146,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 11:59:05','2025-12-04 11:59:05',1354501,1,NULL,NULL,NULL,'2025-12-04 11:59:01','2025-12-04 11:59:05','687bf57dbba8299ef'),('693177c1b1160fa02','Submit Popup Reminders',0,'Success','2025-12-04 12:00:01',1091147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:08','2025-12-04 12:00:09',1354540,1,NULL,NULL,NULL,'2025-12-04 12:00:01','2025-12-04 12:00:09','687bf57d2f9463790'),('693177c1e544ddf7c','Process Job Queue q0',0,'Success','2025-12-04 12:00:01',1091148,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:09','2025-12-04 12:00:09',1354540,1,NULL,NULL,NULL,'2025-12-04 12:00:01','2025-12-04 12:00:09','687bf57d693e0fc1f'),('693177c211d5ded49','Process Job Queue q1',0,'Success','2025-12-04 12:01:00',1091149,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:01:02','2025-12-04 12:01:02',1354577,1,NULL,NULL,NULL,'2025-12-04 12:00:02','2025-12-04 12:01:02','687bf57d8afb5c472'),('693177c231a2989c8','Process Job Queue e0',0,'Success','2025-12-04 12:00:02',1091150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:00:10','2025-12-04 12:00:10',1354540,1,NULL,NULL,NULL,'2025-12-04 12:00:02','2025-12-04 12:00:10','687bf57dbba8299ef'),('693177c25b2b71a33','Send Email Reminders',0,'Success','2025-12-04 12:02:00',1091151,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:03','2025-12-04 12:02:04',1354618,1,NULL,NULL,NULL,'2025-12-04 12:00:02','2025-12-04 12:02:04','687bf5d44d3e10813'),('693177c3183e6f872','Send Email Notifications',0,'Success','2025-12-04 12:02:00',1091152,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:04','2025-12-04 12:02:05',1354618,1,NULL,NULL,NULL,'2025-12-04 12:00:03','2025-12-04 12:02:05','687bf5d466067a4ba'),('693177c35846b3b2b','Auth Token Control',0,'Success','2025-12-04 12:06:00',1091153,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:03','2025-12-04 12:06:03',1354768,1,NULL,NULL,NULL,'2025-12-04 12:00:03','2025-12-04 12:06:03','687bf5d511e08c57f'),('693177c3a7a77f8ab','Process Webhook Queue',0,'Success','2025-12-04 12:02:00',1091154,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:05','2025-12-04 12:02:05',1354618,1,NULL,NULL,NULL,'2025-12-04 12:00:03','2025-12-04 12:02:05','687bf5d5788e2fe0e'),('693177c41075cb0da','Send Scheduled Emails',0,'Success','2025-12-04 12:10:00',1091155,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:05','2025-12-04 12:10:05',1354983,1,NULL,NULL,NULL,'2025-12-04 12:00:04','2025-12-04 12:10:05','687bf5d5eeb01d80d'),('693177fd74085728d','Submit Popup Reminders',0,'Success','2025-12-04 12:01:01',1091156,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:01:03','2025-12-04 12:01:03',1354577,1,NULL,NULL,NULL,'2025-12-04 12:01:01','2025-12-04 12:01:03','687bf57d2f9463790'),('693177fdaa6ca6d18','Process Job Queue q0',0,'Success','2025-12-04 12:01:01',1091157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:01:04','2025-12-04 12:01:04',1354577,1,NULL,NULL,NULL,'2025-12-04 12:01:01','2025-12-04 12:01:04','687bf57d693e0fc1f'),('693177fde6c8d43f5','Process Job Queue q1',0,'Success','2025-12-04 12:02:00',1091158,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:06','2025-12-04 12:02:06',1354618,1,NULL,NULL,NULL,'2025-12-04 12:01:01','2025-12-04 12:02:06','687bf57d8afb5c472'),('693177fe5ebb5f811','Process Job Queue e0',0,'Success','2025-12-04 12:01:02',1091159,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:01:04','2025-12-04 12:01:05',1354577,1,NULL,NULL,NULL,'2025-12-04 12:01:02','2025-12-04 12:01:05','687bf57dbba8299ef'),('6931783a0e162dadf','Submit Popup Reminders',0,'Success','2025-12-04 12:02:02',1091160,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:07','2025-12-04 12:02:07',1354618,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:02:07','687bf57d2f9463790'),('6931783a34c2777ff','Process Job Queue q0',0,'Success','2025-12-04 12:02:02',1091161,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:08','2025-12-04 12:02:08',1354618,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:02:08','687bf57d693e0fc1f'),('6931783a5b92f2a89','Process Job Queue q1',0,'Success','2025-12-04 12:03:00',1091162,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:03:02','2025-12-04 12:03:02',1354653,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:03:02','687bf57d8afb5c472'),('6931783a816f42e84','Process Job Queue e0',0,'Success','2025-12-04 12:02:02',1091163,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:02:09','2025-12-04 12:02:09',1354618,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:02:09','687bf57dbba8299ef'),('6931783ab6f37eb39','Send Email Reminders',0,'Success','2025-12-04 12:04:00',1091164,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:03','2025-12-04 12:04:03',1354689,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:04:03','687bf5d44d3e10813'),('6931783ae1e319e18','Send Email Notifications',0,'Success','2025-12-04 12:04:00',1091165,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:04','2025-12-04 12:04:04',1354689,1,NULL,NULL,NULL,'2025-12-04 12:02:02','2025-12-04 12:04:04','687bf5d466067a4ba'),('6931783b31eb3c822','Process Webhook Queue',0,'Success','2025-12-04 12:04:00',1091166,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:05','2025-12-04 12:04:05',1354689,1,NULL,NULL,NULL,'2025-12-04 12:02:03','2025-12-04 12:04:05','687bf5d5788e2fe0e'),('6931787597e3d1711','Submit Popup Reminders',0,'Success','2025-12-04 12:03:01',1091167,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:03:03','2025-12-04 12:03:04',1354653,1,NULL,NULL,NULL,'2025-12-04 12:03:01','2025-12-04 12:03:04','687bf57d2f9463790'),('69317875c5a04be75','Process Job Queue q0',0,'Success','2025-12-04 12:03:01',1091168,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:03:04','2025-12-04 12:03:05',1354653,1,NULL,NULL,NULL,'2025-12-04 12:03:01','2025-12-04 12:03:05','687bf57d693e0fc1f'),('69317875eea0bcf36','Process Job Queue q1',0,'Success','2025-12-04 12:04:00',1091169,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:05','2025-12-04 12:04:05',1354689,1,NULL,NULL,NULL,'2025-12-04 12:03:01','2025-12-04 12:04:05','687bf57d8afb5c472'),('693178762a473cab6','Process Job Queue e0',0,'Success','2025-12-04 12:03:02',1091170,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:03:05','2025-12-04 12:03:05',1354653,1,NULL,NULL,NULL,'2025-12-04 12:03:02','2025-12-04 12:03:05','687bf57dbba8299ef'),('693178b1c8427aabb','Submit Popup Reminders',0,'Success','2025-12-04 12:04:01',1091171,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:06','2025-12-04 12:04:06',1354689,1,NULL,NULL,NULL,'2025-12-04 12:04:01','2025-12-04 12:04:06','687bf57d2f9463790'),('693178b1ee628a7a1','Process Job Queue q0',0,'Success','2025-12-04 12:04:01',1091172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:07','2025-12-04 12:04:07',1354689,1,NULL,NULL,NULL,'2025-12-04 12:04:01','2025-12-04 12:04:07','687bf57d693e0fc1f'),('693178b21cb26f7dc','Process Job Queue q1',0,'Success','2025-12-04 12:05:00',1091173,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:05:03','2025-12-04 12:05:03',1354731,1,NULL,NULL,NULL,'2025-12-04 12:04:02','2025-12-04 12:05:03','687bf57d8afb5c472'),('693178b2437c97ef3','Process Job Queue e0',0,'Success','2025-12-04 12:04:02',1091174,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:04:08','2025-12-04 12:04:08',1354689,1,NULL,NULL,NULL,'2025-12-04 12:04:02','2025-12-04 12:04:08','687bf57dbba8299ef'),('693178b29b60127f7','Send Email Reminders',0,'Success','2025-12-04 12:06:00',1091175,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:04','2025-12-04 12:06:05',1354768,1,NULL,NULL,NULL,'2025-12-04 12:04:02','2025-12-04 12:06:05','687bf5d44d3e10813'),('693178b2dd4970bce','Send Email Notifications',0,'Success','2025-12-04 12:06:00',1091176,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:05','2025-12-04 12:06:06',1354768,1,NULL,NULL,NULL,'2025-12-04 12:04:02','2025-12-04 12:06:06','687bf5d466067a4ba'),('693178b3213bf948f','Process Webhook Queue',0,'Success','2025-12-04 12:06:00',1091177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:07','2025-12-04 12:06:07',1354768,1,NULL,NULL,NULL,'2025-12-04 12:04:03','2025-12-04 12:06:07','687bf5d5788e2fe0e'),('693178ede990cb2fd','Submit Popup Reminders',0,'Success','2025-12-04 12:05:01',1091178,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:05:04','2025-12-04 12:05:04',1354731,1,NULL,NULL,NULL,'2025-12-04 12:05:01','2025-12-04 12:05:04','687bf57d2f9463790'),('693178ee2d82a80fd','Process Job Queue q0',0,'Success','2025-12-04 12:05:02',1091179,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:05:04','2025-12-04 12:05:05',1354731,1,NULL,NULL,NULL,'2025-12-04 12:05:02','2025-12-04 12:05:05','687bf57d693e0fc1f'),('693178ee749c1382c','Process Job Queue q1',0,'Success','2025-12-04 12:06:00',1091180,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:08','2025-12-04 12:06:08',1354768,1,NULL,NULL,NULL,'2025-12-04 12:05:02','2025-12-04 12:06:08','687bf57d8afb5c472'),('693178eee1f9caa02','Process Job Queue e0',0,'Success','2025-12-04 12:05:02',1091181,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:05:05','2025-12-04 12:05:05',1354731,1,NULL,NULL,NULL,'2025-12-04 12:05:02','2025-12-04 12:05:05','687bf57dbba8299ef'),('69317929e5c5bf536','Submit Popup Reminders',0,'Success','2025-12-04 12:06:01',1091182,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:08','2025-12-04 12:06:08',1354768,1,NULL,NULL,NULL,'2025-12-04 12:06:01','2025-12-04 12:06:08','687bf57d2f9463790'),('6931792a1c13c75a9','Process Job Queue q0',0,'Success','2025-12-04 12:06:02',1091183,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:09','2025-12-04 12:06:09',1354768,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:06:09','687bf57d693e0fc1f'),('6931792a3a8a2976a','Process Job Queue q1',0,'Success','2025-12-04 12:07:00',1091184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:07:02','2025-12-04 12:07:03',1354808,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:07:03','687bf57d8afb5c472'),('6931792a62b00c0d0','Process Job Queue e0',0,'Success','2025-12-04 12:06:02',1091185,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:06:09','2025-12-04 12:06:10',1354768,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:06:10','687bf57dbba8299ef'),('6931792a8b47d8179','Send Email Reminders',0,'Success','2025-12-04 12:08:00',1091186,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:02','2025-12-04 12:08:02',1354843,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:08:02','687bf5d44d3e10813'),('6931792aacca82577','Send Email Notifications',0,'Success','2025-12-04 12:08:00',1091187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:04','2025-12-04 12:08:04',1354843,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:08:04','687bf5d466067a4ba'),('6931792ace9b90e31','Auth Token Control',0,'Success','2025-12-04 12:12:00',1091188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:04','2025-12-04 12:12:04',1355056,1,NULL,NULL,NULL,'2025-12-04 12:06:02','2025-12-04 12:12:04','687bf5d511e08c57f'),('6931792b06caff3cb','Process Webhook Queue',0,'Success','2025-12-04 12:08:00',1091189,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:05','2025-12-04 12:08:05',1354843,1,NULL,NULL,NULL,'2025-12-04 12:06:03','2025-12-04 12:08:05','687bf5d5788e2fe0e'),('69317965779ccf3ca','Submit Popup Reminders',0,'Success','2025-12-04 12:07:01',1091190,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:07:03','2025-12-04 12:07:04',1354808,1,NULL,NULL,NULL,'2025-12-04 12:07:01','2025-12-04 12:07:04','687bf57d2f9463790'),('69317965a79f1d723','Process Job Queue q0',0,'Success','2025-12-04 12:07:01',1091191,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:07:04','2025-12-04 12:07:04',1354808,1,NULL,NULL,NULL,'2025-12-04 12:07:01','2025-12-04 12:07:04','687bf57d693e0fc1f'),('69317965ed698fa39','Process Job Queue q1',0,'Success','2025-12-04 12:08:00',1091192,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:05','2025-12-04 12:08:06',1354843,1,NULL,NULL,NULL,'2025-12-04 12:07:01','2025-12-04 12:08:06','687bf57d8afb5c472'),('69317966436c2adff','Process Job Queue e0',0,'Success','2025-12-04 12:07:02',1091193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:07:05','2025-12-04 12:07:05',1354808,1,NULL,NULL,NULL,'2025-12-04 12:07:02','2025-12-04 12:07:05','687bf57dbba8299ef'),('693179a1936626598','Submit Popup Reminders',0,'Success','2025-12-04 12:08:01',1091194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:06','2025-12-04 12:08:06',1354843,1,NULL,NULL,NULL,'2025-12-04 12:08:01','2025-12-04 12:08:06','687bf57d2f9463790'),('693179a1b634175c2','Process Job Queue q0',0,'Success','2025-12-04 12:08:01',1091195,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:07','2025-12-04 12:08:07',1354843,1,NULL,NULL,NULL,'2025-12-04 12:08:01','2025-12-04 12:08:07','687bf57d693e0fc1f'),('693179a1e829a19f7','Process Job Queue q1',0,'Success','2025-12-04 12:09:00',1091196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:09:02','2025-12-04 12:09:03',1354877,1,NULL,NULL,NULL,'2025-12-04 12:08:01','2025-12-04 12:09:03','687bf57d8afb5c472'),('693179a20f4e010f9','Process Job Queue e0',0,'Success','2025-12-04 12:08:02',1091197,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:08:08','2025-12-04 12:08:08',1354843,1,NULL,NULL,NULL,'2025-12-04 12:08:02','2025-12-04 12:08:08','687bf57dbba8299ef'),('693179a231d68fe85','Send Email Reminders',0,'Success','2025-12-04 12:10:00',1091198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:06','2025-12-04 12:10:06',1354983,1,NULL,NULL,NULL,'2025-12-04 12:08:02','2025-12-04 12:10:06','687bf5d44d3e10813'),('693179a25139bcded','Send Email Notifications',0,'Success','2025-12-04 12:10:00',1091199,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:07','2025-12-04 12:10:07',1354983,1,NULL,NULL,NULL,'2025-12-04 12:08:02','2025-12-04 12:10:07','687bf5d466067a4ba'),('693179a28a8b6324b','Process Webhook Queue',0,'Success','2025-12-04 12:10:00',1091200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:07','2025-12-04 12:10:08',1354983,1,NULL,NULL,NULL,'2025-12-04 12:08:02','2025-12-04 12:10:08','687bf5d5788e2fe0e'),('693179dd62113e3b6','Submit Popup Reminders',0,'Success','2025-12-04 12:09:01',1091201,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:09:04','2025-12-04 12:09:04',1354877,1,NULL,NULL,NULL,'2025-12-04 12:09:01','2025-12-04 12:09:04','687bf57d2f9463790'),('693179dd882d46af3','Process Job Queue q0',0,'Success','2025-12-04 12:09:01',1091202,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:09:05','2025-12-04 12:09:05',1354877,1,NULL,NULL,NULL,'2025-12-04 12:09:01','2025-12-04 12:09:05','687bf57d693e0fc1f'),('693179ddb51d2e9b7','Process Job Queue q1',0,'Success','2025-12-04 12:10:00',1091203,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:08','2025-12-04 12:10:08',1354983,1,NULL,NULL,NULL,'2025-12-04 12:09:01','2025-12-04 12:10:08','687bf57d8afb5c472'),('693179ddebe22be03','Process Job Queue e0',0,'Success','2025-12-04 12:09:01',1091204,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:09:05','2025-12-04 12:09:05',1354877,1,NULL,NULL,NULL,'2025-12-04 12:09:01','2025-12-04 12:09:05','687bf57dbba8299ef'),('69317a19ab3a4ee32','Submit Popup Reminders',0,'Success','2025-12-04 12:10:01',1091205,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:09','2025-12-04 12:10:09',1354983,1,NULL,NULL,NULL,'2025-12-04 12:10:01','2025-12-04 12:10:09','687bf57d2f9463790'),('69317a19c8d634041','Process Job Queue q0',0,'Success','2025-12-04 12:10:01',1091206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:09','2025-12-04 12:10:10',1354983,1,NULL,NULL,NULL,'2025-12-04 12:10:01','2025-12-04 12:10:10','687bf57d693e0fc1f'),('69317a1a01ab8eede','Process Job Queue q1',0,'Success','2025-12-04 12:11:00',1091207,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:11:02','2025-12-04 12:11:02',1355018,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:11:02','687bf57d8afb5c472'),('69317a1a2b9c16710','Process Job Queue e0',0,'Success','2025-12-04 12:10:02',1091208,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:10:10','2025-12-04 12:10:10',1354983,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:10:10','687bf57dbba8299ef'),('69317a1a54c4032ea','Send Email Reminders',0,'Success','2025-12-04 12:12:00',1091209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:05','2025-12-04 12:12:05',1355056,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:12:05','687bf5d44d3e10813'),('69317a1a71c6755d6','Send Email Notifications',0,'Success','2025-12-04 12:12:00',1091210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:06','2025-12-04 12:12:06',1355056,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:12:06','687bf5d466067a4ba'),('69317a1aa8e69c1c1','Send Mass Emails',0,'Success','2025-12-04 12:30:00',1091211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:04','2025-12-04 12:30:04',1355793,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:30:04','687bf5d4b535f913f'),('69317a1ada82072f5','Process Webhook Queue',0,'Success','2025-12-04 12:12:00',1091212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:07','2025-12-04 12:12:07',1355056,1,NULL,NULL,NULL,'2025-12-04 12:10:02','2025-12-04 12:12:07','687bf5d5788e2fe0e'),('69317a1b1a39400e6','Send Scheduled Emails',0,'Success','2025-12-04 12:20:00',1091213,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:03','2025-12-04 12:20:04',1355416,1,NULL,NULL,NULL,'2025-12-04 12:10:03','2025-12-04 12:20:04','687bf5d5eeb01d80d'),('69317a55545d830bd','Submit Popup Reminders',0,'Success','2025-12-04 12:11:01',1091214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:11:03','2025-12-04 12:11:03',1355018,1,NULL,NULL,NULL,'2025-12-04 12:11:01','2025-12-04 12:11:03','687bf57d2f9463790'),('69317a5575850b09b','Process Job Queue q0',0,'Success','2025-12-04 12:11:01',1091215,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:11:04','2025-12-04 12:11:04',1355018,1,NULL,NULL,NULL,'2025-12-04 12:11:01','2025-12-04 12:11:04','687bf57d693e0fc1f'),('69317a5598411139b','Process Job Queue q1',0,'Success','2025-12-04 12:12:00',1091216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:07','2025-12-04 12:12:07',1355056,1,NULL,NULL,NULL,'2025-12-04 12:11:01','2025-12-04 12:12:07','687bf57d8afb5c472'),('69317a55bc16456ef','Process Job Queue e0',0,'Success','2025-12-04 12:11:01',1091217,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:11:05','2025-12-04 12:11:05',1355018,1,NULL,NULL,NULL,'2025-12-04 12:11:01','2025-12-04 12:11:05','687bf57dbba8299ef'),('69317a91f2654412f','Submit Popup Reminders',0,'Success','2025-12-04 12:12:01',1091218,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:08','2025-12-04 12:12:08',1355056,1,NULL,NULL,NULL,'2025-12-04 12:12:01','2025-12-04 12:12:08','687bf57d2f9463790'),('69317a922b61ab142','Process Job Queue q0',0,'Success','2025-12-04 12:12:02',1091219,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:09','2025-12-04 12:12:09',1355056,1,NULL,NULL,NULL,'2025-12-04 12:12:02','2025-12-04 12:12:09','687bf57d693e0fc1f'),('69317a92603544691','Process Job Queue q1',0,'Success','2025-12-04 12:13:00',1091220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:13:01','2025-12-04 12:13:02',1355095,1,NULL,NULL,NULL,'2025-12-04 12:12:02','2025-12-04 12:13:02','687bf57d8afb5c472'),('69317a928c60e7fc6','Process Job Queue e0',0,'Success','2025-12-04 12:12:02',1091221,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:12:10','2025-12-04 12:12:10',1355056,1,NULL,NULL,NULL,'2025-12-04 12:12:02','2025-12-04 12:12:10','687bf57dbba8299ef'),('69317a92bd396e900','Send Email Reminders',0,'Success','2025-12-04 12:14:00',1091222,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:03','2025-12-04 12:14:03',1355196,1,NULL,NULL,NULL,'2025-12-04 12:12:02','2025-12-04 12:14:03','687bf5d44d3e10813'),('69317a92e4bd7b07d','Send Email Notifications',0,'Success','2025-12-04 12:14:00',1091223,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:04','2025-12-04 12:14:04',1355196,1,NULL,NULL,NULL,'2025-12-04 12:12:02','2025-12-04 12:14:04','687bf5d466067a4ba'),('69317a931acc4fdd5','Auth Token Control',0,'Success','2025-12-04 12:18:00',1091224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:03','2025-12-04 12:18:03',1355340,1,NULL,NULL,NULL,'2025-12-04 12:12:03','2025-12-04 12:18:03','687bf5d511e08c57f'),('69317a936c2f8ed9f','Process Webhook Queue',0,'Success','2025-12-04 12:14:00',1091225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:05','2025-12-04 12:14:05',1355196,1,NULL,NULL,NULL,'2025-12-04 12:12:03','2025-12-04 12:14:05','687bf5d5788e2fe0e'),('69317acd5cd5d967f','Submit Popup Reminders',0,'Success','2025-12-04 12:13:01',1091226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:13:03','2025-12-04 12:13:03',1355095,1,NULL,NULL,NULL,'2025-12-04 12:13:01','2025-12-04 12:13:03','687bf57d2f9463790'),('69317acd8a6678223','Process Job Queue q0',0,'Success','2025-12-04 12:13:01',1091227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:13:04','2025-12-04 12:13:04',1355095,1,NULL,NULL,NULL,'2025-12-04 12:13:01','2025-12-04 12:13:04','687bf57d693e0fc1f'),('69317acdaf0c73fbe','Process Job Queue q1',0,'Success','2025-12-04 12:14:00',1091228,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:06','2025-12-04 12:14:06',1355196,1,NULL,NULL,NULL,'2025-12-04 12:13:01','2025-12-04 12:14:06','687bf57d8afb5c472'),('69317acdd0e583514','Process Job Queue e0',0,'Success','2025-12-04 12:13:01',1091229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:13:05','2025-12-04 12:13:05',1355095,1,NULL,NULL,NULL,'2025-12-04 12:13:01','2025-12-04 12:13:05','687bf57dbba8299ef'),('69317b09d17571ef4','Submit Popup Reminders',0,'Success','2025-12-04 12:14:01',1091230,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:06','2025-12-04 12:14:07',1355196,1,NULL,NULL,NULL,'2025-12-04 12:14:01','2025-12-04 12:14:07','687bf57d2f9463790'),('69317b0a0935c8af4','Process Job Queue q0',0,'Success','2025-12-04 12:14:02',1091231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:07','2025-12-04 12:14:07',1355196,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:14:07','687bf57d693e0fc1f'),('69317b0a22f06a759','Process Job Queue q1',0,'Success','2025-12-04 12:15:00',1091232,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:15:02','2025-12-04 12:15:02',1355233,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:15:02','687bf57d8afb5c472'),('69317b0a41b5e0a7b','Process Job Queue e0',0,'Success','2025-12-04 12:14:02',1091233,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:14:08','2025-12-04 12:14:08',1355196,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:14:08','687bf57dbba8299ef'),('69317b0a682ea423c','Send Email Reminders',0,'Success','2025-12-04 12:16:00',1091234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:03','2025-12-04 12:16:04',1355267,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:16:04','687bf5d44d3e10813'),('69317b0a7f26eb038','Send Email Notifications',0,'Success','2025-12-04 12:16:00',1091235,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:04','2025-12-04 12:16:04',1355267,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:16:04','687bf5d466067a4ba'),('69317b0abc02d50af','Process Webhook Queue',0,'Success','2025-12-04 12:16:00',1091236,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:05','2025-12-04 12:16:05',1355267,1,NULL,NULL,NULL,'2025-12-04 12:14:02','2025-12-04 12:16:05','687bf5d5788e2fe0e'),('69317b45773d1d087','Submit Popup Reminders',0,'Success','2025-12-04 12:15:01',1091237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:15:03','2025-12-04 12:15:03',1355233,1,NULL,NULL,NULL,'2025-12-04 12:15:01','2025-12-04 12:15:03','687bf57d2f9463790'),('69317b459bf5b821e','Process Job Queue q0',0,'Success','2025-12-04 12:15:01',1091238,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:15:04','2025-12-04 12:15:04',1355233,1,NULL,NULL,NULL,'2025-12-04 12:15:01','2025-12-04 12:15:04','687bf57d693e0fc1f'),('69317b45b68b9f9a9','Process Job Queue q1',0,'Success','2025-12-04 12:16:00',1091239,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:05','2025-12-04 12:16:06',1355267,1,NULL,NULL,NULL,'2025-12-04 12:15:01','2025-12-04 12:16:06','687bf57d8afb5c472'),('69317b45de766874a','Process Job Queue e0',0,'Success','2025-12-04 12:15:01',1091240,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:15:05','2025-12-04 12:15:05',1355233,1,NULL,NULL,NULL,'2025-12-04 12:15:01','2025-12-04 12:15:05','687bf57dbba8299ef'),('69317b81949cdaead','Submit Popup Reminders',0,'Success','2025-12-04 12:16:01',1091241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:06','2025-12-04 12:16:06',1355267,1,NULL,NULL,NULL,'2025-12-04 12:16:01','2025-12-04 12:16:06','687bf57d2f9463790'),('69317b81cd46615ce','Process Job Queue q0',0,'Success','2025-12-04 12:16:01',1091242,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:07','2025-12-04 12:16:07',1355267,1,NULL,NULL,NULL,'2025-12-04 12:16:01','2025-12-04 12:16:07','687bf57d693e0fc1f'),('69317b820c555098c','Process Job Queue q1',0,'Success','2025-12-04 12:17:00',1091243,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:17:02','2025-12-04 12:17:02',1355303,1,NULL,NULL,NULL,'2025-12-04 12:16:02','2025-12-04 12:17:02','687bf57d8afb5c472'),('69317b828de2a980d','Process Job Queue e0',0,'Success','2025-12-04 12:16:02',1091244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:16:08','2025-12-04 12:16:08',1355267,1,NULL,NULL,NULL,'2025-12-04 12:16:02','2025-12-04 12:16:08','687bf57dbba8299ef'),('69317b82e4bad287b','Send Email Reminders',0,'Success','2025-12-04 12:18:00',1091245,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:04','2025-12-04 12:18:04',1355340,1,NULL,NULL,NULL,'2025-12-04 12:16:02','2025-12-04 12:18:04','687bf5d44d3e10813'),('69317b837433407dd','Send Email Notifications',0,'Success','2025-12-04 12:18:00',1091246,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:05','2025-12-04 12:18:05',1355340,1,NULL,NULL,NULL,'2025-12-04 12:16:03','2025-12-04 12:18:05','687bf5d466067a4ba'),('69317b839d5435655','Process Webhook Queue',0,'Success','2025-12-04 12:18:00',1091247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:06','2025-12-04 12:18:06',1355340,1,NULL,NULL,NULL,'2025-12-04 12:16:03','2025-12-04 12:18:06','687bf5d5788e2fe0e'),('69317bbd915e1b8ba','Submit Popup Reminders',0,'Success','2025-12-04 12:17:01',1091248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:17:03','2025-12-04 12:17:03',1355303,1,NULL,NULL,NULL,'2025-12-04 12:17:01','2025-12-04 12:17:03','687bf57d2f9463790'),('69317bbdbd6e3dd03','Process Job Queue q0',0,'Success','2025-12-04 12:17:01',1091249,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:17:04','2025-12-04 12:17:04',1355303,1,NULL,NULL,NULL,'2025-12-04 12:17:01','2025-12-04 12:17:04','687bf57d693e0fc1f'),('69317bbddd6e97b4b','Process Job Queue q1',0,'Success','2025-12-04 12:18:00',1091250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:06','2025-12-04 12:18:06',1355340,1,NULL,NULL,NULL,'2025-12-04 12:17:01','2025-12-04 12:18:06','687bf57d8afb5c472'),('69317bbe03bcec777','Process Job Queue e0',0,'Success','2025-12-04 12:17:02',1091251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:17:04','2025-12-04 12:17:05',1355303,1,NULL,NULL,NULL,'2025-12-04 12:17:02','2025-12-04 12:17:05','687bf57dbba8299ef'),('69317bf95dfff42b9','Submit Popup Reminders',0,'Success','2025-12-04 12:18:01',1091252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:07','2025-12-04 12:18:07',1355340,1,NULL,NULL,NULL,'2025-12-04 12:18:01','2025-12-04 12:18:07','687bf57d2f9463790'),('69317bf97f1f14755','Process Job Queue q0',0,'Success','2025-12-04 12:18:01',1091253,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:08','2025-12-04 12:18:08',1355340,1,NULL,NULL,NULL,'2025-12-04 12:18:01','2025-12-04 12:18:08','687bf57d693e0fc1f'),('69317bf9a38b1710c','Process Job Queue q1',0,'Success','2025-12-04 12:19:00',1091254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:19:03','2025-12-04 12:19:03',1355381,1,NULL,NULL,NULL,'2025-12-04 12:18:01','2025-12-04 12:19:03','687bf57d8afb5c472'),('69317bf9ca04d979d','Process Job Queue e0',0,'Success','2025-12-04 12:18:01',1091255,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:18:08','2025-12-04 12:18:09',1355340,1,NULL,NULL,NULL,'2025-12-04 12:18:01','2025-12-04 12:18:09','687bf57dbba8299ef'),('69317bfa2327950d9','Send Email Reminders',0,'Success','2025-12-04 12:20:00',1091256,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:04','2025-12-04 12:20:04',1355416,1,NULL,NULL,NULL,'2025-12-04 12:18:02','2025-12-04 12:20:04','687bf5d44d3e10813'),('69317bfa83cb4d596','Send Email Notifications',0,'Success','2025-12-04 12:20:00',1091257,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:05','2025-12-04 12:20:05',1355416,1,NULL,NULL,NULL,'2025-12-04 12:18:02','2025-12-04 12:20:05','687bf5d466067a4ba'),('69317bfae0b459925','Auth Token Control',0,'Success','2025-12-04 12:24:00',1091258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:03','2025-12-04 12:24:04',1355568,1,NULL,NULL,NULL,'2025-12-04 12:18:02','2025-12-04 12:24:04','687bf5d511e08c57f'),('69317bfb4b9838b57','Process Webhook Queue',0,'Success','2025-12-04 12:20:00',1091259,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:06','2025-12-04 12:20:06',1355416,1,NULL,NULL,NULL,'2025-12-04 12:18:03','2025-12-04 12:20:06','687bf5d5788e2fe0e'),('69317c35ce4c911a9','Submit Popup Reminders',0,'Success','2025-12-04 12:19:01',1091260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:19:04','2025-12-04 12:19:04',1355381,1,NULL,NULL,NULL,'2025-12-04 12:19:01','2025-12-04 12:19:04','687bf57d2f9463790'),('69317c3609876c80e','Process Job Queue q0',0,'Success','2025-12-04 12:19:02',1091261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:19:04','2025-12-04 12:19:05',1355381,1,NULL,NULL,NULL,'2025-12-04 12:19:02','2025-12-04 12:19:05','687bf57d693e0fc1f'),('69317c36625a5d80d','Process Job Queue q1',0,'Success','2025-12-04 12:20:00',1091262,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:06','2025-12-04 12:20:07',1355416,1,NULL,NULL,NULL,'2025-12-04 12:19:02','2025-12-04 12:20:07','687bf57d8afb5c472'),('69317c369712f096c','Process Job Queue e0',0,'Success','2025-12-04 12:19:02',1091263,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:19:05','2025-12-04 12:19:05',1355381,1,NULL,NULL,NULL,'2025-12-04 12:19:02','2025-12-04 12:19:05','687bf57dbba8299ef'),('69317c71988fad8d6','Submit Popup Reminders',0,'Success','2025-12-04 12:20:01',1091264,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:07','2025-12-04 12:20:07',1355416,1,NULL,NULL,NULL,'2025-12-04 12:20:01','2025-12-04 12:20:07','687bf57d2f9463790'),('69317c71c74f3a7c3','Process Job Queue q0',0,'Success','2025-12-04 12:20:01',1091265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:08','2025-12-04 12:20:08',1355416,1,NULL,NULL,NULL,'2025-12-04 12:20:01','2025-12-04 12:20:08','687bf57d693e0fc1f'),('69317c720ff59500a','Process Job Queue q1',0,'Success','2025-12-04 12:21:00',1091266,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:21:02','2025-12-04 12:21:03',1355457,1,NULL,NULL,NULL,'2025-12-04 12:20:02','2025-12-04 12:21:03','687bf57d8afb5c472'),('69317c72483de8555','Process Job Queue e0',0,'Success','2025-12-04 12:20:02',1091267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:20:08','2025-12-04 12:20:08',1355416,1,NULL,NULL,NULL,'2025-12-04 12:20:02','2025-12-04 12:20:08','687bf57dbba8299ef'),('69317c727dbd7df72','Send Email Reminders',0,'Success','2025-12-04 12:22:00',1091268,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:02','2025-12-04 12:22:03',1355496,1,NULL,NULL,NULL,'2025-12-04 12:20:02','2025-12-04 12:22:03','687bf5d44d3e10813'),('69317c72c76dc68a6','Send Email Notifications',0,'Success','2025-12-04 12:22:00',1091269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:04','2025-12-04 12:22:04',1355496,1,NULL,NULL,NULL,'2025-12-04 12:20:02','2025-12-04 12:22:04','687bf5d466067a4ba'),('69317c734bdce33f6','Process Webhook Queue',0,'Success','2025-12-04 12:22:00',1091270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:05','2025-12-04 12:22:05',1355496,1,NULL,NULL,NULL,'2025-12-04 12:20:03','2025-12-04 12:22:05','687bf5d5788e2fe0e'),('69317c738a8339dfd','Send Scheduled Emails',0,'Success','2025-12-04 12:30:00',1091271,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:05','2025-12-04 12:30:05',1355793,1,NULL,NULL,NULL,'2025-12-04 12:20:03','2025-12-04 12:30:05','687bf5d5eeb01d80d'),('69317cadf1920aa39','Submit Popup Reminders',0,'Success','2025-12-04 12:21:01',1091272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:21:04','2025-12-04 12:21:04',1355457,1,NULL,NULL,NULL,'2025-12-04 12:21:01','2025-12-04 12:21:04','687bf57d2f9463790'),('69317cae32a0a8dc0','Process Job Queue q0',0,'Success','2025-12-04 12:21:02',1091273,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:21:05','2025-12-04 12:21:05',1355457,1,NULL,NULL,NULL,'2025-12-04 12:21:02','2025-12-04 12:21:05','687bf57d693e0fc1f'),('69317cae7731a6de2','Process Job Queue q1',0,'Success','2025-12-04 12:22:00',1091274,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:05','2025-12-04 12:22:06',1355496,1,NULL,NULL,NULL,'2025-12-04 12:21:02','2025-12-04 12:22:06','687bf57d8afb5c472'),('69317caea1d556dc3','Process Job Queue e0',0,'Success','2025-12-04 12:21:02',1091275,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:21:05','2025-12-04 12:21:05',1355457,1,NULL,NULL,NULL,'2025-12-04 12:21:02','2025-12-04 12:21:05','687bf57dbba8299ef'),('69317ce94bdc47715','Submit Popup Reminders',0,'Success','2025-12-04 12:22:01',1091276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:06','2025-12-04 12:22:06',1355496,1,NULL,NULL,NULL,'2025-12-04 12:22:01','2025-12-04 12:22:06','687bf57d2f9463790'),('69317ce973a7e2fc2','Process Job Queue q0',0,'Success','2025-12-04 12:22:01',1091277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:07','2025-12-04 12:22:07',1355496,1,NULL,NULL,NULL,'2025-12-04 12:22:01','2025-12-04 12:22:07','687bf57d693e0fc1f'),('69317ce9984854fc5','Process Job Queue q1',0,'Success','2025-12-04 12:23:00',1091278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:23:02','2025-12-04 12:23:02',1355531,1,NULL,NULL,NULL,'2025-12-04 12:22:01','2025-12-04 12:23:02','687bf57d8afb5c472'),('69317ce9c02e2201d','Process Job Queue e0',0,'Success','2025-12-04 12:22:01',1091279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:22:07','2025-12-04 12:22:08',1355496,1,NULL,NULL,NULL,'2025-12-04 12:22:01','2025-12-04 12:22:08','687bf57dbba8299ef'),('69317ce9ed9923073','Send Email Reminders',0,'Success','2025-12-04 12:24:00',1091280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:04','2025-12-04 12:24:04',1355568,1,NULL,NULL,NULL,'2025-12-04 12:22:01','2025-12-04 12:24:04','687bf5d44d3e10813'),('69317cea32ed553d0','Send Email Notifications',0,'Success','2025-12-04 12:24:00',1091281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:05','2025-12-04 12:24:05',1355568,1,NULL,NULL,NULL,'2025-12-04 12:22:02','2025-12-04 12:24:05','687bf5d466067a4ba'),('69317cea7077c46cc','Process Webhook Queue',0,'Success','2025-12-04 12:24:00',1091282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:06','2025-12-04 12:24:06',1355568,1,NULL,NULL,NULL,'2025-12-04 12:22:02','2025-12-04 12:24:06','687bf5d5788e2fe0e'),('69317d25574d7a6eb','Submit Popup Reminders',0,'Success','2025-12-04 12:23:01',1091283,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:23:03','2025-12-04 12:23:04',1355531,1,NULL,NULL,NULL,'2025-12-04 12:23:01','2025-12-04 12:23:04','687bf57d2f9463790'),('69317d257eb10e6e2','Process Job Queue q0',0,'Success','2025-12-04 12:23:01',1091284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:23:04','2025-12-04 12:23:04',1355531,1,NULL,NULL,NULL,'2025-12-04 12:23:01','2025-12-04 12:23:04','687bf57d693e0fc1f'),('69317d259f591d37c','Process Job Queue q1',0,'Success','2025-12-04 12:24:00',1091285,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:07','2025-12-04 12:24:07',1355568,1,NULL,NULL,NULL,'2025-12-04 12:23:01','2025-12-04 12:24:07','687bf57d8afb5c472'),('69317d25bd236f562','Process Job Queue e0',0,'Success','2025-12-04 12:23:01',1091286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:23:05','2025-12-04 12:23:05',1355531,1,NULL,NULL,NULL,'2025-12-04 12:23:01','2025-12-04 12:23:05','687bf57dbba8299ef'),('69317d616d32dbeeb','Submit Popup Reminders',0,'Success','2025-12-04 12:24:01',1091287,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:08','2025-12-04 12:24:08',1355568,1,NULL,NULL,NULL,'2025-12-04 12:24:01','2025-12-04 12:24:08','687bf57d2f9463790'),('69317d61ac5bc98f2','Process Job Queue q0',0,'Success','2025-12-04 12:24:01',1091288,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:08','2025-12-04 12:24:08',1355568,1,NULL,NULL,NULL,'2025-12-04 12:24:01','2025-12-04 12:24:08','687bf57d693e0fc1f'),('69317d61dd20195da','Process Job Queue q1',0,'Success','2025-12-04 12:25:00',1091289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:25:01','2025-12-04 12:25:01',1355606,1,NULL,NULL,NULL,'2025-12-04 12:24:01','2025-12-04 12:25:01','687bf57d8afb5c472'),('69317d621dc92f5ad','Process Job Queue e0',0,'Success','2025-12-04 12:24:02',1091290,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:24:09','2025-12-04 12:24:09',1355568,1,NULL,NULL,NULL,'2025-12-04 12:24:02','2025-12-04 12:24:09','687bf57dbba8299ef'),('69317d62c5031da9d','Send Email Reminders',0,'Success','2025-12-04 12:26:00',1091291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:03','2025-12-04 12:26:03',1355642,1,NULL,NULL,NULL,'2025-12-04 12:24:02','2025-12-04 12:26:03','687bf5d44d3e10813'),('69317d630a5339324','Send Email Notifications',0,'Success','2025-12-04 12:26:00',1091292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:04','2025-12-04 12:26:04',1355642,1,NULL,NULL,NULL,'2025-12-04 12:24:03','2025-12-04 12:26:04','687bf5d466067a4ba'),('69317d634f378f576','Auth Token Control',0,'Success','2025-12-04 12:30:00',1091293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:06','2025-12-04 12:30:06',1355793,1,NULL,NULL,NULL,'2025-12-04 12:24:03','2025-12-04 12:30:06','687bf5d511e08c57f'),('69317d63ad90f851d','Process Webhook Queue',0,'Success','2025-12-04 12:26:00',1091294,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:04','2025-12-04 12:26:05',1355642,1,NULL,NULL,NULL,'2025-12-04 12:24:03','2025-12-04 12:26:05','687bf5d5788e2fe0e'),('69317d9d3fa2d9175','Submit Popup Reminders',0,'Success','2025-12-04 12:25:01',1091295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:25:03','2025-12-04 12:25:03',1355606,1,NULL,NULL,NULL,'2025-12-04 12:25:01','2025-12-04 12:25:03','687bf57d2f9463790'),('69317d9d6a42491dd','Process Job Queue q0',0,'Success','2025-12-04 12:25:01',1091296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:25:04','2025-12-04 12:25:04',1355606,1,NULL,NULL,NULL,'2025-12-04 12:25:01','2025-12-04 12:25:04','687bf57d693e0fc1f'),('69317d9d926de2a2d','Process Job Queue q1',0,'Success','2025-12-04 12:26:00',1091297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:05','2025-12-04 12:26:05',1355642,1,NULL,NULL,NULL,'2025-12-04 12:25:01','2025-12-04 12:26:05','687bf57d8afb5c472'),('69317d9db336838c6','Process Job Queue e0',0,'Success','2025-12-04 12:25:01',1091298,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:25:05','2025-12-04 12:25:05',1355606,1,NULL,NULL,NULL,'2025-12-04 12:25:01','2025-12-04 12:25:05','687bf57dbba8299ef'),('69317dd9424a26a90','Submit Popup Reminders',0,'Success','2025-12-04 12:26:01',1091299,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:06','2025-12-04 12:26:06',1355642,1,NULL,NULL,NULL,'2025-12-04 12:26:01','2025-12-04 12:26:06','687bf57d2f9463790'),('69317dd977e8a2567','Process Job Queue q0',0,'Success','2025-12-04 12:26:01',1091300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:06','2025-12-04 12:26:07',1355642,1,NULL,NULL,NULL,'2025-12-04 12:26:01','2025-12-04 12:26:07','687bf57d693e0fc1f'),('69317dd9b6a20f385','Process Job Queue q1',0,'Success','2025-12-04 12:27:00',1091301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:27:02','2025-12-04 12:27:03',1355680,1,NULL,NULL,NULL,'2025-12-04 12:26:01','2025-12-04 12:27:03','687bf57d8afb5c472'),('69317dd9ee71b8026','Process Job Queue e0',0,'Success','2025-12-04 12:26:01',1091302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:26:07','2025-12-04 12:26:08',1355642,1,NULL,NULL,NULL,'2025-12-04 12:26:01','2025-12-04 12:26:08','687bf57dbba8299ef'),('69317dda2bcc83df5','Send Email Reminders',0,'Success','2025-12-04 12:28:00',1091303,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:03','2025-12-04 12:28:03',1355719,1,NULL,NULL,NULL,'2025-12-04 12:26:02','2025-12-04 12:28:03','687bf5d44d3e10813'),('69317ddab01a9848c','Send Email Notifications',0,'Success','2025-12-04 12:28:00',1091304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:04','2025-12-04 12:28:04',1355719,1,NULL,NULL,NULL,'2025-12-04 12:26:02','2025-12-04 12:28:04','687bf5d466067a4ba'),('69317ddaecc413918','Process Webhook Queue',0,'Success','2025-12-04 12:28:00',1091305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:05','2025-12-04 12:28:05',1355719,1,NULL,NULL,NULL,'2025-12-04 12:26:02','2025-12-04 12:28:05','687bf5d5788e2fe0e'),('69317e160cfed87cd','Submit Popup Reminders',0,'Success','2025-12-04 12:27:02',1091306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:27:04','2025-12-04 12:27:04',1355680,1,NULL,NULL,NULL,'2025-12-04 12:27:02','2025-12-04 12:27:04','687bf57d2f9463790'),('69317e16402ada0ac','Process Job Queue q0',0,'Success','2025-12-04 12:27:02',1091307,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:27:04','2025-12-04 12:27:04',1355680,1,NULL,NULL,NULL,'2025-12-04 12:27:02','2025-12-04 12:27:04','687bf57d693e0fc1f'),('69317e166e60d4bc5','Process Job Queue q1',0,'Success','2025-12-04 12:28:00',1091308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:05','2025-12-04 12:28:05',1355719,1,NULL,NULL,NULL,'2025-12-04 12:27:02','2025-12-04 12:28:05','687bf57d8afb5c472'),('69317e16ad7842e97','Process Job Queue e0',0,'Success','2025-12-04 12:27:02',1091309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:27:05','2025-12-04 12:27:05',1355680,1,NULL,NULL,NULL,'2025-12-04 12:27:02','2025-12-04 12:27:05','687bf57dbba8299ef'),('69317e51358060d08','Submit Popup Reminders',0,'Success','2025-12-04 12:28:01',1091310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:06','2025-12-04 12:28:06',1355719,1,NULL,NULL,NULL,'2025-12-04 12:28:01','2025-12-04 12:28:06','687bf57d2f9463790'),('69317e515f8979447','Process Job Queue q0',0,'Success','2025-12-04 12:28:01',1091311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:07','2025-12-04 12:28:07',1355719,1,NULL,NULL,NULL,'2025-12-04 12:28:01','2025-12-04 12:28:07','687bf57d693e0fc1f'),('69317e51826239ca5','Process Job Queue q1',0,'Success','2025-12-04 12:29:00',1091312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:29:02','2025-12-04 12:29:02',1355754,1,NULL,NULL,NULL,'2025-12-04 12:28:01','2025-12-04 12:29:02','687bf57d8afb5c472'),('69317e51a4219e0f3','Process Job Queue e0',0,'Success','2025-12-04 12:28:01',1091313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:28:07','2025-12-04 12:28:08',1355719,1,NULL,NULL,NULL,'2025-12-04 12:28:01','2025-12-04 12:28:08','687bf57dbba8299ef'),('69317e51d5a7cfac3','Send Email Reminders',0,'Success','2025-12-04 12:30:00',1091314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:07','2025-12-04 12:30:07',1355793,1,NULL,NULL,NULL,'2025-12-04 12:28:01','2025-12-04 12:30:07','687bf5d44d3e10813'),('69317e5206921f780','Send Email Notifications',0,'Success','2025-12-04 12:30:00',1091315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:07','2025-12-04 12:30:07',1355793,1,NULL,NULL,NULL,'2025-12-04 12:28:02','2025-12-04 12:30:07','687bf5d466067a4ba'),('69317e526c8034a3c','Process Webhook Queue',0,'Success','2025-12-04 12:30:00',1091316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:08','2025-12-04 12:30:08',1355793,1,NULL,NULL,NULL,'2025-12-04 12:28:02','2025-12-04 12:30:08','687bf5d5788e2fe0e'),('69317e8d2e9ff814e','Submit Popup Reminders',0,'Success','2025-12-04 12:29:01',1091317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:29:03','2025-12-04 12:29:03',1355754,1,NULL,NULL,NULL,'2025-12-04 12:29:01','2025-12-04 12:29:03','687bf57d2f9463790'),('69317e8d6dec8a972','Process Job Queue q0',0,'Success','2025-12-04 12:29:01',1091318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:29:04','2025-12-04 12:29:04',1355754,1,NULL,NULL,NULL,'2025-12-04 12:29:01','2025-12-04 12:29:04','687bf57d693e0fc1f'),('69317e8d97b5d19dc','Process Job Queue q1',0,'Success','2025-12-04 12:30:00',1091319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:09','2025-12-04 12:30:09',1355793,1,NULL,NULL,NULL,'2025-12-04 12:29:01','2025-12-04 12:30:09','687bf57d8afb5c472'),('69317e8db9423de1b','Process Job Queue e0',0,'Success','2025-12-04 12:29:01',1091320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:29:05','2025-12-04 12:29:05',1355754,1,NULL,NULL,NULL,'2025-12-04 12:29:01','2025-12-04 12:29:05','687bf57dbba8299ef'),('69317ec97910431d5','Submit Popup Reminders',0,'Success','2025-12-04 12:30:01',1091321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:09','2025-12-04 12:30:10',1355793,1,NULL,NULL,NULL,'2025-12-04 12:30:01','2025-12-04 12:30:10','687bf57d2f9463790'),('69317ec99abf55eea','Process Job Queue q0',0,'Success','2025-12-04 12:30:01',1091322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:10','2025-12-04 12:30:11',1355793,1,NULL,NULL,NULL,'2025-12-04 12:30:01','2025-12-04 12:30:11','687bf57d693e0fc1f'),('69317ec9c5d024954','Process Job Queue q1',0,'Success','2025-12-04 12:31:00',1091323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:31:02','2025-12-04 12:31:03',1355828,1,NULL,NULL,NULL,'2025-12-04 12:30:01','2025-12-04 12:31:03','687bf57d8afb5c472'),('69317ec9ec909d38b','Process Job Queue e0',0,'Success','2025-12-04 12:30:01',1091324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:30:11','2025-12-04 12:30:11',1355793,1,NULL,NULL,NULL,'2025-12-04 12:30:01','2025-12-04 12:30:11','687bf57dbba8299ef'),('69317eca1fa5c6ded','Send Email Reminders',0,'Success','2025-12-04 12:32:00',1091325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:32:03',1355852,1,NULL,NULL,NULL,'2025-12-04 12:30:02','2025-12-04 12:32:03','687bf5d44d3e10813'),('69317eca4c56f162c','Send Email Notifications',0,'Success','2025-12-04 12:32:00',1091326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:04','2025-12-04 12:32:04',1355852,1,NULL,NULL,NULL,'2025-12-04 12:30:02','2025-12-04 12:32:04','687bf5d466067a4ba'),('69317eca9d451ad52','Send Mass Emails',0,'Success','2025-12-04 12:50:00',1091327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:04','2025-12-04 12:50:04',1356604,1,NULL,NULL,NULL,'2025-12-04 12:30:02','2025-12-04 12:50:04','687bf5d4b535f913f'),('69317ecae9e6bde5a','Auth Token Control',0,'Success','2025-12-04 12:36:00',1091328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:03','2025-12-04 12:36:03',1356001,1,NULL,NULL,NULL,'2025-12-04 12:30:02','2025-12-04 12:36:03','687bf5d511e08c57f'),('69317ecb7e21e5422','Process Webhook Queue',0,'Success','2025-12-04 12:32:00',1091329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:05','2025-12-04 12:32:05',1355852,1,NULL,NULL,NULL,'2025-12-04 12:30:03','2025-12-04 12:32:05','687bf5d5788e2fe0e'),('69317ecbd5a689ec3','Send Scheduled Emails',0,'Success','2025-12-04 12:40:00',1091330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:03','2025-12-04 12:40:04',1356220,1,NULL,NULL,NULL,'2025-12-04 12:30:03','2025-12-04 12:40:04','687bf5d5eeb01d80d'),('69317f05ac4035eed','Submit Popup Reminders',0,'Success','2025-12-04 12:31:01',1091331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:31:03','2025-12-04 12:31:04',1355828,1,NULL,NULL,NULL,'2025-12-04 12:31:01','2025-12-04 12:31:04','687bf57d2f9463790'),('69317f05cc77246af','Process Job Queue q0',0,'Success','2025-12-04 12:31:01',1091332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:31:04','2025-12-04 12:31:04',1355828,1,NULL,NULL,NULL,'2025-12-04 12:31:01','2025-12-04 12:31:04','687bf57d693e0fc1f'),('69317f061c39799b8','Process Job Queue q1',0,'Success','2025-12-04 12:32:00',1091333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:06','2025-12-04 12:32:06',1355852,1,NULL,NULL,NULL,'2025-12-04 12:31:02','2025-12-04 12:32:06','687bf57d8afb5c472'),('69317f067ce0e3736','Process Job Queue e0',0,'Success','2025-12-04 12:31:02',1091334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:31:05','2025-12-04 12:31:05',1355828,1,NULL,NULL,NULL,'2025-12-04 12:31:02','2025-12-04 12:31:05','687bf57dbba8299ef'),('69317f41b2abccba3','Submit Popup Reminders',0,'Success','2025-12-04 12:32:01',1091335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:06','2025-12-04 12:32:07',1355852,1,NULL,NULL,NULL,'2025-12-04 12:32:01','2025-12-04 12:32:07','687bf57d2f9463790'),('69317f41d97655889','Process Job Queue q0',0,'Success','2025-12-04 12:32:01',1091336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:07','2025-12-04 12:32:08',1355852,1,NULL,NULL,NULL,'2025-12-04 12:32:01','2025-12-04 12:32:08','687bf57d693e0fc1f'),('69317f4201bbdc861','Process Job Queue q1',0,'Success','2025-12-04 12:33:00',1091337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:33:02','2025-12-04 12:33:02',1355890,1,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:33:02','687bf57d8afb5c472'),('69317f422460dc308','Process Job Queue e0',0,'Success','2025-12-04 12:32:02',1091338,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:32:08','2025-12-04 12:32:08',1355852,1,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:32:08','687bf57dbba8299ef'),('69317f424f8327cb6','Send Email Reminders',0,'Success','2025-12-04 12:34:00',1091339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:03','2025-12-04 12:34:03',1355927,1,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:34:03','687bf5d44d3e10813'),('69317f4276e28bf80','Send Email Notifications',0,'Success','2025-12-04 12:34:00',1091340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:04','2025-12-04 12:34:04',1355927,1,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:34:04','687bf5d466067a4ba'),('69317f4293419de18','Process Webhook Queue',0,'Success','2025-12-04 12:34:00',1091341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:04','2025-12-04 12:34:04',1355927,1,NULL,NULL,NULL,'2025-12-04 12:32:02','2025-12-04 12:34:04','687bf5d5788e2fe0e'),('69317f7d6b28ceb7f','Submit Popup Reminders',0,'Success','2025-12-04 12:33:01',1091342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:33:03','2025-12-04 12:33:03',1355890,1,NULL,NULL,NULL,'2025-12-04 12:33:01','2025-12-04 12:33:03','687bf57d2f9463790'),('69317f7d9a747ebf0','Process Job Queue q0',0,'Success','2025-12-04 12:33:01',1091343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:33:04','2025-12-04 12:33:04',1355890,1,NULL,NULL,NULL,'2025-12-04 12:33:01','2025-12-04 12:33:04','687bf57d693e0fc1f'),('69317f7dba9f3aa07','Process Job Queue q1',0,'Success','2025-12-04 12:34:00',1091344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:05','2025-12-04 12:34:05',1355927,1,NULL,NULL,NULL,'2025-12-04 12:33:01','2025-12-04 12:34:05','687bf57d8afb5c472'),('69317f7de4f58eda6','Process Job Queue e0',0,'Success','2025-12-04 12:33:01',1091345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:33:05','2025-12-04 12:33:05',1355890,1,NULL,NULL,NULL,'2025-12-04 12:33:01','2025-12-04 12:33:05','687bf57dbba8299ef'),('69317fb9b594b6282','Submit Popup Reminders',0,'Success','2025-12-04 12:34:01',1091346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:06','2025-12-04 12:34:06',1355927,1,NULL,NULL,NULL,'2025-12-04 12:34:01','2025-12-04 12:34:06','687bf57d2f9463790'),('69317fb9d72abab3d','Process Job Queue q0',0,'Success','2025-12-04 12:34:01',1091347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:07','2025-12-04 12:34:07',1355927,1,NULL,NULL,NULL,'2025-12-04 12:34:01','2025-12-04 12:34:07','687bf57d693e0fc1f'),('69317fba14bdf22de','Process Job Queue q1',0,'Success','2025-12-04 12:35:00',1091348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:35:02','2025-12-04 12:35:02',1355966,1,NULL,NULL,NULL,'2025-12-04 12:34:02','2025-12-04 12:35:02','687bf57d8afb5c472'),('69317fba9a7636e23','Process Job Queue e0',0,'Success','2025-12-04 12:34:02',1091349,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:34:07','2025-12-04 12:34:07',1355927,1,NULL,NULL,NULL,'2025-12-04 12:34:02','2025-12-04 12:34:07','687bf57dbba8299ef'),('69317fbae82c07856','Send Email Reminders',0,'Success','2025-12-04 12:36:00',1091350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:04','2025-12-04 12:36:04',1356001,1,NULL,NULL,NULL,'2025-12-04 12:34:02','2025-12-04 12:36:04','687bf5d44d3e10813'),('69317fbb2be39a1b4','Send Email Notifications',0,'Success','2025-12-04 12:36:00',1091351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:05','2025-12-04 12:36:05',1356001,1,NULL,NULL,NULL,'2025-12-04 12:34:03','2025-12-04 12:36:05','687bf5d466067a4ba'),('69317fbb5b831291a','Process Webhook Queue',0,'Success','2025-12-04 12:36:00',1091352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:05','2025-12-04 12:36:06',1356001,1,NULL,NULL,NULL,'2025-12-04 12:34:03','2025-12-04 12:36:06','687bf5d5788e2fe0e'),('69317ff59b49dc60b','Submit Popup Reminders',0,'Success','2025-12-04 12:35:01',1091353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:35:03','2025-12-04 12:35:04',1355966,1,NULL,NULL,NULL,'2025-12-04 12:35:01','2025-12-04 12:35:04','687bf57d2f9463790'),('69317ff5c75aa54dd','Process Job Queue q0',0,'Success','2025-12-04 12:35:01',1091354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:35:04','2025-12-04 12:35:04',1355966,1,NULL,NULL,NULL,'2025-12-04 12:35:01','2025-12-04 12:35:04','687bf57d693e0fc1f'),('69317ff606463ea96','Process Job Queue q1',0,'Success','2025-12-04 12:36:00',1091355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:06','2025-12-04 12:36:06',1356001,1,NULL,NULL,NULL,'2025-12-04 12:35:02','2025-12-04 12:36:06','687bf57d8afb5c472'),('69317ff63654ebecc','Process Job Queue e0',0,'Success','2025-12-04 12:35:02',1091356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:35:05','2025-12-04 12:35:05',1355966,1,NULL,NULL,NULL,'2025-12-04 12:35:02','2025-12-04 12:35:05','687bf57dbba8299ef'),('693180319bdd409d6','Submit Popup Reminders',0,'Success','2025-12-04 12:36:01',1091357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:07','2025-12-04 12:36:07',1356001,1,NULL,NULL,NULL,'2025-12-04 12:36:01','2025-12-04 12:36:07','687bf57d2f9463790'),('69318031bcc8a90a1','Process Job Queue q0',0,'Success','2025-12-04 12:36:01',1091358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:08','2025-12-04 12:36:08',1356001,1,NULL,NULL,NULL,'2025-12-04 12:36:01','2025-12-04 12:36:08','687bf57d693e0fc1f'),('69318031e1aee240c','Process Job Queue q1',0,'Success','2025-12-04 12:37:00',1091359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:37:02','2025-12-04 12:37:02',1356040,1,NULL,NULL,NULL,'2025-12-04 12:36:01','2025-12-04 12:37:02','687bf57d8afb5c472'),('693180320bef6278a','Process Job Queue e0',0,'Success','2025-12-04 12:36:02',1091360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:36:09','2025-12-04 12:36:09',1356001,1,NULL,NULL,NULL,'2025-12-04 12:36:02','2025-12-04 12:36:09','687bf57dbba8299ef'),('693180328cb29829e','Send Email Reminders',0,'Success','2025-12-04 12:38:00',1091361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:03','2025-12-04 12:38:03',1356077,1,NULL,NULL,NULL,'2025-12-04 12:36:02','2025-12-04 12:38:03','687bf5d44d3e10813'),('69318032cc3d35d9f','Send Email Notifications',0,'Success','2025-12-04 12:38:00',1091362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:04','2025-12-04 12:38:04',1356077,1,NULL,NULL,NULL,'2025-12-04 12:36:02','2025-12-04 12:38:04','687bf5d466067a4ba'),('693180330e8fe4caf','Auth Token Control',0,'Success','2025-12-04 12:42:00',1091363,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:03','2025-12-04 12:42:03',1356295,1,NULL,NULL,NULL,'2025-12-04 12:36:03','2025-12-04 12:42:03','687bf5d511e08c57f'),('69318033422690f18','Process Webhook Queue',0,'Success','2025-12-04 12:38:00',1091364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:04','2025-12-04 12:38:04',1356077,1,NULL,NULL,NULL,'2025-12-04 12:36:03','2025-12-04 12:38:04','687bf5d5788e2fe0e'),('6931806de3f915b6e','Submit Popup Reminders',0,'Success','2025-12-04 12:37:01',1091365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:37:03','2025-12-04 12:37:03',1356040,1,NULL,NULL,NULL,'2025-12-04 12:37:01','2025-12-04 12:37:03','687bf57d2f9463790'),('6931806e18c2eb57f','Process Job Queue q0',0,'Success','2025-12-04 12:37:02',1091366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:37:04','2025-12-04 12:37:04',1356040,1,NULL,NULL,NULL,'2025-12-04 12:37:02','2025-12-04 12:37:04','687bf57d693e0fc1f'),('6931806e39134bd82','Process Job Queue q1',0,'Success','2025-12-04 12:38:00',1091367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:05','2025-12-04 12:38:05',1356077,1,NULL,NULL,NULL,'2025-12-04 12:37:02','2025-12-04 12:38:05','687bf57d8afb5c472'),('6931806e5b5426a3d','Process Job Queue e0',0,'Success','2025-12-04 12:37:02',1091368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:37:05','2025-12-04 12:37:05',1356040,1,NULL,NULL,NULL,'2025-12-04 12:37:02','2025-12-04 12:37:05','687bf57dbba8299ef'),('693180a95e465b0a9','Submit Popup Reminders',0,'Success','2025-12-04 12:38:01',1091369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:06','2025-12-04 12:38:06',1356077,1,NULL,NULL,NULL,'2025-12-04 12:38:01','2025-12-04 12:38:06','687bf57d2f9463790'),('693180a98bedaccbc','Process Job Queue q0',0,'Success','2025-12-04 12:38:01',1091370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:07','2025-12-04 12:38:07',1356077,1,NULL,NULL,NULL,'2025-12-04 12:38:01','2025-12-04 12:38:07','687bf57d693e0fc1f'),('693180a9acc01e3ad','Process Job Queue q1',0,'Success','2025-12-04 12:39:00',1091371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:39:02','2025-12-04 12:39:03',1356140,1,NULL,NULL,NULL,'2025-12-04 12:38:01','2025-12-04 12:39:03','687bf57d8afb5c472'),('693180a9e721dd39c','Process Job Queue e0',0,'Success','2025-12-04 12:38:01',1091372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:38:07','2025-12-04 12:38:08',1356077,1,NULL,NULL,NULL,'2025-12-04 12:38:01','2025-12-04 12:38:08','687bf57dbba8299ef'),('693180aa3190930b3','Send Email Reminders',0,'Success','2025-12-04 12:40:00',1091373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:04','2025-12-04 12:40:04',1356220,1,NULL,NULL,NULL,'2025-12-04 12:38:02','2025-12-04 12:40:04','687bf5d44d3e10813'),('693180aaa6733ef09','Send Email Notifications',0,'Success','2025-12-04 12:40:00',1091374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:05','2025-12-04 12:40:05',1356220,1,NULL,NULL,NULL,'2025-12-04 12:38:02','2025-12-04 12:40:05','687bf5d466067a4ba'),('693180aae20c46b6a','Process Webhook Queue',0,'Success','2025-12-04 12:40:00',1091375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:06','2025-12-04 12:40:06',1356220,1,NULL,NULL,NULL,'2025-12-04 12:38:02','2025-12-04 12:40:06','687bf5d5788e2fe0e'),('693180e5d28882fed','Submit Popup Reminders',0,'Success','2025-12-04 12:39:01',1091376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:39:04','2025-12-04 12:39:04',1356140,1,NULL,NULL,NULL,'2025-12-04 12:39:01','2025-12-04 12:39:04','687bf57d2f9463790'),('693180e6031098e6d','Process Job Queue q0',0,'Success','2025-12-04 12:39:02',1091377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:39:04','2025-12-04 12:39:04',1356140,1,NULL,NULL,NULL,'2025-12-04 12:39:02','2025-12-04 12:39:04','687bf57d693e0fc1f'),('693180e6383195e51','Process Job Queue q1',0,'Success','2025-12-04 12:40:00',1091378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:06','2025-12-04 12:40:06',1356220,1,NULL,NULL,NULL,'2025-12-04 12:39:02','2025-12-04 12:40:06','687bf57d8afb5c472'),('693180e67abe97927','Process Job Queue e0',0,'Success','2025-12-04 12:39:02',1091379,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:39:05','2025-12-04 12:39:05',1356140,1,NULL,NULL,NULL,'2025-12-04 12:39:02','2025-12-04 12:39:05','687bf57dbba8299ef'),('69318121acce90e96','Submit Popup Reminders',0,'Success','2025-12-04 12:40:01',1091380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:07','2025-12-04 12:40:07',1356220,1,NULL,NULL,NULL,'2025-12-04 12:40:01','2025-12-04 12:40:07','687bf57d2f9463790'),('69318121e3d0d5044','Process Job Queue q0',0,'Success','2025-12-04 12:40:01',1091381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:08','2025-12-04 12:40:08',1356220,1,NULL,NULL,NULL,'2025-12-04 12:40:01','2025-12-04 12:40:08','687bf57d693e0fc1f'),('6931812279393ad80','Process Job Queue q1',0,'Success','2025-12-04 12:41:00',1091382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:41:02','2025-12-04 12:41:02',1356259,1,NULL,NULL,NULL,'2025-12-04 12:40:02','2025-12-04 12:41:02','687bf57d8afb5c472'),('69318122aa3ead391','Process Job Queue e0',0,'Success','2025-12-04 12:40:02',1091383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:40:09','2025-12-04 12:40:09',1356220,1,NULL,NULL,NULL,'2025-12-04 12:40:02','2025-12-04 12:40:09','687bf57dbba8299ef'),('69318122f175dd1f2','Send Email Reminders',0,'Success','2025-12-04 12:42:00',1091384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:04','2025-12-04 12:42:05',1356295,1,NULL,NULL,NULL,'2025-12-04 12:40:02','2025-12-04 12:42:05','687bf5d44d3e10813'),('693181232d192fc09','Send Email Notifications',0,'Success','2025-12-04 12:42:00',1091385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:05','2025-12-04 12:42:05',1356295,1,NULL,NULL,NULL,'2025-12-04 12:40:03','2025-12-04 12:42:05','687bf5d466067a4ba'),('693181235840ac2f0','Process Webhook Queue',0,'Success','2025-12-04 12:42:00',1091386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:06','2025-12-04 12:42:06',1356295,1,NULL,NULL,NULL,'2025-12-04 12:40:03','2025-12-04 12:42:06','687bf5d5788e2fe0e'),('693181237d4d4414d','Send Scheduled Emails',0,'Success','2025-12-04 12:50:00',1091387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:05','2025-12-04 12:50:05',1356604,1,NULL,NULL,NULL,'2025-12-04 12:40:03','2025-12-04 12:50:05','687bf5d5eeb01d80d'),('6931815dad4689026','Submit Popup Reminders',0,'Success','2025-12-04 12:41:01',1091388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:41:03','2025-12-04 12:41:03',1356259,1,NULL,NULL,NULL,'2025-12-04 12:41:01','2025-12-04 12:41:03','687bf57d2f9463790'),('6931815dccdda0be8','Process Job Queue q0',0,'Success','2025-12-04 12:41:01',1091389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:41:04','2025-12-04 12:41:04',1356259,1,NULL,NULL,NULL,'2025-12-04 12:41:01','2025-12-04 12:41:04','687bf57d693e0fc1f'),('6931815ded64f7d1c','Process Job Queue q1',0,'Success','2025-12-04 12:42:00',1091390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:07','2025-12-04 12:42:07',1356295,1,NULL,NULL,NULL,'2025-12-04 12:41:01','2025-12-04 12:42:07','687bf57d8afb5c472'),('6931815e1a70fbbec','Process Job Queue e0',0,'Success','2025-12-04 12:41:02',1091391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:41:05','2025-12-04 12:41:06',1356259,1,NULL,NULL,NULL,'2025-12-04 12:41:02','2025-12-04 12:41:06','687bf57dbba8299ef'),('69318199558e9001d','Submit Popup Reminders',0,'Success','2025-12-04 12:42:01',1091392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:07','2025-12-04 12:42:07',1356295,1,NULL,NULL,NULL,'2025-12-04 12:42:01','2025-12-04 12:42:07','687bf57d2f9463790'),('693181998b86eba36','Process Job Queue q0',0,'Success','2025-12-04 12:42:01',1091393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:08','2025-12-04 12:42:08',1356295,1,NULL,NULL,NULL,'2025-12-04 12:42:01','2025-12-04 12:42:08','687bf57d693e0fc1f'),('69318199b8adf6bec','Process Job Queue q1',0,'Success','2025-12-04 12:43:00',1091394,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:43:03','2025-12-04 12:43:03',1356328,1,NULL,NULL,NULL,'2025-12-04 12:42:01','2025-12-04 12:43:03','687bf57d8afb5c472'),('69318199eef1f548d','Process Job Queue e0',0,'Success','2025-12-04 12:42:01',1091395,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:42:09','2025-12-04 12:42:09',1356295,1,NULL,NULL,NULL,'2025-12-04 12:42:01','2025-12-04 12:42:09','687bf57dbba8299ef'),('6931819abaa16a11c','Send Email Reminders',0,'Success','2025-12-04 12:44:00',1091396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:03','2025-12-04 12:44:03',1356369,1,NULL,NULL,NULL,'2025-12-04 12:42:02','2025-12-04 12:44:03','687bf5d44d3e10813'),('6931819af3fa7ca12','Send Email Notifications',0,'Success','2025-12-04 12:44:00',1091397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:04','2025-12-04 12:44:04',1356369,1,NULL,NULL,NULL,'2025-12-04 12:42:02','2025-12-04 12:44:04','687bf5d466067a4ba'),('6931819b368453246','Auth Token Control',0,'Success','2025-12-04 12:48:00',1091398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:04','2025-12-04 12:48:04',1356532,1,NULL,NULL,NULL,'2025-12-04 12:42:03','2025-12-04 12:48:04','687bf5d511e08c57f'),('6931819b6ec583648','Process Webhook Queue',0,'Success','2025-12-04 12:44:00',1091399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:04','2025-12-04 12:44:05',1356369,1,NULL,NULL,NULL,'2025-12-04 12:42:03','2025-12-04 12:44:05','687bf5d5788e2fe0e'),('693181d5c9c622968','Submit Popup Reminders',0,'Success','2025-12-04 12:43:01',1091400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:43:04','2025-12-04 12:43:04',1356328,1,NULL,NULL,NULL,'2025-12-04 12:43:01','2025-12-04 12:43:04','687bf57d2f9463790'),('693181d5f32ed0bba','Process Job Queue q0',0,'Success','2025-12-04 12:43:01',1091401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:43:05','2025-12-04 12:43:05',1356328,1,NULL,NULL,NULL,'2025-12-04 12:43:01','2025-12-04 12:43:05','687bf57d693e0fc1f'),('693181d629d6128b7','Process Job Queue q1',0,'Success','2025-12-04 12:44:00',1091402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:05','2025-12-04 12:44:05',1356369,1,NULL,NULL,NULL,'2025-12-04 12:43:02','2025-12-04 12:44:05','687bf57d8afb5c472'),('693181d65bd50747e','Process Job Queue e0',0,'Success','2025-12-04 12:43:02',1091403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:43:05','2025-12-04 12:43:05',1356328,1,NULL,NULL,NULL,'2025-12-04 12:43:02','2025-12-04 12:43:05','687bf57dbba8299ef'),('6931821173f4a6048','Submit Popup Reminders',0,'Success','2025-12-04 12:44:01',1091404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:06','2025-12-04 12:44:06',1356369,1,NULL,NULL,NULL,'2025-12-04 12:44:01','2025-12-04 12:44:06','687bf57d2f9463790'),('69318211ab7dd26ae','Process Job Queue q0',0,'Success','2025-12-04 12:44:01',1091405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:07','2025-12-04 12:44:07',1356369,1,NULL,NULL,NULL,'2025-12-04 12:44:01','2025-12-04 12:44:07','687bf57d693e0fc1f'),('69318211d57de66c3','Process Job Queue q1',0,'Success','2025-12-04 12:45:00',1091406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:45:02','2025-12-04 12:45:02',1356407,1,NULL,NULL,NULL,'2025-12-04 12:44:01','2025-12-04 12:45:02','687bf57d8afb5c472'),('69318212a4ce85359','Process Job Queue e0',0,'Success','2025-12-04 12:44:02',1091407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:44:08','2025-12-04 12:44:08',1356369,1,NULL,NULL,NULL,'2025-12-04 12:44:02','2025-12-04 12:44:08','687bf57dbba8299ef'),('69318212dc86d5832','Send Email Reminders',0,'Success','2025-12-04 12:46:00',1091408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:03','2025-12-04 12:46:03',1356454,1,NULL,NULL,NULL,'2025-12-04 12:44:02','2025-12-04 12:46:03','687bf5d44d3e10813'),('693182132ba8741f0','Send Email Notifications',0,'Success','2025-12-04 12:46:00',1091409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:04','2025-12-04 12:46:04',1356454,1,NULL,NULL,NULL,'2025-12-04 12:44:03','2025-12-04 12:46:04','687bf5d466067a4ba'),('69318213615cc083f','Process Webhook Queue',0,'Success','2025-12-04 12:46:00',1091410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:04','2025-12-04 12:46:04',1356454,1,NULL,NULL,NULL,'2025-12-04 12:44:03','2025-12-04 12:46:04','687bf5d5788e2fe0e'),('6931824d919e96547','Submit Popup Reminders',0,'Success','2025-12-04 12:45:01',1091411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:45:03','2025-12-04 12:45:04',1356407,1,NULL,NULL,NULL,'2025-12-04 12:45:01','2025-12-04 12:45:04','687bf57d2f9463790'),('6931824db1d3654e1','Process Job Queue q0',0,'Success','2025-12-04 12:45:01',1091412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:45:04','2025-12-04 12:45:04',1356407,1,NULL,NULL,NULL,'2025-12-04 12:45:01','2025-12-04 12:45:04','687bf57d693e0fc1f'),('6931824dd06c4819d','Process Job Queue q1',0,'Success','2025-12-04 12:46:00',1091413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:05','2025-12-04 12:46:05',1356454,1,NULL,NULL,NULL,'2025-12-04 12:45:01','2025-12-04 12:46:05','687bf57d8afb5c472'),('6931824e0c0e3e374','Process Job Queue e0',0,'Success','2025-12-04 12:45:02',1091414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:45:05','2025-12-04 12:45:05',1356407,1,NULL,NULL,NULL,'2025-12-04 12:45:02','2025-12-04 12:45:05','687bf57dbba8299ef'),('6931828983f455fae','Submit Popup Reminders',0,'Success','2025-12-04 12:46:01',1091415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:06','2025-12-04 12:46:06',1356454,1,NULL,NULL,NULL,'2025-12-04 12:46:01','2025-12-04 12:46:06','687bf57d2f9463790'),('69318289a78a76be7','Process Job Queue q0',0,'Success','2025-12-04 12:46:01',1091416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:06','2025-12-04 12:46:06',1356454,1,NULL,NULL,NULL,'2025-12-04 12:46:01','2025-12-04 12:46:06','687bf57d693e0fc1f'),('69318289c8ef6279f','Process Job Queue q1',0,'Success','2025-12-04 12:47:00',1091417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:47:01','2025-12-04 12:47:02',1356492,1,NULL,NULL,NULL,'2025-12-04 12:46:01','2025-12-04 12:47:02','687bf57d8afb5c472'),('69318289f0d153895','Process Job Queue e0',0,'Success','2025-12-04 12:46:01',1091418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:46:07','2025-12-04 12:46:07',1356454,1,NULL,NULL,NULL,'2025-12-04 12:46:01','2025-12-04 12:46:07','687bf57dbba8299ef'),('6931828a4de09704d','Send Email Reminders',0,'Success','2025-12-04 12:48:00',1091419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:05','2025-12-04 12:48:05',1356532,1,NULL,NULL,NULL,'2025-12-04 12:46:02','2025-12-04 12:48:05','687bf5d44d3e10813'),('6931828aacc868928','Send Email Notifications',0,'Success','2025-12-04 12:48:00',1091420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:06','2025-12-04 12:48:06',1356532,1,NULL,NULL,NULL,'2025-12-04 12:46:02','2025-12-04 12:48:06','687bf5d466067a4ba'),('6931828aea6ac3182','Process Webhook Queue',0,'Success','2025-12-04 12:48:00',1091421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:06','2025-12-04 12:48:07',1356532,1,NULL,NULL,NULL,'2025-12-04 12:46:02','2025-12-04 12:48:07','687bf5d5788e2fe0e'),('693182c53006cc7be','Submit Popup Reminders',0,'Success','2025-12-04 12:47:01',1091422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:47:03','2025-12-04 12:47:03',1356492,1,NULL,NULL,NULL,'2025-12-04 12:47:01','2025-12-04 12:47:03','687bf57d2f9463790'),('693182c5600079076','Process Job Queue q0',0,'Success','2025-12-04 12:47:01',1091423,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:47:04','2025-12-04 12:47:04',1356492,1,NULL,NULL,NULL,'2025-12-04 12:47:01','2025-12-04 12:47:04','687bf57d693e0fc1f'),('693182c57ea989194','Process Job Queue q1',0,'Success','2025-12-04 12:48:00',1091424,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:07','2025-12-04 12:48:07',1356532,1,NULL,NULL,NULL,'2025-12-04 12:47:01','2025-12-04 12:48:07','687bf57d8afb5c472'),('693182c5b0b5f2696','Process Job Queue e0',0,'Success','2025-12-04 12:47:01',1091425,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:47:04','2025-12-04 12:47:04',1356492,1,NULL,NULL,NULL,'2025-12-04 12:47:01','2025-12-04 12:47:04','687bf57dbba8299ef'),('6931830218c0475dc','Submit Popup Reminders',0,'Success','2025-12-04 12:48:02',1091426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:08','2025-12-04 12:48:08',1356532,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:48:08','687bf57d2f9463790'),('6931830242bdb7387','Process Job Queue q0',0,'Success','2025-12-04 12:48:02',1091427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:09','2025-12-04 12:48:09',1356532,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:48:09','687bf57d693e0fc1f'),('693183026557128df','Process Job Queue q1',0,'Success','2025-12-04 12:49:00',1091428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:49:02','2025-12-04 12:49:03',1356567,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:49:03','687bf57d8afb5c472'),('693183029243c5c14','Process Job Queue e0',0,'Success','2025-12-04 12:48:02',1091429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:48:09','2025-12-04 12:48:09',1356532,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:48:09','687bf57dbba8299ef'),('69318302c707ce939','Send Email Reminders',0,'Success','2025-12-04 12:50:00',1091430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:06','2025-12-04 12:50:06',1356604,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:50:06','687bf5d44d3e10813'),('69318302e4aabf79e','Send Email Notifications',0,'Success','2025-12-04 12:50:00',1091431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:07','2025-12-04 12:50:07',1356604,1,NULL,NULL,NULL,'2025-12-04 12:48:02','2025-12-04 12:50:07','687bf5d466067a4ba'),('69318303854773c02','Auth Token Control',0,'Success','2025-12-04 12:54:00',1091432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:04','2025-12-04 12:54:04',1356763,1,NULL,NULL,NULL,'2025-12-04 12:48:03','2025-12-04 12:54:04','687bf5d511e08c57f'),('69318303b2871bcc0','Process Webhook Queue',0,'Success','2025-12-04 12:50:00',1091433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:07','2025-12-04 12:50:07',1356604,1,NULL,NULL,NULL,'2025-12-04 12:48:03','2025-12-04 12:50:07','687bf5d5788e2fe0e'),('6931833da8c89bd31','Submit Popup Reminders',0,'Success','2025-12-04 12:49:01',1091434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:49:04','2025-12-04 12:49:04',1356567,1,NULL,NULL,NULL,'2025-12-04 12:49:01','2025-12-04 12:49:04','687bf57d2f9463790'),('6931833dce1f021e2','Process Job Queue q0',0,'Success','2025-12-04 12:49:01',1091435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:49:04','2025-12-04 12:49:04',1356567,1,NULL,NULL,NULL,'2025-12-04 12:49:01','2025-12-04 12:49:04','687bf57d693e0fc1f'),('6931833e177afc8c6','Process Job Queue q1',0,'Success','2025-12-04 12:50:00',1091436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:08','2025-12-04 12:50:08',1356604,1,NULL,NULL,NULL,'2025-12-04 12:49:02','2025-12-04 12:50:08','687bf57d8afb5c472'),('6931833e6fc780594','Process Job Queue e0',0,'Success','2025-12-04 12:49:02',1091437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:49:05','2025-12-04 12:49:05',1356567,1,NULL,NULL,NULL,'2025-12-04 12:49:02','2025-12-04 12:49:05','687bf57dbba8299ef'),('6931837a19750242f','Submit Popup Reminders',0,'Success','2025-12-04 12:50:02',1091438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:09','2025-12-04 12:50:09',1356604,1,NULL,NULL,NULL,'2025-12-04 12:50:02','2025-12-04 12:50:09','687bf57d2f9463790'),('6931837a57b7822bc','Process Job Queue q0',0,'Success','2025-12-04 12:50:02',1091439,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:09','2025-12-04 12:50:10',1356604,1,NULL,NULL,NULL,'2025-12-04 12:50:02','2025-12-04 12:50:10','687bf57d693e0fc1f'),('6931837a9afe7b936','Process Job Queue q1',0,'Success','2025-12-04 12:51:00',1091440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:51:02','2025-12-04 12:51:03',1356652,1,NULL,NULL,NULL,'2025-12-04 12:50:02','2025-12-04 12:51:03','687bf57d8afb5c472'),('6931837ae7717b0ad','Process Job Queue e0',0,'Success','2025-12-04 12:50:02',1091441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:50:10','2025-12-04 12:50:10',1356604,1,NULL,NULL,NULL,'2025-12-04 12:50:02','2025-12-04 12:50:10','687bf57dbba8299ef'),('6931837b5f46c6bf2','Send Email Reminders',0,'Success','2025-12-04 12:52:00',1091442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:02','2025-12-04 12:52:02',1356688,1,NULL,NULL,NULL,'2025-12-04 12:50:03','2025-12-04 12:52:02','687bf5d44d3e10813'),('6931837bab9491581','Send Email Notifications',0,'Success','2025-12-04 12:52:00',1091443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:03','2025-12-04 12:52:03',1356688,1,NULL,NULL,NULL,'2025-12-04 12:50:03','2025-12-04 12:52:03','687bf5d466067a4ba'),('6931837bdd494dbcd','Send Mass Emails',0,'Success','2025-12-04 13:10:00',1091444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:03','2025-12-04 13:10:03',1357397,1,NULL,NULL,NULL,'2025-12-04 12:50:03','2025-12-04 13:10:03','687bf5d4b535f913f'),('6931837c12d103812','Process Webhook Queue',0,'Success','2025-12-04 12:52:00',1091445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:04','2025-12-04 12:52:04',1356688,1,NULL,NULL,NULL,'2025-12-04 12:50:04','2025-12-04 12:52:04','687bf5d5788e2fe0e'),('6931837c4069def94','Send Scheduled Emails',0,'Success','2025-12-04 13:00:00',1091446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:03','2025-12-04 13:00:03',1356988,1,NULL,NULL,NULL,'2025-12-04 12:50:04','2025-12-04 13:00:03','687bf5d5eeb01d80d'),('693183b5a7f1bd8f2','Submit Popup Reminders',0,'Success','2025-12-04 12:51:01',1091447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:51:04','2025-12-04 12:51:04',1356652,1,NULL,NULL,NULL,'2025-12-04 12:51:01','2025-12-04 12:51:04','687bf57d2f9463790'),('693183b5d8826aab9','Process Job Queue q0',0,'Success','2025-12-04 12:51:01',1091448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:51:04','2025-12-04 12:51:05',1356652,1,NULL,NULL,NULL,'2025-12-04 12:51:01','2025-12-04 12:51:05','687bf57d693e0fc1f'),('693183b604cf7e4fd','Process Job Queue q1',0,'Success','2025-12-04 12:52:00',1091449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:05','2025-12-04 12:52:05',1356688,1,NULL,NULL,NULL,'2025-12-04 12:51:02','2025-12-04 12:52:05','687bf57d8afb5c472'),('693183b638e136f08','Process Job Queue e0',0,'Success','2025-12-04 12:51:02',1091450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:51:05','2025-12-04 12:51:05',1356652,1,NULL,NULL,NULL,'2025-12-04 12:51:02','2025-12-04 12:51:05','687bf57dbba8299ef'),('693183f13caf2ba11','Submit Popup Reminders',0,'Success','2025-12-04 12:52:01',1091451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:07','2025-12-04 12:52:07',1356688,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:52:07','687bf57d2f9463790'),('693183f15d0a2bf8a','Process Job Queue q0',0,'Success','2025-12-04 12:52:01',1091452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:07','2025-12-04 12:52:08',1356688,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:52:08','687bf57d693e0fc1f'),('693183f185ef6824f','Process Job Queue q1',0,'Success','2025-12-04 12:53:00',1091453,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:53:02','2025-12-04 12:53:03',1356726,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:53:03','687bf57d8afb5c472'),('693183f1a9d31e1ed','Process Job Queue e0',0,'Success','2025-12-04 12:52:01',1091454,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:52:08','2025-12-04 12:52:08',1356688,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:52:08','687bf57dbba8299ef'),('693183f1d510730ff','Send Email Reminders',0,'Success','2025-12-04 12:54:00',1091455,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:05','2025-12-04 12:54:05',1356763,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:54:05','687bf5d44d3e10813'),('693183f1f40e5ddfd','Send Email Notifications',0,'Success','2025-12-04 12:54:00',1091456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:06','2025-12-04 12:54:06',1356763,1,NULL,NULL,NULL,'2025-12-04 12:52:01','2025-12-04 12:54:06','687bf5d466067a4ba'),('693183f224c40ca47','Process Webhook Queue',0,'Success','2025-12-04 12:54:00',1091457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:07','2025-12-04 12:54:07',1356763,1,NULL,NULL,NULL,'2025-12-04 12:52:02','2025-12-04 12:54:07','687bf5d5788e2fe0e'),('6931842dccef72fcb','Submit Popup Reminders',0,'Success','2025-12-04 12:53:01',1091458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:53:04','2025-12-04 12:53:04',1356726,1,NULL,NULL,NULL,'2025-12-04 12:53:01','2025-12-04 12:53:04','687bf57d2f9463790'),('6931842df339578da','Process Job Queue q0',0,'Success','2025-12-04 12:53:01',1091459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:53:05','2025-12-04 12:53:05',1356726,1,NULL,NULL,NULL,'2025-12-04 12:53:01','2025-12-04 12:53:05','687bf57d693e0fc1f'),('6931842e319ac2fb6','Process Job Queue q1',0,'Success','2025-12-04 12:54:00',1091460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:07','2025-12-04 12:54:08',1356763,1,NULL,NULL,NULL,'2025-12-04 12:53:02','2025-12-04 12:54:08','687bf57d8afb5c472'),('6931842e5b5ca885c','Process Job Queue e0',0,'Success','2025-12-04 12:53:02',1091461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:53:06','2025-12-04 12:53:06',1356726,1,NULL,NULL,NULL,'2025-12-04 12:53:02','2025-12-04 12:53:06','687bf57dbba8299ef'),('6931846a0747227b1','Submit Popup Reminders',0,'Success','2025-12-04 12:54:02',1091462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:08','2025-12-04 12:54:08',1356763,1,NULL,NULL,NULL,'2025-12-04 12:54:02','2025-12-04 12:54:08','687bf57d2f9463790'),('6931846a2dbe1e679','Process Job Queue q0',0,'Success','2025-12-04 12:54:02',1091463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:09','2025-12-04 12:54:09',1356763,1,NULL,NULL,NULL,'2025-12-04 12:54:02','2025-12-04 12:54:09','687bf57d693e0fc1f'),('6931846a56b73b5e7','Process Job Queue q1',0,'Success','2025-12-04 12:55:00',1091464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:55:02','2025-12-04 12:55:02',1356794,1,NULL,NULL,NULL,'2025-12-04 12:54:02','2025-12-04 12:55:02','687bf57d8afb5c472'),('6931846a94ff7ce9b','Process Job Queue e0',0,'Success','2025-12-04 12:54:02',1091465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:54:10','2025-12-04 12:54:10',1356763,1,NULL,NULL,NULL,'2025-12-04 12:54:02','2025-12-04 12:54:10','687bf57dbba8299ef'),('6931846ac482ac527','Send Email Reminders',0,'Success','2025-12-04 12:56:00',1091466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:03','2025-12-04 12:56:04',1356834,1,NULL,NULL,NULL,'2025-12-04 12:54:02','2025-12-04 12:56:04','687bf5d44d3e10813'),('6931846b038b3124f','Send Email Notifications',0,'Success','2025-12-04 12:56:00',1091467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:05','2025-12-04 12:56:05',1356834,1,NULL,NULL,NULL,'2025-12-04 12:54:03','2025-12-04 12:56:05','687bf5d466067a4ba'),('6931846b398c8caf5','Auth Token Control',0,'Success','2025-12-04 13:00:00',1091468,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:04','2025-12-04 13:00:04',1356988,1,NULL,NULL,NULL,'2025-12-04 12:54:03','2025-12-04 13:00:04','687bf5d511e08c57f'),('6931846c1ad6a7134','Process Webhook Queue',0,'Success','2025-12-04 12:56:00',1091469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:06','2025-12-04 12:56:06',1356834,1,NULL,NULL,NULL,'2025-12-04 12:54:04','2025-12-04 12:56:06','687bf5d5788e2fe0e'),('693184a601e636aa5','Submit Popup Reminders',0,'Success','2025-12-04 12:55:02',1091470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:55:03','2025-12-04 12:55:04',1356794,1,NULL,NULL,NULL,'2025-12-04 12:55:02','2025-12-04 12:55:04','687bf57d2f9463790'),('693184a627860e077','Process Job Queue q0',0,'Success','2025-12-04 12:55:02',1091471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:55:04','2025-12-04 12:55:05',1356794,1,NULL,NULL,NULL,'2025-12-04 12:55:02','2025-12-04 12:55:05','687bf57d693e0fc1f'),('693184a650b3dc15d','Process Job Queue q1',0,'Success','2025-12-04 12:56:00',1091472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:06','2025-12-04 12:56:07',1356834,1,NULL,NULL,NULL,'2025-12-04 12:55:02','2025-12-04 12:56:07','687bf57d8afb5c472'),('693184a67c5e7b863','Process Job Queue e0',0,'Success','2025-12-04 12:55:02',1091473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:55:05','2025-12-04 12:55:05',1356794,1,NULL,NULL,NULL,'2025-12-04 12:55:02','2025-12-04 12:55:05','687bf57dbba8299ef'),('693184e204bb44306','Submit Popup Reminders',0,'Success','2025-12-04 12:56:02',1091474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:07','2025-12-04 12:56:07',1356834,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:56:07','687bf57d2f9463790'),('693184e23cba03b11','Process Job Queue q0',0,'Success','2025-12-04 12:56:02',1091475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:08','2025-12-04 12:56:08',1356834,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:56:08','687bf57d693e0fc1f'),('693184e26da57989e','Process Job Queue q1',0,'Success','2025-12-04 12:57:00',1091476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:57:02','2025-12-04 12:57:03',1356872,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:57:03','687bf57d8afb5c472'),('693184e2a1dc60750','Process Job Queue e0',0,'Success','2025-12-04 12:56:02',1091477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:56:08','2025-12-04 12:56:09',1356834,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:56:09','687bf57dbba8299ef'),('693184e2c1bc23b0d','Send Email Reminders',0,'Success','2025-12-04 12:58:00',1091478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:03','2025-12-04 12:58:03',1356915,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:58:03','687bf5d44d3e10813'),('693184e2ee02756c7','Send Email Notifications',0,'Success','2025-12-04 12:58:00',1091479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:04','2025-12-04 12:58:04',1356915,1,NULL,NULL,NULL,'2025-12-04 12:56:02','2025-12-04 12:58:04','687bf5d466067a4ba'),('693184e3852c99106','Process Webhook Queue',0,'Success','2025-12-04 12:58:00',1091480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:05','2025-12-04 12:58:05',1356915,1,NULL,NULL,NULL,'2025-12-04 12:56:03','2025-12-04 12:58:05','687bf5d5788e2fe0e'),('6931851d847ce0366','Submit Popup Reminders',0,'Success','2025-12-04 12:57:01',1091481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:57:04','2025-12-04 12:57:04',1356872,1,NULL,NULL,NULL,'2025-12-04 12:57:01','2025-12-04 12:57:04','687bf57d2f9463790'),('6931851db168113f1','Process Job Queue q0',0,'Success','2025-12-04 12:57:01',1091482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:57:04','2025-12-04 12:57:05',1356872,1,NULL,NULL,NULL,'2025-12-04 12:57:01','2025-12-04 12:57:05','687bf57d693e0fc1f'),('6931851dd4be21923','Process Job Queue q1',0,'Success','2025-12-04 12:58:00',1091483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:05','2025-12-04 12:58:05',1356915,1,NULL,NULL,NULL,'2025-12-04 12:57:01','2025-12-04 12:58:05','687bf57d8afb5c472'),('6931851e102534871','Process Job Queue e0',0,'Success','2025-12-04 12:57:02',1091484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:57:05','2025-12-04 12:57:05',1356872,1,NULL,NULL,NULL,'2025-12-04 12:57:02','2025-12-04 12:57:05','687bf57dbba8299ef'),('693185597dc08af04','Submit Popup Reminders',0,'Success','2025-12-04 12:58:01',1091485,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:06','2025-12-04 12:58:06',1356915,1,NULL,NULL,NULL,'2025-12-04 12:58:01','2025-12-04 12:58:06','687bf57d2f9463790'),('69318559dc08b7310','Process Job Queue q0',0,'Success','2025-12-04 12:58:01',1091486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:07','2025-12-04 12:58:07',1356915,1,NULL,NULL,NULL,'2025-12-04 12:58:01','2025-12-04 12:58:07','687bf57d693e0fc1f'),('6931855a37c9c6f07','Process Job Queue q1',0,'Success','2025-12-04 12:59:00',1091487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:59:02','2025-12-04 12:59:02',1356952,1,NULL,NULL,NULL,'2025-12-04 12:58:02','2025-12-04 12:59:02','687bf57d8afb5c472'),('6931855a712e68c4c','Process Job Queue e0',0,'Success','2025-12-04 12:58:02',1091488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:58:07','2025-12-04 12:58:08',1356915,1,NULL,NULL,NULL,'2025-12-04 12:58:02','2025-12-04 12:58:08','687bf57dbba8299ef'),('6931855ab0ef5ff6e','Send Email Reminders',0,'Success','2025-12-04 13:00:00',1091489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:05','2025-12-04 13:00:05',1356988,1,NULL,NULL,NULL,'2025-12-04 12:58:02','2025-12-04 13:00:05','687bf5d44d3e10813'),('6931855ae96307e9a','Send Email Notifications',0,'Success','2025-12-04 13:00:00',1091490,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:05','2025-12-04 13:00:05',1356988,1,NULL,NULL,NULL,'2025-12-04 12:58:02','2025-12-04 13:00:05','687bf5d466067a4ba'),('6931855b36e8501d0','Process Webhook Queue',0,'Success','2025-12-04 13:00:00',1091491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:06','2025-12-04 13:00:06',1356988,1,NULL,NULL,NULL,'2025-12-04 12:58:03','2025-12-04 13:00:06','687bf5d5788e2fe0e'),('6931859562e298080','Submit Popup Reminders',0,'Success','2025-12-04 12:59:01',1091492,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:59:03','2025-12-04 12:59:03',1356952,1,NULL,NULL,NULL,'2025-12-04 12:59:01','2025-12-04 12:59:03','687bf57d2f9463790'),('69318595883e569b3','Process Job Queue q0',0,'Success','2025-12-04 12:59:01',1091493,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:59:04','2025-12-04 12:59:04',1356952,1,NULL,NULL,NULL,'2025-12-04 12:59:01','2025-12-04 12:59:04','687bf57d693e0fc1f'),('69318595a2f226d20','Process Job Queue q1',0,'Success','2025-12-04 13:00:00',1091494,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:07','2025-12-04 13:00:07',1356988,1,NULL,NULL,NULL,'2025-12-04 12:59:01','2025-12-04 13:00:07','687bf57d8afb5c472'),('69318595d9d4fafa2','Process Job Queue e0',0,'Success','2025-12-04 12:59:01',1091495,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 12:59:04','2025-12-04 12:59:04',1356952,1,NULL,NULL,NULL,'2025-12-04 12:59:01','2025-12-04 12:59:04','687bf57dbba8299ef'),('693185d13356b5cb8','Submit Popup Reminders',0,'Success','2025-12-04 13:00:01',1091496,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:07','2025-12-04 13:00:07',1356988,1,NULL,NULL,NULL,'2025-12-04 13:00:01','2025-12-04 13:00:07','687bf57d2f9463790'),('693185d1548391eec','Process Job Queue q0',0,'Success','2025-12-04 13:00:01',1091497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:08','2025-12-04 13:00:08',1356988,1,NULL,NULL,NULL,'2025-12-04 13:00:01','2025-12-04 13:00:08','687bf57d693e0fc1f'),('693185d1795dfe7d2','Process Job Queue q1',0,'Success','2025-12-04 13:01:00',1091498,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:01:02','2025-12-04 13:01:02',1357011,1,NULL,NULL,NULL,'2025-12-04 13:00:01','2025-12-04 13:01:02','687bf57d8afb5c472'),('693185d19f5829394','Process Job Queue e0',0,'Success','2025-12-04 13:00:01',1091499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:00:09','2025-12-04 13:00:09',1356988,1,NULL,NULL,NULL,'2025-12-04 13:00:01','2025-12-04 13:00:09','687bf57dbba8299ef'),('693185d2064799f26','Send Email Reminders',0,'Success','2025-12-04 13:02:00',1091500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:03','2025-12-04 13:02:04',1357045,1,NULL,NULL,NULL,'2025-12-04 13:00:02','2025-12-04 13:02:04','687bf5d44d3e10813'),('693185d23ee248a96','Send Email Notifications',0,'Success','2025-12-04 13:02:00',1091501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:04','2025-12-04 13:02:04',1357045,1,NULL,NULL,NULL,'2025-12-04 13:00:02','2025-12-04 13:02:04','687bf5d466067a4ba'),('693185d28b9bd0e83','Auth Token Control',0,'Success','2025-12-04 13:06:00',1091502,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:03','2025-12-04 13:06:04',1357183,1,NULL,NULL,NULL,'2025-12-04 13:00:02','2025-12-04 13:06:04','687bf5d511e08c57f'),('693185d2cb56511dd','Process Webhook Queue',0,'Success','2025-12-04 13:02:00',1091503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:05','2025-12-04 13:02:05',1357045,1,NULL,NULL,NULL,'2025-12-04 13:00:02','2025-12-04 13:02:05','687bf5d5788e2fe0e'),('693185d31cbf1e96a','Send Scheduled Emails',0,'Success','2025-12-04 13:10:00',1091504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:04','2025-12-04 13:10:05',1357397,1,NULL,NULL,NULL,'2025-12-04 13:00:03','2025-12-04 13:10:05','687bf5d5eeb01d80d'),('6931860d70366fc38','Submit Popup Reminders',0,'Success','2025-12-04 13:01:01',1091505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:01:03','2025-12-04 13:01:04',1357011,1,NULL,NULL,NULL,'2025-12-04 13:01:01','2025-12-04 13:01:04','687bf57d2f9463790'),('6931860da1efd14ec','Process Job Queue q0',0,'Success','2025-12-04 13:01:01',1091506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:01:04','2025-12-04 13:01:04',1357011,1,NULL,NULL,NULL,'2025-12-04 13:01:01','2025-12-04 13:01:04','687bf57d693e0fc1f'),('6931860dcacbf38c8','Process Job Queue q1',0,'Success','2025-12-04 13:02:00',1091507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:06','2025-12-04 13:02:06',1357045,1,NULL,NULL,NULL,'2025-12-04 13:01:01','2025-12-04 13:02:06','687bf57d8afb5c472'),('6931860df0f0b375b','Process Job Queue e0',0,'Success','2025-12-04 13:01:01',1091508,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:01:05','2025-12-04 13:01:05',1357011,1,NULL,NULL,NULL,'2025-12-04 13:01:01','2025-12-04 13:01:05','687bf57dbba8299ef'),('69318649b3b43c3f4','Submit Popup Reminders',0,'Success','2025-12-04 13:02:01',1091509,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:07','2025-12-04 13:02:07',1357045,1,NULL,NULL,NULL,'2025-12-04 13:02:01','2025-12-04 13:02:07','687bf57d2f9463790'),('69318649dde2f8b1a','Process Job Queue q0',0,'Success','2025-12-04 13:02:01',1091510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:08','2025-12-04 13:02:08',1357045,1,NULL,NULL,NULL,'2025-12-04 13:02:01','2025-12-04 13:02:08','687bf57d693e0fc1f'),('6931864a0e61d259e','Process Job Queue q1',0,'Success','2025-12-04 13:03:00',1091511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:03:02','2025-12-04 13:03:03',1357072,1,NULL,NULL,NULL,'2025-12-04 13:02:02','2025-12-04 13:03:03','687bf57d8afb5c472'),('6931864a2c06e946e','Process Job Queue e0',0,'Success','2025-12-04 13:02:02',1091512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:02:08','2025-12-04 13:02:09',1357045,1,NULL,NULL,NULL,'2025-12-04 13:02:02','2025-12-04 13:02:09','687bf57dbba8299ef'),('6931864a512e3d6a3','Send Email Reminders',0,'Success','2025-12-04 13:04:00',1091513,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:03','2025-12-04 13:04:03',1357106,1,NULL,NULL,NULL,'2025-12-04 13:02:02','2025-12-04 13:04:03','687bf5d44d3e10813'),('6931864a78533d630','Send Email Notifications',0,'Success','2025-12-04 13:04:00',1091514,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:04','2025-12-04 13:04:04',1357106,1,NULL,NULL,NULL,'2025-12-04 13:02:02','2025-12-04 13:04:04','687bf5d466067a4ba'),('6931864ab9b37bb0a','Process Webhook Queue',0,'Success','2025-12-04 13:04:00',1091515,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:05','2025-12-04 13:04:05',1357106,1,NULL,NULL,NULL,'2025-12-04 13:02:02','2025-12-04 13:04:05','687bf5d5788e2fe0e'),('69318685378468b6b','Submit Popup Reminders',0,'Success','2025-12-04 13:03:01',1091516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:03:03','2025-12-04 13:03:03',1357072,1,NULL,NULL,NULL,'2025-12-04 13:03:01','2025-12-04 13:03:03','687bf57d2f9463790'),('69318685707ff8297','Process Job Queue q0',0,'Success','2025-12-04 13:03:01',1091517,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:03:04','2025-12-04 13:03:04',1357072,1,NULL,NULL,NULL,'2025-12-04 13:03:01','2025-12-04 13:03:04','687bf57d693e0fc1f'),('69318685f1775c6d9','Process Job Queue q1',0,'Success','2025-12-04 13:04:00',1091518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:06','2025-12-04 13:04:06',1357106,1,NULL,NULL,NULL,'2025-12-04 13:03:01','2025-12-04 13:04:06','687bf57d8afb5c472'),('693186866c05f703d','Process Job Queue e0',0,'Success','2025-12-04 13:03:02',1091519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:03:04','2025-12-04 13:03:05',1357072,1,NULL,NULL,NULL,'2025-12-04 13:03:02','2025-12-04 13:03:05','687bf57dbba8299ef'),('693186c1c0814c0e2','Submit Popup Reminders',0,'Success','2025-12-04 13:04:01',1091520,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:07','2025-12-04 13:04:07',1357106,1,NULL,NULL,NULL,'2025-12-04 13:04:01','2025-12-04 13:04:07','687bf57d2f9463790'),('693186c1ea4bab9d9','Process Job Queue q0',0,'Success','2025-12-04 13:04:01',1091521,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:08','2025-12-04 13:04:09',1357106,1,NULL,NULL,NULL,'2025-12-04 13:04:01','2025-12-04 13:04:09','687bf57d693e0fc1f'),('693186c2120963f51','Process Job Queue q1',0,'Success','2025-12-04 13:05:00',1091522,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:05:02','2025-12-04 13:05:02',1357145,1,NULL,NULL,NULL,'2025-12-04 13:04:02','2025-12-04 13:05:02','687bf57d8afb5c472'),('693186c234c04254a','Process Job Queue e0',0,'Success','2025-12-04 13:04:02',1091523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:04:09','2025-12-04 13:04:09',1357106,1,NULL,NULL,NULL,'2025-12-04 13:04:02','2025-12-04 13:04:09','687bf57dbba8299ef'),('693186c25bbc3edc1','Send Email Reminders',0,'Success','2025-12-04 13:06:00',1091524,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:04','2025-12-04 13:06:05',1357183,1,NULL,NULL,NULL,'2025-12-04 13:04:02','2025-12-04 13:06:05','687bf5d44d3e10813'),('693186c278b4b4120','Send Email Notifications',0,'Success','2025-12-04 13:06:00',1091525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:05','2025-12-04 13:06:06',1357183,1,NULL,NULL,NULL,'2025-12-04 13:04:02','2025-12-04 13:06:06','687bf5d466067a4ba'),('693186c3365436d7a','Process Webhook Queue',0,'Success','2025-12-04 13:06:00',1091526,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:06','2025-12-04 13:06:06',1357183,1,NULL,NULL,NULL,'2025-12-04 13:04:03','2025-12-04 13:06:06','687bf5d5788e2fe0e'),('693186fe03a212abe','Submit Popup Reminders',0,'Success','2025-12-04 13:05:02',1091527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:05:03','2025-12-04 13:05:03',1357145,1,NULL,NULL,NULL,'2025-12-04 13:05:02','2025-12-04 13:05:03','687bf57d2f9463790'),('693186fe2e470eff4','Process Job Queue q0',0,'Success','2025-12-04 13:05:02',1091528,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:05:04','2025-12-04 13:05:04',1357145,1,NULL,NULL,NULL,'2025-12-04 13:05:02','2025-12-04 13:05:04','687bf57d693e0fc1f'),('693186fe4ac740901','Process Job Queue q1',0,'Success','2025-12-04 13:06:00',1091529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:07','2025-12-04 13:06:07',1357183,1,NULL,NULL,NULL,'2025-12-04 13:05:02','2025-12-04 13:06:07','687bf57d8afb5c472'),('693186fe6c909ab84','Process Job Queue e0',0,'Success','2025-12-04 13:05:02',1091530,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:05:05','2025-12-04 13:05:05',1357145,1,NULL,NULL,NULL,'2025-12-04 13:05:02','2025-12-04 13:05:05','687bf57dbba8299ef'),('6931873a0b913e11e','Submit Popup Reminders',0,'Success','2025-12-04 13:06:02',1091531,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:08','2025-12-04 13:06:08',1357183,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:06:08','687bf57d2f9463790'),('6931873a3306f248d','Process Job Queue q0',0,'Success','2025-12-04 13:06:02',1091532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:09','2025-12-04 13:06:09',1357183,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:06:09','687bf57d693e0fc1f'),('6931873a5b88de2a2','Process Job Queue q1',0,'Success','2025-12-04 13:07:00',1091533,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:07:03','2025-12-04 13:07:03',1357217,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:07:03','687bf57d8afb5c472'),('6931873a7f53fbaae','Process Job Queue e0',0,'Success','2025-12-04 13:06:02',1091534,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:06:09','2025-12-04 13:06:10',1357183,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:06:10','687bf57dbba8299ef'),('6931873aaa6b4906a','Send Email Reminders',0,'Success','2025-12-04 13:08:00',1091535,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:03','2025-12-04 13:08:03',1357254,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:08:03','687bf5d44d3e10813'),('6931873ac96a80470','Send Email Notifications',0,'Success','2025-12-04 13:08:00',1091536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:04','2025-12-04 13:08:04',1357254,1,NULL,NULL,NULL,'2025-12-04 13:06:02','2025-12-04 13:08:04','687bf5d466067a4ba'),('6931873b128063006','Auth Token Control',0,'Success','2025-12-04 13:12:00',1091537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:03','2025-12-04 13:12:04',1357455,1,NULL,NULL,NULL,'2025-12-04 13:06:03','2025-12-04 13:12:04','687bf5d511e08c57f'),('6931873b529958b3a','Process Webhook Queue',0,'Success','2025-12-04 13:08:00',1091538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:05','2025-12-04 13:08:05',1357254,1,NULL,NULL,NULL,'2025-12-04 13:06:03','2025-12-04 13:08:05','687bf5d5788e2fe0e'),('69318775eec143773','Submit Popup Reminders',0,'Success','2025-12-04 13:07:01',1091539,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:07:04','2025-12-04 13:07:04',1357217,1,NULL,NULL,NULL,'2025-12-04 13:07:01','2025-12-04 13:07:04','687bf57d2f9463790'),('69318776323e4d206','Process Job Queue q0',0,'Success','2025-12-04 13:07:02',1091540,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:07:05','2025-12-04 13:07:05',1357217,1,NULL,NULL,NULL,'2025-12-04 13:07:02','2025-12-04 13:07:05','687bf57d693e0fc1f'),('69318776c8e6e4bae','Process Job Queue q1',0,'Success','2025-12-04 13:08:00',1091541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:06','2025-12-04 13:08:06',1357254,1,NULL,NULL,NULL,'2025-12-04 13:07:02','2025-12-04 13:08:06','687bf57d8afb5c472'),('6931877713fe48e9c','Process Job Queue e0',0,'Success','2025-12-04 13:07:03',1091542,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:07:05','2025-12-04 13:07:05',1357217,1,NULL,NULL,NULL,'2025-12-04 13:07:03','2025-12-04 13:07:05','687bf57dbba8299ef'),('693187b16f395b794','Submit Popup Reminders',0,'Success','2025-12-04 13:08:01',1091543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:07','2025-12-04 13:08:07',1357254,1,NULL,NULL,NULL,'2025-12-04 13:08:01','2025-12-04 13:08:07','687bf57d2f9463790'),('693187b18c2b09c2f','Process Job Queue q0',0,'Success','2025-12-04 13:08:01',1091544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:08','2025-12-04 13:08:08',1357254,1,NULL,NULL,NULL,'2025-12-04 13:08:01','2025-12-04 13:08:08','687bf57d693e0fc1f'),('693187b1b5a3cdb77','Process Job Queue q1',0,'Success','2025-12-04 13:09:00',1091545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:09:02','2025-12-04 13:09:02',1357292,1,NULL,NULL,NULL,'2025-12-04 13:08:01','2025-12-04 13:09:02','687bf57d8afb5c472'),('693187b2644656a7b','Process Job Queue e0',0,'Success','2025-12-04 13:08:02',1091546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:08:08','2025-12-04 13:08:09',1357254,1,NULL,NULL,NULL,'2025-12-04 13:08:02','2025-12-04 13:08:09','687bf57dbba8299ef'),('693187b2b157fbb6e','Send Email Reminders',0,'Success','2025-12-04 13:10:00',1091547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:05','2025-12-04 13:10:05',1357397,1,NULL,NULL,NULL,'2025-12-04 13:08:02','2025-12-04 13:10:05','687bf5d44d3e10813'),('693187b3079f3f91d','Send Email Notifications',0,'Success','2025-12-04 13:10:00',1091548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:06','2025-12-04 13:10:06',1357397,1,NULL,NULL,NULL,'2025-12-04 13:08:03','2025-12-04 13:10:06','687bf5d466067a4ba'),('693187b33bf34d5e1','Process Webhook Queue',0,'Success','2025-12-04 13:10:00',1091549,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:06','2025-12-04 13:10:07',1357397,1,NULL,NULL,NULL,'2025-12-04 13:08:03','2025-12-04 13:10:07','687bf5d5788e2fe0e'),('693187ed7855d4b9b','Submit Popup Reminders',0,'Success','2025-12-04 13:09:01',1091550,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:09:03','2025-12-04 13:09:04',1357292,1,NULL,NULL,NULL,'2025-12-04 13:09:01','2025-12-04 13:09:04','687bf57d2f9463790'),('693187edada745823','Process Job Queue q0',0,'Success','2025-12-04 13:09:01',1091551,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:09:04','2025-12-04 13:09:04',1357292,1,NULL,NULL,NULL,'2025-12-04 13:09:01','2025-12-04 13:09:04','687bf57d693e0fc1f'),('693187edce61618fa','Process Job Queue q1',0,'Success','2025-12-04 13:10:00',1091552,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:07','2025-12-04 13:10:07',1357397,1,NULL,NULL,NULL,'2025-12-04 13:09:01','2025-12-04 13:10:07','687bf57d8afb5c472'),('693187edebc7f9672','Process Job Queue e0',0,'Success','2025-12-04 13:09:01',1091553,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:09:05','2025-12-04 13:09:05',1357292,1,NULL,NULL,NULL,'2025-12-04 13:09:01','2025-12-04 13:09:05','687bf57dbba8299ef'),('6931882938e8772ff','Submit Popup Reminders',0,'Success','2025-12-04 13:10:01',1091554,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:08','2025-12-04 13:10:08',1357397,1,NULL,NULL,NULL,'2025-12-04 13:10:01','2025-12-04 13:10:08','687bf57d2f9463790'),('69318829717b603bf','Process Job Queue q0',0,'Success','2025-12-04 13:10:01',1091555,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:09','2025-12-04 13:10:09',1357397,1,NULL,NULL,NULL,'2025-12-04 13:10:01','2025-12-04 13:10:09','687bf57d693e0fc1f'),('693188299a30980e6','Process Job Queue q1',0,'Success','2025-12-04 13:11:00',1091556,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:11:02','2025-12-04 13:11:02',1357422,1,NULL,NULL,NULL,'2025-12-04 13:10:01','2025-12-04 13:11:02','687bf57d8afb5c472'),('69318829d05ff8a08','Process Job Queue e0',0,'Success','2025-12-04 13:10:01',1091557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:10:10','2025-12-04 13:10:10',1357397,1,NULL,NULL,NULL,'2025-12-04 13:10:01','2025-12-04 13:10:10','687bf57dbba8299ef'),('6931882a09c1b56f6','Send Email Reminders',0,'Success','2025-12-04 13:12:00',1091558,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:04','2025-12-04 13:12:05',1357455,1,NULL,NULL,NULL,'2025-12-04 13:10:02','2025-12-04 13:12:05','687bf5d44d3e10813'),('6931882a3b044f74a','Send Email Notifications',0,'Success','2025-12-04 13:12:00',1091559,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:05','2025-12-04 13:12:05',1357455,1,NULL,NULL,NULL,'2025-12-04 13:10:02','2025-12-04 13:12:05','687bf5d466067a4ba'),('6931882a913c5789b','Send Mass Emails',0,'Success','2025-12-04 13:30:00',1091560,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:30:04','2025-12-04 13:30:04',1358107,1,NULL,NULL,NULL,'2025-12-04 13:10:02','2025-12-04 13:30:04','687bf5d4b535f913f'),('6931882ac9d264e2d','Process Webhook Queue',0,'Success','2025-12-04 13:12:00',1091561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:06','2025-12-04 13:12:06',1357455,1,NULL,NULL,NULL,'2025-12-04 13:10:02','2025-12-04 13:12:06','687bf5d5788e2fe0e'),('6931882b700d042d3','Send Scheduled Emails',0,'Success','2025-12-04 13:20:00',1091562,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:03','2025-12-04 13:20:03',1357734,1,NULL,NULL,NULL,'2025-12-04 13:10:03','2025-12-04 13:20:03','687bf5d5eeb01d80d'),('6931886593274af07','Submit Popup Reminders',0,'Success','2025-12-04 13:11:01',1091563,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:11:03','2025-12-04 13:11:04',1357422,1,NULL,NULL,NULL,'2025-12-04 13:11:01','2025-12-04 13:11:04','687bf57d2f9463790'),('69318865bf50538da','Process Job Queue q0',0,'Success','2025-12-04 13:11:01',1091564,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:11:04','2025-12-04 13:11:04',1357422,1,NULL,NULL,NULL,'2025-12-04 13:11:01','2025-12-04 13:11:04','687bf57d693e0fc1f'),('69318865e40e909ca','Process Job Queue q1',0,'Success','2025-12-04 13:12:00',1091565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:06','2025-12-04 13:12:07',1357455,1,NULL,NULL,NULL,'2025-12-04 13:11:01','2025-12-04 13:12:07','687bf57d8afb5c472'),('693188660b781f1f9','Process Job Queue e0',0,'Success','2025-12-04 13:11:02',1091566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:11:05','2025-12-04 13:11:05',1357422,1,NULL,NULL,NULL,'2025-12-04 13:11:02','2025-12-04 13:11:05','687bf57dbba8299ef'),('693188a16137e758d','Submit Popup Reminders',0,'Success','2025-12-04 13:12:01',1091567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:07','2025-12-04 13:12:07',1357455,1,NULL,NULL,NULL,'2025-12-04 13:12:01','2025-12-04 13:12:07','687bf57d2f9463790'),('693188a1898819256','Process Job Queue q0',0,'Success','2025-12-04 13:12:01',1091568,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:08','2025-12-04 13:12:08',1357455,1,NULL,NULL,NULL,'2025-12-04 13:12:01','2025-12-04 13:12:08','687bf57d693e0fc1f'),('693188a1ac5a230a5','Process Job Queue q1',0,'Success','2025-12-04 13:13:00',1091569,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:13:02','2025-12-04 13:13:02',1357495,1,NULL,NULL,NULL,'2025-12-04 13:12:01','2025-12-04 13:13:02','687bf57d8afb5c472'),('693188a1d421865d5','Process Job Queue e0',0,'Success','2025-12-04 13:12:01',1091570,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:12:09','2025-12-04 13:12:09',1357455,1,NULL,NULL,NULL,'2025-12-04 13:12:01','2025-12-04 13:12:09','687bf57dbba8299ef'),('693188a28f7fbfac9','Send Email Reminders',0,'Success','2025-12-04 13:14:00',1091571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:03','2025-12-04 13:14:03',1357512,1,NULL,NULL,NULL,'2025-12-04 13:12:02','2025-12-04 13:14:03','687bf5d44d3e10813'),('693188a2e7832d676','Send Email Notifications',0,'Success','2025-12-04 13:14:00',1091572,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:04','2025-12-04 13:14:04',1357512,1,NULL,NULL,NULL,'2025-12-04 13:12:02','2025-12-04 13:14:04','687bf5d466067a4ba'),('693188a34167657ed','Auth Token Control',0,'Success','2025-12-04 13:18:00',1091573,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:03','2025-12-04 13:18:03',1357654,1,NULL,NULL,NULL,'2025-12-04 13:12:03','2025-12-04 13:18:03','687bf5d511e08c57f'),('693188a3959d2d923','Process Webhook Queue',0,'Success','2025-12-04 13:14:00',1091574,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:05','2025-12-04 13:14:05',1357512,1,NULL,NULL,NULL,'2025-12-04 13:12:03','2025-12-04 13:14:05','687bf5d5788e2fe0e'),('693188dd9b65b681c','Submit Popup Reminders',0,'Success','2025-12-04 13:13:01',1091575,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:13:03','2025-12-04 13:13:04',1357495,1,NULL,NULL,NULL,'2025-12-04 13:13:01','2025-12-04 13:13:04','687bf57d2f9463790'),('693188ddc46eaad16','Process Job Queue q0',0,'Success','2025-12-04 13:13:01',1091576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:13:04','2025-12-04 13:13:05',1357495,1,NULL,NULL,NULL,'2025-12-04 13:13:01','2025-12-04 13:13:05','687bf57d693e0fc1f'),('693188ddec7c11c16','Process Job Queue q1',0,'Success','2025-12-04 13:14:00',1091577,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:05','2025-12-04 13:14:06',1357512,1,NULL,NULL,NULL,'2025-12-04 13:13:01','2025-12-04 13:14:06','687bf57d8afb5c472'),('693188de1f4373168','Process Job Queue e0',0,'Success','2025-12-04 13:13:02',1091578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:13:05','2025-12-04 13:13:05',1357495,1,NULL,NULL,NULL,'2025-12-04 13:13:02','2025-12-04 13:13:05','687bf57dbba8299ef'),('693189194b5f47cb5','Submit Popup Reminders',0,'Success','2025-12-04 13:14:01',1091579,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:06','2025-12-04 13:14:06',1357512,1,NULL,NULL,NULL,'2025-12-04 13:14:01','2025-12-04 13:14:06','687bf57d2f9463790'),('693189198e2d5fec8','Process Job Queue q0',0,'Success','2025-12-04 13:14:01',1091580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:07','2025-12-04 13:14:07',1357512,1,NULL,NULL,NULL,'2025-12-04 13:14:01','2025-12-04 13:14:07','687bf57d693e0fc1f'),('6931891a2b7598b18','Process Job Queue q1',0,'Success','2025-12-04 13:15:00',1091581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:15:02','2025-12-04 13:15:02',1357543,1,NULL,NULL,NULL,'2025-12-04 13:14:02','2025-12-04 13:15:02','687bf57d8afb5c472'),('6931891a6ee944629','Process Job Queue e0',0,'Success','2025-12-04 13:14:02',1091582,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:14:07','2025-12-04 13:14:08',1357512,1,NULL,NULL,NULL,'2025-12-04 13:14:02','2025-12-04 13:14:08','687bf57dbba8299ef'),('6931891aaf14cfc9c','Send Email Reminders',0,'Success','2025-12-04 13:16:00',1091583,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:04','2025-12-04 13:16:04',1357583,1,NULL,NULL,NULL,'2025-12-04 13:14:02','2025-12-04 13:16:04','687bf5d44d3e10813'),('6931891b0427b464d','Send Email Notifications',0,'Success','2025-12-04 13:16:00',1091584,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:05','2025-12-04 13:16:05',1357583,1,NULL,NULL,NULL,'2025-12-04 13:14:03','2025-12-04 13:16:05','687bf5d466067a4ba'),('6931891b5388ba057','Process Webhook Queue',0,'Success','2025-12-04 13:16:00',1091585,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:06','2025-12-04 13:16:06',1357583,1,NULL,NULL,NULL,'2025-12-04 13:14:03','2025-12-04 13:16:06','687bf5d5788e2fe0e'),('6931895585bcc5133','Submit Popup Reminders',0,'Success','2025-12-04 13:15:01',1091586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:15:03','2025-12-04 13:15:04',1357543,1,NULL,NULL,NULL,'2025-12-04 13:15:01','2025-12-04 13:15:04','687bf57d2f9463790'),('69318955ad3afcc08','Process Job Queue q0',0,'Success','2025-12-04 13:15:01',1091587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:15:04','2025-12-04 13:15:05',1357543,1,NULL,NULL,NULL,'2025-12-04 13:15:01','2025-12-04 13:15:05','687bf57d693e0fc1f'),('69318955da25e3da2','Process Job Queue q1',0,'Success','2025-12-04 13:16:00',1091588,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:07','2025-12-04 13:16:07',1357583,1,NULL,NULL,NULL,'2025-12-04 13:15:01','2025-12-04 13:16:07','687bf57d8afb5c472'),('693189560efa00fcd','Process Job Queue e0',0,'Success','2025-12-04 13:15:02',1091589,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:15:05','2025-12-04 13:15:05',1357543,1,NULL,NULL,NULL,'2025-12-04 13:15:02','2025-12-04 13:15:05','687bf57dbba8299ef'),('693189922519d6f21','Submit Popup Reminders',0,'Success','2025-12-04 13:16:02',1091590,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:07','2025-12-04 13:16:08',1357583,1,NULL,NULL,NULL,'2025-12-04 13:16:02','2025-12-04 13:16:08','687bf57d2f9463790'),('693189925919e720f','Process Job Queue q0',0,'Success','2025-12-04 13:16:02',1091591,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:08','2025-12-04 13:16:09',1357583,1,NULL,NULL,NULL,'2025-12-04 13:16:02','2025-12-04 13:16:09','687bf57d693e0fc1f'),('693189927791616a2','Process Job Queue q1',0,'Success','2025-12-04 13:17:00',1091592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:17:02','2025-12-04 13:17:03',1357621,1,NULL,NULL,NULL,'2025-12-04 13:16:02','2025-12-04 13:17:03','687bf57d8afb5c472'),('693189929965f9168','Process Job Queue e0',0,'Success','2025-12-04 13:16:02',1091593,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:16:09','2025-12-04 13:16:09',1357583,1,NULL,NULL,NULL,'2025-12-04 13:16:02','2025-12-04 13:16:09','687bf57dbba8299ef'),('69318992c734db9cc','Send Email Reminders',0,'Success','2025-12-04 13:18:00',1091594,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:04','2025-12-04 13:18:04',1357654,1,NULL,NULL,NULL,'2025-12-04 13:16:02','2025-12-04 13:18:04','687bf5d44d3e10813'),('69318993166dab7a3','Send Email Notifications',0,'Success','2025-12-04 13:18:00',1091595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:05','2025-12-04 13:18:05',1357654,1,NULL,NULL,NULL,'2025-12-04 13:16:03','2025-12-04 13:18:05','687bf5d466067a4ba'),('69318993dbb4aa827','Process Webhook Queue',0,'Success','2025-12-04 13:18:00',1091596,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:05','2025-12-04 13:18:06',1357654,1,NULL,NULL,NULL,'2025-12-04 13:16:03','2025-12-04 13:18:06','687bf5d5788e2fe0e'),('693189cdee953dc20','Submit Popup Reminders',0,'Success','2025-12-04 13:17:01',1091597,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:17:04','2025-12-04 13:17:04',1357621,1,NULL,NULL,NULL,'2025-12-04 13:17:01','2025-12-04 13:17:04','687bf57d2f9463790'),('693189ce49da98093','Process Job Queue q0',0,'Success','2025-12-04 13:17:02',1091598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:17:05','2025-12-04 13:17:05',1357621,1,NULL,NULL,NULL,'2025-12-04 13:17:02','2025-12-04 13:17:05','687bf57d693e0fc1f'),('693189ce76515b4c0','Process Job Queue q1',0,'Success','2025-12-04 13:18:00',1091599,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:06','2025-12-04 13:18:06',1357654,1,NULL,NULL,NULL,'2025-12-04 13:17:02','2025-12-04 13:18:06','687bf57d8afb5c472'),('693189cea040a0604','Process Job Queue e0',0,'Success','2025-12-04 13:17:02',1091600,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:17:06','2025-12-04 13:17:07',1357621,1,NULL,NULL,NULL,'2025-12-04 13:17:02','2025-12-04 13:17:07','687bf57dbba8299ef'),('69318a09239790f66','Submit Popup Reminders',0,'Success','2025-12-04 13:18:01',1091601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:07','2025-12-04 13:18:07',1357654,1,NULL,NULL,NULL,'2025-12-04 13:18:01','2025-12-04 13:18:07','687bf57d2f9463790'),('69318a09515adde40','Process Job Queue q0',0,'Success','2025-12-04 13:18:01',1091602,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:08','2025-12-04 13:18:08',1357654,1,NULL,NULL,NULL,'2025-12-04 13:18:01','2025-12-04 13:18:08','687bf57d693e0fc1f'),('69318a096d2bd0047','Process Job Queue q1',0,'Success','2025-12-04 13:19:00',1091603,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:19:02','2025-12-04 13:19:02',1357696,1,NULL,NULL,NULL,'2025-12-04 13:18:01','2025-12-04 13:19:02','687bf57d8afb5c472'),('69318a0a30b2a28b2','Process Job Queue e0',0,'Success','2025-12-04 13:18:02',1091604,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:18:08','2025-12-04 13:18:09',1357654,1,NULL,NULL,NULL,'2025-12-04 13:18:02','2025-12-04 13:18:09','687bf57dbba8299ef'),('69318a0a7679831fd','Send Email Reminders',0,'Success','2025-12-04 13:20:00',1091605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:04','2025-12-04 13:20:04',1357734,1,NULL,NULL,NULL,'2025-12-04 13:18:02','2025-12-04 13:20:04','687bf5d44d3e10813'),('69318a0ab0da8a3a4','Send Email Notifications',0,'Success','2025-12-04 13:20:00',1091606,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:05','2025-12-04 13:20:05',1357734,1,NULL,NULL,NULL,'2025-12-04 13:18:02','2025-12-04 13:20:05','687bf5d466067a4ba'),('69318a0aea2dfcd2d','Auth Token Control',0,'Success','2025-12-04 13:24:00',1091607,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:24:03','2025-12-04 13:24:03',1357889,1,NULL,NULL,NULL,'2025-12-04 13:18:02','2025-12-04 13:24:03','687bf5d511e08c57f'),('69318a0b2df1691af','Process Webhook Queue',0,'Success','2025-12-04 13:20:00',1091608,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:06','2025-12-04 13:20:06',1357734,1,NULL,NULL,NULL,'2025-12-04 13:18:03','2025-12-04 13:20:06','687bf5d5788e2fe0e'),('69318a45662c19c2b','Submit Popup Reminders',0,'Success','2025-12-04 13:19:01',1091609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:19:03','2025-12-04 13:19:04',1357696,1,NULL,NULL,NULL,'2025-12-04 13:19:01','2025-12-04 13:19:04','687bf57d2f9463790'),('69318a4591a2106d8','Process Job Queue q0',0,'Success','2025-12-04 13:19:01',1091610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:19:04','2025-12-04 13:19:04',1357696,1,NULL,NULL,NULL,'2025-12-04 13:19:01','2025-12-04 13:19:04','687bf57d693e0fc1f'),('69318a45b48f7d35a','Process Job Queue q1',0,'Success','2025-12-04 13:20:00',1091611,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:06','2025-12-04 13:20:06',1357734,1,NULL,NULL,NULL,'2025-12-04 13:19:01','2025-12-04 13:20:06','687bf57d8afb5c472'),('69318a45e4bfa74bd','Process Job Queue e0',0,'Success','2025-12-04 13:19:01',1091612,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:19:05','2025-12-04 13:19:05',1357696,1,NULL,NULL,NULL,'2025-12-04 13:19:01','2025-12-04 13:19:05','687bf57dbba8299ef'),('69318a8125860252b','Submit Popup Reminders',0,'Success','2025-12-04 13:20:01',1091613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:07','2025-12-04 13:20:07',1357734,1,NULL,NULL,NULL,'2025-12-04 13:20:01','2025-12-04 13:20:07','687bf57d2f9463790'),('69318a814674c1957','Process Job Queue q0',0,'Success','2025-12-04 13:20:01',1091614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:07','2025-12-04 13:20:08',1357734,1,NULL,NULL,NULL,'2025-12-04 13:20:01','2025-12-04 13:20:08','687bf57d693e0fc1f'),('69318a816a5ac667c','Process Job Queue q1',0,'Success','2025-12-04 13:21:00',1091615,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:21:02','2025-12-04 13:21:02',1357771,1,NULL,NULL,NULL,'2025-12-04 13:20:01','2025-12-04 13:21:02','687bf57d8afb5c472'),('69318a81c4387981d','Process Job Queue e0',0,'Success','2025-12-04 13:20:01',1091616,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:20:08','2025-12-04 13:20:09',1357734,1,NULL,NULL,NULL,'2025-12-04 13:20:01','2025-12-04 13:20:09','687bf57dbba8299ef'),('69318a8206ed527a4','Send Email Reminders',0,'Success','2025-12-04 13:22:00',1091617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:03','2025-12-04 13:22:03',1357807,1,NULL,NULL,NULL,'2025-12-04 13:20:02','2025-12-04 13:22:03','687bf5d44d3e10813'),('69318a8245767d75f','Send Email Notifications',0,'Success','2025-12-04 13:22:00',1091618,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:04','2025-12-04 13:22:04',1357807,1,NULL,NULL,NULL,'2025-12-04 13:20:02','2025-12-04 13:22:04','687bf5d466067a4ba'),('69318a82823406b62','Process Webhook Queue',0,'Success','2025-12-04 13:22:00',1091619,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:05','2025-12-04 13:22:05',1357807,1,NULL,NULL,NULL,'2025-12-04 13:20:02','2025-12-04 13:22:05','687bf5d5788e2fe0e'),('69318a82b039c45f3','Send Scheduled Emails',0,'Success','2025-12-04 13:30:00',1091620,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:30:05','2025-12-04 13:30:05',1358107,1,NULL,NULL,NULL,'2025-12-04 13:20:02','2025-12-04 13:30:05','687bf5d5eeb01d80d'),('69318abd91dcf4145','Submit Popup Reminders',0,'Success','2025-12-04 13:21:01',1091621,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:21:03','2025-12-04 13:21:04',1357771,1,NULL,NULL,NULL,'2025-12-04 13:21:01','2025-12-04 13:21:04','687bf57d2f9463790'),('69318abdc62c8e5f7','Process Job Queue q0',0,'Success','2025-12-04 13:21:01',1091622,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:21:04','2025-12-04 13:21:05',1357771,1,NULL,NULL,NULL,'2025-12-04 13:21:01','2025-12-04 13:21:05','687bf57d693e0fc1f'),('69318abde51268bee','Process Job Queue q1',0,'Success','2025-12-04 13:22:00',1091623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:05','2025-12-04 13:22:05',1357807,1,NULL,NULL,NULL,'2025-12-04 13:21:01','2025-12-04 13:22:05','687bf57d8afb5c472'),('69318abe3b1a997eb','Process Job Queue e0',0,'Success','2025-12-04 13:21:02',1091624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:21:05','2025-12-04 13:21:05',1357771,1,NULL,NULL,NULL,'2025-12-04 13:21:02','2025-12-04 13:21:05','687bf57dbba8299ef'),('69318af998008584b','Submit Popup Reminders',0,'Success','2025-12-04 13:22:01',1091625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:06','2025-12-04 13:22:07',1357807,1,NULL,NULL,NULL,'2025-12-04 13:22:01','2025-12-04 13:22:07','687bf57d2f9463790'),('69318af9c2a697ca2','Process Job Queue q0',0,'Success','2025-12-04 13:22:01',1091626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:07','2025-12-04 13:22:07',1357807,1,NULL,NULL,NULL,'2025-12-04 13:22:01','2025-12-04 13:22:07','687bf57d693e0fc1f'),('69318afa1062978c9','Process Job Queue q1',0,'Success','2025-12-04 13:23:00',1091627,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:23:02','2025-12-04 13:23:02',1357850,1,NULL,NULL,NULL,'2025-12-04 13:22:02','2025-12-04 13:23:02','687bf57d8afb5c472'),('69318afa3a657f854','Process Job Queue e0',0,'Success','2025-12-04 13:22:02',1091628,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:22:08','2025-12-04 13:22:08',1357807,1,NULL,NULL,NULL,'2025-12-04 13:22:02','2025-12-04 13:22:08','687bf57dbba8299ef'),('69318afab026741f9','Send Email Reminders',0,'Success','2025-12-04 13:24:00',1091629,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:24:04','2025-12-04 13:24:04',1357889,1,NULL,NULL,NULL,'2025-12-04 13:22:02','2025-12-04 13:24:04','687bf5d44d3e10813'),('69318afae75a57d4a','Send Email Notifications',0,'Success','2025-12-04 13:24:00',1091630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:24:05','2025-12-04 13:24:05',1357889,1,NULL,NULL,NULL,'2025-12-04 13:22:02','2025-12-04 13:24:05','687bf5d466067a4ba'),('69318afb37b4fd28d','Process Webhook Queue',0,'Success','2025-12-04 13:24:00',1091631,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:24:06','2025-12-04 13:24:06',1357889,1,NULL,NULL,NULL,'2025-12-04 13:22:03','2025-12-04 13:24:06','687bf5d5788e2fe0e'),('69318b35565976d3c','Submit Popup Reminders',0,'Success','2025-12-04 13:23:01',1091632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:23:03','2025-12-04 13:23:03',1357850,1,NULL,NULL,NULL,'2025-12-04 13:23:01','2025-12-04 13:23:03','687bf57d2f9463790'),('69318b357c00e2f42','Process Job Queue q0',0,'Success','2025-12-04 13:23:01',1091633,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:23:04','2025-12-04 13:23:05',1357850,1,NULL,NULL,NULL,'2025-12-04 13:23:01','2025-12-04 13:23:05','687bf57d693e0fc1f'),('69318b35a7012b054','Process Job Queue q1',0,'Success','2025-12-04 13:24:00',1091634,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:24:07','2025-12-04 13:24:07',1357889,1,NULL,NULL,NULL,'2025-12-04 13:23:01','2025-12-04 13:24:07','687bf57d8afb5c472'),('69318b35ccc846520','Process Job Queue e0',0,'Success','2025-12-04 13:23:01',1091635,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-04 13:23:05','2025-12-04 13:23:05',1357850,1,NULL,NULL,NULL,'2025-12-04 13:23:01','2025-12-04 13:23:05','687bf57dbba8299ef'),('69318b7197262a8ca',