<?php
namespace Espo\Custom\Hooks\Note;

use Espo\Core\Exceptions\Error;
use Espo\Core\Exceptions\BadRequest;

use Espo\Entities\Note;

use Espo\Core\Container;
use Espo\Core\Mail\Message;
use Espo\Core\Utils\Json;

use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

use Espo\Core\Mail\EmailSender;
use Espo\Core\Mail\EmailFactory;
use Espo\Core\Mail\SmtpParams;
use Espo\Tools\Email\SendService;

class EmailMentionedUser
{
    public function __construct(
        private EmailSender $emailSender,
        private EmailFactory $emailFactory,
        Container $container,
        private EntityManager $entityManager
    ){}

    public function afterSave(Note $entity, array $options = [])
    {

        $log = $GLOBALS['log'];
        $listaDeUserIds = [];
        
        $data_obj = $entity->getData();
        $log->info(Json::encode($data_obj));

        if(property_exists($data_obj, 'mentions'))
        {
            $mentions = (object) [
                "data" => $data_obj->mentions,
            ];

            $decodedJson = json_decode(Json::encode($mentions), true);
            if (json_last_error() === JSON_ERROR_NONE && isset($decodedJson['data']) && is_array($decodedJson['data'])) {
                
                $mentionsData = $decodedJson['data'];
                $stream = $entity->getPost();

                $actionId = $entity->getParentId();
                $action = $this->entityManager->getEntity('Campaign', $actionId);
                $actionName = $action->getName();

                foreach ($mentionsData as $usernameKey => $userInfoArray) {
                    
                    if (is_array($userInfoArray) && isset($userInfoArray['id'])) {                        
                        $listaDeUserIds[] = $userInfoArray['id'];
                    }
                }
                foreach($listaDeUserIds as $userId){

                    $userTo = $this->entityManager->getEntity('User', $userId);            
                    $emailAddress = $userTo->get('emailAddress');

                    if($emailAddress != null){
                        $userFromId = $entity->getCreatedById();
                        $userFrom = $this->entityManager->getEntity('User', $userFromId);
                        $userName = $userFrom->getUserName();

                        $log->info("To: ".$emailAddress." From: " .$userName ."Assunto: ". $stream. "Ação: ". $actionName);
                        $this->sendEmail($userName, $emailAddress, $stream, $actionName);

                    }else{
                        $log->info("Sem email");
                        throw new \Espo\Core\Exceptions\BadRequest("Usuário sem e-mail cadastrado.");
                    }
                }
            } else {
                $log->info("Mentions null");                
            }
        }else{
            $log->info("Data obj null");
        }
    }

    public function sendEmail($userFrom, $emailTo, $message, $actionName): void
    {
        $email = $this->emailFactory->create();        
        $email->setSubject("Você foi mencionado na ação: ". $actionName);
        //$email->setBody("Na ação " .$actionName." teve uma atualização. O usuário " .$userFrom." escreveu: " .$message);
        $email->setBody("Mensagem de " .$userFrom.": " .$message);
        $email->addToAddress($emailTo);
        $email->setIsPlain(); // Html is by default
        $this->emailSender->send($email);
    }
}