// client/custom/src/views/contact/list.js

Espo.define('Espo.Custom.Views.Contact.List', 'views.record.list', function (Dep) {

    return Dep.extend({
        
        // Define os eventos de clique.
        // O seletor [data-action="create"] é o mais confiável para o botão "Criar Contato"
        events: {
            ...Dep.prototype.events,
            'click [data-action="create"]': 'createRecordWithDefaults',
        },

        // Este é o nosso método customizado.
        createRecordWithDefaults: function () {
            // Define os atributos que você quer pré-preencher
            const prefilledAttributes = {
                emailAddress: 'exemplo@dominio.com',
            };

            // Chama o método 'createRecordView' do EspoCRM, passando os atributos.
            // Este método irá abrir o modal de criação e preencher os campos.
            this.createRecordView(prefilledAttributes);
        },
    });
});