<?php
namespace Espo\Custom\Hooks\Campaign;

use Espo\Core\ORM\Repository\Option\SaveOption;
use Espo\Core\Utils\SystemUser;
use Espo\ORM\EntityManager;
use Espo\Tools\Email\SendService;

use Espo\ORM\Entity;
use Espo\Core\Mail\EmailSender;
use Espo\Core\Mail\EmailFactory;
use Espo\Core\Mail\SmtpParams;
use Espo\Core\Utils\Config;

class SendEmail
{
    public function __construct(
        private EmailSender $emailSender,
        private EmailFactory $emailFactory,
        private Config $config,
        private EntityManager $entityManager
    ){}

    public function afterSave(Entity $entity, array $options): void
    {
        
        $log = $GLOBALS['log'];
        $log->info("afterSave - sendEmail");

        if($entity->isAttributeChanged('status'))
        {
            $log->info("Mudou de status.");
            $assignedUserId = $entity->get('assignedUserId');

            if($assignedUserId){
                $user = $this->entityManager->getEntity('User', $assignedUserId);
                if ($user) {
                    //TODO: Validar se tem email
                    $userEmail = $user->get('emailAddress');
                    
                    $log->info('Email do usuario: '. $userEmail);
                    $this->sendEmail($userEmail);
                }
            }else{
                $log->info('Campanha sem usuario designado.');
            }

        }
        //$this->sendEmail();

    }
    public function sendEmail($emailTo): void
    {
        $email = $this->emailFactory->create();        
        $email->setSubject('Atualização na ação XXX');
        $email->setBody('Teve uma atualização X na ação XXX. O status foi atualizado para ZZZ.');
        $email->addToAddress($emailTo);
        $email->setIsPlain(); // Html is by default
        $this->emailSender->send($email);
    }
}