define('custom:views/campaign/record/detail', ['views/record/detail','collection-factory'], function (Dep, CollectionFactory) {

    return Dep.extend({

        contasCorrentesCollection: null,

        setup: function () {
            // ... (código 'setup' permanece o mesmo)
            Dep.prototype.setup.call(this);

            this.addButton({
                name: 'alocarInvestimento',
                label: 'Alocar Investimentos',
                style: 'default',
                title: 'Clique para executar ação',
                action: 'alocarInvestimento'
            });
        },

        // MÉTODO: Carrega a Coleção de Contas Correntes
        loadContasCorrentes: async function (redeId) {
            
            const entidadeContaCorrente = 'CSoftContaCorrente'; 
            const nomeDoCampoLinkNaCC = 'account1Id';
            const gerenteMarketingId = '68dbfdc48863525c1';
            
            if (!this.contasCorrentesCollection) {
                //this.contasCorrentesCollection = this.getCollectionFactory().create(entidadeContaCorrente);
                this.contasCorrentesCollection = await this.getCollectionFactory().create(entidadeContaCorrente);
            }

            if (typeof this.contasCorrentesCollection.fetch !== 'function') {
                 throw new Error("A Coleção não possui o método fetch.");
            }

            const options = {
                where: [
                    {
                        type: 'equals',
                        field: nomeDoCampoLinkNaCC,   // ajuste se o nome real for outro
                        value: [redeId, gerenteMarketingId]
                    }
                ],
                select: ['id', 'name', 'saldo']
            };

            const promise = await this.contasCorrentesCollection.fetch(options);
            
            return promise;
        },

        // Método executado ao clicar no botão
        actionAlocarInvestimento: function () {
            
            const fetchAndCreateView = async () => {
                
                const redeId = this.model.get('cCRedeAcaoId');
                
                if (!redeId) {
                    Espo.Ui.error('Nenhuma Rede associada a esta Ação. Por favor, vincule uma Rede para continuar.');
                    return;
                }

                try{
                    // 1. Carrega as Contas Correntes e espera
                    await this.loadContasCorrentes(redeId); 
                    
                    if (!this.contasCorrentesCollection || this.contasCorrentesCollection.length === 0) {
                        Espo.Ui.error('Nenhuma Conta Corrente foi encontrada para a Rede vinculada.');
                        // Não retorna, permitindo que o modal abra, mas com a lista vazia.
                    }
                    
                    // 2. **MUDANÇA AQUI:** Mapeia a coleção, extraindo nome e saldo.
                    const contasCorrentesData = this.contasCorrentesCollection.models.map(model => ({
                        id: model.id,
                        nome: model.get('name'),
                        saldo: model.get('saldo'),
                        tipoConta: model.get('cSoftTipoCC')
                    }));

                    // 3. Cria e renderiza o Modal, passando os dados
                    this.createView('dialog', 'custom:views/campaign/modals/alocar-investimentos', {
                        //id: this.model.id,
                        id: this.model.attributes.id,
                        title: this.model.get('name'),
                        saldoAcao: this.model.get('budget'), // Renomeei para evitar confusão com saldo da conta corrente
                        model: this.model,
                        // PASSANDO A LISTA DE CONTAS CORRENTES COM SALDOS
                        contasCorrentes: contasCorrentesData
                        
                    }, view => {
                        
                        view.render();

                        this.listenToOnce(view, 'done', response => {
                            
                            this.model.fetch().then(() => {

                                Espo.Ui.notify('Atualizando dados...', 'loading');

                                const helper = this.getHelper();
                                const layoutManager = helper && helper.layoutManager;

                                if (layoutManager && typeof layoutManager.loadPanels === 'function') {
                                    // ✅ Usa o gerenciador global do layout
                                    layoutManager.loadPanels();
                                    Espo.Ui.success('Painéis recarregados com sucesso.');
                                } else {
                                    // ✅ Último fallback — força re-render da tela atual
                                    console.warn('Record.DetailView e LayoutManager não disponíveis — recarregando o registro.');
                                    const router = this.getRouter ? this.getRouter() : null;
                                    if (router) {
                                        router.navigate('#Campaign/view/' + this.model.id, { trigger: true });
                                    } else {
                                        this.reRender();
                                    }
                                }

                                Espo.Ui.notify(false);

                            });
                        })
                    });
                }catch(error){
                    console.error('Erro ao carregar ou exibir o modal:', error);
                    Espo.Ui.error('Falha ao carregar dados das contas correntes. Verifique a conexão ou logs do servidor.');
                }
            };

            fetchAndCreateView();
        }
    });
});