<?php
namespace Espo\Custom\Hooks\Note;

use Espo\Core\Exceptions\Error;
use Espo\Core\Exceptions\BadRequest;

use Espo\Entities\Note;

use Espo\Core\Container;
use Espo\Core\Mail\Message;
use Espo\Core\Utils\Json;

use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

use Espo\Core\Mail\EmailSender;
use Espo\Core\Mail\EmailFactory;
use Espo\Core\Mail\SmtpParams;
use Espo\Tools\Email\SendService;

use Espo\Core\Job\JobSchedulerFactory;
use Espo\Core\Job\QueueName;

use Espo\Core\Utils\Config;

class EmailMentionedUser
{
    public function __construct(
        private EmailSender $emailSender,
        private EmailFactory $emailFactory,
        Container $container,
        private Config        $config,
        private EntityManager $entityManager,
        JobSchedulerFactory $jobSchedulerFactory
    ){
        $this->jobSchedulerFactory = $jobSchedulerFactory;
    }

    public function afterSave(Note $entity, array $options = [])
    {

        $log = $GLOBALS['log'];
        $log->info("afterSave - EmailMentionedUser");
        
        $listaDeUserIds = [];
        
        $data_obj = $entity->getData();
        $log->info(Json::encode($data_obj));

        if(property_exists($data_obj, 'mentions'))
        {
            $mentions = (object) [
                "data" => $data_obj->mentions,
            ];

            $decodedJson = json_decode(Json::encode($mentions), true);
            if (json_last_error() === JSON_ERROR_NONE && isset($decodedJson['data']) && is_array($decodedJson['data'])) {
                
                $mentionsData = $decodedJson['data'];
                $stream = $entity->getPost();

                $actionId = $entity->getParentId();
                $action = $this->entityManager->getEntity('Campaign', $actionId);
                $actionName = $action->getName();

                foreach ($mentionsData as $usernameKey => $userInfoArray) {
                    
                    if (is_array($userInfoArray) && isset($userInfoArray['id'])) {                        
                        $listaDeUserIds[] = $userInfoArray['id'];
                    }
                }
                foreach($listaDeUserIds as $userId){

                    $userTo = $this->entityManager->getEntity('User', $userId);            
                    $emailAddress = $userTo->get('emailAddress');

                    if($emailAddress != null){
                        $userFromId = $entity->getCreatedById();
                        $userFrom = $this->entityManager->getEntity('User', $userFromId);
                        $userName = $userFrom->getUserName();

                        $log->info("To: ".$emailAddress." From: " .$userName ."Assunto: ". $stream. "Ação: ". $actionName);
                        $this->sendEmail($userName, $emailAddress, $stream, $actionName, $actionId);

                    }else{
                        $log->info("Sem email");
                        throw new \Espo\Core\Exceptions\BadRequest("Usuário sem e-mail cadastrado.");
                    }
                }
            } else {
                $log->info("Mentions null");                
            }
        }else{
            $log->info("Mentions dont exist");
        }
    }

    public function sendEmail($userFrom, $emailTo, $message, $actionName, $actionId): void
    {
        //$email = $this->emailFactory->create();        
        //$email->setSubject("Você foi mencionado");
        $subject = "Você foi mencionado";

        $siteUrl      = (string) $this->config->get('siteUrl');
        $campaignLink = rtrim($siteUrl, '/') . '/#Campaign/view/' . $actionId;

        $html_body = "
        <p>
            Você foi mencionado na <strong>{$actionName}</strong>
        </p>

        <p>
            Mensagem de {$userFrom}:<br>
            {$message}<br>
            <a href='{$campaignLink}'>{$campaignLink}</a>
        </p>

        <p>
            Atenciosamente,<br>
            <strong>Suporte Soft CRM</strong>
        </p>
        ";


        //$email->setBody("Mensagem de " .$userFrom.": " .$message);
        //$email->setBody($html_body);
        //$email->addToAddress($emailTo);
        //$email->setIsHtml();
        
        try {
            //$this->emailSender->send($email);

        $this->jobSchedulerFactory->create()
                ->setClassName('Espo\\Custom\\Jobs\\SendMentionEmail') // Nome completo da classe do job
                ->setQueue(QueueName::E0) // Queue 'e0' é otimizada para envios de email (processa o mais rápido possível, um por um)
                ->setData([
                    'emailTo' => $emailTo,
                    'htmlBody' => $html_body,
                    'subject' => $subject
                ])
                ->schedule();            


            //$log->info("Email enviado com sucesso para: {$emailTo} (campanha: {$campaignName})");
        } catch (\Throwable $e) {
            //$log->error('Erro ao enviar email: ' . $e->getMessage());
        }
    }
}