<?php

namespace Espo\Custom\EntryPoints;

use Espo\Core\EntryPoints\Base;

class NivelCampanha extends Base
{
    public function run()
    {
        $pdo = $this->getEntityManager()->getPDO();
        $sql = "SELECT COALESCE(c_nivel, 'Sem nível') AS c_nivel, COUNT(*) AS total
                FROM campaign
                GROUP BY c_nivel
                ORDER BY total DESC";
        $rows = $pdo->query($sql)->fetchAll(\PDO::FETCH_ASSOC);

        $dataPoints = [];
        foreach ($rows as $r) {
            $dataPoints[] = [
                'label' => $r['c_nivel'],
                'y'     => (int) $r['total'],
            ];
        }

        header('Content-Type: text/html; charset=UTF-8');
        ?>
        <!DOCTYPE HTML>
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Gráfico de Níveis das Campanhas</title>
            <script src="https://cdn.canvasjs.com/canvasjs.min.js"></script>
        </head>
        <style>
            
                html::-webkit-scrollbar,
                body::-webkit-scrollbar {
                    display: none;              /* Chrome, Edge, Safari */
                
            }
        </style>
        <body>
           
            <div id="chartContainer" style="height: 500px; width: 100%;"></div>

            <script>
            window.onload = function () {
                const dataPoints = <?php echo json_encode($dataPoints, JSON_UNESCAPED_UNICODE|JSON_NUMERIC_CHECK); ?>;
                var chart = new CanvasJS.Chart("chartContainer", {
                     theme: "dark",
                     animationEnabled: true,
                     exportEnabled: true,
                    title: { text: "Distribuição dos Níveis das Campanhas" },
                    data: [{ type: "doughnut", dataPoints: dataPoints }]
                });
                chart.render();
            }
            </script>
        </body>
        </html>
        <?php
    }
}
