<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;


class Verba extends Base
{

    public function actionReprovar($params, $data, $request){
        

        $entityManager = $this->getContainer()->get('entityManager');
        $totais_por_conta = $data->totais_por_conta ?? [];

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
        $user = $this->getUser();
        $userId = $user->getId();
        
        $acao->set('cNivel', 'Cancelado');

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }           

        $postMessage = sprintf(
            '@%s Ação cancelada. Observações: %s',            
            htmlspecialchars($userName),
            $data->observacao
        );

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,                 // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
            'createdById' => $data->logged_user  // autor
        ]);

        if(!empty($totais_por_conta)){

            foreach ($totais_por_conta as $nomeConta => $dados) {
                $total = $dados->total;
                $id    = $dados->id;

                if (empty($id) || empty($total) || (float) $total <= 0) 
                {
                    continue;
                }

                $mov = $entityManager->getEntity('CCMovimentacao');
                $mov->set('name', 'Retorno automático - cancelamento');
                $mov->set('softContaCorrenteId', $id);
                $mov->set('campaignId', $data->acao_id);
                $mov->set('cSoftValor', (float)$total);
                $mov->set('createdById', $userId);
                $mov->set('cSoftTipo', 'Crédito');
                $mov->set('cSoftTipoVerba', $nomeConta);

                $entityManager->saveEntity($mov);
            }            
        }
        
        $entityManager->saveEntity($note);
        $entityManager->saveEntity($acao);

        return [
            'success' => true,
            'mensagem' => 'Ação cancelada com sucesso',
        ];
    }

    public function actionAprovar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionAprovar.');
        

        $entityManager = $this->getContainer()->get('entityManager');
        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }             

        $precisa_arte = $acao->get('cCCAprovacaoArteBool');
        $precisa_compra = $acao->get('cCTemCompra');
        
        if($precisa_arte){
            $acao->set('cNivel', 'Produção da Arte');

        }else if($precisa_compra){
            $acao->set('cNivel', 'Em compras');
        }else{
            $valor_acao = $acao->get('budget');
            $acao->set('cNivel', 'Aguardando Pagamento');
            $acao->set('cCValorFinal', $valor_acao);
            $acao->set('cCValorResidual', 0);
        }

        //$acao->set('assignedUser', $data->designed_user_id);
        $entityManager->saveEntity($acao);


        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
}
