<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;


class Briefing extends Base
{
    
    public function actionReprovar($params, $data, $request){
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }
        $acao->set('cNivel', 'Ajuste de Briefing');
        $acao->set('assignedUser', $data->designed_user_id);
           

        $postMessage = sprintf(
            '@%s Briefing reprovado. Observações: %s',            
            htmlspecialchars($userName),
            $data->observacao
        );

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
            'createdById' => $data->logged_user  // autor
        ]);

        $entityManager->saveEntity($note);
        $entityManager->saveEntity($acao);
        

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }

    public function actionAprovar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionAprovar.');
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   
        
        $acao->set('cNivel', 'Aprovação de Verba');
        //$acao->set('assignedUser', $data->designed_user_id);
        $entityManager->saveEntity($acao);        

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }

    public function actionAjustar($params, $data, $request){

        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionAjustar.');

        $entityManager = $this->getContainer()->get('entityManager');

        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
            
        $entityManager = $this->getContainer()->get('entityManager');
        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   

        $acao->set('cNivel', 'Aprovação de Briefing');
        $acao->set('cBriefingAtualizado', $data->briefing_atualizado);

        $postMessage = sprintf(
            '@%s Briefing atualizado: %s',            
            htmlspecialchars($userName),
            $data->briefing_atualizado
        );

        $note = $entityManager->createEntity('Note');

        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
            'createdById' => $data->logged_user  // autor
        ]);

        try {
            $entityManager->saveEntity($note);
            $entityManager->saveEntity($acao);
              
        } catch (Exception $e) {

            return [
                'success' => false,
                'mensagem' => 'Falha ao atualizar ação.',
            ];            
        }

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
}
