<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;

class Alocacao extends Base
{
    public function actionConfirmar($params, $data, $request)
    {
        $log = $GLOBALS['log'];
        $log->info("actionConfirmar - Alocacao");

        $entityManager = $this->getContainer()->get('entityManager');

        //Criar uma movimentação retirando (debito) o dinheiro da CC selecionada e alocando no cCValorAlocado da Ação
        //[Ação]         Valor alocado (cCValorAlocado)
        //[Ação]		   Alocação necessária (cCInvestimentoNecessario)
        //[C.C] 		   Origem do investimento (softContaCorrente)
        //[Movimentação]  Valor para investir (cSoftValor) - teste
        
        $origem = $data->origemInvestimento ?? null;
        $valor = $data->valorInvestir ?? null;
        $idAcao = $data->idAcao ?? null;
        $contaCorrenteId = $data->contaCorrenteId ?? null;   
        $investimentoNecessario = $data->investimentoNecessario;     
        $user = $this->getUser();
        $userId = $user->getId();
        
        if (!$idAcao || !$contaCorrenteId || !$valor) {
            throw new BadRequest("Parâmetros inválidos para criar movimentação.");
        }

        
        //Carregar as entidades Acao e CC
        $acao = $entityManager->getEntity('Campaign', $idAcao);
        $contaCorrente = $entityManager->getEntity('CCSoftContaCorrente', $contaCorrenteId);
        
        if (!$contaCorrente) {
            throw new BadRequest("Conta Corrente não encontrada.");
        }    
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }        
        //Criar uma movimentacao
        $mov = $entityManager->getEntity('CCMovimentacao');
        $mov->set('name', 'Alocação automática');
        $mov->set('softContaCorrenteId', $contaCorrenteId);
        $mov->set('campaignId', $idAcao);
        $mov->set('cSoftValor', (float)$valor);
        $mov->set('createdById', $userId);
        $mov->set('cSoftTipo', 'Débito');
        $mov->set('cSoftTipoVerba', $origem);
        
        $entityManager->saveEntity($mov);

        // Atualiza valores alocados da Acao
        $valorAtual = (float)$acao->get('cCValorAlocado');      
        $alocacaoNecessaria = (float)$acao->get('cCInvestimentoNecessario');   
        $valorAcao = (float)$acao->get('budget');        

        $valorAlocado = $valorAtual + (float)$valor;
        $alocacaoNecessariaFinal = $valorAcao - $valorAlocado;

        $valorAlocado = round((float) $valorAlocado, 2);
        $alocacaoNecessariaFinal = round((float) $alocacaoNecessariaFinal, 2);

        $acao->set('cCValorAlocado', $valorAlocado);
        $acao->set('cCInvestimentoNecessario', $alocacaoNecessariaFinal);

        $entityManager->saveEntity($acao);


        return [
            'success' => true,
            'mensagem' => 'Movimentação registrada com sucesso',
        ];
    }

    public function actionConfirmarRealocacao($params, $data, $request)
    {
        $log = $GLOBALS['log'];
        $log->info("actionConfirmar - Realocacao");

        $entityManager = $this->getContainer()->get('entityManager');
        
        $origem = $data->origemInvestimento ?? null;
        $valor = $data->valorInvestir ?? null;
        $idAcao = $data->idAcao ?? null;
        $contaCorrenteId = $data->contaCorrenteId ?? null;     
        $user = $this->getUser();
        $userId = $user->getId();
        
        if (!$idAcao || !$contaCorrenteId || !$valor) {
            throw new BadRequest("Parâmetros inválidos para criar movimentação.");
        }

        
        //Carregar as entidades Acao e CC
        $acao = $entityManager->getEntity('Campaign', $idAcao);
        $contaCorrente = $entityManager->getEntity('CCSoftContaCorrente', $contaCorrenteId);
        
        if (!$contaCorrente) {
            throw new BadRequest("Conta Corrente não encontrada.");
        }    
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }        
        //Criar uma movimentacao
        $mov = $entityManager->getEntity('CCMovimentacao');
        $mov->set('name', 'Realocação automática');
        $mov->set('softContaCorrenteId', $contaCorrenteId);
        $mov->set('campaignId', $idAcao);
        $mov->set('cSoftValor', (float)$valor);
        $mov->set('createdById', $userId);
        $mov->set('cSoftTipo', 'Débito');
        $mov->set('cSoftTipoVerba', $origem);
        
        $entityManager->saveEntity($mov);

        // Atualiza valores realocados da Acao
        $valorAtual = (float)$acao->get('cCValorAlocado');      
        $alocacaoNecessaria = (float)$acao->get('cCInvestimentoNecessario');   
        $valorAcao = (float)$acao->get('cCValorFinal');
        $valorResidual = (float)$acao->get('cCValorResidual');

        $valorAlocado = $valorAtual + (float)$valor;
        $alocacaoNecessariaFinal = $valorAcao - $valorAlocado;
        $valorResidualFinal = $alocacaoNecessariaFinal * -1;

        $valorAlocado = round((float) $valorAlocado, 2);
        $alocacaoNecessariaFinal = round((float) $alocacaoNecessariaFinal, 2);
        $valorResidualFinal = round((float) $valorResidualFinal, 2);

        $acao->set('cCValorAlocado', $valorAlocado);
        $acao->set('cCInvestimentoNecessario', $alocacaoNecessariaFinal);
        $acao->set('cCValorResidual', $valorResidualFinal);

        $entityManager->saveEntity($acao);


        return [
            'success' => true,
            'mensagem' => 'Movimentação registrada com sucesso',
        ];
    }

        public function actionConfirmarRetorno($params, $data, $request)
    {
        $log = $GLOBALS['log'];
        $log->info("actionConfirmar - Retorno");

        $entityManager = $this->getContainer()->get('entityManager');
        
        $origem = $data->origemInvestimento ?? null;
        $valor = $data->valorRetornar ?? null;
        $idAcao = $data->idAcao ?? null;
        $contaCorrenteId = $data->contaCorrenteId ?? null;     
        $user = $this->getUser();
        $userId = $user->getId();
        
        if (!$idAcao || !$contaCorrenteId || !$valor) {
            throw new BadRequest("Parâmetros inválidos para criar movimentação.");
        }

        
        //Carregar as entidades Acao e CC
        $acao = $entityManager->getEntity('Campaign', $idAcao);
        $contaCorrente = $entityManager->getEntity('CCSoftContaCorrente', $contaCorrenteId);
        
        if (!$contaCorrente) {
            throw new BadRequest("Conta Corrente não encontrada.");
        }    
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }        
        //Criar uma movimentacao
        $mov = $entityManager->getEntity('CCMovimentacao');
        $mov->set('name', 'Retorno automático');
        $mov->set('softContaCorrenteId', $contaCorrenteId);
        $mov->set('campaignId', $idAcao);
        $mov->set('cSoftValor', (float)$valor);
        $mov->set('createdById', $userId);
        $mov->set('cSoftTipo', 'Crédito');
        $mov->set('cSoftTipoVerba', $origem);
        
        $entityManager->saveEntity($mov);

        // Atualiza valores retornardos da Acao
        $valorAtual = (float)$acao->get('cCValorAlocado');      
        $retornoNecessario = (float)$acao->get('cCInvestimentoNecessario');   
        $valorAcao = (float)$acao->get('cCValorFinal');
        $valorResidual = (float)$acao->get('cCValorResidual');

        $valorAlocado = $valorAtual - (float)$valor;
        $alocacaoNecessariaFinal = ($valorAlocado - $valorAcao) * -1;
        $valorResidualFinal = $alocacaoNecessariaFinal * -1;

        $valorAlocado = round((float) $valorAlocado, 2);
        $alocacaoNecessariaFinal = round((float) $alocacaoNecessariaFinal, 2);
        $valorResidualFinal = round((float) $valorResidualFinal, 2);

        $acao->set('cCValorAlocado', $valorAlocado);
        $acao->set('cCInvestimentoNecessario', $alocacaoNecessariaFinal);
        $acao->set('cCValorResidual', $valorResidualFinal);

        $entityManager->saveEntity($acao);


        return [
            'success' => true,
            'mensagem' => 'Movimentação registrada com sucesso',
        ];
    }
}

