define('custom:views/conta-corrente/record/detail', [
  'views/record/detail'
], function (Dep) {

  return Dep.extend({
    setup() {
      Dep.prototype.setup.call(this);
      console.log("ENTREI CREATE CC2");

            this.listenTo(this.model, 'after:relate', (link, model) => {
                this.atualizarSaldo();
            });

            this.listenTo(this.model, 'after:unrelate', (link, model) => {
                if (link === 'movimentacaos') {
                    console.log('Movimentação removida:', model);
                    this.atualizarSaldo();
                }
            });
        },

        /**
         * Atualiza o saldo na UI após movimentações mudarem
         */
    atualizarSaldo: function () {
        Espo.Ui.notify('Atualizando saldo...', 'loading');

        this.model.fetch().then(() => {
            this.reRender(); // Atualiza a tela da conta corrente
            Espo.Ui.notify(false);
            Espo.Ui.success('Saldo atualizado com sucesso.');
        }).catch(e => {
            Espo.Ui.notify(false);
            Espo.Ui.error('Erro ao atualizar o saldo.');
            console.error(e);
        });        
    },
    afterRender: function () {
    
      Dep.prototype.afterRender.call(this); 
      
      const $root = this.$el; // container da página atual (list/record)

      const applyHide = () => {
          // Esconde o item "Remover ligação" do menu
          $root.find('a.action[data-action="unlinkRelated"]').closest('li').hide();

          // (Opcional) esconder também o "Remover" (exclui o registro)
          // $root.find('a.action[data-action="removeRelated"]').closest('li').hide();
      };

      // Aplica agora e depois (caso a lista renderize em seguida)
      applyHide();
      setTimeout(applyHide, 150);
      setTimeout(applyHide, 600);
    
    },
  });
});
