define('custom:views/campaign/record/edit', ['views/record/edit'], function (Dep) {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);
            
            this.listenTo(this.model, 'change:cAccountId', function () {
                this.atualizarRede();
            }.bind(this));
        },
        
        afterRender: function () {            
            Dep.prototype.afterRender.call(this); 

            const status = this.model.get('cNivel');

            if(status == 'Nova'){
                document.querySelector('.side').style.display = 'none'
            }            
        },

        atualizarRede: function () {

            const accountId = this.model.get('cAccountId');
            if (!accountId) {
                this.model.set('cRede', null);
                return;
            }

            // 1) Buscar dados da conta
            Espo.Ajax.getRequest('Account/' + accountId).then(account => {

                const codigoRede = account.cCodigoDaRede;
                const nomeConta = account.name;   // <-- nome da conta

                if (!codigoRede) {
                    // Sem código da rede → usar nome da conta
                    this.model.set('cRede', nomeConta);
                    return;
                }

                // 2) Buscar REDE correspondente
                Espo.Ajax.getRequest('CRede', {
                    where: [
                        {
                            type: 'equals',
                            attribute: 'cdigoDoGrupo',
                            value: codigoRede
                        }
                    ]
                }).then(response => {

                    if (response.list && response.list.length > 0) {
                        const rede = response.list[0];
                        this.model.set('cRede', rede.name);
                        this.model.set('cCCRedeAcao', rede.id);                        
                        this.model.set('cCCRedeAcaoId', rede.id);
                        this.model.set('cCCRedeAcaoName', rede.name);
                    } else {
                        //TODO: tratar se não encontrar rede
                        this.model.set('cRede', nomeConta);
                    }
                });

            });

        },

    });

});
