define('custom:views/campaign/modals/validar-acao', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {

            const title = (this.options.title) || '';
            const ajustar_button = String(this.options.ajustar_button);

            this.headerText = title;             

            this.formModel = new Model();
            /*
            this.formModel.setDefs({
                fields: {
                    observacao: { 
                        type: 'text',
                        readOnly: false,
                        labelText: 'Digite as observações...',
                        required: true
                    }
                }
            });*/
            
            this.formModel.defs.fields.observacao = Object.assign(
                {
                    type: 'text',
                    label: 'Observações',
                    required: true
                },
                this.formModel.defs.fields.observacao || {}
            );

            this.formModel.set({
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'observacao', label: 'Observações', labelText: 'Observações'}]
                        ],
                    },
                ],
            });
            
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'reprovar',
                    text: ajustar_button,
                    style: 'danger',
                    onClick: () => this.reprovar(),
                }
            ];

        }

        async reprovar(){

            console.log("Reprovar");

            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            
            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }

            const obs = this.formModel.attributes.observacao;
            const user_created = this.options.model.attributes.createdByName;
            const user_id_created = this.options.model.attributes.createdById;
            const logged_user = this.getUser().attributes.id;
            const acao_id = this.options.model.attributes.id;
            const status_atual = this.options.model.get('cNivel') 

            const fluxoReprovacao = {
                'Aprovação de Briefing': {
                    rota: 'Briefing/action/reprovar',
                    mensagemSucesso: 'Briefing reprovado com sucesso!',
                },
                'Aprovação de Verba': {
                    rota: 'Verba/action/reprovar',
                    mensagemSucesso: 'Verba reprovada com sucesso!',
                },
                'Aprovação da Arte': {
                    rota: 'Arte/action/reprovar',
                    mensagemSucesso: 'Arte reprovada com sucesso!',
                },
                'Aprovação da documentação': {
                    rota: 'Documentacao/action/reprovar',
                    mensagemSucesso: 'Documentação reprovada com sucesso!',
                },
                'Produção da Arte': {
                    rota: 'Briefing/action/reprovar',
                    mensagemSucesso: 'Briefing reprovado com sucesso!',
                },
            };
            
            const config = fluxoReprovacao[status_atual];

            if(obs != null){
                
                Espo.Ui.notify('Processando...', { close: false, spinner: true });
                const $reprovar = $('.modal-footer [data-name="reprovar"], .modal-footer .btn-danger');
                $reprovar.addClass('disabled');

                try {
                    const response = await Espo.Ajax.postRequest(config.rota, {
                        acao_id: acao_id,
                        logged_user: logged_user,
                        observacao: obs,
                        designed_user_id: user_id_created,
                        designed_user: user_created,
                        status_atual: status_atual,
                        totais_por_conta: this.options.movimentacoesData
                    });

                    if (response.success) {
                        this.trigger('done', response);
                        this.close();
                    } else {
                        $reprovar.addClass('enable');
                        Espo.Ui.notify(false);
                        Espo.Ui.error('Erro ao trocar de status');
                    }
                } catch (e) {
                    $reprovar.addClass('enable');
                    Espo.Ui.error('Falha na comunicação com o servidor');
                    console.error(e);
                }

            }else{
                Espo.Ui.error('Adicione uma observação.');                
            }
        }
    }

});