define('custom:views/campaign/modals/inserir-docs', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

            className = 'dialog dialog-record';

            // language=Handlebars
            templateContent = `
                <div class="record no-side-margin">{{{record}}}</div>
            `;

            backdrop = true;

            setup() {

                const title = (this.options.title) || '';
                const ajustar_button = String(this.options.ajustar_button);

                this.attachmentField = this.options.attachmentField || 'cCArquivosDaAcao';

                this.headerText = title;

                this.formModel = this.options.model;

                this.formModel.defs.fields[this.attachmentField] = Object.assign(
                    {
                        type: 'attachmentMultiple',
                        labelText: 'Documentos',
                        required: true
                    },
                    this.formModel.defs.fields[this.attachmentField] || {}
                );

                this.createView('record', 'views/record/edit-for-modal', {
                    model: this.formModel,
                    selector: '.record',
                    detailLayout: [
                        {
                            rows: [
                                [{ name: this.attachmentField, label: 'Documentos' }],
                                [{ name: 'observacao', label: 'Observações' }]
                            ],
                        },
                    ],
                });

                this.buttonList = [
                    {
                        name: 'cancelar',
                        label: 'Cancelar',
                        onClick: () => this.close(),
                    },
                    {
                        name: 'enviarDoc',
                        text: ajustar_button,
                        style: 'success',
                        onClick: () => this.enviarDoc(),
                    }
                ];
            }

            async enviarDoc() {

                console.log("Enviar docs");
                const recordView = this.getView('record');
                const isValid = recordView.processFetch();
                
                if (!isValid) { 
                    Espo.Ui.error('Verifique os campos.');
                    return;
                }
                const field = this.attachmentField;

                const assigned_user_id = this.formModel.get('assignedUserId');
                const user_id_created = this.options.model.get('createdById');
                const logged_user = this.getUser().get('id');
                const observacao = this.formModel.get('observacao') || '';

                const arquivos_ids  = this.formModel.get(field + 'Ids');
                const arquivos_name = this.formModel.get(field + 'Names');
                const arquivos_type = this.formModel.get(field + 'Types');

                const acao_id = this.options.model.get('id');
                const status_atual = this.options.model.get('cNivel') 

                Espo.Ui.notify('Processando...', { close: false, spinner: true });

                const $enviarDocs = $('.modal-footer [data-name="enviarDoc"], .modal-footer .btn-success');
                $enviarDocs.addClass('disabled');

                
                const fluxoEnvioDocs = {
                    'Produção da Arte': {
                        rota: 'Arte/action/enviarArte',
                        mensagemSucesso: 'Arte enviada com sucesso!',
                    },
                    'Aprovação de Verba': {
                        rota: 'Verba/action/reprovar',
                        mensagemSucesso: 'Verba reprovada com sucesso!',
                    },
                    'Aprovação da Arte': {
                        rota: 'Arte/action/reprovar',
                        mensagemSucesso: 'Arte reprovada com sucesso!',
                    },
                    'Aprovação da documentação': {
                        rota: 'Documentacao/action/reprovar',
                        mensagemSucesso: 'Documentação reprovada com sucesso!',
                    },
                    'Aguardando Documentação': {
                        rota: 'Documentacao/action/inserir',
                        mensagemSucesso: 'Documentação inserida com sucesso!',
                    }
                };
                
                const config = fluxoEnvioDocs[status_atual];

                try {
                    const response = await Espo.Ajax.postRequest(config.rota, {
                        acao_id: acao_id,
                        logged_user: logged_user,
                        observacao: observacao,
                        created_user_id: user_id_created,
                        arquivos_ids: arquivos_ids,
                        arquivos_name: arquivos_name,
                        arquivos_type: arquivos_type,
                        assigned_user_id: assigned_user_id,
                        attachmentField: field
                    });

                    if (response.success) {
                        this.trigger('done', response);
                        this.close();
                    } else {
                        $enviarDocs.removeClass('disabled');
                        Espo.Ui.notify(false);
                        Espo.Ui.error('Erro ao enviar documentos.');
                    }
                } catch (e) {
                    $enviarDocs.removeClass('disabled');
                    Espo.Ui.error('Falha na comunicação com o servidor');
                    console.error(e);
                }
            }
        };
});