define('custom:views/campaign/modals/ajustar-acao', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {

            const title = (this.options.title) || '';
            const ajustar_button = String(this.options.ajustar_button);
            const ajustar_obs = String(this.options.obs_field) || 'Ajustar';

            this.headerText = title;             

            this.formModel = new Model();

            this.formModel.setDefs({
                fields: {
                    observacao: { 
                        type: 'text',
                        readOnly: false,
                        labelText: ajustar_obs,
                        required: true
                    }
                }
            });
            
            this.formModel.set({
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'ajuste', label: ajustar_obs, required: true }]
                        ],
                    },
                ],
            });
            
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'ajustar',
                    text: ajustar_button,
                    style: 'success',
                    onClick: () => this.ajustar(),
                }
            ];

        }

        async ajustar(){

            console.log("Ajustar");

            const briefing_atualizado = this.formModel.attributes.ajuste;
            const status_atual = this.options.model.get('cNivel');
            const acao_id = this.options.model.attributes.id;
            const user_id_created = this.options.model.get('createdById');
            const logged_user = this.getUser().get('id');

            if(briefing_atualizado.length > 5){
                
                Espo.Ui.notify('Processando...', { close: false, spinner: true });
                const $ajustar = $('.modal-footer [data-name="ajustar"], .modal-footer .btn-success');
                $ajustar.addClass('disabled');

                try {
                    const response = await Espo.Ajax.postRequest('Briefing/action/ajustar', {
                        acao_id: acao_id,
                        briefing_atualizado: briefing_atualizado,
                        status_atual: status_atual,
                        designed_user_id: user_id_created,
                        logged_user: logged_user
                    });

                    if (response.success) {
                        this.trigger('done', response);
                        this.close();
                    } else {
                        $reprovar.addClass('enable');
                        Espo.Ui.notify(false);
                        Espo.Ui.error('Erro ao trocar de status');
                    }
                } catch (e) {
                    $ajustar.addClass('enable');
                    Espo.Ui.error('Falha na comunicação com o servidor');
                    console.error(e);
                }

            }else{
                Espo.Ui.error('Preencha todos os campos.');                
            }            
        }
    }

});