<?php
namespace Espo\Custom\Jobs;

use Espo\Core\Job\Job;
use Espo\Core\Mail\EmailSender;
use Espo\Core\Mail\EmailFactory;

use Espo\Core\Utils\Config;
use Espo\Core\Job\Job\Data;

class SendMentionEmail implements Job
{
    public function __construct(
        private EmailSender $emailSender,
        private EmailFactory $emailFactory
    ) {}

    public function run(Data $data): void
    {
        // $data contém os parâmetros que você passou ao agendar o job
        $email = $this->emailFactory->create();
        
        $subject  = (string) ($data->get('subject')  ?? '');
        $htmlBody = (string) ($data->get('htmlBody') ?? '');
        $emailTo  = (string) ($data->get('emailTo')  ?? '');

        $email->setSubject($subject);
        $email->setBody($htmlBody);
        $email->addToAddress($emailTo);

        $email->setIsHtml();

        try {
            $this->emailSender->send($email);
        } catch (\Throwable $e) {
            // O EspoCRM loga falhas em Jobs automaticamente, 
            // mas você pode adicionar logs customizados aqui
        }
    }
}