<?php
namespace Espo\Custom\Hooks\CCMovimentacao;

use Espo\ORM\Entity;
use Espo\Core\ORM\EntityManager;

class updateSaldo
{ 
    private $entityManager;

    public function __construct(EntityManager $entityManager) {
        $this->entityManager = $entityManager;
    }

    /**
     * @param array<string, mixed> $options
     */
    public function beforeSave(Entity $entity, array $options): void
    {
        $log = $GLOBALS['log'];       
        $log->info("beforeSave - updateSaldo");

        $tipoMovimentacao = $entity->get('cSoftTipo');     // Crédito ou Débito
        $valor = (float) $entity->get('cSoftValor');       // valor da movimentação

        // Link no relacionamento de BD entre movimentacao e Conta Corrente        
        $ccLinkName = "softContaCorrente";
        //$contaCorrente = $entity->get($ccLinkName);
        $contaCorrente = $this->entityManager
            ->getRelation($entity, $ccLinkName)
            ->findOne(); // retorna a conta vinculada

        if (!$contaCorrente) {
            $log->error("Nenhuma Conta Corrente vinculada à movimentação.");
            return;
        }

        $contaCorrenteName = $contaCorrente->get("name");
        $contaCorrenteId = $contaCorrente->get("cSoftIDContaCorrente");
        $tipoCC = $contaCorrente->get('cSoftTipoCC') ? : 'Outros';

        $log->info("Atualizando CMovimentacao do tipo " .$tipoMovimentacao. " no valor de R$" .$valor. " na CC: " .$contaCorrenteName. " (" .$contaCorrenteId.")");

        // valores atuais ou zero
        $totalCredito = (float) $contaCorrente->get('totalDeCredito') ?: 0;
        $totalDebito = (float) $contaCorrente->get('totalDeDebito') ?: 0;

        if ($tipoMovimentacao == "Débito") {
            $totalDebito += $valor;
        } elseif ($tipoMovimentacao == "Crédito") {
            $totalCredito += $valor;
        } else {
            $log->error("Tipo de movimentação inválido: " . $tipoMovimentacao);
            return;
        }

        // atualizar totais
        $contaCorrente->set('totalDeCredito', $totalCredito);
        $contaCorrente->set('totalDeDebito', $totalDebito);

        // saldo = créditos - débitos
        $saldoFinal = $totalCredito - $totalDebito;
        $contaCorrente->set('saldo', $saldoFinal);

        $this->entityManager->saveEntity($contaCorrente);

        $entity->set('cSoftTipoVerba', $tipoCC);        
        $name = $entity->get('name');
        if(strlen($name) == 0){
            $entity->set('name', 'Movimentação Manual');
        }

/*
        if ($tipoCC == "Acordo Objetivo" || $tipoCC == "Acordo de Marketing") {

            if ($tipoMovimentacao == "Débito") {
                $totalDebito += $valor;
            } elseif ($tipoMovimentacao == "Crédito") {
                $totalCredito += $valor;
            } else {
                $log->error("Tipo de movimentação inválido: " . $tipoMovimentacao);
                return;
            }

            // atualizar totais
            $contaCorrente->set('totalDeCredito', $totalCredito);
            $contaCorrente->set('totalDeDebito', $totalDebito);

            // saldo = créditos - débitos
            $saldoFinal = $totalCredito - $totalDebito;
            $contaCorrente->set('saldo', $saldoFinal);

            $this->entityManager->saveEntity($contaCorrente);
        } 
        else {
            //TODO: implementar regra para CC de supervisores/gerentes
        }
        */
    }
}
