<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;

class Pagamento extends Base
{

    public function actionPagamentoRealizado($params, $data, $request){
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id);
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }
        if($data->tem_transporte){
            $acao->set('cNivel', 'Em transporte');
        }else{
            $acao->set('cNivel', 'Aguardando Documentação');
        }           

        if(strlen($data->observacoes) > 0){
            
            $postMessage = sprintf(
                'Pagamento realizado. Observações: %s',  
                $data->observacoes
            );
        }else{
            
            $postMessage = sprintf(
                'Pagamento realizado'
            );
        }

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
        ]);

        $entityManager->saveEntity($note);
        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Status da ação atualizado com sucesso',
        ];
    }
}