<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;

class Acao extends Base
{

    public function actionIniciar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('User: ' .$data->logged_user);

        $entityManager = $this->getContainer()->get('entityManager');

        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }    

        $acao->set('cNivel', 'Aprovação de Briefing');
        $acao->set('assignedUserId', $data->logged_user);

        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }

}