define('custom:views/campaign/modals/pagamento-realizado', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {

            const title = (this.options.title) || '';

            this.headerText = title;             

            this.formModel = new Model();

            this.formModel.setDefs({
                fields: {
                    observacao: { 
                        type: 'text',
                        readOnly: false,
                        labelText: "Observações",
                        required: false
                    }
                }
            });
            
            this.formModel.set({
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'observacoes', label: "Observações", required: false }]
                        ],
                    },
                ],
            });
            
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'comTransporte',
                    text: "Com transporte",
                    style: 'success',
                    onClick: () => this.atualizaStatus(1),
                },
                {
                    name: 'semTransporte',
                    text: "Sem transporte",
                    style: 'warning',
                    onClick: () => this.atualizaStatus(0),
                }
            ];

        }
        async atualizaStatus($temTransporte){

            const obs = this.formModel.attributes.observacoes;
            const status_atual = this.options.model.get('cNivel');
            const acao_id = this.options.model.attributes.id;
            const tem_transporte = $temTransporte;

            Espo.Ui.notify('Processando...', { close: false, spinner: true });
            const $semTransporte = $('.modal-footer [data-name="semTransporte"], .modal-footer .btn-warning');
            const $comTransporte = $('.modal-footer [data-name="comTransporte"], .modal-footer .btn-success');

            $semTransporte.addClass('disabled');
            $comTransporte.addClass('disabled');

            try {
                const response = await Espo.Ajax.postRequest('Pagamento/action/pagamentoRealizado', {
                    acao_id: acao_id,
                    observacoes: obs,
                    status_atual: status_atual,
                    tem_transporte: tem_transporte
                });

                if (response.success) {
                    this.trigger('done', response);
                    this.close();
                } else {
                    $semTransporte.addClass('enable');
                    $comTransporte.addClass('enable');
                    Espo.Ui.notify(false);
                    Espo.Ui.error('Erro ao trocar de status');
                }
            } catch (e) {
                $semTransporte.addClass('enable');
                $comTransporte.addClass('enable');
                Espo.Ui.error('Falha na comunicação com o servidor');
                console.error(e);
            }  
        }
    }

});