define('custom:views/campaign/modals/finalizar-compra', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        // If true, clicking on the backdrop will close the dialog.
        // Can be 'static', true or false.
        backdrop = true 

        setup() {

            let title = this.options.title; // assuming it's passed from our parent view
            let valorAlocado = this.options.valor_alocado;
            let valorAcao = this.options.valor_acao;
            let idAcao = this.options.id_acao;

            this.headerText = title;     
            this.attachmentField = this.options.attachmentField;   

            //this.formModel = new Model();
            this.formModel = this.options.model;
            
            this.formModel.defs.fields[this.attachmentField] = Object.assign(
                {
                    type: 'attachmentMultiple',
                    labelText: 'Documentos',
                    required: true
                },
                this.formModel.defs.fields[this.attachmentField] || {}
            );
            
            this.formModel.setDefs({
                fields: {
                    [this.attachmentField]: {
                        type: 'attachmentMultiple',
                        required: true,
                        label: 'Documentos',
                        labelText: 'Documentos',
                    },
                    valorPago: {
                        type: 'currency',
                        required: true,
                        label: 'Valor final pago'
                    }
                }
            });
            
            
            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: this.attachmentField, label: 'Documentos da Compra', labelText: 'Documentos da Compra'}],
                            [{ name: 'valorPago',type: 'currency',label: 'Valor Pago', labelText: 'Valor Pago'}]
                        ],
                    },
                ],
            });
            
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'finalizar', // handler for 'doSomething' action is bellow
                    text: 'Atualizar valor', // button label 
                    style: 'success',
                    onClick: () => this.confirmarCompra(valorAlocado, valorAcao, title, idAcao),
                }
            ];

        }

        async confirmarCompra(valorAlocado, valorAcao, title) {

            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            
            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }
            
            let valor_residual = valorAcao - this.formModel.attributes.valorPago;
            
            const field = this.attachmentField;
            const arquivos_ids  = this.formModel.get(field + 'Ids');
            const arquivos_name = this.formModel.get(field + 'Names');
            const arquivos_type = this.formModel.get(field + 'Types');

            this.createView('dialog', 'custom:views/campaign/modals/confirmar-compra', {
                title: title,
                valorAlocado: valorAlocado,
                valorAcao: valorAcao,
                valorPago: this.formModel.attributes.valorPago,
                valorResidual: valor_residual,
                idAcao: this.options.id_acao,
                arquivos_ids: arquivos_ids, 
                arquivos_name: arquivos_name,  
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
        }
    }

});