define('custom:views/campaign/modals/confirmar-retorno', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];
            this.headerText = 'Retornar investimento';

            this.formModel = new Model();

            // Define os campos do formulário
            this.formModel.setDefs({
                fields: {
                    saldoDisponivel: { 
                        type: 'currency', 
                        readOnly: true
                    },
                    valorRetornar: { 
                        type: 'currency', 
                        required: true, 
                        currency: 'BRL',
                        text: 'Valor para retornar',  
                        labelText: 'Valor para retornar', 
                        min: 0.01,
                        precision: 2,
                        default: null
                    }
                }
            });

            // Inicializa com o valor sugerido (opcional, pode vir da primeira modal)
            this.formModel.set({
                saldoDisponivel: this.options.data.saldo
            });

            // Passa os dados da primeira modal para o modelo
            this.formModel.set(this.options.data || {});

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'saldoDisponivel', readOnly: true, label: 'Valor disponível para retornar' }],
                            [{ name: 'valorRetornar', label: 'Valor para retornar' }],
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {
            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            let saldoFinalCC = 0;

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }

            if(this.formModel.attributes.valorRetornar > this.formModel.attributes.saldoDisponivel){                
                Espo.Ui.error('Valor de retorno é maior do que o saldo.');
                return;
            }

            if(this.formModel.attributes.valorRetornar > this.formModel.attributes.valorResidual){                
                Espo.Ui.error('Valor de retorno é maior que o valor residual. (R$ ' + this.formModel.attributes.valorResidual +')');
                return;
            }
            
            saldoFinalCC = this.formModel.attributes.saldoDisponivel - this.formModel.attributes.valorRetornar;

            const data = {
                idAcao: this.formModel.attributes.id,
                origemInvestimento: this.formModel.attributes.origemInvestimento,
                valorRetornar: this.formModel.attributes.valorRetornar,
                saldoFinal: saldoFinalCC,
                contaCorrenteId: this.formModel.attributes.contaCorrenteId,
                valorResidual: this.formModel.attributes.valorResidual
            };
            
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/aviso-retorno', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
        }
    }
});