define('custom:views/campaign/modals/confirmar-compra', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
        
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Confirmar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];
            this.headerText = 'Finalizar Compra';

            this.formModel = new Model();

            // Define os campos do formulário
            this.formModel.setDefs({
                fields: {
                    valorFinal: { 
                        type: 'currency', 
                        readOnly: true
                    },
                    valorOriginal: { 
                        type: 'currency', 
                        readOnly: true
                    },
                    valorResidual: { 
                        type: 'currency', 
                        readOnly: true
                    }
                }
            });

            // Inicializa com o valor sugerido (opcional, pode vir da primeira modal)
            this.formModel.set({
                valorFinal: this.options.valorPago,
                valorOriginal: this.options.valorAcao,
                valorResidual: this.options.valorResidual
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'valorFinal', readOnly: true, label: 'Valor Final da compra' }],
                            [{ name: 'valorOriginal', readOnly: true, label: 'Valor inicial da ação' }],
                            [{ name: 'valorResidual', readOnly: true, label: 'Valor residual' }],
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {
            try {
            const response = await Espo.Ajax.postRequest('Compra/action/finalizarCompra', {
                acao_id:  this.options.idAcao,
                arquivos_ids: this.options.arquivos_ids, 
                arquivos_name: this.options.arquivos_name,
                valor_final: this.formModel.attributes.valorFinal,
                valor_residual: this.formModel.attributes.valorResidual,
            });

            if (response.success) {
                Espo.Ui.success(response.mensagem);
                this.trigger('done', response);
                this.close();
            } else {
                
                Espo.Ui.notify(false);
                Espo.Ui.error('Erro iniciar a ação');
            }
        } catch (e) {
            Espo.Ui.error('Falha na comunicação com o servidor');
            console.error(e);
        }
        }
    }
});