define('custom:views/campaign/modals/aviso-retorno', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
            
            const textFieldOrigem = 'O retorno será feito da conta corrente ' + this.options.data.origemInvestimento + ', confirmar?';
            const textFieldValorRetornar = 'O valor que ira retornar é de R$ ' + this.options.data.valorRetornar;

            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];            
            this.headerText = 'Aviso de retorno do investimento';

            this.formModel = new Model();

            // Passa os dados da primeira modal para o modelo
            //this.formModel.set(this.options.data || {});

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'origemInvestimento', readOnly: true, label:  textFieldOrigem}],                            
                            [{ name: 'valorRetornar', readOnly: true, label:  textFieldValorRetornar}],                        
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {
            const recordView = this.getView('record');
            const isValid = recordView.processFetch();

            //Cria uma movimentação adicionando (credito) o dinheiro da CC selecionada
            //Atualiza status ação

            try {
                const response = await Espo.Ajax.postRequest('Alocacao/action/confirmarRetorno', {
                    origemInvestimento: this.options.data.origemInvestimento,
                    valorRetornar: this.options.data.valorRetornar,
                    idAcao: this.options.data.idAcao,
                    contaCorrenteId: this.options.data.contaCorrenteId,
                    investimentoNecessario: this.options.data.investimentoNecessario
                });

                if (response.success) {
                    Espo.Ui.success(response.mensagem);
                    this.trigger('done', response);
                    this.close();
                } else {
                    Espo.Ui.error('Erro ao confirmar a alocação');
                }
            } catch (e) {
                Espo.Ui.error('Falha na comunicação com o servidor');
                console.error(e);
            }
        }
    }
});