<?php

namespace Espo\Custom\EntryPoints;

use Espo\Core\EntryPoints\Base;

class TotalCampanhasConcluidas extends Base
{
    public function run()
    {
        $pdo = $this->getEntityManager()->getPDO();

        // Conta campanhas concluídas
        $sql = "SELECT COUNT(*) AS total FROM campaign WHERE c_nivel = 'concluida'";
        $total = $pdo->query($sql)->fetchColumn();

        header('Content-Type: text/html; charset=UTF-8');
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Campanhas Concluídas</title>
              <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
            <style>
                html::-webkit-scrollbar,
                    body::-webkit-scrollbar {
                        display: none;              /* Chrome, Edge, Safari */
                    }
                body {
                    font-family: Arial, sans-serif;
                    text-align: center;
                }
                .card {
                    background: #f4f6f8;
                    border-radius: 12px;
                    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
                    display: flex; /* Flexbox horizontal */
                    align-items: center; /* Centraliza verticalmente (ícone e info) */
                    /* Removendo o 'justify-content' aqui para que o 'flex-grow: 1' funcione melhor */
                    width: 100%;
                    height: 80px;
                    padding: 10px 20px;
                    box-sizing: border-box;
                }
                .icon {
                    font-size: 36px;
                    color: #2c3e50;
                    margin-right: 15px;
                    flex-shrink: 0; 
                }
                .info {
                    display: flex;
                    flex-direction: column;                  
                    flex-grow: 1; 
                    align-items: center; 
                    justify-content: center; 
                }
                    .number {
                        font-size: 48px;
                        font-weight: bold;
                        color: #2e7d32;
                        line-height: 1;
                    }
                    .label {
                        font-size: 18px;
                        color: #388e3c;
                    }
                </style>
        </head>
        <body>
           <div class="card">
                <div class="icon"><i class="fa-solid fa-font-awesome"></i></div>
                   <div class="info">
                    <div class="number"><?php echo $total; ?></div>
                    <div class="label">Campanhas Concluídas</div>
                </div>
            </div>
        </body>
        </html>
        <?php
    }
}
