<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;


class Documentacao extends Base
{
    public function actionInserir($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionInserir.');

        $entityManager = $this->getContainer()->get('entityManager');

        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }

        $acao->set('cNivel', 'Aprovação da documentação');
        $acao->set('cCArquivosDaDocumentacaoIds', $data->arquivos_ids);
        $acao->set('cCArquivosDaDocumentacaoNames', $data->arquivos_name);
        
        if(strlen($data->observacao) > 0){
            
            $postMessage = sprintf(
                'Documentos inseridos. Observações: %s',  
                $data->observacao
            );
        }else{
            
            $postMessage = sprintf(
                'Documentos inseridos'
            );
        }

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
        ]);
                
        $entityManager->saveEntity($note);  
        $entityManager->saveEntity($acao);    

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
    
    public function actionAprovar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionAprovar Documentacao.');

        $entityManager = $this->getContainer()->get('entityManager');
               
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   

        $acao->set('cNivel', 'Concluída');
        $entityManager->saveEntity($acao);   

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
    
    public function actionReprovar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionReprovar - Documentacao.');
               
        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }
        $acao->set('cNivel', 'Aguardando Documentação');
        //$acao->set('assignedUser', $data->designed_user_id);
        
        $postMessage = sprintf(
            '@%s Documentação reprovada. Observações: %s',            
            htmlspecialchars($userName),
            $data->observacao
        );

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
        ]);

        $entityManager->saveEntity($note);
        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Documentação reprovada com sucesso',
        ];
    }
    
    public function actionRetirada($params, $data, $request){
        
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionRetirada Documentacao.');

        $entityManager = $this->getContainer()->get('entityManager');
               
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   

        $acao->set('cNivel', 'Aguardando Documentação');
        $entityManager->saveEntity($acao);   

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
}
