<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;

class Compra extends Base
{

    public function actionFinalizarCompra($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionFinalizarCompra.');
        

        $entityManager = $this->getContainer()->get('entityManager');

        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }    

        $valorResidualFinal = ($data->valor_residual) * -1;

        $valorFinal = round((float) $data->valor_final, 2);
        $valorResidual = round((float) $data->valor_residual, 2);
        $valorResidualFinal = round((float) $valorResidualFinal, 2);

        $acao->set('cNivel', 'Aguardando Pagamento');

        $acao->set('cCArquivosCompraIds', $data->arquivos_ids);
        $acao->set('cCArquivosCompraNames', $data->arquivos_name);  

        $acao->set('cCValorFinal', $valorFinal);   
        $acao->set('cCValorResidual', $valorResidual);    
        $acao->set('cCInvestimentoNecessario', $valorResidualFinal);    
        //$acao->set('assignedUserId', $data->logged_user);

        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Compra finalizada com sucesso',
        ];
        
    }
}