<?php
namespace Espo\Custom\Controllers;

use Espo\Core\Controllers\Base;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Exceptions\BadRequest;
use Espo\ORM\Entity;

class Arte extends Base
{

    public function actionEnviarArte($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        

        $entityManager = $this->getContainer()->get('entityManager');

        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }    

        $acao->set('cNivel', 'Aprovação da Arte');
        $acao->set('cArquivosIds', $data->arquivos_ids);
        $acao->set('cArquivosNames', $data->arquivos_name);        
        //$acao->set('assignedUserId', $data->logged_user);

        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Arte enviada com sucesso',
        ];
    }
    public function actionReprovar($params, $data, $request){
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 
        $user_created = $entityManager->getEntity('User', $data->designed_user_id);
        $userName = $user_created->get('userName');
        
        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }
        $acao->set('cNivel', 'Produção da Arte');
        //$acao->set('assignedUser', $data->designed_user_id);
           

        $postMessage = sprintf(
            '@%s Arte reprovada. Observações: %s',            
            htmlspecialchars($userName),
            $data->observacao
        );

        $note = $entityManager->createEntity('Note');
        $note->set([
            'parentType' => 'Campaign',            // entidade principal
            'parentId' => $data->acao_id,          // id da campanha
            'type' => 'Post',                      // tipo: Post = comentário
            'post' => $postMessage,                   // o conteúdo do comentário
            //TODO: ajustar para enviar a notificação para quem fez a arte
            //'createdById' => $data->logged_user  // autor
        ]);

        $entityManager->saveEntity($note);
        $entityManager->saveEntity($acao);
        
        return [
            'success' => true,
            'mensagem' => 'Arte reprovada com sucesso',
        ];
    }
    

    public function actionAprovar($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionAprovar.');
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   
        
        $precisa_compra = $acao->get('cCTemCompra');

        if($precisa_compra){
            $acao->set('cNivel', 'Em compras');
            //$acao->set('assignedUser', $data->designed_user_id);
        }else{
            $valor_acao = $acao->get('budget');
            $acao->set('cNivel', 'Aguardando Pagamento');
            $acao->set('cCValorFinal', $valor_acao);
            $acao->set('cCValorResidual', 0);
        }
        
        $entityManager->saveEntity($acao);        

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }

        public function actionSemArte($params, $data, $request){
        $log = $GLOBALS['log'] ?? null;
        $log?->info('Init actionSemArte.');
        

        $entityManager = $this->getContainer()->get('entityManager');

        
        $acao = $entityManager->getEntity('Campaign', $data->acao_id); 

        if (!$acao) {
            throw new BadRequest("Ação não encontrada.");
        }   
        
        $precisa_compra = $acao->get('cCTemCompra');

        $acao->set('cCCAprovacaoArteBool', 0);

        if($precisa_compra){
            $acao->set('cNivel', 'Em compras');
            //$acao->set('assignedUser', $data->designed_user_id);
        }else{
            $valor_acao = $acao->get('budget');
            $acao->set('cNivel', 'Aguardando Pagamento');
            $acao->set('cCValorFinal', $valor_acao);
            $acao->set('cCValorResidual', 0);
        }
        
        $entityManager->saveEntity($acao);        

        return [
            'success' => true,
            'mensagem' => 'Ação atualizada com sucesso',
        ];
    }
}