define('custom:views/movimentacao/record/create', [
  'views/record/create'
], function (Dep) {

  return Dep.extend({
    setup() {
      Dep.prototype.setup.call(this);
      console.log("ENTREI CREATE MOVIMENTACAO");

      this.listenToOnce(this.model, 'sync', function () {
        const contaId =
          this.model.get('cCSoftIDContaCorrente') ||
          this.model.get('softContaCorrente');

        if (contaId) {
          // Dispara um evento global do browser
          window.dispatchEvent(new CustomEvent('cc:refreshSaldo', {
            detail: { id: contaId }
          }));
        }
      }, this);
    }
  });
});
