define('custom:views/campaign/modals/retornar-investimento', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        // If true, clicking on the backdrop will close the dialog.
        // Can be 'static', true or false.
        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.retornarInvestimento(),
                }
            ];

            const title = ('Retornar investimentos: ' + this.options.title) || ''; // assuming it's passed from our parent view
            const movimentacoesData = this.options.movimentacoesData;
            const valorResidual = this.options.valorResidual;
            
            let saldoFinalAO = movimentacoesData["Acordo Objetivo"]?.total || 0;
            let saldoFinalAM = movimentacoesData["Acordo de Marketing"]?.total || 0;
            let saldoFinalGerenteMkt = movimentacoesData["Gerente de Marketing"]?.total || 0;
            
            const saldos = {
                'Acordo Objetivo': movimentacoesData['Acordo Objetivo']?.total || 0,
                'Acordo de Marketing': movimentacoesData['Acordo de Marketing']?.total || 0,
                'Gerente de Marketing': movimentacoesData['Gerente de Marketing']?.total || 0
            };
            const options = Object.keys(saldos).filter(label => saldos[label] !== 0);

            this.headerText = title;             

            this.formModel = new Model();

            this.formModel.setDefs({
                fields: {
                    valorResidual: { type: 'currency', readOnly: true },
                    saldoAcordoObjetivo: { type: 'currency', readOnly: true },
                    saldoAcordoMarketing: { type: 'currency', readOnly: true },
                    saldoGerenteMarketing: { type: 'currency', readOnly: true },
                    origemInvestimento: {
                        type: 'enum',
                        //options: ['Acordo Objetivo', 'Acordo de Marketing', 'Gerente de Marketing'],
                        options: options,
                        required: true,
                        labelText: 'Origem do Investimento',
                        view: 'views/fields/enum'
                    }
                }
            });
            
            this.formModel.set({
                valorResidual: valorResidual || 0,
                saldoAcordoObjetivo: saldoFinalAO || 0,
                saldoAcordoMarketing: saldoFinalAM || 0,
                saldoGerenteMarketing: saldoFinalGerenteMkt || 0,
                origemInvestimento: options[0]
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'valorResidual', readOnly: true, label: 'Valor Residual' }],
                            [{ name: 'saldoAcordoObjetivo', readOnly: true, label: 'Investimentos alocados do Acordo Objetivo: ' }],
                            [{ name: 'saldoAcordoMarketing', readOnly: true, label: 'Investimentos alocados do Acordo de Marketing:' }],
                            [{ name: 'saldoGerenteMarketing', readOnly: true, label: 'Investimentos alocados do Gerente de Marketing:' }],
                            [{ name: 'origemInvestimento', label: 'Selecione de qual verba deseja retornar o valor:' }],
                        ],
                    },
                ],
            });

        }

        async retornarInvestimento() {
            console.log("retornarInvestimento.");

            let saldoFinal = 0;        
            const origemInvestimento = this.formModel.attributes.origemInvestimento;    
            const movimentacoesData = this.options.movimentacoesData;
                        

            const resultado = Object.entries(movimentacoesData).find(
                ([key]) => key === origemInvestimento
            );

            saldoFinal = resultado[1].total;

            // Passa os dados atuais para a nova modal
            const data = {
                id: this.options.id,
                valorResidual: this.formModel.attributes.valorResidual,
                saldoDisponivel: saldoFinal,
                origemInvestimento: origemInvestimento,
                contaCorrenteId: resultado[1].id ? resultado[1].id  : null,
            };
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/confirmar-retorno', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
            
        }
    }

});