define('custom:views/campaign/modals/realocar-investimento', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        // If true, clicking on the backdrop will close the dialog.
        // Can be 'static', true or false.
        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.realocarInvestimento(),
                }
            ];

            const title = ('Realocar investimentos: ' + this.options.title) || ''; // assuming it's passed from our parent view
            const contasCorrentes = this.options.contasCorrentes;
            const valorResidual = this.options.valorResidual;
            let saldoFinalAO = 0;
            let saldoFinalAM = 0;
            let saldoFinalGerenteMkt = 0;
            const tiposUsados = [];

            contasCorrentes.forEach(model => {

                const tipo = model.tipoConta;
                const saldo = model.saldo;

                if (!tiposUsados.includes(tipo)) {
                    tiposUsados.push(tipo);
                }
                if (tipo === 'Acordo Objetivo') {
                    saldoFinalAO += saldo;
                } else if (tipo === 'Acordo de Marketing') {
                    saldoFinalAM += saldo;
                } else if (tipo === 'Gerente de Marketing') {
                    saldoFinalGerenteMkt += saldo;
                }
            });

            this.headerText = title;             

            this.formModel = new Model();

            this.formModel.setDefs({
                fields: {
                    valorResidual: { type: 'currency', readOnly: true },
                    saldoAcordoObjetivo: { type: 'currency', readOnly: true },
                    saldoAcordoMarketing: { type: 'currency', readOnly: true },
                    saldoGerenteMarketing: { type: 'currency', readOnly: true },
                    origemInvestimento: {
                        type: 'enum',
                        options: tiposUsados,
                        required: true,
                        labelText: 'Origem do Investimento',
                        view: 'views/fields/enum'
                    }
                }
            });
            
            this.formModel.set({
                valorResidual: valorResidual || 0,
                saldoAcordoObjetivo: saldoFinalAO || 0,
                saldoAcordoMarketing: saldoFinalAM || 0,
                saldoGerenteMarketing: saldoFinalGerenteMkt || 0,
                origemInvestimento: 'Gerente de Marketing'
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'valorResidual', readOnly: true, label: 'Valor Residual' }],
                            [{ name: 'saldoAcordoObjetivo', readOnly: true, label: 'Conta Corrente - Acordo Objetivo: ' }],
                            [{ name: 'saldoAcordoMarketing', readOnly: true, label: 'Conta Corrente - Acordo de Marketing' }],
                            [{ name: 'saldoGerenteMarketing', readOnly: true, label: 'Conta Corrente - Gerente de Marketing' }],
                            [{ name: 'origemInvestimento', label: 'Selecione a origem do investimento:' }],
                        ],
                    },
                ],
            });

        }

        async realocarInvestimento() {
            console.log("Finalizar pagamento.");

            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            let saldoFinal = 0;        
            const origemInvestimento = this.formModel.attributes.origemInvestimento;    
            const contasCorrentes = this.options.contasCorrentes;
            

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }
            
            const contaSelecionada = contasCorrentes.find(c => c.tipoConta === origemInvestimento);


            if(origemInvestimento == 'Acordo Objetivo'){
                saldoFinal = this.formModel.attributes.saldoAcordoObjetivo;

            }else if(origemInvestimento == 'Acordo de Marketing'){
                saldoFinal = this.formModel.attributes.saldoAcordoMarketing;
                
            }else if(origemInvestimento == 'Suporte de Marketing'){
                saldoFinal = this.formModel.attributes.saldoGerenteMarketing;
                
            }else if(origemInvestimento == 'Gerente de Marketing'){
                saldoFinal = this.formModel.attributes.saldoGerenteMarketing;                
            }

            // Passa os dados atuais para a nova modal
            const data = {
                id: this.options.id,
                valorResidual: this.formModel.attributes.valorResidual,
                saldoDisponivel: saldoFinal,
                origemInvestimento: origemInvestimento,
                contaCorrenteId: contaSelecionada ? contaSelecionada.id : null,
            };
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/confirmar-realocacao', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
            
        }
    }

});