define('custom:views/campaign/modals/confirmar-realocacao', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];
            this.headerText = 'Realocar investimento';

            this.formModel = new Model();

            // Define os campos do formulário
            this.formModel.setDefs({
                fields: {
                    saldoDisponivel: { 
                        type: 'currency', 
                        readOnly: true
                    },
                    valorAlocar: { 
                        type: 'currency', 
                        required: true, 
                        currency: 'BRL',
                        labelText: 'Valor para realocar', 
                        min: 0.01,
                        precision: 2,
                        default: null
                    }
                }
            });

            // Inicializa com o valor sugerido (opcional, pode vir da primeira modal)
            this.formModel.set({
                saldoDisponivel: this.options.data.saldoDisponivel
            });

            // Passa os dados da primeira modal para o modelo
            this.formModel.set(this.options.data || {});

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'saldoDisponivel', readOnly: true, label: 'Saldo Disponível' }],
                            [{ name: 'valorAlocar', label: 'Valor para realocar', default: null }],
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {

            let saldoFinalCC = this.formModel.attributes.saldoDisponivel;
            let valorResidual = this.formModel.attributes.valorResidual;

            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            const valorResidualInteiro = Math.abs(valorResidual);

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }else if(isValid.valorAlocar <= 0){
                Espo.Ui.error('O valor para investir precisa ser maior do que zero.');
                return;
            }else if(isValid.valorAlocar > valorResidualInteiro){
                Espo.Ui.error('O valor escolhido para realocar é maior que o necessário. (R$ ' + valorResidualInteiro +')');
                return;
            }
            saldoFinalCC = this.formModel.attributes.saldoDisponivel - this.formModel.attributes.valorAlocar;

            const data = {
                idAcao: this.formModel.attributes.id,
                saldo: this.formModel.attributes.saldoDisponivel,
                origemInvestimento: this.formModel.attributes.origemInvestimento,
                valorInvestir: this.formModel.attributes.valorAlocar,
                saldoFinal: saldoFinalCC,
                contaCorrenteId: this.formModel.attributes.contaCorrenteId,
                valorResidual: this.formModel.attributes.valorResidual
            };
            
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/aviso-realocacao', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
        }
    }
});