define('custom:views/campaign/modals/confirmar-alocacao', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.actionConfirmar(),
                }
            ];
            this.headerText = 'Alocar investimento';

            this.formModel = new Model();

            // Define os campos do formulário
            this.formModel.setDefs({
                fields: {
                    saldoDisponivel: { 
                        type: 'currency', 
                        readOnly: true
                    },
                    valorAlocar: { 
                        type: 'currency', 
                        required: true, 
                        currency: 'BRL',
                        text: 'Valor para investir',  
                        labelText: 'Valor para investir', 
                        min: 0.01,
                        precision: 2
                    }
                }
            });

            // Inicializa com o valor sugerido (opcional, pode vir da primeira modal)
            this.formModel.set({
                saldoDisponivel: this.options.data.saldo
            });

            // Passa os dados da primeira modal para o modelo
            this.formModel.set(this.options.data || {});

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'saldoDisponivel', readOnly: true, label: 'Saldo Disponível' }],
                            [{ name: 'valorAlocar', label: 'Valor para investir' }],
                        ],
                    },
                ],
            });
        }

        async actionConfirmar() {
            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            let saldoFinalCC = this.formModel.attributes.saldo;

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
                
            }else if(isValid.valorAlocar <= 0){
                Espo.Ui.error('O valor para investir precisa ser maior do que zero.');
                return;

            }else if(isValid.valorAlocar > this.formModel.attributes.investimentoNecessario){                
                Espo.Ui.error('O valor para investir precisa ser menor que a Alocação necessária. (R$ ' + this.formModel.attributes.investimentoNecessario +')');
                return;
            }


            saldoFinalCC = this.formModel.attributes.saldo - this.formModel.attributes.valorAlocar;

            const data = {
                idAcao: this.formModel.attributes.id,
                valorCampanha: this.formModel.attributes.valorCampanha,
                investimentoNecessario: this.formModel.attributes.investimentoNecessario,
                saldo: this.formModel.attributes.saldo,
                origemInvestimento: this.formModel.attributes.origemInvestimento,
                valorInvestir: this.formModel.attributes.valorAlocar,
                saldoFinal: saldoFinalCC,
                contaCorrenteId: this.formModel.attributes.contaCorrenteId
            };
            
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/aviso', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
        }
    }
});