define('custom:views/campaign/modals/alocar-investimentos', ['views/modal', 'model'], (ModalView, Model) => {

    return class extends ModalView {

        className = 'dialog dialog-record'

        // language=Handlebars
        templateContent = `
            <div class="record no-side-margin">{{{record}}}</div>
        `

        // If true, clicking on the backdrop will close the dialog.
        // Can be 'static', true or false.
        backdrop = true 

        setup() {
            
            this.buttonList = [
                {
                    name: 'cancelar',
                    label: 'Cancelar',
                    onClick: () => this.close(),
                },
                {
                    name: 'proximo', // handler for 'doSomething' action is bellow
                    text: 'Avançar', // button label 
                    style: 'success',
                    onClick: () => this.avancarAlocacao(),
                }
            ];

            const title = ('Alocar investimentos: ' + this.options.title) || '';
            const saldoAcao = this.options.saldoAcao || 0;
            const valorAlocado = Number(this.model.get('cCValorAlocado')) || 0
            const contasCorrentes = this.options.contasCorrentes;
            let investimentoNecessario = Math.round((saldoAcao - valorAlocado) * 100) / 100;
            let saldoFinalAO = 0;
            let saldoFinalAM = 0;
            let saldoFinalGerenteMkt = 0;
            const campaignId = this.options.model.id;
            const tiposUsados = [];

            contasCorrentes.forEach(model => {

                const tipo = model.tipoConta;
                const saldo = model.saldo;

                if (!tiposUsados.includes(tipo)) {
                    tiposUsados.push(tipo);
                }
                if (tipo === 'Acordo Objetivo') {
                    saldoFinalAO += saldo;
                } else if (tipo === 'Acordo de Marketing') {
                    saldoFinalAM += saldo;
                } else if (tipo === 'Gerente de Marketing') {
                    saldoFinalGerenteMkt += saldo;
                }
            });

            this.headerText = title;             

            this.formModel = new Model();

            this.formModel.setDefs({
                fields: {
                    valorCampanha: { type: 'currency', readOnly: true, labelText: 'Valor Campanha' },
                    investimentoNecessario: { type: 'currency', readOnly: true, labelText: 'Investimento Necessário' },
                    saldoAcordoObjetivo: { type: 'currency', readOnly: true, labelText: 'Saldo Acordo Objetivo' },
                    saldoAcordoMarketing: { type: 'currency', readOnly: true, labelText: 'Saldo Acordo Marketing' },
                    saldoGerenteMarketing: { type: 'currency', readOnly: true, labelText: 'Saldo Gerente Marketing' },
                    origemInvestimento: {
                        type: 'enum',
                        //options: ['Acordo Objetivo', 'Acordo de Marketing','Gerente de Marketing'],
                        options: tiposUsados,
                        required: true,
                        labelText: 'Origem do Investimento',
                        view: 'views/fields/enum'
                    }
                }
            });
            
            this.formModel.set({
                valorCampanha: saldoAcao || 0,
                investimentoNecessario: investimentoNecessario,
                saldoAcordoObjetivo: saldoFinalAO || 0,
                saldoAcordoMarketing: saldoFinalAM || 0,
                saldoGerenteMarketing: saldoFinalGerenteMkt || 0,
                origemInvestimento: 'Gerente de Marketing'
            });

            this.createView('record', 'views/record/edit-for-modal', {
                model: this.formModel,
                selector: '.record',                
                detailLayout: [
                    {
                        rows: [
                            [{ name: 'valorCampanha', readOnly: true, label: 'Valor da campanha' }],
                            [{ name: 'investimentoNecessario', readOnly: true, label: 'Investimento necessário' }],
                            [{ name: 'saldoAcordoObjetivo', readOnly: true, label: 'Conta Corrente - Acordo Objetivo: ' }],
                            [{ name: 'saldoAcordoMarketing', readOnly: true, label: 'Conta Corrente - Acordo de Marketing' }],
                            [{ name: 'saldoGerenteMarketing', readOnly: true, label: 'Conta Corrente - Gerente de Marketing' }],
                            [{ name: 'origemInvestimento', label: 'Selecione a origem do investimento:' }],
                        ],
                    },
                ],
            });

        }

        async avancarAlocacao() {
            const recordView = this.getView('record');
            const isValid = recordView.processFetch();
            let saldoFinal = 0;        
            const origemInvestimento = this.formModel.attributes.origemInvestimento;    
            const contasCorrentes = this.options.contasCorrentes;
            

            if (!isValid) { 
                Espo.Ui.error('Verifique os campos.');
                return;
            }
            
            const contaSelecionada = contasCorrentes.find(c => c.tipoConta === origemInvestimento);


            if(origemInvestimento == 'Acordo Objetivo'){
                saldoFinal = this.formModel.attributes.saldoAcordoObjetivo;

            }else if(origemInvestimento == 'Acordo de Marketing'){
                saldoFinal = this.formModel.attributes.saldoAcordoMarketing;
                
            }else if(origemInvestimento == 'Suporte de Marketing'){
                saldoFinal = this.formModel.attributes.saldoGerenteMarketing;
                
            }else if(origemInvestimento == 'Gerente de Marketing'){
                saldoFinal = this.formModel.attributes.saldoGerenteMarketing;                
            }

            // Passa os dados atuais para a nova modal
            const data = {
                id: this.options.id,
                valorCampanha: this.formModel.attributes.valorCampanha,
                investimentoNecessario: this.formModel.attributes.investimentoNecessario,
                saldo: saldoFinal,
                origemInvestimento: origemInvestimento,
                contaCorrenteId: contaSelecionada ? contaSelecionada.id : null,
            };
            // Cria a nova modal para confirmar a alocação
            this.createView('dialog', 'custom:views/campaign/modals/confirmar-alocacao', {
                data: data
            }, view => {
                view.render();
                this.listenToOnce(view, 'done', response => {
                    
                    this.trigger('done', response); // Propaga o evento para a view pai
                    this.close();
                });
            });
        }
    }

});